/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.nominaltransactionbase;

import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.cashtransaction.CashTransaction;
import com.varial.accounting.domain.chequedeposit.ChequeDepositTransaction;
import com.varial.accounting.domain.currencyrevaluation.CurrencyRevaluationExceptionMapper;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.documenttype.DocumentCategoryType;
import com.varial.accounting.domain.documenttype.DocumentType;
import com.varial.accounting.domain.financesetup.BaseDateForConsiderationType;
import com.varial.accounting.domain.financesetup.ConversionTableType;
import com.varial.accounting.domain.financesetup.CurrencyType;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financesetup.IFinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialPeriod;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.invoiceallocation.PersonalAccountAdjustmentTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceReceivableTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceTransaction;
import com.varial.accounting.domain.nlaccountopenitem.NLAccountOpenItem;
import com.varial.accounting.domain.nlaccountopenitem.NLAccountOpenItemPersistencyManager;
import com.varial.accounting.domain.nlaccountopenitemallocation.NLAccountOpenItemAllocation;
import com.varial.accounting.domain.nominalledger.NominalLedgerTaxAccounts;
import com.varial.accounting.domain.nominaltransactionbase.BankAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.BankStatementPostingTransactionPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.BaseDifferenceEntry;
import com.varial.accounting.domain.nominaltransactionbase.DownPaymentHelper;
import com.varial.accounting.domain.nominaltransactionbase.EntryComparator;
import com.varial.accounting.domain.nominaltransactionbase.FixedAssetManager;
import com.varial.accounting.domain.nominaltransactionbase.ForeignCurrencyRate;
import com.varial.accounting.domain.nominaltransactionbase.INominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.JournalTransactionGroupEnum;
import com.varial.accounting.domain.nominaltransactionbase.NLAccountSplit;
import com.varial.accounting.domain.nominaltransactionbase.NLAccountSplitHeader;
import com.varial.accounting.domain.nominaltransactionbase.NLTransactionCorrectionToTransactionPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntryPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBaseData;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBasePersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.PrepaidTax;
import com.varial.accounting.domain.nominaltransactionbase.ProcessingStatus;
import com.varial.accounting.domain.nominaltransactionbase.RecurringNominalTransactionBasePersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.TransactionConversionManager;
import com.varial.accounting.domain.nominaltransactionbase.TransactionExceptionMapper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionManager;
import com.varial.accounting.domain.nominaltransactionbase.TransactionTranslatableResource;
import com.varial.accounting.domain.nominaltransactionbase.TransactionType;
import com.varial.accounting.domain.nominaltransactionbase.TransactionUseTypeEnum;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContext;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.CurrencyToleranceChecker;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.DefaultExchangeRateDateResolver;
import com.varial.accounting.domain.nominaltransactionbase.tax.processing.TaxEntryProcessor;
import com.varial.accounting.domain.nominaltransactionbase.tax.validation.fixedtaxcode.FixedTaxCodeValidator;
import com.varial.accounting.domain.nominaltransactionbase.tax.validation.fixedtaxcode.IFixedTaxCodeValidator;
import com.varial.accounting.domain.nominaltransactionbase.tax.validation.posting.TaxConfigurationValidator;
import com.varial.accounting.domain.nominaltransactionbase.tax.validation.taxbase.ITaxBaseValidator;
import com.varial.accounting.domain.nominaltransactionbase.tax.validation.taxbase.TaxBaseValidator;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemPersistencyManager;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountPlafond;
import com.varial.accounting.domain.sequenceno.SequenceNo;
import com.varial.accounting.domain.sequenceno.SequenceNoAssignmentTimePointType;
import com.varial.accounting.domain.sequenceno.SequenceNoMapping;
import com.varial.accounting.domain.sequenceno.SequenceNoMappingManager;
import com.varial.accounting.domain.taxcode.TaxCode;
import com.varial.accounting.domain.taxcode.TaxCodeManager;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.costing.base.domain.costingcompany.CostingCompany;
import com.varial.costing.base.domain.costingcompany.CostingCompanyPersistencyManager;
import com.varial.framework.domain.company.Jurisdiction;
import com.varial.framework.domain.company.JurisdictionFactory;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.currency.ConversionRateUtils;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.transfer.TransferConfigPersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NominalTransactionBase
extends PersistentObject
implements INominalTransactionBase {
    private boolean isFromUpdateScript = false;
    private boolean isFromUpdateBalanceScript = false;
    private boolean addToAccountBalance = true;
    private static Logger LOGGER = LoggerFactory.getLogger((String)NominalTransactionBase.class.getName());
    public static final int PRIORITY = 4;
    private final IFixedTaxCodeValidator fixedTaxCodeValidator = new FixedTaxCodeValidator();
    private final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private Batch mBatch;
    protected String mCreatorID;
    private Date mCreationDate;
    private Date mTransactionDate;
    private FinancialYear mFinancialYear;
    private Date mDocumentDate;
    private String mReferenceNumber;
    private String mSequenceNumber;
    private String mProcessId;
    private String mNote;
    private boolean mIsUnfinished;
    private boolean mIsJournalized;
    private Date mValueDate;
    private ForeignCurrencyRate mForeignCurrencyRate;
    private boolean mIsPayment;
    private BigDecimal mTotal;
    private BigDecimal mBaseTotal;
    private TaxCode[] mFixedTaxCodes;
    private Date mTaxDate;
    private boolean mIsInputTax;
    private boolean mMultipleTaxCodes;
    private TaxRate mFixedTaxRate;
    private boolean mIsCancellation;
    protected BaseDifferenceEntry mBaseDifferenceEntry;
    private String mOidJournal;
    private String mJournalNumber;
    private Date mDateOfReceipt;
    private DocumentType mDocumentType;
    private SequenceNo mTaxRegister;
    private String mTaxRegisterNumber;
    private String mOidTaxRegisterJournal;
    private DocumentCategoryType mDocumentCategory;
    private String mImportApplication;
    protected ConversionRate mConversionRate;
    private ICurrency mEnteredCurrency;
    private boolean mCostingAlreadyPosted;
    private boolean mIsCorrection;
    private NominalTransactionBase mCorrectionToDocument;
    private ConversionRate mSeccurr1ConversionRate;
    private ConversionRate mSeccurr2ConversionRate;
    private ConversionRate mSeccurr3ConversionRate;
    private ConversionRate mSeccurr4ConversionRate;
    private TransactionUseTypeEnum mTransactionUseType;
    private boolean mIsConsolidationTransaction;
    private boolean mIsJournalized_old;
    private Date mTransactionDate_old;
    private FinancialYear mFinancialYear_old;
    private String mSequenceNumber_old;
    private String mProcessId_old;
    private Date mDocumentDate_old;
    private String mReferenceNumber_old;
    private boolean mIsUnfinished_old;
    private Date mTaxDate_old;
    private SequenceNo mSequenceNo_old;
    private DocumentType mDocumentType_old;
    private DocumentCategoryType mDocumentCategory_old;
    private DocumentCategoryType mDocumentCategory_new;
    protected boolean mBaseTotalHasBeenEntered = false;
    private CancellationContext mCancellationContext;
    private Jurisdiction mJurisdiction;
    private TransactionManager mTransactionManager;
    private FinanceSetup mFinanceSetup;
    protected boolean mDeletedFromBalance = false;
    protected boolean mLoadedEntries;
    private boolean mCheckConversionRate = true;
    private TaxCodeManager mTaxCodeManager;
    private SequenceNoMappingManager mSequenceNoMappingManager;
    private boolean mIsCorrection_old;
    private boolean createdECSalesListCalculated = false;
    private boolean createdECSalesList;
    private boolean createdTaxReturnReportCalculated = false;
    private boolean createdTaxReturnReport;
    private boolean vatReturnClosedCalculated = false;
    private boolean vatReturnClosed;
    private boolean createdChamberContributionCalculated = false;
    private boolean createdChamberContribution;
    private boolean hasAllocatedItemCalculated = false;
    private boolean hasAllocatedItem;
    private boolean hasAllocatedDownPaymentItemCalculated = false;
    private boolean hasAllocatedDownPaymentItem;
    private boolean hasItemIncludedInPaymentSessionCalculated = false;
    private boolean hasItemIncludedInPaymentSession;
    private boolean hasItemIncludedInInstalmentCalculated = false;
    private boolean hasItemIncludedInInstalment;
    private boolean hasReconciledItemCalculated = false;
    private boolean hasReconciledItem;
    private boolean hasAllocatedNLAccountItemCalculated = false;
    private boolean hasAllocatedNLAccountItem;
    private boolean hasOpenItemPaidBySplitPaymentCalculated = false;
    private boolean hasOpenItemPaidBySplitPayment;
    private Map<String, TaxCode> mTaxCodeMap;
    private AccountingCompany mAccountingCompany;
    private boolean mFromRecurring = false;
    private boolean mIsFromAssetAccounting = false;
    private boolean mCheckAutomaticSequenceNo = true;
    private boolean mCheckUseTaxNetAmount = true;
    private boolean mHadSeveralFixedTaxCodes;
    protected boolean mReworkExecuted = false;
    private boolean mPostingDirectlyToAssetAccountAllowed = true;
    public boolean mCheckValidTaxRate = true;
    protected boolean mNoConversionToBaseCurrencyForTransfer = false;
    private int mTransactionPersistencyType;
    public static final int TRANSACTIONPERSISTENCYTYPE_REGULAR = 0;
    public static final int TRANSACTIONPERSISTENCYTYPE_RECURRING = 1;
    public static final int TRANSACTIONPERSISTENCYTYPE_BANKSTATEMENTPOSTING = 2;
    private Map<String, CustSupAddress> mOneOffAddressMap;
    protected Map<ICurrency, ConversionRate> mSeccurrConversionRateMap = null;
    protected ConversionRate mTaxOfficeRate;
    private boolean mJournaliseAdjustments = false;
    private boolean mShouldCancelInvoiceAllocation = false;
    private boolean mFromGenerateDownPayment = false;
    private boolean mIsNLAccountResidueAdjustmentWithBaseTotal = false;
    private boolean mIsAutomaticProcessing = false;
    private ProcessingStatus mProcessingStatus;
    private FixedAssetManager mFixedAssetManager;
    private boolean mFixedAssetManagerCreated = false;
    private OpenItem mOriginalOpenItem;
    private boolean mIsSupplierDiscountAdjustment = false;
    private CostingCompany mCostingCompany = null;
    private boolean mIsCreatedByTransfer = false;
    private boolean mNoCheckVAT = false;

    protected NominalTransactionBase(Batch batch, int transactionPersistencyType) throws BusinessDomainException {
        super(4);
        this.mTransactionPersistencyType = transactionPersistencyType;
        this.setBatch(batch);
        this.mIsJournalized = false;
        this.mIsCancellation = false;
        this.mLoadedEntries = true;
        this.mCostingAlreadyPosted = false;
        this.mIsCorrection = false;
        this.mCreatorID = SessionContext.getInstance().getSession().getUserCode();
        this.mCreationDate = new Date();
        this.mTransactionUseType = TransactionUseTypeEnum.TUTE_NONE;
        this.mIsConsolidationTransaction = false;
    }

    protected NominalTransactionBase(AccountingCompany company, int transactionPersistencyType) {
        super(4);
        this.mTransactionPersistencyType = transactionPersistencyType;
        this.setCompany(company);
        this.mIsJournalized = false;
        this.mIsCancellation = false;
        this.mDeletedFromBalance = true;
        this.mLoadedEntries = true;
        this.mCostingAlreadyPosted = false;
        this.mIsCorrection = false;
        this.mCreatorID = SessionContext.getInstance().getSession().getUserCode();
        this.mCreationDate = new Date();
        this.mTransactionUseType = TransactionUseTypeEnum.TUTE_NONE;
        this.mIsConsolidationTransaction = false;
    }

    protected NominalTransactionBase(boolean readOnly, int transactionPersistencyType) {
        super(4, readOnly);
        this.mTransactionPersistencyType = transactionPersistencyType;
        this.mLoadedEntries = false;
    }

    protected NominalTransactionBase(String objectid, int transactionPersistencyType) {
        super(4, objectid);
        this.mTransactionPersistencyType = transactionPersistencyType;
        this.mLoadedEntries = false;
    }

    public static NominalTransactionBase getNominalTransactionBase(String objectid, int transactionPersistencyType) {
        switch (transactionPersistencyType) {
            case 1: {
                return RecurringNominalTransactionBasePersistencyManager.getTransaction((String)objectid);
            }
            case 2: {
                return BankStatementPostingTransactionPersistencyManager.getTransaction((String)objectid);
            }
            case 0: {
                NominalTransactionBase t = NominalTransactionBasePersistencyManager.getTransaction((String)objectid);
                if (t == null) {
                    throw ExceptionMapper.makeDataNotFoundPersistencyException((String)objectid);
                }
                return t;
            }
        }
        throw ExceptionMapper.makeApplicationException((String)"Unknown persistency type");
    }

    public NominalTransactionBase(String objectid, int version, int transactionPersistencyType) {
        super(4, objectid, version, true);
        this.mTransactionPersistencyType = transactionPersistencyType;
        this.requireLoaded();
        this.mLoadedEntries = false;
    }

    public NominalTransactionBase(String objectid, int version, Batch batch, int transactionPersistencyType) {
        super(4, objectid, version, true);
        this.mTransactionPersistencyType = transactionPersistencyType;
        this.requireLoaded();
        if (!PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.mBatch, (IPersistentObject)batch)) {
            throw ExceptionMapper.makeApplicationException((String)"NominalTransactionBase: transaction is not in the batch");
        }
        this.mBatch = batch;
        this.mLoadedEntries = false;
    }

    public NominalTransactionBase(NominalTransactionBase toCancel, CancellationContext context) throws BusinessDomainException {
        super(4, toCancel.getSubPriority() - 1);
        InvoiceReceivableTransaction invoiceToCancel;
        Date taxDate;
        String referenceNumber;
        this.mTransactionPersistencyType = toCancel.getTransactionPersistencyType();
        if (context == null || context.getFinancialYear() == null || context.getTransactionDate() == null) {
            throw TransactionExceptionMapper.makeCancellationTransactionDateMissingDomainException();
        }
        this.mBatch = context.getBatch();
        if (this.mBatch == null) {
            this.mBatch = toCancel.getBatch();
        }
        this.mLoadedEntries = true;
        this.mCreatorID = SessionContext.getInstance().getSession().getUserCode();
        this.mCreationDate = new Date();
        this.mTransactionUseType = toCancel.getUseType();
        if (context.isCancellation()) {
            this.setIsCancellation(true);
        }
        this.setIsJournalized(false);
        this.setIsUnfinished(false);
        FinancialYear financialYear = context.getFinancialYear();
        this.setFinancialYear(financialYear);
        Date transactionDate = context.getTransactionDate();
        this.setTransactionDate(transactionDate);
        if (TransactionHelper.transactionDateBefore((Date)transactionDate, (FinancialYear)financialYear, (Date)toCancel.getTransactionDate(), (FinancialYear)toCancel.getFinancialYear())) {
            throw TransactionExceptionMapper.makeCancellationDateBeforeOriginalDateDomainException();
        }
        if (!this.isPersonalAccountAdjustmentTransaction()) {
            this.checkTransactionDate();
        }
        if (StringMapper.isNullString((String)(referenceNumber = context.getReferenceNumber()))) {
            referenceNumber = toCancel.getReferenceNumber();
        }
        this.setReferenceNumber(referenceNumber);
        Date documentDate = context.getDocumentDate();
        if (documentDate == null) {
            documentDate = toCancel.getDocumentDate();
        }
        this.setDocumentDate(documentDate);
        String note = context.getNote();
        if (StringMapper.isNullString((String)note)) {
            note = context.isCancellation() ? TransactionTranslatableResource.NOTE_FOR_CANCEL_TRANSACTION.getValue((ILanguage)this.getReportLanguage()) : toCancel.getNote();
        }
        this.setNote(note);
        if (context.getTaxDate() != null) {
            if (toCancel.getTaxDate() != null && DateHelper.before((Date)context.getTaxDate(), (Date)toCancel.getTaxDate())) {
                if (this.isPersonalAccountAdjustmentTransaction()) {
                    throw TransactionExceptionMapper.makeCancellationTaxDateBeforeOriginalTaxDateInAdjustmentTransactionDomainException((String)DateMapper.toString((Date)toCancel.getTaxDate()));
                }
                throw TransactionExceptionMapper.makeCancellationTaxDateBeforeOriginalTaxDateDomainException((String)DateMapper.toString((Date)toCancel.getTaxDate()));
            }
            taxDate = context.getTaxDate();
        } else {
            taxDate = toCancel.getTaxDate();
        }
        this.setTaxDate(taxDate);
        this.setImportApplication(toCancel.isPersonalAccountAdjustmentTransaction() ? null : context.getImportApplication());
        this.setDocumentType(toCancel.getDocumentType());
        this.setTaxRegister(toCancel.getTaxRegister());
        boolean getNextSequenceNo = true;
        if (TransferConfigPersistencyManager.getTransferConfig().getUseSequenceNumberOfImportForReverseTransaction() && !StringMapper.isNullString((String)context.getSequenceNumber())) {
            this.setSequenceNumber(context.getSequenceNumber());
            getNextSequenceNo = false;
        }
        if (getNextSequenceNo && toCancel.isInvoiceReceivableTransaction() && (invoiceToCancel = (InvoiceReceivableTransaction)toCancel).isTransitoryTransaction()) {
            getNextSequenceNo = false;
        }
        if (ISoftware.isFalke()) {
            getNextSequenceNo = false;
            if (!StringMapper.isNullString((String)context.getSequenceNumber())) {
                this.setSequenceNumber(context.getSequenceNumber());
            } else {
                this.setSequenceNumber(toCancel.getSequenceNumber());
            }
        } else if (context.mustUseOriginalSequenceNumber()) {
            getNextSequenceNo = false;
            this.setSequenceNumber(toCancel.getSequenceNumber());
        }
        if (getNextSequenceNo) {
            SequenceNo sequenceNo = null;
            sequenceNo = this.getDocumentType() != null ? this.getSequenceNoMappingManager().getSequenceNo(this.getDocumentType()) : this.getSequenceNoMappingManager().getSequenceNo(toCancel.getDocumentCategory());
            String sequenceNumber = "";
            if (sequenceNo != null) {
                if (sequenceNo.automaticAssignment()) {
                    getNextSequenceNo = false;
                }
                sequenceNumber = this.getSequenceNoMappingManager().getNextSequenceNumber(sequenceNo, this.getFinancialYear(), this.getTransactionDate(), true, false);
            } else {
                sequenceNumber = context.getSequenceNumber();
            }
            this.setSequenceNumber(sequenceNumber);
        }
        if (getNextSequenceNo && StringMapper.isNullString((String)this.getSequenceNumber()) && toCancel.getFinanceSetup().getMandatorySequenceNumber()) {
            throw TransactionExceptionMapper.makeSequenceNumberForCancellationTransactionMissingDomainException();
        }
        this.setProcessId(toCancel.getProcessId());
        this.setFixedTaxCode(toCancel.getFixedTaxCodes());
        this.setIsPayment(toCancel.getIsPayment());
        this.setIsInputTax(toCancel.getIsInputTax());
        this.copyForeignCurrencyRateWithoutCheckFrom(toCancel);
        this.setValueDate(toCancel.getValueDate());
        if (context.isCancellation()) {
            this.setTotal(BigDecimalMapper.negate((BigDecimal)toCancel.getTotal()));
            this.setBaseTotal(BigDecimalMapper.negate((BigDecimal)toCancel.getBaseTotal()), false);
        } else {
            this.setTotal(toCancel.getTotal());
            this.setBaseTotal(toCancel.getBaseTotal(), false);
        }
        this.setDateOfReceipt(toCancel.getDateOfReceipt());
        this.setMultipleTaxCodes(toCancel.getMultipleTaxCodes());
        this.setFixedTaxRate(toCancel.getFixedTaxRate());
        this.setDocumentCategory(toCancel.getDocumentCategory());
        this.setCostingAlreadyPosted(toCancel.getCostingAlreadyPosted());
        this.setSeccurr1ConversionRate(toCancel.getSeccurr1ConversionRate());
        this.setSeccurr2ConversionRate(toCancel.getSeccurr2ConversionRate());
        this.setSeccurr3ConversionRate(toCancel.getSeccurr3ConversionRate());
        this.setSeccurr4ConversionRate(toCancel.getSeccurr4ConversionRate());
        this.setTaxOfficeRate(toCancel.getTaxOfficeRate());
        if (toCancel.getBaseDifferenceEntry() != null) {
            this.setBaseDifferenceEntry(new BaseDifferenceEntry(toCancel.getBaseDifferenceEntry(), this, context));
        }
    }

    protected void load() {
        switch (this.getTransactionPersistencyType()) {
            case 1: {
                RecurringNominalTransactionBasePersistencyManager.load((NominalTransactionBase)this);
                break;
            }
            case 2: {
                BankStatementPostingTransactionPersistencyManager.load((NominalTransactionBase)this);
                break;
            }
            case 0: {
                NominalTransactionBasePersistencyManager.load((NominalTransactionBase)this);
                break;
            }
            default: {
                throw ExceptionMapper.makeApplicationException((String)"Unknown persistency type");
            }
        }
    }

    protected void deleteImpl() {
        switch (this.getTransactionPersistencyType()) {
            case 1: {
                RecurringNominalTransactionBasePersistencyManager.delete((NominalTransactionBase)this);
                break;
            }
            case 2: {
                BankStatementPostingTransactionPersistencyManager.delete((NominalTransactionBase)this);
                break;
            }
            case 0: {
                NominalTransactionBasePersistencyManager.delete((NominalTransactionBase)this);
                break;
            }
            default: {
                throw ExceptionMapper.makeApplicationException((String)"Unknown persistency type");
            }
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getCompany().getDomainKey() + "/" + this.getFinancialYear().getCode() + "/" + DateMapper.toString((Date)this.getDocumentDate()) + "/" + this.getReferenceNumber() + "/" + this.getSequenceNumber();
    }

    protected void saveImpl() {
        switch (this.getTransactionPersistencyType()) {
            case 1: {
                RecurringNominalTransactionBasePersistencyManager.save((NominalTransactionBase)this);
                break;
            }
            case 2: {
                BankStatementPostingTransactionPersistencyManager.save((NominalTransactionBase)this);
                break;
            }
            case 0: {
                NominalTransactionBasePersistencyManager.save((NominalTransactionBase)this);
                if (!this.changedTransactionDate() && !this.changedIsJournalized() && !this.changedFinancialYear() && !this.changedSequenceNumber() && !this.changedProcessId() && !this.changedReferenceNumber() && !this.changedDocumentDate() && !this.changedIsUnfinished() && !this.changedTaxDate() && !this.changedDocumentType() && !this.changedDocumentCategory() && !this.changedIsPostedInvoice()) break;
                this.registerForLastExecute();
                break;
            }
            default: {
                throw ExceptionMapper.makeApplicationException((String)"Unknown persistency type");
            }
        }
    }

    protected void firstExecuteImpl() throws BusinessDomainException {
        if (!(this.isNew() || StringMapper.isNullString((String)this.mSequenceNumber_old) || StringMapper.equalWithTrim((String)this.mSequenceNumber, (String)this.mSequenceNumber_old))) {
            this.getSequenceNoMappingManager().giveBackSequenceNumber(this.mFinancialYear_old, this.mSequenceNo_old, this.mSequenceNumber_old, this.mTransactionDate_old);
        }
    }

    protected void lastExecuteImpl() throws BusinessDomainException {
        if (this.changedTransactionDate()) {
            NominalLedgerEntryPersistencyManager.updateTransactionDate((NominalTransactionBase)this);
            OpenItemPersistencyManager.updateTransactionDate((NominalTransactionBase)this);
            NLAccountOpenItemPersistencyManager.updateTransactionDate((NominalTransactionBase)this);
        }
        if (this.changedIsJournalized()) {
            NominalLedgerEntryPersistencyManager.updateIsJournalized((NominalTransactionBase)this);
        }
        if (this.changedIsPostedInvoice()) {
            NominalLedgerEntryPersistencyManager.updateIsPostedInvoice((NominalTransactionBase)this);
        }
        if (this.changedFinancialYear()) {
            NominalLedgerEntryPersistencyManager.updateFinancialYear((NominalTransactionBase)this);
            OpenItemPersistencyManager.updateFinancialYear((NominalTransactionBase)this);
            NLAccountOpenItemPersistencyManager.updateFinancialYear((NominalTransactionBase)this);
        }
        if (this.changedIsUnfinished()) {
            NominalLedgerEntryPersistencyManager.updateIsUnfinished((NominalTransactionBase)this);
            OpenItemPersistencyManager.updateIsUnfinished((NominalTransactionBase)this);
        }
        if (this.changedSequenceNumber()) {
            OpenItemPersistencyManager.updateSequenceNumber((NominalTransactionBase)this);
            NLAccountOpenItemPersistencyManager.updateSequenceNumber((NominalTransactionBase)this);
        }
        if (this.changedDocumentType()) {
            OpenItemPersistencyManager.updateDocumentType((NominalTransactionBase)this);
            NLAccountOpenItemPersistencyManager.updateDocumentType((NominalTransactionBase)this);
        }
        if (this.changedReferenceNumber() && !this.isChequeDepositTransaction()) {
            OpenItemPersistencyManager.updateReferenceNumber((NominalTransactionBase)this);
            NLAccountOpenItemPersistencyManager.updateReferenceNumber((NominalTransactionBase)this);
            NominalLedgerEntryPersistencyManager.updateReferenceNumber((NominalTransactionBase)this);
        }
        if (this.changedDocumentDate()) {
            OpenItemPersistencyManager.updateDocumentDate((NominalTransactionBase)this);
            NLAccountOpenItemPersistencyManager.updateDocumentDate((NominalTransactionBase)this);
        }
        if (this.changedTaxDate()) {
            NominalLedgerEntryPersistencyManager.updateTaxDate((NominalTransactionBase)this);
        }
        if (this.changedDocumentCategory()) {
            NLAccountOpenItemPersistencyManager.updateDocumentCategory((NominalTransactionBase)this);
        }
        if (this.changedProcessId() && !this.isChequeDepositTransaction() && !this.isCashTransaction()) {
            NominalLedgerEntryPersistencyManager.updateProcessId((NominalTransactionBase)this);
            OpenItemPersistencyManager.updateProcessId((NominalTransactionBase)this);
            NLAccountOpenItemPersistencyManager.updateProcessId((NominalTransactionBase)this);
        }
    }

    protected void setData(NominalTransactionBaseData data) {
        this.mBatch = data.mBatch;
        this.mTransactionDate = data.mTransactionDate;
        this.mFinancialYear = data.mFinancialYear;
        this.mDocumentDate = data.mDocumentDate;
        this.mValueDate = data.mValueDate;
        this.mReferenceNumber = data.mReferenceNumber;
        this.mSequenceNumber = data.mSequenceNumber;
        this.mNote = data.mNote;
        this.mIsUnfinished = data.mIsUnfinished;
        this.mIsJournalized = data.mIsJournalized;
        this.mIsCancellation = data.mIsCancellation;
        this.mForeignCurrencyRate = data.mForeignCurrencyRate;
        this.mProcessId = data.mProcessId;
        this.mTotal = data.mTotal;
        this.mIsPayment = data.mIsPayment;
        this.mFixedTaxCodes = data.mFixedTaxCodes;
        this.mDateOfReceipt = data.mDateOfReceipt;
        this.mTaxDate = data.mTaxDate;
        this.mDocumentType = data.mDocumentType;
        this.mIsInputTax = data.mIsInputTax;
        this.mTaxRegister = data.mTaxRegister;
        this.mJournalNumber = data.mJournalNumber;
        this.mOidJournal = data.mOidJournal;
        this.mTaxRegisterNumber = data.mTaxRegisterNumber;
        this.mOidTaxRegisterJournal = data.mOidTaxRegisterJournal;
        this.mDocumentCategory = data.mDocumentCategory;
        this.mImportApplication = data.mImportApplication;
        this.mEnteredCurrency = data.mEnteredCurrency;
        this.mConversionRate = data.mConversionRate;
        this.mMultipleTaxCodes = data.mMultipleTaxCodes;
        this.mFixedTaxRate = data.mFixedTaxRate;
        this.mCostingAlreadyPosted = data.mCostingAlreadyPosted;
        this.mIsCorrection = data.mIsCorrection;
        this.mSeccurr1ConversionRate = data.mSeccurr1ConversionRate;
        this.mSeccurr2ConversionRate = data.mSeccurr2ConversionRate;
        this.mSeccurr3ConversionRate = data.mSeccurr3ConversionRate;
        this.mSeccurr4ConversionRate = data.mSeccurr4ConversionRate;
        this.mBaseTotal = data.mBaseTotal;
        this.mTransactionUseType = data.mTransactionUseType;
        this.mCreatorID = data.mCreatorID;
        this.mCreationDate = data.mCreationDate;
        this.mIsCreatedByTransfer = data.mIsCreatedByTransfer;
        this.mTransactionDate_old = this.mTransactionDate;
        this.mIsJournalized_old = this.mIsJournalized;
        this.mFinancialYear_old = this.mFinancialYear;
        this.mSequenceNumber_old = this.mSequenceNumber;
        this.mProcessId_old = this.mProcessId;
        this.mReferenceNumber_old = this.mReferenceNumber;
        this.mDocumentDate_old = this.mDocumentDate;
        this.mIsUnfinished_old = this.mIsUnfinished;
        this.mTaxDate_old = this.mTaxDate;
        this.mDocumentType_old = this.mDocumentType;
        this.mDocumentCategory_old = this.mDocumentCategory;
        this.mHadSeveralFixedTaxCodes = this.mFixedTaxCodes != null && this.mFixedTaxCodes.length > 1;
        this.mIsCorrection_old = data.mIsCorrection;
        this.mTaxOfficeRate = data.mTaxOfficeRate;
        this.mIsConsolidationTransaction = data.mIsConsolidationTransaction;
    }

    protected void destroyImpl() throws BusinessDomainException {
        int i;
        NominalLedgerEntry[] entries;
        if (!this.getIsRecurring() && !this.getIsBankStatementPosting()) {
            this.checkForDestroy();
            if (!this.getIsUnfinished()) {
                this.removeFromAccountBalance();
            }
            if (this.isCancellation()) {
                this.deleteCancellationTransaction();
                entries = this.getAllEnteredEntries();
                for (i = 0; i < entries.length; ++i) {
                    if (entries[i].getNLAccountOpenItem() == null) continue;
                    NLAccountOpenItemAllocation cancellationAllocation = entries[i].getNLAccountOpenItem().getAllocationAmounts()[0].getNLAccountOpenItemAllocation();
                    cancellationAllocation.makeSaveable();
                    cancellationAllocation.destroy();
                    entries[i].getNLAccountOpenItem().setIsAllocated(false);
                }
            }
            if (!StringMapper.isNullString((String)this.mSequenceNumber)) {
                this.saveOldSeqNoMapping();
                this.getSequenceNoMappingManager().giveBackSequenceNumber(this.getFinancialYear(), this.mSequenceNo_old, this.getSequenceNumber(), this.getTransactionDate());
            }
        }
        entries = this.getAllEnteredEntries();
        for (i = 0; i < entries.length; ++i) {
            entries[i].makeSaveable();
            entries[i].destroy();
        }
        if (this.getBaseDifferenceEntry() != null) {
            this.getBaseDifferenceEntry().makeSaveable();
            this.getBaseDifferenceEntry().destroy();
        }
    }

    protected void checkForDestroy() throws BusinessDomainException {
        if (this.getIsConsolidationTransaction()) {
            return;
        }
        if (!this.isPurchaseRegisterInvoice() && !this.mIsUnfinished) {
            if (this.getIsJournalized()) {
                throw TransactionExceptionMapper.makeChangeNotAllowedBecauseJournalizationDomainException();
            }
            this.checkTransactionDateBlocked(this.getTransactionDate());
            if (this.isPeriodClosed()) {
                throw TransactionExceptionMapper.makeTransactionDateNotAllowedAsPeriodClosedDomainException();
            }
            String sessionOID = NominalTransactionBasePersistencyManager.getTransferSessionOID((NominalTransactionBase)this);
            if (!StringMapper.isNullString((String)sessionOID)) {
                throw TransactionExceptionMapper.makeTransactionIsReferencedByTransferDomainException((String)sessionOID, (String)this.getReferenceNumber());
            }
        }
    }

    public SequenceNo getSequenceNo() {
        SequenceNo result = null;
        SequenceNoMappingManager manager = this.getSequenceNoMappingManager();
        result = this.getDocumentType() != null ? manager.getSequenceNo(this.getDocumentType()) : manager.getSequenceNo(this.makeDocumentCategory());
        return result;
    }

    public void setCancellationContext(CancellationContext context) {
        this.mCancellationContext = context;
    }

    public CancellationContext getCancellationContext() {
        return this.mCancellationContext;
    }

    protected abstract void deleteCancellationTransaction() throws BusinessDomainException;

    public void cancelTransaction(CancellationContext context) throws BusinessDomainException {
        this.validateCancellability();
        this.setCancellationContext(context);
        this.createCancellationTransaction(context);
        this.updateBatchJournalizationState();
    }

    private void updateBatchJournalizationState() {
        if (this.getBatch().getIsJournalized()) {
            this.getBatch().makeSaveable();
            this.getBatch().setIsJournalized(false);
        }
    }

    private void validateCancellability() throws BusinessDomainException {
        if (this.isCancellation()) {
            throw TransactionExceptionMapper.makeCancellationTransactionCannotBeCancelledDomainException();
        }
        if (this.getReverseTransactionBase() != null) {
            throw TransactionExceptionMapper.makeTransactionHasBeenCancelledDomainException();
        }
        if (!this.getIsJournalized()) {
            throw TransactionExceptionMapper.makeNotJournalizedDomainException();
        }
        if (!this.getIsAutomaticProcessing() && this.getUseType().value() != 0 && this.getUseType().value() != 5 && this.getUseType().value() != 6 && this.getUseType().value() != 8 && this.getUseType().value() != 11 && this.getUseType().value() != 15) {
            throw TransactionExceptionMapper.makeAutomaticCreatedTransactionCannotBeCancelledDomainException();
        }
    }

    protected abstract void createCancellationTransaction(CancellationContext var1) throws BusinessDomainException;

    public void journalize() {
        this.setIsJournalized(true);
    }

    public void setjournalizeToOpenOnlyForConsolidation() {
        this.setIsJournalizedForConsolidation(false);
    }

    public void prepareForUpdate() throws BusinessDomainException {
        this.requireLoaded();
        this.hasAllocatedItem();
        this.hasAllocatedDownPaymentItem();
        this.hasItemIncludedInPaymentSession();
        this.hasItemIncludedInInstalment();
        this.hasReconciledItem();
        this.createdTaxReturnReport();
        this.createdECSalesList();
        this.createdChamberContribution();
        this.hasAllocatedNLAccountItem();
        this.hasOpenItemPaidBySplitPayment();
        if (this.getReverseTransactionBase() == null && !this.mIsUnfinished) {
            this.removeFromAccountBalance();
        }
    }

    public Language getReportLanguage() {
        return this.getCompany().getDefaultLanguage();
    }

    public void setCheckConversionRate(boolean checkRate) {
        this.mCheckConversionRate = checkRate;
    }

    public boolean getCheckConversionRate() {
        return this.mCheckConversionRate;
    }

    public void setCheckUseTaxNetAmount(boolean checkUseTaxNetAmount) {
        this.mCheckUseTaxNetAmount = checkUseTaxNetAmount;
    }

    public boolean getCheckUseTaxNetAmount() {
        return this.mCheckUseTaxNetAmount;
    }

    public void setCostingAlreadyPosted(boolean alreadyPosted) {
        this.mCostingAlreadyPosted = alreadyPosted;
    }

    public void setCheckValidTaxRate(boolean checkValidTaxRate) {
        this.mCheckValidTaxRate = checkValidTaxRate;
    }

    public boolean getCostingAlreadyPosted() {
        return this.mCostingAlreadyPosted;
    }

    protected void checkReferenceNumber() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.getReferenceNumber())) {
            if (this.isInvoiceTransaction()) {
                throw TransactionExceptionMapper.makeInvoiceReferenceNumberMissingDomainException();
            }
            if (StringMapper.isNullString((String)this.mSequenceNumber)) {
                if (this.isChequeDepositTransaction()) {
                    throw TransactionExceptionMapper.makeSlipOrSequenceNumberNotSetDomainException();
                }
                throw TransactionExceptionMapper.makeReferenceNumberNotSetDomainException();
            }
            if (this.getFinanceSetup().getMandatoryReferenceNumber()) {
                throw TransactionExceptionMapper.makeInvoiceReferenceNumberMissingDomainException();
            }
        }
    }

    public boolean getNegativePostingsAllowed() {
        return false;
    }

    protected void checkValueDate() throws BusinessDomainException {
        if (this.mValueDate != null && !TransactionHelper.isValueDateCorrect((Date)this.mValueDate, (AccountingCompany)this.getCompany())) {
            throw TransactionExceptionMapper.makeValueDateNotAllowedDomainException();
        }
    }

    public boolean getMultipleTaxCodes() {
        this.requireLoaded();
        return this.mMultipleTaxCodes;
    }

    public void setMultipleTaxCodes(boolean multipleTaxCodes) {
        this.mMultipleTaxCodes = multipleTaxCodes;
    }

    public TaxRate getFixedTaxRate() {
        this.requireLoaded();
        return this.mFixedTaxRate;
    }

    public void setFixedTaxRate(TaxRate fixedTaxRate) {
        this.mFixedTaxRate = fixedTaxRate;
    }

    protected BigDecimal checkBalanced() throws BusinessDomainException {
        BigDecimal debitTotal = BigDecimal.ZERO;
        BigDecimal creditTotal = BigDecimal.ZERO;
        NominalLedgerEntry[] entries = this.getAllEnteredEntries();
        if (entries == null || entries.length < 2) {
            throw TransactionExceptionMapper.makeNotBalancedDomainException();
        }
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getEnteredAmount().signum() == 0 && !this.canBeZero(entries[i]) && !this.getFromCurrencyRevaluation()) {
                throw TransactionExceptionMapper.makeAmountZeroDomainException();
            }
            BigDecimal netAmount = entries[i].getForeignNetAmount();
            if (entries[i].getIsDebit()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[{}]: <{}> debit <{}>", new Object[]{i, entries[i].getAccount().getNominalLedgerItemCode(), netAmount});
                }
                debitTotal = debitTotal.add(netAmount);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[{}]: <{}> credit <{}>", new Object[]{i, entries[i].getAccount().getNominalLedgerItemCode(), netAmount});
            }
            creditTotal = creditTotal.add(netAmount);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("total <{}>/<{}>", (Object)debitTotal, (Object)creditTotal);
        }
        if (debitTotal.compareTo(creditTotal) != 0) {
            throw TransactionExceptionMapper.makeNotBalancedDomainException();
        }
        return debitTotal;
    }

    public void checkBaseCurrencyBalanced() throws BusinessDomainException {
        BigDecimal debitTotal = BigDecimal.ZERO;
        BigDecimal creditTotal = BigDecimal.ZERO;
        NominalLedgerEntry[] entries = this.getAllEnteredEntries();
        if (entries == null || entries.length < 2) {
            throw TransactionExceptionMapper.makeNotBalancedDomainException();
        }
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getBaseAmount() == null) {
                throw TransactionExceptionMapper.makeAmountZeroDomainException();
            }
            if (entries[i].getBaseAmount().signum() == 0 && !this.canBeZero(entries[i]) && !this.getFromCurrencyRevaluation()) {
                throw TransactionExceptionMapper.makeAmountZeroDomainException();
            }
            BigDecimal netAmount = entries[i].getBaseAmount();
            if (entries[i].getIsDebit()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[{}]: debit <{}> ", new Object[]{i, netAmount});
                }
                debitTotal = debitTotal.add(netAmount);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[{}]: credit <{}>", new Object[]{i, netAmount});
            }
            creditTotal = creditTotal.add(netAmount);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("total <{}>/<{}>", (Object)debitTotal, (Object)creditTotal);
        }
        if (debitTotal.compareTo(creditTotal) != 0) {
            throw TransactionExceptionMapper.makeNotBalancedDomainException((String)StringMapper.toString((String)this.getReferenceNumber()));
        }
    }

    protected boolean canBeZero(NominalLedgerEntry entry) {
        return !(entry instanceof BankAccountEntry);
    }

    public NominalTaxEntry[] getSortedTaxEntries() {
        NominalTaxEntry[] entries = this.getTaxEntries();
        if (entries != null && entries.length > 1) {
            Arrays.sort(entries, EntryComparator.getComparator());
        }
        return entries;
    }

    public String getJournalNumber() {
        this.requireLoaded();
        return this.mJournalNumber;
    }

    public String getOidJournal() {
        this.requireLoaded();
        return this.mOidJournal;
    }

    public Batch getBatch() {
        this.requireLoaded();
        return this.mBatch;
    }

    public void setBatch(Batch batch) throws BusinessDomainException {
        if (batch.getIsClosed()) {
            throw TransactionExceptionMapper.makeBatchClosedDomainException();
        }
        this.protocol("batch", (IPersistentObject)this.mBatch, (IPersistentObject)batch);
        this.mBatch = batch;
    }

    public void setBatchWithoutCheck(Batch batch) {
        this.mBatch = batch;
    }

    public FinanceSetup getFinanceSetup() {
        if (this.mFinanceSetup == null) {
            this.mFinanceSetup = this.getCompany().getFinanceSetup();
            if (this.mFinanceSetup == null) {
                throw ExceptionMapper.makeApplicationException((String)"NominalTransactionBase.getFinanceSetup: No Finance Setup found");
            }
        }
        return this.mFinanceSetup;
    }

    public void setFinanceSetup(FinanceSetup financeSetup) {
        this.mFinanceSetup = financeSetup;
    }

    public ConversionRate getConversionRate() {
        this.requireLoaded();
        if (this.mConversionRate == null) {
            this.mConversionRate = this.getForeignCurrencyRate() != null ? this.getForeignCurrencyRate().getConversionRate() : new ConversionRate(BigDecimal.valueOf(1L), false);
        }
        return this.mConversionRate;
    }

    public ICurrency getEnteredCurrency() {
        this.requireLoaded();
        if (this.mEnteredCurrency == null) {
            if (this.getForeignCurrencyRate() != null) {
                this.mEnteredCurrency = this.getForeignCurrencyRate().getCurrency();
            }
            if (this.mEnteredCurrency == null) {
                this.mEnteredCurrency = this.getFinanceSetup().getBaseCurrency();
            }
        }
        return this.mEnteredCurrency;
    }

    public Date getTransactionDate() {
        this.requireLoaded();
        return this.mTransactionDate;
    }

    public void setTransactionDate(Date transactionDate) throws BusinessDomainException {
        if (transactionDate == null) {
            throw TransactionExceptionMapper.makeTransactionDateMissingDomainException();
        }
        if (!this.isNew() && !DateHelper.equal((Date)transactionDate, (Date)this.getTransactionDate())) {
            this.checkIfAmendingAllowed();
        }
        this.protocol("transactiondate", this.mTransactionDate, transactionDate);
        this.mTransactionDate = transactionDate;
    }

    public FinancialYear getFinancialYear() {
        this.requireLoaded();
        return this.mFinancialYear;
    }

    public void setFinancialYear(FinancialYear financialYear) throws BusinessDomainException {
        this.setFinancialYear(financialYear, false);
    }

    public void setFinancialYear(FinancialYear financialYear, boolean withoutCheckClosed) throws BusinessDomainException {
        if (financialYear == null) {
            throw TransactionExceptionMapper.makeFinancialYearMissingDomainException();
        }
        if (!withoutCheckClosed && (financialYear.getCloseMark() || financialYear.isLastPeriodClosed())) {
            String value = financialYear.getCode();
            if (financialYear.isLastPeriodClosed()) {
                value = value.concat("|").concat(financialYear.getLastPeriod().getCode());
            }
            throw TransactionExceptionMapper.makeFinancialYearOrLastPeriodClosedDomainException((String)value);
        }
        if (!this.isNew() && !financialYear.equals((Object)this.getFinancialYear())) {
            this.checkIfAmendingAllowed();
        }
        this.protocol("financialyear", (IPersistentObject)this.mFinancialYear, (IPersistentObject)financialYear);
        this.mFinancialYear = financialYear;
    }

    public void setDocumentType(DocumentType documentType) throws BusinessDomainException {
        if (documentType != null && !documentType.getAccountingCompany().equals((Object)this.getCompany())) {
            throw ExceptionMapper.makeApplicationException((String)"Document type is not in the company");
        }
        if (!this.isNew() && PersistentObjectUtils.objectChanged((IPersistentObject)documentType, (IPersistentObject)this.getDocumentType())) {
            this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION, ProcessingStatus.TransactionStatusType.CANCELLED);
        }
        if (documentType != null && documentType.getIsBlocked()) {
            throw TransactionExceptionMapper.makeDocumentTypeBlockedDomainException((String)documentType.getCode());
        }
        this.protocol("documenttype", (IPersistentObject)this.mDocumentType, (IPersistentObject)documentType);
        this.mDocumentType = documentType;
    }

    public DocumentType getDocumentType() {
        this.requireLoaded();
        return this.mDocumentType;
    }

    public void setTaxRegister(SequenceNo taxRegister) throws BusinessDomainException {
        if (taxRegister != null && !taxRegister.getCompany().equals((Object)this.getCompany())) {
            throw ExceptionMapper.makeApplicationException((String)"Tax register is not in the company");
        }
        if (!this.isNew() && PersistentObjectUtils.objectChanged((IPersistentObject)taxRegister, (IPersistentObject)this.getTaxRegister())) {
            this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.CANCELLATION, ProcessingStatus.TransactionStatusType.CANCELLED);
        }
        this.protocol("taxregister", (IPersistentObject)this.mTaxRegister, (IPersistentObject)taxRegister);
        this.mTaxRegister = taxRegister;
    }

    public SequenceNo getTaxRegister() {
        this.requireLoaded();
        return this.mTaxRegister;
    }

    public TaxCode getFixedTaxCode() {
        this.getFixedTaxCodes();
        if (this.mFixedTaxCodes.length == 1) {
            return this.mFixedTaxCodes[0];
        }
        return null;
    }

    public boolean hasSeveralFixedTaxCodes() {
        this.getFixedTaxCodes();
        return this.mFixedTaxCodes.length > 1;
    }

    public boolean hadSeveralFixedTaxCodes() {
        this.requireLoaded();
        if (this.isNew()) {
            this.mHadSeveralFixedTaxCodes = false;
        }
        return this.mHadSeveralFixedTaxCodes;
    }

    public TaxCode[] getFixedTaxCodes() {
        this.requireLoaded();
        if (this.mFixedTaxCodes == null) {
            this.mFixedTaxCodes = new TaxCode[0];
        }
        return this.mFixedTaxCodes;
    }

    public String getTaxRegisterNumber() {
        this.requireLoaded();
        return this.mTaxRegisterNumber;
    }

    public String getOidTaxRegisterJournal() {
        this.requireLoaded();
        return this.mOidTaxRegisterJournal;
    }

    public void setFixedTaxCode(TaxCode[] fixedTaxCodes) {
        if (fixedTaxCodes == null) {
            fixedTaxCodes = new TaxCode[]{};
        }
        this.mFixedTaxCodes = fixedTaxCodes;
    }

    public Date getDateOfReceipt() {
        this.requireLoaded();
        return this.mDateOfReceipt;
    }

    public void setDateOfReceipt(Date dateOfReceipt) {
        this.protocol("dateofreceipt", this.mDateOfReceipt, dateOfReceipt);
        this.mDateOfReceipt = dateOfReceipt;
    }

    public Date getDocumentDate() {
        this.requireLoaded();
        return this.mDocumentDate;
    }

    public void setDocumentDate(Date documentDate) throws BusinessDomainException {
        if (!this.isNew() && !DateHelper.equal((Date)documentDate, (Date)this.getDocumentDate())) {
            this.checkIfAmendingAllowed();
        }
        this.protocol("documentdate", this.mDocumentDate, documentDate);
        this.mDocumentDate = documentDate;
    }

    public Date getTaxDate() {
        this.requireLoaded();
        return this.mTaxDate == null ? this.mDocumentDate : this.mTaxDate;
    }

    public void setTaxDate(Date taxDate) throws BusinessDomainException {
        if (this.getJurisdiction().useTaxDate()) {
            if (!this.isNew() && !DateHelper.equal((Date)taxDate, (Date)this.getTaxDate())) {
                this.checkTaxDateAmendingAllowed();
            }
            this.protocol("taxdate", this.mTaxDate, taxDate);
        }
        this.mTaxDate = taxDate;
    }

    private void checkTaxDateAmendingAllowed() throws BusinessDomainException {
        if (this.getCompany().getJurisdictionType() == JurisdictionType.DE) {
            if (this.getCompany().getFinanceSetup().getBaseTaxReportType() == BaseDateForConsiderationType.TAXPOINT) {
                this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.CREATED_VAT_RETURN, ProcessingStatus.TransactionStatusType.CREATED_EC_SALES_LIST, ProcessingStatus.TransactionStatusType.CREATED_CHAMBER_CONTRIBUTION);
            }
        } else {
            if (!this.isKronospanPLInvoiceTransaction()) {
                this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.JOURNALISED);
            }
            this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.CANCELLATION, ProcessingStatus.TransactionStatusType.CREATED_VAT_RETURN, ProcessingStatus.TransactionStatusType.CREATED_EC_SALES_LIST, ProcessingStatus.TransactionStatusType.CREATED_CHAMBER_CONTRIBUTION);
            if (!this.isKronospanPL()) {
                this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.HAS_ALLOCATED_ITEM);
            }
        }
    }

    public boolean isKronospanPL() {
        return this.isPL() && ISoftware.isKronospan();
    }

    public boolean isKronospanPLInvoiceTransaction() {
        return this.isKronospanPL() && this.isInvoiceTransaction();
    }

    public Date getValueDate() {
        this.requireLoaded();
        return this.mValueDate;
    }

    public void setValueDate(Date valueDate) throws BusinessDomainException {
        if (!this.isNew() && !DateHelper.equal((Date)valueDate, (Date)this.getValueDate())) {
            this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION);
        }
        this.protocol("valuedate", this.mValueDate, valueDate);
        this.mValueDate = valueDate;
    }

    public String getReferenceNumber() {
        this.requireLoaded();
        return this.mReferenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) throws BusinessDomainException {
        this.setReferenceNumber(referenceNumber, true);
    }

    public void setReferenceNumber(String referenceNumber, boolean checkAllocatedItem) throws BusinessDomainException {
        if (!this.isNew() && !StringMapper.equalWithTrim((String)this.getReferenceNumber(), (String)referenceNumber)) {
            this.checkIfAmendingAllowed(checkAllocatedItem);
        }
        this.protocol("referencenumber", this.mReferenceNumber, referenceNumber);
        this.mReferenceNumber = referenceNumber;
    }

    public String getSequenceNumber() {
        this.requireLoaded();
        return this.mSequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) throws BusinessDomainException {
        if (!this.isNew() && !StringMapper.equalWithTrim((String)this.getSequenceNumber(), (String)sequenceNumber)) {
            this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.JOURNALISED);
            this.registerForFirstExecute();
        }
        this.mSequenceNumber = sequenceNumber;
    }

    public String getProcessId() {
        this.requireLoaded();
        return this.mProcessId;
    }

    public void setProcessId(String processId) {
        this.protocol("processid", this.mProcessId, processId);
        this.mProcessId = processId;
    }

    public ForeignCurrencyRate getForeignCurrencyRate() {
        this.requireLoaded();
        return this.mForeignCurrencyRate;
    }

    public void setForeignCurrencyRate(ForeignCurrencyRate foreignCurrencyRate) throws BusinessDomainException {
        this.setForeignCurrencyRate(foreignCurrencyRate, CurrencyType.BASE_CURRENCY);
    }

    public void setForeignCurrencyRate(ForeignCurrencyRate foreignCurrencyRate, CurrencyType currencyType) throws BusinessDomainException {
        if (!this.isNew() && (this.getForeignCurrencyRate() == null && foreignCurrencyRate != null || this.mForeignCurrencyRate != null && foreignCurrencyRate == null || this.mForeignCurrencyRate != null && foreignCurrencyRate != null && (!ConversionRateUtils.isEqual((ConversionRate)this.mForeignCurrencyRate.getConversionRate(), (ConversionRate)foreignCurrencyRate.getConversionRate()) || !this.mForeignCurrencyRate.getCurrency().equals(foreignCurrencyRate.getCurrency())))) {
            this.checkIfAmendingAllowed();
        }
        this.mForeignCurrencyRate = foreignCurrencyRate;
        if (this.mForeignCurrencyRate != null) {
            this.mEnteredCurrency = this.mForeignCurrencyRate.getCurrency();
            this.mConversionRate = this.mForeignCurrencyRate.getConversionRate();
        } else {
            switch (currencyType) {
                case BASE_CURRENCY: {
                    this.mEnteredCurrency = this.getFinanceSetup().getBaseCurrency();
                    this.mConversionRate = new ConversionRate(BigDecimal.ONE, false);
                    break;
                }
                case SECONDARY_CURRENCY_1: {
                    this.mEnteredCurrency = this.getFinanceSetup().getSeccurrency1();
                    this.mConversionRate = new ConversionRate(BigDecimal.ZERO, false);
                    break;
                }
                case SECONDARY_CURRENCY_2: {
                    this.mEnteredCurrency = this.getFinanceSetup().getSeccurrency2();
                    this.mConversionRate = new ConversionRate(BigDecimal.ZERO, false);
                    break;
                }
                case SECONDARY_CURRENCY_3: {
                    this.mEnteredCurrency = this.getFinanceSetup().getSeccurrency3();
                    this.mConversionRate = new ConversionRate(BigDecimal.ZERO, false);
                    break;
                }
                case SECONDARY_CURRENCY_4: {
                    this.mEnteredCurrency = this.getFinanceSetup().getSeccurrency4();
                    this.mConversionRate = new ConversionRate(BigDecimal.ZERO, false);
                    break;
                }
            }
        }
    }

    public void copyForeignCurrencyRateWithoutCheckFrom(NominalTransactionBase transaction) {
        this.mForeignCurrencyRate = transaction.getForeignCurrencyRate();
        this.mEnteredCurrency = transaction.getEnteredCurrency();
        this.mConversionRate = transaction.getConversionRate();
    }

    public void setForeignCurrencyRateWithoutCheck(ForeignCurrencyRate foreignCurrencyRate, ICurrency enteredCurrency, ConversionRate conversionRate) {
        this.mForeignCurrencyRate = foreignCurrencyRate;
        this.mEnteredCurrency = enteredCurrency;
        this.mConversionRate = conversionRate;
    }

    public String getNote() {
        this.requireLoaded();
        return this.mNote;
    }

    public void setNote(String note) {
        this.protocol("note", this.mNote, note);
        this.mNote = note;
    }

    public boolean isCancellation() {
        this.requireLoaded();
        return this.mIsCancellation;
    }

    public void setIsCancellation(boolean isCancellation) {
        this.protocol("iscancellation", this.mIsCancellation, isCancellation);
        this.mIsCancellation = isCancellation;
    }

    public boolean getIsCorrection() {
        this.requireLoaded();
        return this.mIsCorrection;
    }

    public void setIsCorrection(boolean isCorrection) {
        this.protocol("iscorrection", this.mIsCorrection, isCorrection);
        this.mIsCorrection = isCorrection;
    }

    public INominalTransactionBase getCorrectionToDocument() {
        this.requireLoaded();
        if (this.mCorrectionToDocument == null && !this.isNew() && this.getIsCorrection()) {
            this.mCorrectionToDocument = NLTransactionCorrectionToTransactionPersistencyManager.getCorrectionToDocument((NominalTransactionBase)this);
        }
        return this.mCorrectionToDocument;
    }

    public void setCorrectionToDocument(NominalTransactionBase correctionDocument) throws BusinessDomainException {
        if (correctionDocument != null && !this.isNew() && StringMapper.equal((String)correctionDocument.getObjectid(), (String)this.getObjectid())) {
            throw TransactionExceptionMapper.makeCorrectionPostingMustNotReferToItselfDomainException();
        }
        this.mCorrectionToDocument = correctionDocument;
    }

    public boolean getIsUnfinished() {
        this.requireLoaded();
        return this.mIsUnfinished;
    }

    public void setIsUnfinished(boolean isUnfinished) throws BusinessDomainException {
        if (!this.isNew()) {
            if (this.getIsUnfinished() != isUnfinished) {
                this.checkIfAmendingAllowed();
            }
            if (this.getBatch() != null && this.getBatch().getIsClosed() && isUnfinished) {
                throw TransactionExceptionMapper.makeStateUnfinishedNotAllowedDomainException();
            }
        }
        if (isUnfinished) {
            this.setBaseDifferenceEntry(null);
        }
        this.protocol("isunfinished", this.mIsUnfinished, isUnfinished);
        this.mIsUnfinished = isUnfinished;
    }

    public boolean getIsPayment() {
        this.requireLoaded();
        return this.mIsPayment;
    }

    public void setIsPayment(boolean isPayment) throws BusinessDomainException {
        if (!this.isNew() && this.getIsPayment() != isPayment) {
            this.checkIfAmendingAllowed();
        }
        this.protocol("ispayment", this.mIsPayment, isPayment);
        this.mIsPayment = isPayment;
    }

    public BigDecimal getTotal() {
        this.requireLoaded();
        return this.mTotal;
    }

    public void setTotal(BigDecimal total) throws BusinessDomainException {
        if (total == null) {
            total = BigDecimal.ZERO;
        } else if (!this.isCancellation() && total.signum() == -1 && !this.getNegativePostingsAllowed()) {
            throw TransactionExceptionMapper.makeAmountNegativeDomainException();
        }
        if (!this.isNew() && this.getTotal().compareTo(total) != 0) {
            this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION);
        }
        this.protocol("total", this.mTotal, total);
        this.mTotal = total;
    }

    public boolean getIsJournalized() {
        this.requireLoaded();
        return this.mIsJournalized;
    }

    private void setIsJournalized(boolean journalized) {
        if (this.getIsJournalized()) {
            throw ExceptionMapper.makeApplicationException((String)"Amending is not allowed because the transaction is already journalized.");
        }
        this.protocol("isjournalized", this.mIsJournalized, journalized);
        this.mIsJournalized = journalized;
    }

    private void setIsJournalizedForConsolidation(boolean journalized) {
        this.protocol("isjournalized", this.mIsJournalized, journalized);
        this.mIsJournalized = journalized;
    }

    public String getImportApplication() {
        this.requireLoaded();
        return this.mImportApplication;
    }

    public void setImportApplication(String importApplication) {
        this.protocol("importapplication", this.mImportApplication, importApplication);
        this.mImportApplication = importApplication;
    }

    public DocumentCategoryType getDocumentCategory() {
        this.requireLoaded();
        return this.mDocumentCategory;
    }

    public void setDocumentCategory(DocumentCategoryType documentCategory) {
        this.mDocumentCategory = documentCategory;
    }

    public DocumentCategoryType getDocumentCategory_New() {
        this.requireLoaded();
        if (this.mDocumentCategory_new == null) {
            this.mDocumentCategory_new = this.makeDocumentCategory();
        }
        return this.mDocumentCategory_new;
    }

    public BaseDifferenceEntry getBaseDifferenceEntry() {
        if (this.mBaseDifferenceEntry == null) {
            this.getAllEnteredEntries();
        }
        return this.mBaseDifferenceEntry;
    }

    protected void setBaseDifferenceEntry(BaseDifferenceEntry differenceEntry) throws BusinessDomainException {
        if (!this.isNew()) {
            this.getBaseDifferenceEntry();
            if (differenceEntry != null && this.mBaseDifferenceEntry != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)differenceEntry, (IPersistentObject)this.mBaseDifferenceEntry)) {
                throw ExceptionMapper.makeApplicationException((String)"wrong base difference entry for transaction");
            }
            if (differenceEntry == null && this.mBaseDifferenceEntry != null || differenceEntry != null && this.mBaseDifferenceEntry == null) {
                this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION);
            }
            if (this.mBaseDifferenceEntry != null && differenceEntry == null) {
                this.mBaseDifferenceEntry.makeSaveable();
                this.mBaseDifferenceEntry.destroy();
            }
        }
        this.mBaseDifferenceEntry = differenceEntry;
    }

    public ICurrency getBaseCurrency() {
        return this.getFinanceSetup().getBaseCurrency();
    }

    public abstract NominalTransactionBase getReverseTransactionBase();

    public abstract NominalLedgerEntry[] getAllEnteredEntries();

    public abstract NominalLedgerEntry[] getSortedAllEnteredEntries();

    public abstract NominalLedgerEntry[] getNominalEntries();

    public PersonalAccountEntry[] getAllPersonalAccountEntries() {
        return new PersonalAccountEntry[0];
    }

    public abstract NominalTaxEntry[] getTaxEntries();

    public OpenItem getOriginalOpenItem() {
        return this.mOriginalOpenItem;
    }

    public void setOriginalOpenItem(OpenItem originalOpenItem) {
        this.mOriginalOpenItem = originalOpenItem;
    }

    public FixedAssetManager getFixedAssetManager() {
        if (!this.mFixedAssetManagerCreated) {
            this.mFixedAssetManager = FixedAssetManager.getFixedAssetManager((OpenItem)this.getOriginalOpenItem(), (boolean)this.getPostingDirectlyToAssetAccountAllowed());
            this.mFixedAssetManagerCreated = true;
        }
        return this.mFixedAssetManager;
    }

    public TransactionManager getTransactionManager() {
        if (this.mTransactionManager == null) {
            this.mTransactionManager = TransactionManager.getTransactionManager((JurisdictionType)this.getCompany().getJurisdictionType());
        }
        return this.mTransactionManager;
    }

    public TaxCodeManager getTaxCodeManager() {
        if (this.mTaxCodeManager == null) {
            this.mTaxCodeManager = TaxCodeManager.getTaxCodeManager((JurisdictionType)this.getCompany().getJurisdictionType());
        }
        return this.mTaxCodeManager;
    }

    public Jurisdiction getJurisdiction() {
        if (this.mJurisdiction == null) {
            this.mJurisdiction = JurisdictionFactory.getJurisdiction((JurisdictionType)this.getCompany().getJurisdictionType());
        }
        return this.mJurisdiction;
    }

    public abstract TransactionType getTransactionType();

    public boolean getIsFromAssetAccounting() {
        this.requireLoaded();
        return this.mIsFromAssetAccounting;
    }

    public void setIsFromAssetAccounting(boolean isFromAssetAccounting) {
        this.protocol("isfromassetaccounting", this.mIsFromAssetAccounting, isFromAssetAccounting);
        this.mIsFromAssetAccounting = isFromAssetAccounting;
    }

    protected void checkTransactionDate() throws BusinessDomainException {
        if (this.isNew() || !this.onlyTaxDateChanged()) {
            this.checkTransactionDateBlocked(this.getTransactionDate());
            if (this.changedTransactionDate()) {
                this.checkTransactionDateBlocked(this.mTransactionDate_old);
            }
            this.checkIfPeriodClosed();
        }
        if ((this.isNew() || this.changedTransactionDate()) && this.mSequenceNo_old != null && this.mSequenceNo_old.withTransactionDateInAscendingOrder()) {
            throw TransactionExceptionMapper.makeTransactionDateCannotBeChangedBecauseSequenceNoDomainException();
        }
    }

    private boolean onlyTaxDateChanged() {
        return this.changedTaxDate() && !this.changedTransactionDate() && !this.changedFinancialYear() && !this.changedDocumentCategory() && !this.changedDocumentDate() && !this.changedReferenceNumber() && !this.changedSequenceNumber() && !this.changedDocumentType() && !this.changedIsUnfinished() && !this.changedProcessId();
    }

    private void checkIfPeriodClosed() throws BusinessDomainException {
        if (this.getIsConsolidationTransaction() || !this.isPeriodClosed()) {
            return;
        }
        if (this.isCurrencyRevaluationPostingForAllocatedOpenItem()) {
            String errorValue = StringMapper.toString((String)this.getReferenceNumber()) + "/" + DateMapper.toString((Date)this.getTransactionDate()) + "/" + this.getFinancialYear().getCode();
            throw CurrencyRevaluationExceptionMapper.makePeriodClosedForTransferPostingOfAllocatedOpenItemDomainException((String)errorValue);
        }
        throw TransactionExceptionMapper.makeTransactionDateNotAllowedAsPeriodClosedDomainException();
    }

    private void checkTransactionDateBlocked(Date transactionDate) throws BusinessDomainException {
        if (this.mTransactionPersistencyType != 1 && !this.isPurchaseRegisterInvoice() && !this.getFinanceSetup().isTransactionDateValid(transactionDate)) {
            throw TransactionExceptionMapper.makeTransactionDateBlockedDomainException((String)DateMapper.toString((Date)transactionDate));
        }
    }

    protected void checkDocumentDate() throws BusinessDomainException {
        if (this.getDocumentDate() == null) {
            throw TransactionExceptionMapper.makeDocumentDateMissingDomainException();
        }
        this.checkFromToDocumentDate();
    }

    protected void checkFromToDocumentDate() throws BusinessDomainException {
        if (this.mTransactionPersistencyType != 1 && !this.isPurchaseRegisterInvoice()) {
            if ((this.getFinanceSetup().getDocumentDateFrom() != null || this.getFinanceSetup().getDocumentDateTo() != null) && this.getDocumentDate() == null) {
                throw TransactionExceptionMapper.makeDocumentDateMissingDomainException();
            }
            if (!this.getFinanceSetup().isDocumentDateValid(this.getDocumentDate())) {
                throw TransactionExceptionMapper.makeDocumentDateBlockedDomainException();
            }
        }
    }

    protected void checkForeignCurrencyRate() throws BusinessDomainException {
        if (!(this.getBaseCurrency().equals(this.getEnteredCurrency()) || this.getForeignCurrencyRate() != null && this.getForeignCurrencyRate().getConversionRate() != null && this.getForeignCurrencyRate().getConversionRate().getRate() != null && this.getForeignCurrencyRate().getConversionRate().getRate().signum() > 0 || this.getFromCurrencyRevaluation())) {
            throw TransactionExceptionMapper.makeRateNegativeOrZeroDomainException();
        }
    }

    public boolean shouldCheckConversionRate() {
        return this.mCheckConversionRate;
    }

    public boolean isBaseTotalEntered() {
        return this.mBaseTotalHasBeenEntered;
    }

    protected void checkCurrencyTolerance(ConversionTableType tableType) throws BusinessDomainException {
        new CurrencyToleranceChecker((IFinanceSetup)this.getFinanceSetup(), this.getBaseCurrency()).checkTolerance(this, tableType);
    }

    protected void checkCostingForEntries() throws BusinessDomainException {
        NominalLedgerEntry[] entries = this.getAllEnteredEntries();
        if (entries == null || entries.length == 0) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            entries[i].checkQuantity();
            entries[i].checkCosting();
        }
    }

    protected void checkTaxes() throws BusinessDomainException {
        if (this.isDownPaymentTaxAdjustment()) {
            return;
        }
        new TaxConfigurationValidator().validateTaxConfiguration(this);
    }

    public ICountry getOwnCountry() {
        return this.getCompany().getCountry();
    }

    public boolean isDownPaymentTaxAdjustment() {
        return this.getUseType() != null && this.getUseType().value() == 30;
    }

    protected void reworkForTaxEntries() throws BusinessDomainException {
        NLAccountSplit[] splits;
        NominalTaxEntry[] allTaxEntries;
        if (this.isDownPaymentTaxAdjustment()) {
            return;
        }
        if (this.isChequeDepositTransaction()) {
            ((ChequeDepositTransaction)this).setBaseNetAmount();
            return;
        }
        if (this.isInvoiceTransaction() && ((InvoiceTransaction)this).getIsDownPaymentFinalInvoice()) {
            DownPaymentHelper.setPrepaidTaxAmounts((InvoiceTransaction)((InvoiceTransaction)this));
        }
        if ((allTaxEntries = this.getTaxEntries()) == null || allTaxEntries.length == 0) {
            return;
        }
        for (NLAccountSplit split : splits = this.getNLAccountSplits()) {
            NominalTaxEntry[] taxEntries = split.getTaxEntries();
            TaxEntryProcessor processor = new TaxEntryProcessor(split, (ITaxBaseValidator)new TaxBaseValidator(), this.configuration, this.mTaxOfficeRate);
            for (NominalTaxEntry taxEntry : taxEntries) {
                processor.process(taxEntry);
            }
        }
    }

    protected void checkTaxDate() throws BusinessDomainException {
        FinancialPeriod documentDatePeriod;
        if (this.getDocumentDate() == null) {
            throw TransactionExceptionMapper.makeDocumentDateMissingDomainException();
        }
        if (this.getTaxDate() == null) {
            throw TransactionExceptionMapper.makeTaxDateMissingDomainException();
        }
        if (!(DateHelper.equal((Date)this.getTaxDate(), (Date)this.getDocumentDate()) || !this.getTransactionManager().taxDateAndDocumentDateMustBeInSamePeriod(this) || (documentDatePeriod = this.getFinancialYear().getFinancialPeriod(this.getDocumentDate())) != null && DateHelper.between((Date)this.getTaxDate(), (Date)documentDatePeriod.getValidFrom(), (Date)documentDatePeriod.getValidUntil()))) {
            throw TransactionExceptionMapper.makeTaxDateAndDocumentDateNotInSamePeriodDomainException();
        }
    }

    public void setCheckAutomaticSequenceNo(boolean check) {
        this.mCheckAutomaticSequenceNo = check;
    }

    protected void checkAutomaticSequenceNo() throws BusinessDomainException {
        boolean checkEmpty = false;
        if (this.mCheckAutomaticSequenceNo) {
            if ((this.isPurchaseRegisterInvoice() || !this.mIsUnfinished) && StringMapper.isNullString((String)this.mSequenceNumber)) {
                checkEmpty = true;
                SequenceNo sequenceNo = this.getSequenceNo();
                if (sequenceNo != null) {
                    if (sequenceNo.automaticAssignment()) {
                        checkEmpty = false;
                    }
                    if (sequenceNo.getWithoutinterrupt()) {
                        if (!this.mIsUnfinished) {
                            String sequenceNumber = this.getSequenceNoMappingManager().getNextSequenceNumber(sequenceNo, this.getFinancialYear(), this.getTransactionDate(), true, false, true);
                            this.setSequenceNumber(sequenceNumber);
                            NominalLedgerEntry[] entries = this.getNominalEntries();
                            for (int i = 0; i < entries.length; ++i) {
                                if (entries[i].getCosting() == null) continue;
                                entries[i].getCosting().setSequenceNumber(sequenceNumber);
                            }
                        }
                    } else if (sequenceNo.getAssignmentTimePoint() == SequenceNoAssignmentTimePointType.MANUAL) {
                        throw TransactionExceptionMapper.makeSequenceNumberMissingDomainException();
                    }
                }
            }
        } else {
            SequenceNo sequenceNo;
            checkEmpty = true;
            if (StringMapper.isNullString((String)this.getSequenceNumber()) && (sequenceNo = this.getSequenceNo()) != null && sequenceNo.automaticAssignment()) {
                checkEmpty = false;
            }
        }
        if (checkEmpty && this.getFinanceSetup().getMandatorySequenceNumber() && StringMapper.isNullString((String)this.getSequenceNumber())) {
            if (this.isPersonalAccountAdjustmentTransaction()) {
                throw TransactionExceptionMapper.makeSequenceNumberForAdjustmentTransactionMissingDomainException();
            }
            throw TransactionExceptionMapper.makeSequenceNumberMissingDomainException();
        }
    }

    public boolean getIsInputTax() {
        this.requireLoaded();
        return this.mIsInputTax;
    }

    public void setIsInputTax(boolean inputTax) throws BusinessDomainException {
        if (!this.isNew() && this.getIsInputTax() != inputTax) {
            this.checkIfAmendingAllowed();
        }
        this.protocol("isinputtax", this.mIsInputTax, inputTax);
        this.mIsInputTax = inputTax;
    }

    public boolean getUseNotDueTaxAccount() {
        return false;
    }

    public Map<String, TaxCode> getUsedTaxCodes() {
        if (this.mTaxCodeMap == null) {
            this.mTaxCodeMap = new HashMap<String, TaxCode>();
            for (int i = 0; i < this.getTaxEntries().length; ++i) {
                TaxCode taxCode = this.getTaxEntries()[i].getTaxRate().getTaxCode();
                this.mTaxCodeMap.put(taxCode.getCode(), taxCode);
            }
        }
        return this.mTaxCodeMap;
    }

    public Date getExchangeRateDate() {
        return DefaultExchangeRateDateResolver.resolve((Date)this.getTransactionDate(), (Date)this.getDocumentDate(), (Date)this.getValueDate(), (TransactionType)this.getTransactionType());
    }

    protected void convertForFinishedTransaction() throws BusinessDomainException {
        TransactionConversionManager.convertForFinishedTransaction((NominalTransactionBase)this);
    }

    public boolean isParallelCurrencyGainLossTransaction() {
        return this.getUseType() != null && (this.getUseType().value() == 13 || this.getUseType().value() == 14 || this.getUseType().value() == 17);
    }

    public boolean isPersonalAccountTransferTransaction() {
        return this.getUseType() != null && this.getUseType().value() == 2;
    }

    public boolean isClosingTransaction() {
        return this.getUseType() != null && (this.getUseType().value() == 21 || this.getUseType().value() == 22);
    }

    public boolean isParalcurrVatReturnClosingTransaction() {
        return this.getUseType() != null && this.getUseType().value() == 20;
    }

    public boolean isNLAccountOpenItemAdjustment() {
        return this.getUseType() != null && (this.getUseType().value() == 1 || this.getUseType().value() == 27 || this.getUseType().value() == 18 || this.getUseType().value() == 17);
    }

    public void convertForUnfinishedTransaction() throws BusinessDomainException {
        TransactionConversionManager.convertForUnfinishedTransaction((NominalTransactionBase)this);
    }

    protected void updateRateInCosting() {
        NominalLedgerEntry[] allEntries = this.getAllEnteredEntries();
        for (int i = 0; i < allEntries.length; ++i) {
            allEntries[i].updateRateInCosting();
        }
    }

    public void addToAccountBalance() throws BusinessDomainException {
        this.addToAccountBalance(true);
    }

    public void addToAccountBalance(boolean withCosting) throws BusinessDomainException {
        this.addToAccountBalance(withCosting, true, true);
    }

    public void addToAccountBalance(boolean withCosting, boolean withCarriedForwardOI, boolean withPlafond) throws BusinessDomainException {
        PersonalAccountPlafond validPlafond;
        NominalTaxEntry[] taxEntries;
        NominalLedgerEntry[] entries = this.getAllEnteredEntries();
        for (int i = 0; i < entries.length; ++i) {
            entries[i].addToAccountBalance(withCosting, withCarriedForwardOI);
        }
        if (this.getBaseDifferenceEntry() != null) {
            this.getBaseDifferenceEntry().addToAccountBalance(withCosting, withCarriedForwardOI);
        }
        if (withPlafond && (taxEntries = this.getTaxEntries()) != null && taxEntries.length > 0 && (validPlafond = this.getValidPlafond()) != null) {
            validPlafond.addFromPlafond(taxEntries);
        }
    }

    public void removeFromAccountBalance() throws BusinessDomainException {
        if (!this.mDeletedFromBalance) {
            PersonalAccountPlafond validPlafond;
            NominalTaxEntry[] taxEntries;
            NominalLedgerEntry[] entries = this.getAllEnteredEntries();
            for (int i = 0; i < entries.length; ++i) {
                entries[i].removeFromAccountBalance();
            }
            if (this.getBaseDifferenceEntry() != null) {
                this.getBaseDifferenceEntry().removeFromAccountBalance();
            }
            if ((taxEntries = this.getTaxEntries()) != null && taxEntries.length > 0 && (validPlafond = this.getValidPlafond()) != null) {
                validPlafond.removeFromPlafond(taxEntries);
            }
            this.mDeletedFromBalance = true;
        }
    }

    private PersonalAccountPlafond getValidPlafond() {
        PersonalAccount persAcc = null;
        switch (this.getTransactionType()) {
            case INVOICE_PAYABLE: 
            case INVOICE_RECEIVABLE: {
                persAcc = ((InvoiceTransaction)this).getPersonalAccountEntry().getPersonalAccount();
                break;
            }
            case PERSONAL_ACCOUNT_ADJUSTMENT: {
                persAcc = ((PersonalAccountAdjustmentTransaction)this).getPersonalAccountEntry().getPersonalAccount();
            }
        }
        return persAcc == null ? null : persAcc.getValidPlafond(this.getTaxDate());
    }

    public final void rework() throws BusinessDomainException {
        this.rework(false);
    }

    public final void rework(boolean withoutConversion) throws BusinessDomainException {
        this.setNoNetBalance();
        if (this.getIsRecurring() || this.getIsBankStatementPosting()) {
            this.checkFinishedTransaction();
            this.fixedTaxCodeValidator.validate((INominalTransactionBase)this);
        } else {
            this.checkAutomaticSequenceNo();
            this.checkDescriptions();
            if (this.getReverseTransactionBase() != null) {
                this.checkReferenceNumber();
                if (this.getTransactionType() == TransactionType.INVOICE_PAYABLE || this.getTransactionType() == TransactionType.INVOICE_RECEIVABLE) {
                    this.setContraAccounts();
                    this.setEuVatNumber();
                }
            } else {
                if (!this.mIsUnfinished) {
                    this.checkCompany();
                    this.checkFinishedTransaction();
                    this.fixedTaxCodeValidator.validate((INominalTransactionBase)this);
                    if (!withoutConversion) {
                        this.convertForFinishedTransaction();
                    }
                    this.reworkForTaxEntries();
                    this.adjustNLAccountOpenItems();
                    this.checkCashAccountBalance();
                    this.setContraAccounts();
                    this.setEuVatNumber();
                    if (this.addToAccountBalance) {
                        this.addToAccountBalance();
                    }
                } else {
                    this.checkUnfinishedTransaction();
                    this.convertForUnfinishedTransaction();
                    this.adjustNLAccountOpenItems();
                }
                this.calculateBaseTotal();
                this.calculateTaxTotals();
                this.adjustDownPaymentTransactions();
                this.adjustOpenItems();
                this.setDownPaymentRequestsToDone();
                this.adjustTransitoryTransactions();
                if (!this.mIsUnfinished) {
                    this.updateFixedAsset();
                } else {
                    this.deleteFixedAsset();
                }
                this.closingCostUnit();
                this.setNlentryTaxRegister();
            }
        }
        this.mReworkExecuted = true;
    }

    private void checkCompany() throws BusinessDomainException {
        if (this.getFinancialYear() != null && this.getCompany() != null && !this.getFinancialYear().getCompany().equals((Object)this.getCompany())) {
            throw TransactionExceptionMapper.makeFinancialYearIsNotInCompanyDomainException();
        }
    }

    protected void setDownPaymentRequestsToDone() throws BusinessDomainException {
    }

    private void closingCostUnit() throws BusinessDomainException {
        NominalLedgerEntry[] entries = this.getNominalEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getCosting() == null) continue;
            entries[i].getCosting().closingCostUnit();
        }
        BaseDifferenceEntry rde = this.getBaseDifferenceEntry();
        if (rde != null && rde.getCosting() != null) {
            rde.getCosting().closingCostUnit();
        }
    }

    protected void setNoNetBalance() {
    }

    protected void calculateTaxTotals() {
    }

    protected abstract void setContraAccounts();

    protected void adjustTransitoryTransactions() throws BusinessDomainException {
    }

    protected void adjustDownPaymentTransactions() throws BusinessDomainException {
    }

    private void updateFixedAsset() throws BusinessDomainException {
        if (this.getFixedAssetManager() == null) {
            return;
        }
        if (this.getUseType() != null && (this.getUseType().value() == 3 || this.getUseType().value() == 4 || this.getUseType().value() == 38) || this.getIsConsolidationTransaction()) {
            return;
        }
        NominalLedgerEntry[] entries = this.getAllEnteredEntries();
        for (int i = 0; i < entries.length; ++i) {
            entries[i].updateFixedAsset();
        }
        BaseDifferenceEntry rde = this.getBaseDifferenceEntry();
        if (rde != null) {
            rde.updateFixedAsset();
        }
    }

    private void deleteFixedAsset() throws BusinessDomainException {
        if (this.getFixedAssetManager() == null) {
            return;
        }
        NominalLedgerEntry[] entries = this.getAllEnteredEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getObjectid() == null) continue;
            entries[i].deleteFixedAsset();
        }
        BaseDifferenceEntry rde = this.getBaseDifferenceEntry();
        if (rde != null) {
            rde.deleteFixedAsset();
        }
    }

    protected void checkCashAccountBalance() throws BusinessDomainException {
    }

    protected abstract void checkFinishedTransaction() throws BusinessDomainException;

    protected void checkUnfinishedTransaction() {
    }

    protected void adjustOpenItems() throws BusinessDomainException {
    }

    private void adjustNLAccountOpenItems() throws BusinessDomainException {
        NominalLedgerEntry[] allEntries = this.getAllEnteredEntries();
        for (int i = 0; i < allEntries.length; ++i) {
            allEntries[i].checkForeignCurrencyOfNLAccount();
            allEntries[i].adjustNLAccountOpenItem();
        }
        BaseDifferenceEntry de = this.getBaseDifferenceEntry();
        if (de != null) {
            de.checkForeignCurrencyOfNLAccount();
            de.adjustNLAccountOpenItem();
        }
    }

    private boolean getCreatedTaxReturnReport() {
        NominalTaxEntry[] taxEntries = this.getTaxEntries();
        for (int i = 0; i < taxEntries.length; ++i) {
            if (!taxEntries[i].isVatReturnCreated()) continue;
            return true;
        }
        return false;
    }

    private boolean getIsClosedVATReturn() {
        NominalTaxEntry[] taxEntries;
        for (NominalTaxEntry taxEntry : taxEntries = this.getTaxEntries()) {
            if (!taxEntry.isVatReturnClosed()) continue;
            return true;
        }
        return false;
    }

    private boolean getCreatedChamberContribution() {
        NominalTaxEntry[] taxEntries = this.getTaxEntries();
        for (int i = 0; i < taxEntries.length; ++i) {
            if (!taxEntries[i].isChamberContributionCreated()) continue;
            return true;
        }
        return false;
    }

    private boolean getCreatedECSalesList() {
        NominalTaxEntry[] taxEntries = this.getTaxEntries();
        for (int i = 0; i < taxEntries.length; ++i) {
            if (!taxEntries[i].isECSalesListCreated()) continue;
            return true;
        }
        return false;
    }

    protected boolean getHasReconciledItem() {
        return false;
    }

    protected boolean getHasAllocatedItem() {
        return false;
    }

    protected boolean getHasItemIncludedInPaymentSession() {
        return false;
    }

    protected boolean getHasAllocatedDownPaymentItem() {
        return false;
    }

    protected boolean getHasItemIncludedInInstalment() {
        return false;
    }

    public boolean getHasAllocatedNLAccountItem() {
        if (!this.isNLAccountOpenItemAdjustment()) {
            NominalLedgerEntry[] entries = this.getAllEnteredEntries();
            for (int i = 0; i < entries.length; ++i) {
                NLAccountOpenItem oi = entries[i].getNLAccountOpenItem();
                if (oi == null || !oi.getIsAllocated()) continue;
                return true;
            }
            BaseDifferenceEntry de = this.getBaseDifferenceEntry();
            if (de != null && de.getNLAccountOpenItem() != null && de.getNLAccountOpenItem().getIsAllocated()) {
                return true;
            }
        }
        return false;
    }

    public boolean createdECSalesList() {
        if (!this.createdECSalesListCalculated) {
            this.createdECSalesList = !this.isNew() ? this.getCreatedECSalesList() : false;
            this.createdECSalesListCalculated = true;
        }
        return this.createdECSalesList;
    }

    public boolean createdTaxReturnReport() {
        if (!this.createdTaxReturnReportCalculated) {
            this.createdTaxReturnReport = !this.isNew() ? this.getCreatedTaxReturnReport() : false;
            this.createdTaxReturnReportCalculated = true;
        }
        return this.createdTaxReturnReport;
    }

    public boolean createdChamberContribution() {
        if (!this.createdChamberContributionCalculated) {
            this.createdChamberContribution = !this.isNew() ? this.getCreatedChamberContribution() : false;
            this.createdChamberContributionCalculated = true;
        }
        return this.createdChamberContribution;
    }

    public boolean hasReconciledItem() {
        if (!this.hasReconciledItemCalculated) {
            this.hasReconciledItem = !this.isNew() ? this.getHasReconciledItem() : false;
            this.hasReconciledItemCalculated = true;
        }
        return this.hasReconciledItem;
    }

    public boolean hasAllocatedItem() {
        if (!this.hasAllocatedItemCalculated) {
            this.hasAllocatedItem = !this.isNew() ? this.getHasAllocatedItem() : false;
            this.hasAllocatedItemCalculated = true;
        }
        return this.hasAllocatedItem;
    }

    public boolean hasAllocatedDownPaymentItem() {
        if (!this.hasAllocatedDownPaymentItemCalculated) {
            this.hasAllocatedDownPaymentItem = !this.isNew() ? this.getHasAllocatedDownPaymentItem() : false;
            this.hasAllocatedDownPaymentItemCalculated = true;
        }
        return this.hasAllocatedDownPaymentItem;
    }

    public boolean hasItemIncludedInPaymentSession() {
        if (!this.hasItemIncludedInPaymentSessionCalculated) {
            this.hasItemIncludedInPaymentSession = !this.isNew() ? this.getHasItemIncludedInPaymentSession() : false;
            this.hasItemIncludedInPaymentSessionCalculated = true;
        }
        return this.hasItemIncludedInPaymentSession;
    }

    public boolean hasItemIncludedInInstalment() {
        if (!this.hasItemIncludedInInstalmentCalculated) {
            this.hasItemIncludedInInstalment = !this.isNew() ? this.getHasItemIncludedInInstalment() : false;
            this.hasItemIncludedInInstalmentCalculated = true;
        }
        return this.hasItemIncludedInInstalment;
    }

    public boolean hasAllocatedNLAccountItem() {
        if (!this.hasAllocatedNLAccountItemCalculated) {
            this.hasAllocatedNLAccountItem = !this.isNew() ? this.getHasAllocatedNLAccountItem() : false;
            this.hasAllocatedNLAccountItemCalculated = true;
        }
        return this.hasAllocatedNLAccountItem;
    }

    public boolean isVATReturnClosed() {
        if (!this.vatReturnClosedCalculated) {
            this.vatReturnClosed = !this.isNew() ? this.getIsClosedVATReturn() : false;
            this.vatReturnClosedCalculated = true;
        }
        return this.vatReturnClosed;
    }

    private boolean changedTransactionDate() {
        if (!this.isNew()) {
            return !DateHelper.equal((Date)this.mTransactionDate, (Date)this.mTransactionDate_old);
        }
        return false;
    }

    private boolean changedIsJournalized() {
        if (!this.isNew()) {
            return this.mIsJournalized != this.mIsJournalized_old;
        }
        return false;
    }

    private boolean changedFinancialYear() {
        if (!this.isNew()) {
            return !this.mFinancialYear.equals((Object)this.mFinancialYear_old);
        }
        return false;
    }

    private boolean changedDocumentType() {
        if (!this.isNew()) {
            return PersistentObjectUtils.objectChanged((IPersistentObject)this.mDocumentType, (IPersistentObject)this.mDocumentType_old);
        }
        return false;
    }

    private boolean changedDocumentCategory() {
        if (!this.isNew()) {
            return this.mDocumentCategory != this.mDocumentCategory_old;
        }
        return false;
    }

    private boolean changedSequenceNumber() {
        if (!this.isNew()) {
            return !StringMapper.equal((String)this.mSequenceNumber, (String)this.mSequenceNumber_old);
        }
        return false;
    }

    private boolean changedProcessId() {
        if (!this.isNew()) {
            return !StringMapper.equal((String)this.mProcessId, (String)this.mProcessId_old);
        }
        return false;
    }

    public boolean changedIsUnfinished() {
        if (!this.isNew()) {
            return this.mIsUnfinished != this.mIsUnfinished_old;
        }
        return false;
    }

    protected boolean changedReferenceNumber() {
        if (!this.isNew()) {
            return !StringMapper.equal((String)this.mReferenceNumber, (String)this.mReferenceNumber_old);
        }
        return false;
    }

    protected boolean changedDocumentDate() {
        if (!this.isNew()) {
            return !DateHelper.equal((Date)this.mDocumentDate, (Date)this.mDocumentDate_old);
        }
        return false;
    }

    private boolean changedTaxDate() {
        if (!this.isNew()) {
            return !DateHelper.equal((Date)this.mTaxDate, (Date)this.mTaxDate_old);
        }
        return false;
    }

    public void setFromRecurringToTrue() {
        this.mFromRecurring = true;
    }

    public boolean getFromRecurringToTrue() {
        return this.mFromRecurring;
    }

    public BigDecimal getBaseTotal() {
        this.requireLoaded();
        return this.mBaseTotal;
    }

    public void setBaseTotal(BigDecimal baseTotal) throws BusinessDomainException {
        this.setBaseTotal(baseTotal, true);
    }

    public void setBaseTotal(BigDecimal baseTotal, boolean withCheck) throws BusinessDomainException {
        if (withCheck) {
            if (this.getIsRecurring() || this.mFromRecurring) {
                return;
            }
            if (this.isNominalLedgerTransaction() && !this.getFromCurrencyRevaluation() && !this.getIsNLAccountResidueAdjustmentWithBaseTotal() && !this.getIsNLAccountOpenItemConversionAdjustment() || this.isChequeDepositTransaction() || this.isCashTransaction() && ((CashTransaction)this).isSeveralAccounts()) {
                return;
            }
            if (baseTotal == null) {
                throw TransactionExceptionMapper.makeAmountZeroDomainException();
            }
            if (baseTotal.signum() == -1 && this.getTotal() != null && this.getTotal().signum() != -1 && !this.getFromCurrencyRevaluation()) {
                throw TransactionExceptionMapper.makeAmountNegativeDomainException();
            }
            if (baseTotal.signum() == 1 && this.getTotal() != null && this.getTotal().signum() != 1 && !this.getFromCurrencyRevaluation() && !this.getIsNLAccountOpenItemConversionAdjustment()) {
                throw TransactionExceptionMapper.makeAmountZeroDomainException();
            }
        }
        this.mBaseTotal = baseTotal;
        this.mBaseTotalHasBeenEntered = true;
    }

    private void calculateBaseTotal() {
        if (!this.mBaseTotalHasBeenEntered) {
            this.mBaseTotal = this.getEnteredCurrency().equals(this.getBaseCurrency()) ? this.getTotal() : this.makeBaseTotal();
        }
    }

    public abstract BigDecimal makeBaseTotal();

    public boolean getIsRecurring() {
        return this.mTransactionPersistencyType == 1;
    }

    public boolean getIsBankStatementPosting() {
        return this.mTransactionPersistencyType == 2;
    }

    public void setTransactionPersistencyType(int type) {
        this.mTransactionPersistencyType = type;
    }

    public int getTransactionPersistencyType() {
        return this.mTransactionPersistencyType;
    }

    public AccountingCompany getCompany() {
        if (this.getBatch() == null) {
            return this.mAccountingCompany;
        }
        return this.getBatch().getCompany();
    }

    public void setCompany(AccountingCompany company) {
        this.mAccountingCompany = company;
    }

    public void convertEntriesToNewTotalAmount(ICurrency currency, BigDecimal newAmount) throws BusinessDomainException {
        TransactionConversionManager.convertEntriesToNewTotalAmount((NominalTransactionBase)this, (ICurrency)currency, (BigDecimal)newAmount);
    }

    public void saveOldSeqNoMapping() {
        this.mSequenceNo_old = this.getSequenceNo();
    }

    public void setOldSeqNoMapping(SequenceNo oldSequenceNo) {
        this.mSequenceNo_old = oldSequenceNo;
    }

    public void setHasAllocatedItemCalculated(boolean calculated) {
        this.hasAllocatedItemCalculated = calculated;
    }

    public NominalLedgerEntry[] getSortedNominalEntries() {
        NominalLedgerEntry[] entries = this.getNominalEntries();
        if (entries != null && entries.length > 1) {
            Arrays.sort(entries, EntryComparator.getComparator());
        }
        return entries;
    }

    public void makeTransactionReadOnly() {
        this.makeReadOnly();
        NominalLedgerEntry[] entries = this.getAllEnteredEntries();
        for (int i = 0; i < entries.length; ++i) {
            entries[i].makeEntryReadOnly();
        }
        BaseDifferenceEntry de = this.getBaseDifferenceEntry();
        if (de != null) {
            de.makeEntryReadOnly();
        }
        try {
            if (this.isNew() && !StringMapper.isNullString((String)this.getSequenceNumber())) {
                SequenceNoMapping.giveBackSequenceNumber((FinancialYear)this.getFinancialYear(), (SequenceNo)this.getSequenceNo(), (String)this.getSequenceNumber(), (Date)this.getTransactionDate());
            }
        }
        catch (BusinessDomainException businessDomainException) {
            // empty catch block
        }
    }

    public void setFromUpdateScript(boolean fromScript) {
        this.isFromUpdateScript = fromScript;
    }

    public boolean isFromUpdateScript() {
        return this.isFromUpdateScript;
    }

    public void setFromUpdateBalanceScript(boolean fromScript) {
        this.isFromUpdateBalanceScript = fromScript;
    }

    public boolean isFromUpdateBalanceScript() {
        return this.isFromUpdateBalanceScript;
    }

    public void setNoConversionToBaseCurrencyForTransfer(boolean noConversionToBaseCurrencyForTransfer) {
        this.mNoConversionToBaseCurrencyForTransfer = noConversionToBaseCurrencyForTransfer;
    }

    public boolean getNoConversionToBaseCurrencyForTransfer() {
        return this.mNoConversionToBaseCurrencyForTransfer;
    }

    public SequenceNoMappingManager getSequenceNoMappingManager() {
        if (this.mSequenceNoMappingManager == null) {
            this.mSequenceNoMappingManager = new SequenceNoMappingManager(this.getCompany());
        }
        return this.mSequenceNoMappingManager;
    }

    public void setSequenceNoMappingManager(SequenceNoMappingManager manager) {
        this.mSequenceNoMappingManager = manager;
    }

    protected void checkPostCondition() throws BusinessDomainException {
        if (!this.mReworkExecuted || this.getIsUnfinished() || this.isCancellation()) {
            return;
        }
        if (!this.getSequenceNoMappingManager().isSequenceNumberUnique(this.getFinancialYear(), this.getTransactionDate(), this.getDocumentType(), this.getDocumentCategory_New(), this.getSequenceNumber())) {
            throw TransactionExceptionMapper.makeSequenceNumberIsNotUniqueDomainException();
        }
    }

    public void setPostingDirectlyToAssetAccountAllowed(boolean allowed) {
        this.mPostingDirectlyToAssetAccountAllowed = allowed;
    }

    public boolean getPostingDirectlyToAssetAccountAllowed() {
        return this.mPostingDirectlyToAssetAccountAllowed;
    }

    public void setIsSupplierDiscountAdjustment(boolean isDiscountAdjustment) {
        this.mIsSupplierDiscountAdjustment = isDiscountAdjustment;
    }

    public boolean getIsSupplierDiscountAdjustment() {
        return this.mIsSupplierDiscountAdjustment;
    }

    public boolean makeOneOffAccountAddressReadOnly(CustSupAddress oneOffAddress) {
        if (oneOffAddress.isNew()) {
            return false;
        }
        if (this.mOneOffAddressMap == null) {
            this.mOneOffAddressMap = new HashMap<String, CustSupAddress>();
            this.mOneOffAddressMap.put(oneOffAddress.getObjectid(), oneOffAddress);
            return false;
        }
        if (this.mOneOffAddressMap.get(oneOffAddress.getObjectid()) == null) {
            this.mOneOffAddressMap.put(oneOffAddress.getObjectid(), oneOffAddress);
            return false;
        }
        return true;
    }

    public CostingCompany getCostingCompany() {
        if (this.mCostingCompany == null) {
            this.mCostingCompany = CostingCompanyPersistencyManager.getCostingCompany((String)this.getCompany().getObjectid());
        }
        return this.mCostingCompany;
    }

    public void setSeccurrConversionRate(Map<ICurrency, ConversionRate> rateMap) {
        this.mSeccurrConversionRateMap = rateMap;
    }

    public ConversionRate getSeccurr1ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr1ConversionRate;
    }

    public void setSeccurr1ConversionRate(ConversionRate rate) {
        this.mSeccurr1ConversionRate = rate;
    }

    public ConversionRate getSeccurr2ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr2ConversionRate;
    }

    public void setSeccurr2ConversionRate(ConversionRate rate) {
        this.mSeccurr2ConversionRate = rate;
    }

    public ConversionRate getSeccurr3ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr3ConversionRate;
    }

    public void setSeccurr3ConversionRate(ConversionRate rate) {
        this.mSeccurr3ConversionRate = rate;
    }

    public ConversionRate getSeccurr4ConversionRate() {
        this.requireLoaded();
        return this.mSeccurr4ConversionRate;
    }

    public void setSeccurr4ConversionRate(ConversionRate rate) {
        this.mSeccurr4ConversionRate = rate;
    }

    public TransactionUseTypeEnum getUseType() {
        this.requireLoaded();
        return this.mTransactionUseType;
    }

    public void setUseType(TransactionUseTypeEnum useType) {
        this.mTransactionUseType = useType == null ? TransactionUseTypeEnum.TUTE_NONE : useType;
    }

    public boolean getFromCurrencyRevaluation() {
        return false;
    }

    public boolean getIsAutomaticProcessing() {
        return this.mIsAutomaticProcessing;
    }

    public void setIsAutomaticProcessing(boolean isAutomaticProcessing) {
        this.mIsAutomaticProcessing = isAutomaticProcessing;
    }

    public abstract boolean isPeriodClosed();

    public boolean isAgedDataTransaction() {
        return false;
    }

    public String getCreatorID() {
        this.requireLoaded();
        return this.mCreatorID;
    }

    public Date getCreationDate() {
        this.requireLoaded();
        return this.mCreationDate;
    }

    public boolean getIsForeignPersonalAccount() throws BusinessDomainException {
        return false;
    }

    public abstract JournalTransactionGroupEnum getJournalTransactionGroup();

    public boolean getIsCorrection_old() {
        this.requireLoaded();
        return this.mIsCorrection_old;
    }

    public boolean isCreatedByTransfer() {
        this.requireLoaded();
        return this.mIsCreatedByTransfer;
    }

    public void setIsCreatedByTransfer(boolean isCreatedByTransfer) {
        this.mIsCreatedByTransfer = isCreatedByTransfer;
    }

    protected void setNominalEntries(NominalLedgerEntry[] newEntries) throws BusinessDomainException {
    }

    protected void setTaxEntries(NominalTaxEntry[] taxEntries) throws BusinessDomainException {
    }

    public boolean getIsDownPaymentFinalInvoice() {
        return false;
    }

    public boolean getIsDownPaymentRequestInvoice() {
        return this.getUseType() != null && (this.getUseType().value() == 25 || this.getUseType().value() == 26);
    }

    private void setNlentryTaxRegister() throws BusinessDomainException {
        NominalTaxEntry[] taxEntries;
        if (!this.getJurisdiction().useTaxRegister()) {
            return;
        }
        for (NominalTaxEntry nominalTaxEntry : taxEntries = this.getTaxEntries()) {
            nominalTaxEntry.setTaxRegister(this.getTaxRegister(nominalTaxEntry));
        }
        if (this.isInvoiceTransaction()) {
            PrepaidTax[] prepaidTaxes;
            for (PrepaidTax prepaidTax : prepaidTaxes = ((InvoiceTransaction)this).getPrepaidTaxes()) {
                NominalTaxEntry[] prepaidTaxEntries;
                for (NominalTaxEntry prepaidTaxEntry : prepaidTaxEntries = prepaidTax.getTaxEntries()) {
                    prepaidTaxEntry.setTaxRegister(this.getTaxRegister(prepaidTaxEntry));
                }
            }
        }
    }

    private SequenceNo getTaxRegister(NominalTaxEntry nominalTaxEntry) throws BusinessDomainException {
        TaxCode taxCode = nominalTaxEntry.getTaxRate().getTaxCode();
        if (nominalTaxEntry.isCorrespondingEntry() && taxCode.isWithCorrespondingEntry(this.getReverseChargeMethod())) {
            SequenceNo outputTaxRegister = this.getOutputTaxRegister(nominalTaxEntry.getTaxRate());
            if (outputTaxRegister == null) {
                throw TransactionExceptionMapper.makeOutputTaxRegisterMissingDomainException();
            }
            return outputTaxRegister;
        }
        if (nominalTaxEntry.isCorrespondingEntry() && taxCode.isSplitPayment()) {
            SequenceNo splitPaymentTaxRegister = this.getOutputTaxRegister(nominalTaxEntry.getTaxRate());
            if (splitPaymentTaxRegister == null) {
                splitPaymentTaxRegister = this.getTaxRegister();
            }
            return splitPaymentTaxRegister;
        }
        return this.getTaxRegister();
    }

    private SequenceNo getOutputTaxRegister(TaxRate taxRate) {
        NominalLedgerTaxAccounts taxAccounts = this.getFinanceSetup().getNominalLedger().getTaxAccounts(taxRate);
        SequenceNo outputTaxRegister = null;
        if (taxAccounts != null) {
            outputTaxRegister = taxAccounts.getOutputTaxRegister(this.getCompany());
        }
        return outputTaxRegister;
    }

    public boolean getReverseChargeMethod() {
        FinancialYear rsYear;
        boolean result = this.getFinanceSetup().getReverseChargeMethod();
        if (result && (rsYear = this.getFinanceSetup().getReverseChargeFinancialYear()) != null && DateHelper.before((Date)this.getFinancialYear().getValidFrom(), (Date)rsYear.getValidFrom())) {
            result = false;
        }
        return result;
    }

    public boolean isCashTransaction() {
        return false;
    }

    public boolean isInvoiceTransaction() {
        return false;
    }

    public boolean isChequeDepositTransaction() {
        return false;
    }

    public boolean isNominalLedgerTransaction() {
        return false;
    }

    public boolean isCashTransfer() {
        return false;
    }

    public boolean isPersonalAccountAdjustmentTransaction() {
        return false;
    }

    public boolean isInvoiceReceivableTransaction() {
        return false;
    }

    public boolean isInvoicePayableTransaction() {
        return false;
    }

    public boolean isPurchaseRegisterInvoice() {
        return false;
    }

    public ConversionRate getTaxOfficeRate() {
        this.requireLoaded();
        return this.mTaxOfficeRate;
    }

    public ConversionRate getTaxOfficeRateToIdl() {
        ConversionRate result = this.getTaxOfficeRate();
        if (result == null) {
            result = this.getConversionRate();
        }
        return result;
    }

    public void setTaxOfficeRate(ConversionRate taxOfficeRate) throws BusinessDomainException {
        if (taxOfficeRate != null && taxOfficeRate.getRate() != null && taxOfficeRate.getRate().signum() < 0) {
            throw TransactionExceptionMapper.makeRateForTaxNegativeDomainException();
        }
        this.mTaxOfficeRate = taxOfficeRate;
    }

    public boolean isCZ() {
        return this.getCompany().getJurisdictionType() == JurisdictionType.CZ;
    }

    public boolean isPL() {
        return this.getCompany().getJurisdictionType() == JurisdictionType.PL;
    }

    public void setNoCheckVAT(boolean noCheckVAT) {
        this.mNoCheckVAT = noCheckVAT;
    }

    public boolean getNoCheckVAT() {
        return this.mNoCheckVAT;
    }

    public boolean getJournaliseAdjustments() {
        return this.mJournaliseAdjustments;
    }

    public void setJournaliseAdjustments(boolean journaliseAdjustments) {
        this.mJournaliseAdjustments = journaliseAdjustments;
    }

    public boolean shouldCancelInvoiceAllocation() {
        return this.mShouldCancelInvoiceAllocation;
    }

    public void setShouldCancelInvoiceAllocation(boolean shouldCancel) {
        this.mShouldCancelInvoiceAllocation = shouldCancel;
    }

    public void setFromGenerateDownPayment(boolean fromGenerateDownPayment) {
        this.mFromGenerateDownPayment = fromGenerateDownPayment;
    }

    public boolean getFromGenerateDownPayment() {
        return this.mFromGenerateDownPayment;
    }

    public boolean getIsNLAccountResidueAdjustmentWithBaseTotal() {
        return this.mIsNLAccountResidueAdjustmentWithBaseTotal;
    }

    public void setIsNLAccountResidueAdjustmentWithBaseTotal(boolean nlAccountResidueAdjustmentWithBaseTotal) {
        this.mIsNLAccountResidueAdjustmentWithBaseTotal = nlAccountResidueAdjustmentWithBaseTotal;
    }

    protected boolean changedIsPostedInvoice() {
        return false;
    }

    public boolean getIsPostedInvoice() {
        return false;
    }

    public NLAccountSplit[] getNLAccountSplits() {
        NLAccountSplit[] result = new NLAccountSplit[1];
        NLAccountSplitHeader nlAccountSplitHeadData = new NLAccountSplitHeader(0, null, null, this.getIsInputTax(), this.getCostingAlreadyPosted(), this.getProcessId());
        result[0] = new NLAccountSplit(nlAccountSplitHeadData, this.getNominalEntries(), this.getTaxEntries());
        return result;
    }

    public boolean isCurrencyRevaluationPostingForAllocatedOpenItem() {
        return false;
    }

    public boolean getIsNLAccountOpenItemConversionAdjustment() {
        return this.getUseType() != null && this.getUseType().value() == 1;
    }

    public boolean getIsConsolidationTransaction() {
        this.requireLoaded();
        return this.mIsConsolidationTransaction;
    }

    public void setIsConsolidationTransaction(boolean isConsolidationTransaction) {
        this.mIsConsolidationTransaction = isConsolidationTransaction;
    }

    public void setAddToAccountBalance(boolean addToAccountBalance) {
        this.addToAccountBalance = addToAccountBalance;
    }

    public abstract BankAccountEntry[] getBankAccountEntries();

    public boolean isCreatedAutomatically() {
        return this.getUseType().value() != 0;
    }

    public boolean hasOpenItemPaidBySplitPayment() {
        if (!this.hasOpenItemPaidBySplitPaymentCalculated) {
            this.hasOpenItemPaidBySplitPayment = !this.isNew() ? this.getHasOpenItemPaidBySplitPayment() : false;
            this.hasOpenItemPaidBySplitPaymentCalculated = true;
        }
        return this.hasOpenItemPaidBySplitPayment;
    }

    protected boolean getHasOpenItemPaidBySplitPayment() {
        return false;
    }

    public abstract void setLoadedEntries(NominalLedgerEntry[] var1);

    protected void setEuVatNumber() throws BusinessDomainException {
    }

    public ProcessingStatus getProcessingStatus() {
        if (this.mProcessingStatus == null) {
            this.mProcessingStatus = new ProcessingStatus((INominalTransactionBase)this);
        }
        return this.mProcessingStatus;
    }

    public void setBaseTotalHasBeenEntered(boolean baseTotalHasBeenEntered) {
        this.mBaseTotalHasBeenEntered = baseTotalHasBeenEntered;
    }

    protected void checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType ... notAllowedStatusTypes) throws BusinessDomainException {
        Optional status = this.getProcessingStatus().findFirst(notAllowedStatusTypes);
        if (status.isPresent()) {
            throw TransactionExceptionMapper.makeAmendingNotAllowedErrorMessage((NominalTransactionBase)this, (ProcessingStatus.TransactionStatusType)((ProcessingStatus.TransactionStatusType)status.get()));
        }
    }

    protected void checkIfAmendingAllowed() throws BusinessDomainException {
        this.checkIfAmendingAllowed(true);
    }

    protected void checkIfAmendingAllowed(boolean checkAllocatedItem) throws BusinessDomainException {
        this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION, ProcessingStatus.TransactionStatusType.CANCELLED, ProcessingStatus.TransactionStatusType.HAS_RECONCILED_ITEM, ProcessingStatus.TransactionStatusType.CREATED_VAT_RETURN, ProcessingStatus.TransactionStatusType.CREATED_EC_SALES_LIST, ProcessingStatus.TransactionStatusType.HAS_ALLOCATED_DOWN_PAYMENT_ITEM);
        if (checkAllocatedItem) {
            this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.HAS_ALLOCATED_ITEM);
        }
        this.checkIfAmendingAllowed(ProcessingStatus.TransactionStatusType.HAS_ITEM_INCLUDED_IN_PAYMENT_SESSION, ProcessingStatus.TransactionStatusType.HAS_ITEM_INCLUDED_IN_INSTALMENT, ProcessingStatus.TransactionStatusType.CREATED_CHAMBER_CONTRIBUTION, ProcessingStatus.TransactionStatusType.HAS_ALLOCATED_NLACCOUNT_ITEM);
    }

    protected void checkDescriptions() throws BusinessDomainException {
        NominalLedgerEntry[] nlentries;
        if (!(this.isPL() && this.isPeriodClosed() && this.configuration.isNotAllowedToChangeDescriptionIfPeriodClosedPL())) {
            return;
        }
        for (NominalLedgerEntry nlentry : nlentries = this.getAllEnteredEntries()) {
            if (!nlentry.changedDescription()) continue;
            throw TransactionExceptionMapper.makeAmendingDescriptionNotAllowedBacauseOfClosedPeriodErrorMessage();
        }
    }

    public boolean requiresPaymentEffectiveDate() {
        return this.isInvoiceTransaction();
    }
}

