/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.nlaccountreport;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.nlaccountreport.NLAccountBalanceCostingTypeContainer;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.costing.base.domain.actcostingdata.koabalance.CostTypeReportBalance;
import com.varial.costing.base.domain.actcostingdata.koabalance.CostingSplitKoaBalancePersistencyManager;
import com.varial.costing.base.domain.costtypebase.CostAccountBase;
import com.varial.costing.base.domain.costtypebase.CostTypeBase;
import com.varial.costing.base.domain.costtypebase.CostTypeBasePersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NLAccountBalanceCostingTypeDataSource
implements JRDataSource {
    private static Logger LOGGER = LoggerFactory.getLogger((String)NLAccountBalanceCostingTypeDataSource.class.getName());
    private final ICurrency mCurrency;
    private boolean mHasNext = true;
    private int mNumberOfDistRows = 0;
    private int mCounter = 0;
    private NLAccountBalanceCostingTypeContainer mContainer;
    private NLAccountBalanceCostingTypeContainer[] mContainers;
    private static final String F_OPENINGBALANCE = "F_OpeningBalance";
    private static final String F_DEBIT = "F_Debit";
    private static final String F_CREDIT = "F_Credit";
    private static final String F_BALANCE = "F_Balance";
    private static final String F_OPENINGBALANCE_CREDIT = "F_OpeningBalanceCredit";
    private static final String F_DEBIT_TP = "F_Debit_TP";
    private static final String F_CREDIT_TP = "F_Credit_TP";
    private static final String F_BALANCE_CREDIT = "F_BalanceCredit";
    private static final String F_DESCRIPTION = "F_Description";
    private static final String F_COSTTYPE = "F_CostType";
    private static final int NOSUBCOSTTYPE = 0;
    private boolean mIsSpecialPDFKronospan = false;
    public static TranslateableResourceList mNLAccountBalanceSubCostingTypeReportList = TranslateableResourceList.createTranslateableResourceList((String)"NLAccountBalanceSubCostingTypeReportList", (String[])new String[]{"Ohne KoA"});

    public NLAccountBalanceCostingTypeDataSource(NLAccountCompanySetting accCompSetting, ICurrency currency, Language language, FinancialYear finYear, Date fromDate, Date untilDate, BigDecimal currentOpeningBalance, BigDecimal currentOpeningBalanceCredit, BigDecimal currentOpeningBalanceDebit, BigDecimal currentBalance, BigDecimal currentBalanceCredit, BigDecimal currentBalanceDebit, BigDecimal currentCredit, BigDecimal currentDebit, BigDecimal currentCreditTP, BigDecimal currentDebitTP, boolean isSpecialPDFKronospan) {
        this.mCurrency = currency;
        CostAccountBase cab = accCompSetting.getCostAccountBase();
        CostTypeBase[] ctb = CostTypeBasePersistencyManager.getCostTypes((CostAccountBase)cab);
        this.mNumberOfDistRows = ctb.length;
        this.mIsSpecialPDFKronospan = isSpecialPDFKronospan;
        ArrayList<String> oidList = new ArrayList<String>();
        for (CostTypeBase costTypeBase : ctb) {
            oidList.add(costTypeBase.getObjectid());
        }
        CostTypeReportBalance[] costTypeBalance = CostingSplitKoaBalancePersistencyManager.getCostCentreReportBalancesForAccounting(oidList, (ICurrency)currency, null, (Date)VDate.getDateMin(), (Date)untilDate, (Boolean)false);
        this.mContainers = new NLAccountBalanceCostingTypeContainer[costTypeBalance.length];
        for (int i = 0; i < costTypeBalance.length; ++i) {
            CostTypeBase costTypeBase = CostTypeBasePersistencyManager.getCostTypeBase((String)costTypeBalance[i].oidCostType);
            this.mContainers[i] = new NLAccountBalanceCostingTypeContainer(accCompSetting, finYear, costTypeBase, currency, language, fromDate, untilDate, this.mIsSpecialPDFKronospan);
        }
        ArrayList<NLAccountBalanceCostingTypeContainer> containerList = new ArrayList<NLAccountBalanceCostingTypeContainer>();
        BigDecimal sumOpeningBalance = BigDecimal.ZERO;
        BigDecimal sumDebit = BigDecimal.ZERO;
        BigDecimal sumCredit = BigDecimal.ZERO;
        BigDecimal sumBalance = BigDecimal.ZERO;
        BigDecimal sumOpeningBalanceCredit = BigDecimal.ZERO;
        BigDecimal sumOpeningBalanceDebit = BigDecimal.ZERO;
        BigDecimal sumDebitTP = BigDecimal.ZERO;
        BigDecimal sumCreditTP = BigDecimal.ZERO;
        BigDecimal sumBalanceCredit = BigDecimal.ZERO;
        BigDecimal sumBalanceDebit = BigDecimal.ZERO;
        for (NLAccountBalanceCostingTypeContainer container : this.mContainers) {
            if (this.mIsSpecialPDFKronospan) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)container.getOpeningBalanceCredit()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getOpeningBalanceDebit()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getAmountDebit()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getAmountCredit()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getAmountDebitTP()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getAmountCreditTP()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getBalanceCredit()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getBalanceDebit())) continue;
                containerList.add(container);
                sumDebit = sumDebit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getAmountDebit()));
                sumCredit = sumCredit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getAmountCredit()));
                sumOpeningBalance = sumOpeningBalance.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getOpeningBalance()));
                sumOpeningBalanceCredit = sumOpeningBalanceCredit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getOpeningBalanceCredit()));
                sumOpeningBalanceDebit = sumOpeningBalanceDebit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getOpeningBalanceDebit()));
                sumDebitTP = sumDebitTP.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getAmountDebitTP()));
                sumCreditTP = sumCreditTP.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getAmountCreditTP()));
                sumBalance = sumBalance.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getBalance()));
                sumBalanceCredit = sumBalanceCredit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getBalanceCredit()));
                sumBalanceDebit = sumBalanceDebit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getBalanceDebit()));
                continue;
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)container.getOpeningBalance()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getAmountDebit()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getAmountCredit()) && BigDecimalMapper.isZeroOrNull((BigDecimal)container.getBalance())) continue;
            containerList.add(container);
            sumOpeningBalance = sumOpeningBalance.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getOpeningBalance()));
            sumDebit = sumDebit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getAmountDebit()));
            sumCredit = sumCredit.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getAmountCredit()));
            sumBalance = sumBalance.add(BigDecimalMapper.toBigDecimal((BigDecimal)container.getBalance()));
        }
        if (this.mIsSpecialPDFKronospan) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sumOpeningBalanceDebit: " + sumOpeningBalanceDebit + " / currentOpeningBalanceDebit: " + currentOpeningBalanceDebit);
                LOGGER.debug("sumOpeningBalanceCredit: " + sumOpeningBalanceCredit + " / currentOpeningBalanceCredit: " + currentOpeningBalanceCredit);
                LOGGER.debug("sumDebit: " + sumDebit + " / currentDebit: " + currentDebit);
                LOGGER.debug("sumCredit: " + sumCredit + " / currentCredit: " + currentCredit);
                LOGGER.debug("sumDebitTP: " + sumDebitTP + " / currentDebitTP: " + currentDebitTP);
                LOGGER.debug("sumCreditTP: " + sumCreditTP + " / currentCreditTP: " + currentCreditTP);
                LOGGER.debug("sumBalanceDebit: " + sumBalanceDebit + " / currentBalanceDebit: " + currentBalanceDebit);
                LOGGER.debug("sumBalanceCredit: " + sumBalanceCredit + " / currentBalanceCredit: " + currentBalanceCredit);
            }
            if (sumOpeningBalance.compareTo(currentOpeningBalance) != 0 || sumDebit.compareTo(currentDebit) != 0 || sumCredit.compareTo(currentCredit) != 0 || sumDebitTP.compareTo(currentDebitTP) != 0 || sumCreditTP.compareTo(currentCreditTP) != 0 || sumBalance.compareTo(currentBalance) != 0) {
                BigDecimal openingBalance = currentOpeningBalance.subtract(sumOpeningBalance);
                BigDecimal openingBalanceDebit = BigDecimal.ZERO;
                BigDecimal openingBalanceCredit = BigDecimal.ZERO;
                if (openingBalance.compareTo(BigDecimal.ZERO) < 0) {
                    openingBalanceCredit = openingBalance.negate();
                } else {
                    openingBalanceDebit = openingBalance;
                }
                BigDecimal balance = currentBalance.subtract(sumBalance);
                BigDecimal balanceDebit = BigDecimal.ZERO;
                BigDecimal balanceCredit = BigDecimal.ZERO;
                if (balance.compareTo(BigDecimal.ZERO) < 0) {
                    balanceCredit = balance.negate();
                } else {
                    balanceDebit = balance;
                }
                NLAccountBalanceCostingTypeContainer ohneKoACont = new NLAccountBalanceCostingTypeContainer(BigDecimal.ZERO, currentDebit.subtract(sumDebit), currentCredit.subtract(sumCredit), openingBalanceDebit, openingBalanceCredit, currentDebitTP.subtract(sumDebitTP), currentCreditTP.subtract(sumCreditTP), balanceDebit, balanceCredit, mNLAccountBalanceSubCostingTypeReportList.getString((ILanguage)language, 0));
                containerList.add(ohneKoACont);
                this.mNumberOfDistRows += 2;
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sumOpeningBalance: " + sumOpeningBalance + " / currentOpeningBalance: " + currentOpeningBalance);
                LOGGER.debug("sumDebit: " + sumDebit + " / currentDebit: " + currentDebit);
                LOGGER.debug("sumCredit: " + sumCredit + " / currentCredit: " + currentCredit);
                LOGGER.debug("sumBalance: " + sumBalance + " / currentBalance: " + currentBalance);
            }
            if (sumOpeningBalance.compareTo(currentOpeningBalance) != 0 || sumDebit.compareTo(currentDebit) != 0 || sumCredit.compareTo(currentCredit) != 0 || sumBalance.compareTo(currentBalance) != 0) {
                NLAccountBalanceCostingTypeContainer ohneKoACont = new NLAccountBalanceCostingTypeContainer(currentOpeningBalance.subtract(sumOpeningBalance), currentDebit.subtract(sumDebit), currentCredit.subtract(sumCredit), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, mNLAccountBalanceSubCostingTypeReportList.getString((ILanguage)language, 0));
                containerList.add(ohneKoACont);
                this.mNumberOfDistRows += 2;
            }
        }
        this.mContainers = new NLAccountBalanceCostingTypeContainer[containerList.size()];
        containerList.toArray(this.mContainers);
        Arrays.sort(this.mContainers, NLAccountBalanceCostingTypeContainer.getComparator());
    }

    public int getNumberOfRecords() {
        if (this.mContainers == null) {
            return 0;
        }
        return this.mContainers.length;
    }

    public boolean getHasNext() {
        return this.mHasNext;
    }

    public boolean getPrintCostingTypeDistribution() {
        return this.mNumberOfDistRows > 1;
    }

    public boolean next() throws JRException {
        boolean result = false;
        try {
            result = this.mHasNext = this.mCounter < this.mContainers.length;
            this.mContainer = this.mHasNext ? this.mContainers[this.mCounter] : null;
            ++this.mCounter;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (this.mContainer != null) {
            try {
                if (F_OPENINGBALANCE.equals(field.getName())) {
                    value = this.mIsSpecialPDFKronospan ? this.mContainer.getOpeningBalanceDebit() : this.mContainer.getOpeningBalance();
                } else if (F_OPENINGBALANCE_CREDIT.equals(field.getName())) {
                    value = this.mContainer.getOpeningBalanceCredit();
                } else if (F_DEBIT.equals(field.getName())) {
                    value = this.mContainer.getAmountDebit();
                } else if (F_CREDIT.equals(field.getName())) {
                    value = this.mContainer.getAmountCredit();
                } else if (F_DEBIT_TP.equals(field.getName())) {
                    value = this.mContainer.getAmountDebitTP();
                } else if (F_CREDIT_TP.equals(field.getName())) {
                    value = this.mContainer.getAmountCreditTP();
                } else if (F_BALANCE.equals(field.getName())) {
                    value = this.mIsSpecialPDFKronospan ? this.mContainer.getBalanceDebit() : this.mContainer.getBalance();
                } else if (F_BALANCE_CREDIT.equals(field.getName())) {
                    value = this.mContainer.getBalanceCredit();
                } else if (F_DESCRIPTION.equals(field.getName())) {
                    value = this.mContainer.getDescription();
                } else if (F_COSTTYPE.equals(field.getName())) {
                    value = this.mContainer.getCostTypeCode();
                }
                if (value instanceof String) {
                    value = StringUtil.toJasperString((String)((String)value));
                } else if (value instanceof BigDecimal) {
                    value = this.mCurrency.round((BigDecimal)value);
                }
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
            }
        }
        return value;
    }
}

