/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.eaudit.export.v35.record.builder;

import com.varial.accounting.domain.eaudit.IEAuditSession;
import com.varial.accounting.domain.eaudit.export.common.context.AccountExportContext;
import com.varial.accounting.domain.eaudit.export.common.criteria.EAuditExportCriteria;
import com.varial.accounting.domain.eaudit.export.common.types.EAuditFieldType;
import com.varial.accounting.domain.eaudit.export.v35.record.builder.AbstractEAuditRecordBuilder;
import com.varial.accounting.domain.eaudit.validation.EAuditErrorMessage;
import com.varial.accounting.domain.nlaccountreport.BalanceSheetType;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.domain.errormessage.TranslatableErrorMessage;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Map;

public class EAuditAccountRecordBuilder
extends AbstractEAuditRecordBuilder<EAuditAccountRecordBuilder> {
    private static final String RECORD_TYPE = "DSKT";
    private static final String RECORD_VERSION = "01";
    private static final int ACCOUNT_DESCRIPTION_LENGTH = 150;
    private static final Map<BalanceSheetType, String> BALANCE_SHEET_TYPE_MAP = Map.of(BalanceSheetType.TAX_LAW, "0", BalanceSheetType.COMMERCIAL_LAW, "1");

    private EAuditAccountRecordBuilder balanceSheetType(IEAuditSession session) throws BusinessDomainException {
        return (EAuditAccountRecordBuilder)((Object)this.appendCheckedField(1, this.mapBalanceSheetType(session.getBalanceSheetType()), EAuditFieldType.BALANCE_SHEET_TYPE));
    }

    private String mapBalanceSheetType(BalanceSheetType balanceSheetType) {
        return balanceSheetType != null ? BALANCE_SHEET_TYPE_MAP.get(balanceSheetType) : null;
    }

    public EAuditAccountRecordBuilder createAccount(IEAuditSession session, EAuditExportCriteria criteria, AccountExportContext context) throws BusinessDomainException {
        return (EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)((EAuditAccountRecordBuilder)((Object)this.recordType())).eubpProcedure())).senderNumber(session))).receiverNumber(session))).recordVersion())).createdNow())).noError())).noError())).sysId())).companyCode(session))).balanceSheetType(session).accountType())).accountCode(context))).dateFrom(criteria))).dateTo(criteria))).accountDescription(context).waSupplier().startBalanceDebit(context).startBalanceCredit(context).yearBalanceDebit(context).yearBalanceCredit(context).endFlag());
    }

    private EAuditAccountRecordBuilder accountDescription(AccountExportContext context) throws BusinessDomainException {
        String description = this.eAuditConverter.convert(context.getAccountInfo().getDescription());
        if (StringMapper.isNullString((String)description)) {
            throw ExceptionMapper.makeDomainException((TranslatableErrorMessage)EAuditErrorMessage.ACCOUNT_DESCRIPTION_MISSING, (String)context.getAccountInfo().getAccountCode());
        }
        return (EAuditAccountRecordBuilder)this.appendField(150, description);
    }

    private EAuditAccountRecordBuilder waSupplier() {
        return (EAuditAccountRecordBuilder)this.appendField(150, " ");
    }

    private EAuditAccountRecordBuilder startBalanceDebit(AccountExportContext context) {
        return (EAuditAccountRecordBuilder)((Object)this.appendSignedAmount(context.getStartBalance().getTotalDebit()));
    }

    private EAuditAccountRecordBuilder startBalanceCredit(AccountExportContext context) {
        return (EAuditAccountRecordBuilder)((Object)this.appendSignedAmount(context.getStartBalance().getTotalCredit()));
    }

    private EAuditAccountRecordBuilder yearBalanceDebit(AccountExportContext context) {
        return (EAuditAccountRecordBuilder)((Object)this.appendSignedAmount(context.getYearBalance().getTotalDebit()));
    }

    private EAuditAccountRecordBuilder yearBalanceCredit(AccountExportContext context) {
        return (EAuditAccountRecordBuilder)((Object)this.appendSignedAmount(context.getYearBalance().getTotalCredit()));
    }

    @Override
    protected String getRecordType() {
        return RECORD_TYPE;
    }

    @Override
    protected String getRecordVersion() {
        return RECORD_VERSION;
    }

    protected EAuditAccountRecordBuilder self() {
        return this;
    }
}

