/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.eaudit.export.v35.record.builder;

import com.varial.accounting.domain.eaudit.IEAuditSession;
import com.varial.accounting.domain.eaudit.export.common.content.core.EAuditIdentifierProvider;
import com.varial.accounting.domain.eaudit.export.common.context.AccountExportContext;
import com.varial.accounting.domain.eaudit.export.common.criteria.EAuditExportCriteria;
import com.varial.accounting.domain.eaudit.export.common.types.EAuditFieldType;
import com.varial.accounting.domain.eaudit.export.v35.formatting.EAuditCharacterConverter;
import com.varial.accounting.domain.eaudit.export.v35.record.builder.AbstractRecordBuilder;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.errormessage.TranslatableErrorMessage;
import com.varial.serverbase.domain.textoutput.NumberFormatUtils;
import com.varial.serverbase.domain.textoutput.OutputCharacterConverter;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.eclipse.jetty.util.StringUtil;

public abstract class AbstractEAuditRecordBuilder<T extends AbstractEAuditRecordBuilder<T>>
extends AbstractRecordBuilder<T> {
    private static final String EUBP_PROCEDURE = "EUBP";
    private static final String DATA_EXCHANGE_TYPE = "AGBPF";
    private static final int AMOUNT_LENGTH = 25;
    private static final String ACCOUNT_TYPE = "0";
    private static final int ACCOUNT_CODE_LENGTH = 35;
    private static final int COMPANY_CODE_LENGTH = 100;
    protected final OutputCharacterConverter eAuditConverter = new EAuditCharacterConverter();

    protected T companyNumber(String number, EAuditFieldType numberType) throws BusinessDomainException {
        return this.appendCheckedField(15, number, numberType);
    }

    protected T appendDateField(Date date) {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(8, DateMapper.toYYYYMMDDString((Date)date))));
    }

    protected T dateFrom(EAuditExportCriteria filter) {
        return this.appendDateField(filter.getDateFrom());
    }

    protected T dateTo(EAuditExportCriteria filter) {
        return this.appendDateField(filter.getDateTo());
    }

    protected T appendCheckedField(int length, String value, EAuditFieldType fieldType) throws BusinessDomainException {
        if (StringUtil.isEmpty((String)value) && fieldType.isMandatory()) {
            throw ExceptionMapper.makeDomainException((TranslatableErrorMessage)((TranslatableErrorMessage)fieldType.getMissingErrorMessage().orElseThrow(() -> new IllegalStateException("Missing error message for mandatory field: " + fieldType))));
        }
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(length, value)));
    }

    protected T localDateTime(int length, LocalDateTime localDateTime) {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(length, localDateTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSSSSS")))));
    }

    protected T dataExchangeType() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(5, DATA_EXCHANGE_TYPE)));
    }

    protected T senderNumber(IEAuditSession session) throws BusinessDomainException {
        return this.companyNumber(this.eAuditConverter.convert(session.getSenderNumber()), EAuditFieldType.SENDER_NUMBER);
    }

    protected T receiverNumber(IEAuditSession session) throws BusinessDomainException {
        return this.companyNumber(this.eAuditConverter.convert(session.getReceiverNumber()), EAuditFieldType.RECEIVER_NUMBER);
    }

    protected T createdToday() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(8, DateMapper.toYYYYMMDDString((Date)DateHelper.today()))));
    }

    protected T createdNow() {
        return this.localDateTime(17, LocalDateTime.now());
    }

    protected T fileNumber(int fileNumber) {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendNumericField(6, fileNumber)));
    }

    protected T eubpProcedure() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(5, EUBP_PROCEDURE)));
    }

    protected T recordType() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(4, this.getRecordType())));
    }

    protected T recordVersion() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(2, this.getRecordVersion())));
    }

    protected T blank(int length) {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(length, "")));
    }

    protected T noError() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(1, ACCOUNT_TYPE)));
    }

    protected T endFlag() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(1, "E")));
    }

    protected T appendSignedAmount(BigDecimal amount) {
        String sign = amount != null && amount.signum() < 0 ? "-" : " ";
        return ((AbstractEAuditRecordBuilder)this.appendField(1, sign)).appendAmount(amount, 25, 2);
    }

    protected T appendAmount(BigDecimal value, int totalLength, int decimalPlaces) {
        if (value == null) {
            return (T)((Object)((AbstractEAuditRecordBuilder)this.appendNumericField(totalLength, 0)));
        }
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(totalLength, NumberFormatUtils.toZeroPaddedNumericString((BigDecimal)value, (int)totalLength, (int)decimalPlaces))));
    }

    protected T auditedCompanyNumber(IEAuditSession session) throws BusinessDomainException {
        return this.companyNumber(this.eAuditConverter.convert(session.getAuditedCompanyNumber()), EAuditFieldType.AUDITED_COMPANY_NUMBER);
    }

    protected abstract String getRecordType();

    protected abstract String getRecordVersion();

    protected T accountType() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(1, ACCOUNT_TYPE)));
    }

    protected T accountCode(AccountExportContext context) throws BusinessDomainException {
        return this.accountCode(context.getAccountInfo().getAccountCode());
    }

    protected T accountCode(String accountCode) throws BusinessDomainException {
        return this.appendCheckedField(35, this.eAuditConverter.convert(accountCode), EAuditFieldType.ACCOUNT_CODE);
    }

    protected T companyCode(IEAuditSession session) {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(100, this.eAuditConverter.convert(session.getAccountingCompany().getCode()))));
    }

    protected T sysId() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(100, EAuditIdentifierProvider.getSysId())));
    }

    protected T noEInvoice() {
        return (T)((Object)((AbstractEAuditRecordBuilder)this.appendField(1, ACCOUNT_TYPE)));
    }
}

