/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.bankstatementposting.matching.returndebitnote.strategy;

import com.varial.accounting.domain.bankstatementposting.BankStatementEntry;
import com.varial.accounting.domain.bankstatementposting.matching.returndebitnote.strategy.ReturnDebitNoteStrategy;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;

public class DefaultReturnDebitNoteStrategy
implements ReturnDebitNoteStrategy {
    private static final String[] ORIGINAL_AMOUNTS = new String[]{"ORIGINALBETRAG", "OAMT+"};
    private static final String[] REFERENCE_NUMBERS = new String[]{"EREF+"};

    @Override
    public BigDecimal getCharges(BankStatementEntry entry) {
        if (entry.getBankStatementPostingSession().getASCIITransferFormat() != null || entry.getBankStatementPostingSession().getTransferFormatType().value() == 4) {
            BigDecimal originalAmount = this.getOriginalAmount(entry);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)originalAmount)) {
                return entry.getPaymentAmount().abs().subtract(originalAmount);
            }
        } else {
            return entry.getBankStatementFieldManager().getCharges();
        }
        return null;
    }

    @Override
    public BigDecimal getOriginalAmount(BankStatementEntry entry) {
        String amountS = this.extractString(entry, ORIGINAL_AMOUNTS);
        if (StringMapper.isNullString((String)amountS)) {
            return null;
        }
        try {
            return BigDecimalMapper.toBigDecimal((String)amountS, (char)',', (char)'.');
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getReferenceNumber(BankStatementEntry entry) {
        return this.extractString(entry, REFERENCE_NUMBERS);
    }

    private String extractString(BankStatementEntry entry, String[] searchStrings) {
        String reasonsForPayment = entry.getReasonsForPaymentManager().getReasonsForPaymentWithoutYear();
        if (StringMapper.isNullString((String)reasonsForPayment)) {
            return null;
        }
        int pos = 0;
        for (String s : searchStrings) {
            pos = reasonsForPayment.indexOf(s);
            if (pos < 0) continue;
            pos += s.length();
            break;
        }
        if (pos < 0) {
            return null;
        }
        StringBuffer sTmp1 = new StringBuffer();
        char[] charsTmp1 = reasonsForPayment.toCharArray();
        for (int i = pos; i < charsTmp1.length; ++i) {
            if (charsTmp1[i] == ' ') continue;
            String s1 = reasonsForPayment.substring(i, reasonsForPayment.length());
            sTmp1.append(s1);
            break;
        }
        char[] charsTmp2 = sTmp1.toString().toCharArray();
        StringBuffer sTmp2 = new StringBuffer();
        for (int i = 0; i < charsTmp2.length && charsTmp2[i] != ' '; ++i) {
            sTmp2.append(charsTmp2[i]);
        }
        return sTmp2.toString();
    }
}

