/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.servantimpl.eubp;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.deuv.deuvsending.DEUVSending;
import com.varial.personnel.domain.deuv.deuvsending.DEUVSendingPersistencyManager;
import com.varial.personnel.domain.eubp.EubpAccountFilterStruct;
import com.varial.personnel.domain.eubp.EubpAccountStruct;
import com.varial.personnel.domain.eubp.EubpApStruct;
import com.varial.personnel.domain.eubp.EubpDsstStruct;
import com.varial.personnel.domain.eubp.EubpInfoStruct;
import com.varial.personnel.domain.eubp.EubpMandant;
import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.dsst.EubpDsst;
import com.varial.personnel.domain.eubp.dsst.EubpDsstPersistencyManager;
import com.varial.personnel.domain.eubp.dsst.mapper.EubpDsstMapper;
import com.varial.personnel.domain.eubp.mapper.EubpAccountMapper;
import com.varial.personnel.domain.eubp.mapper.EubpExceptionMapper;
import com.varial.personnel.domain.eubp.mapper.EubpMandantMapper;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.reports.eubp.EubpAccountFilterQuery;
import com.varial.personnel.domain.reports.eubp.EubpsCreator;
import com.varial.personnel.domain.reports.eubp.Mandanten;
import com.varial.personnel.domain.reports.eubp.MandantenMap;
import com.varial.personnel.domain.reports.eubp.PCompanyWithPeriods;
import com.varial.personnel.domain.reports.eubp.PlantPlaceWithPeriods;
import com.varial.personnel.domain.reports.eubp.PlantWithPeriods;
import com.varial.personnel.domain.reports.eubp.cancel.EubpCancelAccountReport;
import com.varial.personnel.domain.reports.eubp.receive.EubpReceiveProtocolReport;
import com.varial.personnel.domain.reports.eubp.statementsOfContribution.StatementOfContributionForEubpCreator;
import com.varial.personnel.framework.access.PersonnelRightList;
import com.varial.personnel.framework.basictypes.Communication;
import com.varial.personnel.framework.checkup.EMailAddress;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.personnel.servantimpl.employee.SpecialAccessServantBase;
import com.varial.personnel.servantimpl.eubp.EubpServantService;
import com.varial.serverbase.mapper.DateMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class EubpServantImpl
extends SpecialAccessServantBase
implements EubpServantService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EubpInfoStruct[] getEubpInfos(AuthorizationToken token, String companyNumber, String deliveryDate, int yearFrom, int yearUntil) throws BusinessDomainException {
        try {
            Date validUntil;
            token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            Date validFrom = this.toValidFrom(yearFrom);
            Date effectiveDate = validUntil = this.getValidUntil(yearUntil);
            if (companyNumber.length() != 8) {
                throw EubpExceptionMapper.makeIllegalLengthCompanyNumber(companyNumber);
            }
            MandantenMap mandantenMap = new MandantenMap(companyNumber, effectiveDate, validFrom, validUntil);
            TreeSet betriebsnummern = new TreeSet(mandantenMap.getMandantenMap().keySet());
            ArrayList<EubpMandant> list = new ArrayList<EubpMandant>();
            for (String betriebsnummer : betriebsnummern) {
                Mandanten mandanten = mandantenMap.getMandanten(betriebsnummer);
                for (PCompanyWithPeriods pCompany : mandanten.getPCompanys()) {
                    list.add(new EubpMandant(pCompany.getPCompany()));
                }
                for (PlantWithPeriods plant : mandanten.getPlants()) {
                    list.add(new EubpMandant(plant.getPlant()));
                }
                for (PlantPlaceWithPeriods plantPlace : mandanten.getPlantPlaces()) {
                    list.add(new EubpMandant(plantPlace.getPlantPlace()));
                }
            }
            EubpInfoStruct[] eubpInfoStructArray = EubpMandantMapper.toInfoStruct(list, (Date)mandantenMap.getValidUntil());
            return eubpInfoStructArray;
        }
        finally {
            this.endService();
        }
    }

    public EubpApStruct getApInfos(AuthorizationToken token, String companyNumber, String deliveryDate, int yearFrom, int yearUntil) throws BusinessDomainException {
        Date validUntil;
        token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
        this.setTokenForSpecialAccess(token);
        this.beginQueryService();
        Date validFrom = this.toValidFrom(yearFrom);
        Date effectiveDate = validUntil = this.getValidUntil(yearUntil);
        MandantenMap mandantenMap = new MandantenMap(companyNumber, effectiveDate, validFrom, validUntil);
        Mandanten mandanten = mandantenMap.getMandanten(companyNumber);
        DEUVSenderTP deuvSenderTP = mandanten.getDEUVSenderTP(effectiveDate, validUntil);
        if (deuvSenderTP == null) {
            throw EubpExceptionMapper.makeDEUVSenderNotFoundException(validUntil);
        }
        Communication communication = deuvSenderTP.getCommunication();
        return new EubpApStruct(communication.getContactPerson(), communication.getTelephoneNumber(), communication.getEMailAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEubpAccount(AuthorizationToken token, int gddue, boolean isZustellung, String emailAddress, boolean isFragebogen, boolean kennzLstAp, int kennzWg, boolean kennzFamilieMitarbeit, String nameAp, String telAp, String emailAp, String companyNumber, String deliveryDate, int yearFrom, int yearUntil, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
            this.setTokenForSpecialAccess(token);
            if (isZustellung) {
                if (emailAddress == null || emailAddress.isBlank()) {
                    throw EubpExceptionMapper.makeEmailEmptyException();
                }
                new EMailAddress(emailAddress).check();
            }
            if (isFragebogen) {
                if (nameAp == null || nameAp.isBlank()) {
                    throw EubpExceptionMapper.makeNameApEmptyException();
                }
                if (telAp == null || telAp.isBlank()) {
                    throw EubpExceptionMapper.makeTelApEmptyException();
                }
                if (emailAp == null || emailAp.isBlank()) {
                    throw EubpExceptionMapper.makeEmailApEmptyException();
                }
                if (!EubpServantImpl.isDIN5008(telAp)) {
                    throw EubpExceptionMapper.makeTelApNotDIN5008Exception();
                }
                new EMailAddress(emailAp).check();
            }
            this.beginUpdateService();
            EubpsCreator command = new EubpsCreator(token, callback, gddue, isZustellung, emailAddress, isFragebogen, kennzLstAp, kennzWg, kennzFamilieMitarbeit, nameAp, telAp, emailAp, companyNumber, DateMapper.toDate((String)deliveryDate), this.toValidFrom(yearFrom), this.getValidUntil(yearUntil));
            lazyRunnable.setLowPriorityRunnable((Runnable)((Object)command));
        }
        finally {
            this.endService();
        }
    }

    private static boolean isDIN5008(String telefonnummer) {
        String regEx = "^\\+[1-9][0-9]* [0-9 ]+(-[0-9]+)?|0[1-9][0-9]* [1-9][0-9 ]*(-[0-9]+)?$";
        return Pattern.matches("^\\+[1-9][0-9]* [0-9 ]+(-[0-9]+)?|0[1-9][0-9]* [1-9][0-9 ]*(-[0-9]+)?$", telefonnummer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EubpAccountStruct[] getEubpAccounts(AuthorizationToken token, EubpAccountFilterStruct filter) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            String companyNumber = filter.bbnr;
            if (companyNumber.length() != 0 && companyNumber.length() != 8) {
                throw EubpExceptionMapper.makeIllegalLengthCompanyNumber(companyNumber);
            }
            EubpAccountStruct[] eubpAccountStructArray = EubpAccountMapper.toIdl((EubpAccount[])EubpAccountFilterQuery.getEubpAccounts((EubpAccountFilterStruct)filter));
            return eubpAccountStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EubpDsstStruct[] getEubpDssts(AuthorizationToken token, String oidEubpAcount) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            EubpDsstPersistencyManager pm = EubpDsstPersistencyManager.getInstance();
            EubpDsst[] eubpDssts = pm.query(new Order[]{Order.asc((String)"FILENUMBER")}, Restrictions.eq((String)"OIDEUBPACCOUNT", (String)oidEubpAcount), true);
            EubpDsstStruct[] eubpDsstStructArray = EubpDsstMapper.toIdl((EubpDsst[])eubpDssts);
            return eubpDsstStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEubpAccount(AuthorizationToken token, String oidEubpAccount, int versionEubpAccount) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
            this.beginUpdateService();
            EubpAccount eubpAccount = new EubpAccount(oidEubpAccount, versionEubpAccount);
            eubpAccount.makeDeletion();
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEubpAccount(AuthorizationToken token, String oidEubpAccount, int versionEubpAccount, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EubpCancelAccountReport command = new EubpCancelAccountReport(token, callback, oidEubpAccount, versionEubpAccount);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveEubpResponses(AuthorizationToken token, String oidDEUVSender, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEubpFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EubpReceiveProtocolReport command = new EubpReceiveProtocolReport(token, callback, oidDEUVSender);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStatementOfContributionForEubp(AuthorizationToken token, String validFrom, String validUntil, String oidPcompany, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getPrintStatementOfContributionRight(), oidPcompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            StatementOfContributionForEubpCreator creator = new StatementOfContributionForEubpCreator(token, callback, oidPcompany, DateMapper.toDate((String)validFrom), DateMapper.toDate((String)validUntil));
            lazyRunnable.setLowPriorityRunnable((Runnable)creator);
        }
        finally {
            this.endService();
        }
    }

    private Date toValidFrom(int yearFrom) {
        return DateHelper.max((Date)PersonnelBasic.getPersonnelBasic().getSystemStart(), (Date)DateHelper.parse((String)(yearFrom - 1 + "-01-01")));
    }

    private Date toValidUntil(int yearUntil) {
        return DateHelper.parse((String)(yearUntil + "-12-31"));
    }

    private Date getValidUntil(int year) {
        DEUVSending[] deuvSendings = DEUVSendingPersistencyManager.query((Order[])new Order[]{Order.desc((String)"DATEOFSENDING")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"TYPEOFSENDING", (String)"1"), Restrictions.sqlRestriction((String)"DATEOFSENDING = (SELECT MAX(DATEOFSENDING) FROM DEUVSENDING_T A WHERE A.TYPEOFSENDING = 1)")}));
        return deuvSendings.length == 0 ? this.toValidUntil(year) : deuvSendings[0].getDateofSending();
    }
}

