/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.framework;

import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class PFileHelper {
    public static String getAbsoluteFolderForWrite(String path) throws BusinessDomainException {
        return PFileHelper.getAbsoluteFolderForWrite(path, "Der Pfad");
    }

    public static String getAbsoluteFolderForWrite(String path, String prefix) throws BusinessDomainException {
        if (StringMapper.isNullString((String)path)) {
            throw FrameWorkExceptionMapper.makePathIsMissedDomainException((String)prefix);
        }
        File directory = new File(path);
        PFileHelper.checkFolderForWrite(directory, prefix);
        return directory.getAbsolutePath();
    }

    public static File checkFolderForWrite(File directory, String prefix) throws BusinessDomainException {
        PFileHelper.checkFolder(directory, prefix);
        if (!directory.canWrite()) {
            throw FrameWorkExceptionMapper.makePathIsNotWriteableDomainException((String)prefix, (String)directory.getAbsolutePath());
        }
        return directory;
    }

    public static File checkFolder(File directory, String prefix) throws BusinessDomainException {
        PFileHelper.checkForRead(directory, prefix);
        if (!directory.isDirectory()) {
            throw FrameWorkExceptionMapper.makePathIsNotDirectoryDomainException((String)prefix, (String)directory.getAbsolutePath());
        }
        return directory;
    }

    public static File checkFile(File document, String prefix) throws BusinessDomainException {
        PFileHelper.checkForRead(document, prefix);
        if (!document.isFile()) {
            throw FrameWorkExceptionMapper.makePathIsNotFileDomainException((String)prefix, (String)document.getAbsolutePath());
        }
        return document;
    }

    public static void checkForRead(File file, String prefix) throws BusinessDomainException {
        if (!file.exists()) {
            throw FrameWorkExceptionMapper.makePathNotExistsDomainException((String)prefix, (String)file.getPath());
        }
        if (!file.canRead()) {
            throw FrameWorkExceptionMapper.makePathIsNotReadableDomainException((String)prefix, (String)file.getAbsolutePath());
        }
    }

    public static LinkedList<String> getFileLines(File file, String charset) {
        LinkedList<String> lines = new LinkedList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            while ((line = reader.readLine()) != null) {
                if (StringMapper.isNullString((String)line)) continue;
                lines.add(line);
            }
            reader.close();
        }
        catch (IOException e) {
            lines.clear();
        }
        return lines;
    }

    public static CharSequence getFileContent(File input, String charset) {
        return PFileHelper.getFileContent(input, charset, Integer.MAX_VALUE);
    }

    public static CharSequence getFileContent(File input, String charset, int length) {
        StringBuilder b = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), charset));
            while (reader.ready() && b.length() < length) {
                b.append((char)reader.read());
            }
            reader.close();
        }
        catch (IOException e) {
            b.setLength(0);
        }
        return b;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static File appendToName(File file, String identifier) {
        return new File(file.getParent() + File.separatorChar + PFileHelper.name(file) + identifier + PFileHelper.extension(file));
    }

    public static String extension(File file) {
        int index = file.getName().indexOf(46);
        if (index < 0) {
            return "";
        }
        return file.getName().substring(index);
    }

    public static String name(File file) {
        int index = file.getName().indexOf(46);
        if (index < 0) {
            return file.getName();
        }
        return file.getName().substring(0, index);
    }

    public static File yieldFor(File destination) {
        if (destination.exists()) {
            File renamed = destination;
            int i = 1;
            while (renamed.exists()) {
                renamed = PFileHelper.appendToName(destination, "_" + i);
                ++i;
            }
            if (!new File(destination.getAbsolutePath()).renameTo(renamed)) {
                throw new IllegalStateException("Rename " + destination + " to " + renamed + " failed");
            }
        }
        return destination;
    }

    public static final List<Path> listAllFilesInDir(Path directory) {
        ArrayList<Path> allFiles = new ArrayList<Path>();
        if (Files.exists(directory, new LinkOption[0]) && Files.isDirectory(directory, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                    allFiles.add(path);
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                throw new ApplicationException(e.getMessage(), (Throwable)e);
            }
        }
        return allFiles;
    }

    public static LocalDate getLastModified(Path file) {
        try {
            return DateHelper.toLocalDate((Instant)Files.getLastModifiedTime(file, new LinkOption[0]).toInstant());
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public static String getExtension(Path path) {
        String fileName = path.getFileName().toString();
        int index = fileName.lastIndexOf(46);
        if (index < 0 || index == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(index + 1);
    }
}

