/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetaxcertificate;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.library.EmployerBean;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;

public class WageTaxCertificateHelper {
    public boolean isRelevantForReport(EmployeeForReport employee, Date dateOfWithDrawal, Date returnCalculationDate, Date listEndDate) {
        return this.isRelevantForReport(employee, listEndDate, dateOfWithDrawal, returnCalculationDate, listEndDate);
    }

    public boolean isRelevantForReport(EmployeeForReport employee, Date effectiveDate, Date dateOfWithDrawal, Date returnCalculationDate, Date listEndDate) {
        return WageTaxCertificateHelper.isTaxIDPresent(employee, listEndDate) && (dateOfWithDrawal != null && DateHelper.beforeOrEqual((Date)dateOfWithDrawal, (Date)listEndDate) && DateHelper.beforeOrEqual((Date)returnCalculationDate, (Date)dateOfWithDrawal) || dateOfWithDrawal != null && PDateHelper.getDiffInMonths((Date)dateOfWithDrawal, (Date)listEndDate) == 0 && DateHelper.beforeOrEqual((Date)dateOfWithDrawal, (Date)employee.getEmploymentValidUntil()) || dateOfWithDrawal != null && WageTaxCertificateHelper.isDecember(listEndDate) && DateHelper.after((Date)dateOfWithDrawal, (Date)listEndDate) || dateOfWithDrawal == null && WageTaxCertificateHelper.isDecember(listEndDate) || WageTaxCertificateHelper.isChangeInEmploymentToGfB(employee, effectiveDate, returnCalculationDate, listEndDate));
    }

    protected static boolean isDecember(Date date) {
        return new VDate(date).getMonth() == 11;
    }

    private static boolean isChangeInEmploymentToGfB(EmployeeForReport efr, Date effectivDate, Date from, Date until) {
        Employee employee = WageTaxCertificateHelper.getIEmployeePM().getEmployee(efr.getOidEmployee());
        Date date = from;
        while (DateHelper.beforeOrEqual((Date)date, (Date)DateHelper.getLastDayOfMonth((Date)until))) {
            if (WageTaxCertificateHelper.isChangeInEmploymentToGfB(employee, effectivDate, date)) {
                return true;
            }
            date = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)date));
        }
        return false;
    }

    private static boolean isChangeInEmploymentToGfB(Employee employee, Date effectiveDate, Date date) {
        Date previousMonth = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate));
        Tax tax = employee.getTaxOrNull(effectiveDate, date);
        Tax taxPreviousMonth = employee.getTaxOrNull(previousMonth, date);
        return taxPreviousMonth != null && !WageTaxCertificateHelper.isGfB(taxPreviousMonth.getTaxacation()) && tax != null && WageTaxCertificateHelper.isGfB(tax.getTaxacation());
    }

    private static boolean isTaxIDPresent(EmployeeForReport efr, Date date) {
        if (new VDate(date).getYear() >= 2023) {
            Employee employee = WageTaxCertificateHelper.getIEmployeePM().getEmployee(efr.getOidEmployee());
            Tax tax = employee.getTaxOrNull(VDate.getDateMax(), date);
            String taxID = "";
            if (tax != null) {
                taxID = tax.getTin();
            }
            return !StringMapper.isNullString((String)taxID);
        }
        return true;
    }

    public static boolean isGfB(TaxacationEnum te) {
        switch (te.value()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public Date getDateOfEntry(String oidEmployee, Date dateOfEntry, Date effectiveDate, Date validDate) throws BusinessDomainException {
        return dateOfEntry;
    }

    public Date getDateOfWithDrawal(String oidEmployee, Date dateOfWithDrawal, Date effectiveDate, Date validDate) throws BusinessDomainException {
        return dateOfWithDrawal;
    }

    public String getPlantDescription(EmployerBean employerBean) {
        return employerBean.getPlantLongDescription();
    }

    public String getPlantStreetStreetNumber(EmployerBean employerBean) {
        return employerBean.getPlantStreet();
    }

    public String getPlantPostalCode(EmployerBean employerBean) {
        return employerBean.getPlantPostalcode();
    }

    public String getPlantCity(EmployerBean employerBean) {
        return employerBean.getPlantCity();
    }

    public String getPlantNumber(EmployerBean employerBean) {
        return employerBean.getPlantPostalcode() + " " + employerBean.getPlantCity();
    }

    public Date getCalculationStartDate(CompanyFoundations companyFoundations) {
        return companyFoundations.getCalculationStart();
    }

    public Date getCurrentEmployeeFirstDate(EmployeeForReport efr, Date listFirstDate, Date listEndDate) {
        return DateHelper.max((Date[])new Date[]{WageTaxCertificateHelper.getGfBFirstDate(efr, listFirstDate, listEndDate), efr.getDateOfEntry(), listFirstDate});
    }

    private static Date getGfBFirstDate(EmployeeForReport efr, Date from, Date until) {
        Employee employee = WageTaxCertificateHelper.getIEmployeePM().getEmployee(efr.getOidEmployee());
        Date date = DateHelper.getFirstDayOfMonth((Date)until);
        while (DateHelper.afterOrEqual((Date)date, (Date)from)) {
            if (WageTaxCertificateHelper.isChangeInEmploymentFromGfB(employee, date)) {
                return date;
            }
            date = DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)date));
        }
        return from;
    }

    private static boolean isChangeInEmploymentFromGfB(Employee employee, Date date) {
        Date previousMonth = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)date));
        Tax tax = employee.getTaxOrNull(VDate.getDateMax(), date);
        Tax taxPreviousMonth = employee.getTaxOrNull(VDate.getDateMax(), previousMonth);
        return taxPreviousMonth != null && WageTaxCertificateHelper.isGfB(taxPreviousMonth.getTaxacation()) && tax != null && !WageTaxCertificateHelper.isGfB(tax.getTaxacation());
    }

    public boolean hatAnzahlUVorBescheinigungsbeginn(EmployeeForReport efr, Date effectiveFrom, Date listFirstDate) throws BusinessDomainException {
        return false;
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

