/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.statementofcontributionzvk;

import com.varial.personnel.domain.reports.StringComparator;
import com.varial.personnel.domain.reports.statementofcontributionzvk.StatementOfContributionZVKReportBean;
import com.varial.personnel.framework.multikeymap.MultiKeyHashMap2;
import com.varial.personnel.framework.multikeymap.MultiKeyMap2;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StatementOfContributionZVKReportBeans {
    private final MultiKeyMap2<String, String, PersonalnummerToBeansMap> beanMap = new MultiKeyHashMap2();
    private int size = 0;
    private final String filterRecipientDescription;

    public StatementOfContributionZVKReportBeans(String filterRecipientDescription) {
        this.filterRecipientDescription = StringMapper.toStringOrNull((String)filterRecipientDescription);
    }

    public boolean add(StatementOfContributionZVKReportBean bean) {
        boolean added;
        String key1 = bean.getBetriebsstaette_VWE_Nr();
        String key2 = bean.getRecipient_key();
        if (this.filterRecipientDescription != null && !StringMapper.equal((String)this.filterRecipientDescription, (String)key2)) {
            return false;
        }
        PersonalnummerToBeansMap beans = (PersonalnummerToBeansMap)this.beanMap.get((Object)key1, (Object)key2);
        if (beans == null) {
            beans = new PersonalnummerToBeansMap();
            this.beanMap.put((Object)key1, (Object)key2, (Object)beans);
        }
        if (added = beans.add(bean)) {
            ++this.size;
        }
        return added;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterator<StatementOfContributionZVKReportBean> iterator() {
        ZVKComparator zvkComparator = new ZVKComparator();
        ArrayList<StatementOfContributionZVKReportBean> list = new ArrayList<StatementOfContributionZVKReportBean>();
        ArrayList keys1 = new ArrayList(this.beanMap.keySet());
        keys1.sort(new StringComparator());
        for (String key1 : keys1) {
            Map key2ToBeansMap = (Map)this.beanMap.get((Object)key1);
            ArrayList keys2 = new ArrayList(key2ToBeansMap.keySet());
            keys2.sort(new StringComparator());
            for (String key2 : keys2) {
                PersonalnummerToBeansMap personalnummernToBeansMap = (PersonalnummerToBeansMap)key2ToBeansMap.get(key2);
                for (String personalnummer : personalnummernToBeansMap.getPersonalnummern()) {
                    ArrayList<StatementOfContributionZVKReportBean> beans = new ArrayList<StatementOfContributionZVKReportBean>(personalnummernToBeansMap.getBeans(personalnummer));
                    beans.sort(zvkComparator);
                    list.addAll(beans);
                }
            }
        }
        return list.iterator();
    }

    private class ZVKComparator
    implements Comparator<StatementOfContributionZVKReportBean> {
        private ZVKComparator() {
        }

        @Override
        public int compare(StatementOfContributionZVKReportBean o1, StatementOfContributionZVKReportBean o2) {
            int comp = this.compare(o1.isAreYearDatas(), o2.isAreYearDatas());
            if (comp != 0) {
                return comp;
            }
            comp = StringMapper.compareTo((String)DateMapper.toYYYYMMMinusSeparationString((Date)o1.getForValidUntilDate()), (String)DateMapper.toYYYYMMMinusSeparationString((Date)o2.getForValidUntilDate()));
            if (comp != 0) {
                return comp;
            }
            comp = this.compare(StringMapper.equal((String)o1.getF_status(), (String)"Neu"), StringMapper.equal((String)o2.getF_status(), (String)"Neu"));
            return comp;
        }

        @Override
        private int compare(boolean a, boolean b) {
            return a == b ? 0 : (a ? 1 : -1);
        }
    }

    private class PersonalnummerToBeansMap {
        private final List<String> personalnummern = new ArrayList<String>();
        private final Map<String, Collection<StatementOfContributionZVKReportBean>> personalNummerToBeansMap = new HashMap<String, Collection<StatementOfContributionZVKReportBean>>();

        private PersonalnummerToBeansMap() {
        }

        public List<String> getPersonalnummern() {
            return this.personalnummern;
        }

        public Collection<StatementOfContributionZVKReportBean> getBeans(String personalnummer) {
            return this.personalNummerToBeansMap.get(personalnummer);
        }

        public boolean add(StatementOfContributionZVKReportBean bean) {
            Collection<StatementOfContributionZVKReportBean> beans;
            String personalnummer = bean.getF_pers_nr();
            if (this.personalnummern.isEmpty() || !this.personalnummern.get(this.personalnummern.size() - 1).equals(personalnummer)) {
                this.personalnummern.add(personalnummer);
            }
            if ((beans = this.personalNummerToBeansMap.get(personalnummer)) == null) {
                beans = new ArrayList<StatementOfContributionZVKReportBean>();
                this.personalNummerToBeansMap.put(personalnummer, beans);
            }
            return beans.add(bean);
        }
    }
}

