/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.masterdataimport.socialinsurance;

import com.infor.igf.core.scheduler.ExecutionGroup;
import com.infor.igf.core.scheduler.PreferredScheduler;
import com.infor.igf.core.scheduler.SchedulerService;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.PermanentCalculationJob;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.global.masterdata.xmlimport.XmlImport;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.global.socialinsurance.global.SocialInsuranceGlobal;
import com.varial.personnel.domain.global.socialinsurance.lawarea.SocialInsuranceLawArea;
import com.varial.personnel.domain.reports.Progressbar;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.serverbase.basictypes.VDate;
import de.gkv.masterdata.version1.Stammdatendatei;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class SocialInsuranceXmlImport
extends XmlImport {
    private final AuthorizationToken mToken;
    private final Progressbar<?> mProgressBar;
    private static BigDecimal TWELVE = BigDecimal.valueOf(12L);
    private static BigDecimal ZERO_TWO = new BigDecimal("0.2");
    private static BigDecimal ZERO_EIGHT = new BigDecimal("0.8");
    private static BigDecimal ZERO_ZEROFIVE = new BigDecimal("0.05");
    private Date calculationDate = null;

    public SocialInsuranceXmlImport(AuthorizationToken token, Progressbar<?> progressBar, Stammdatendatei stammdatendatei) {
        super(stammdatendatei);
        this.mToken = token;
        this.mProgressBar = progressBar;
    }

    public Date getCalculationDate() {
        return this.calculationDate;
    }

    public void importXml() throws BusinessDomainException {
        Values values;
        LocalDate gueltigAb;
        SocialInsurance socialInsurance;
        List<SocialInsuranceTP> socialInsuranceTPs;
        SortedMap<LocalDate, Values> valuesMap = this.createValuesMap();
        if (valuesMap.isEmpty()) {
            return;
        }
        HashSet<LocalDate> gueltigAbSet = new HashSet<LocalDate>(valuesMap.keySet());
        LocalDate minGueltigAb = this.getMin(gueltigAbSet);
        Date minValidFrom = PDateHelper.toDate((LocalDate)minGueltigAb);
        LocalDate dateOfcomparison = DateHelper.toLocalDate((Date)DateHelper.getFirstDayOfYear((Date)DateHelper.addMonths((Date)DateHelper.today(), (int)-12)));
        if (minGueltigAb.isBefore(dateOfcomparison) && valuesMap.get(dateOfcomparison) == null) {
            valuesMap.put(dateOfcomparison, new Values());
        }
        if ((socialInsuranceTPs = SocialInsuranceXmlImport.getHistoryFrom(socialInsurance = SocialInsurancePersistencyManager.getInstance(), minValidFrom)).isEmpty()) {
            SocialInsuranceXmlImport.checkGueltigAb(minGueltigAb, valuesMap);
        }
        for (SocialInsuranceTP siTP : socialInsuranceTPs) {
            LocalDate gueltigAb2 = DateHelper.toLocalDate((Date)DateHelper.max((Date)siTP.getValidFrom(), (Date)minValidFrom));
            Values values2 = (Values)valuesMap.get(gueltigAb2);
            if (values2 == null) {
                values2 = new Values();
                valuesMap.put(gueltigAb2, values2);
            }
            values2.socialInsuranceTP = siTP;
        }
        Stammdatendatei.BeitragssaetzeSv beitragssaetzeSv = null;
        Stammdatendatei.Rechengroessen rechengroessen = null;
        SocialInsuranceTP socialInsuranceTP = null;
        Values previous = null;
        for (Map.Entry<LocalDate, Values> entry : valuesMap.entrySet()) {
            gueltigAb = entry.getKey();
            values = entry.getValue();
            if (values.beitragssaetzeSv == null) {
                values.beitragssaetzeSv = beitragssaetzeSv;
            }
            if (values.rechengroessen == null) {
                values.rechengroessen = rechengroessen;
            }
            if (values.socialInsuranceTP == null) {
                if (socialInsuranceTP == null) {
                    socialInsuranceTP = SocialInsuranceXmlImport.createSocialInsuranceTP(minValidFrom);
                }
                values.socialInsuranceTP = SocialInsuranceXmlImport.createCopy(socialInsuranceTP);
            }
            if (previous != null) {
                previous.until = DateHelper.yesterday((Date)PDateHelper.toDate((LocalDate)gueltigAb));
            }
            beitragssaetzeSv = values.beitragssaetzeSv;
            rechengroessen = values.rechengroessen;
            socialInsuranceTP = values.socialInsuranceTP;
            previous = values;
        }
        previous.until = VDate.getDateMax();
        this.mProgressBar.setTotal(valuesMap.size());
        for (Map.Entry<LocalDate, Values> entry : valuesMap.entrySet()) {
            gueltigAb = entry.getKey();
            values = entry.getValue();
            this.fill(values.socialInsuranceTP, values, gueltigAb);
            this.mProgressBar.nextProcessed();
        }
    }

    public void createCalculations(Progressbar<?> progressBar, Date startDate) throws BusinessDomainException {
        if (this.calculationDate != null) {
            PersistencySession context = SessionContext.getInstance().getPersistencySession();
            Employee[] employees = IEmployeePersistencyManager.getInstance().getAllEE();
            progressBar.setTotal(employees.length);
            for (Employee employee : employees) {
                if (!employee.isLastDateOfWithdrawalAfter(startDate)) continue;
                Date effectiveFrom = DateHelper.tomorrow((Date)employee.getJournalizedUntil());
                Date validFrom = this.calculationDate;
                Date[] dates = employee.checkAndCorrectStartOfCalculation(effectiveFrom, validFrom);
                String correctEffectiveFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(dates[0].getTime()), ZoneId.systemDefault()).toString();
                String correctValidFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(dates[1].getTime()), ZoneId.systemDefault()).toString();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("oidEmployee", employee.getObjectid());
                parameters.put("effectiveFrom", correctEffectiveFrom);
                parameters.put("validFrom", correctValidFrom);
                parameters.put("classOfBasic", this.getClass().getName());
                parameters.put("suppliedDomainKey", employee.getDomainKey());
                SchedulerService schedulerService = (SchedulerService)UtilitiesManager.getBean((String)"schedulerService", SchedulerService.class);
                schedulerService.addJob(PreferredScheduler.CALCULATION, ExecutionGroup.CALCULATION, this.mToken.getUserId(), employee.getSchedulerDescription().toString(), PermanentCalculationJob.class, parameters);
                context.flush();
                progressBar.nextProcessed();
            }
        }
    }

    private LocalDate getMin(Set<LocalDate> localDates) {
        LocalDate result = null;
        for (LocalDate localDate : localDates) {
            if (result != null && !localDate.isBefore(result)) continue;
            result = localDate;
        }
        return result;
    }

    private void fill(SocialInsuranceTP socialInsuranceTP, Values values, LocalDate gueltigAb) throws BusinessDomainException {
        Stammdatendatei.Rechengroessen rechengroessen;
        Date gueltigAbDate = PDateHelper.toDate((LocalDate)gueltigAb);
        SocialInsuranceGlobal siGlobal = socialInsuranceTP.getGlobal();
        SocialInsuranceLawArea siWest = socialInsuranceTP.getLawAreaWest();
        SocialInsuranceLawArea siEast = socialInsuranceTP.getLawAreaEast();
        SocialInsuranceTP oldSocialInsuranceTP = SocialInsuranceXmlImport.createCopy(socialInsuranceTP);
        Stammdatendatei.BeitragssaetzeSv beitragssaetzeSv = values.beitragssaetzeSv;
        if (beitragssaetzeSv != null) {
            siGlobal.setAverageGeneralContributionRateForAllowanceInPHI(beitragssaetzeSv.getKvAllgemein());
            siGlobal.setAverageReducedContributionRateForAllowanceInPHI(beitragssaetzeSv.getKvErmaessigt());
            siGlobal.setAdditionalDuesHI(beitragssaetzeSv.getKvDzban());
            siGlobal.setTotalContributionRateForPensionersInsurance(beitragssaetzeSv.getRvAllgemein());
            siGlobal.setTotalContributionRateForMinersPensionersInsurance(beitragssaetzeSv.getRvKnappschaftlich());
            siGlobal.setTotalContributionRateForUnemploymentInsurance(beitragssaetzeSv.getAlv());
            siGlobal.setTotalContributionRateForNursingInsurance(beitragssaetzeSv.getPvBasisbeitragssatz());
            siGlobal.setSurchargeNI(beitragssaetzeSv.getPvZuschlag());
            siGlobal.setBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners(beitragssaetzeSv.getKvPauschal());
            siGlobal.setBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners(beitragssaetzeSv.getRvPauschalAg());
            siGlobal.setPercentInsolvencyAssessment(beitragssaetzeSv.getInsolvenzgeldumlage());
            siGlobal.setNursingInsuranceReduction(beitragssaetzeSv.getPvAbschlag());
            siGlobal.setEEratePensionInsurance(beitragssaetzeSv.getRvAnteilAn());
            siGlobal.setLumpsumMinijob(beitragssaetzeSv.getPauschalsteuerMinijob());
        }
        if ((rechengroessen = values.rechengroessen) != null) {
            Stammdatendatei.Rechengroessen.Geringverdiener geringverdiener;
            BigDecimal value;
            Stammdatendatei.Rechengroessen.Beitragsbemessungsgrenzen beitragsbemessungsgrenzen = rechengroessen.getBeitragsbemessungsgrenzen();
            if (beitragsbemessungsgrenzen != null) {
                Object kvPv2;
                List kvPvs = beitragsbemessungsgrenzen.getKvPv();
                for (Object kvPv2 : kvPvs) {
                    value = kvPv2.getValue().multiply(TWELVE);
                    if ("O".equals(kvPv2.getRechtskreis())) {
                        siEast.setMaximumAssessableEarningsForHealthAndNursingInsurance(value);
                        continue;
                    }
                    siWest.setMaximumAssessableEarningsForHealthAndNursingInsurance(value);
                }
                List rvAlvs = beitragsbemessungsgrenzen.getRvAlv();
                kvPv2 = rvAlvs.iterator();
                while (kvPv2.hasNext()) {
                    Stammdatendatei.Rechengroessen.Beitragsbemessungsgrenzen.RvAlv rvAlv = (Stammdatendatei.Rechengroessen.Beitragsbemessungsgrenzen.RvAlv)kvPv2.next();
                    BigDecimal value2 = rvAlv.getValue().multiply(TWELVE);
                    if ("O".equals(rvAlv.getRechtskreis())) {
                        siEast.setMaximumAssessableEarningsForPensionersAndUnemploymentInsurance(value2);
                        continue;
                    }
                    siWest.setMaximumAssessableEarningsForPensionersAndUnemploymentInsurance(value2);
                }
                List rvKbss = beitragsbemessungsgrenzen.getRvKbs();
                for (Stammdatendatei.Rechengroessen.Beitragsbemessungsgrenzen.RvKbs rvKbs : rvKbss) {
                    BigDecimal value3 = rvKbs.getValue().multiply(TWELVE);
                    if ("O".equals(rvKbs.getRechtskreis())) {
                        siEast.setMaximumAssessableEarningsForMinersPensionersInsurance(value3);
                        continue;
                    }
                    siWest.setMaximumAssessableEarningsForMinersPensionersInsurance(value3);
                }
            }
            List bezugsgroessen = rechengroessen.getBezugsgroesse();
            for (Stammdatendatei.Rechengroessen.Bezugsgroesse bezugsgroesse : bezugsgroessen) {
                value = bezugsgroesse.getValue();
                if ("O".equals(bezugsgroesse.getRechtskreis())) {
                    siEast.setBasicAmountForPensionersAndUnemploymentInsurance(value);
                    continue;
                }
                siWest.setBasicAmountForHealthAndNursingInsurance(value);
                siWest.setBasicAmountForPensionersAndUnemploymentInsurance(value);
                siEast.setBasicAmountForHealthAndNursingInsurance(value);
            }
            Stammdatendatei.Rechengroessen.Jahresarbeitsentgeltgrenze jahresarbeitsentgeltgrenze = rechengroessen.getJahresarbeitsentgeltgrenze();
            if (jahresarbeitsentgeltgrenze != null) {
                String allgemeineJae = jahresarbeitsentgeltgrenze.getAllgemeineJae();
                value = SocialInsuranceXmlImport.toBigDecimal(allgemeineJae);
                siWest.setAnnualEarningsLimitHI(value);
                siEast.setAnnualEarningsLimitHI(value);
            }
            if ((geringverdiener = rechengroessen.getGeringverdiener()) != null) {
                BigDecimal geringverdienergrenzeBerufsausbildung = geringverdiener.getGeringverdienergrenzeBerufsausbildung();
                siWest.setGeneralMarginalValueOfLowIncomeEarners(geringverdienergrenzeBerufsausbildung);
                siEast.setGeneralMarginalValueOfLowIncomeEarners(geringverdienergrenzeBerufsausbildung);
            }
            siWest.setMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
            siEast.setMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
            siWest.setMinimumCalculationBasisForContributionOfPensionersInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_EIGHT));
            siEast.setMinimumCalculationBasisForContributionOfPensionersInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_EIGHT));
            siWest.setCalculationBasisForContributionOfHealthAndNursingInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
            siEast.setCalculationBasisForContributionOfHealthAndNursingInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
            siWest.setCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
            siEast.setCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_TWO));
            siWest.setCalculationBasisForContributionOfUnemploymentInsurance(siWest.getBasicAmountForHealthAndNursingInsurance());
            siEast.setCalculationBasisForContributionOfUnemploymentInsurance(siEast.getBasicAmountForHealthAndNursingInsurance());
            siWest.setMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(siWest.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_ZEROFIVE));
            siEast.setMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(siEast.getBasicAmountForHealthAndNursingInsurance().multiply(ZERO_ZEROFIVE));
            if (siGlobal.getLowWageFrom().signum() == 0 || siGlobal.getLowWageFrom().compareTo(BigDecimal.valueOf(55601L, 2)) < 0 && gueltigAb.getYear() >= 2025) {
                siGlobal.setLowWageFrom(BigDecimal.valueOf(55601L, 2));
            }
        }
        socialInsuranceTP.calculationOfRemainingFields();
        Date dateOfcomparison = DateHelper.getFirstDayOfYear((Date)DateHelper.addMonths((Date)DateHelper.today(), (int)-12));
        if (!SocialInsuranceXmlImport.isEqual(socialInsuranceTP, oldSocialInsuranceTP) && DateHelper.afterOrEqual((Date)gueltigAbDate, (Date)dateOfcomparison)) {
            SocialInsurance socialInsurance = SocialInsurancePersistencyManager.getInstance();
            socialInsuranceTP.setValidUntil(values.until);
            socialInsuranceTP.makeSaveable();
            if (!DateHelper.equal((Date)socialInsuranceTP.getValidFrom(), (Date)gueltigAbDate)) {
                socialInsuranceTP.setValidFrom(gueltigAbDate);
                socialInsurance.addHistory((PersonnelTimedPersistenceObject)socialInsuranceTP, false);
            } else {
                socialInsurance.setHistory((PersonnelTimedPersistenceObject)socialInsuranceTP, false, socialInsuranceTP.getEffectiveFrom());
            }
            this.calculationDate = PDateHelper.minIgnoringNulls((Date[])new Date[]{this.calculationDate, gueltigAbDate});
            ++this.mCreated;
        }
    }

    private static boolean isEqual(SocialInsuranceTP siTP1, SocialInsuranceTP siTP2) {
        return SocialInsuranceXmlImport.isEqual(siTP1.getGlobal(), siTP2.getGlobal()) && SocialInsuranceXmlImport.isEqual(siTP1.getLawAreaWest(), siTP2.getLawAreaWest()) && SocialInsuranceXmlImport.isEqual(siTP1.getLawAreaEast(), siTP2.getLawAreaEast());
    }

    private static boolean isEqual(SocialInsuranceGlobal siGlobal1, SocialInsuranceGlobal siGlobal2) {
        return SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAverageGeneralContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEaverageGeneralContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERaverageGeneralContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAverageReducedContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEaverageReducedContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERaverageReducedContributionRateForAllowanceInPHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForNursingInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getTotalContributionRateForMinersPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEtotalContributionRateForMinersPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERtotalContributionRateForMinersPI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEblanketContributionRateForHIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERblanketContributionRateForHIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEblanketContributionRateForPIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERblanketContributionRateForPIConcerningLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getInsignificantMaximumLimitForLowIncomeEarnersAmount) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getMinimumCalculationBasisForLowIncomeEarnersAmount) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getFactorForFormula) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getLowWageFrom) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getLowWageUntil) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargeNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargeNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargeNI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargeHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargeHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargeHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargeUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargeUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargeUI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getSurchargePI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEESurchargePI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getERSurchargePI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getPercentInsolvencyAssessment) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDues) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getDebtLimit) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesHI) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesKVDR) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesHIEE) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getAdditionalDuesHIER) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getFactorForFormulaTransition) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getNursingInsuranceReduction) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getEEratePensionInsurance) && SocialInsuranceXmlImport.isEqual(siGlobal1, siGlobal2, SocialInsuranceGlobal::getLumpsumMinijob);
    }

    private static boolean isEqual(SocialInsuranceLawArea siLawArea1, SocialInsuranceLawArea siLawArea2) {
        return SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getBasicAmountForHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getBasicAmountForHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getBasicAmountForPensionersAndUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMaximumAssessableEarningsForHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMaximumAssessableEarningsForMinersPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMinimumCalculationBasisForContributionOfHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMinimumCalculationBasisForContributionOfPensionersInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getCalculationBasisForContributionOfHealthAndNursingInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getCalculationBasisForContributionOfUnemploymentInsurance) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getGeneralMarginalValueOfLowIncomeEarners) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome) && SocialInsuranceXmlImport.isEqual(siLawArea1, siLawArea2, SocialInsuranceLawArea::getAnnualEarningsLimitHI);
    }

    private static <T> boolean isEqual(T t1, T t2, GetBigDecimalFunction<T> f) {
        return SocialInsuranceXmlImport.isEqual(f.getBigDecimal(t1), f.getBigDecimal(t2));
    }

    private static boolean isEqual(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        return PBigDecimalMapper.isEqual((BigDecimal)bigDecimal1, (BigDecimal)bigDecimal2);
    }

    private static SocialInsuranceTP createCopy(SocialInsuranceTP socialInsuranceTP) {
        SocialInsuranceTP copy = (SocialInsuranceTP)socialInsuranceTP.createNew();
        copy.setEffectiveFrom(socialInsuranceTP.getEffectiveFrom());
        copy.setEffectiveUntil(socialInsuranceTP.getEffectiveUntil());
        copy.setValidFrom(socialInsuranceTP.getValidFrom());
        copy.setValidUntil(socialInsuranceTP.getValidUntil());
        copy.setGlobal(SocialInsuranceXmlImport.createCopy(socialInsuranceTP.getGlobal()));
        copy.setLawAreaWest(SocialInsuranceXmlImport.createCopy(socialInsuranceTP.getLawAreaWest()));
        copy.setLawAreaEast(SocialInsuranceXmlImport.createCopy(socialInsuranceTP.getLawAreaEast()));
        copy.makeReadOnly();
        return copy;
    }

    private static SocialInsuranceLawArea createCopy(SocialInsuranceLawArea siLawArea) {
        SocialInsuranceLawArea copy = new SocialInsuranceLawArea(siLawArea.getBasicAmountForHealthAndNursingInsurance(), siLawArea.getBasicAmountForPensionersAndUnemploymentInsurance(), siLawArea.getMaximumAssessableEarningsForHealthAndNursingInsurance(), siLawArea.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance(), siLawArea.getMaximumAssessableEarningsForMinersPensionersInsurance(), siLawArea.getMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(), siLawArea.getMinimumCalculationBasisForContributionOfPensionersInsurance(), siLawArea.getCalculationBasisForContributionOfHealthAndNursingInsurance(), siLawArea.getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(), siLawArea.getCalculationBasisForContributionOfUnemploymentInsurance(), siLawArea.getGeneralMarginalValueOfLowIncomeEarners(), siLawArea.getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(), siLawArea.getAnnualEarningsLimitHI());
        return copy;
    }

    private static SocialInsuranceGlobal createCopy(SocialInsuranceGlobal siGlobal) {
        SocialInsuranceGlobal copy = new SocialInsuranceGlobal(siGlobal.getAverageGeneralContributionRateForAllowanceInPHI(), siGlobal.getEEaverageGeneralContributionRateForAllowanceInPHI(), siGlobal.getERaverageGeneralContributionRateForAllowanceInPHI(), siGlobal.getAverageReducedContributionRateForAllowanceInPHI(), siGlobal.getEEaverageReducedContributionRateForAllowanceInPHI(), siGlobal.getERaverageReducedContributionRateForAllowanceInPHI(), siGlobal.getTotalContributionRateForPensionersInsurance(), siGlobal.getEEtotalContributionRateForPI(), siGlobal.getERtotalContributionRateForPI(), siGlobal.getTotalContributionRateForUnemploymentInsurance(), siGlobal.getEEtotalContributionRateForUI(), siGlobal.getERtotalContributionRateForUI(), siGlobal.getTotalContributionRateForNursingInsurance(), siGlobal.getEEtotalContributionRateForNI(), siGlobal.getERtotalContributionRateForNI(), siGlobal.getTotalContributionRateForMinersPensionersInsurance(), siGlobal.getEEtotalContributionRateForMinersPI(), siGlobal.getERtotalContributionRateForMinersPI(), siGlobal.getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners(), siGlobal.getEEblanketContributionRateForHIConcerningLowIncomeEarners(), siGlobal.getERblanketContributionRateForHIConcerningLowIncomeEarners(), siGlobal.getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners(), siGlobal.getEEblanketContributionRateForPIConcerningLowIncomeEarners(), siGlobal.getERblanketContributionRateForPIConcerningLowIncomeEarners(), siGlobal.getInsignificantMaximumLimitForLowIncomeEarnersAmount(), siGlobal.getMinimumCalculationBasisForLowIncomeEarnersAmount(), siGlobal.getFactorForFormula(), siGlobal.getLowWageFrom(), siGlobal.getLowWageUntil(), siGlobal.getSurchargeNI(), siGlobal.getEESurchargeNI(), siGlobal.getERSurchargeNI(), siGlobal.getSurchargeHI(), siGlobal.getEESurchargeHI(), siGlobal.getERSurchargeHI(), siGlobal.getSurchargeUI(), siGlobal.getEESurchargeUI(), siGlobal.getERSurchargeUI(), siGlobal.getSurchargePI(), siGlobal.getEESurchargePI(), siGlobal.getERSurchargePI(), siGlobal.getPercentInsolvencyAssessment(), siGlobal.getAdditionalDues(), siGlobal.getDebtLimit(), siGlobal.getAdditionalDuesHI(), siGlobal.getAdditionalDuesKVDR(), siGlobal.getAdditionalDuesHIEE(), siGlobal.getAdditionalDuesHIER(), siGlobal.getFactorForFormulaTransition(), siGlobal.getNursingInsuranceReduction(), siGlobal.getEEratePensionInsurance(), siGlobal.getLumpsumMinijob());
        return copy;
    }

    private SortedMap<LocalDate, Values> createValuesMap() {
        Values values;
        LocalDate gueltigAb;
        TreeMap<LocalDate, Values> valuesMap = new TreeMap<LocalDate, Values>();
        for (Stammdatendatei.BeitragssaetzeSv beitragssaetzeSv : this.mMasterdata.getBeitragssaetzeSv()) {
            gueltigAb = SocialInsuranceXmlImport.toLocalDate(beitragssaetzeSv.getGueltigAb());
            values = valuesMap.computeIfAbsent(gueltigAb, x -> new Values());
            if (values.beitragssaetzeSv != null) {
                throw new IllegalStateException("Zum Datum " + gueltigAb + " gibt es mehrere Beitragss\u00e4tze.");
            }
            values.beitragssaetzeSv = beitragssaetzeSv;
        }
        for (Stammdatendatei.Rechengroessen rechengroessen : this.mMasterdata.getRechengroessen()) {
            gueltigAb = SocialInsuranceXmlImport.toLocalDate(rechengroessen.getGueltigAb());
            values = valuesMap.computeIfAbsent(gueltigAb, x -> new Values());
            if (values.rechengroessen != null) {
                throw new IllegalStateException("Zum Datum " + gueltigAb + " gibt es mehrere Rechengr\u00f6\u00dfen.");
            }
            values.rechengroessen = rechengroessen;
        }
        return valuesMap;
    }

    private static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s);
    }

    private static SocialInsuranceTP createSocialInsuranceTP(Date minValidFrom) {
        SocialInsuranceTP socialInsuranceTP = new SocialInsuranceTP();
        socialInsuranceTP.setValidFrom(minValidFrom);
        return socialInsuranceTP;
    }

    private static List<SocialInsuranceTP> getHistoryFrom(SocialInsurance socialInsurance, Date validDate) {
        ArrayList<SocialInsuranceTP> result = new ArrayList<SocialInsuranceTP>();
        for (SocialInsuranceTP socialInsuranceTP : socialInsurance.getHistory().getAll()) {
            if (!DateHelper.beforeOrEqual((Date)validDate, (Date)socialInsuranceTP.getValidUntil())) continue;
            result.add(socialInsuranceTP);
        }
        result.sort((siTP1, siTP2) -> DateHelper.compare((Date)siTP1.getValidFrom(), (Date)siTP2.getValidFrom()));
        return result;
    }

    private static void checkGueltigAb(LocalDate gueltigAb, Map<LocalDate, Values> valuesMap) {
        Values values = valuesMap.get(gueltigAb);
        if (values.beitragssaetzeSv == null) {
            throw new IllegalStateException("Zum Datum " + gueltigAb + " gibt Rechengr\u00f6\u00dfen, aber keine Beitragss\u00e4tze.");
        }
        if (values.rechengroessen == null) {
            throw new IllegalStateException("Zum Datum " + gueltigAb + " gibt Beitragss\u00e4tze, aber keine Rechengr\u00f6\u00dfen.");
        }
    }

    private class Values {
        private Stammdatendatei.BeitragssaetzeSv beitragssaetzeSv;
        private Stammdatendatei.Rechengroessen rechengroessen;
        private SocialInsuranceTP socialInsuranceTP;
        private Date until;

        private Values() {
        }
    }

    @FunctionalInterface
    private static interface GetBigDecimalFunction<T> {
        public BigDecimal getBigDecimal(T var1);
    }
}

