/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.elstamdatatransferprotocol;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.elo2.BaseProtocolContent;
import com.varial.personnel.domain.elo2.CompOrPlantDetails;
import com.varial.personnel.domain.elo2.ProtocolContentType;
import com.varial.personnel.domain.elo2.ReceiveAGProtocolContent;
import com.varial.personnel.domain.elo2.ReceiveProtocolDetailContent;
import com.varial.personnel.domain.elo2.ReceiveProtocolHandler;
import com.varial.personnel.domain.elo2.account.Elo2Account;
import com.varial.personnel.domain.elo2.elstam.Elo2Elstam;
import com.varial.personnel.domain.elo2.elstam.Elo2ElstamFieldFormat;
import com.varial.personnel.domain.elo2.elstam.Elo2ElstamTemp;
import com.varial.personnel.domain.elo2.kvpv.Elo2ListeKVPV;
import com.varial.personnel.domain.elo2.transfer.Elo2Receive;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.reports.elstamdatatransferprotocol.Elo2DataTransferLastPageSubReportBean;
import com.varial.personnel.domain.reports.elstamdatatransferprotocol.Elo2ELSTAMProtocolBean;
import com.varial.personnel.framework.D;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.shared.Version;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class Elo2ReceiveProtocolReportDataSource
implements JRDataSource {
    private static final String staticDatei = "Die Verarbeitung der Datei";
    private static final String staticResult = "wurde korrekt beendet.";
    private static final String staticDateiName = "Dateiname";
    private static final String staticErstellungsdatum = "Erstellungsdatum";
    private static final String staticDateiNr = "Datei-Nr.";
    protected String mPARAMETER_staticELO2Meldungen = "";
    private String mPARAMETER_staticCompany = "";
    private String mPARAMETER_staticBetriebs = "";
    private String mPARAMETER_staticDatum = "";
    private String mPARAMETER_staticBenutzer = "";
    private String mPARAMETER_staticSeite = "";
    private String mPARAMETER_staticPersNr = "";
    private String mPARAMETER_staticPersName = "";
    private String mPARAMETER_staticError = "";
    private String mPARAMETER_staticMessage = "";
    private String mPARAMETER_staticStId = "";
    private static final String STATIC_TEXT_PARAMETER_staticELO2Meldungen = "staticELO2Meldungen";
    private static final String STATIC_TEXT_PARAMETER_staticCompany = "staticCompany";
    private static final String STATIC_TEXT_PARAMETER_staticBetriebs = "staticBetriebs";
    private static final String STATIC_TEXT_PARAMETER_staticDatum = "staticDatum";
    private static final String STATIC_TEXT_PARAMETER_staticBenutzer = "staticBenutzer";
    private static final String STATIC_TEXT_PARAMETER_staticSeite = "staticSeite";
    private static final String STATIC_TEXT_PARAMETER_staticPersNr = "staticPersNr";
    private static final String STATIC_TEXT_PARAMETER_staticPersName = "staticPersName";
    private static final String STATIC_TEXT_PARAMETER_staticError = "staticError";
    private static final String STATIC_TEXT_PARAMETER_staticMessage = "staticMessage";
    private static final String STATIC_TEXT_PARAMETER_staticStId = "staticStId";
    private Collection<Elo2DataTransferLastPageSubReportBean> mLastPageCollection;
    private Collection<Elo2ListeKVPV> mKvPvListe;
    private final Elo2Receive mCreator;
    private Elo2Account mAccount;
    private final ReceiveProtocolHandler protocolHandler;
    protected boolean mAbschlussPruefen;
    protected String mUserID;
    private final Date mActDatum;
    private BaseProtocolContent protContent;
    private Elo2ELSTAMProtocolBean currentElstam;
    private Elo2ElstamFieldFormat currentElstamFieldFormat;
    private ReceiveProtocolDetailContent detailProtContent;
    private ReceiveAGProtocolContent agProtContent;
    private String currentAGTaxId;
    private String currentCompanyNameComplete;
    private String currentCompanyKey;
    private List<CompOrPlantDetails> copdList = null;
    private int protocolContentType = 0;

    public Elo2ReceiveProtocolReportDataSource(Elo2Receive creator) {
        this.mCreator = creator;
        this.protocolHandler = this.mCreator.getProtocolHandler();
        this.mAbschlussPruefen = true;
        this.mUserID = SessionContext.getInstance().getSession().getUserCode();
        this.mActDatum = VDate.getCurrentLocalizedDateAndTime();
        this.mPARAMETER_staticELO2Meldungen = this.getReportName();
        this.mPARAMETER_staticCompany = "Firma";
        this.mPARAMETER_staticBetriebs = "Betriebsstaette";
        this.mPARAMETER_staticDatum = "Datum";
        this.mPARAMETER_staticBenutzer = "Benutzer";
        this.mPARAMETER_staticSeite = "Seite";
        this.mPARAMETER_staticPersNr = "Pers.Nr.";
        this.mPARAMETER_staticPersName = "Name, Vorname";
        this.mPARAMETER_staticError = "Fehlertext";
        this.mPARAMETER_staticMessage = "Aufgrund von Fehlermeldungen in der Datei konnte fuer folgende Mitarbeiter kein ELStAM-Satz erzeugt werden:";
        this.mPARAMETER_staticStId = "Steuer-Nr.";
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(STATIC_TEXT_PARAMETER_staticELO2Meldungen, this.mPARAMETER_staticELO2Meldungen);
        parameters.put(STATIC_TEXT_PARAMETER_staticCompany, this.mPARAMETER_staticCompany);
        parameters.put(STATIC_TEXT_PARAMETER_staticBetriebs, this.mPARAMETER_staticBetriebs);
        parameters.put(STATIC_TEXT_PARAMETER_staticDatum, this.mPARAMETER_staticDatum);
        parameters.put(STATIC_TEXT_PARAMETER_staticBenutzer, this.mPARAMETER_staticBenutzer);
        parameters.put(STATIC_TEXT_PARAMETER_staticSeite, this.mPARAMETER_staticSeite);
        parameters.put(STATIC_TEXT_PARAMETER_staticPersNr, this.mPARAMETER_staticPersNr);
        parameters.put(STATIC_TEXT_PARAMETER_staticPersName, this.mPARAMETER_staticPersName);
        parameters.put(STATIC_TEXT_PARAMETER_staticError, this.mPARAMETER_staticError);
        parameters.put(STATIC_TEXT_PARAMETER_staticMessage, this.mPARAMETER_staticMessage);
        parameters.put(STATIC_TEXT_PARAMETER_staticStId, this.mPARAMETER_staticStId);
        return parameters;
    }

    private void fillLastPageValues() {
        this.mLastPageCollection = new LinkedList<Elo2DataTransferLastPageSubReportBean>();
        this.mLastPageCollection.add(new Elo2DataTransferLastPageSubReportBean(staticDatei, staticResult, staticDateiName, staticErstellungsdatum, staticDateiNr, "", this.protocolHandler.getPerfidiaFilePathAndName(), this.protocolHandler.getPerfidiaFileName(), this.protocolHandler.getPerfidiaFileCreation(), this.protocolHandler.getPerfidiaFileNumber(), this.protocolHandler.getPerfidiaFileDetailCount()));
    }

    public boolean next() throws JRException {
        boolean next = false;
        try {
            next = this.getNext();
            if (!next && this.mAbschlussPruefen) {
                this.closeReport();
                next = true;
            }
            return next;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
    }

    public void closeReport() {
        this.fillLastPageValues();
        this.mAbschlussPruefen = false;
    }

    protected void reset() {
        this.currentElstam = null;
        this.currentElstamFieldFormat = new Elo2ElstamFieldFormat();
        this.detailProtContent = null;
        this.agProtContent = null;
        this.protocolContentType = 0;
        this.currentAGTaxId = "";
        this.currentCompanyNameComplete = "";
    }

    protected boolean getNext() throws BusinessDomainException {
        D.enter();
        boolean next = false;
        this.reset();
        next = this.protocolHandler.hasNextContent();
        if (next) {
            this.protContent = this.protocolHandler.getNextContent();
            if (this.protContent != null) {
                if (this.protContent instanceof ReceiveProtocolDetailContent) {
                    this.detailProtContent = (ReceiveProtocolDetailContent)this.protContent;
                    this.currentAGTaxId = this.detailProtContent.getAgStId();
                    this.currentCompanyKey = this.detailProtContent.getCompanyKey();
                    this.fillELSTAM();
                } else if (this.protContent instanceof ReceiveAGProtocolContent) {
                    this.agProtContent = (ReceiveAGProtocolContent)this.protContent;
                    this.currentAGTaxId = this.agProtContent.getAgStId();
                    this.currentCompanyKey = this.agProtContent.getCompOrPlantKey();
                }
                this.copdList = this.protocolHandler.getCompOrPlantDetailsPerTaxId(this.currentAGTaxId);
                if (this.copdList != null && !StringMapper.isNullString((String)this.currentCompanyKey)) {
                    for (CompOrPlantDetails copd : this.copdList) {
                        if (!this.currentCompanyKey.equals(copd.getCompanyKey())) continue;
                        this.currentCompanyNameComplete = copd.getCompanyNameComplete();
                        break;
                    }
                }
                if (StringMapper.isNullString((String)this.currentCompanyNameComplete)) {
                    if (!StringMapper.isNullString((String)this.currentCompanyKey) && this.currentCompanyKey.contains("/")) {
                        String[] compKeys;
                        block1: for (String compK : compKeys = this.currentCompanyKey.split("/")) {
                            if (this.copdList == null) continue;
                            for (CompOrPlantDetails copd : this.copdList) {
                                if (!compK.equals(copd.getCompanyKey())) continue;
                                this.currentCompanyNameComplete = copd.getCompanyNameComplete();
                                break block1;
                            }
                        }
                    }
                    if (StringMapper.isNullString((String)this.currentCompanyNameComplete)) {
                        this.currentCompanyNameComplete = this.currentCompanyKey;
                    }
                }
            }
        }
        D.leave();
        return next;
    }

    private String formatToCurrency(String val) {
        String temp = val;
        if (temp.contains(".")) {
            temp = temp.replace(".", ",");
        }
        return temp;
    }

    protected void fillELSTAM() throws BusinessDomainException {
        Elo2ElstamTemp els = (Elo2ElstamTemp)this.detailProtContent.getDetails();
        this.protocolContentType = els == null || this.detailProtContent.getProtocolContentType() == ProtocolContentType.AN_WITHERROR ? 2 : 1;
        if (els != null) {
            String freiJahr = "";
            if (els.getFreiBetrJahr() != null) {
                freiJahr = this.formatToCurrency(els.getFreiBetrJahr().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String freiMonat = "";
            if (els.getFreiBetrMonat() != null) {
                freiMonat = this.formatToCurrency(els.getFreiBetrMonat().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String freiWoche = "";
            if (els.getFreiBetrWoche() != null) {
                freiWoche = this.formatToCurrency(els.getFreiBetrWoche().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String freiTag = "";
            if (els.getFreiBetrTag() != null) {
                freiTag = this.formatToCurrency(els.getFreiBetrTag().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String hinzuJahr = "";
            if (els.getHinzuBetrJahr() != null) {
                hinzuJahr = this.formatToCurrency(els.getHinzuBetrJahr().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String hinzuMonat = "";
            if (els.getHinzuBetrMonat() != null) {
                hinzuMonat = this.formatToCurrency(els.getHinzuBetrMonat().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String hinzuWoche = "";
            if (els.getHinzuBetrWoche() != null) {
                hinzuWoche = this.formatToCurrency(els.getHinzuBetrWoche().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String hinzuTag = "";
            if (els.getHinzuBetrTag() != null) {
                hinzuTag = this.formatToCurrency(els.getHinzuBetrTag().setScale(2, RoundingMode.HALF_UP).toString());
            }
            String anzKindFrei = "";
            if (els.getAnzKindFrei() != null) {
                anzKindFrei = this.formatToCurrency(els.getAnzKindFrei().setScale(1, RoundingMode.HALF_UP).toPlainString());
            }
            String faktor = "";
            if (els.getFaktor() != null) {
                faktor = this.formatToCurrency(els.getFaktor().setScale(3, RoundingMode.HALF_UP).toPlainString());
            }
            String isImported = "";
            if (this.detailProtContent.isCreateOrSetAccount()) {
                isImported = "J";
            }
            this.currentElstam = new Elo2ELSTAMProtocolBean(this.detailProtContent.getSurName(), this.detailProtContent.getFirstName(), this.detailProtContent.getBirthDateAsString(), DateMapper.toDDMMYYYYPointSeparationString((Date)els.getGueltigab()), els.getAnidnr(), this.detailProtContent.getPersNrAsString(), Integer.toString(els.getSteuerklasse()), anzKindFrei, faktor, freiJahr, freiMonat, freiWoche, freiTag, hinzuJahr, hinzuMonat, hinzuWoche, hinzuTag, ChurchTaxEnumMapper.valueToStringForDeviantEntries((int)els.getKonfAn()), ChurchTaxEnumMapper.valueToStringForDeviantEntries((int)els.getKonfEG()), isImported);
            this.currentElstamFieldFormat = els.getFieldFormat();
        }
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public String getUser() {
        return SessionContext.getInstance().getSession().getUserCode();
    }

    public String getPerfidiaFile() throws BusinessDomainException {
        return Integer.toString(this.mAccount.getCurrentFileNumber());
    }

    public Elo2Elstam getElstam() {
        return this.mAccount.getElo2Elstam();
    }

    public Elo2Account getElo2Account() {
        return this.mAccount;
    }

    public Date getCreateDate() {
        return this.getDatumUhrzeit();
    }

    public String getArchi_string() {
        return "";
    }

    public String getCurrencyName() {
        return "Euro";
    }

    public String getAbgabeGrund() {
        return this.mAccount.getReasonOfDelivery().toString();
    }

    public Date getDatumUhrzeit() {
        return VDate.getCurrentLocalizedDateAndTime();
    }

    public String getEmployeeDescription() {
        Employee ee = this.mAccount.getEmployee();
        if (ee == null) {
            return "?";
        }
        return Integer.toString(ee.getPersonnelnumber());
    }

    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        try {
            if (fieldName.equals("Field_ProtContType")) {
                return this.protocolContentType;
            }
            if (fieldName.equals("elstamErrorMessage") && this.agProtContent != null) {
                return this.agProtContent.getMessagesAsString();
            }
            if (fieldName.equals("Field_PersNr") && this.detailProtContent != null) {
                return this.detailProtContent.getPersNrAsString();
            }
            if (fieldName.equals("Field_PersName") && this.detailProtContent != null) {
                return this.detailProtContent.getCompleteName();
            }
            if (fieldName.equals("Field_Meldetyp")) {
                return this.protocolHandler.getReasonOfDeliveryAsString();
            }
            if (fieldName.equals("Field_ReasonOfDeliv")) {
                return this.protocolHandler.getReasonOfDelivery().value();
            }
            if (fieldName.equals("Field_Company")) {
                return this.currentCompanyNameComplete;
            }
            if (fieldName.equals("Field_CompStId")) {
                return this.currentAGTaxId;
            }
            if (fieldName.equals("Field_Datum")) {
                return DateMapper.toDDMMYYYYPointSeparationString((Date)this.mActDatum);
            }
            if (fieldName.equals("Field_Benutzer")) {
                return this.mUserID;
            }
            if (fieldName.equals("version")) {
                return Version.getVersion();
            }
            if (fieldName.equals("datumUhrzeit")) {
                return String.format("%1$tH:%1$tM", new Date());
            }
            if (fieldName.equals("LastPage_subreport_Bean")) {
                return this.mLastPageCollection;
            }
            if (fieldName.equals("anKvPv_subreport_Bean")) {
                return this.mCreator.getKvPvListe();
            }
            if (fieldName.equals("format_validfrom")) {
                return true;
            }
            if (fieldName.equals("errorMessage") && this.detailProtContent != null) {
                return this.detailProtContent.getMessagesAsString();
            }
            if (fieldName.equals("vhMessage") && this.detailProtContent != null) {
                return this.detailProtContent.getMessagesAsString();
            }
            if (fieldName.equals("elstam.f_SurName") && this.currentElstam != null) {
                return this.currentElstam.getF_SurName();
            }
            if (fieldName.equals("elstam.f_FirstName") && this.currentElstam != null) {
                return this.currentElstam.getF_FirstName();
            }
            if (fieldName.equals("elstam.f_BirthDate") && this.currentElstam != null) {
                return this.currentElstam.getF_BirthDate();
            }
            if (fieldName.equals("elstam.f_BeginDate") && this.currentElstam != null) {
                return this.currentElstam.getF_BeginDate();
            }
            if (fieldName.equals("elstam.f_TaxId") && this.currentElstam != null) {
                return this.currentElstam.getF_TaxId();
            }
            if (fieldName.equals("elstam.f_PersNr") && this.currentElstam != null) {
                return this.currentElstam.getF_PersNr();
            }
            if (fieldName.equals("elstam.f_TaxBracket") && this.currentElstam != null) {
                return this.currentElstam.getF_TaxBracket();
            }
            if (fieldName.equals("elstam.f_AnzKindFrei") && this.currentElstam != null) {
                return this.currentElstam.getF_AnzKindFrei();
            }
            if (fieldName.equals("elstam.f_Faktor") && this.currentElstam != null) {
                return this.currentElstam.getF_Faktor();
            }
            if (fieldName.equals("elstam.f_FreiJahr") && this.currentElstam != null) {
                return this.currentElstam.getF_FreiJahr();
            }
            if (fieldName.equals("elstam.f_FreiMonat") && this.currentElstam != null) {
                return this.currentElstam.getF_FreiMonat();
            }
            if (fieldName.equals("elstam.f_FreiWoche") && this.currentElstam != null) {
                return this.currentElstam.getF_FreiWoche();
            }
            if (fieldName.equals("elstam.f_FreiTag") && this.currentElstam != null) {
                return this.currentElstam.getF_FreiTag();
            }
            if (fieldName.equals("elstam.f_HinzuJahr") && this.currentElstam != null) {
                return this.currentElstam.getF_HinzuJahr();
            }
            if (fieldName.equals("elstam.f_HinzuMonat") && this.currentElstam != null) {
                return this.currentElstam.getF_HinzuMonat();
            }
            if (fieldName.equals("elstam.f_HinzuWoche") && this.currentElstam != null) {
                return this.currentElstam.getF_HinzuWoche();
            }
            if (fieldName.equals("elstam.f_HinzuTag") && this.currentElstam != null) {
                return this.currentElstam.getF_HinzuTag();
            }
            if (fieldName.equals("elstam.f_KonfAn") && this.currentElstam != null) {
                return this.currentElstam.getF_KonfAn();
            }
            if (fieldName.equals("elstam.f_KonfEg") && this.currentElstam != null) {
                return this.currentElstam.getF_KonfEg();
            }
            if (fieldName.equals("elstam.f_Imported") && this.currentElstam != null) {
                return this.currentElstam.getF_Imported();
            }
            if (fieldName.equals("format.formatOrdnungsmerkmal") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatOrdnungsmerkmal();
            }
            if (fieldName.equals("format.formatAnidnr") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatAnidnr();
            }
            if (fieldName.equals("format.formatGueltigab") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatGueltigab();
            }
            if (fieldName.equals("format.formatSteuerklasse") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatSteuerklasse();
            }
            if (fieldName.equals("format.formatFaktor") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatFaktor();
            }
            if (fieldName.equals("format.formatFreiBetrJahr") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatFreiBetrJahr();
            }
            if (fieldName.equals("format.formatFreiBetrMonat") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatFreiBetrMonat();
            }
            if (fieldName.equals("format.formatFreiBetrWoche") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatFreiBetrWoche();
            }
            if (fieldName.equals("format.formatFreiBetrTag") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatFreiBetrTag();
            }
            if (fieldName.equals("format.formatHinzuBetrJahr") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatHinzuBetrJahr();
            }
            if (fieldName.equals("format.formatHinzuBetrMonat") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatHinzuBetrMonat();
            }
            if (fieldName.equals("format.formatHinzuBetrWoche") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatHinzuBetrWoche();
            }
            if (fieldName.equals("format.formatHinzuBetrTag") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatHinzuBetrTag();
            }
            if (fieldName.equals("format.formatAnzKindFrei") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatAnzKindFrei();
            }
            if (fieldName.equals("format.formatKonfAn") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatKonfAn();
            }
            if (fieldName.equals("format.formatKonfEG") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatKonfEG();
            }
            if (fieldName.equals("format.formatBeschBeginn") && this.currentElstamFieldFormat != null) {
                return this.currentElstamFieldFormat.getFormatBeschBeginn();
            }
            if (fieldName.equals("Field_Successfull")) {
                String message = "Erfolgreich verarbeitete ELStAM-Saetze: " + Integer.toString(this.protocolHandler.getCountOfAllSuccessfullElstams()) + "\ndavon uebernommen in MA-Besteuerung: " + Integer.toString(this.protocolHandler.getCountOfAllSuccessfullImportedElstams());
                return message;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        return null;
    }

    protected String getReportName() {
        return "Datenuebernahme ELStAM";
    }
}

