/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.recipient;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.global.masterdata.xmlimport.XmlImport;
import com.varial.personnel.domain.global.recipient.ModeOfPaymentEnum;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.recipient.RecipientPersistencyManager;
import com.varial.personnel.domain.global.recipient.RecipientTP;
import com.varial.personnel.domain.global.recipient.TypeOfRecipientEnum;
import com.varial.personnel.domain.global.recipient.bv.BV;
import com.varial.personnel.domain.global.recipient.mapper.RecipientExceptionMapper;
import com.varial.personnel.domain.reports.Progressbar;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.personnel.framework.basictypes.TypeOfBankTransferEnum;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.StringMapper;
import de.gkv.masterdata.version1.AnschriftCtp;
import de.gkv.masterdata.version1.Stammdatendatei;
import java.util.Date;
import java.util.List;

public class RecipientXmlImport
extends XmlImport {
    private final Progressbar<?> mProgressBar;
    protected int mUpdated = 0;

    public RecipientXmlImport(Stammdatendatei stammdatendatei) {
        this(stammdatendatei, null);
    }

    public RecipientXmlImport(Stammdatendatei stammdatendatei, Progressbar<?> progressBar) {
        super(stammdatendatei);
        this.mProgressBar = progressBar;
    }

    public void importXml() throws BusinessDomainException {
        List versorgungswerke = this.mMasterdata.getBerufsstaendischeVersorgungseinrichtungen().getVersorgungswerk();
        if (this.mProgressBar != null) {
            this.mProgressBar.setTotal(versorgungswerke.size());
        }
        for (Stammdatendatei.BerufsstaendischeVersorgungseinrichtungen.Versorgungswerk versorgungswerk : versorgungswerke) {
            RecipientTP tp = this.getRecipientTPorNew(versorgungswerk.getBbnrBv(), versorgungswerk.getBvNummer());
            this.fillRecipientTP(tp, versorgungswerk);
            if (this.mProgressBar == null) continue;
            this.mProgressBar.nextProcessed();
        }
    }

    private void fillRecipientTP(RecipientTP tp, Stammdatendatei.BerufsstaendischeVersorgungseinrichtungen.Versorgungswerk input) {
        Date validFrom;
        tp.makeSaveable();
        BV bv = null;
        if (tp.isNew()) {
            bv = new BV(tp);
            PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
            tp.setEffectiveFrom(pb.getSystemStart());
            tp.setEffectiveUntil(VDate.getDateMax());
            Date validFrom2 = DateHelper.add((Date)input.getGueltigAb().toGregorianCalendar().getTime(), (int)1);
            tp.setValidFrom(validFrom2);
            tp.setValidUntil(VDate.getDateMax());
            tp.setModeOfPaymentEnum(ModeOfPaymentEnum.MOPE_Bankeinzug);
            tp.setTypeOfBankTransfer(TypeOfBankTransferEnum.TOBTE_DTAUS);
        } else {
            bv = tp.getBV();
            if (bv == null) {
                bv = new BV(tp);
            }
        }
        bv.makeSaveable();
        bv.setActive(input.isBvAktiv());
        bv.setShortdescription(input.getKurzbezeichnung());
        if (input.getGueltigBis() != null && DateHelper.before((Date)(validFrom = DateHelper.add((Date)input.getGueltigBis().toGregorianCalendar().getTime(), (int)1)), (Date)VDate.getCurrentLocalizedDateAndTime())) {
            bv.setShortdescription(input.getKurzbezeichnung() + " \u2013 nicht mehr verwenden");
        }
        bv.setAbv(input.getBvNummer());
        bv.setDummyMemberShipNumber(input.getDummyMitgliedsnummer());
        bv.setReportingfilter("");
        tp.setLongDescription(input.getName1() + " " + this.get(input.getName2()) + " " + this.get(input.getName3()));
        for (AnschriftCtp each : input.getAnschrift()) {
            if (!"Anschrift".equals(each.getArt())) continue;
            PostalAddress address = tp.getAddress();
            if (address == null) {
                address = new PostalAddress(null, null, null, null);
            }
            address.setCity(each.getOrt());
            address.setPostalCode(each.getPlz());
            address.setStreet(each.getStrasse() + " " + each.getHausnummer());
            tp.setAddress(address);
        }
        bv.setKeyAgeLimit(Integer.parseInt(input.getAltersgrenze()));
        bv.setKeyMultiEmployment(Integer.parseInt(input.getMehrfachbeschaeftigung()));
        bv.setReportingfilter(input.getMeldefilter());
        tp.setBV(bv);
    }

    private String get(String string) {
        if (StringMapper.isNullString((String)string) || "null".equals(string)) {
            return "";
        }
        return string;
    }

    private RecipientTP getRecipientTPorNew(String bbnr, String key) throws BusinessDomainException {
        Recipient[] recipients;
        for (Recipient each : recipients = RecipientPersistencyManager.query(null, null)) {
            RecipientTP tp = (RecipientTP)each.getHistory().getItemOrNull(VDate.getDateMax(), VDate.getDateMax());
            if (tp == null || tp.getTypeOfRecipientEnum() != TypeOfRecipientEnum.TORE_Versorgungseinrichtung || !StringMapper.equal((String)bbnr, (String)tp.getStandardCompanyNumber())) continue;
            ++this.mUpdated;
            return tp;
        }
        Recipient parent = new Recipient();
        parent.setRecipientKey(RecipientXmlImport.getNewKey(recipients, key));
        parent.makeSaveable();
        RecipientTP tp = new RecipientTP(parent);
        tp.setStandardCompanyNumber(bbnr);
        tp.setTypeOfRecipientEnum(TypeOfRecipientEnum.TORE_Versorgungseinrichtung);
        ++this.mCreated;
        return tp;
    }

    private static String getNewKey(Recipient[] recipients, String key) throws BusinessDomainException {
        if (!RecipientXmlImport.existsKey(recipients, key)) {
            return key;
        }
        String newKey = key + "BV";
        if (!RecipientXmlImport.existsKey(recipients, newKey)) {
            return newKey;
        }
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            newKey = key + "BV" + c;
            if (RecipientXmlImport.existsKey(recipients, newKey)) continue;
            return newKey;
        }
        throw RecipientExceptionMapper.makeCannotCreateRecipientKeyException(key);
    }

    private static boolean existsKey(Recipient[] recipients, String key) {
        for (Recipient recipient : recipients) {
            if (!key.equals(recipient.getRecipientKey())) continue;
            return true;
        }
        return false;
    }

    public int getUpdated() {
        return this.mUpdated;
    }
}

