/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.healthfund.itsg;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.WriteCalculationJob;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.itsg.DifferencesItsg;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundItsg;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundTPItsg;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;
import java.util.Iterator;

public class UpdateJob {
    private int valuationCount;
    private int differenceCount;
    private int notFoundCount;
    private DifferencesItsg differences;
    private Date startDate;
    private Date currentDate = VDate.getDateMax();
    private HealthFundItsg currentHealthFundItsg;
    private HealthFund[] currentHealthFunds;
    private int currentHealthFundIndex;
    private int count;

    public void appendToMessage(BusinessDomainException BusinessDomainException2, StringBuilder messageBuffer) {
        messageBuffer.append(this.differences.getId()).append(' ').append(this.differences.getName());
        messageBuffer.append(" verweigert. ").append(BusinessDomainException2.getMessage());
        messageBuffer.append(" (").append(BusinessDomainException2.getServerMethod()).append(")\r\n");
    }

    public String buildErrorMessage(StringBuilder messageBuffer) {
        return DifferencesItsg.summaryString(new StringBuilder(messageBuffer.length() + 256), this.count, this.differenceCount, this.valuationCount, this.notFoundCount).append((CharSequence)messageBuffer).toString();
    }

    public String buildResultMessage(StringBuilder messageBuffer) {
        StringBuilder b = new StringBuilder(messageBuffer.length() + 256);
        b.append("Aktualisiere ");
        if (this.count != 1) {
            b.append("Krankenkassen entsprechend ").append(this.count);
        } else {
            b.append("eine Krankenkasse entsprechend");
        }
        b.append(" GKV-Beitragss\u00e4tzen ab " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.startDate) + ".\r\n\r\n");
        return DifferencesItsg.summaryString(b, this.count, this.differenceCount, this.valuationCount, this.notFoundCount).append((CharSequence)messageBuffer).toString();
    }

    private void decreaseCurrent(Date date) {
        if (DateHelper.after((Date)this.currentDate, (Date)date)) {
            this.currentDate = date;
        }
    }

    public boolean initHealthFund(HealthFundItsg healthFundItsg, HealthFund[] healthfunds) throws BusinessDomainException {
        if (this.currentHealthFundItsg != healthFundItsg) {
            this.currentHealthFundItsg = healthFundItsg;
            this.currentHealthFunds = healthfunds;
            this.currentHealthFundIndex = 0;
            if (healthfunds.length == 0) {
                ++this.notFoundCount;
                return false;
            }
        }
        if (this.currentHealthFundIndex + 1 > this.currentHealthFunds.length) {
            return false;
        }
        HealthFund hf = this.currentHealthFunds[this.currentHealthFundIndex++];
        this.differences = new DifferencesItsg(healthFundItsg, hf, this.startDate);
        if (this.differences.getValuateNeeded()) {
            ++this.valuationCount;
        }
        if (this.differences.isDifferent()) {
            ++this.differenceCount;
        }
        return true;
    }

    public void setStartDate(Date systemStart) {
        this.startDate = systemStart;
    }

    public void makeUpdate() throws BusinessDomainException {
        HealthFund bo = this.differences.getBo();
        String[] code = bo.getHealthFund().split("\\s[(]\\d{1,}[)]$");
        String number = bo.getHealthFund().substring(code[0].length(), bo.getHealthFund().length());
        Date max = VDate.getDateMax();
        String name = this.differences.getName();
        if (StringMapper.equal((String)bo.getHealthFundTP(max, max).getStandardCompanyNumber(), (String)"15035218")) {
            name = name.concat(" alt").trim();
        }
        if (!code[0].equals(name)) {
            bo.makeSaveable();
            String newCode = name.concat(number).trim();
            if (newCode.length() > 50) {
                int d = newCode.length() - 50;
                newCode = name.substring(0, name.length() - d).concat(number).trim();
            }
            bo.setHealthFund(newCode);
        }
        Date effectiveFrom = bo.getHealthFundTP(max, max).getEffectiveFrom();
        Iterator<HealthFundTP> iit = this.differences.getItsgTPs().iterator();
        Iterator<Date> dit = this.differences.getDates().iterator();
        while (iit.hasNext()) {
            HealthFundTPItsg itp = (HealthFundTPItsg)iit.next();
            Date validFrom = dit.next();
            HealthFundTP tp = itp.getFor(bo);
            tp.setValidFrom(validFrom);
            tp.setEffectiveFrom(effectiveFrom);
            bo.addHistory(tp, true);
        }
        this.decreaseCurrent(this.differences.getBegin());
    }

    public boolean isDiffValuateNeeded() {
        return this.differences.getValuateNeeded();
    }

    public void setCount(int count) {
        this.count = count;
    }

    public WriteCalculationJob valuate(AuthorizationToken token, Date schedulerTime) throws BusinessDomainException {
        return this.differences.valuate(token, schedulerTime);
    }

    public void removeWithdrawalEmployees(Date date) {
        this.differences.removeWithdrawalEmployees(date);
    }
}

