/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.healthfund;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.global.healthfund.Assessment;
import com.varial.personnel.domain.global.healthfund.AssessmentData;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.persistency.global.healthfundtp.assessment.AssessmentContainer;
import com.varial.personnel.persistency.global.healthfundtp.assessment.IAssessmentDao;
import com.varial.serverbase.mapper.ExceptionMapper;

public class AssessmentPersistencyManager {
    private static IAssessmentDao dao = (IAssessmentDao)UtilitiesManager.getApplicationContext().getBean("assessmentDao");

    public static Assessment[] getAssessments(HealthFundTP hftp) {
        return AssessmentPersistencyManager.query(null, Restrictions.eq((String)"oidhealthfundtp", (String)hftp.getObjectid()), hftp);
    }

    public static Assessment[] getAssessmentU1(HealthFundTP hftp) {
        Assessment[] result = AssessmentPersistencyManager.query(null, Restrictions.and((Criterion)Restrictions.eq((String)"oidhealthfundtp", (String)hftp.getObjectid()), (Criterion)Restrictions.eq((String)"assessmentkey", (String)"U1")), hftp);
        return result;
    }

    public static Assessment[] getAssessmentU2(HealthFundTP hftp) {
        Assessment[] result = AssessmentPersistencyManager.query(null, Restrictions.and((Criterion)Restrictions.eq((String)"oidhealthfundtp", (String)hftp.getObjectid()), (Criterion)Restrictions.eq((String)"assessmentkey", (String)"U2")), hftp);
        return result;
    }

    public static Assessment[] getAssessmentU3(HealthFundTP hftp) {
        Assessment[] result = AssessmentPersistencyManager.query(null, Restrictions.and((Criterion)Restrictions.eq((String)"oidhealthfundtp", (String)hftp.getObjectid()), (Criterion)Restrictions.eq((String)"assessmentkey", (String)"U3")), hftp);
        return result;
    }

    private static Assessment[] query(Order[] sortierung, Criterion filters, HealthFundTP hftp) {
        try {
            AssessmentContainer[] containers = dao.getRows(sortierung, filters);
            int count = containers.length;
            Assessment[] result = new Assessment[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new Assessment(hftp, true);
                AssessmentPersistencyManager.fillAssessment(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void load(Assessment assessment) {
        AssessmentContainer container = null;
        try {
            container = dao.getRowByObjectID(assessment.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)assessment.getObjectid());
        }
        AssessmentPersistencyManager.fillAssessment(assessment, container);
    }

    public static void save(Assessment assessment) {
        AssessmentContainer container = dao.getInitializedInstance();
        AssessmentPersistencyManager.fillContainer(container, assessment);
        try {
            container = assessment.isNew() ? dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        assessment.setLastuser(container.getLastUserid());
        assessment.setObjectid(container.getObjectid());
        assessment.setTimestamp(container.getObjectTS());
        assessment.setVersion(container.getVersion());
    }

    public static void delete(Assessment assessment) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), assessment.getObjectid(), assessment.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static void fillAssessment(Assessment assessment, AssessmentContainer container) {
        if (assessment.getHealthFundTP() == null) {
            assessment.setHealthFundTP(new HealthFundTP(container.oidhealthfundtp));
        }
        assessment.setData(new AssessmentData(container.assessmentkey, container.serialnumber, container.submitpercentage, container.refundpcgenerale));
        assessment.setLastuser(container.getLastUserid());
        assessment.setObjectid(container.getObjectid());
        assessment.setTimestamp(container.getObjectTS());
        assessment.setVersion(container.getVersion());
    }

    private static void fillContainer(AssessmentContainer container, Assessment assessment) {
        container.setObjectid(assessment.getObjectid());
        container.setObjectTS(assessment.getTimestamp());
        container.setLastUserid(assessment.getLastuser());
        container.setVersion(assessment.getVersion());
        container.oidhealthfundtp = assessment.getHealthFundTP().getObjectid();
        container.assessmentkey = assessment.getAssessmentKey();
        container.serialnumber = assessment.getSerialNumber();
        container.submitpercentage = assessment.getSubmitPercentage();
        container.refundpcgenerale = assessment.getRefundPercentage();
    }
}

