/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.CertificateCalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.employee.attachment.AttachmentTableEnum;
import com.varial.personnel.domain.employee.attachment.EEAttachment;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTP;
import com.varial.personnel.domain.employee.attachment.ModeOfAttachmentEnum;
import com.varial.personnel.domain.employee.loan.EELoanTP;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.PfaendungsbetragZpo2011Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

public class ErmittlungPfaendungsbetragNeuFormula {
    protected final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    protected final ValuePositionLibrary wplib;
    private final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    protected EEAttachmentTP mPfaendungsVertrag = null;
    private Date mPfaendungsVertragGueltigBis = null;
    protected BigDecimal mPfaendungsBrutto = BigDecimal.ZERO;
    protected BigDecimal mPfaendungsBruttoZVK = BigDecimal.ZERO;
    protected BigDecimal mPfaendungsBruttoSVPflichtig = BigDecimal.ZERO;
    protected BigDecimal mPfaendungsBruttoStPflichtig = BigDecimal.ZERO;
    protected BigDecimal mGesetzlicheAbzuege = BigDecimal.ZERO;
    private BigDecimal mPfaendungsNetto = BigDecimal.ZERO;
    private BigDecimal mPfaendungsBetrag = BigDecimal.ZERO;
    private BigDecimal mPfaendungsRestBetrag = BigDecimal.ZERO;
    private BigDecimal mPfaendungsRate = BigDecimal.ZERO;
    private BigDecimal mPfaendungsRateLStJA = BigDecimal.ZERO;
    private BigDecimal mGlaeubigerGebuehr = BigDecimal.ZERO;
    private BigDecimal mArbeitgebergebuehr = BigDecimal.ZERO;
    private BigDecimal mAufgelPfaendung = BigDecimal.ZERO;
    private BigDecimal mPfaendungsRateZPO = BigDecimal.ZERO;
    private PfaendungsbetragZpo2011Formula mZPOFormula;
    protected BigDecimal mPfaendungsNettoOhneZPO = BigDecimal.ZERO;
    private BigDecimal mBavAbzuege = BigDecimal.ZERO;
    private BigDecimal mBavAbzuegeSVFrei = BigDecimal.ZERO;
    private BigDecimal mBavAbzuegeSTFrei = BigDecimal.ZERO;
    private boolean mHatFiktivesPfaendungsbrutto = false;
    protected boolean mIsNettoMethode;

    public ErmittlungPfaendungsbetragNeuFormula(CalculationLibrary calLib, EmployeeLibrary eeLib, ValuePositionLibrary wpLib, GlobalLibrary glLib) {
        this.callib = calLib;
        this.eelib = eeLib;
        this.gllib = glLib;
        this.wplib = wpLib;
    }

    public void ermittel() throws BusinessDomainException {
        if (this.callib.isBerechnungNachAustritt()) {
            return;
        }
        this.selektierePfaendungsVertrag();
        this.setNettoMethode();
        if ((!this.mPfaendungsVertrag.getRevaluation() || DateHelper.before((Date)this.mPfaendungsVertragGueltigBis, (Date)this.callib.berchnungWirksamAb())) && DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)this.callib.berchnungWirksamAb())) {
            this.selectierePfaendungausSichtVormonat();
        } else {
            if (this.mIsNettoMethode) {
                this.ermittlePfaendungsNettoNettomethode();
            } else {
                this.ermittlePfaendungsNetto();
            }
            this.mZPOFormula = new PfaendungsbetragZpo2011Formula(this.callib, this.eelib, this.gllib, this.wplib, this.mPfaendungsNetto, this.mPfaendungsVertrag, this.mPfaendungsNettoOhneZPO, this.mHatFiktivesPfaendungsbrutto);
            if (this.mPfaendungsVertrag.getAttachmentTable() != AttachmentTableEnum.ATE_fester_Betrag_ohne_ZPO && (this.mPfaendungsVertrag.getAttachmentTable() != AttachmentTableEnum.ATE_monatliche_Pfaendungsrate || this.mPfaendungsVertrag.getModeOfAttachment().value() != 3)) {
                this.ermittlePfaendungsbetragZPO();
            }
            this.ermittlePfaendungsBetrag();
            switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
                case 4: {
                    break;
                }
                case 3: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsBetrag)) break;
                }
                default: {
                    this.selectiereRestbetragPfaendungausVormonat();
                }
            }
            this.ermittleAufgelPfaendungsRate();
            this.ermittlePfaendungsRate();
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2016, 0, 1).getDate())) {
                this.checkLStJA();
            }
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)this.callib.berchnungWirksamAb())) {
                if (this.mPfaendungsRate.compareTo(BigDecimal.ZERO) > 0) {
                    this.ermittleGlaeubigerGebuehr();
                    this.ermittleArbeitgeberGebuehr();
                }
            } else if (this.mPfaendungsVertrag.getRevaluation()) {
                if (this.mPfaendungsRate.compareTo(BigDecimal.ZERO) > 0) {
                    this.ermittleGlaeubigerGebuehr();
                    this.ermittleArbeitgeberGebuehr();
                }
            } else {
                this.ermittleGlaeubigerGebuehrVM();
                this.ermittleArbeitgeberGebuehrVM();
            }
            ValuePosition vp = (ValuePosition)this.wplib.wertPosition().getGenesisOfParentObjects();
            vp.setResult(this.mPfaendungsRate.add(this.mPfaendungsRateLStJA));
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getPercentageOfCoequalAttachments())) {
                vp.setPercentage(this.mPfaendungsVertrag.getPercentageOfCoequalAttachments());
            }
            this.erzeugeWertpositionen();
        }
        this.callib.result(this.mPfaendungsRate);
    }

    protected void setNettoMethode() {
        this.mIsNettoMethode = this.mPfaendungsVertrag.isNetMethod();
    }

    private void ermittleAufgelPfaendungsRate() throws BusinessDomainException {
        this.mAufgelPfaendung = this.aktuellePfaendungenBisher();
    }

    private void ermittlePfaendungsbetragZPO() throws BusinessDomainException {
        this.mZPOFormula.ermittel();
        this.mPfaendungsRateZPO = this.callib.pfaendungsRate();
    }

    private void selektierePfaendungsVertrag() throws BusinessDomainException {
        try {
            this.mPfaendungsVertrag = ((EEAttachment)((ValuePosition)this.wplib.wertPosition().getGenesisOfParentObjects()).getGenesisOfParentObjects()).getEEAttachmentTP(this.wplib.wirksamAb(), this.wplib.gueltigAb());
            List eeAttachmentTPList = this.mPfaendungsVertrag.getEEAttachment().getHistory().getItems(VDate.getDateMax());
            if (!eeAttachmentTPList.isEmpty()) {
                this.mPfaendungsVertragGueltigBis = VDate.getDateMin();
                for (EEAttachmentTP tempEEAttachmentTP : eeAttachmentTPList) {
                    if (!DateHelper.after((Date)tempEEAttachmentTP.getValidUntil(), (Date)this.mPfaendungsVertragGueltigBis)) continue;
                    this.mPfaendungsVertragGueltigBis = tempEEAttachmentTP.getValidUntil();
                }
            }
        }
        catch (ClassCastException e) {
            throw EvaluationExceptionMapper.makeNoEEAttachmentGenesisDomainException((ValuePosition)this.wplib.wertPosition().getGenesisOfParentObjects(), this.callib.berchnungGueltigAb());
        }
    }

    private void ermittlePfaendungsNettoNettomethode() throws BusinessDomainException {
        switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
            case 3: {
                this.ermittlePfaendungsBruttoUnterhalt();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoUnterhaltOhneZPO();
                break;
            }
            case 4: {
                this.ermittlePfaendungsBruttoPrivInsolvenz();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoPrivInsolvenzOhneZPO();
                break;
            }
            case 2: {
                this.ermittlePfaendungsBruttoSachpfaendung();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoSachpfaendungOhneZPO();
                break;
            }
            case 0: {
                this.ermittlePfaendungsBruttoAbtretung();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoAbtretungOhneZPO();
                break;
            }
            case 1: {
                this.ermittlePfaendungsBruttoVorpfaendung();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoVorpfaendungOhneZPO();
                break;
            }
        }
        this.mBavAbzuege = this.ermittleAbzuegeBAV();
        this.mPfaendungsBruttoStPflichtig = this.mPfaendungsBruttoStPflichtig.subtract(this.mBavAbzuegeSTFrei);
        this.mPfaendungsBruttoSVPflichtig = this.mPfaendungsBruttoSVPflichtig.subtract(this.mBavAbzuegeSVFrei);
        if (this.mPfaendungsBrutto.compareTo(BigDecimal.ZERO) != 0) {
            TypeOfCalculationCase typeOfCalculationCase = this.mPfaendungsVertrag.isCutPartialPayPeriod() && this.mHatFiktivesPfaendungsbrutto ? TypeOfCalculationCase.PfaendungOhneFehlzeiten : TypeOfCalculationCase.Pfaendung;
            BigDecimal sVBeitraege = BigDecimal.ZERO;
            BigDecimal stAbzuege = BigDecimal.ZERO;
            if (this.mPfaendungsBruttoSVPflichtig.compareTo(this.mPfaendungsBruttoStPflichtig) == 0) {
                CertificateCalculationCase cc = new CertificateCalculationCase();
                cc.init(this.eelib.marb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), this.mPfaendungsBruttoSVPflichtig, typeOfCalculationCase);
                cc.setZVKBrutto(this.mPfaendungsBruttoZVK);
                cc.start();
                sVBeitraege = cc.getSVBeitraege();
                stAbzuege = cc.getStAbzuege();
                cc.removeValuesOfCalculation();
            } else {
                CertificateCalculationCase ccSV = new CertificateCalculationCase();
                ccSV.init(this.eelib.marb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), this.mPfaendungsBruttoSVPflichtig, typeOfCalculationCase);
                ccSV.setZVKBrutto(this.mPfaendungsBruttoZVK);
                ccSV.start();
                sVBeitraege = ccSV.getSVBeitraege();
                ccSV.removeValuesOfCalculation();
                CertificateCalculationCase ccSt = new CertificateCalculationCase();
                ccSt.init(this.eelib.marb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), this.mPfaendungsBruttoStPflichtig, typeOfCalculationCase);
                ccSt.setZVKBrutto(this.mPfaendungsBruttoZVK);
                ccSt.start();
                stAbzuege = ccSt.getStAbzuege();
                ccSt.removeValuesOfCalculation();
            }
            this.mPfaendungsNetto = this.mPfaendungsBrutto.subtract(sVBeitraege).subtract(stAbzuege);
        }
        BigDecimal aTZAufstockung = this.ermittleATZAufstockung();
        BigDecimal zvkAnUmlage = this.ermittleZVKANBeitraege();
        BigDecimal zusaetzlichesPfaendungsnetto = this.ermittleZusaetzlichesPfaengungsnetto();
        this.mPfaendungsNetto = this.mPfaendungsNetto.subtract(this.mBavAbzuege).subtract(zvkAnUmlage).add(aTZAufstockung).add(zusaetzlichesPfaendungsnetto);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getAddAmount())) {
            this.mPfaendungsNetto = this.mPfaendungsNetto.add(this.mPfaendungsVertrag.getAddAmount());
        }
    }

    private void ermittlePfaendungsNetto() throws BusinessDomainException {
        switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
            case 3: {
                this.ermittlePfaendungsBruttoUnterhalt();
                this.ermittleGesetzlicheAbzuege();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoUnterhaltOhneZPO();
                break;
            }
            case 4: {
                this.ermittlePfaendungsBruttoPrivInsolvenz();
                this.ermittleGesetzlicheAbzuege();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoPrivInsolvenzOhneZPO();
                break;
            }
            case 2: {
                this.ermittlePfaendungsBruttoSachpfaendung();
                this.ermittleGesetzlicheAbzuege();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoSachpfaendungOhneZPO();
                break;
            }
            case 0: {
                this.ermittlePfaendungsBruttoAbtretung();
                this.ermittleGesetzlicheAbzuege();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoAbtretungOhneZPO();
                break;
            }
            case 1: {
                this.ermittlePfaendungsBruttoVorpfaendung();
                this.ermittleGesetzlicheAbzuege();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) break;
                this.ermittlePfaendungsBruttoVorpfaendungOhneZPO();
                break;
            }
        }
        BigDecimal bavAbzuege = this.ermittleAbzuegeBAV();
        BigDecimal aTZAufstockung = this.ermittleATZAufstockung();
        BigDecimal zusaetzlichesPfaendungsnetto = this.ermittleZusaetzlichesPfaengungsnetto();
        this.mPfaendungsNetto = this.mPfaendungsBrutto.subtract(this.mGesetzlicheAbzuege).subtract(bavAbzuege).add(aTZAufstockung).add(zusaetzlichesPfaendungsnetto);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getAddAmount())) {
            this.mPfaendungsNetto = this.mPfaendungsNetto.add(this.mPfaendungsVertrag.getAddAmount());
        }
    }

    private void ermittlePfaendungsBruttoVorpfaendungOhneZPO() throws BusinessDomainException {
        this.pfaendungsnettoOhneZPO(141430);
    }

    private void ermittlePfaendungsBruttoAbtretungOhneZPO() throws BusinessDomainException {
        this.pfaendungsnettoOhneZPO(141330);
    }

    private void ermittlePfaendungsBruttoSachpfaendungOhneZPO() throws BusinessDomainException {
        this.pfaendungsnettoOhneZPO(141230);
    }

    private void ermittlePfaendungsBruttoPrivInsolvenzOhneZPO() throws BusinessDomainException {
        this.pfaendungsnettoOhneZPO(141180);
    }

    private void ermittlePfaendungsBruttoUnterhaltOhneZPO() throws BusinessDomainException {
        this.pfaendungsnettoOhneZPO(141140);
    }

    private void pfaendungsnettoOhneZPO(int pfaendungBruttoOhneZpo) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{pfaendungBruttoOhneZpo}))) {
            ValuePosition[] vpArray2;
            this.mPfaendungsNettoOhneZPO = this.mPfaendungsNettoOhneZPO.add(vPos.getResult());
            block5: for (ValuePosition vPos2 : vpArray2 = this.wplib.genesisUndFolgen(vPos)) {
                if (vPos2.getValueType().getValueTypeTP(vPos2.getEffectiveFrom(), vPos2.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 20) {
                    this.mPfaendungsNettoOhneZPO = this.mPfaendungsNettoOhneZPO.subtract(vPos2.getResult());
                    this.mGesetzlicheAbzuege = this.mGesetzlicheAbzuege.subtract(vPos2.getResult());
                    continue;
                }
                if (vPos2.getValueType().getValueTypeTP(vPos2.getEffectiveFrom(), vPos2.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 19) {
                    this.mPfaendungsNettoOhneZPO = this.mPfaendungsNettoOhneZPO.add(vPos2.getResult());
                    this.mGesetzlicheAbzuege = this.mGesetzlicheAbzuege.add(vPos2.getResult());
                    continue;
                }
                switch (vPos2.getValueType().getValueTypeKey()) {
                    case 100921: 
                    case 100922: 
                    case 100923: 
                    case 100924: 
                    case 100941: 
                    case 100942: 
                    case 100943: 
                    case 100944: 
                    case 770000: 
                    case 770005: 
                    case 770010: 
                    case 770110: 
                    case 771000: 
                    case 771010: 
                    case 771110: 
                    case 774510: 
                    case 774511: 
                    case 774512: 
                    case 774514: 
                    case 774550: 
                    case 774610: 
                    case 774620: 
                    case 774630: 
                    case 774730: 
                    case 774760: 
                    case 774761: 
                    case 774762: 
                    case 774764: 
                    case 774800: 
                    case 774860: 
                    case 774870: 
                    case 774880: 
                    case 774980: {
                        this.mPfaendungsNettoOhneZPO = this.mPfaendungsNettoOhneZPO.subtract(vPos2.getResult());
                        this.mGesetzlicheAbzuege = this.mGesetzlicheAbzuege.subtract(vPos2.getResult());
                        continue block5;
                    }
                    case 230510: 
                    case 770020: 
                    case 770025: 
                    case 770030: 
                    case 770035: 
                    case 770040: 
                    case 770045: 
                    case 770120: 
                    case 770130: 
                    case 770140: 
                    case 771020: 
                    case 771030: 
                    case 771040: 
                    case 771120: 
                    case 771130: 
                    case 771140: 
                    case 775510: 
                    case 775512: 
                    case 775514: 
                    case 775520: 
                    case 775550: 
                    case 775555: 
                    case 775560: 
                    case 775610: 
                    case 775620: 
                    case 775630: 
                    case 775640: 
                    case 775650: 
                    case 775655: 
                    case 775720: 
                    case 775725: 
                    case 775730: {
                        this.mPfaendungsNettoOhneZPO = this.mPfaendungsNettoOhneZPO.add(vPos2.getResult());
                        this.mGesetzlicheAbzuege = this.mGesetzlicheAbzuege.add(vPos2.getResult());
                    }
                }
            }
        }
    }

    protected BigDecimal ermittleAbzuegeBAV() throws BusinessDomainException {
        ValuePosition[] bAVAbzuege;
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal resultSVFrei = BigDecimal.ZERO;
        BigDecimal resultSTFrei = BigDecimal.ZERO;
        for (ValuePosition vPos : bAVAbzuege = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{863130, 863110, 863160, 863150, 863120, 862110, 886210}))) {
            ValuePosition[] parentUndFolgen;
            Date eintrittBAV = VDate.getDateMin();
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2016, 0, 1).getDate())) {
                ValuePosition genesis = (ValuePosition)vPos.getGenesisOfParentObjects();
                PersistentObject object = genesis.getGenesisOfParentObjects();
                if (object instanceof EEPensionSchemeTP) {
                    EEPensionSchemeTP eePensionSchemeTP = (EEPensionSchemeTP)object;
                    eintrittBAV = eePensionSchemeTP.getDateOfEntry();
                }
                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2024, 0, 1).getDate()) && object instanceof EELoanTP) {
                    EELoanTP eeLoanTP = (EELoanTP)object;
                    eintrittBAV = eeLoanTP.getStartRepayment();
                }
            }
            if (!DateHelper.before((Date)eintrittBAV, (Date)this.mPfaendungsVertrag.getReceptDate())) continue;
            block6: for (ValuePosition element : parentUndFolgen = this.wplib.parentUndFolgen((ValuePosition)vPos.getParentObject())) {
                if (BigDecimalMapper.compareTo((BigDecimal)vPos.getResult(), (BigDecimal)BigDecimal.ZERO) <= 0) continue;
                switch (element.getValueType().getValueTypeKey()) {
                    case 145130: 
                    case 145140: 
                    case 145180: 
                    case 145190: 
                    case 145230: 
                    case 145235: 
                    case 145240: 
                    case 145245: 
                    case 145280: 
                    case 145290: 
                    case 145330: 
                    case 145335: 
                    case 145340: 
                    case 145345: 
                    case 145380: 
                    case 145385: 
                    case 145390: 
                    case 145395: 
                    case 862110: 
                    case 886210: {
                        result = result.add(element.getResult());
                        continue block6;
                    }
                    case 110510: 
                    case 110610: 
                    case 110620: {
                        if (!this.mIsNettoMethode) continue block6;
                        resultSTFrei = resultSTFrei.add(element.getResult());
                        continue block6;
                    }
                    case 130510: 
                    case 130515: 
                    case 130520: 
                    case 130610: {
                        if (!this.mIsNettoMethode) continue block6;
                        resultSVFrei = resultSVFrei.add(element.getResult());
                    }
                }
            }
        }
        this.mBavAbzuegeSTFrei = resultSTFrei.negate();
        this.mBavAbzuegeSVFrei = resultSVFrei.negate();
        return result;
    }

    private BigDecimal ermittleATZAufstockung() throws BusinessDomainException {
        return this.wplib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes((int[])new int[]{99971}));
    }

    private void ermittlePfaendungsBetrag() {
        switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
            case 4: {
                break;
            }
            default: {
                this.mPfaendungsBetrag = this.mPfaendungsVertrag.getAttachingAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsBetrag)) break;
                this.mPfaendungsBetrag = BigDecimal.ZERO;
            }
        }
    }

    private BigDecimal ermittleZusaetzlichesPfaengungsnetto() throws BusinessDomainException {
        return this.wplib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes((int[])new int[]{141060}));
    }

    private void ermittlePfaendungsRate() throws BusinessDomainException {
        switch (this.mPfaendungsVertrag.getAttachmentTable().value()) {
            case 1: 
            case 2: {
                if (this.mPfaendungsVertrag.getAttachmentTable() == AttachmentTableEnum.ATE_fester_Betrag_ohne_ZPO || this.mPfaendungsVertrag.getModeOfAttachment().value() == 3) {
                    BigDecimal pfaendungsNetto;
                    this.mPfaendungsRate = this.mPfaendungsVertrag.getMonthlyInstalment();
                    if (this.mPfaendungsVertrag.getUnattachableAmount().compareTo(BigDecimal.ZERO) == 0) break;
                    BigDecimal pfandfreierBetrag = this.mPfaendungsVertrag.getUnattachableAmount();
                    if (this.mPfaendungsVertrag.isCutPartialPayPeriod() && this.eelib.isTeilLZZVorhanden()) {
                        BigDecimal anzKalenderTage = BigDecimal.valueOf(new VDate(DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb())).getDay());
                        pfandfreierBetrag = pfandfreierBetrag.multiply(this.mZPOFormula.ermittelKalendertageMitarbeiter()).divide(anzKalenderTage, 2, RoundingMode.HALF_UP);
                    }
                    if (this.mPfaendungsVertrag.getUnattachablePercentage().compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal diff = this.mPfaendungsNetto.subtract(pfandfreierBetrag);
                        diff = diff.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : diff.multiply(this.mPfaendungsVertrag.getUnattachablePercentage()).divide(this.EINHUNDERT, 2, RoundingMode.UP);
                        pfandfreierBetrag = pfandfreierBetrag.add(diff);
                    }
                    if (this.mPfaendungsRate.compareTo(pfaendungsNetto = this.mPfaendungsNetto.subtract(this.mAufgelPfaendung).subtract(pfandfreierBetrag)) <= 0) break;
                    this.mPfaendungsRate = pfaendungsNetto;
                    if (this.mPfaendungsRate.compareTo(BigDecimal.ZERO) >= 0) break;
                    this.mPfaendungsRate = BigDecimal.ZERO;
                    break;
                }
                if (this.mPfaendungsVertrag.getMonthlyInstalment().compareTo(this.mPfaendungsRateZPO) > 0) {
                    this.mPfaendungsRate = this.mPfaendungsRateZPO;
                    break;
                }
                this.mPfaendungsRate = this.mPfaendungsVertrag.getMonthlyInstalment();
                break;
            }
            case 0: {
                this.mPfaendungsRate = this.mPfaendungsRateZPO;
            }
        }
        switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
            case 4: {
                break;
            }
            case 3: {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getAttachingAmount())) break;
            }
            default: {
                if (!BigDecimalMapper.isZero((BigDecimal)this.mPfaendungsRestBetrag)) {
                    if (this.mPfaendungsRestBetrag.compareTo(this.mPfaendungsRate) < 0) {
                        this.mPfaendungsRate = this.mPfaendungsRestBetrag;
                    }
                    new CalculationBasic(this.wplib.wertPosition().getEmployee(), this.wplib.wirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb())), "Pf\u00e4ndungsrestbetrag");
                    break;
                }
                this.mPfaendungsRate = BigDecimal.ZERO;
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getPercentageOfCoequalAttachments())) {
            this.mPfaendungsRate = this.mPfaendungsRate.multiply(this.mPfaendungsVertrag.getPercentageOfCoequalAttachments()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        if (this.mPfaendungsVertrag.getAttachmentTable().value() == 0) {
            if (this.mPfaendungsRate.compareTo(this.mPfaendungsRateZPO.subtract(this.mAufgelPfaendung)) > 0) {
                this.mPfaendungsRate = this.mPfaendungsRateZPO.subtract(this.mAufgelPfaendung);
                if (this.mPfaendungsRate.compareTo(BigDecimal.ZERO) < 0) {
                    this.mPfaendungsRate = BigDecimal.ZERO;
                }
            }
            if (this.mPfaendungsVertrag.isCutPartialPayPeriod() && this.mHatFiktivesPfaendungsbrutto && this.eelib.isTeilLZZVorhanden()) {
                this.mPfaendungsRate = this.mPfaendungsRate.multiply(this.wplib.svTage()).divide(BigDecimal.valueOf(30L), 2, RoundingMode.HALF_UP);
            }
        }
        if (this.mPfaendungsVertrag.isSuspendPaying()) {
            this.mPfaendungsRate = BigDecimal.ZERO;
        }
    }

    private void ermittleGlaeubigerGebuehr() {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getPercentageFeeOfCreditor())) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getFeeOfCreditor())) {
                this.mGlaeubigerGebuehr = this.mPfaendungsVertrag.getFeeOfCreditor();
            }
        } else {
            switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
                case 4: {
                    this.mGlaeubigerGebuehr = this.mPfaendungsRate.multiply(this.mPfaendungsVertrag.getPercentageFeeOfCreditor()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP);
                    break;
                }
                case 3: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getAttachingAmount())) {
                        this.mGlaeubigerGebuehr = this.mPfaendungsRate.multiply(this.mPfaendungsVertrag.getPercentageFeeOfCreditor()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP);
                        break;
                    }
                }
                default: {
                    this.mGlaeubigerGebuehr = this.mPfaendungsRate.compareTo(this.mPfaendungsRestBetrag) > 0 ? this.mPfaendungsRestBetrag.multiply(this.mPfaendungsVertrag.getPercentageFeeOfCreditor()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP) : this.mPfaendungsRate.multiply(this.mPfaendungsVertrag.getPercentageFeeOfCreditor()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP);
                }
            }
        }
    }

    private void ermittleGlaeubigerGebuehrVM() throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition valuePosition : vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.callib.berchnungWirksamAb())), DateHelper.yesterday((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.getWertartenGlaeubigerGebuehren())) {
            EEAttachment genesis = this.selectGenesis(valuePosition);
            if (!genesis.equals((Object)this.mPfaendungsVertrag.getEEAttachment())) continue;
            this.mGlaeubigerGebuehr = valuePosition.getResult();
            break;
        }
    }

    private EEAttachment selectGenesis(ValuePosition valuePosition) {
        if (valuePosition.getGenesisOfParentObjects() instanceof EEAttachment) {
            return (EEAttachment)valuePosition.getGenesisOfParentObjects();
        }
        return this.selectGenesis((ValuePosition)valuePosition.getGenesisOfParentObjects());
    }

    private ValueType[] getWertartenGlaeubigerGebuehren() {
        ValueType[] result = null;
        switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
            case 3: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795260});
                break;
            }
            case 4: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795265});
                break;
            }
            case 2: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795270});
                break;
            }
            case 0: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795280});
                break;
            }
            case 1: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795290});
            }
        }
        return result;
    }

    private ValueType[] getWertartenAGGebuehren() throws BusinessDomainException {
        ValueType[] result = null;
        switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
            case 3: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795360});
                break;
            }
            case 4: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795365});
                break;
            }
            case 2: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795370});
                break;
            }
            case 0: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795380});
                break;
            }
            case 1: {
                result = ValueTypeHelper.getValueTypes((int[])new int[]{795390});
            }
        }
        return result;
    }

    private void ermittleArbeitgeberGebuehrVM() throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition valuePosition : vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.callib.berchnungWirksamAb())), DateHelper.yesterday((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.getWertartenAGGebuehren())) {
            EEAttachment genesis = this.selectGenesis(valuePosition);
            if (!genesis.equals((Object)this.mPfaendungsVertrag.getEEAttachment())) continue;
            this.mArbeitgebergebuehr = valuePosition.getResult();
            break;
        }
    }

    private void ermittleArbeitgeberGebuehr() {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getPercentageFeeOfEmployer())) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getFeeOfEmployer())) {
                this.mArbeitgebergebuehr = this.mPfaendungsVertrag.getFeeOfEmployer();
            }
        } else {
            switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
                case 4: {
                    this.mArbeitgebergebuehr = this.mPfaendungsRate.multiply(this.mPfaendungsVertrag.getPercentageFeeOfEmployer()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP);
                    break;
                }
                case 3: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getAttachingAmount())) {
                        this.mArbeitgebergebuehr = this.mPfaendungsRate.multiply(this.mPfaendungsVertrag.getPercentageFeeOfEmployer()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP);
                        break;
                    }
                }
                default: {
                    this.mArbeitgebergebuehr = this.mPfaendungsRate.compareTo(this.mPfaendungsRestBetrag) > 0 ? this.mPfaendungsRestBetrag.multiply(this.mPfaendungsVertrag.getPercentageFeeOfEmployer()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP) : this.mPfaendungsRate.multiply(this.mPfaendungsVertrag.getPercentageFeeOfEmployer()).divide(this.EINHUNDERT, 2, RoundingMode.HALF_UP);
                }
            }
        }
    }

    private void erzeugeWertpositionen() throws BusinessDomainException {
        if (this.mPfaendungsNetto.compareTo(BigDecimal.ZERO) > 0) {
            switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
                case 3: {
                    this.wplib.addNeueWertPosition(795110, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, this.mBavAbzuege, this.mPfaendungsNetto, false);
                    break;
                }
                case 4: {
                    this.wplib.addNeueWertPosition(795115, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, this.mBavAbzuege, this.mPfaendungsNetto, false);
                    break;
                }
                case 2: {
                    this.wplib.addNeueWertPosition(795120, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, this.mBavAbzuege, this.mPfaendungsNetto, false);
                    break;
                }
                case 0: {
                    this.wplib.addNeueWertPosition(795130, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, this.mBavAbzuege, this.mPfaendungsNetto, false);
                    break;
                }
                case 1: {
                    this.wplib.addNeueWertPosition(795140, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, this.mBavAbzuege, this.mPfaendungsNetto, false);
                    break;
                }
            }
        }
        BigDecimal vhSatz = this.mPfaendungsVertrag.getPercentageFeeOfCreditor();
        if (this.mGlaeubigerGebuehr.compareTo(BigDecimal.ZERO) > 0) {
            switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
                case 3: {
                    this.wplib.addNeueWertPosition(795260, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mGlaeubigerGebuehr, false);
                    break;
                }
                case 4: {
                    this.wplib.addNeueWertPosition(795265, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mGlaeubigerGebuehr, false);
                    break;
                }
                case 2: {
                    this.wplib.addNeueWertPosition(795270, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mGlaeubigerGebuehr, false);
                    break;
                }
                case 0: {
                    this.wplib.addNeueWertPosition(795280, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mGlaeubigerGebuehr, false);
                    break;
                }
                case 1: {
                    this.wplib.addNeueWertPosition(795290, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mGlaeubigerGebuehr, false);
                    break;
                }
            }
        }
        vhSatz = this.mPfaendungsVertrag.getPercentageFeeOfEmployer();
        if (this.mArbeitgebergebuehr.compareTo(BigDecimal.ZERO) > 0) {
            switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
                case 3: {
                    this.wplib.addNeueWertPosition(795360, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mArbeitgebergebuehr, false);
                    break;
                }
                case 4: {
                    this.wplib.addNeueWertPosition(795365, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mArbeitgebergebuehr, false);
                    break;
                }
                case 2: {
                    this.wplib.addNeueWertPosition(795370, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mArbeitgebergebuehr, false);
                    break;
                }
                case 0: {
                    this.wplib.addNeueWertPosition(795380, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mArbeitgebergebuehr, false);
                    break;
                }
                case 1: {
                    this.wplib.addNeueWertPosition(795390, vhSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mArbeitgebergebuehr, false);
                    break;
                }
            }
        }
        switch (this.mPfaendungsVertrag.getModeOfAttachment().value()) {
            case 4: {
                break;
            }
            case 3: {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getAttachingAmount())) break;
            }
            default: {
                this.mPfaendungsRestBetrag = this.mPfaendungsRestBetrag.subtract(this.mPfaendungsRate).subtract(this.mPfaendungsRateLStJA);
                this.wplib.addNeueWertPosition(795565, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsVertrag.getAttachingAmount(), BigDecimal.ZERO, this.mPfaendungsRestBetrag, false);
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsRateLStJA)) {
            this.wplib.addNeueWertPosition(795551, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsRateLStJA, false);
        }
    }

    protected void ermittleGesetzlicheAbzuege() throws BusinessDomainException {
        ValuePosition[] vpArray;
        this.mGesetzlicheAbzuege = this.wplib.aktuelleAbzuegeVorNetto().subtract(this.wplib.aktuelleBezuegeVorNetto());
        block3: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{230510, 250510, 250610, 770110, 770120, 770130, 770140, 770000, 770005, 770010, 770020, 770025, 770030, 770035, 770040, 770045, 771110, 771120, 771130, 771140, 771000, 771010, 771020, 771030, 771040, 774510, 774511, 774512, 774514, 774550, 774610, 774620, 774630, 774730, 774760, 774761, 774762, 774764, 774800, 774860, 774870, 774880, 774980, 775510, 775512, 775514, 775520, 775550, 775555, 775560, 775610, 775620, 775630, 775640, 775650, 775655, 775720, 775720, 775725, 775730, 100944, 100942, 100941, 100943, 100924, 100922, 100921, 100923}))) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100921: 
                case 100922: 
                case 100923: 
                case 100924: 
                case 100941: 
                case 100942: 
                case 100943: 
                case 100944: 
                case 250510: 
                case 250610: 
                case 770000: 
                case 770005: 
                case 770010: 
                case 770110: 
                case 771000: 
                case 771010: 
                case 771110: 
                case 774510: 
                case 774511: 
                case 774512: 
                case 774514: 
                case 774550: 
                case 774610: 
                case 774620: 
                case 774630: 
                case 774730: 
                case 774760: 
                case 774761: 
                case 774762: 
                case 774764: 
                case 774800: 
                case 774860: 
                case 774870: 
                case 774880: 
                case 774980: {
                    this.mGesetzlicheAbzuege = this.mGesetzlicheAbzuege.add(vPos.getResult());
                    continue block3;
                }
                default: {
                    this.mGesetzlicheAbzuege = this.mGesetzlicheAbzuege.subtract(vPos.getResult());
                }
            }
        }
    }

    private BigDecimal ermittleZVKANBeitraege() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal zvkANBeitrag = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{100944, 100942, 100941, 100943, 100924, 100922, 100921, 100923}))) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100921: 
                case 100922: 
                case 100923: 
                case 100924: 
                case 100941: 
                case 100942: 
                case 100943: 
                case 100944: {
                    zvkANBeitrag = zvkANBeitrag.add(vPos.getResult());
                }
            }
        }
        return zvkANBeitrag;
    }

    protected void ermittlePfaendungsBruttoUnterhalt() throws BusinessDomainException {
        this.ermittlePfaendungsBrutto(ValueTypeHelper.getValueTypes((int[])new int[]{141100, 141110, 141120, 141130}));
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
            this.mPfaendungsNettoOhneZPO = this.wplib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes((int[])new int[]{141140}));
        }
    }

    protected void ermittlePfaendungsBruttoPrivInsolvenz() throws BusinessDomainException {
        this.ermittlePfaendungsBrutto(ValueTypeHelper.getValueTypes((int[])new int[]{141150, 141160, 141170}));
    }

    protected void ermittlePfaendungsBruttoSachpfaendung() throws BusinessDomainException {
        this.ermittlePfaendungsBrutto(ValueTypeHelper.getValueTypes((int[])new int[]{141200, 141210, 141220}));
    }

    protected void ermittlePfaendungsBruttoVorpfaendung() throws BusinessDomainException {
        this.ermittlePfaendungsBrutto(ValueTypeHelper.getValueTypes((int[])new int[]{141400, 141410, 141420}));
    }

    protected void ermittlePfaendungsBruttoAbtretung() throws BusinessDomainException {
        this.ermittlePfaendungsBrutto(ValueTypeHelper.getValueTypes((int[])new int[]{141300, 141310, 141320}));
    }

    private void ermittlePfaendungsBrutto(ValueType[] valueTypes) throws BusinessDomainException {
        BigDecimal fiktivesPfaendungsbrutto = this.ermittleFiktivesPfaendungsbrutto();
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)fiktivesPfaendungsbrutto)) {
            ValuePosition[] wpArray;
            BigDecimal resultGesamt = BigDecimal.valueOf(0L);
            BigDecimal resultStPflichtig = BigDecimal.valueOf(0L);
            BigDecimal resultSVPflichtig = BigDecimal.valueOf(0L);
            BigDecimal resultZVKPflichtig = BigDecimal.valueOf(0L);
            for (ValuePosition element : wpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), valueTypes)) {
                ValuePosition[] parentUndFolgen;
                resultGesamt = resultGesamt.add(element.getResult());
                block6: for (ValuePosition element2 : parentUndFolgen = this.wplib.parentUndFolgen((ValuePosition)element.getParentObject())) {
                    switch (element2.getValueType().getValueTypeKey()) {
                        case 110510: 
                        case 110610: 
                        case 110620: {
                            resultStPflichtig = resultStPflichtig.add(element.getResult());
                            continue block6;
                        }
                        case 130510: 
                        case 130515: 
                        case 130520: 
                        case 130610: {
                            resultSVPflichtig = resultSVPflichtig.add(element.getResult());
                            continue block6;
                        }
                        case 100901: 
                        case 100902: 
                        case 100903: 
                        case 100904: 
                        case 100905: {
                            if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2025, 0, 1).getDate())) continue block6;
                            resultZVKPflichtig = resultZVKPflichtig.add(element.getResult());
                        }
                    }
                }
            }
            this.mPfaendungsBrutto = resultGesamt;
            this.mPfaendungsBruttoStPflichtig = resultStPflichtig;
            this.mPfaendungsBruttoSVPflichtig = resultSVPflichtig;
            this.mPfaendungsBruttoZVK = resultZVKPflichtig;
        } else {
            this.mHatFiktivesPfaendungsbrutto = true;
            this.mPfaendungsBrutto = fiktivesPfaendungsbrutto;
            this.mPfaendungsBruttoStPflichtig = fiktivesPfaendungsbrutto;
            this.mPfaendungsBruttoSVPflichtig = fiktivesPfaendungsbrutto;
            if (this.eelib.isMarbZVKPflichtig()) {
                this.mPfaendungsBruttoZVK = fiktivesPfaendungsbrutto;
            }
        }
    }

    private BigDecimal ermittleFiktivesPfaendungsbrutto() throws BusinessDomainException {
        if (this.mIsNettoMethode && this.mPfaendungsVertrag.isCutPartialPayPeriod()) {
            return this.wplib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes((int[])new int[]{141050}));
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal aktuellePfaendungenBisher() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{795060, 795061, 795070, 795080, 795090, 795550, 795551}))) {
            result = result.add(vPos.getResult());
        }
        return result;
    }

    private void selectiereRestbetragPfaendungausVormonat() throws BusinessDomainException {
        if (this.mPfaendungsVertrag.getLastChangingAttachmentAmount() != null && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.mPfaendungsVertrag.getLastChangingAttachmentAmount()), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            this.mPfaendungsRestBetrag = this.mPfaendungsVertrag.getAttachingAmount();
        } else {
            ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.wplib.gueltigAb())), DateHelper.yesterday((Date)this.wplib.gueltigAb()), this.wplib.genesisParent().getGenesisOfParentObjects());
            ValuePosition vpGenesis = null;
            ValuePosition vpRestBetrag = null;
            if (vpArray.length == 1) {
                vpGenesis = vpArray[0];
                vpRestBetrag = this.wplib.folgeWertartVomGenesisDB((PersistentObject)vpGenesis, 795565);
            }
            this.mPfaendungsRestBetrag = vpRestBetrag != null ? (this.mPfaendungsVertrag.getLastChangingAttachmentAmount() != null && DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.mPfaendungsVertrag.getLastChangingAttachmentAmount()), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb())) ? this.mPfaendungsVertrag.getAttachingAmount() : vpRestBetrag.getResult()) : this.mPfaendungsVertrag.getAttachingAmount();
            if (this.mPfaendungsRestBetrag.compareTo(BigDecimal.ZERO) > 0) {
                new CalculationBasic(this.wplib.wertPosition().getEmployee(), this.wplib.wirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb())), "Pf\u00e4ndungsabbau");
            }
        }
    }

    private void checkLStJA() throws BusinessDomainException {
        BigDecimal summeLStJA;
        if (this.mPfaendungsVertrag.getSpecialDecision() && DateHelper.getMonth((Date)this.callib.berchnungGueltigAb()) + 1 == 12 && !BigDecimalMapper.isZeroOrNull((BigDecimal)(summeLStJA = this.getWerteLStJA()))) {
            BigDecimal gesamtPfaendung;
            this.mPfaendungsRateLStJA = summeLStJA;
            if (this.mPfaendungsVertrag.getModeOfAttachment() != ModeOfAttachmentEnum.MOAE_private_Insolvenz && this.mPfaendungsRestBetrag.compareTo(gesamtPfaendung = this.mPfaendungsRateLStJA.add(this.mPfaendungsRate)) < 0) {
                this.mPfaendungsRateLStJA = this.mPfaendungsRestBetrag.subtract(this.mPfaendungsRate);
                if (this.mPfaendungsRateLStJA.compareTo(BigDecimal.ZERO) < 0) {
                    this.mPfaendungsRateLStJA = BigDecimal.ZERO;
                }
            }
        }
    }

    private BigDecimal getWerteLStJA() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition vpos : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{760100, 760110, 760120, 760130}))) {
            result = result.add(vpos.getResult());
        }
        return result;
    }

    private void selectierePfaendungausSichtVormonat() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.wplib.wirksamAb())), DateHelper.yesterday((Date)this.wplib.wirksamAb()), this.wplib.gueltigAb(), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), this.wplib.genesisParent().getGenesisOfParentObjects());
        ValuePosition vpGenesis = null;
        ValuePosition[] vPos = null;
        if (vpArray.length > 0) {
            vpGenesis = vpArray[0];
            block19: for (ValuePosition vp : vPos = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.wplib.wirksamAb())), DateHelper.yesterday((Date)this.wplib.wirksamAb()), this.wplib.gueltigAb(), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), (PersistentObject)vpGenesis)) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 795110: {
                        this.wplib.addNeueWertPosition(795110, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, vp.getFactor2(), vp.getResult(), false);
                        continue block19;
                    }
                    case 795115: {
                        this.wplib.addNeueWertPosition(795115, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, vp.getFactor2(), vp.getResult(), false);
                        continue block19;
                    }
                    case 795120: {
                        this.wplib.addNeueWertPosition(795120, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, vp.getFactor2(), vp.getResult(), false);
                        continue block19;
                    }
                    case 795130: {
                        this.wplib.addNeueWertPosition(795130, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, vp.getFactor2(), vp.getResult(), false);
                        continue block19;
                    }
                    case 795140: {
                        this.wplib.addNeueWertPosition(795140, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsBrutto, vp.getFactor2(), vp.getResult(), false);
                        continue block19;
                    }
                    case 795260: {
                        this.wplib.addNeueWertPosition(795260, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795265: {
                        this.wplib.addNeueWertPosition(795265, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795270: {
                        this.wplib.addNeueWertPosition(795270, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795280: {
                        this.wplib.addNeueWertPosition(795280, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795290: {
                        this.wplib.addNeueWertPosition(795290, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795360: {
                        this.wplib.addNeueWertPosition(795360, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795365: {
                        this.wplib.addNeueWertPosition(795365, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795370: {
                        this.wplib.addNeueWertPosition(795370, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795380: {
                        this.wplib.addNeueWertPosition(795380, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795390: {
                        this.wplib.addNeueWertPosition(795390, vp.getPercentage(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795565: {
                        this.wplib.addNeueWertPosition(795565, BigDecimal.ZERO, BigDecimal.ZERO, this.mPfaendungsVertrag.getAttachingAmount(), BigDecimal.ZERO, vp.getResult(), false);
                        continue block19;
                    }
                    case 795551: {
                        this.wplib.addNeueWertPosition(795551, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, vp.getResult(), false);
                        this.mPfaendungsRateLStJA = vp.getResult();
                        continue block19;
                    }
                    default: {
                        if (vp.getValueType().getValueTypeKey() != this.wplib.wertartenNummer()) continue block19;
                        vpGenesis.setResult(vpGenesis.getResult().add(vp.getResult()));
                        this.mPfaendungsRate = vp.getResult();
                    }
                }
            }
        }
        ValuePosition vp = (ValuePosition)this.wplib.wertPosition().getGenesisOfParentObjects();
        vp.setResult(this.mPfaendungsRate.add(this.mPfaendungsRateLStJA));
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPfaendungsVertrag.getPercentageOfCoequalAttachments())) {
            vp.setPercentage(this.mPfaendungsVertrag.getPercentageOfCoequalAttachments());
        }
    }
}

