/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eubp.dsan;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.EECompanyPlant;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.accidentinsurancefund.EEAccidentInsuranceFund;
import com.varial.personnel.domain.employee.accidentinsurancefund.partclassofrisk.PartClassOfRisk;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTP;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.relative.EERelativeTP;
import com.varial.personnel.domain.employee.relative.FlagCalculationEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.vblu.EEVBLU;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalcAddContEnum;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalculationEnum;
import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.dsan.EubpDsan;
import com.varial.personnel.domain.eubp.dsan.PartDsanGt;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTP;
import com.varial.personnel.domain.global.ageparttimemodel.ContractEnum;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PartDsan {
    private final EubpDsan mDsan;
    private EubpAccount mAccount;
    private Date mGltab;
    private String mAenddat;
    private String mAzvualt;
    private String mAzvuweiter;
    private Date mErsteintr;
    private Date mEintr;
    private Date mAustr;
    private String mName;
    private String mGbname;
    private String mVoname;
    private String mGe;
    private String mLdkz;
    private String mPlz;
    private String mOrt;
    private String mStr;
    private String mHnr;
    private String mEuvsnr;
    private Date mGbdt;
    private String mGbort;
    private String mSasc;
    private String mToddat;
    private String mKennzrk;
    private String mKennzpvs;
    private String mKnr;
    private String mBlz;
    private String mIban;
    private String mBic;
    private String mStkl;
    private String mKistpf;
    private BigDecimal mKifrbtrg;
    private String mEgstfrbtrg;
    private String mTt;
    private String mTtsc;
    private int mPersgr;
    private int mBygrkv;
    private int mBygrrv;
    private int mBygrav;
    private int mBygrpv;
    private String mKennzgv;
    private String mKennzmf;
    private String mKennzmfb;
    private String mKennzsta;
    private String mBbnrkk;
    private String mBbnrkkum;
    private BigDecimal mGesbyprivkv;
    private BigDecimal mGesbyprivpv;
    private String mBbnrvw;
    private String mKennzzva;
    private String mZva;
    private String mKennzbau;
    private String mAzwoech;
    private String mKennzgle;
    private String mKennzbefrvp;
    private String mKennzverzgle;
    private String mKennzverzrvfgb;
    private String mKennzverzrvpgb;
    private String mKennzwg;
    private String mKennzelt;
    private String mKennzkg;
    private String mKennzvbe;
    private String mKennzrbz;
    private String mKennzatz;
    private String mKennzatzalt;
    private Date mAtzbg;
    private Date mAtzen;
    private Date mFpbeg;
    private Date mWgsBg;
    private Date mWgsEn;
    private Date mWgsFpBeg;
    private boolean mMmkn = false;
    private boolean mMms3 = false;
    private final List<PartDsanGt> mPartDsanGtList = new ArrayList<PartDsanGt>();

    public PartDsan(EubpDsan dsan) {
        this.mDsan = dsan;
    }

    public Date getGltab() {
        return this.mGltab;
    }

    public void setGltab(Date gltab) {
        this.mGltab = gltab;
    }

    public String getAenddat() {
        return this.mAenddat;
    }

    public void setAenddat(String aenddat) {
        this.mAenddat = aenddat;
    }

    public String getAzvualt() {
        return this.mAzvualt;
    }

    public void setAzvualt(String azvualt) {
        this.mAzvualt = azvualt;
    }

    public String getAzvuweiter() {
        return this.mAzvuweiter;
    }

    public void setAzvuweiter(String azvuweiter) {
        this.mAzvuweiter = azvuweiter;
    }

    public Date getErsteintr() {
        return this.mErsteintr;
    }

    public void setErsteintr(Date ersteintr) {
        this.mErsteintr = ersteintr;
    }

    public Date getEintr() {
        return this.mEintr;
    }

    public void setEintr(Date eintr) {
        this.mEintr = eintr;
    }

    public Date getAustr() {
        return this.mAustr;
    }

    public void setAustr(Date austr) {
        this.mAustr = austr;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getGbname() {
        return this.mGbname;
    }

    public void setGbname(String gbname) {
        this.mGbname = gbname;
    }

    public String getVoname() {
        return this.mVoname;
    }

    public void setVoname(String voname) {
        this.mVoname = voname;
    }

    public String getGe() {
        return this.mGe;
    }

    public void setGe(String ge) {
        this.mGe = ge;
    }

    public String getLdkz() {
        return this.mLdkz;
    }

    public void setLdkz(String ldkz) {
        this.mLdkz = ldkz;
    }

    public String getPlz() {
        return this.mPlz;
    }

    public void setPlz(String plz) {
        this.mPlz = plz;
    }

    public String getOrt() {
        return this.mOrt;
    }

    public void setOrt(String ort) {
        this.mOrt = ort;
    }

    public String getStr() {
        return this.mStr;
    }

    public void setStr(String str) {
        this.mStr = str;
    }

    public String getHnr() {
        return this.mHnr;
    }

    public void setHnr(String hnr) {
        this.mHnr = hnr;
    }

    public String getEuvsnr() {
        return this.mEuvsnr;
    }

    public void setEuvsnr(String euvsnr) {
        this.mEuvsnr = euvsnr;
    }

    public Date getGbdt() {
        return this.mGbdt;
    }

    public void setGbdt(Date gbdt) {
        this.mGbdt = gbdt;
    }

    public String getGbort() {
        return this.mGbort;
    }

    public void setGbort(String gbort) {
        this.mGbort = gbort;
    }

    public String getSasc() {
        return this.mSasc;
    }

    public void setSasc(String sasc) {
        this.mSasc = sasc;
    }

    public String getToddat() {
        return this.mToddat;
    }

    public void setToddat(String toddat) {
        this.mToddat = toddat;
    }

    public String getKennzrk() {
        return this.mKennzrk;
    }

    public void setKennzrk(String kennzrk) {
        this.mKennzrk = kennzrk;
    }

    public String getKennzpvs() {
        return this.mKennzpvs;
    }

    public void setKennzpvs(String kennzpvs) {
        this.mKennzpvs = kennzpvs;
    }

    public String getKnr() {
        return this.mKnr;
    }

    public void setKnr(String knr) {
        this.mKnr = knr;
    }

    public String getBlz() {
        return this.mBlz;
    }

    public void setBlz(String blz) {
        this.mBlz = blz;
    }

    public String getIban() {
        return this.mIban;
    }

    public void setIban(String iban) {
        this.mIban = iban;
    }

    public String getBic() {
        return this.mBic;
    }

    public void setBic(String bic) {
        this.mBic = bic;
    }

    public String getStkl() {
        return this.mStkl;
    }

    public void setStkl(String stkl) {
        this.mStkl = stkl;
    }

    public String getKistpf() {
        return this.mKistpf;
    }

    public void setKistpf(String kistpf) {
        this.mKistpf = kistpf;
    }

    public BigDecimal getKifrbtrg() {
        return this.mKifrbtrg;
    }

    public void setKifrbtrg(BigDecimal kifrbtrg) {
        this.mKifrbtrg = kifrbtrg;
    }

    public String getEgstfrbtrg() {
        return this.mEgstfrbtrg;
    }

    public void setEgstfrbtrg(String egstfrbtrg) {
        this.mEgstfrbtrg = egstfrbtrg;
    }

    public String getTt() {
        return this.mTt;
    }

    public void setTt(String tt) {
        this.mTt = tt;
    }

    public String getTtsc() {
        return this.mTtsc;
    }

    public void setTtsc(String ttsc) {
        this.mTtsc = ttsc;
    }

    public int getPersgr() {
        return this.mPersgr;
    }

    public void setPersgr(int persgr) {
        this.mPersgr = persgr;
    }

    public int getBygrkv() {
        return this.mBygrkv;
    }

    public void setBygrkv(int bygrkv) {
        this.mBygrkv = bygrkv;
    }

    public int getBygrrv() {
        return this.mBygrrv;
    }

    public void setBygrrv(int bygrrv) {
        this.mBygrrv = bygrrv;
    }

    public int getBygrav() {
        return this.mBygrav;
    }

    public void setBygrav(int bygrav) {
        this.mBygrav = bygrav;
    }

    public int getBygrpv() {
        return this.mBygrpv;
    }

    public void setBygrpv(int bygrpv) {
        this.mBygrpv = bygrpv;
    }

    public String getKennzgv() {
        return this.mKennzgv;
    }

    public void setKennzgv(String kennzgv) {
        this.mKennzgv = kennzgv;
    }

    public String getKennzmf() {
        return this.mKennzmf;
    }

    public void setKennzmf(String kennzmf) {
        this.mKennzmf = kennzmf;
    }

    public String getKennzmfb() {
        return this.mKennzmfb;
    }

    public void setKennzmfb(String kennzmfb) {
        this.mKennzmfb = kennzmfb;
    }

    public String getKennzsta() {
        return this.mKennzsta;
    }

    public void setKennzsta(String kennzsta) {
        this.mKennzsta = kennzsta;
    }

    public String getBbnrkk() {
        return this.mBbnrkk;
    }

    public void setBbnrkk(String bbnrkk) {
        this.mBbnrkk = bbnrkk;
    }

    public String getBbnrkkum() {
        return this.mBbnrkkum;
    }

    public void setBbnrkkum(String bbnrkkum) {
        this.mBbnrkkum = bbnrkkum;
    }

    public BigDecimal getGesbyprivkv() {
        return this.mGesbyprivkv;
    }

    public void setGesbyprivkv(BigDecimal gesbyprivkv) {
        this.mGesbyprivkv = gesbyprivkv;
    }

    public BigDecimal getGesbyprivpv() {
        return this.mGesbyprivpv;
    }

    public void setGesbyprivpv(BigDecimal gesbyprivpv) {
        this.mGesbyprivpv = gesbyprivpv;
    }

    public String getBbnrvw() {
        return this.mBbnrvw;
    }

    public void setBbnrvw(String bbnrvw) {
        this.mBbnrvw = bbnrvw;
    }

    public String getKennzzva() {
        return this.mKennzzva;
    }

    public void setKennzzva(String kennzzva) {
        this.mKennzzva = kennzzva;
    }

    public String getZva() {
        return this.mZva;
    }

    public void setZva(String zva) {
        this.mZva = zva;
    }

    public String getKennzbau() {
        return this.mKennzbau;
    }

    public void setKennzbau(String kennzbau) {
        this.mKennzbau = kennzbau;
    }

    public String getAzwoech() {
        return this.mAzwoech;
    }

    public void setAzwoech(String azwoech) {
        this.mAzwoech = azwoech;
    }

    public String getKennzgle() {
        return this.mKennzgle;
    }

    public void setKennzgle(String kennzgle) {
        this.mKennzgle = kennzgle;
    }

    public String getKennzbefrvp() {
        return this.mKennzbefrvp;
    }

    public void setKennzbefrvp(String kennzbefrvp) {
        this.mKennzbefrvp = kennzbefrvp;
    }

    public String getKennzverzgle() {
        return this.mKennzverzgle;
    }

    public void setKennzverzgle(String kennzverzgle) {
        this.mKennzverzgle = kennzverzgle;
    }

    public String getKennzverzrvfgb() {
        return this.mKennzverzrvfgb;
    }

    public void setKennzverzrvfgb(String kennzverzrvfgb) {
        this.mKennzverzrvfgb = kennzverzrvfgb;
    }

    public String getKennzverzrvpgb() {
        return this.mKennzverzrvpgb;
    }

    public void setKennzverzrvpgb(String kennzverzrvpgb) {
        this.mKennzverzrvpgb = kennzverzrvpgb;
    }

    public String getKennzwg() {
        return this.mKennzwg;
    }

    public void setKennzwg(String kennzwg) {
        this.mKennzwg = kennzwg;
    }

    public String getKennzelt() {
        return this.mKennzelt;
    }

    public void setKennzelt(String kennzelt) {
        this.mKennzelt = kennzelt;
    }

    public String getKennzkg() {
        return this.mKennzkg;
    }

    public void setKennzkg(String kennzkg) {
        this.mKennzkg = kennzkg;
    }

    public String getKennzvbe() {
        return this.mKennzvbe;
    }

    public void setKennzvbe(String kennzvbe) {
        this.mKennzvbe = kennzvbe;
    }

    public String getKennzrbz() {
        return this.mKennzrbz;
    }

    public void setKennzrbz(String kennzrbz) {
        this.mKennzrbz = kennzrbz;
    }

    public String getKennzatz() {
        return this.mKennzatz;
    }

    public void setKennzatz(String kennzatz) {
        this.mKennzatz = kennzatz;
    }

    public String getKennzatzalt() {
        return this.mKennzatzalt;
    }

    public void setKennzatzalt(String kennzatzalt) {
        this.mKennzatzalt = kennzatzalt;
    }

    public Date getAtzbg() {
        return this.mAtzbg;
    }

    public void setAtzbg(Date atzbg) {
        this.mAtzbg = atzbg;
    }

    public Date getAtzen() {
        return this.mAtzen;
    }

    public void setAtzen(Date atzen) {
        this.mAtzen = atzen;
    }

    public Date getFpbeg() {
        return this.mFpbeg;
    }

    public void setFpbeg(Date fpbeg) {
        this.mFpbeg = fpbeg;
    }

    public Date getWgsBg() {
        return this.mWgsBg;
    }

    public void setWgsBg(Date wgsBg) {
        this.mWgsBg = wgsBg;
    }

    public Date getWgsEn() {
        return this.mWgsEn;
    }

    public void setWgsEn(Date wgsEn) {
        this.mWgsEn = wgsEn;
    }

    public Date getWgsFpBeg() {
        return this.mWgsFpBeg;
    }

    public void setWgsFpBeg(Date wgsFpBeg) {
        this.mWgsFpBeg = wgsFpBeg;
    }

    public boolean getMmkn() {
        return this.mMmkn;
    }

    public void setMmkn(boolean mmkn) {
        this.mMmkn = mmkn;
    }

    public boolean getMms3() {
        return this.mMms3;
    }

    public void setMms3(boolean mms3) {
        this.mMms3 = mms3;
    }

    public void init(EubpAccount account) {
        this.mAccount = account;
        this.mGltab = null;
        this.mAenddat = "";
        this.mAzvualt = "";
        this.mAzvuweiter = "";
        this.mErsteintr = null;
        this.mEintr = null;
        this.mAustr = null;
        this.mName = "";
        this.mGbname = "";
        this.mVoname = "";
        this.mGe = "";
        this.mLdkz = "";
        this.mPlz = "";
        this.mOrt = "";
        this.mStr = "";
        this.mHnr = "";
        this.mEuvsnr = "";
        this.mGbdt = null;
        this.mGbort = "";
        this.mSasc = "";
        this.mToddat = null;
        this.mKennzrk = "";
        this.mKennzpvs = "";
        this.mKnr = "";
        this.mBlz = "";
        this.mIban = "";
        this.mBic = "";
        this.mStkl = "";
        this.mKistpf = "";
        this.mKifrbtrg = BigDecimal.ZERO;
        this.mEgstfrbtrg = "";
        this.mTt = "";
        this.mTtsc = "";
        this.mPersgr = 0;
        this.mBygrkv = 0;
        this.mBygrrv = 0;
        this.mBygrav = 0;
        this.mBygrpv = 0;
        this.mKennzgv = "";
        this.mKennzmf = "";
        this.mKennzmfb = "";
        this.mKennzsta = "";
        this.mBbnrkk = "";
        this.mBbnrkkum = "";
        this.mGesbyprivkv = BigDecimal.ZERO;
        this.mGesbyprivpv = BigDecimal.ZERO;
        this.mBbnrvw = "";
        this.mKennzzva = "";
        this.mMmkn = false;
        this.mMms3 = false;
    }

    public void fill(Master master, Employment employment, Insurance insurance, Date validDate) throws BusinessDomainException {
        boolean kindergeld;
        Date effectiveDate;
        Employee employee;
        block38: {
            EEVBLU vblu;
            employee = employment.getEmployee();
            effectiveDate = this.mAccount.getEffectiveFrom();
            this.mGltab = validDate;
            this.mAenddat = DateMapper.toYYYYMMDDString((Date)DateHelper.max((Date[])new Date[]{master.getEffectiveFrom(), employment.getEffectiveFrom(), insurance.getEffectiveFrom()}));
            this.mAzvualt = "";
            this.mAzvuweiter = "";
            this.mErsteintr = employee.getMinimumDateOfEntry();
            this.mEintr = employment.getDateOfEntry();
            this.mAustr = employment.getDateOfWithDrawal();
            this.mName = insurance.getSurname();
            this.mGbname = insurance.getNameAtBirth();
            this.mVoname = insurance.getFirstname();
            switch (master.getSex().value()) {
                case 1: {
                    this.mGe = "M";
                    break;
                }
                case 0: {
                    this.mGe = "W";
                    break;
                }
                case 2: {
                    this.mGe = "X";
                    break;
                }
                case 3: {
                    this.mGe = "D";
                }
            }
            this.mLdkz = master.getState() != null ? master.getState().getIsoCode3166_1() : "D";
            this.mPlz = master.getPostalCode();
            this.mStr = master.getStreet();
            this.mHnr = master.getStreetNumber();
            this.mEuvsnr = insurance.getEuInsuranceNo();
            this.mGbdt = master.getDateOfBirth();
            this.mGbort = insurance.getPlaceOfBirth();
            this.mSasc = insurance.getNationality().getDomainKey();
            this.mToddat = "";
            EECompanyPlant eeCompanyPlant = (EECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
            eeCompanyPlant.setEffectiveFrom(effectiveDate);
            eeCompanyPlant.setValidFrom(validDate);
            eeCompanyPlant.setEmployee(employee);
            this.mKennzrk = eeCompanyPlant.getLawArea();
            this.mKennzpvs = eeCompanyPlant.getFederalStateTP().getLongDescription().equals("Sachsen") ? "J" : "N";
            this.mKnr = "";
            this.mBlz = "";
            this.mIban = "";
            this.mBic = "";
            Tax tax = employee.getTax(effectiveDate, validDate);
            this.mStkl = String.valueOf(tax.getTaxBracket());
            this.mKistpf = tax.getChurchTax() ? "J" : "N";
            this.mKifrbtrg = tax.getChildRelief();
            this.mEgstfrbtrg = "";
            this.mTt = insurance.getOccupationLong() != null ? insurance.getOccupationLong().getOccupationLongTP(effectiveDate, validDate).getLongDescription() : "";
            this.mTtsc = insurance.getOccupationKey(validDate);
            this.mPersgr = insurance.getPersonGroup();
            this.mBygrkv = insurance.getDuesGroupHI();
            this.mBygrrv = insurance.getDuesGroupPI();
            this.mBygrav = insurance.getDuesGroupUI();
            this.mBygrpv = insurance.getDuesGroupNI();
            this.mKennzgv = insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GERINGVERDIENER ? "J" : "N";
            this.mKennzmf = insurance.getMultiplyEmployment().value() > 1 ? "J" : "N";
            this.mKennzmfb = "N";
            this.mKennzsta = insurance.getStatusCodeEUBP();
            if (insurance.getHealthFund() != null) {
                this.mBbnrkk = insurance.getHealthFund().getHealthFundTP(effectiveDate, validDate).getStandardCompanyNumber();
            } else if (insurance.getHealthFundKVdR() != null) {
                insurance.getHealthFundKVdR().getHealthFundTP(effectiveDate, validDate).getStandardCompanyNumber();
            } else {
                this.mBbnrkk = "";
            }
            this.mBbnrkkum = insurance.getAssessmentHealthFund() != null ? insurance.getAssessmentHealthFund().getHealthFundTP(effectiveDate, validDate).getStandardCompanyNumber() : "";
            this.mGesbyprivkv = insurance.getTotalRateToPHI();
            this.mGesbyprivpv = insurance.getTotalRateToPNI();
            this.mBbnrvw = insurance.getRecipient() != null ? insurance.getRecipient().getRecipientTP(effectiveDate, validDate).getStandardCompanyNumber() : "";
            this.mKennzzva = "0";
            EEZVK zvk = employee.getEEZVKOrNull(effectiveDate, validDate);
            if (zvk != null && (zvk.getTypeOfCalcAddCont() != ZvkTypeOfCalcAddContEnum.ZTOCACE_keineBerechnung || zvk.getTypeOfCalculation() != ZvkTypeOfCalculationEnum.ZTOCE_keine_Berechnung)) {
                this.mKennzzva = "1";
            }
            if ((vblu = (EEVBLU)employee.getVBLUHistory().getItemOrNull(validDate, validDate)) != null) {
                this.mKennzzva = "3";
            }
            this.mZva = "";
            if (this.mKennzzva.equals("1")) {
                this.mZva = zvk.getZVK().getRecipientTP(effectiveDate, validDate).getLongDescription();
            }
            if (this.mKennzzva.equals("\u00a7")) {
                this.mZva = vblu.getVBLU().getRecipientTP(effectiveDate, validDate).getLongDescription();
            }
            this.mKennzbau = "N";
            this.mAzwoech = "";
            this.mKennzgle = insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG ? "J" : "N";
            String string = this.mKennzbefrvp = insurance.getUseTransitionBy31122022() && insurance.getPersonGroup() == 109 && (insurance.getDuesGroupHI() == 6 || insurance.getDuesGroupPI() == 5 || insurance.getDuesGroupUI() == 0) ? "J" : "N";
            this.mKennzverzgle = insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG ? (insurance.getNoExemptionPF() ? "J" : "N") : "";
            if (insurance.getPersonGroup() == 109) {
                if (insurance.getNoExemptionPF()) {
                    if (DateHelper.afterOrEqual((Date)validDate, (Date)new VDate(2013, 0, 1).getDate())) {
                        this.mKennzverzrvpgb = "J";
                        this.mKennzverzrvfgb = "N";
                    } else {
                        this.mKennzverzrvpgb = "N";
                        this.mKennzverzrvfgb = "J";
                    }
                } else {
                    this.mKennzverzrvfgb = "N";
                    this.mKennzverzrvpgb = "N";
                }
            } else {
                this.mKennzverzrvfgb = "";
                this.mKennzverzrvpgb = "";
            }
            EEDataCreditTP[] wertguthaben = employee.getEEDataCredits(effectiveDate, validDate);
            this.mKennzwg = wertguthaben != null && wertguthaben.length != 0 ? "J" : "N";
            this.mKennzelt = insurance.getNIChildEducation() ? "J" : "N";
            kindergeld = false;
            try {
                EERelativeTP[] relatives;
                for (EERelativeTP each : relatives = employee.getEffectiveEERelativesForEvaluation(effectiveDate, validDate)) {
                    if (!each.getDoPayment() || each.getCAFlagCalculation() != FlagCalculationEnum.FCE_FULL) continue;
                    kindergeld = true;
                }
            }
            catch (BusinessDomainException de) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)de)) break block38;
                throw de;
            }
        }
        this.mKennzkg = kindergeld ? "J" : "N";
        this.mKennzvbe = insurance.getPersonGroup() / 100 == 9 && insurance.getHealthFundKVdR() != null ? "J" : "N";
        this.mKennzrbz = insurance.getTypeOfPension() > 1 && insurance.getTypeOfPension() < 10 ? "J" : "N";
        this.mKennzatz = "0";
        if (insurance.getPersonGroup() == 103) {
            switch (insurance.getTypeAgePartTime().value()) {
                case 0: {
                    this.mKennzatz = "2";
                    break;
                }
                case 1: {
                    this.mKennzatz = "1";
                }
            }
        }
        this.mKennzatzalt = "N";
        if (insurance.getPersonGroup() == 103) {
            if (insurance.getAgePartTimeModel() != null) {
                this.mKennzatzalt = insurance.getAgePartTimeModel().getAgePartTimeModelTP(effectiveDate, validDate).getTypeOfContract() == ContractEnum.CE_Altvertrag ? "J" : "N";
            } else if (employment.getPlant() != null && employment.getPlant().getPlantSettingOrNull(effectiveDate, validDate) != null && employment.getPlant().getPlantSettingOrNull(effectiveDate, validDate).getSettings().getAgePartTimeModel() != null) {
                this.mKennzatzalt = employment.getPlant().getPlantSettingOrNull(effectiveDate, validDate).getSettings().getAgePartTimeModel().getAgePartTimeModelTP(effectiveDate, validDate).getTypeOfContract() == ContractEnum.CE_Altvertrag ? "J" : "N";
            } else if (employee.getPCompany().getCompanySettings(effectiveDate, validDate).getSettings().getAgePartTimeModel() != null) {
                this.mKennzatzalt = employee.getPCompany().getCompanySettings(effectiveDate, validDate).getSettings().getAgePartTimeModel().getAgePartTimeModelTP(effectiveDate, validDate).getTypeOfContract() == ContractEnum.CE_Altvertrag ? "J" : "N";
            } else if (DateHelper.before((Date)insurance.getBeginAgePartTime(), (Date)new Date(104, 8, 1))) {
                this.mKennzatzalt = "J";
            }
        }
        this.mAtzbg = insurance.getPersonGroup() == 103 ? insurance.getBeginAgePartTime() : null;
        this.mAtzen = insurance.getPersonGroup() == 103 ? insurance.getEndAgePartTime() : null;
        this.mFpbeg = insurance.getPersonGroup() == 103 ? insurance.getBeginWorkExemption() : null;
        EEAccidentInsuranceFund eeAccidentInsuranceFund = (EEAccidentInsuranceFund)employee.getEEAccidentInsuranceFundHistory().getItemOrNull(effectiveDate, validDate);
        if (eeAccidentInsuranceFund != null) {
            PartClassOfRisk[] partClassOfRisks;
            this.fillPartDsanGt(PartDsan.getAccidentInsuranceFundTP(eeAccidentInsuranceFund.getAccidentInsuranceFund(), effectiveDate, validDate), PartDsan.getAccidentInsuranceFundTP(eeAccidentInsuranceFund.getDifferentAccidentInsuranceFund(), effectiveDate, validDate), eeAccidentInsuranceFund.getClassOfRisk(), eeAccidentInsuranceFund.getAIFpercent());
            for (PartClassOfRisk partClassOfRisk : partClassOfRisks = eeAccidentInsuranceFund.getPartClassOfRisk()) {
                this.fillPartDsanGt(PartDsan.getAccidentInsuranceFundTP(partClassOfRisk.getAccidentInsuranceFund(), effectiveDate, validDate), PartDsan.getAccidentInsuranceFundTP(partClassOfRisk.getDifferentAccidentInsuranceFund(), effectiveDate, validDate), partClassOfRisk.getClassOfRisk(), partClassOfRisk.getAIFPercent());
            }
        }
    }

    private static AccidentInsuranceFundTP getAccidentInsuranceFundTP(AccidentInsuranceFund accidentInsuranceFund, Date effectiveDate, Date validDate) {
        return accidentInsuranceFund == null ? null : (AccidentInsuranceFundTP)accidentInsuranceFund.getHistory().getItemOrNull(effectiveDate, validDate);
    }

    public void fillPartDsanGt(AccidentInsuranceFundTP accidentInsuranceFundTP, AccidentInsuranceFundTP differentAccidentInsuranceFundTP, String classOfRisk, BigDecimal aifPercent) {
        if (this.mPartDsanGtList.size() >= 9) {
            return;
        }
        PartDsanGt partDsanGt = new PartDsanGt();
        partDsanGt.init();
        partDsanGt.fill(accidentInsuranceFundTP, differentAccidentInsuranceFundTP, classOfRisk, aifPercent);
        this.mPartDsanGtList.add(partDsanGt);
    }

    public boolean isEqual(PartDsan oldObject) {
        if (!StringMapper.equal((String)oldObject.getAzvualt(), (String)this.getAzvualt())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getAzvuweiter(), (String)this.getAzvuweiter())) {
            return false;
        }
        if (DateHelper.compareDateWithNull((Date)oldObject.getErsteintr(), (Date)this.getErsteintr()) != 0) {
            return false;
        }
        if (DateHelper.compareDateWithNull((Date)oldObject.getEintr(), (Date)this.getEintr()) != 0) {
            return false;
        }
        if (DateHelper.compareDateWithNull((Date)oldObject.getAustr(), (Date)this.getAustr()) != 0) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getName(), (String)this.getName())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getGbname(), (String)this.getGbname())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getVoname(), (String)this.getVoname())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getGe(), (String)this.getGe())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getLdkz(), (String)this.getLdkz())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getPlz(), (String)this.getPlz())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getOrt(), (String)this.getOrt())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getStr(), (String)this.getStr())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getHnr(), (String)this.getHnr())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getEuvsnr(), (String)this.getEuvsnr())) {
            return false;
        }
        if (DateHelper.compareDateWithNull((Date)oldObject.getGbdt(), (Date)this.getGbdt()) != 0) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getGbort(), (String)this.getGbort())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getSasc(), (String)this.getSasc())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getToddat(), (String)this.getToddat())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzrk(), (String)this.getKennzrk())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzpvs(), (String)this.getKennzpvs())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKnr(), (String)this.getKnr())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getBlz(), (String)this.getBlz())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getIban(), (String)this.getIban())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getBic(), (String)this.getBic())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getStkl(), (String)this.getStkl())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKistpf(), (String)this.getKistpf())) {
            return false;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)oldObject.getKifrbtrg(), (BigDecimal)this.getKifrbtrg())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getEgstfrbtrg(), (String)this.getEgstfrbtrg())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getTt(), (String)this.getTt())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getTtsc(), (String)this.getTtsc())) {
            return false;
        }
        if (oldObject.getPersgr() != this.getPersgr()) {
            return false;
        }
        if (oldObject.getBygrkv() != this.getBygrkv()) {
            return false;
        }
        if (oldObject.getBygrrv() != this.getBygrrv()) {
            return false;
        }
        if (oldObject.getBygrav() != this.getBygrav()) {
            return false;
        }
        if (oldObject.getBygrpv() != this.getBygrpv()) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzgv(), (String)this.getKennzgv())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzmf(), (String)this.getKennzmf())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzmfb(), (String)this.getKennzmfb())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzsta(), (String)this.getKennzsta())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getBbnrkk(), (String)this.getBbnrkk())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getBbnrkkum(), (String)this.getBbnrkkum())) {
            return false;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)oldObject.getGesbyprivkv(), (BigDecimal)this.getGesbyprivkv())) {
            return false;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)oldObject.getGesbyprivpv(), (BigDecimal)this.getGesbyprivpv())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getBbnrvw(), (String)this.getBbnrvw())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzzva(), (String)this.getKennzzva())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getZva(), (String)this.getZva())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzbau(), (String)this.getKennzbau())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getAzwoech(), (String)this.getAzwoech())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzgle(), (String)this.getKennzgle())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzgle(), (String)this.getKennzgle())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzbefrvp(), (String)this.getKennzbefrvp())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzverzrvfgb(), (String)this.getKennzverzrvfgb())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzverzrvpgb(), (String)this.getKennzverzrvpgb())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzwg(), (String)this.getKennzwg())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzelt(), (String)this.getKennzelt())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzkg(), (String)this.getKennzkg())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzvbe(), (String)this.getKennzvbe())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzrbz(), (String)this.getKennzrbz())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzatz(), (String)this.getKennzatz())) {
            return false;
        }
        if (!StringMapper.equal((String)oldObject.getKennzatzalt(), (String)this.getKennzatzalt())) {
            return false;
        }
        if (DateHelper.compareDateWithNull((Date)oldObject.getAtzbg(), (Date)this.getAtzbg()) != 0) {
            return false;
        }
        if (DateHelper.compareDateWithNull((Date)oldObject.getAtzen(), (Date)this.getAtzen()) != 0) {
            return false;
        }
        if (DateHelper.compareDateWithNull((Date)oldObject.getFpbeg(), (Date)this.getFpbeg()) != 0) {
            return false;
        }
        return PartDsan.isEqual(oldObject.mPartDsanGtList, this.mPartDsanGtList);
    }

    private static boolean isEqual(List<PartDsanGt> partDsanGts1, List<PartDsanGt> partDsanGts2) {
        if (partDsanGts1.size() != partDsanGts2.size()) {
            return false;
        }
        if (partDsanGts1.size() == 0) {
            return true;
        }
        Iterator<PartDsanGt> iter1 = partDsanGts1.iterator();
        Iterator<PartDsanGt> iter2 = partDsanGts2.iterator();
        PartDsanGt partDsanGt1 = iter1.next();
        PartDsanGt partDsanGt2 = iter2.next();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (!partDsanGt1.isEqual(partDsanGt2)) {
                return false;
            }
            partDsanGt1 = iter1.next();
            partDsanGt2 = iter2.next();
        }
        return true;
    }

    public String print() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isVersion06OrLower = this.mDsan.getVersionsnr().compareTo("06") <= 0;
        boolean isVersion07OrHigher = this.mDsan.getVersionsnr().compareTo("07") >= 0;
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mGltab), (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mAenddat + "000000000"), (int)17));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mAzvualt, (int)20));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mAzvuweiter, (int)20));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(DateMapper.toYYYYMMDDString((Date)this.mErsteintr) + "000000000"), (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mEintr), (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mAustr == null ? "" : DateMapper.toYYYYMMDDString((Date)this.mAustr)), (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mName, (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mGbname, (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mVoname, (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mGe, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mLdkz, (int)3));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mPlz, (int)10));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mOrt, (int)34));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mStr, (int)33));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mHnr, (int)9));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEuvsnr, (int)20));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mGbdt), (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mGbort, (int)34));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mSasc, (int)3));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mToddat, (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzrk, (int)1));
        if (isVersion06OrLower) {
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzpvs, (int)1));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKnr, (int)10));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBlz, (int)8));
        }
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mIban, (int)34));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBic, (int)11));
        if (isVersion06OrLower) {
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mStkl, (int)1));
            stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)this.mKistpf, (int)1));
            stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)this.round(this.mKifrbtrg, 1), (int)3));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEgstfrbtrg, (int)10));
        }
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mTt, (int)25));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mTtsc, (int)9));
        if (isVersion06OrLower) {
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mPersgr), (int)3));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mBygrkv), (int)1));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mBygrrv), (int)1));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mBygrav), (int)1));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mBygrpv), (int)1));
        }
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzgv, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(isVersion06OrLower ? this.mKennzmf : " "), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzmfb, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzsta, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBbnrkk, (int)15));
        if (isVersion06OrLower) {
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBbnrkkum, (int)15));
        }
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.getSign(this.mGesbyprivkv), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)this.round(this.mGesbyprivkv, 2), (int)10));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.getSign(this.mGesbyprivpv), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLengthPEM((String)this.round(this.mGesbyprivpv, 2), (int)10));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mBbnrvw, (int)15));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzzva, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mZva, (int)35));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzbau, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mAzwoech, (int)4));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzgle, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzbefrvp, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzverzgle, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzverzrvfgb, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzverzrvpgb, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzwg, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzelt, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzkg, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzvbe, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzrbz, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzatz, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mKennzatzalt, (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mAtzbg), (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mAtzen), (int)8));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mFpbeg), (int)8));
        if (isVersion07OrHigher) {
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mWgsBg), (int)8));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mWgsEn), (int)8));
            stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)DateMapper.toYYYYMMDDString((Date)this.mWgsFpBeg), (int)8));
        }
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mMmkn ? "J" : "N"), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mMms3 ? "J" : "N"), (int)1));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)Integer.toString(this.mPartDsanGtList.size()), (int)1));
        for (PartDsanGt part : this.mPartDsanGtList) {
            stringBuilder.append(part.print());
        }
        return stringBuilder.toString();
    }

    private String getSign(BigDecimal bigDecimal) {
        return bigDecimal.signum() >= 0 ? "+" : "-";
    }

    private String round(BigDecimal bigDecimal, int scale) {
        return bigDecimal.setScale(scale, RoundingMode.HALF_UP).toString().replace(".", "").replace(".", "");
    }

    public String toString() {
        return "PartDsan [, mGltab = " + this.mGltab + ", mAenddat = " + this.mAenddat + ", mAzvualt = " + this.mAzvualt + ", mAzvuweiter = " + this.mAzvuweiter + ", mErsteintr = " + this.mErsteintr + ", mEintr = " + this.mEintr + ", mAustr = " + this.mAustr + ", mName = " + this.mName + ", mGbname = " + this.mGbname + ", mVoname = " + this.mVoname + ", mGe = " + this.mGe + ", mLdkz = " + this.mLdkz + ", mPlz = " + this.mPlz + ", mOrt = " + this.mOrt + ", mStr = " + this.mStr + ", mHnr = " + this.mHnr + ", mEuvsnr = " + this.mEuvsnr + ", mGbdt = " + this.mGbdt + ", mGbort = " + this.mGbort + ", mSasc = " + this.mSasc + ", mToddat = " + this.mToddat + ", mKennzrk = " + this.mKennzrk + ", mKennzpvs = " + this.mKennzpvs + ", mKnr = " + this.mKnr + ", mBlz = " + this.mBlz + ", mIban = " + this.mIban + ", mBic = " + this.mBic + ", mStkl = " + this.mStkl + ", mKistpf = " + this.mKistpf + ", mKifrbtrg = " + this.mKifrbtrg + ", mEgstfrbtrg = " + this.mEgstfrbtrg + ", mTt = " + this.mTt + ", mTtsc = " + this.mTtsc + ", mPersgr = " + this.mPersgr + ", mBygrkv = " + this.mBygrkv + ", mBygrrv = " + this.mBygrrv + ", mBygrav = " + this.mBygrav + ", mBygrpv = " + this.mBygrpv + ", mKennzgv = " + this.mKennzgv + ", mKennzmf = " + this.mKennzmf + ", mKennzmfb = " + this.mKennzmfb + ", mKennzsta = " + this.mKennzsta + ", mBbnrkk = " + this.mBbnrkk + ", mBbnrkkum = " + this.mBbnrkkum + ", mGesbyprivkv = " + this.mGesbyprivkv + ", mGesbyprivpv = " + this.mGesbyprivpv + ", mBbnrvw = " + this.mBbnrvw + ", mKennzzva = " + this.mKennzzva + ", mZva = " + this.mZva + ", mKennzbau = " + this.mKennzbau + ", mAzwoech = " + this.mAzwoech + ", mKennzgle = " + this.mKennzgle + ", mKennzbefrvp = " + this.mKennzbefrvp + ", mKennzverzgle = " + this.mKennzverzgle + ", mKennzverzrvfgb = " + this.mKennzverzrvfgb + ", mKennzverzrvpgb = " + this.mKennzverzrvpgb + ", mKennzwg = " + this.mKennzwg + ", mKennzelt = " + this.mKennzelt + ", mKennzkg = " + this.mKennzkg + ", mKennzvbe = " + this.mKennzvbe + ", mKennzrbz = " + this.mKennzrbz + ", mKennzatz = " + this.mKennzatz + ", mKennzatzalt = " + this.mKennzatzalt + ", mAtzbg = " + this.mAtzbg + ", mAtzen = " + this.mAtzen + ", mFpbeg = " + this.mFpbeg + ", mMmkn = " + this.mMmkn + ", mMms3 = " + this.mMms3 + ", mPartDsanGtList = " + this.mPartDsanGtList + "]";
    }
}

