/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.valueposition;

import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.taskreminder.TaskReminder;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.calculation.CertificateCalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.calculation.mapper.CalculationExceptionMapper;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionComparator;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.basictypes.CategoryEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ClassificationEnum;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuePositionHistory {
    private static Logger LOGGER = LoggerFactory.getLogger(ValuePositionHistory.class);
    private final List<ValuePosition> mValuePositionHistory = new ArrayList<ValuePosition>();
    private Foundations found;
    private Date startERA;
    private boolean startERAfound = false;

    private ValuePositionHistory() {
    }

    public ValuePositionHistory(ValuePosition vp) {
        this();
        this.mValuePositionHistory.add(vp);
    }

    public ValuePositionHistory(ValuePosition[] vp) {
        this();
        if (vp.length > 0) {
            for (ValuePosition element : vp) {
                this.mValuePositionHistory.add(element);
            }
            Collections.sort(this.mValuePositionHistory, new ValuePositionComparator());
        }
    }

    public ValuePosition[] getItems(PersistentObject genesisPO) {
        ArrayList<ValuePosition> newList = new ArrayList<ValuePosition>();
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        for (ValuePosition vp : this.mValuePositionHistory) {
            if (vp.isReadOnly() || vp.getGenesisOfParentObjects() == null || !vp.getGenesisOfParentObjects().equals((Object)genesisPO)) continue;
            newList.add(vp);
        }
        ValuePosition[] results = new ValuePosition[newList.size()];
        return newList.toArray(results);
    }

    public ValuePosition[] getItemsForReports(PersistentObject genesisPO) {
        ArrayList<ValuePosition> newList = new ArrayList<ValuePosition>();
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        for (ValuePosition vp : this.mValuePositionHistory) {
            if (vp.getGenesisOfParentObjects() == null || !vp.getGenesisOfParentObjects().equals((Object)genesisPO)) continue;
            newList.add(vp);
        }
        ValuePosition[] results = new ValuePosition[newList.size()];
        return newList.toArray(results);
    }

    public ValuePosition[] getItemsOfParent(PersistentObject parentPO) {
        ArrayList<ValuePosition> newList = new ArrayList<ValuePosition>();
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        for (ValuePosition vp : this.mValuePositionHistory) {
            if (vp.isReadOnly() || vp.getGenesisOfParentObjects() == null || !vp.getParentObject().equals((Object)parentPO)) continue;
            newList.add(vp);
        }
        ValuePosition[] results = new ValuePosition[newList.size()];
        return newList.toArray(results);
    }

    public ValuePosition[] getItems(int valueTypeKey) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.getValueType().getValueTypeKey() != valueTypeKey || vp.isReadOnly()) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItems(int ... valueTypeKey) {
        if (valueTypeKey.length == 0) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> results = new ArrayList<ValuePosition>();
        for (int valueType : valueTypeKey) {
            ValuePosition[] vps;
            for (ValuePosition vp : vps = this.getItems(valueType)) {
                results.add(vp);
            }
        }
        ValuePosition[] result = new ValuePosition[results.size()];
        return results.toArray(result);
    }

    public ValuePosition getItem(int valueTypeKey, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        if (this.mValuePositionHistory.isEmpty()) {
            throw FrameWorkExceptionMapper.makeObjectNotExistsDomainException((String)"");
        }
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || vp.getValueType().getValueTypeKey() != valueTypeKey || !DateHelper.between((Date)vp.getEffectiveFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)effectiveFrom), (Date)DateHelper.getLastDayOfMonth((Date)effectiveFrom)) || !DateHelper.between((Date)vp.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)validFrom), (Date)DateHelper.getLastDayOfMonth((Date)validFrom))) continue;
            return vp;
        }
        throw FrameWorkExceptionMapper.makeObjectForThisDateNotExistsInHistoryDomainException(null, (Date)effectiveFrom, (Date)validFrom);
    }

    public ValuePosition getItem(int valueTypeKey, Date effectiveFrom, Date validFrom, PersistentObject persistentObject) throws BusinessDomainException {
        if (this.mValuePositionHistory.isEmpty()) {
            throw FrameWorkExceptionMapper.makeObjectNotExistsDomainException((String)"");
        }
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || vp.getValueType().getValueTypeKey() != valueTypeKey || !DateHelper.equal((Date)vp.getEffectiveFrom(), (Date)effectiveFrom) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)validFrom) || vp.getGenesisOfParentObjects() != persistentObject) continue;
            return vp;
        }
        throw FrameWorkExceptionMapper.makeObjectForThisDateNotExistsInHistoryDomainException(null, (Date)effectiveFrom, (Date)validFrom);
    }

    public ValuePosition[] getItems(CategoryEnum category, PersistentObject persistentObject) throws BusinessDomainException {
        ArrayList<ValuePosition> resultList = new ArrayList<ValuePosition>();
        if (this.mValuePositionHistory.isEmpty()) {
            throw FrameWorkExceptionMapper.makeObjectNotExistsDomainException((String)"");
        }
        for (ValuePosition vp : this.mValuePositionHistory) {
            if (vp.isReadOnly() || vp.getGenesisOfParentObjects() != persistentObject || ValuePosition.getCategory(vp, vp.getEffectiveFrom(), vp.getValidFrom()).value() != category.value()) continue;
            resultList.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[resultList.size()];
        resultList.toArray(vpArray);
        return vpArray;
    }

    public ValuePosition[] getItems(int valueTypeKey, Date effectiveFrom, Date validFrom, Date validUntil) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || vp.getValueType().getValueTypeKey() != valueTypeKey || !DateHelper.equal((Date)vp.getEffectiveFrom(), (Date)effectiveFrom) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)validFrom) || !DateHelper.equal((Date)vp.getValidUntil(), (Date)validUntil)) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItems(int valueTypeKey, Date effectiveFrom, Date validFrom) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || vp.getValueType().getValueTypeKey() != valueTypeKey || !DateHelper.equal((Date)vp.getEffectiveFrom(), (Date)effectiveFrom) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)validFrom)) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItems(Date effectiveFrom, Date validFrom) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || !DateHelper.equal((Date)vp.getEffectiveFrom(), (Date)effectiveFrom) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)validFrom)) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItems(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || !DateHelper.beforeOrEqual((Date)vp.getEffectiveFrom(), (Date)effectiveUntil) || !DateHelper.afterOrEqual((Date)vp.getEffectiveUntil(), (Date)effectiveFrom) || !DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)validUntil) || !DateHelper.afterOrEqual((Date)vp.getValidUntil(), (Date)validFrom)) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItems(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, int i) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        if (this.mValuePositionHistory.size() < i) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int j = 0; j < i; ++j) {
            ValuePosition vp = this.mValuePositionHistory.get(j);
            if (vp.isReadOnly() && !vp.isBvCopied() || !DateHelper.beforeOrEqual((Date)vp.getEffectiveFrom(), (Date)effectiveUntil) || !DateHelper.afterOrEqual((Date)vp.getEffectiveUntil(), (Date)effectiveFrom) || !DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)validUntil) || !DateHelper.afterOrEqual((Date)vp.getValidUntil(), (Date)validFrom)) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItemsInside(CategoryEnum category, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() != category.value() || !DateHelper.beforeOrEqual((Date)vp.getEffectiveFrom(), (Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint)) || !DateHelper.afterOrEqual((Date)vp.getEffectiveUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint)) || !DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)DateHelper.getLastDayOfMonth((Date)validTimePoint)) || !DateHelper.afterOrEqual((Date)vp.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint))) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItemsInside(int valueTypeKey, Date effectiveTimePoint, Date validTimePoint) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || vp.getValueType().getValueTypeKey() != valueTypeKey || !DateHelper.beforeOrEqual((Date)vp.getEffectiveFrom(), (Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint)) || !DateHelper.afterOrEqual((Date)vp.getEffectiveUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint)) || !DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)DateHelper.getLastDayOfMonth((Date)validTimePoint)) || !DateHelper.afterOrEqual((Date)vp.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint))) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItemsInside(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        LinkedList<ValuePosition> result = new LinkedList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.isReadOnly() || !DateHelper.beforeOrEqual((Date)vp.getEffectiveFrom(), (Date)effectiveUntil) || !DateHelper.afterOrEqual((Date)vp.getEffectiveUntil(), (Date)effectiveFrom) || !DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)validUntil) || !DateHelper.afterOrEqual((Date)vp.getValidUntil(), (Date)validFrom)) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition getNextItemWithSameValuetype(int index, ValueType valueType, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        if (this.mValuePositionHistory.isEmpty()) {
            return null;
        }
        if (this.mValuePositionHistory.size() == index + 1) {
            return null;
        }
        for (int i = index + 1; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.getValueType().getValueTypeKey() == valueType.getValueTypeKey() && DateHelper.beforeOrEqual((Date)vp.getEffectiveFrom(), (Date)effectiveUntil) && DateHelper.afterOrEqual((Date)vp.getEffectiveUntil(), (Date)effectiveFrom) && DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)validUntil) && DateHelper.afterOrEqual((Date)vp.getValidUntil(), (Date)validFrom)) {
                return vp;
            }
            if (vp.getValueType().getValueTypeKey() <= valueType.getValueTypeKey()) continue;
            return null;
        }
        return null;
    }

    public int getIndex(ValuePosition valuePosition) {
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (valuePosition != vp) continue;
            return i;
        }
        return -1;
    }

    public List<ValuePosition> addItem(ValuePosition vp) {
        if (vp != null && !vp.isReadOnly()) {
            this.mValuePositionHistory.add(vp);
        }
        return this.mValuePositionHistory;
    }

    public void addList(List<ValuePosition> list) {
        this.mValuePositionHistory.addAll(this.mValuePositionHistory.size(), list);
    }

    public List<ValuePosition> removeItem(ValuePosition vp) {
        this.mValuePositionHistory.remove(vp);
        vp.makeReadOnly();
        return this.mValuePositionHistory;
    }

    /*
     * Unable to fully structure code
     */
    public List<ValuePosition> addConsequenceOfValueType(ValuePosition valuePosition, CalculationCase calculationCase) throws BusinessDomainException {
        block21: {
            list = new LinkedList<ValuePosition>();
            vp = null;
            if (valuePosition.isReadOnly()) {
                this.mValuePositionHistory.remove(vp);
                return this.mValuePositionHistory;
            }
            vpValueType = valuePosition.getValueType();
            vpValueTypeTP = vpValueType.getValueTypeTP(valuePosition.getEffectiveFrom(), valuePosition.getValidFrom());
            this.findERAStart(calculationCase);
            eraData = null;
            try {
                eraData = calculationCase.getEmployee().getEEDataERA(calculationCase.getEffectiveFrom(), calculationCase.getValidFrom());
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block21;
                throw e;
            }
        }
        covtArray = valuePosition.getValueType().getValueTypeTP(valuePosition.getEffectiveFrom(), valuePosition.getValidFrom()).getAllConsequenceOfValueType();
        this.checkVtOrientationForEEAttachement(calculationCase, valuePosition.getValueType().getValueTypeKey(), covtArray);
        this.checkVtClassificationForTax(calculationCase, valuePosition.getValueType().getValueTypeKey(), covtArray);
        if (calculationCase instanceof CertificateCalculationCase && calculationCase.getTypeOfCalculationCase() != TypeOfCalculationCase.NettoBruttoHochrechnungMK) {
            covtArray = this.checkAndModificationConsequenceOfValueType(covtArray);
        }
        block9: for (ConsequenceOfValueType covt : covtArray) {
            vt = covt.getConsequenceOfValueType();
            if (!DateHelper.afterOrEqual((Date)calculationCase.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate())) ** GOTO lbl-1000
            switch (covt.getConsequenceOfValueType().getValueTypeKey()) {
                case 371210: 
                case 371220: 
                case 371230: 
                case 372210: 
                case 372220: 
                case 372230: {
                    reminderName = "Der Wertart " + String.valueOf(valuePosition.getValueType().getValueTypeKey()) + " ist eine falsche Eigenschaft EFZ-Versicherung zugeordnet.";
                    reminderNote = "Seit Jul. 2011 soll die Eigenschaft EFZ-Versicherung mit der Wertart " + String.valueOf(covt.getConsequenceOfValueType().getValueTypeKey()) + " nicht mehr verwendet werden.\nBitte wenden Sie sich mit Ihren Fragen an Ihren Fachberater.";
                    reminderDate = calculationCase.getValidFrom();
                    if (TaskReminderHelper.existsTaskReminderInCalculationCase(calculationCase, reminderName, reminderDate) || TaskReminderHelper.existsTaskReminder(reminderName, reminderDate)) continue block9;
                    reminder = TaskReminderHelper.createTaskReminder(reminderName, reminderDate, reminderNote, SessionContext.getInstance().getSession().getUserCode());
                    calculationCase.addTaskreminder(reminder);
                    continue block9;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (eraData != null && vt.getValueTypeKey() > 99999) {
                        switch (vpValueTypeTP.getValueTypeFoundation().getGeneral().getEraEvaluation().value()) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 10: {
                                if (this.startERA == null || !DateHelper.afterOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)valuePosition.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)this.startERA))) break;
                                valuePosition.setToAnalyze(false);
                                continue block9;
                            }
                            case 2: 
                            case 5: 
                            case 8: 
                            case 11: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: {
                                if (this.startERA != null && !DateHelper.before((Date)DateHelper.getFirstDayOfMonth((Date)valuePosition.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)this.startERA))) break;
                                valuePosition.setToAnalyze(false);
                                continue block9;
                            }
                        }
                    }
                    if (vt.getValueTypeKey() == 700100) {
                        valuePosition.setNetWageIsConsequence(true);
                    }
                    if (vt.getValueTypeTP(valuePosition.getEffectiveFrom(), valuePosition.getValidFrom()).getValueTypeFoundation().getOneTimeCreateForCalculationCase()) {
                        myDate = null;
                        myDate = DateHelper.after((Date)calculationCase.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)valuePosition.getValidFrom())) != false ? calculationCase.getValidFrom() : DateHelper.getFirstDayOfMonth((Date)valuePosition.getValidFrom());
                        if (this.getItems(vt.getValueTypeKey(), valuePosition.getEffectiveFrom(), myDate).length == 0) {
                            vpos = valuePosition.create(valuePosition, covt, myDate);
                            if (vpos == null) continue block9;
                            list.add(list.size(), vpos);
                            continue block9;
                        }
                        for (ValuePosition vPos : consequence = this.getItems(vt.getValueTypeKey(), valuePosition.getEffectiveFrom(), myDate)) {
                            vPos.interpretationConsequence(valuePosition, covt);
                        }
                        continue block9;
                    }
                    if (vt.getValueTypeTP(valuePosition.getEffectiveFrom(), valuePosition.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 15) {
                        if (this.getItems(vt.getValueTypeKey(), valuePosition.getEffectiveFrom(), valuePosition.getValidFrom(), valuePosition.getValidUntil()).length != 0 || (vpos = valuePosition.create(valuePosition, covt)) == null) continue block9;
                        list.add(list.size(), vpos);
                        continue block9;
                    }
                    vpos = valuePosition.create(valuePosition, covt);
                    if (vpos == null) continue block9;
                    list.add(list.size(), vpos);
                }
            }
        }
        for (i = 0; i < list.size(); ++i) {
            vp = (ValuePosition)list.get(i);
            if (vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() != 15) continue;
            for (ConsequenceOfValueType element : covtArray = vp.getValueType().getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getAllConsequenceOfValueType()) {
                vt = element.getConsequenceOfValueType();
                if (vt.getValueTypeTP(vp.getEffectiveFrom(), vp.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() == 15) {
                    if (this.getItems(vt.getValueTypeKey(), vp.getEffectiveFrom(), vp.getValidFrom(), vp.getValidUntil()).length != 0 || (vpos = vp.create(vt)) == null) continue;
                    list.add(list.size(), vpos);
                    continue;
                }
                vpos = vp.create(vt);
                if (vpos == null) continue;
                list.add(list.size(), vpos);
            }
        }
        this.addList(list);
        Collections.sort(this.mValuePositionHistory, new ValuePositionComparator());
        return this.mValuePositionHistory;
    }

    private void checkVtOrientationForEEAttachement(CalculationCase calculationCase, int userValueTypeNumber, ConsequenceOfValueType[] covtArray) throws BusinessDomainException {
        if (userValueTypeNumber >= 99899) {
            return;
        }
        for (ConsequenceOfValueType covt : covtArray) {
            switch (covt.getConsequenceOfValueType().getValueTypeKey()) {
                case 795060: 
                case 795070: 
                case 795080: {
                    String reminderName = "Der Wertart " + String.valueOf(userValueTypeNumber) + " ist eine falsche Eigenschaft f\u00fcr die Pf\u00e4ndungsermittlung zugeordnet.";
                    String reminderNote = "Der Wertart " + String.valueOf(userValueTypeNumber) + " ist f\u00fcr die Pf\u00e4ndungsermittlung die falsche Eigenschaft zugeordnet. Seit Jan. 2011 soll nur die Eigenschaft Lohnpf\u00e4ndung/-abtretung verwendet werden.\nBitte wenden Sie sich mit Ihren Fragen an Ihren Fachberater.";
                    Date reminderDate = calculationCase.getValidFrom();
                    if (TaskReminderHelper.existsTaskReminderInCalculationCase(calculationCase, reminderName, reminderDate)) {
                        return;
                    }
                    if (TaskReminderHelper.existsTaskReminder(reminderName, reminderDate)) {
                        return;
                    }
                    TaskReminder reminder = TaskReminderHelper.createTaskReminder(reminderName, reminderDate, reminderNote, SessionContext.getInstance().getSession().getUserCode());
                    calculationCase.addTaskreminder(reminder);
                }
            }
        }
    }

    private void checkVtClassificationForTax(CalculationCase calculationCase, int userValueTypeNumber, ConsequenceOfValueType[] covtArray) throws BusinessDomainException {
        Date marginalDate = new VDate(2025, 0, 1).getDate();
        if (userValueTypeNumber >= 99997) {
            return;
        }
        if (DateHelper.before((Date)calculationCase.getValidFrom(), (Date)marginalDate)) {
            return;
        }
        if (DateHelper.after((Date)calculationCase.getEffectiveFrom(), (Date)DateHelper.tomorrow((Date)calculationCase.getEmployee().getJournalizedUntil())) || DateHelper.before((Date)calculationCase.getEffectiveFrom(), (Date)calculationCase.getValidFrom())) {
            return;
        }
        for (ConsequenceOfValueType covt : covtArray) {
            if (!covt.getForOrientation() || covt.getForClassification() != ClassificationEnum.CE_Lohnsteuerpflicht || covt.getConsequenceOfValueType().getValueTypeKey() != 110620) continue;
            throw CalculationExceptionMapper.make110620NotAllowedDomainException((Date)calculationCase.getValidFrom(), (int)userValueTypeNumber);
        }
    }

    private void findERAStart(CalculationCase cCase) throws BusinessDomainException {
        if (!this.startERAfound) {
            this.startERAfound = true;
            Plant plant = cCase.getEmployee().getEmployment(cCase.getEffectiveFrom(), cCase.getValidFrom()).getPlant();
            if (plant != null) {
                this.found = plant.getPlantFoundations(cCase.getEffectiveFrom(), cCase.getValidFrom()).getFoundations();
                this.startERA = this.found.getEraImplementation();
            }
            if (this.startERA == null) {
                this.found = cCase.getEmployee().getPCompany().getCompanyFoundations(cCase.getEffectiveFrom(), cCase.getValidFrom()).getFoundations();
                this.startERA = this.found.getEraImplementation();
            }
        }
    }

    public void sort() {
        Collections.sort(this.mValuePositionHistory, new ValuePositionComparator());
    }

    public List<ValuePosition> getAll() {
        return this.mValuePositionHistory;
    }

    public int getSize() {
        return this.mValuePositionHistory.size();
    }

    public ValuePosition getItem(int i) {
        return this.mValuePositionHistory.get(i);
    }

    public void print() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Diese History sieht wie folgt aus: ");
            for (ValuePosition vp : this.mValuePositionHistory) {
                if (vp.getValueType() != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug(new StringBuffer().append(vp.getValueType().getValueTypeKey()).append(" / ").append(vp.getEmployee().getPersonnelnumber()).append(" / ").append(DateMapper.toDDMMYYYYPointSeparationString((Date)vp.getEffectiveFrom())).append(" / ").append(DateMapper.toDDMMYYYYPointSeparationString((Date)vp.getValidFrom())).append(" / ").append(BigDecimalMapper.toString((BigDecimal)vp.getResult())).toString());
                }
                if (vp.getParentObject() != null) {
                    try {
                        LOGGER.debug("parentobject : {}", (Object)((ValuePosition)vp.getParentObject()).getValueType().getValueTypeKey());
                    }
                    catch (ClassCastException e) {
                        LOGGER.debug("Das Parentobject ist keine VP");
                    }
                    catch (ApplicationException e) {
                        throw e;
                    }
                }
                if (vp.getGenesisOfParentObjects() == null) continue;
                try {
                    LOGGER.debug("genesisobject: {}", (Object)((ValuePosition)vp.getGenesisOfParentObjects()).getValueType().getValueTypeKey());
                }
                catch (ClassCastException e) {
                    LOGGER.debug("Das Genesisobject ist keine VP");
                }
                catch (ApplicationException e) {
                    throw e;
                }
            }
        }
    }

    public ValuePosition[] getItems(PersistentObject genesisOfParentObjects, boolean pAuswertung) {
        if (!pAuswertung) {
            return this.getItems(genesisOfParentObjects);
        }
        ArrayList<ValuePosition> newList = new ArrayList<ValuePosition>();
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        for (ValuePosition vp : this.mValuePositionHistory) {
            if (vp.getGenesisOfParentObjects() == null || !vp.getGenesisOfParentObjects().equals((Object)genesisOfParentObjects)) continue;
            newList.add(vp);
        }
        ValuePosition[] results = new ValuePosition[newList.size()];
        return newList.toArray(results);
    }

    public static boolean isEgaOrNonContributory(ConsequenceOfValueType[] covts) {
        for (ConsequenceOfValueType covt : covts) {
            if (!ValuePositionHistory.isEgaOrNonContributory(covt)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEgaOrNonContributory(ConsequenceOfValueType covt) {
        switch (covt.getConsequenceOfValueType().getValueTypeKey()) {
            case 128200: 
            case 130610: 
            case 130620: 
            case 130650: {
                return true;
            }
        }
        return false;
    }

    private ConsequenceOfValueType[] checkAndModificationConsequenceOfValueType(ConsequenceOfValueType[] covtArray) {
        ArrayList<ConsequenceOfValueType> list = new ArrayList<ConsequenceOfValueType>();
        for (ConsequenceOfValueType covt : covtArray) {
            if (ValuePositionHistory.isEgaOrNonContributory(covt)) continue;
            list.add(covt);
        }
        ConsequenceOfValueType[] covs = new ConsequenceOfValueType[list.size()];
        return list.toArray(covs);
    }

    public ValuePosition[] getItemsOfUserValueTypes() {
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        for (int i = 0; i < this.mValuePositionHistory.size(); ++i) {
            ValuePosition vp = this.mValuePositionHistory.get(i);
            if (vp.getValueType().getValueTypeKey() >= 100000) continue;
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        return result.toArray(vpArray);
    }

    public ValuePosition[] getItems(PersistentObject parent, PersistentObject genesisPO) {
        ArrayList<ValuePosition> newList = new ArrayList<ValuePosition>();
        if (this.mValuePositionHistory.isEmpty()) {
            return new ValuePosition[0];
        }
        for (ValuePosition vp : this.mValuePositionHistory) {
            if (vp.isReadOnly() || vp.getGenesisOfParentObjects() == null || vp.getParentObject() == null || !vp.getGenesisOfParentObjects().equals((Object)genesisPO) || !vp.getParentObject().equals((Object)parent)) continue;
            newList.add(vp);
        }
        ValuePosition[] results = new ValuePosition[newList.size()];
        return newList.toArray(results);
    }
}

