/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.tax;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.service.ExceptionHolder;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.EmployeeHelper;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.tax.ChurchTaxEnum;
import com.varial.personnel.domain.employee.tax.DevRedHHBenfGrpEnum;
import com.varial.personnel.domain.employee.tax.DevRedHHBenfRateEnum;
import com.varial.personnel.domain.employee.tax.EvaluationTargetOfPaymentEnum;
import com.varial.personnel.domain.employee.tax.ITaxPersistencyManager;
import com.varial.personnel.domain.employee.tax.IncomeTaxReturnYYEnum;
import com.varial.personnel.domain.employee.tax.PAYETaxFindingsEnum;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.global.community.Community;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.global.taxoffice.TaxOffice;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Tax
extends PersonnelTimedPersistenceObject
implements IEmployeeReferenced {
    private static final int PRIORITY = 40;
    private Employee mEmployee;
    private boolean mTaxCardPresented;
    private int mIssueYearTaxCard;
    private Date mEntryDateTaxCard;
    private Date mDateDelivered;
    private Date mDateReturned;
    private TaxOffice mTaxOffice;
    private Community mCommunity;
    private Date mIssueDateTaxCard;
    private String mPseudonym;
    private int mTaxBracket;
    private BigDecimal mChildRelief;
    private ChurchTaxEnum mChurchTaxEE;
    private ChurchTaxEnum mChurchTaxSpouse;
    private BigDecimal mFreeAllowanceYY;
    private BigDecimal mFreeAllowanceMM;
    private BigDecimal mAddAmountYY;
    private BigDecimal mAddAmountMM;
    private TaxacationEnum mTaxacation;
    private PAYETaxFindingsEnum mPayeTaxFindings;
    private boolean mPayeTax;
    private boolean mChurchTax;
    private boolean mSolidarityCharge;
    private IncomeTaxReturnYYEnum mIncomeTaxReturnYY;
    private boolean mComputationOfUnderpaymentIncomeTax;
    private boolean mComputationOfUnderpaymentSolidarityCharge;
    private boolean mComputationOfUnderpaymentChurchTax;
    private boolean mChurchTaxDomicile;
    private FederalState mFederalState;
    private boolean mAssociationEE;
    private boolean mERpaysContribut;
    private DevRedHHBenfGrpEnum mDevRedHHBenfGrp;
    private DevRedHHBenfRateEnum mDevRedHHBenfRate;
    private boolean mCtfcGfBwoutTax;
    private int mCtfcYYGfBwoutTax;
    private Date mRegistrGfBwoutTax;
    private TaxOffice mTaxOfficeGfBwoutTax;
    private Date mDateCtfcGfBwoutTax;
    private String mTaxNumber;
    private boolean mCtfcDBAwoutTax;
    private Date mRegistrDBAwoutTax;
    private Date mFromDBAwoutTax;
    private Date mUntilDBAwoutTax;
    private TaxOffice mTaxOfficeDBAwoutTax;
    private Date mDateCtfcDBAwoutTax;
    private boolean mOldAgeReliefAmount;
    private boolean mPensionFreeDues;
    private boolean mWageTaxCertificate;
    private boolean mRedOfChurchTax;
    private BigDecimal mMonthlyEarnings;
    private String mMemo;
    private BigDecimal mPension;
    private Date mStartDateOfPension;
    private BigDecimal mBonusOfPension;
    private boolean mChurchTaxDeduction;
    private EvaluationTargetOfPaymentEnum mEvaluationTargetOfPayment;
    private BigDecimal mTaxOfSwitzerland;
    private boolean mNegativeTaxPossible;
    private String mTin;
    private BigDecimal mPercentageSplit;
    private boolean mSidelineEmployer;
    private BigDecimal mAddAmountWeekly;
    private BigDecimal mAddAmountDaily;
    private BigDecimal mFreeAllowanceWeekly;
    private BigDecimal mFreeAllowanceDaily;
    private boolean mNoElstam;
    private boolean mReregister;
    private boolean mCrossBorderEmployeeFrance;
    private Tax mOld = null;
    private boolean mSpecialChecks = false;

    protected Tax(Employee employee) {
        super(40);
        this.mEmployee = employee;
    }

    protected Tax(String objectid) {
        super(40, objectid);
    }

    protected Tax(String objectid, int version, Employee ee) {
        super(40, objectid, version);
        this.mEmployee = ee;
    }

    protected Tax(boolean readOnly) {
        super(40, readOnly);
    }

    protected Tax(Employee ee, boolean readOnly) {
        super(40, readOnly);
        this.mEmployee = ee;
    }

    protected void load() {
        this.getITaxPM().load(this);
    }

    protected void saveImpl() {
        this.getITaxPM().save(this);
    }

    protected void deleteImpl() {
        this.getITaxPM().delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mEmployee.getDomainKey()).append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    protected void setData(TaxOffice taxOffice, Community community, FederalState federalState, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, boolean taxCardPresented, int issueYearTaxCard, Date entryDateTaxCard, Date dateDelivered, Date dateReturned, Date issueDateTaxCard, String pseudonym, int taxBracket, BigDecimal childRelief, ChurchTaxEnum churchTaxEE, ChurchTaxEnum churchTaxSpouse, BigDecimal freeAllowanceYY, BigDecimal freeAllowanceMM, BigDecimal addAmountYY, BigDecimal addAmountMM, TaxacationEnum taxacation, PAYETaxFindingsEnum payeTaxFindings, boolean payeTax, boolean churchTax, boolean solidarityCharge, IncomeTaxReturnYYEnum incomeTaxReturnYY, boolean computationOfUnderpaymentChurchTax, boolean computationOfUnderpaymentIncomeTax, boolean computationOfUnderpaymentSolidarityCharge, boolean churchTaxDomicile, boolean associationEE, boolean erPaysContribut, DevRedHHBenfGrpEnum devRedHHBenfGrp, DevRedHHBenfRateEnum devRedHHBenfRate, boolean ctfcGfBwoutTax, int ctfcYYGfBwoutTax, Date registrGfBwoutTax, TaxOffice taxOfficeGfBwoutTax, Date dateCtfcGfBwoutTax, String taxNumber, boolean ctfcDBAwoutTax, Date registrDBAwoutTax, Date fromDBAwoutTax, Date untilDBAwoutTax, TaxOffice taxOfficeDBAwoutTax, Date dateCtfcDBAwoutTax, boolean oldAgeReliefAmount, boolean pensionFreeDues, boolean wageTaxCertificate, boolean redOfChurchTax, BigDecimal monthlyEarnings, String memo, BigDecimal pension, Date startDateOfPension, BigDecimal bonusOfPension, boolean churchTaxDeduction, EvaluationTargetOfPaymentEnum evaluationTargetOfPayment, BigDecimal taxOfSwitzerland, boolean negativeTaxPossible, String tin, BigDecimal percentageSplit, boolean sidelineEmployer, BigDecimal addAmountWeekly, BigDecimal addAmountDaily, BigDecimal freeAllowanceWeekly, BigDecimal freeAllowanceDaily, boolean noElstam, boolean reregister, boolean crossBorderEmployeeFrance) {
        this.mTaxOffice = taxOffice;
        this.mCommunity = community;
        this.mFederalState = federalState;
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mTaxCardPresented = taxCardPresented;
        this.mIssueYearTaxCard = issueYearTaxCard;
        this.mEntryDateTaxCard = entryDateTaxCard;
        this.mDateDelivered = dateDelivered;
        this.mDateReturned = dateReturned;
        this.mIssueDateTaxCard = issueDateTaxCard;
        this.mPseudonym = pseudonym;
        this.mTaxBracket = taxBracket;
        this.mChildRelief = childRelief;
        this.mChurchTaxEE = churchTaxEE;
        this.mChurchTaxSpouse = churchTaxSpouse;
        this.mFreeAllowanceYY = freeAllowanceYY;
        this.mFreeAllowanceMM = freeAllowanceMM;
        this.mAddAmountYY = addAmountYY;
        this.mAddAmountMM = addAmountMM;
        this.mTaxacation = taxacation;
        this.mPayeTaxFindings = payeTaxFindings;
        this.mPayeTax = payeTax;
        this.mChurchTax = churchTax;
        this.mSolidarityCharge = solidarityCharge;
        this.mIncomeTaxReturnYY = incomeTaxReturnYY;
        this.mComputationOfUnderpaymentChurchTax = computationOfUnderpaymentChurchTax;
        this.mComputationOfUnderpaymentIncomeTax = computationOfUnderpaymentIncomeTax;
        this.mComputationOfUnderpaymentSolidarityCharge = computationOfUnderpaymentSolidarityCharge;
        this.mChurchTaxDomicile = churchTaxDomicile;
        this.mAssociationEE = associationEE;
        this.mERpaysContribut = erPaysContribut;
        this.mDevRedHHBenfGrp = devRedHHBenfGrp;
        this.mDevRedHHBenfRate = devRedHHBenfRate;
        this.mCtfcGfBwoutTax = ctfcGfBwoutTax;
        this.mCtfcYYGfBwoutTax = ctfcYYGfBwoutTax;
        this.mRegistrGfBwoutTax = registrGfBwoutTax;
        this.mTaxOfficeGfBwoutTax = taxOfficeGfBwoutTax;
        this.mDateCtfcGfBwoutTax = dateCtfcGfBwoutTax;
        this.mTaxNumber = taxNumber;
        this.mCtfcDBAwoutTax = ctfcDBAwoutTax;
        this.mRegistrDBAwoutTax = registrDBAwoutTax;
        this.mFromDBAwoutTax = fromDBAwoutTax;
        this.mUntilDBAwoutTax = untilDBAwoutTax;
        this.mTaxOfficeDBAwoutTax = taxOfficeDBAwoutTax;
        this.mDateCtfcDBAwoutTax = dateCtfcDBAwoutTax;
        this.mOldAgeReliefAmount = oldAgeReliefAmount;
        this.mPensionFreeDues = pensionFreeDues;
        this.mWageTaxCertificate = wageTaxCertificate;
        this.mRedOfChurchTax = redOfChurchTax;
        this.mMonthlyEarnings = monthlyEarnings;
        this.mMemo = memo;
        this.mPension = pension;
        this.mStartDateOfPension = startDateOfPension;
        this.mBonusOfPension = bonusOfPension;
        this.mChurchTaxDeduction = churchTaxDeduction;
        this.mEvaluationTargetOfPayment = evaluationTargetOfPayment;
        this.mTaxOfSwitzerland = taxOfSwitzerland;
        this.mNegativeTaxPossible = negativeTaxPossible;
        this.mTin = tin;
        this.mPercentageSplit = percentageSplit;
        this.mSidelineEmployer = sidelineEmployer;
        this.mAddAmountDaily = addAmountDaily;
        this.mAddAmountWeekly = addAmountWeekly;
        this.mFreeAllowanceDaily = freeAllowanceDaily;
        this.mFreeAllowanceWeekly = freeAllowanceWeekly;
        this.mNoElstam = noElstam;
        this.mReregister = reregister;
        this.mCrossBorderEmployeeFrance = crossBorderEmployeeFrance;
    }

    @Override
    public PersonnelTimedPersistenceObject createNew() {
        Tax result = new Tax(this.mEmployee);
        result.mEffectiveFrom = this.getEffectiveFrom();
        result.mEffectiveUntil = this.getEffectiveUntil();
        result.mValidFrom = this.getValidFrom();
        result.mValidUntil = this.getValidUntil();
        result.mTaxCardPresented = this.getTaxCardPresented();
        result.mIssueYearTaxCard = this.getIssueYearTaxCard();
        result.mEntryDateTaxCard = this.getEntryDateTaxCard();
        result.mDateDelivered = this.getDateDelivered();
        result.mDateReturned = this.getDateReturned();
        result.mTaxOffice = this.getTaxOffice();
        result.mCommunity = this.getCommunity();
        result.mIssueDateTaxCard = this.getIssueDateTaxCard();
        result.mPseudonym = this.getPseudonym();
        result.mTaxBracket = this.getTaxBracket();
        result.mChildRelief = this.getChildRelief();
        result.mChurchTaxEE = this.getChurchTaxEE();
        result.mChurchTaxSpouse = this.getChurchTaxSpouse();
        result.mFreeAllowanceYY = this.getFreeAllowanceYY();
        result.mFreeAllowanceMM = this.getFreeAllowanceMM();
        result.mAddAmountYY = this.getAddAmountYY();
        result.mAddAmountMM = this.getAddAmountMM();
        result.mTaxacation = this.getTaxacation();
        result.mPayeTaxFindings = this.getPayeTaxFindings();
        result.mPayeTax = this.getPayeTax();
        result.mChurchTax = this.getChurchTax();
        result.mSolidarityCharge = this.getSolidarityCharge();
        result.mIncomeTaxReturnYY = this.getIncomeTaxReturnYY();
        result.mComputationOfUnderpaymentChurchTax = this.isComputationOfUnderpaymentChurchTax();
        result.mComputationOfUnderpaymentIncomeTax = this.isComputationOfUnderpaymentIncomeTax();
        result.mComputationOfUnderpaymentSolidarityCharge = this.isComputationOfUnderpaymentSolidarityCharge();
        result.mChurchTaxDomicile = this.getChurchTaxDomicile();
        result.mFederalState = this.getFederalState();
        result.mAssociationEE = this.getAssociationEE();
        result.mDevRedHHBenfGrp = this.getDevRedHHBenfGrp();
        result.mDevRedHHBenfRate = this.getDevRedHHBenfRate();
        result.mCtfcGfBwoutTax = this.getCtfcGfBwoutTax();
        result.mCtfcYYGfBwoutTax = this.getCtfcYYGfBwoutTax();
        result.mRegistrGfBwoutTax = this.getRegistrGfBwoutTax();
        result.mTaxOfficeGfBwoutTax = this.getTaxOfficeGfBwoutTax();
        result.mDateCtfcGfBwoutTax = this.getDateCtfcGfBwoutTax();
        result.mTaxNumber = this.getTaxNumber();
        result.mCtfcDBAwoutTax = this.getCtfcDBAwoutTax();
        result.mRegistrDBAwoutTax = this.getRegistrDBAwoutTax();
        result.mFromDBAwoutTax = this.getFromDBAwoutTax();
        result.mUntilDBAwoutTax = this.getUntilDBAwoutTax();
        result.mTaxOfficeDBAwoutTax = this.getTaxOfficeDBAwoutTax();
        result.mDateCtfcDBAwoutTax = this.getDateCtfcDBAwoutTax();
        result.mOldAgeReliefAmount = this.getOldAgeReliefAmount();
        result.mPensionFreeDues = this.getPensionFreeDues();
        result.mWageTaxCertificate = this.getWageTaxCertificate();
        result.mRedOfChurchTax = this.getRedOfChurchTax();
        result.mMonthlyEarnings = this.getMonthlyEarnings();
        result.mMemo = this.getMemo();
        result.mPension = this.getPension();
        result.mStartDateOfPension = this.getStartDateOfPension();
        result.mBonusOfPension = this.getBonusOfPension();
        result.mChurchTaxDeduction = this.getChurchTaxDeduction();
        result.mEvaluationTargetOfPayment = this.getEvaluationTargetOfPayment();
        result.mTaxOfSwitzerland = this.getTaxOfSwitzerland();
        result.mNegativeTaxPossible = this.isNegativeTaxPossible();
        result.mTin = this.getTin();
        result.mPercentageSplit = this.getPercentageSplit();
        result.mSidelineEmployer = this.getSidelineEmployer();
        result.mAddAmountDaily = this.getAddAmountDaily();
        result.mAddAmountWeekly = this.getAddAmountWeekly();
        result.mFreeAllowanceDaily = this.getFreeAllowanceDaily();
        result.mFreeAllowanceWeekly = this.getFreeAllowanceWeekly();
        result.mNoElstam = this.getNoElstam();
        result.mReregister = this.getReregister();
        result.mCrossBorderEmployeeFrance = this.getCrossBorderEmployeeFrance();
        return result;
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public boolean getTaxCardPresented() {
        this.requireLoaded();
        return this.mTaxCardPresented;
    }

    public void setTaxCardPresented(boolean taxCardPresented) {
        this.mTaxCardPresented = taxCardPresented;
    }

    public int getIssueYearTaxCard() {
        this.requireLoaded();
        return this.mIssueYearTaxCard;
    }

    public void setIssueYearTaxCard(int issueYearTaxCard) {
        this.mIssueYearTaxCard = issueYearTaxCard;
    }

    public Date getEntryDateTaxCard() {
        this.requireLoaded();
        return this.mEntryDateTaxCard;
    }

    public void setEntryDateTaxCard(Date entryDateTaxCard) {
        this.mEntryDateTaxCard = entryDateTaxCard;
    }

    public Date getDateDelivered() {
        this.requireLoaded();
        return this.mDateDelivered;
    }

    public void setDateDelivered(Date dateDelivered) {
        this.mDateDelivered = dateDelivered;
    }

    public Date getDateReturned() {
        this.requireLoaded();
        return this.mDateReturned;
    }

    public void setDateReturned(Date dateReturned) {
        this.mDateReturned = dateReturned;
    }

    public TaxOffice getTaxOffice() {
        this.requireLoaded();
        return this.mTaxOffice;
    }

    public void setTaxOffice(TaxOffice taxOffice) {
        this.mTaxOffice = taxOffice;
    }

    public Community getCommunity() {
        this.requireLoaded();
        return this.mCommunity;
    }

    public void setCommunity(Community community) {
        this.mCommunity = community;
    }

    public Date getIssueDateTaxCard() {
        this.requireLoaded();
        return this.mIssueDateTaxCard;
    }

    public void setIssueDateTaxCard(Date issueDateTaxCard) {
        this.mIssueDateTaxCard = issueDateTaxCard;
    }

    public String getPseudonym() {
        this.requireLoaded();
        return this.mPseudonym;
    }

    public void setPseudonym(String pseudonym) {
        this.mPseudonym = pseudonym;
    }

    public int getTaxBracket() {
        this.requireLoaded();
        return this.mTaxBracket;
    }

    public void setTaxBracket(int taxBracket) {
        this.mTaxBracket = taxBracket;
    }

    public BigDecimal getChildRelief() {
        this.requireLoaded();
        return this.mChildRelief == null ? new BigDecimal("0.0") : this.mChildRelief;
    }

    public void setChildRelief(BigDecimal childRelief) {
        this.mChildRelief = childRelief;
    }

    public ChurchTaxEnum getChurchTaxEE() {
        this.requireLoaded();
        return this.mChurchTaxEE;
    }

    public void setChurchTaxEE(ChurchTaxEnum churchTaxEE) {
        this.mChurchTaxEE = churchTaxEE;
    }

    public ChurchTaxEnum getChurchTaxSpouse() {
        this.requireLoaded();
        return this.mChurchTaxSpouse;
    }

    public void setChurchTaxSpouse(ChurchTaxEnum churchTaxSpouse) {
        this.mChurchTaxSpouse = churchTaxSpouse;
    }

    public BigDecimal getFreeAllowanceYY() {
        this.requireLoaded();
        return this.mFreeAllowanceYY == null ? new BigDecimal("0.00") : this.mFreeAllowanceYY;
    }

    public void setFreeAllowanceYY(BigDecimal freeAllowanceYY) {
        this.mFreeAllowanceYY = freeAllowanceYY;
    }

    public BigDecimal getFreeAllowanceMM() {
        this.requireLoaded();
        return this.mFreeAllowanceMM == null ? new BigDecimal("0.00") : this.mFreeAllowanceMM;
    }

    public void setFreeAllowanceMM(BigDecimal freeAllowanceMM) {
        this.mFreeAllowanceMM = freeAllowanceMM;
    }

    public BigDecimal getAddAmountYY() {
        this.requireLoaded();
        return this.mAddAmountYY == null ? new BigDecimal("0.00") : this.mAddAmountYY;
    }

    public void setAddAmountYY(BigDecimal addAmountYY) {
        this.mAddAmountYY = addAmountYY;
    }

    public BigDecimal getAddAmountMM() {
        this.requireLoaded();
        return this.mAddAmountMM == null ? new BigDecimal("0.00") : this.mAddAmountMM;
    }

    public void setAddAmountMM(BigDecimal addAmountMM) {
        this.mAddAmountMM = addAmountMM;
    }

    public TaxacationEnum getTaxacation() {
        this.requireLoaded();
        return this.mTaxacation;
    }

    public void setTaxacation(TaxacationEnum taxacation) {
        this.mTaxacation = taxacation;
    }

    public PAYETaxFindingsEnum getPayeTaxFindings() {
        this.requireLoaded();
        return this.mPayeTaxFindings;
    }

    public void setPayeTaxFindings(PAYETaxFindingsEnum payeTaxFindings) {
        this.mPayeTaxFindings = payeTaxFindings;
    }

    public boolean getPayeTax() {
        this.requireLoaded();
        return this.mPayeTax;
    }

    public void setPayeTax(boolean payeTax) {
        this.mPayeTax = payeTax;
    }

    public boolean getChurchTax() {
        this.requireLoaded();
        return this.mChurchTax;
    }

    public void setChurchTax(boolean churchTax) {
        this.mChurchTax = churchTax;
    }

    public boolean getSolidarityCharge() {
        this.requireLoaded();
        return this.mSolidarityCharge;
    }

    public void setSolidarityCharge(boolean solidarityCharge) {
        this.mSolidarityCharge = solidarityCharge;
    }

    public IncomeTaxReturnYYEnum getIncomeTaxReturnYY() {
        this.requireLoaded();
        return this.mIncomeTaxReturnYY;
    }

    public void setIncomeTaxReturnYY(IncomeTaxReturnYYEnum incomeTaxReturnYY) {
        this.mIncomeTaxReturnYY = incomeTaxReturnYY;
    }

    public boolean isComputationOfUnderpaymentChurchTax() {
        this.requireLoaded();
        return this.mComputationOfUnderpaymentChurchTax;
    }

    public boolean isComputationOfUnderpaymentIncomeTax() {
        this.requireLoaded();
        return this.mComputationOfUnderpaymentIncomeTax;
    }

    public boolean isComputationOfUnderpaymentSolidarityCharge() {
        this.requireLoaded();
        return this.mComputationOfUnderpaymentSolidarityCharge;
    }

    public void setComputationOfUnderpaymentChurchTax(boolean computationOfUnderpaymentChurchTax) {
        this.mComputationOfUnderpaymentChurchTax = computationOfUnderpaymentChurchTax;
    }

    public void setComputationOfUnderpaymentIncomeTax(boolean computationOfUnderpaymentIncomeTax) {
        this.mComputationOfUnderpaymentIncomeTax = computationOfUnderpaymentIncomeTax;
    }

    public void setComputationOfUnderpaymentSolidarityCharge(boolean computationOfUnderpaymentSolidarityCharge) {
        this.mComputationOfUnderpaymentSolidarityCharge = computationOfUnderpaymentSolidarityCharge;
    }

    public boolean getChurchTaxDomicile() {
        this.requireLoaded();
        return this.mChurchTaxDomicile;
    }

    public void setChurchTaxDomicile(boolean churchTaxDomicile) {
        this.mChurchTaxDomicile = churchTaxDomicile;
    }

    public FederalState getFederalState() {
        this.requireLoaded();
        return this.mFederalState;
    }

    public void setFederalState(FederalState federalState) {
        this.mFederalState = federalState;
    }

    public boolean getAssociationEE() {
        this.requireLoaded();
        return this.mAssociationEE;
    }

    public void setAssociationEE(boolean associationEE) {
        this.mAssociationEE = associationEE;
    }

    public boolean getERpaysContribut() {
        this.requireLoaded();
        return this.mERpaysContribut;
    }

    public void setERpaysContribut(boolean erPaysContribut) {
        this.mERpaysContribut = erPaysContribut;
    }

    public DevRedHHBenfGrpEnum getDevRedHHBenfGrp() {
        this.requireLoaded();
        return this.mDevRedHHBenfGrp;
    }

    public void setDevRedHHBenfGrp(DevRedHHBenfGrpEnum devRedHHBenfGrp) {
        this.mDevRedHHBenfGrp = devRedHHBenfGrp;
    }

    public DevRedHHBenfRateEnum getDevRedHHBenfRate() {
        this.requireLoaded();
        return this.mDevRedHHBenfRate;
    }

    public void setDevRedHHBenfRate(DevRedHHBenfRateEnum devRedHHBenfRate) {
        this.mDevRedHHBenfRate = devRedHHBenfRate;
    }

    public boolean getCtfcGfBwoutTax() {
        this.requireLoaded();
        return this.mCtfcGfBwoutTax;
    }

    public void setCtfcGfBwoutTax(boolean ctfcGfBwoutTax) {
        this.mCtfcGfBwoutTax = ctfcGfBwoutTax;
    }

    public int getCtfcYYGfBwoutTax() {
        this.requireLoaded();
        return this.mCtfcYYGfBwoutTax;
    }

    public void setCtfcYYGfBwoutTax(int ctfcYYGfBwoutTax) {
        this.mCtfcYYGfBwoutTax = ctfcYYGfBwoutTax;
    }

    public Date getRegistrGfBwoutTax() {
        this.requireLoaded();
        return this.mRegistrGfBwoutTax;
    }

    public void setRegistrGfBwoutTax(Date registrGfBwoutTax) {
        this.mRegistrGfBwoutTax = registrGfBwoutTax;
    }

    public TaxOffice getTaxOfficeGfBwoutTax() {
        this.requireLoaded();
        return this.mTaxOfficeGfBwoutTax;
    }

    public void setTaxOfficeGfBwoutTax(TaxOffice taxOfficeGfBwoutTax) {
        this.mTaxOfficeGfBwoutTax = taxOfficeGfBwoutTax;
    }

    public Date getDateCtfcGfBwoutTax() {
        this.requireLoaded();
        return this.mDateCtfcGfBwoutTax;
    }

    public void setDateCtfcGfBwoutTax(Date dateCtfcGfBwoutTax) {
        this.mDateCtfcGfBwoutTax = dateCtfcGfBwoutTax;
    }

    public String getTaxNumber() {
        this.requireLoaded();
        return this.mTaxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.mTaxNumber = taxNumber;
    }

    public boolean getCtfcDBAwoutTax() {
        this.requireLoaded();
        return this.mCtfcDBAwoutTax;
    }

    public void setCtfcDBAwoutTax(boolean ctfcDBAwoutTax) {
        this.mCtfcDBAwoutTax = ctfcDBAwoutTax;
    }

    public Date getRegistrDBAwoutTax() {
        this.requireLoaded();
        return this.mRegistrDBAwoutTax;
    }

    public void setRegistrDBAwoutTax(Date registrDBAwoutTax) {
        this.mRegistrDBAwoutTax = registrDBAwoutTax;
    }

    public Date getFromDBAwoutTax() {
        this.requireLoaded();
        return this.mFromDBAwoutTax;
    }

    public void setFromDBAwoutTax(Date fromDBAwoutTax) {
        this.mFromDBAwoutTax = fromDBAwoutTax;
    }

    public Date getUntilDBAwoutTax() {
        this.requireLoaded();
        return this.mUntilDBAwoutTax;
    }

    public void setUntilDBAwoutTax(Date untilDBAwoutTax) {
        this.mUntilDBAwoutTax = untilDBAwoutTax;
    }

    public TaxOffice getTaxOfficeDBAwoutTax() {
        this.requireLoaded();
        return this.mTaxOfficeDBAwoutTax;
    }

    public void setTaxOfficeDBAwoutTax(TaxOffice taxOfficeDBAwoutTax) {
        this.mTaxOfficeDBAwoutTax = taxOfficeDBAwoutTax;
    }

    public Date getDateCtfcDBAwoutTax() {
        this.requireLoaded();
        return this.mDateCtfcDBAwoutTax;
    }

    public void setDateCtfcDBAwoutTax(Date dateCtfcDBAwoutTax) {
        this.mDateCtfcDBAwoutTax = dateCtfcDBAwoutTax;
    }

    public boolean getOldAgeReliefAmount() {
        this.requireLoaded();
        return this.mOldAgeReliefAmount;
    }

    public void setOldAgeReliefAmount(boolean oldAgeReliefAmount) {
        this.mOldAgeReliefAmount = oldAgeReliefAmount;
    }

    public boolean getPensionFreeDues() {
        this.requireLoaded();
        return this.mPensionFreeDues;
    }

    public void setPensionFreeDues(boolean pensionFreeDues) {
        this.mPensionFreeDues = pensionFreeDues;
    }

    public boolean getWageTaxCertificate() {
        this.requireLoaded();
        return this.mWageTaxCertificate;
    }

    public void setWageTaxCertificate(boolean wageTaxCertificate) {
        this.mWageTaxCertificate = wageTaxCertificate;
    }

    public boolean getRedOfChurchTax() {
        this.requireLoaded();
        return this.mRedOfChurchTax;
    }

    public void setRedOfChurchTax(boolean redOfChurchTax) {
        this.mRedOfChurchTax = redOfChurchTax;
    }

    public BigDecimal getMonthlyEarnings() {
        this.requireLoaded();
        return this.mMonthlyEarnings;
    }

    public void setMonthlyEarnings(BigDecimal monthlyEarnings) {
        this.mMonthlyEarnings = monthlyEarnings;
    }

    public String getMemo() {
        this.requireLoaded();
        return this.mMemo;
    }

    public void setMemo(String memo) {
        this.mMemo = memo;
    }

    public BigDecimal getPension() {
        this.requireLoaded();
        return this.mPension;
    }

    public void setPension(BigDecimal pension) {
        this.mPension = pension;
    }

    public Date getStartDateOfPension() {
        this.requireLoaded();
        return this.mStartDateOfPension;
    }

    public void setStartDateOfPension(Date startDateOfPension) {
        this.mStartDateOfPension = startDateOfPension;
    }

    public BigDecimal getBonusOfPension() {
        this.requireLoaded();
        return this.mBonusOfPension;
    }

    public void setBonusOfPension(BigDecimal bonusOfPension) {
        this.mBonusOfPension = bonusOfPension;
    }

    public boolean getChurchTaxDeduction() {
        this.requireLoaded();
        return this.mChurchTaxDeduction;
    }

    public void setChurchTaxDeduction(boolean churchTaxDeduction) {
        this.mChurchTaxDeduction = churchTaxDeduction;
    }

    public EvaluationTargetOfPaymentEnum getEvaluationTargetOfPayment() {
        this.requireLoaded();
        return this.mEvaluationTargetOfPayment;
    }

    public void setEvaluationTargetOfPayment(EvaluationTargetOfPaymentEnum evaluationTargetOfPayment) {
        this.mEvaluationTargetOfPayment = evaluationTargetOfPayment;
    }

    public BigDecimal getTaxOfSwitzerland() {
        this.requireLoaded();
        return this.mTaxOfSwitzerland;
    }

    public void setTaxOfSwitzerland(BigDecimal taxOfSwitzerland) {
        this.mTaxOfSwitzerland = taxOfSwitzerland;
    }

    public boolean isNegativeTaxPossible() {
        this.requireLoaded();
        return this.mNegativeTaxPossible;
    }

    public void setNegativeTaxPosible(boolean bool) {
        this.mNegativeTaxPossible = bool;
    }

    public String getTin() {
        this.requireLoaded();
        return this.mTin;
    }

    public void setTin(String tin) {
        this.mTin = tin;
    }

    public BigDecimal getPercentageSplit() {
        this.requireLoaded();
        return this.mPercentageSplit == null ? new BigDecimal("0.000") : this.mPercentageSplit;
    }

    public void setPercentageSplit(BigDecimal percentageSplit) {
        this.mPercentageSplit = percentageSplit;
    }

    public boolean getSidelineEmployer() {
        this.requireLoaded();
        return this.mSidelineEmployer;
    }

    public void setSidelineEmployer(boolean sidelineEmployer) {
        this.mSidelineEmployer = sidelineEmployer;
    }

    public BigDecimal getAddAmountWeekly() {
        this.requireLoaded();
        return this.mAddAmountWeekly;
    }

    public void setAddAmountWeekly(BigDecimal addAmountWeekly) {
        this.mAddAmountWeekly = addAmountWeekly;
    }

    public BigDecimal getAddAmountDaily() {
        this.requireLoaded();
        return this.mAddAmountDaily;
    }

    public void setAddAmountDaily(BigDecimal addAmountDaily) {
        this.mAddAmountDaily = addAmountDaily;
    }

    public BigDecimal getFreeAllowanceWeekly() {
        this.requireLoaded();
        return this.mFreeAllowanceWeekly;
    }

    public void setFreeAllowanceWeekly(BigDecimal freeAllowanceWeekly) {
        this.mFreeAllowanceWeekly = freeAllowanceWeekly;
    }

    public BigDecimal getFreeAllowanceDaily() {
        this.requireLoaded();
        return this.mFreeAllowanceDaily;
    }

    public void setFreeAllowanceDaily(BigDecimal freeAllowanceDaily) {
        this.mFreeAllowanceDaily = freeAllowanceDaily;
    }

    public boolean getNoElstam() {
        this.requireLoaded();
        return this.mNoElstam;
    }

    public void setNoElstam(boolean noElstam) {
        this.mNoElstam = noElstam;
    }

    public boolean getReregister() {
        this.requireLoaded();
        return this.mReregister;
    }

    public void setReregister(boolean reregister) {
        this.mReregister = reregister;
    }

    public boolean getCrossBorderEmployeeFrance() {
        this.requireLoaded();
        return this.mCrossBorderEmployeeFrance;
    }

    public void setCrossBorderEmployeeFrance(boolean crossBorderEmployeeFrance) {
        this.mCrossBorderEmployeeFrance = crossBorderEmployeeFrance;
    }

    public void compareToOld(Tax old) {
        if (old == null) {
            return;
        }
        old.requireLoaded();
        this.mOld = old;
        if (DateHelper.after((Date)old.getValidFrom(), (Date)this.mValidFrom)) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getTaxBracket() != this.mTaxBracket) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getChildRelief(), (BigDecimal)this.mChildRelief)) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getChurchTaxEE().value() != this.mChurchTaxEE.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getChurchTaxSpouse().value() != this.mChurchTaxSpouse.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getFreeAllowanceYY(), (BigDecimal)this.mFreeAllowanceYY)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getFreeAllowanceMM(), (BigDecimal)this.mFreeAllowanceMM)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getAddAmountYY(), (BigDecimal)this.mAddAmountYY)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getAddAmountMM(), (BigDecimal)this.mAddAmountMM)) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getTaxacation().value() != this.mTaxacation.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getPayeTaxFindings().value() != this.mPayeTaxFindings.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getPayeTax() != this.mPayeTax) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getChurchTax() != this.mChurchTax) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getSolidarityCharge() != this.mSolidarityCharge) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getIncomeTaxReturnYY().value() != this.mIncomeTaxReturnYY.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isComputationOfUnderpaymentChurchTax() != this.mComputationOfUnderpaymentChurchTax) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isComputationOfUnderpaymentIncomeTax() != this.mComputationOfUnderpaymentIncomeTax) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isComputationOfUnderpaymentSolidarityCharge() != this.mComputationOfUnderpaymentSolidarityCharge) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getChurchTaxDomicile() != this.mChurchTaxDomicile) {
            this.setValuateNeeded(true);
            return;
        }
        if (this.mChurchTaxDomicile && StringMapper.compareTo((String)old.getFederalState().getObjectid(), (String)this.mFederalState.getObjectid()) != 0) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getAssociationEE() != this.mAssociationEE) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getERpaysContribut() != this.mERpaysContribut) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getDevRedHHBenfGrp().value() != this.mDevRedHHBenfGrp.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getDevRedHHBenfRate().value() != this.mDevRedHHBenfRate.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getOldAgeReliefAmount() != this.mOldAgeReliefAmount) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getPensionFreeDues() != this.mPensionFreeDues) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getWageTaxCertificate() != this.mWageTaxCertificate) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getRedOfChurchTax() != this.mRedOfChurchTax) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getMonthlyEarnings(), (BigDecimal)this.mMonthlyEarnings)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getPension(), (BigDecimal)this.mPension)) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getBonusOfPension(), (BigDecimal)this.mBonusOfPension)) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getChurchTaxDeduction() != this.mChurchTaxDeduction) {
            this.setValuateNeeded(true);
            return;
        }
        if (DateHelper.compareDateWithNull((Date)old.getStartDateOfPension(), (Date)this.mStartDateOfPension) != 0) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getEvaluationTargetOfPayment().value() != this.mEvaluationTargetOfPayment.value()) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getTaxOfSwitzerland(), (BigDecimal)this.mTaxOfSwitzerland)) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isNegativeTaxPossible() != this.mNegativeTaxPossible) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getPercentageSplit(), (BigDecimal)this.mPercentageSplit)) {
            this.setValuateNeeded(true);
            return;
        }
    }

    @Override
    public void checkAttributes() throws BusinessDomainException {
        this.requireLoaded();
        try {
            this.checkDates();
            if (!this.mSpecialChecks) {
                this.checkValidFromAgainstRetroactiveCalculation(this.getEmployee());
            }
            this.checkTaxBracket();
            this.checkChildRelief();
            this.checkPercentageSplit();
            this.checkChurchTax();
            this.checkPayeTaxFindings();
            this.checkPayeTax();
            this.checkChurchTaxAgainstTaxaction();
            this.checkSolidarityCharge();
            this.checkIncomeTaxReturnYY();
            this.checkAssociationEE();
            this.checkFreeAllowance();
            this.checkAddAmount();
            this.checkTaxCardPresented();
            this.checkPension();
            this.checkChangeOfTaxData();
            this.checkTaxOfSwitzerland();
            this.checkTin();
            this.checkPauschsteuerGfB();
            this.checkDBATuerkei();
            this.checkSidelineEmployer();
        }
        catch (BusinessDomainException e) {
            if (!this.mSpecialChecks) {
                BusinessDomainException bde = new BusinessDomainException(e.getMessage() + " ; f\u00fcr Firma/PNr.: " + this.mEmployee.getPCompany().getPCompanyKey() + " / " + this.mEmployee.getPersonnelnumber(), e.getErrorNumber(), e.getServerMethod(), e.getDomain(), e.getValues());
                throw bde;
            }
            throw e;
        }
    }

    private void checkSidelineEmployer() throws BusinessDomainException {
        switch (this.getTaxBracket()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!this.getSidelineEmployer()) break;
                throw EmployeeExceptionMapper.makeTaxBraketFalseWhenSidelineEmployerDomainException();
            }
            case 6: {
                if (this.getSidelineEmployer()) break;
                throw EmployeeExceptionMapper.makeTaxBracketFalseWhenNotSidelineEmployerDomainException();
            }
        }
    }

    private void checkDBATuerkei() throws BusinessDomainException {
        if (this.mTaxacation == TaxacationEnum.TE_DBA_TUERKEI && (!this.mPensionFreeDues || this.mTaxBracket != 1 && this.mTaxBracket != 6)) {
            throw EmployeeExceptionMapper.makeDBATuerkeiNotAllowedDomainException();
        }
    }

    private void checkPauschsteuerGfB() throws BusinessDomainException {
        try {
            Date checkDate = this.mValidFrom;
            int yearOfJournalizedUntil = new VDate(this.mEmployee.getJournalizedUntil()).getYear();
            Date smallestCheckDate = new VDate(yearOfJournalizedUntil, 0, 1).getDate();
            if (DateHelper.before((Date)checkDate, (Date)smallestCheckDate)) {
                checkDate = smallestCheckDate;
            }
            Insurance insurance = this.mEmployee.getInsurance(VDate.getDateMax(), checkDate);
            TaxacationEnum taxacation = this.mTaxacation;
            if (this.mEmployee.noCheckForEvPT()) {
                return;
            }
            this.mEmployee.specialCheckLumpSumAndPersongroup(insurance, taxacation, checkDate);
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return;
            }
            throw e;
        }
    }

    @Override
    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        boolean firstOfHistorie = this.getEmployee().getTaxHistory().getSize() == 0;
        Date[] dates = this.getEmployee().checkDates(firstOfHistorie, this.getValidFrom());
        this.setEffectiveFrom(dates[0]);
        this.setValidFrom(dates[1]);
    }

    private void checkTaxBracket() throws BusinessDomainException {
        if (this.mTaxBracket < 0 || this.mTaxBracket > 6) {
            throw EmployeeExceptionMapper.makeTaxBracketFalseDomainException();
        }
    }

    private void checkChildRelief() throws BusinessDomainException {
        BigDecimal bigDecimalX = this.getChildRelief().subtract(new BigDecimal(this.getChildRelief().intValue()));
        if (!BigDecimalMapper.isZero((BigDecimal)bigDecimalX) && bigDecimalX.compareTo(new BigDecimal("0.5")) != 0) {
            throw EmployeeExceptionMapper.makeChildReliefFalseDomainException();
        }
        if (!(this.getTaxBracket() != 5 && this.getTaxBracket() != 6 || BigDecimalMapper.isZero((BigDecimal)this.getChildRelief()))) {
            throw EmployeeExceptionMapper.makeChildReliefAndTaxBracketDontCorrespondingDomainException();
        }
    }

    private void checkPayeTaxFindings() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2010, 0, 1).getDate()) && this.mPayeTaxFindings == PAYETaxFindingsEnum.PTFE_GUENSTIGERPRUEFUNG_VORSORGEPAUSCHALE) {
            throw EmployeeExceptionMapper.makeGuenstigerpruefungNotAllowedDomainException();
        }
        switch (this.getTaxacation().value()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.getPayeTaxFindings().value() == 0) break;
                throw EmployeeExceptionMapper.makePayeTaxFindingsAndTaxacationDontCorrespondingDomainException();
            }
        }
        switch (this.getTaxBracket()) {
            case 0: {
                if (this.getPayeTaxFindings().value() == 0) break;
                throw EmployeeExceptionMapper.makePayeTaxFindingsAndTaxBracketDontCorrespondingDomainException();
            }
            default: {
                if (this.getPayeTaxFindings().value() != 0) break;
                throw EmployeeExceptionMapper.makePayeTaxFindingsAndTaxBracketValidDontCorrespondingDomainException();
            }
        }
        if (this.getPayeTaxFindings().value() == 3 && DateHelper.before((Date)this.mValidFrom, (Date)new VDate(2008, 0, 1).getDate())) {
            throw EmployeeExceptionMapper.makePayeTaxFindingsAndValidFromDontCorrespondingDomainException();
        }
    }

    private void checkPayeTax() throws BusinessDomainException {
        switch (this.getTaxacation().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (!this.getPayeTax()) break;
                throw EmployeeExceptionMapper.makePayeTaxAndTaxacationDontCorrespondingDomainException();
            }
        }
    }

    private void checkSolidarityCharge() throws BusinessDomainException {
        switch (this.getTaxacation().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (!this.getSolidarityCharge()) break;
                throw EmployeeExceptionMapper.makeSolidarityChargeAndTaxacationDontCorrespondingDomainException();
            }
        }
    }

    private void checkIncomeTaxReturnYY() throws BusinessDomainException {
        if (this.getTaxacation().value() != 2 && this.getIncomeTaxReturnYY().value() != 0) {
            throw EmployeeExceptionMapper.makeIncomeTaxReturnYYAndTaxacationDontCorrespondingDomainException();
        }
        if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2007, 0, 1).getDate()) && this.mIncomeTaxReturnYY.value() == 2) {
            throw EmployeeExceptionMapper.makePermanentIncomeTaxReturnYYNotAllowedDomainException();
        }
        if (this.getIncomeTaxReturnYY().value() != 0) {
            if (!BigDecimalMapper.isZero((BigDecimal)this.getAddAmountYY()) || !BigDecimalMapper.isZero((BigDecimal)this.getAddAmountMM())) {
                throw EmployeeExceptionMapper.makeIncomeTaxReturnYYAndAddAmountsDontCorrespondingDomainException();
            }
            if (!BigDecimalMapper.isZero((BigDecimal)this.getFreeAllowanceYY()) || !BigDecimalMapper.isZero((BigDecimal)this.getFreeAllowanceMM())) {
                throw EmployeeExceptionMapper.makeIncomeTaxReturnYYAndFreeAllowancesDontCorrespondingDomainException();
            }
        }
    }

    public void checkAssociationEE() throws BusinessDomainException {
        if (this.getAssociationEE()) {
            this.mEmployee.checkAssociationEE(this.mEffectiveFrom, this.mValidFrom);
        }
    }

    private void checkFreeAllowance() throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)this.getFreeAllowanceMM()) && BigDecimalMapper.isZero((BigDecimal)this.getFreeAllowanceYY())) {
            throw EmployeeExceptionMapper.makeFreeAllowanceYYAndMMDontCorrespondingDomainException();
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.getFreeAllowanceYY())) {
            if (!BigDecimalMapper.isZero((BigDecimal)this.getAddAmountYY()) || !BigDecimalMapper.isZero((BigDecimal)this.getAddAmountMM())) {
                throw EmployeeExceptionMapper.makeFreeAllowanceAndAddAmountDontCorrespondingDomainException();
            }
            if (this.getFreeAllowanceYY().signum() == -1) {
                throw EmployeeExceptionMapper.makeFreeAllowanceYYFalseDomainException();
            }
            if (this.getFreeAllowanceMM().signum() == -1) {
                throw EmployeeExceptionMapper.makeFreeAllowanceMMFalseDomainException();
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.getFreeAllowanceMM(), (BigDecimal)this.getFreeAllowanceYY()) == 1) {
                throw EmployeeExceptionMapper.makeFreeAllowanceMMGreaterFreeAllowanceYYDomainException();
            }
        }
    }

    private void checkAddAmount() throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)this.getAddAmountYY()) && BigDecimalMapper.isZero((BigDecimal)this.getAddAmountMM())) {
            throw EmployeeExceptionMapper.makeAddAmountYYAndMMDontCorrespondingDomainException();
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.getAddAmountYY())) {
            switch (this.getTaxBracket()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw EmployeeExceptionMapper.makeAddAmountAndTaxBracketDontCorrespondingDomainException();
                }
            }
            if (!BigDecimalMapper.isZero((BigDecimal)this.getAddAmountYY())) {
                if (!BigDecimalMapper.isZero((BigDecimal)this.getFreeAllowanceYY()) || !BigDecimalMapper.isZero((BigDecimal)this.getFreeAllowanceMM())) {
                    throw EmployeeExceptionMapper.makeFreeAllowanceAndAddAmountDontCorrespondingDomainException();
                }
                if (this.getAddAmountYY().signum() == -1) {
                    throw EmployeeExceptionMapper.makeAddAmountYYFalseDomainException();
                }
                if (this.getAddAmountMM().signum() == -1) {
                    throw EmployeeExceptionMapper.makeAddAmountMMFalseDomainException();
                }
                if (BigDecimalMapper.compareTo((BigDecimal)this.getAddAmountMM(), (BigDecimal)this.getAddAmountYY()) == 1) {
                    throw EmployeeExceptionMapper.makeAddAmountMMGreaterAddAmountYYDomainException();
                }
            }
        }
    }

    public void checkTaxCardPresented() throws BusinessDomainException {
        if (DateHelper.before((Date)this.getValidFrom(), (Date)DateMapper.toDate((String)"2013-01-01")) && this.getTaxCardPresented() && this.getTaxBracket() > 0 && this.getTaxBracket() < 7 && (this.getCommunity() == null || StringMapper.isNullString((String)this.getCommunity().getGeneralCommunityKey()))) {
            throw EmployeeExceptionMapper.makeCommunityMissingDomainException();
        }
    }

    public void checkPension() throws BusinessDomainException {
        if (this.mPensionFreeDues) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPension) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mBonusOfPension)) {
                throw EmployeeExceptionMapper.makePensionMissingDomainException();
            }
            if (this.mStartDateOfPension == null) {
                throw EmployeeExceptionMapper.makeStartdateOfPensionMissingDomainException();
            }
        }
    }

    public void checkPensionPayment() throws BusinessDomainException {
        if (this.mOld == null) {
            return;
        }
        if (!this.mOld.getPensionFreeDues() && this.mPensionFreeDues) {
            throw EmployeeExceptionMapper.makePensionPaymentToEnterDomainException();
        }
    }

    private void checkChangeOfTaxData() throws BusinessDomainException {
        if (this.mOld == null) {
            return;
        }
        int monthOfJournalizedUntil = new VDate(this.mEmployee.getJournalizedUntil()).getMonth();
        int yearOfJournalizedUntil = new VDate(this.mEmployee.getJournalizedUntil()).getYear();
        int yearOfValidFrom = new VDate(this.mValidFrom).getYear();
        if (this.mOld.getTaxBracket() != this.mTaxBracket || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getChildRelief(), (BigDecimal)this.mChildRelief) != 0 || this.mOld.getChurchTaxEE().value() != this.mChurchTaxEE.value() || this.mOld.getChurchTaxSpouse().value() != this.mChurchTaxSpouse.value() || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getFreeAllowanceYY(), (BigDecimal)this.mFreeAllowanceYY) != 0 || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getFreeAllowanceMM(), (BigDecimal)this.mFreeAllowanceMM) != 0 || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getAddAmountYY(), (BigDecimal)this.mAddAmountYY) != 0 || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getAddAmountMM(), (BigDecimal)this.mAddAmountMM) != 0 || this.mOld.getTaxacation().value() != this.mTaxacation.value() || this.mOld.getPayeTaxFindings().value() != this.mPayeTaxFindings.value() || this.mOld.getPayeTax() != this.mPayeTax || this.mOld.getChurchTax() != this.mChurchTax || this.mOld.getSolidarityCharge() != this.mSolidarityCharge || this.mOld.getIncomeTaxReturnYY().value() != this.mIncomeTaxReturnYY.value() || this.mOld.isComputationOfUnderpaymentChurchTax() != this.mComputationOfUnderpaymentChurchTax || this.mOld.isComputationOfUnderpaymentIncomeTax() != this.mComputationOfUnderpaymentIncomeTax || this.mOld.isComputationOfUnderpaymentSolidarityCharge() != this.mComputationOfUnderpaymentSolidarityCharge || this.mOld.getChurchTaxDomicile() != this.mChurchTaxDomicile || this.mChurchTaxDomicile && StringMapper.compareTo((String)this.mOld.getFederalState().getObjectid(), (String)this.mFederalState.getObjectid()) != 0 || this.mOld.getAssociationEE() != this.mAssociationEE || this.mOld.getERpaysContribut() != this.mERpaysContribut || this.mOld.getOldAgeReliefAmount() != this.mOldAgeReliefAmount || this.mOld.getPensionFreeDues() != this.mPensionFreeDues || this.mOld.getWageTaxCertificate() != this.mWageTaxCertificate || this.mOld.getRedOfChurchTax() != this.mRedOfChurchTax || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getMonthlyEarnings(), (BigDecimal)this.mMonthlyEarnings) != 0 || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getPension(), (BigDecimal)this.mPension) != 0 || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getBonusOfPension(), (BigDecimal)this.mBonusOfPension) != 0 || this.mOld.getChurchTaxDeduction() != this.mChurchTaxDeduction || DateHelper.compareDateWithNull((Date)this.mOld.getStartDateOfPension(), (Date)this.mStartDateOfPension) != 0 || this.mOld.getEvaluationTargetOfPayment().value() != this.mEvaluationTargetOfPayment.value() || BigDecimalMapper.compareTo((BigDecimal)this.mOld.getTaxOfSwitzerland(), (BigDecimal)this.mTaxOfSwitzerland) != 0) {
            this.mEmployee.taxChangeNotAllowed(monthOfJournalizedUntil, yearOfValidFrom, yearOfJournalizedUntil, this.mOld, this);
        }
    }

    @Override
    public String getRootDomainKey() {
        return this.getEmployee().getDomainKey();
    }

    @Override
    public String getNaturalLanguageClassName() {
        return "Mitarbeiter - Besteuerung";
    }

    private void checkTaxOfSwitzerland() throws BusinessDomainException {
        if (this.mTaxacation.value() == 11 && BigDecimalMapper.isZero((BigDecimal)this.getTaxOfSwitzerland())) {
            throw EmployeeExceptionMapper.makeTaxOfSwitzerlandMissingDomainException();
        }
    }

    public void checkChurchTax() throws BusinessDomainException {
        this.requireLoaded();
        FederalState fs = EmployeeHelper.getAppurtenantFederalStateForChurchTax((Employee)this.mEmployee, (Date)this.mEffectiveFrom, (Date)this.mValidFrom);
        if (fs == null) {
            return;
        }
        if (!this.getChurchTaxDeduction()) {
            return;
        }
        this.checkChurchTaxExtended(fs.getFederalState(), this.mChurchTaxEE);
        if (this.getChurchTaxSpouse().value() != 0) {
            if (this.getChurchTaxEE().value() == this.getChurchTaxSpouse().value()) {
                throw EmployeeExceptionMapper.makeChurchTaxSpouseAndChurchTaxEEDontCorresponding2DomainException();
            }
            if (this.getChurchTaxEE().value() == 0) {
                throw EmployeeExceptionMapper.makeChurchTaxSpouseAndChurchTaxEEDontCorresponding1DomainException();
            }
        }
        this.checkChurchTaxExtended(fs.getFederalState(), this.mChurchTaxSpouse);
        if (this.getChurchTaxDomicile()) {
            if (this.getFederalState() == null) {
                throw EmployeeExceptionMapper.makeChurchTaxDomicileAndFederalStateDontCorrespondingDomainException();
            }
            switch (fs.getFederalState()) {
                case 3: {
                    break;
                }
                case 5: {
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    throw EmployeeExceptionMapper.makeChurchTaxDomicileAndFederalStatePCompanyDontCorrespondingDomainException();
                }
            }
        }
    }

    private void checkChurchTaxExtended(int federalStateKey, ChurchTaxEnum churchTax) throws BusinessDomainException {
        switch (churchTax.value()) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        block3 : switch (federalStateKey) {
            case 1: {
                switch (churchTax.value()) {
                    case 3: 
                    case 19: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 2: {
                switch (churchTax.value()) {
                    case 3: 
                    case 18: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 3: {
                switch (churchTax.value()) {
                    case 3: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 5: {
                switch (churchTax.value()) {
                    case 3: 
                    case 16: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 6: {
                switch (churchTax.value()) {
                    case 3: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 7: {
                switch (churchTax.value()) {
                    case 3: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 14: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 8: {
                switch (churchTax.value()) {
                    case 3: 
                    case 8: 
                    case 12: 
                    case 15: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 9: {
                switch (churchTax.value()) {
                    case 3: 
                    case 17: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 10: {
                switch (churchTax.value()) {
                    case 3: 
                    case 13: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 11: 
            case 12: {
                switch (churchTax.value()) {
                    case 3: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            case 13: {
                switch (churchTax.value()) {
                    case 3: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 18: {
                        break block3;
                    }
                }
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
            default: {
                throw EmployeeExceptionMapper.makeChurchtaxNotRelevantInFederalstateDomainException();
            }
        }
    }

    private void checkChurchTaxAgainstTaxaction() throws BusinessDomainException {
        switch (this.getTaxacation().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (!this.getChurchTax()) break;
                throw EmployeeExceptionMapper.makeChurchTaxAndTaxacationDontCorrespondingDomainException();
            }
        }
    }

    public void checkForAdvice(ExceptionHolder exceptionHolder) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            this.checkPensionPayment();
        }
        catch (BusinessDomainException e) {
            list.add(e.getMessage());
        }
        if (!list.isEmpty()) {
            exceptionHolder.setException(EmployeeExceptionMapper.makeCheckTaxForAdviceDomainException(list));
        }
    }

    public void checkTin() throws BusinessDomainException {
        int i;
        if (StringMapper.equal((String)this.getEmployee().getPCompany().getObjectid(), (String)"94244845233448982")) {
            return;
        }
        if (StringMapper.isNullString((String)this.mTin)) {
            return;
        }
        char[] chars = this.mTin.toCharArray();
        if (chars.length != 11) {
            throw EmployeeExceptionMapper.makeLengthOfTinInvalidDomainException();
        }
        for (char c : chars) {
            if (Character.isDigit(c)) continue;
            throw EmployeeExceptionMapper.makeNonNumericTinDomainException();
        }
        int[] counter = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (int i2 = 0; i2 < counter.length; ++i2) {
            counter[chars[i2] - 48] = counter[chars[i2] - 48] + 1;
        }
        int existence = 0;
        for (i = 0; i < counter.length; ++i) {
            if (counter[i] > 1) {
                ++existence;
            }
            if (counter[i] <= 3) continue;
            throw EmployeeExceptionMapper.makeTinRepeatErrorDomainException();
        }
        if (existence == 0 || existence > 1) {
            throw EmployeeExceptionMapper.makeTinRepeatErrorDomainException();
        }
        for (i = 0; i < chars.length - 3; ++i) {
            if (chars[i] - 48 != chars[i + 1] - 48 || chars[i] - 48 != chars[i + 2] - 48) continue;
            throw EmployeeExceptionMapper.makeTinRepeatErrorDomainException();
        }
        int n = 11;
        int m = 10;
        int produkt = 10;
        for (int i3 = 0; i3 < 10; ++i3) {
            int ziffer = chars[i3] - 48;
            int summe = (ziffer + produkt) % 10;
            if (summe == 0) {
                summe = 10;
            }
            produkt = 2 * summe % 11;
        }
        int pruefZiffer = 11 - produkt;
        if (pruefZiffer == 10) {
            pruefZiffer = 0;
        }
        if (chars[10] - 48 != pruefZiffer) {
            throw EmployeeExceptionMapper.makeCheckDigitErrorTinDomainException();
        }
    }

    public void specialCheckPAYETaxFindingGuenstigerpruefung() throws BusinessDomainException {
        if (DateHelper.after((Date)this.mValidUntil, (Date)new VDate(2009, 11, 31).getDate()) && this.mPayeTaxFindings == PAYETaxFindingsEnum.PTFE_GUENSTIGERPRUEFUNG_VORSORGEPAUSCHALE) {
            throw EmployeeExceptionMapper.makeGuenstigerpruefungNotAllowedDomainException();
        }
    }

    private void checkPercentageSplit() throws BusinessDomainException {
        if (DateHelper.before((Date)this.mValidFrom, (Date)new VDate(2010, 0, 1).getDate()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageSplit)) {
            throw EmployeeExceptionMapper.makePercentageSplitNotAllowed();
        }
        if (this.mTaxBracket != 4 && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageSplit)) {
            throw EmployeeExceptionMapper.makePercentageSplitNotAllowed();
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageSplit) && BigDecimalMapper.compareTo((BigDecimal)this.mPercentageSplit, (BigDecimal)BigDecimal.valueOf(999L, 3)) > 0) {
            throw EmployeeExceptionMapper.makeValueOfPercentageSplitFalse();
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageSplit) && this.mIncomeTaxReturnYY != IncomeTaxReturnYYEnum.ITRE_KEIN_JAHRESAUSGLEICH) {
            if (this.mSpecialChecks) {
                throw EmployeeExceptionMapper.makePercentagesplitAndIncometaxreturnyyDontCorresponding();
            }
            this.mIncomeTaxReturnYY = IncomeTaxReturnYYEnum.ITRE_KEIN_JAHRESAUSGLEICH;
        }
    }

    private ITaxPersistencyManager getITaxPM() {
        return (ITaxPersistencyManager)UtilitiesManager.getBean((String)"taxPersistencyManager", ITaxPersistencyManager.class);
    }

    public void setSpecialChecks(boolean specialChecks) {
        this.mSpecialChecks = specialChecks;
    }

    public void specialCheckForTaxBraket() throws BusinessDomainException {
        if (!(this.mTaxBracket != 4 || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mPercentageSplit) || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mFreeAllowanceYY) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mFreeAllowanceMM))) {
            throw EmployeeExceptionMapper.makeCombinationTaxbraketAndFreeallowanceNotAllowedDomainException();
        }
    }

    public boolean isLumpSum() {
        List<TaxacationEnum> lumpSumTaxacationEnumList = Arrays.asList(TaxacationEnum.TE_PAUSCHAL_KURZFRISTIGE_BESCHAEFTIGUNG, TaxacationEnum.TE_PAUSCHAL_GERINGFUEGIGE_BESCHAEFTIGUNG, TaxacationEnum.TE_PAUSCHAL_EINHEITLICHE_PAUSCHSTEUER_GFB, TaxacationEnum.TE_PAUSCHAL_AUSHILFSKRAEFTE_LAND_UND_FORSTWIRTSCHAFT);
        return lumpSumTaxacationEnumList.contains(this.getTaxacation());
    }

    public void specialCheckAssociationEE() throws BusinessDomainException {
        if (this.getAssociationEE()) {
            this.mEmployee.specialCheckAssociationEE(this.mEffectiveFrom, this.mValidFrom);
        }
    }

    public void checkNIChildEducationAndChildRelief() throws BusinessDomainException {
        this.mEmployee.checkNIChildEducationAndChildRelief(this, this.getValidFrom());
    }
}

