/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.insurance;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFund;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundFilterStruct;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundTP;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.AssessmentDutyEnum;
import com.varial.personnel.domain.employee.insurance.ContributionScalePHIEnum;
import com.varial.personnel.domain.employee.insurance.ContributionScaleVHIEnum;
import com.varial.personnel.domain.employee.insurance.ContributionScaleVNIEnum;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.ModeOfPensionEnum;
import com.varial.personnel.domain.employee.insurance.MultiplyEmploymentEnum;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.insurance.StatusCodeEnum;
import com.varial.personnel.domain.employee.insurance.mapper.ExclusionFactsEnum;
import com.varial.personnel.domain.employee.insurance.mapper.OrphanBenefitEnum;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.master.NameAffixPersistencyManager;
import com.varial.personnel.domain.employee.master.NamePrefixPersistencyManager;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModel;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.healthfund.mapper.HealthFundExceptionMapper;
import com.varial.personnel.domain.global.occupationlong.OccupationLongTP;
import com.varial.personnel.domain.global.occupationlong.OccupationLongTPPersistencyManager;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.state.State;
import com.varial.personnel.domain.global.state.StateCheckup;
import com.varial.personnel.domain.global.state.StatePersistencyManager;
import com.varial.personnel.domain.global.state.StateTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.settings.PlantSettings;
import com.varial.personnel.domain.zahls.mapper.ZahlsExceptionMapper;
import com.varial.personnel.framework.ICustomerControls;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.checkup.AddressCheckUp;
import com.varial.personnel.framework.checkup.CheckUp;
import com.varial.personnel.framework.checkup.KVNumber;
import com.varial.personnel.framework.checkup.MembershipNumberOfPpRecipient;
import com.varial.personnel.framework.checkup.PersonCheckUp;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceCheckUp {
    private static Logger LOGGER = LoggerFactory.getLogger(InsuranceCheckUp.class);
    private static final Date START_OF_OCCOPATION_LONG = DateMapper.toDate((String)"2011-12-01");
    private static final Date START_OF_DISABILTTY_CERTICATE = DateMapper.toDate((String)"2015-01-01");
    private static final Date START_OF_NEU_MINIJOB = DateMapper.toDate((String)"2013-01-01");
    private static final Date END_OF_MIDIJOB = DateMapper.toDate((String)"2015-01-01");
    private static final Date END_OF_USE_TRANSITION_BY_31122022 = DateMapper.toDate((String)"2023-12-31");
    private final Employee mEmployee;
    private final Insurance mInsurance;
    private final Insurance mOld;
    private Date mPensionableAge;

    public InsuranceCheckUp(Employee employee, Insurance insurance, Insurance insuranceOld) {
        this.mEmployee = employee;
        this.mInsurance = insurance;
        this.mOld = insuranceOld;
    }

    public void checkAttributes() throws BusinessDomainException {
        if (this.mInsurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GFB_WAEHREND_ELTERNZEIT) {
            throw FrameWorkExceptionMapper.makePublicMessageDomainException((String)"Die Auswahl '9-GfB w\u00e4hrend Elternzeit' f\u00fcr besonderes SV-Merkmal ist nicht erlaubt. Die Verwendung dieser Auswahl befindet sich noch in Implementierung.");
        }
        this.isUseTransitionBy31122022();
        this.checkInsuranceNo();
        this.checkNationality();
        this.checkOccupationAndOccupationGroup();
        this.checkPositionOfJob();
        this.checkEducation();
        this.checkHealthFund();
        this.checkAssessmentDutyEnum();
        this.checkNameAtBirth();
        this.checkPlaceOfBirth();
        if (this.mInsurance.getPersonGroup() < 900 || this.mInsurance.getPersonGroup() > 998) {
            this.checkPersonGroup();
        }
        this.extendedCheckPersonGroup();
        this.checkDuesGroup();
        this.checkGroupKeyOfOther();
        this.checkTypeOfPensionAgainstDuesGroup();
        this.checkPersonGroupAgainstTypeOfPension();
        this.checkPersonGroupAgainstDuesGroup();
        this.checkPersonGroupAgainstDateOfBirth();
        this.checkPersonGroupAgainstSpecialCategory();
        this.checkPersonGroupAgainstAssessmentDuty();
        this.checkSpecialCategoryAgainstPersonGroup();
        this.checkNameAffixAtBirth();
        this.checkNamePrefixAtBirth();
        this.checkNoExemptionPF();
        this.checkPrivateHI();
        this.checkVHI();
        this.checkPrivateNI();
        this.checkContScaleVNI();
        this.checkMultiplyEmployment();
        this.checkSIidCard();
        this.checkKVdRHealthFund();
        this.checkKVdR();
        this.checkReferenceNumberHealthFund();
        this.checkDuesHI();
        this.checkDuesNI();
        this.checkEuInsuranceNo();
        this.checkEuStateOfBirth();
        new StateCheckup().checkInvalidStateKey(this.mInsurance.getValidFrom(), this.mInsurance.getValidUntil(), new State[]{this.mInsurance.getEuStateOfBirth(), this.mInsurance.getNationality()});
        this.checkNIChildEducationKVdR();
        this.checkAgePartTime();
        this.checkReplacer();
        this.checkPersonGroupAndDuesGroupPI();
        this.checkAssessmentHealthFundSame();
        this.checkFeaturePlus();
        this.checkSurname();
        this.checkFirstname();
        this.checkStreet();
        this.checkStreetNumber();
        this.checkPostalCode();
        this.checkDomicile();
        this.checkAddressAddendum();
        this.checkSpecialCategoryOfPersons();
        this.checkInsolvencyHealthFund();
        this.checkIsSameInsolvencyHealthFund();
        this.checkDateOfPensionBalance();
        this.checkProcessNo();
        this.checkBaseRatePrivateInsurance();
        this.checkHealthFundForDeuv();
        this.checkRecipientAssignment();
        this.checkPpMembershipNumber();
        this.checkModeOfPensionAndTotalDues();
        this.checkRemittance();
        if (this.mInsurance.getSpecialChecks()) {
            this.checkCompleteOccupationLong(this.mInsurance.getValidFrom());
        }
        this.ckeckReferenceZahls();
        this.checkKvNumberNumber();
        this.checkDecreaseOfDuesInReducedHours();
        if (!this.mInsurance.getSpecialChecks()) {
            this.checkAnnaulEarningsGLZ();
        }
        this.checkDuesGroupPIAndGLZ();
        this.checkERAllowance();
        this.checkDuesGroupHIAndERAllowanceVHI();
        this.checkPersonGroupAgainstAssessment();
        this.checkLegalHealthFund();
        this.checkRetirementPension();
        this.checkUseTransitionBy31122022();
        this.checkExclusionFacts();
        this.checkOrphanBenefit();
        if (this.mInsurance.getSpecialChecks()) {
            this.checkCreateOfTaskReminderIsNecessary();
        }
    }

    private void checkPersonGroupAndDuesGroupPI() throws BusinessDomainException {
        if (this.mOld == null) {
            return;
        }
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_NEU_MINIJOB)) {
            return;
        }
        if (this.isActuallyPgs109() && this.mOld.getDuesGroupHI() == 6 && this.mOld.getDuesGroupPI() == 1 && this.mOld.getDuesGroupUI() == 0 && this.mOld.getDuesGroupNI() == 0 && this.mInsurance.getDuesGroupPI() == 5) {
            Date maxDateOfEntry;
            Date minDateOfEntry;
            Insurance[] is = this.getIInsurancePM().query(new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)"2099-12-31"), Restrictions.eq((String)"noexemptionpf", (String)"T")}), true);
            if (is.length > 0 && DateHelper.beforeOrEqual((Date)this.mInsurance.getValidFrom(), (Date)is[0].getValidFrom())) {
                return;
            }
            if (this.mInsurance.getTypeOfPension() != 4 && !DateHelper.equal((Date)(minDateOfEntry = this.mEmployee.getMinimumDateOfEntry()), (Date)(maxDateOfEntry = this.mEmployee.getMaximumDateOfEntry())) && !DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)maxDateOfEntry), (Date)DateHelper.getFirstDayOfMonth((Date)this.mInsurance.getValidFrom()))) {
                throw EmployeeExceptionMapper.makeResetDuesGroupPIFrom1To5NotAllowedDomainException();
            }
        }
    }

    private void checkSurname() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mInsurance.getSurname())) {
            throw EmployeeExceptionMapper.makeSurnameMissingDomainException();
        }
        if (StringMapper.equal((String)this.mInsurance.getSurname(), (String)"+")) {
            return;
        }
        PersonCheckUp.checkName((String)this.mInsurance.getSurname());
    }

    private void checkFirstname() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mInsurance.getFirstname())) {
            throw EmployeeExceptionMapper.makeFirstnameMissingDomainException();
        }
        if (StringMapper.equal((String)this.mInsurance.getSurname(), (String)"+")) {
            return;
        }
        PersonCheckUp.checkFirstname((String)this.mInsurance.getFirstname());
        PersonCheckUp.checkPlusInFirstnameAndName((String)this.mInsurance.getFirstname(), (String)this.mInsurance.getSurname());
    }

    private void checkPostalCode() throws BusinessDomainException {
        this.checkPostalCode(this.mEmployee.getMaster(VDate.getDateMax(), this.mInsurance.getValidFrom()).getState());
    }

    private void checkPostalCode(State state) throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mInsurance.getPostalCode())) {
            if (state == null || StringMapper.equal((String)state.getState(), (String)"000")) {
                throw EmployeeExceptionMapper.makePostalCodeRequiredDomainException();
            }
        } else {
            this.mInsurance.setPostalCode(this.mInsurance.getPostalCode().trim());
        }
        AddressCheckUp.checkPostalCode((String)this.mInsurance.getPostalCode().trim(), (State)state);
    }

    private void checkDomicile() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mInsurance.getDomicile())) {
            throw EmployeeExceptionMapper.makeDomicileMissingDomainException();
        }
        State state = this.mEmployee.getMaster(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getState();
        if (state == null) {
            state = StatePersistencyManager.getStateByKey((String)"000");
        }
        AddressCheckUp.checkDomicile((String)this.mInsurance.getDomicile(), (State)state);
    }

    private void checkStreet() throws BusinessDomainException {
        AddressCheckUp.checkStreet((String)this.mInsurance.getStreet());
    }

    private void checkStreetNumber() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mInsurance.getStreetNumber())) {
            return;
        }
        AddressCheckUp.checkStreetNumber((String)this.mInsurance.getStreetNumber());
    }

    private void checkAddressAddendum() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mInsurance.getAddressaddendum())) {
            return;
        }
        AddressCheckUp.checkAddressAddendum((String)this.mInsurance.getAddressaddendum());
    }

    private void checkInsuranceNo() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mInsurance.getInsuranceNo())) {
            CheckUp.socialInsuranceNumberCheckup((Insurance)this.mInsurance);
        }
    }

    private void checkNationality() throws BusinessDomainException {
        if (this.mInsurance.getNationality() == null) {
            throw EmployeeExceptionMapper.makeNationalityMissingDomainException();
        }
    }

    private void checkPositionOfJob() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_OCCOPATION_LONG)) {
            return;
        }
        if (this.mInsurance.getPositionOfJob() < 0 || this.mInsurance.getPositionOfJob() > 9) {
            throw EmployeeExceptionMapper.makePositionOfJobFalseDomainException();
        }
        if ((this.mInsurance.getPersonGroup() == 102 || this.mInsurance.getPersonGroup() == 105) && this.mInsurance.getPositionOfJob() != 0) {
            throw EmployeeExceptionMapper.makePositionOfJobAndPersongroupDontCorrespondingDomainException();
        }
        if (!(this.mInsurance.getPositionOfJob() != 0 || this.mInsurance.getPersonGroup() == 102 || this.mInsurance.getPersonGroup() == 105 || this.mInsurance.getPersonGroup() >= 900 || this.mInsurance.getPersonGroup() == 190 && DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)new VDate(2010, 0, 1).getDate()))) {
            throw EmployeeExceptionMapper.makePositionOfJobAndPersongroupDontCorrespondingDomainException();
        }
        if (this.mInsurance.getPersonGroup() == 103 && this.mInsurance.getPositionOfJob() != 8 && this.mInsurance.getPositionOfJob() != 9) {
            throw EmployeeExceptionMapper.makePositionOfJobBY103FalseDomainException();
        }
    }

    private void checkEducation() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_OCCOPATION_LONG)) {
            return;
        }
        if (this.mInsurance.getEducation() < 1 || this.mInsurance.getEducation() > 7) {
            throw EmployeeExceptionMapper.makeEducationFalseDomainException();
        }
    }

    private void checkOccupationAndOccupationGroup() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_OCCOPATION_LONG)) {
            return;
        }
        if (this.mInsurance.getOccupation() == null) {
            throw EmployeeExceptionMapper.makeOccupationMissingDomainException();
        }
        if (this.mInsurance.getOccupationGroup() == null || this.mInsurance.getOccupation().getAKey().substring(0, 3).compareTo(this.mInsurance.getOccupationGroup().getAKey()) != 0) {
            throw EmployeeExceptionMapper.makeOccupationAndOccupationGroupDontCorrespondingDomainException();
        }
    }

    private void checkHealthFund() throws BusinessDomainException {
        if (this.mInsurance.getHealthFund() == null) {
            if (this.mInsurance.getDuesGroupHI() != 0 || this.mInsurance.getDuesGroupNI() != 0 || this.mInsurance.getDuesGroupPI() != 0 || this.mInsurance.getDuesGroupUI() != 0) {
                if (this.mInsurance.getDuesGroupHI() > 0) {
                    throw EmployeeExceptionMapper.makeHealthFundMissingDomainException("Krankenkasse");
                }
                if (this.mInsurance.getDuesGroupPI() > 0) {
                    throw EmployeeExceptionMapper.makeHealthFundMissingDomainException("Einzugsstelle RV");
                }
                if (this.mInsurance.getDuesGroupUI() > 0) {
                    throw EmployeeExceptionMapper.makeHealthFundMissingDomainException("Einzugsstelle AV");
                }
                if (this.mInsurance.getDuesGroupNI() > 0) {
                    throw EmployeeExceptionMapper.makeHealthFundMissingDomainException("Pflegekasse");
                }
            }
        } else {
            if (((ICustomerControls)UtilitiesManager.getBean((String)"customerControls", ICustomerControls.class)).healthFundAssignmentToPlantIsNecessary()) {
                if (!CheckUp.checkHealthFundAssignmentToPlant((Employee)this.mEmployee, (HealthFund)this.mInsurance.getHealthFund(), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) {
                    throw EmployeeExceptionMapper.makeHealthFundIsNotAssignedToPlantDomainException();
                }
            } else if (!CheckUp.checkHealthFundAssignment((Employee)this.mEmployee, (HealthFund)this.mInsurance.getHealthFund(), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) {
                throw EmployeeExceptionMapper.makeHealthFundIsNotAssignedDomainException();
            }
            this.mInsurance.getHealthFund().getHealthFundTP(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
            if (this.mInsurance.getSpecialChecks()) {
                this.checkHealthFundMerger("Die ausgew\u00e4hlte Krankenkasse", this.mInsurance.getHealthFund(), this.mInsurance.getValidFrom());
            }
        }
    }

    private void checkAssessmentHealthFundSame() throws BusinessDomainException {
        if (this.isValidUntilBefore("2006-01-01")) {
            return;
        }
        boolean isHealthFundBkn = this.isGfbHealthFund(this.mInsurance.getHealthFund());
        if ((this.isGfbPgs109() || this.mInsurance.getPersonGroup() == 110) && !isHealthFundBkn) {
            throw EmployeeExceptionMapper.makeAssessmentAndHealthFundMustBknDomainException();
        }
        if (this.isGfbMixedCase() && isHealthFundBkn) {
            throw EmployeeExceptionMapper.makeMixedCaseGfBAssessmentHealthFundDomainException();
        }
        if (!this.isAssessmentDuty()) {
            return;
        }
        HealthFundTP atp = this.mInsurance.getAssessmentHealthFund().getHealthFundTP(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
        if (atp.getTypeOfHealthFundEnum() == TypeOfHealthFundEnum.TOHF_LKK) {
            throw EmployeeExceptionMapper.makeLkkAssessmentInvalidDomainException();
        }
        if (!(this.mInsurance.getPersonGroup() != 109 && this.mInsurance.getPersonGroup() != 110 || this.isGfbHealthFund(this.mInsurance.getAssessmentHealthFund()))) {
            throw EmployeeExceptionMapper.makeAssessmentAndHealthFundMustBknDomainException();
        }
        if (StringMapper.equal((String)this.getStandardCompanyNumber(this.mInsurance.getHealthFund()), (String)this.getStandardCompanyNumber(this.mInsurance.getAssessmentHealthFund()))) {
            return;
        }
        if (this.mInsurance.isHealthFundLKK()) {
            return;
        }
        if (!this.isTransitionAreaBy31122023()) {
            throw EmployeeExceptionMapper.makeAssessmentHealthFundMustSameDomainException();
        }
    }

    private boolean isGfbHealthFund(HealthFund healthFund) throws BusinessDomainException {
        return "98000006".equals(this.getStandardCompanyNumber(healthFund)) || "99300933".equals(this.getStandardCompanyNumber(healthFund));
    }

    private String getStandardCompanyNumber(HealthFund healthFund) throws BusinessDomainException {
        if (healthFund == null) {
            return null;
        }
        return healthFund.getHealthFundTP(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getStandardCompanyNumber();
    }

    private boolean isGfbMixedCase() {
        if (this.mInsurance.getPersonGroup() != 101 && this.mInsurance.getPersonGroup() != 106) {
            return false;
        }
        if (this.mInsurance.getDuesGroupHI() != 6) {
            return false;
        }
        return this.mInsurance.getDuesGroupPI() != 0 || this.mInsurance.getDuesGroupNI() != 0 || this.mInsurance.getDuesGroupUI() != 0;
    }

    private boolean isAssessmentDuty() {
        return this.mInsurance.getAssessmentDuty() != null && this.mInsurance.getAssessmentHealthFund() != null && this.mInsurance.getHealthFund() != null && this.mInsurance.getAssessmentDuty() != AssessmentDutyEnum.ADE_KEINE;
    }

    private void checkKVdRHealthFund() throws BusinessDomainException {
        if (this.mInsurance.getHealthFundKVdR() == null) {
            if (!(this.mInsurance.getNoRegistrationKVDR() || this.mInsurance.getBeginKVDR() == null && this.mInsurance.getBeginCapitalPayment() == null)) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Krankenkasse KVdR");
            }
            return;
        }
        if (this.mInsurance.getDuesGroupHI() != 0 || this.mInsurance.getDuesGroupNI() != 0 || this.mInsurance.getDuesGroupPI() != 0 || this.mInsurance.getDuesGroupUI() != 0) {
            FrameWorkExceptionMapper.makeInputNotAllowedDomainException((String)"KVdR-Krankenkasse");
        }
        this.mInsurance.getHealthFundKVdR().getHealthFundTP(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
        if (!CheckUp.checkHealthFundAssignment((Employee)this.mEmployee, (HealthFund)this.mInsurance.getHealthFundKVdR(), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) {
            throw EmployeeExceptionMapper.makeKVdRHealthFundIsNotAssignedDomainException();
        }
        if (this.mInsurance.getSpecialChecks()) {
            this.checkHealthFundMerger("Die ausgew\u00e4hlte KVdR-Krankenkasse", this.mInsurance.getHealthFundKVdR(), this.mInsurance.getValidFrom());
        }
        if (this.mInsurance.getAssessmentHealthFund() != null) {
            throw EmployeeExceptionMapper.makeAssessmentIsNotAllowedDomainException();
        }
        if (this.mInsurance.getInsolvencyHealthFund() != null) {
            throw EmployeeExceptionMapper.makeAssessmentIsNotAllowedDomainException();
        }
        if (this.mInsurance.getHealthFund() != null) {
            throw EmployeeExceptionMapper.makeAssignementHealtfundNotAllowedDomainException();
        }
        if (!this.mInsurance.getNoRegistrationKVDR()) {
            if (this.mInsurance.getBeginKVDR() == null && this.mInsurance.getBeginCapitalPayment() == null) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Reiter: 'KV der Rentner' Beginndatum Versorgungsbezug oder Begindatum Kapitalleistung");
            }
            if (this.mInsurance.getBeginCapitalPayment() != null && PBigDecimalMapper.isZero((BigDecimal)this.mInsurance.getCapitalPayment())) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Reiter: 'KV der Rentner', 'Kapitalleistung' (Betrag) Kapitalleistung (in Euro)");
            }
        }
    }

    private void checkAssessmentDutyEnum() throws BusinessDomainException {
        if (this.isValidUntilBefore("2006-01-01")) {
            return;
        }
        if (this.mInsurance.getAssessmentDuty() != AssessmentDutyEnum.ADE_KEINE && this.mInsurance.getAssessmentHealthFund() == null) {
            throw EmployeeExceptionMapper.makeAssessmentHealthFundMissingDomainException();
        }
        if (this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_U1) {
            throw EmployeeExceptionMapper.makeAssessment1IsInvalidDomainException();
        }
        if (this.mInsurance.getMangingDirector() && this.mInsurance.getStatusCode() != StatusCodeEnum.SCE_GESCHAEFTSFUEHRENDER_GMBH_GESELLSCHAFTER && !this.mInsurance.missBgs() && this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_U1_und_U2) {
            throw EmployeeExceptionMapper.makeAssessmentU1andU2NotAllowedDomainException();
        }
    }

    private void checkNameAtBirth() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mInsurance.getNameAtBirth())) {
            PersonCheckUp.checkName((String)this.mInsurance.getNameAtBirth());
        }
    }

    private void checkPlaceOfBirth() throws BusinessDomainException {
        if (!this.mInsurance.getSpecialChecks()) {
            return;
        }
        if (this.mInsurance.isDEUVAdviceable() || this.mInsurance.getHealthFundKVdR() != null) {
            if ((StringMapper.isNullString((String)this.mInsurance.getPlaceOfBirth()) || this.mInsurance.getEuStateOfBirth() == null) && StringMapper.isNullString((String)this.mInsurance.getInsuranceNo())) {
                throw EmployeeExceptionMapper.makePlaceOfBirthMissingDomainException();
            }
            PersonCheckUp.checkPlaceOfBirth((String)this.mInsurance.getPlaceOfBirth());
        }
    }

    private void checkPersonGroup() throws BusinessDomainException {
        CheckUp.checkPersonGroup((int)this.mInsurance.getPersonGroup(), (Date)this.mInsurance.getValidFrom());
        switch (this.mInsurance.getPersonGroup()) {
            case 109: {
                if (!this.isActuallyPgs109()) {
                    return;
                }
                if (AssignmentPCompanyHealthFund.existsHFminersGuild((PCompany)this.mEmployee.getPCompany(), (Plant)this.mEmployee.getAppurtenantPlant(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) break;
                throw EmployeeExceptionMapper.makeMinersGuildMissingDomainException();
            }
            case 110: {
                if (AssignmentPCompanyHealthFund.existsHFminersGuild((PCompany)this.mEmployee.getPCompany(), (Plant)this.mEmployee.getAppurtenantPlant(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) break;
                throw EmployeeExceptionMapper.makeMinersGuildMissingDomainException();
            }
        }
    }

    private void extendedCheckPersonGroup() throws BusinessDomainException {
        if (this.mInsurance.getPersonGroup() > 127 && this.mInsurance.getPersonGroup() != 190 && (this.mInsurance.getDuesGroupHI() != 0 || this.mInsurance.getDuesGroupNI() != 0 || this.mInsurance.getDuesGroupPI() != 0 || this.mInsurance.getDuesGroupUI() != 0)) {
            throw EmployeeExceptionMapper.makePersongroupNotAllowedBGS0000DomainException();
        }
        String companynumber = this.getEECompanyPlant().getCompanyNumber();
        if (companynumber.startsWith("985") || companynumber.startsWith("987")) {
            if (this.mInsurance.getPersonGroup() != 102 && this.mInsurance.getPersonGroup() != 103 && this.mInsurance.getPersonGroup() != 107 && this.mInsurance.getPersonGroup() != 111 && this.mInsurance.getPersonGroup() != 121 && this.mInsurance.getPersonGroup() != 122 && this.mInsurance.getPersonGroup() <= 899) {
                throw EmployeeExceptionMapper.makePersongroupFalseForDisabilityDomainException();
            }
        } else if (this.mInsurance.getPersonGroup() == 107 || this.mInsurance.getPersonGroup() == 111) {
            throw EmployeeExceptionMapper.makePersongroupOnlyForDisabilityDomainException();
        }
        if (DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)START_OF_DISABILTTY_CERTICATE) && (this.mInsurance.getPersonGroup() == 107 || this.mInsurance.getPersonGroup() == 111 || this.mInsurance.getPersonGroup() == 127)) {
            throw EmployeeExceptionMapper.makePersongroupNotValidBefore2015DomainException();
        }
        if (this.mInsurance.getPersonGroup() == 120 && DateHelper.before((Date)this.mEmployee.getJournalizedUntil(), (Date)new VDate(2017, 5, 30).getDate())) {
            throw EmployeeExceptionMapper.makePersongroup120NotValidBeforeJul2017DomainException();
        }
        Date dateMarginal = new VDate(2017, 6, 1).getDate();
        if (!this.mInsurance.getSpecialChecks()) {
            if (this.mEmployee.isLastDateOfWithdrawalJournalized()) {
                return;
            }
            if (DateHelper.between((Date)dateMarginal, (Date)this.mInsurance.getValidFrom(), (Date)this.mInsurance.getValidUntil()) || DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateMarginal)) {
                this.additionalcheckAllDuesGroups();
            }
        } else if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateMarginal)) {
            this.additionalcheckAllDuesGroups();
        }
        if (!(this.mInsurance.getPersonGroup() != 112 && this.mInsurance.getPersonGroup() != 114 || this.mInsurance.isHealthFundLKK())) {
            throw EmployeeExceptionMapper.makePgsOnlyByLkkAllowedDomainException();
        }
        if (!(this.mInsurance.getPersonGroup() != 113 || !this.mInsurance.isHealthFundLKK() || this.mInsurance.getDuesGroupHI() != 0 || this.mInsurance.getDuesGroupNI() != 0 || BigDecimalMapper.isZeroOrNull((BigDecimal)this.mInsurance.getERallowanceHIFarm()) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mInsurance.getERallowanceNIFarm()))) {
            throw EmployeeExceptionMapper.makeNoAllowanceFarmDomainException();
        }
    }

    private IEECompanyPlant getEECompanyPlant() {
        IEECompanyPlant eeCompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        eeCompanyPlant.setEmployee(this.mEmployee);
        eeCompanyPlant.setEffectiveFrom(this.mInsurance.getEffectiveFrom());
        eeCompanyPlant.setValidFrom(this.mInsurance.getValidFrom());
        return eeCompanyPlant;
    }

    private void checkDuesGroup() throws BusinessDomainException {
        CheckUp.checkDuesGroup((Date)this.mInsurance.getValidFrom(), (Date)this.mInsurance.getValidUntil(), (int)this.mInsurance.getDuesGroupHI(), (int)this.mInsurance.getDuesGroupPI(), (int)this.mInsurance.getDuesGroupUI(), (int)this.mInsurance.getDuesGroupNI());
        if (!(this.mInsurance.getDuesGroupHI() != 4 && this.mInsurance.getDuesGroupHI() != 5 || this.mInsurance.isHealthFundLKK())) {
            throw EmployeeExceptionMapper.makeDuesGroupLkkDomainException();
        }
        Date dateMarginal = new VDate(2017, 0, 1).getDate();
        Date followingDateMarginal = new VDate(2022, 0, 1).getDate();
        Date timePoint = this.mInsurance.getValidFrom();
        if (!this.mInsurance.getSpecialChecks()) {
            if (this.mEmployee.isLastDateOfWithdrawalJournalized()) {
                return;
            }
            if (DateHelper.between((Date)followingDateMarginal, (Date)this.mInsurance.getValidFrom(), (Date)this.mInsurance.getValidUntil()) || DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)followingDateMarginal)) {
                timePoint = DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil());
            } else if (DateHelper.between((Date)dateMarginal, (Date)this.mInsurance.getValidFrom(), (Date)this.mInsurance.getValidUntil()) || DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateMarginal)) {
                timePoint = DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil());
                this.additionalcheckDuesGroupUI(timePoint);
            }
        } else if (!DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)followingDateMarginal) && DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateMarginal)) {
            this.additionalcheckDuesGroupUI(timePoint);
        }
        if (this.mInsurance.getDuesGroupUI() == 2) {
            Date dateOfBirth = this.mEmployee.getMaster(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getDateOfBirth();
            if (this.mInsurance.getFreeingOfERDuesUI()) {
                if (this.mEmployee.getIsFirstEntry() && this.mInsurance.isNew()) {
                    Date dateYearsLater = new VDate(dateOfBirth).addYears(55).getDate();
                    if (DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)dateYearsLater)) {
                        throw EmployeeExceptionMapper.makeDuesGroupUITwoFalseERpaysUIDomainException();
                    }
                    dateYearsLater = new VDate(dateOfBirth).addYears(65).getDate();
                    if (!this.mInsurance.getStartOfPensionWith65()) {
                        dateYearsLater = InsuranceCheckUp.calculatePensionableAge(dateOfBirth);
                    }
                    if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateYearsLater)) {
                        throw EmployeeExceptionMapper.makeDuesGroupUITwoFalseERpaysUIDomainException();
                    }
                }
            } else {
                Date rentenEintritt = this.calculatePensionableAge();
                if (DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)rentenEintritt)) {
                    throw EmployeeExceptionMapper.makeDuesGroupUITwoFalseDomainException();
                }
            }
        } else if (this.mInsurance.getFreeingOfERDuesUI()) {
            throw EmployeeExceptionMapper.makeFreeingOfERDuesUIFalseDomainException();
        }
    }

    private Date calculatePensionableAge() throws BusinessDomainException {
        if (this.mPensionableAge == null) {
            Date dateOfBirth = this.mEmployee.getMaster(VDate.getDateMax(), VDate.getDateMax()).getDateOfBirth();
            this.mPensionableAge = new VDate(dateOfBirth).addYears(65).getDate();
            if (!this.mInsurance.getStartOfPensionWith65()) {
                this.mPensionableAge = InsuranceCheckUp.calculatePensionableAge(dateOfBirth);
            }
        }
        return this.mPensionableAge;
    }

    public static Date calculatePensionableAge(Date dateOfBirth) throws BusinessDomainException {
        Date pensionableAge = new VDate(dateOfBirth).addYears(65).getDate();
        int geburtsjahr = new VDate(dateOfBirth).getYear();
        if (geburtsjahr > 1963) {
            pensionableAge = new VDate(pensionableAge).addMonths(24).getDate();
        } else if (geburtsjahr > 1958) {
            pensionableAge = new VDate(pensionableAge).addMonths(12 + (geburtsjahr - 1958) * 2).getDate();
        } else if (geburtsjahr > 1946) {
            pensionableAge = new VDate(pensionableAge).addMonths(geburtsjahr - 1946).getDate();
        }
        return pensionableAge;
    }

    private void additionalcheckDuesGroupUI(Date timePoint) throws BusinessDomainException {
        if (this.mInsurance.getPersonGroup() >= 981 && this.mInsurance.getPersonGroup() <= 999) {
            return;
        }
        Date dateYearsLater = this.calculatePensionableAge();
        if (DateHelper.afterOrEqual((Date)timePoint, (Date)dateYearsLater) && this.mInsurance.getDuesGroupUI() != 0) {
            throw EmployeeExceptionMapper.makeDuesGroupUIZeroFalseDomainException(DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.calculatePensionableAge())));
        }
    }

    private void additionalcheckAllDuesGroups() throws BusinessDomainException {
        if (this.mInsurance.getTypeOfPension() == 4 && this.mInsurance.getPersonGroup() == 101 && this.mInsurance.getDuesGroupHI() == 3 && this.mInsurance.getDuesGroupPI() == 1 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 1) {
            throw EmployeeExceptionMapper.makeUsePersongroup120DomainException();
        }
    }

    private void checkTypeOfPensionAgainstDuesGroup() throws BusinessDomainException {
        switch (this.mInsurance.getTypeOfPension()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.checkValidHiTOP2();
                this.checkValidPiTOP2();
                this.checkValidUiTOP2();
                this.checkValidNiTOP2();
                break;
            }
            case 3: {
                this.checkValidHiTOP3();
                this.checkValidPiROP3();
                this.checkValidUiTOP3();
                this.checkValidNiTOP3();
                break;
            }
            case 4: {
                this.checkValidHiTOP4();
                this.checkValidPiTOP4();
                this.checkValidUiTOP4();
                this.checkValidNiTOP4();
                break;
            }
            case 5: {
                this.checkValidHiTOP5();
                this.checkValidPiTOP5();
                this.checkValidUiTOP5();
                this.checkValidNiTOP5();
                break;
            }
            case 6: 
            case 7: {
                this.checkValidHiTOP6und7();
                this.checkValidPiTOP6und7();
                this.checkValidUiTOP6und7();
                this.checkValidNiTOP6und7();
                break;
            }
            case 8: 
            case 9: {
                this.checkValidHiTOP8und9();
                this.checkValidPiTOP8und9();
                this.checkValidUiTOP8und9();
                this.checkValidNiTOP8und9();
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionFalseDomainException();
            }
        }
    }

    private void checkValidHiTOP2() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionTwoFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidHiTOP3() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionThreeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidHiTOP4() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionForeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidHiTOP5() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionFifeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidHiTOP6und7() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionSixOrSevenFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidHiTOP8und9() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionEightOrNineFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidPiTOP2() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionTwoFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidPiROP3() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionThreeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidPiTOP4() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.mInsurance.getPersonGroup() == 120) break;
                throw EmployeeExceptionMapper.makeTypeOfPensionForeFalseDuesGroupDomainException();
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionForeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidPiTOP5() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionFifeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidPiTOP6und7() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionSixOrSevenFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidPiTOP8und9() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionEightOrNineFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidUiTOP2() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionTwoFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidUiTOP3() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionThreeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidUiTOP4() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionForeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidUiTOP5() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionFifeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidUiTOP6und7() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionSixOrSevenFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidUiTOP8und9() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionEightOrNineFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidNiTOP2() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionTwoFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidNiTOP3() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionThreeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidNiTOP4() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionForeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidNiTOP5() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionFifeFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidNiTOP6und7() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionSixOrSevenFalseDuesGroupDomainException();
            }
        }
    }

    private void checkValidNiTOP8und9() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makeTypeOfPensionEightOrNineFalseDuesGroupDomainException();
            }
        }
    }

    private void checkPersonGroupAgainstTypeOfPension() throws BusinessDomainException {
        if ((this.mInsurance.getTypeOfPension() == 4 || this.mInsurance.getTypeOfPension() == 5) && this.mInsurance.getPersonGroup() == 103) {
            throw EmployeeExceptionMapper.makePersonGroupAndTypeOfPensionDontCorrespondingDomainException();
        }
    }

    private void checkPersonGroupAgainstDuesGroup() throws BusinessDomainException {
        switch (this.mInsurance.getPersonGroup()) {
            case 109: {
                if (!this.isActuallyPgs109()) {
                    return;
                }
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0 && DateHelper.after((Date)this.mInsurance.getValidUntil(), (Date)new VDate("1999-03-31").getDate())) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(109);
                }
                this.checkValidDuesGroupHi109();
                this.checkValidDuesGroupPi109();
                this.checkValidDuesGroupUi109();
                this.checkValidDuesGroupNi109();
                break;
            }
            case 101: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(101);
                }
                this.checkValidDuesGroupHi101();
                this.checkValidDuesGroupPi101();
                this.checkValidDuesGroupUi101();
                this.checkValidDuesGroupNi101();
                break;
            }
            case 102: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(102);
                }
                this.checkValidDuesGroupHi102();
                this.checkValidDuesGroupPi102();
                this.checkValidDuesGroupUi102();
                this.checkValidDuesGroupNi102();
                break;
            }
            case 103: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(103);
                }
                this.checkValidDuesGroupHi103();
                this.checkValidDuesGroupPi103();
                this.checkValidDuesGroupUi103();
                this.checkValidDuesGroupNi103();
                break;
            }
            case 104: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(104);
                }
                this.checkValidDuesGroupHI104();
                this.checkValidDuesGroupPi104();
                this.checkValidDuesGroupUi104();
                this.checkValidDuesGroupNi104();
                break;
            }
            case 105: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(105);
                }
                this.checkValidDuesGroupHi105();
                this.checkValidDuesGroupPi105();
                this.checkValidDuesGroupUi105();
                this.checkValidDuesGroupNi105();
                break;
            }
            case 106: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(106);
                }
                this.checkValidDuesGroupHi106();
                this.checkValidDuesGroupPi106();
                this.checkValidDuesGroupUi106();
                this.checkValidDuesGroupNi106();
                break;
            }
            case 107: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(107);
                }
                this.checkValidDuesGroupHi107();
                this.checkValidDuesGroupPi107();
                this.checkValidDuesGroupUi107();
                this.checkValidDuesGroupNi107();
                break;
            }
            case 108: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(108);
                }
                this.checkValidDuesGroupHi108();
                this.checkValidDuesGroupPi108();
                this.checkValidDuesGroupUi108();
                this.checkValidDuesGroupNi108();
                break;
            }
            case 110: {
                this.checkValidDuesGroupHi110();
                this.checkValidDuesGroupPi110();
                this.checkValidDuesGroupUi110();
                this.checkValidDuesGroupNi110();
                this.checkAgainstContributionScalePHIandNI();
                break;
            }
            case 111: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(111);
                }
                this.checkValidDuesGroupHi111();
                this.checkValidDuesGroupPi111();
                this.checkValidDuesGroupUi111();
                this.checkValidDuesGroupNi111();
                break;
            }
            case 112: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(112);
                }
                this.checkValidDuesGroupHi112();
                this.checkValidDuesGroupPi112();
                this.checkValidDuesGroupUi112();
                this.checkValidDuesGroupNi112();
                break;
            }
            case 113: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(113);
                }
                this.checkValidDuesGroupHi113();
                this.checkValidDuesGroupPi113();
                this.checkValidDuesGroupUi113();
                this.checkValidDuesGroupNi113();
                break;
            }
            case 114: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(114);
                }
                this.checkValidDuesGroupHi114();
                this.checkValidDuesGroupPi114();
                this.checkValidDuesGroupUi114();
                this.checkValidDuesGroupNi114();
                break;
            }
            case 116: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(116);
                }
                this.checkValidDuesGroupHi116();
                this.checkValidDuesGroupPi116();
                this.checkValidDuesGroupUi116();
                this.checkValidDuesGroupNi116();
                break;
            }
            case 118: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(118);
                }
                this.checkValidDuesGroupHi118();
                this.checkValidDuesGroupPi118();
                this.checkValidDuesGroupUi118();
                this.checkValidDuesGroupNi118();
                break;
            }
            case 119: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(119);
                }
                this.checkValidDuesGroupHi119();
                this.checkValifDuesGroupPi119();
                this.checkValidDuesGroupUi119();
                this.checkValidDuesGroupNi119();
                break;
            }
            case 120: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(120);
                }
                this.checkValidDuesGroupHi120();
                this.checkValifDuesGroupPi120();
                this.checkValidDuesGroupUi120();
                this.checkValidDuesGroupNi120();
                break;
            }
            case 121: {
                this.checkDuesGroupNotZero(121);
                this.checkValidDuesGroupForPersonGroup(121, this.mInsurance.getDuesGroupHI(), 0, 1, 3);
                this.checkValidDuesGroupForPersonGroup(121, this.mInsurance.getDuesGroupPI(), 0, 1);
                this.checkValidDuesGroupForPersonGroup(121, this.mInsurance.getDuesGroupUI(), 0, 1);
                this.checkValidDuesGroupForPersonGroup(121, this.mInsurance.getDuesGroupNI(), 0, 1, 2);
                break;
            }
            case 122: {
                this.checkDuesGroupNotZero(122);
                this.checkValidDuesGroupForPersonGroup(122, this.mInsurance.getDuesGroupHI(), 0, 1, 3, 9);
                this.checkValidDuesGroupForPersonGroup(122, this.mInsurance.getDuesGroupPI(), 0, 1);
                this.checkValidDuesGroupForPersonGroup(122, this.mInsurance.getDuesGroupUI(), 0, 1);
                this.checkValidDuesGroupForPersonGroup(122, this.mInsurance.getDuesGroupNI(), 0, 1, 2);
                break;
            }
            case 123: {
                this.checkDuesGroupNotZero(123);
                this.checkValidDuesGroupForPersonGroup(123, this.mInsurance.getDuesGroupHI(), 0, 1, 3, 9);
                this.checkValidDuesGroupForPersonGroup(123, this.mInsurance.getDuesGroupPI(), 0, 1);
                this.checkValidDuesGroupForPersonGroup(123, this.mInsurance.getDuesGroupUI(), 0, 1, 2);
                this.checkValidDuesGroupForPersonGroup(123, this.mInsurance.getDuesGroupNI(), 0, 1, 2);
                break;
            }
            case 124: {
                this.checkDuesGroupNotZero(124);
                this.checkValidDuesGroupForPersonGroup(124, this.mInsurance.getDuesGroupHI(), 0, 1, 3, 9);
                this.checkValidDuesGroupForPersonGroup(124, this.mInsurance.getDuesGroupPI(), 0, 1, 3);
                this.checkValidDuesGroupForPersonGroup(124, this.mInsurance.getDuesGroupUI(), 0, 1, 2);
                this.checkValidDuesGroupForPersonGroup(124, this.mInsurance.getDuesGroupNI(), 0, 1, 2);
                break;
            }
            case 127: {
                if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
                    throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(127);
                }
                this.checkValidDuesGroupHi127();
                this.checkValidDuesGroupPi127();
                this.checkValidDuesGroupUi127();
                this.checkValidDuesGroupNi127();
                break;
            }
            case 190: {
                this.checkValidDuesGroupHi110();
                this.checkValidDuesGroupPi110();
                this.checkValidDuesGroupUi110();
                this.checkValidDuesGroupNi110();
            }
        }
    }

    private void checkDuesGroupNotZero(int personGroup) throws BusinessDomainException {
        if (this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
            throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(personGroup);
        }
    }

    private void checkValidDuesGroupForPersonGroup(int personGroup, int duesGroup, Integer ... validValues) throws BusinessDomainException {
        boolean valid = false;
        for (Integer value : validValues) {
            if (duesGroup != value) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(personGroup);
        }
    }

    private void checkValidDuesGroupNi101() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(101);
            }
        }
    }

    private void checkValidDuesGroupNi102() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(102);
            }
        }
    }

    private void checkValidDuesGroupNi103() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(103);
            }
        }
    }

    private void checkValidDuesGroupNi104() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(104);
            }
        }
    }

    private void checkValidDuesGroupNi105() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(105);
            }
        }
    }

    private void checkValidDuesGroupNi106() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(106);
            }
        }
    }

    private void checkValidDuesGroupNi107() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(107);
            }
        }
    }

    private void checkValidDuesGroupNi108() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(108);
            }
        }
    }

    private void checkValidDuesGroupNi109() throws BusinessDomainException {
        if (!this.isActuallyPgs109()) {
            return;
        }
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(109);
            }
        }
    }

    private void checkValidDuesGroupNi110() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(110);
            }
        }
    }

    private void checkAgainstContributionScalePHIandNI() throws BusinessDomainException {
        if (this.mInsurance.getContributionScalePHI() != ContributionScalePHIEnum.CSPHIE_KEINE || this.mInsurance.getPrivateNI()) {
            throw EmployeeExceptionMapper.makePersongroupAndPrivateSiDontCorrespondigDomainException();
        }
    }

    private void checkValidDuesGroupNi111() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(111);
            }
        }
    }

    private void checkValidDuesGroupNi112() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(112);
            }
        }
    }

    private void checkValidDuesGroupNi113() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(113);
            }
        }
    }

    private void checkValidDuesGroupNi114() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(114);
            }
        }
    }

    private void checkValidDuesGroupNi116() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(116);
            }
        }
    }

    private void checkValidDuesGroupNi118() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(118);
            }
        }
    }

    private void checkValidDuesGroupNi119() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(119);
            }
        }
    }

    private void checkValidDuesGroupNi120() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(120);
            }
        }
    }

    private void checkValidDuesGroupNi127() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupNI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(127);
            }
        }
    }

    private void checkValidDuesGroupUi101() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(101);
            }
        }
    }

    private void checkValidDuesGroupUi102() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(102);
            }
        }
    }

    private void checkValidDuesGroupUi103() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(103);
            }
        }
    }

    private void checkValidDuesGroupUi104() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(104);
            }
        }
    }

    private void checkValidDuesGroupUi105() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(105);
            }
        }
    }

    private void checkValidDuesGroupUi106() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(106);
            }
        }
    }

    private void checkValidDuesGroupUi107() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(107);
            }
        }
    }

    private void checkValidDuesGroupUi108() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(108);
            }
        }
    }

    private void checkValidDuesGroupUi109() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(109);
            }
        }
    }

    private void checkValidDuesGroupUi110() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(110);
            }
        }
    }

    private void checkValidDuesGroupUi111() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(111);
            }
        }
    }

    private void checkValidDuesGroupUi112() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(112);
            }
        }
    }

    private void checkValidDuesGroupUi113() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(113);
            }
        }
    }

    private void checkValidDuesGroupUi114() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(114);
            }
        }
    }

    private void checkValidDuesGroupUi116() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(116);
            }
        }
    }

    private void checkValidDuesGroupUi118() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(118);
            }
        }
    }

    private void checkValidDuesGroupUi119() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(119);
            }
        }
    }

    private void checkValidDuesGroupUi120() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(120);
            }
        }
    }

    private void checkValidDuesGroupUi127() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupUI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(119);
            }
        }
    }

    private void checkValidDuesGroupPi101() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(101);
            }
        }
    }

    private void checkValidDuesGroupPi102() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(102);
            }
        }
    }

    private void checkValidDuesGroupPi103() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(103);
            }
        }
    }

    private void checkValidDuesGroupPi104() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(104);
            }
        }
    }

    private void checkValidDuesGroupPi105() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(105);
            }
        }
    }

    private void checkValidDuesGroupPi106() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(106);
            }
        }
    }

    private void checkValidDuesGroupPi107() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(107);
            }
        }
    }

    private void checkValidDuesGroupPi108() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(108);
            }
        }
    }

    private void checkValidDuesGroupPi109() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(109);
            }
        }
    }

    private void checkValidDuesGroupPi110() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(110);
            }
        }
    }

    private void checkValidDuesGroupPi111() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(111);
            }
        }
    }

    private void checkValidDuesGroupPi112() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(112);
            }
        }
    }

    private void checkValidDuesGroupPi113() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(113);
            }
        }
    }

    private void checkValidDuesGroupPi114() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(114);
            }
        }
    }

    private void checkValidDuesGroupPi116() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(116);
            }
        }
    }

    private void checkValidDuesGroupPi118() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(118);
            }
        }
    }

    private void checkValifDuesGroupPi119() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(119);
            }
        }
    }

    private void checkValifDuesGroupPi120() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 1: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(120);
            }
        }
    }

    private void checkValidDuesGroupPi127() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupPI()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(119);
            }
        }
    }

    private void checkValidDuesGroupHi101() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(101);
            }
        }
    }

    private void checkValidDuesGroupHi102() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(102);
            }
        }
    }

    private void checkValidDuesGroupHi103() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(103);
            }
        }
    }

    private void checkValidDuesGroupHI104() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(104);
            }
        }
    }

    private void checkValidDuesGroupHi105() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(105);
            }
        }
    }

    private void checkValidDuesGroupHi106() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(106);
            }
        }
    }

    private void checkValidDuesGroupHi107() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(107);
            }
        }
    }

    private void checkValidDuesGroupHi108() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(108);
            }
        }
    }

    private void checkValidDuesGroupHi109() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(109);
            }
        }
    }

    private void checkValidDuesGroupHi110() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(110);
            }
        }
    }

    private void checkValidDuesGroupHi111() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(111);
            }
        }
    }

    private void checkValidDuesGroupHi112() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 4: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(112);
            }
        }
    }

    private void checkValidDuesGroupHi113() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(113);
            }
        }
    }

    private void checkValidDuesGroupHi114() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 5: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(114);
            }
        }
    }

    private void checkValidDuesGroupHi116() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(116);
            }
        }
    }

    private void checkValidDuesGroupHi118() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(118);
            }
        }
    }

    private void checkValidDuesGroupHi119() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(119);
            }
        }
    }

    private void checkValidDuesGroupHi120() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(120);
            }
        }
    }

    private void checkValidDuesGroupHi127() throws BusinessDomainException {
        switch (this.mInsurance.getDuesGroupHI()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw EmployeeExceptionMapper.makePersonGroupAndDuesGroupDontCorrespondingDomainException(127);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkPersonGroupAgainstDateOfBirth() throws BusinessDomainException {
        switch (this.mInsurance.getPersonGroup()) {
            case 103: {
                if (this.mEmployee == null) break;
                master = null;
                try {
                    master = this.mEmployee.getMaster(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                }
                catch (ApplicationException e) {
                    throw e;
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) ** GOTO lbl13
                    throw e;
                }
lbl13:
                // 2 sources

                if (master == null || (dateOfBirth = master.getDateOfBirth()) == null) break;
                dateYearsLater = new VDate(dateOfBirth).addYears(55).getDate();
                if (DateHelper.after((Date)this.mInsurance.getValidFrom(), (Date)dateYearsLater)) break;
                throw EmployeeExceptionMapper.makePersonGroupAndDateOfBirthDontCorrespondingDomainException();
            }
        }
    }

    private void checkPersonGroupAgainstAssessmentDuty() throws BusinessDomainException {
        if (this.isValidUntilBefore("2006-01-01")) {
            return;
        }
        if (this.getPlantOrCompanyAssessable()) {
            switch (this.mInsurance.getPersonGroup()) {
                case 102: {
                    this.checkPersonGroupAgainstAssessment();
                    break;
                }
                case 107: 
                case 111: {
                    if (this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_KEINE) break;
                    throw EmployeeExceptionMapper.makePersonGroupAndAssessmentDutyDontCorrespondingDomainException(this.mInsurance.getPersonGroup());
                }
                case 110: {
                    if (this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_U1_und_U2 || this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_U2) break;
                    throw EmployeeExceptionMapper.makePersonGroupAndAssessmentDutyDontCorrespondingDomainException(this.mInsurance.getPersonGroup());
                }
                case 112: {
                    this.checkPersonGroupAgainstAssessment();
                    break;
                }
                case 122: {
                    this.checkPersonGroupAgainstAssessment();
                    break;
                }
                case 123: {
                    if (!DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)DateMapper.toDate((String)"2012-07-01")) || this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_U2) break;
                    throw EmployeeExceptionMapper.makePersonGroupAndAssessmentDutyDontCorrespondingDomainException(this.mInsurance.getPersonGroup());
                }
            }
        }
    }

    private boolean isValidUntilBefore(String dateString) {
        return DateHelper.before((Date)this.mInsurance.getValidUntil(), (Date)DateMapper.toDate((String)dateString));
    }

    private void checkPersonGroupAgainstSpecialCategory() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)new VDate(2012, 0, 1).getDate())) {
            return;
        }
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_OCCOPATION_LONG)) {
            if (this.mInsurance.getPersonGroup() != 102 && this.mInsurance.getPersonGroup() != 105) {
                return;
            }
            if (this.mInsurance.getSpecialCategoryOfPersons() != SpecialCategoryEnum.SCE_GERINGVERDIENER) {
                throw EmployeeExceptionMapper.makeSpecialCategoryAfter20111201DomainException();
            }
        } else {
            if (this.mInsurance.getPositionOfJob() != 0 || this.mInsurance.getPersonGroup() != 102 && this.mInsurance.getPersonGroup() != 105) {
                return;
            }
            if (this.mInsurance.getSpecialCategoryOfPersons() != SpecialCategoryEnum.SCE_GERINGVERDIENER) {
                throw EmployeeExceptionMapper.makePersongroupAgainstSpecialCategoryDomainException();
            }
        }
    }

    private void checkGroupKeyOfOther() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mInsurance.getGroupKeyOfOther())) {
            if (this.mInsurance.getMultiplyEmployment().value() == 0) {
                throw EmployeeExceptionMapper.makeGroupKeyHIOfOtherAndMultiplyEmploymentDontCorrespondingDomainException();
            }
            int groupKeyHIOfOther = 0;
            int groupKeyPIOfOther = 0;
            int groupKeyUIOfOther = 0;
            int groupKeyNIOfOther = 0;
            try {
                groupKeyHIOfOther = Integer.parseInt(this.mInsurance.getGroupKeyOfOther().substring(0, 1));
            }
            catch (NumberFormatException e) {
                throw EmployeeExceptionMapper.makeGroupKeyHIOfOtherFalseDomainException();
            }
            try {
                groupKeyPIOfOther = Integer.parseInt(this.mInsurance.getGroupKeyOfOther().substring(1, 2));
            }
            catch (NumberFormatException e) {
                throw EmployeeExceptionMapper.makeGroupKeyPIOfOtherFalseDomainException();
            }
            try {
                groupKeyUIOfOther = Integer.parseInt(this.mInsurance.getGroupKeyOfOther().substring(2, 3));
            }
            catch (NumberFormatException e) {
                throw EmployeeExceptionMapper.makeGroupKeyUIOfOtherFalseDomainException();
            }
            try {
                groupKeyNIOfOther = Integer.parseInt(this.mInsurance.getGroupKeyOfOther().substring(3));
            }
            catch (NumberFormatException e) {
                throw EmployeeExceptionMapper.makeGroupKeyNIOfOtherFalseDomainException();
            }
            if (groupKeyHIOfOther < 0 || groupKeyHIOfOther > 6 && groupKeyHIOfOther != 9) {
                throw EmployeeExceptionMapper.makeGroupKeyHIOfOtherFalseDomainException();
            }
            if (groupKeyPIOfOther < 0 || groupKeyPIOfOther > 6) {
                throw EmployeeExceptionMapper.makeGroupKeyPIOfOtherFalseDomainException();
            }
            if (groupKeyUIOfOther < 0 || groupKeyUIOfOther > 2) {
                throw EmployeeExceptionMapper.makeGroupKeyUIOfOtherFalseDomainException();
            }
            if (groupKeyNIOfOther < 0 || groupKeyNIOfOther > 2) {
                throw EmployeeExceptionMapper.makeGroupKeyNIOfOtherFalseDomainException();
            }
        }
    }

    private void checkSpecialCategoryAgainstPersonGroup() throws BusinessDomainException {
        block0 : switch (this.mInsurance.getSpecialCategoryOfPersons().value()) {
            case 1: {
                switch (this.mInsurance.getPersonGroup()) {
                    case 102: 
                    case 105: 
                    case 119: {
                        break block0;
                    }
                }
                throw EmployeeExceptionMapper.makeSpecialCategoryAndPersonGroupDontCorrespondingDomainException();
            }
            case 2: {
                switch (this.mInsurance.getPersonGroup()) {
                    case 109: {
                        if (!this.isActuallyPgs109()) {
                            return;
                        }
                    }
                    case 102: 
                    case 105: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 116: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 127: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 202: 
                    case 203: 
                    case 207: 
                    case 208: 
                    case 209: 
                    case 210: {
                        throw EmployeeExceptionMapper.makeSpecialCategoryAndPersonGroupDontCorresponding2DomainException();
                    }
                }
                break;
            }
            case 3: {
                switch (this.mInsurance.getPersonGroup()) {
                    case 109: {
                        if (!this.isActuallyPgs109()) {
                            return;
                        }
                    }
                    case 102: 
                    case 103: 
                    case 105: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 116: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 202: 
                    case 203: 
                    case 207: 
                    case 208: 
                    case 209: 
                    case 210: {
                        throw EmployeeExceptionMapper.makeSpecialCategoryAndPersonGroupDontCorresponding3DomainException();
                    }
                }
                break;
            }
        }
    }

    private void checkNameAffixAtBirth() throws BusinessDomainException {
        NameAffixPersistencyManager.checkNameAffix((String)this.mInsurance.getNameAffixAtBirth());
    }

    private void checkNamePrefixAtBirth() throws BusinessDomainException {
        NamePrefixPersistencyManager.checkNamePrefix((String)this.mInsurance.getNamePrefixAtBirth());
    }

    private void checkNoExemptionPF() throws BusinessDomainException {
        block28: {
            block27: {
                block29: {
                    if (!DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_NEU_MINIJOB)) break block27;
                    if (!this.isActuallyPgs109()) break block28;
                    if (!this.mInsurance.getOfferForExemptionFromPI()) break block29;
                    if (this.mInsurance.getDateOfferForExemptionFromPI() == null) {
                        throw EmployeeExceptionMapper.makeDateNoExemptionPFMissingDomainException();
                    }
                    if (this.mInsurance.getDuesGroupPI() != 5 && this.mInsurance.getDuesGroupPI() != 0) {
                        throw EmployeeExceptionMapper.makeOfferForExcemptionAndDuesGroupPIFalseDomainException();
                    }
                    break block28;
                }
                if (this.mOld == null || this.mOld.getDuesGroupHI() != 6 || this.mOld.getDuesGroupPI() != 1 || this.mOld.getDuesGroupUI() != 0 || this.mOld.getDuesGroupNI() != 0 || this.mInsurance.getDuesGroupPI() != 5) break block28;
                if (this.mInsurance.getDateOfferForExemptionFromPI() != null) {
                    throw EmployeeExceptionMapper.makeNoExemptionPFMissingDomainException();
                }
                switch (this.mInsurance.getDuesGroupPI()) {
                    case 1: {
                        break block28;
                    }
                    case 0: {
                        if (this.mInsurance.getModeOfPension().value() != 0) break block28;
                    }
                    default: {
                        throw EmployeeExceptionMapper.makeNoOfferForExcemptionAndDuesGroupPIFalseDomainException();
                    }
                    {
                        break block28;
                    }
                }
            }
            if (this.mInsurance.getNoExemptionPF()) {
                if (this.mInsurance.getDateNoExemptionPF() == null) {
                    throw EmployeeExceptionMapper.makeDateNoExemptionPFMissingDomainException();
                }
                switch (this.mInsurance.getDuesGroupPI()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 0: {
                        if (this.mInsurance.getModeOfPension().value() != 0) break;
                    }
                    default: {
                        throw EmployeeExceptionMapper.makeNoExemptionPFAndDuesGroupPIDontCorrespondingDomainException();
                    }
                }
                if (!(this.isActuallyPgs109() || this.mInsurance.getSpecialCategoryOfPersons().value() == 2 && this.mInsurance.getSpecialCategoryOfPersons().value() != 3)) {
                    throw EmployeeExceptionMapper.makeNoExemptionPFAndPersonGroupOrSpecialCategoryDontCorrespondingDomainException();
                }
            } else {
                if (this.mInsurance.getDateNoExemptionPF() != null) {
                    throw EmployeeExceptionMapper.makeNoExemptionPFMissingDomainException();
                }
                if (this.isActuallyPgs109()) {
                    switch (this.mInsurance.getDuesGroupPI()) {
                        case 0: {
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            if (DateHelper.before((Date)this.mInsurance.getValidUntil(), (Date)new VDate("1999-04-01").getDate())) {
                                throw EmployeeExceptionMapper.makeNoExemptionPFAndDuesGroupPIfalseDomainException();
                            }
                            if (!DateHelper.after((Date)this.mInsurance.getValidUntil(), (Date)new VDate("2004-12-31").getDate())) break;
                            throw EmployeeExceptionMapper.makeNoExemptionPFAndDuesGroupPIfalseDomainException();
                        }
                        default: {
                            throw EmployeeExceptionMapper.makeNoExemptionPFAndDuesGroupPIfalseDomainException();
                        }
                    }
                }
            }
        }
    }

    private void checkPrivateHI() throws BusinessDomainException {
        if (this.mInsurance.getPrivateHI()) {
            if (this.mInsurance.getDuesGroupHI() != 0) {
                throw EmployeeExceptionMapper.makePrivateHIandDuesGroupHIdontCorrespondingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getTotalRateToPHI())) {
                throw EmployeeExceptionMapper.makePrivateHIandTotalRateToPHIdontCorrespondingDomainException();
            }
        } else if (!BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getTotalRateToPHI()) || this.mInsurance.getERAllowancePHI() != 9) {
            throw EmployeeExceptionMapper.makePrivateHIandOtherDontCorrespondingDomainException();
        }
    }

    private void checkVHI() throws BusinessDomainException {
        if (!this.isValidUntilBefore("2009-01-01") && this.mInsurance.getContScaleVHI().value() == 2) {
            throw EmployeeExceptionMapper.makeContScaleVHIFalse2009DomainException();
        }
        if (this.mInsurance.getContScaleVHI().value() != 0) {
            if (this.mInsurance.getDuesGroupHI() != 0 && this.mInsurance.getDuesGroupHI() != 9) {
                throw EmployeeExceptionMapper.makeContScaleVHIandDuesGroupHIdontCorrespondingDomainException();
            }
            if (this.mInsurance.getPrivateHI()) {
                throw EmployeeExceptionMapper.makeContScaleVHIandPrivateHIdontCorrespondingDomainException();
            }
        }
        if (this.mInsurance.getDuesGroupHI() == 9) {
            if (this.mInsurance.getContScaleVHI() == ContributionScaleVHIEnum.CSE_KEINE) {
                throw EmployeeExceptionMapper.makeVHIRateMissingDomainException();
            }
            if ((this.mInsurance.getPersonGroup() == 119 || this.mInsurance.getPersonGroup() == 120) && this.mInsurance.getContScaleVHI() != ContributionScaleVHIEnum.CSE_ERMAESSIGT) {
                throw EmployeeExceptionMapper.makeForPgsVhiRateFalseDomainException();
            }
        }
    }

    private void checkContScaleVNI() throws BusinessDomainException {
        if (this.mInsurance.getContScaleVNI().value() != 0) {
            if (this.mInsurance.getContScaleVHI().value() == 0) {
                throw EmployeeExceptionMapper.makeContScaleVHIandContScaleVNIdontCorrespondingDomainException();
            }
            if (this.mInsurance.getDuesGroupNI() != 1 && this.mInsurance.getDuesGroupNI() != 2 && (this.mInsurance.getDuesGroupNI() != 0 || this.mInsurance.getSpecialCategoryOfPersons() != SpecialCategoryEnum.SCE_PFLICHTVERSICHERUNG_PAR_5_SGB_V)) {
                throw EmployeeExceptionMapper.makeContScaleVNIandDuesGroupNIdontCorrespondingDomainException();
            }
            if (this.mInsurance.getPrivateNI()) {
                throw EmployeeExceptionMapper.makeContScaleVNIandPrivateNIdontCorrespondingDomainException();
            }
        }
    }

    private void checkPrivateNI() throws BusinessDomainException {
        if (this.mInsurance.getPrivateNI()) {
            if (this.mInsurance.getDuesGroupNI() != 0) {
                throw EmployeeExceptionMapper.makePrivateNIandDuesGroupNIdontCorrespondingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getTotalRateToPNI())) {
                throw EmployeeExceptionMapper.makePrivateNIandTotalRateToPNIdontCorrespondingDomainException();
            }
        } else if (!BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getTotalRateToPNI()) || this.mInsurance.getERAllowancePNI() != 9) {
            throw EmployeeExceptionMapper.makePrivateNIandOtherDontCorrespondingDomainException();
        }
    }

    private void checkSIidCard() throws BusinessDomainException {
        if (this.mInsurance.getSIidCard()) {
            if (this.mInsurance.getRegistrSIidCard() == null) {
                throw EmployeeExceptionMapper.makeRegistrSIidCardMissingDomainException();
            }
        } else if (this.mInsurance.getRegistrSIidCard() != null) {
            throw EmployeeExceptionMapper.makeSIidCardMissingDomainException();
        }
    }

    private void checkMultiplyEmployment() throws BusinessDomainException {
        if (this.mInsurance.getMultiplyEmployment().value() != 0 && this.mInsurance.getDuesGroupHI() == 0 && this.mInsurance.getDuesGroupPI() == 0 && this.mInsurance.getDuesGroupUI() == 0 && this.mInsurance.getDuesGroupNI() == 0) {
            throw EmployeeExceptionMapper.makeMultiplyEmploymentAndDuesGroupKeyDontCorrespondingDomainException();
        }
    }

    private void checkKVdR() throws BusinessDomainException {
        boolean kvdr = false;
        if (this.mEmployee.getEmployment(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getPlant() != null && this.mEmployee.getEmployment(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getPlant() != null) {
            try {
                if (this.mEmployee.getEmployment(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getPlant().getPlantEmploymentOffice(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()) != null) {
                    kvdr = this.mEmployee.getEmployment(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getPlant().getPlantEmploymentOffice(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getGeneralEmploymentOffice().getPaymentPointPensionersHealthInsurance();
                }
            }
            catch (ApplicationException e) {
                throw e;
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                    kvdr = false;
                }
                throw e;
            }
        }
        if (!kvdr) {
            try {
                if (this.mEmployee.getPCompany().getCompanyEmploymentOffice(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()) != null) {
                    kvdr = this.mEmployee.getPCompany().getCompanyEmploymentOffice(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom()).getGeneralEmploymentOffice().getPaymentPointPensionersHealthInsurance();
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                    kvdr = false;
                }
                throw e;
            }
        }
        if (!kvdr) {
            if (this.mInsurance.getHealthFundKVdR() != null) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndHealthFundKVdRDontCorrespondingDomainException();
            }
            if (!StringMapper.isNullString((String)this.mInsurance.getMembershipKVdR())) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndMembershipKVdRDontCorrespondingDomainException();
            }
            if (!BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getLimitOfDues())) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndLimitOfDuesDontCorrespondingDomainException();
            }
            if (!BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getLegalPension())) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndLegalPensionDontCorrespondingDomainException();
            }
            if (this.mInsurance.getChoiseOfDuesHI().value() != 0) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndChoiseOfDuesHIDontCorrespondingDomainException();
            }
            if (!BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getDuesHI())) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndDuesHIDontCorrespondingDomainException();
            }
            if (this.mInsurance.getChoiseOfDuesNI().value() != 0) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndChoiseOfDuesNIDontCorrespondingDomainException();
            }
            if (!BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getDuesNI())) {
                throw EmployeeExceptionMapper.makePayingOfficeKVdRAndDuesNIDontCorrespondingDomainException();
            }
        }
        if (this.mInsurance.getEndKVDR() != null && this.mOld != null && !DateHelper.equal((Date)this.mOld.getEndKVDR(), (Date)this.mInsurance.getEndKVDR()) && DateHelper.after((Date)this.mInsurance.getValidFrom(), (Date)this.mInsurance.getEndKVDR())) {
            throw EmployeeExceptionMapper.makeValidFromIsAfterEndKVDRDomainException();
        }
    }

    private void checkDuesHI() throws BusinessDomainException {
        Date dateMarginal = new VDate(2011, 0, 1).getDate();
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateMarginal) && this.mInsurance.getChoiseOfDuesHI().value() == 3) {
            throw EmployeeExceptionMapper.makeIndividualAmountNotAllowedException();
        }
        if (BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getDuesHI()) && this.mInsurance.getChoiseOfDuesHI().value() == 3) {
            throw EmployeeExceptionMapper.makeDuesHIAndChoiseOfDuesHIDontCorrespondingDomainException();
        }
    }

    private void checkDuesNI() throws BusinessDomainException {
        Date dateMarginal = new VDate(2011, 0, 1).getDate();
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateMarginal) && this.mInsurance.getChoiseOfDuesNI().value() == 5) {
            throw EmployeeExceptionMapper.makeIndividualAmountNotAllowedException();
        }
        if (BigDecimalMapper.isZero((BigDecimal)this.mInsurance.getDuesNI()) && this.mInsurance.getChoiseOfDuesNI().value() == 5) {
            throw EmployeeExceptionMapper.makeDuesNIAndChoiseOfDuesNIDontCorrespondingDomainException();
        }
    }

    private void checkNIChildEducationKVdR() throws BusinessDomainException {
        if (!this.mInsurance.getNIChildOfEducKVdR() && this.mInsurance.getDateOfReceiptKVdR() != null) {
            throw EmployeeExceptionMapper.makeDateOfReceiptKVdRFalseDomainException();
        }
    }

    private void checkAgePartTime() throws BusinessDomainException {
        if (this.mInsurance.getPersonGroup() == 103 && this.mInsurance.getBeginAgePartTime() == null) {
            throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Beginn der Altersteilzeit");
        }
        if (this.mInsurance.getBeginAgePartTime() != null && this.mInsurance.getEndAgePartTime() == null || this.mInsurance.getBeginAgePartTime() == null && this.mInsurance.getEndAgePartTime() != null) {
            throw EmployeeExceptionMapper.makeBeginAndEndOfAgePartTimeDontCorrespondingDomainException();
        }
        if (this.mInsurance.getUseAgePartTime() && this.mInsurance.getAgePartTimeModel() == null && this.existsAgePartTimeModel() == null) {
            throw EmployeeExceptionMapper.makeAgePartTimeIsMissingDomainException();
        }
        if (this.mInsurance.getTypeAgePartTime().value() == 1 && this.mInsurance.getBeginWorkExemption() == null) {
            throw EmployeeExceptionMapper.makeBlockzeitWithoutDateOfWorkExemptionDomainException();
        }
    }

    private AgePartTimeModel existsAgePartTimeModel() throws BusinessDomainException {
        AgePartTimeModel agePartTimeModel;
        block9: {
            CompanySettings companySettings;
            PCompany company;
            block8: {
                agePartTimeModel = null;
                Plant plant = null;
                PlantSettings plantSettings = null;
                company = null;
                companySettings = null;
                Employment employment = (Employment)this.mEmployee.getEmploymentHistory().getItemOrNull(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                if (employment != null) {
                    plant = employment.getPlant();
                }
                if (plant != null) {
                    try {
                        plantSettings = plant.getPlantSettings(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                        agePartTimeModel = plantSettings.getSettings().getAgePartTimeModel();
                        if (agePartTimeModel != null) {
                            return agePartTimeModel;
                        }
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block8;
                        throw e;
                    }
                }
            }
            company = this.mEmployee.getPCompany();
            try {
                companySettings = company.getCompanySettings(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                agePartTimeModel = companySettings.getSettings().getAgePartTimeModel();
                if (agePartTimeModel != null) {
                    return agePartTimeModel;
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block9;
                throw e;
            }
        }
        return agePartTimeModel;
    }

    private void checkReplacer() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mInsurance.getCompanyKeyOfReplacer()) && this.mInsurance.getPersonnelnumberReplacer() == 0) {
            return;
        }
        if (!StringMapper.isNullString((String)this.mInsurance.getCompanyKeyOfReplacer()) && this.mInsurance.getPersonnelnumberReplacer() == 0 || StringMapper.isNullString((String)this.mInsurance.getCompanyKeyOfReplacer()) && this.mInsurance.getPersonnelnumberReplacer() != 0) {
            throw EmployeeExceptionMapper.makeDataOfReplacerAreUncompletedDomainException();
        }
        PCompany pCompany = PCompany.getPCompanyByPCompanyKey((String)this.mInsurance.getCompanyKeyOfReplacer());
        Employee[] employeeReplacer = this.getIEmployeePM().query(null, Restrictions.and((Criterion)Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid()), (Criterion)Restrictions.eq((String)"personnelnumber", (String)Integer.toString(this.mInsurance.getPersonnelnumberReplacer()))), true);
        if (employeeReplacer.length != 1) {
            throw EmployeeExceptionMapper.makePersonnelnumberReplacerNotFound();
        }
        int personGroup = employeeReplacer[0].getActiveInsurance().getPersonGroup();
        if (personGroup != 101 && personGroup != 102) {
            throw EmployeeExceptionMapper.makePersonGroupOfReplacerIsFalse();
        }
    }

    private void checkReferenceNumberHealthFund() {
        if (this.mOld == null) {
            return;
        }
        if (StringMapper.isNullString((String)this.mInsurance.getReferenceNumberHealthFund())) {
            return;
        }
        if (PersonnelPersistenceObject.isEqual((IPersistentObject)this.mOld.getHealthFundKVdR(), (IPersistentObject)this.mInsurance.getHealthFundKVdR())) {
            return;
        }
        if (!PersonnelPersistenceObject.isEqual((IPersistentObject)this.mOld.getHealthFundKVdR(), (IPersistentObject)this.mInsurance.getHealthFundKVdR())) {
            this.mInsurance.setReferenceNumberHealthFund("");
            this.mInsurance.setReferenceNumberHealthFundCapitalPayment("");
        }
    }

    private void checkEuInsuranceNo() throws BusinessDomainException {
        block7: {
            if (!StringMapper.isNullString((String)this.mInsurance.getInsuranceNo())) {
                if (!StringMapper.isNullString((String)this.mInsurance.getEuInsuranceNo())) {
                    throw EmployeeExceptionMapper.makeInsuranceNoAndEuInsuranceNoDontCorrespondingDomainException();
                }
            } else if (!StringMapper.isNullString((String)this.mInsurance.getEuInsuranceNo())) {
                StateTP stateTP = null;
                try {
                    stateTP = this.mInsurance.getNationality().getObjectFromObjectId(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                    if (!stateTP.getEuEeaCountryOfBirth()) {
                        throw EmployeeExceptionMapper.makeEuInsuranceNoAndNationalityDontCorrespondingDomainException();
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block7;
                    throw e;
                }
            }
        }
    }

    private void checkEuStateOfBirth() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mInsurance.getEuInsuranceNo()) && this.mInsurance.getEuStateOfBirth() == null) {
            throw EmployeeExceptionMapper.makeEuStateOfBirthMissingDomainException();
        }
    }

    private void checkFeaturePlus() throws BusinessDomainException {
        if (StringMapper.equal((String)this.mInsurance.getFirstname(), (String)"+") || StringMapper.equal((String)this.mInsurance.getSurname(), (String)"+")) {
            if (DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)DateMapper.toDate((String)"2014-06-01"))) {
                throw EmployeeExceptionMapper.makeFeaturePlusNotAllowedDomainException();
            }
            if (StringMapper.equal((String)this.mInsurance.getFirstname(), (String)"+") && StringMapper.equal((String)this.mInsurance.getSurname(), (String)"+")) {
                throw EmployeeExceptionMapper.makeFeaturePlusNotDuplicateAllowedDomainException();
            }
        }
    }

    private void checkERAllowance() throws BusinessDomainException {
        if (this.mInsurance.getERAllowanceVHI() != 1 && this.mInsurance.getERAllowanceVHI() != 11 && this.mInsurance.getERAllowanceVHI() != 21 && this.mInsurance.getERAllowanceVHI() != 99) {
            FrameWorkExceptionMapper.makeInputNotValidDomainException((String)"AG-Zuschuss freiw. KV");
        }
        if (this.mInsurance.getERAllowanceVNI() != 1 && this.mInsurance.getERAllowanceVNI() != 2 && this.mInsurance.getERAllowanceVNI() != 3 && this.mInsurance.getERAllowanceVNI() != 9) {
            FrameWorkExceptionMapper.makeInputNotValidDomainException((String)"AG-Zuschuss freiw. PV");
        }
        if (this.mInsurance.getERAllowancePHI() != 1 && this.mInsurance.getERAllowancePHI() != 2 && this.mInsurance.getERAllowancePHI() != 9) {
            FrameWorkExceptionMapper.makeInputNotValidDomainException((String)"AG-Zuschuss private KV");
        }
        if (this.mInsurance.getERAllowancePNI() != 1 && this.mInsurance.getERAllowancePNI() != 2 && this.mInsurance.getERAllowancePNI() != 9) {
            FrameWorkExceptionMapper.makeInputNotValidDomainException((String)"AG-Zuschuss private PV");
        }
    }

    private void checkAnnaulEarningsGLZ() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_NEU_MINIJOB) && DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)END_OF_MIDIJOB) && this.mInsurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && (this.mInsurance.getMultiplyEmployment() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG || this.mInsurance.getMultiplyEmployment() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mInsurance.getAnnaulEarningsGLZ())) {
            throw EmployeeExceptionMapper.makeAnnaulEarningsGLZisMissingDomainException();
        }
    }

    private void checkDuesGroupPIAndGLZ() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)START_OF_NEU_MINIJOB) && this.mInsurance.isOldLowWageArea() && this.mInsurance.getRecipient() == null && this.mInsurance.getDuesGroupPI() == 0) {
            throw EmployeeExceptionMapper.makeDuesGroupPIAandGLZFalseDomainException();
        }
    }

    private void checkDecreaseOfDuesInReducedHours() throws BusinessDomainException {
        if (this.mInsurance.isDecreaseOfDuesInReducedHours()) {
            if (this.mInsurance.getDuesGroupHI() != 9) {
                throw EmployeeExceptionMapper.makeInvalidDecreaseOfDuesInReducedHours();
            }
            if (this.mInsurance.getERAllowanceVHI() != 21 || this.mInsurance.getERAllowanceVNI() != 3) {
                throw EmployeeExceptionMapper.makeInvalidDecreaseOfDuesInReducedHours();
            }
        }
    }

    private void ckeckReferenceZahls() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mInsurance.getReferenceNumberZahls()) && StringMapper.equalWithTrim((String)this.mInsurance.getReferenceNumberZahlsCapitalPayment(), (String)this.mInsurance.getReferenceNumberZahls())) {
            throw ZahlsExceptionMapper.makeReferenceMustBeDifferentException();
        }
    }

    private void checkOccupationExt(boolean needed) throws BusinessDomainException {
        if (needed) {
            if (this.mInsurance.getSchoolLeaving() != 1 && this.mInsurance.getSchoolLeaving() != 2 && this.mInsurance.getSchoolLeaving() != 3 && this.mInsurance.getSchoolLeaving() != 4 && this.mInsurance.getSchoolLeaving() != 9) {
                throw EmployeeExceptionMapper.makeSchollLeavingFalseException();
            }
            if (this.mInsurance.getProfessionalEducation() != 1 && this.mInsurance.getProfessionalEducation() != 2 && this.mInsurance.getProfessionalEducation() != 3 && this.mInsurance.getProfessionalEducation() != 4 && this.mInsurance.getProfessionalEducation() != 5 && this.mInsurance.getProfessionalEducation() != 6 && this.mInsurance.getProfessionalEducation() != 9) {
                throw EmployeeExceptionMapper.makeProfessionalEductionFalseException();
            }
            if (this.mInsurance.getManPowerProvision() != 1 && this.mInsurance.getManPowerProvision() != 2) {
                throw EmployeeExceptionMapper.makeManPowerProvisionFalseException();
            }
            if (this.mInsurance.getTypeOfContract() != 1 && this.mInsurance.getTypeOfContract() != 2 && this.mInsurance.getTypeOfContract() != 3 && this.mInsurance.getTypeOfContract() != 4) {
                throw EmployeeExceptionMapper.makeTypeOfContractFalseException();
            }
        } else if (this.mInsurance.getSchoolLeaving() != 0 || this.mInsurance.getProfessionalEducation() != 0 || this.mInsurance.getManPowerProvision() != 0 || this.mInsurance.getTypeOfContract() != 0) {
            throw EmployeeExceptionMapper.makeOccupationLongNotAllowedNotAllowedDomainException();
        }
    }

    public void checkValidityAfter2018() throws BusinessDomainException {
        OccupationLongTP[] tps;
        if (!this.mInsurance.getSpecialChecks() && this.mEmployee.isLastDateOfWithdrawalJournalized()) {
            return;
        }
        if (this.mInsurance.getOccupationLong().getNotUse() && (tps = OccupationLongTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"objectidroot", (String)String.valueOf(this.mInsurance.getOccupationLong().getOccupationNew())), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}))).length > 0) {
            if (!this.mInsurance.getSpecialChecks()) {
                throw EmployeeExceptionMapper.makeUseNewOccupationDomainException(tps[0].getOccupationLong().getOccupationKey(), tps[0].getLongDescription(), tps[0].getValidFrom());
            }
            if (this.mInsurance.getSpecialChecks() && DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)tps[0].getValidFrom())) {
                throw EmployeeExceptionMapper.makeUseNewOccupationDomainException(tps[0].getOccupationLong().getOccupationKey(), tps[0].getLongDescription(), tps[0].getValidFrom());
            }
        }
    }

    private void checkSpecialCategoryOfPersons() throws BusinessDomainException {
        if (this.mInsurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_FOERDERUNG_NACH_PAR_16A_SGB_II && this.mInsurance.getDuesGroupUI() != 0) {
            throw EmployeeExceptionMapper.makeSpecialCategoryAndDuesgroupUIDontCorrespondingDomainException();
        }
        if (this.mInsurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_PFLICHTVERSICHERUNG_PAR_5_SGB_V && (!DateHelper.after((Date)this.mInsurance.getValidFrom(), (Date)new VDate(2007, 3, 1).getDate()) || this.mInsurance.getDuesGroupHI() != 0 || this.mInsurance.getContScaleVHI() != ContributionScaleVHIEnum.CSE_ALLGEMEIN || this.mInsurance.getERAllowanceVHI() != 21 || this.mInsurance.getDuesGroupNI() != 0 && this.mInsurance.getDuesGroupNI() != 1 || this.mInsurance.getContScaleVNI() != ContributionScaleVNIEnum.CSVNIE_ALLGEMEIN || this.mInsurance.getERAllowanceVNI() != 3)) {
            throw EmployeeExceptionMapper.makeSpecialCategoryAndDuesgroupHIDontCorrespondingDomainException();
        }
        if (!(this.mInsurance.getSpecialCategoryOfPersons() != SpecialCategoryEnum.SCE_AV_BEITRAG_1_PROZENT_BEZUGSGROESSE || DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)new VDate(2016, 6, 1).getDate()) && this.mInsurance.getPersonGroup() == 111)) {
            throw EmployeeExceptionMapper.makeAvBeitragEinProzentNotAllowedDomainException();
        }
    }

    private void checkInsolvencyHealthFund() throws BusinessDomainException {
        if (this.mInsurance.getInsolvencyDuty() && this.mInsurance.getInsolvencyHealthFund() == null || !this.mInsurance.getInsolvencyDuty() && this.mInsurance.getInsolvencyHealthFund() != null) {
            throw EmployeeExceptionMapper.makeInsolvencyHealthfundMissingDomainException();
        }
        if (this.mInsurance.getInsolvencyHealthFund() == null) {
            return;
        }
        if (((ICustomerControls)UtilitiesManager.getBean((String)"customerControls", ICustomerControls.class)).healthFundAssignmentToPlantIsNecessary()) {
            if (!CheckUp.checkHealthFundAssignmentToPlant((Employee)this.mEmployee, (HealthFund)this.mInsurance.getInsolvencyHealthFund(), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) {
                throw EmployeeExceptionMapper.makeInsolvencyHealthFundIsNotAssignedToPlantDomainException();
            }
        } else if (!CheckUp.checkHealthFundAssignment((Employee)this.mEmployee, (HealthFund)this.mInsurance.getInsolvencyHealthFund(), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) {
            throw EmployeeExceptionMapper.makeInsolvencyHealthFundIsNotAssignedDomainException();
        }
        this.mInsurance.getInsolvencyHealthFund().getHealthFundTP(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
        if (this.mInsurance.getSpecialChecks()) {
            this.checkHealthFundMerger("Die ausgew\u00e4hlte InsG-Umlagekasse ", this.mInsurance.getInsolvencyHealthFund(), this.mInsurance.getValidFrom());
        }
    }

    private void checkDateOfPensionBalance() {
        if (this.mInsurance.getDateOfPensionBalance() != null && !DateHelper.equal((Date)this.mInsurance.getDateOfPensionBalance(), (Date)DateHelper.getLastDayOfMonth((Date)this.mInsurance.getDateOfPensionBalance()))) {
            FrameWorkExceptionMapper.makeOnlyLastDayOfMonthAllowedDomainException();
        }
    }

    private void checkIsSameInsolvencyHealthFund() throws BusinessDomainException {
        if (DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)DateMapper.toDate((String)"2009-01-01")) || this.mInsurance.getInsolvencyHealthFund() == null) {
            return;
        }
        boolean isHealthFundBkn = this.isGfbHealthFund(this.mInsurance.getHealthFund());
        if ((this.isGfbPgs109() || this.mInsurance.getPersonGroup() == 110) && !isHealthFundBkn) {
            throw EmployeeExceptionMapper.makeAssessmentAndHealthFundMustBknDomainException();
        }
        if (this.isGfbMixedCase() && isHealthFundBkn) {
            throw EmployeeExceptionMapper.makeMixedCaseGfBAssessmentHealthFundDomainException();
        }
        if (!(this.mInsurance.getPersonGroup() != 109 && this.mInsurance.getPersonGroup() != 110 || this.isGfbHealthFund(this.mInsurance.getInsolvencyHealthFund()))) {
            throw EmployeeExceptionMapper.makeAssessmentAndHealthFundMustBknDomainException();
        }
        if (StringMapper.equal((String)this.getStandardCompanyNumber(this.mInsurance.getHealthFund()), (String)this.getStandardCompanyNumber(this.mInsurance.getInsolvencyHealthFund()))) {
            return;
        }
        if (this.mInsurance.isHealthFundLKK()) {
            return;
        }
        if (!this.isTransitionAreaBy31122023()) {
            throw EmployeeExceptionMapper.makeInsolvencyHealthFundMustSameDomainException();
        }
    }

    private void checkProcessNo() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mInsurance.getProcessNo())) {
            CheckUp.ProcessNoCheckup((Insurance)this.mInsurance);
        }
    }

    private void checkBaseRatePrivateInsurance() throws BusinessDomainException {
        if (DateHelper.before((Date)this.mInsurance.getValidFrom(), (Date)new VDate(2010, 0, 1).getDate()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mInsurance.getBaseRatePrivateInsurance())) {
            throw EmployeeExceptionMapper.makeBaseRatePHINotAllowedDomainException();
        }
    }

    private void checkRecipientAssignment() throws BusinessDomainException {
        if (this.mInsurance.getRecipient() != null && !CheckUp.checkRecipientAssignment((Employee)this.mEmployee, (Recipient)this.mInsurance.getRecipient(), (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom())) {
            throw EmployeeExceptionMapper.makeRecipientIsNotAssignedDomainException();
        }
    }

    private void checkHealthFundForDeuv() throws BusinessDomainException {
        if (this.mInsurance.isDEUVAdviceable() && this.mInsurance.getHealthFund() == null) {
            throw EmployeeExceptionMapper.makeMissedHealthfundForDeuvDomainException();
        }
    }

    private void checkPpMembershipNumber() throws BusinessDomainException {
        if (this.mInsurance.getRecipient() != null) {
            if (this.mInsurance.getModeOfPension() == ModeOfPensionEnum.MOPE_KEINE) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Versorgungsart");
            }
            if (StringMapper.isNullString((String)this.mInsurance.getPpMembershipNumber())) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Mitgliedsnummer bei der Versorgungseinrichtung");
            }
            if (this.mInsurance.getEmployee().noCheckForEvPT()) {
                return;
            }
            MembershipNumberOfPpRecipient checker = new MembershipNumberOfPpRecipient(this.mInsurance.getRecipient().getActiveRecipientTP().getStandardCompanyNumber(), this.mInsurance.getPpMembershipNumber());
            checker.checkMembershipNumber();
            if (checker.getError()) {
                throw EmployeeExceptionMapper.makePpMembershipNumberInvalidDomainException(checker.getErrorMessage());
            }
        }
    }

    private void checkModeOfPensionAndTotalDues() throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mInsurance.getTotalDues()) && this.mInsurance.getModeOfPension() == ModeOfPensionEnum.MOPE_BERUFSSTAENDISCHE_VERSORGUNG) {
            throw EmployeeExceptionMapper.makeTotalDuesNotAllowedException();
        }
    }

    private void checkKvNumberNumber() throws BusinessDomainException {
        if (new KVNumber(this.mInsurance.getMembershipKVdR()).isInvalidCheckDigit()) {
            throw FrameWorkExceptionMapper.makeKvNumberInvalidDomainException();
        }
    }

    private void checkDuesGroupHIAndERAllowanceVHI() throws BusinessDomainException {
        if (!StringMapper.isNullString((String)this.mInsurance.getGroupKeyOfOther()) && Integer.parseInt(this.mInsurance.getGroupKeyOfOther().substring(0, 1)) == 9 && this.mInsurance.getDuesGroupHI() == 9) {
            if (this.mInsurance.getERAllowanceVHI() == 99) {
                throw EmployeeExceptionMapper.makeERAllowanceVHIFalseDomainException();
            }
            if (this.mInsurance.getERAllowanceVNI() == 9) {
                throw EmployeeExceptionMapper.makeERAllowanceVNIFalseDomainException();
            }
        }
    }

    private void checkPersonGroupAgainstAssessment() throws BusinessDomainException {
        if (this.mInsurance.getPersonGroup() == 122 && (this.mInsurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_FOERDERUNG_NACH_PAR_76_SGB_III ? this.mInsurance.getAssessmentDuty() != AssessmentDutyEnum.ADE_KEINE : this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_KEINE || this.mInsurance.getAssessmentDuty() == AssessmentDutyEnum.ADE_U1)) {
            throw EmployeeExceptionMapper.makePgs122OnlyAssessmentDutyAllowedDomainException();
        }
        if ((this.mInsurance.getPersonGroup() == 102 && this.mInsurance.getDuesGroupHI() == 4 || this.mInsurance.getPersonGroup() == 112) && this.mInsurance.getAssessmentDuty() != AssessmentDutyEnum.ADE_KEINE) {
            throw EmployeeExceptionMapper.makePgs102and112AgainstAssessmetDutyFalseDomainException();
        }
    }

    private boolean getPlantOrCompanyAssessable() throws BusinessDomainException {
        boolean assessable = false;
        if (this.mEmployee != null) {
            PlantSettings plantSettings;
            Employment employment;
            block13: {
                employment = null;
                plantSettings = null;
                try {
                    employment = this.mEmployee.getEmployment(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block13;
                    throw e;
                }
            }
            if (employment != null && employment.getPlant() != null) {
                block14: {
                    try {
                        plantSettings = employment.getPlant().getPlantSettings(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block14;
                        throw e;
                    }
                }
                if (plantSettings != null) {
                    if (plantSettings.getSettings() != null) {
                        assessable = plantSettings.getSettings().getAssessable();
                        if (!assessable) {
                            assessable = this.getCompanyAssessable();
                        }
                    } else {
                        assessable = this.getCompanyAssessable();
                    }
                } else {
                    assessable = this.getCompanyAssessable();
                }
            } else {
                assessable = this.getCompanyAssessable();
            }
        } else {
            LOGGER.debug("this.getEmployee() = null");
        }
        return assessable;
    }

    private boolean getCompanyAssessable() throws BusinessDomainException {
        boolean assessable = false;
        if (this.mEmployee != null) {
            if (this.mEmployee.getPCompany() != null) {
                CompanySettings companySettings;
                block10: {
                    companySettings = null;
                    try {
                        companySettings = this.mEmployee.getPCompany().getCompanySettings(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block10;
                        throw e;
                    }
                }
                if (companySettings != null) {
                    if (companySettings.getSettings() != null) {
                        assessable = companySettings.getSettings().getAssessable();
                    } else {
                        LOGGER.debug("companySettings.getSettings() = null");
                    }
                } else {
                    LOGGER.debug("companySettings = null");
                }
            } else {
                LOGGER.debug("this.getEmployee().getPCompany() = null");
            }
        } else {
            LOGGER.debug("this.getEmployee() = null");
        }
        return assessable;
    }

    private void checkRemittance() throws BusinessDomainException {
        if (this.mOld != null) {
            this.mEmployee.checkRemittance(this.mOld, this.mInsurance);
        }
    }

    public void specialcheckCompleteOccupationLong() throws BusinessDomainException {
        this.checkCompleteOccupationLong(DateHelper.tomorrow((Date)this.mEmployee.getJournalizedUntil()));
    }

    public void specialcheckKVdRandVBZ(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        this.mInsurance.specialcheckKVdRandVBZ(effectiveTimePoint, validTimePoint);
    }

    public void checkNIChildEducationAndChildRelief() throws BusinessDomainException {
        if (this.mInsurance.getPersonGroup() >= 981 && this.mInsurance.getPersonGroup() <= 999 || this.mInsurance.getDuesGroupHI() == 0 || this.mInsurance.getDuesGroupHI() == 6) {
            return;
        }
        Tax tax = (Tax)this.mEmployee.getTaxHistory().getItemOrNull(VDate.getDateMax(), this.mInsurance.getValidFrom());
        BigDecimal childRelief = null;
        if (tax != null) {
            childRelief = tax.getChildRelief();
        }
        if (!this.mInsurance.getNIChildEducation() && !BigDecimalMapper.isZeroOrNull((BigDecimal)childRelief)) {
            throw EmployeeExceptionMapper.makeChildReliefExistsDomainException(this.mInsurance.getValidFrom(), tax.getValidFrom());
        }
    }

    public void postCheckHIInWorkExemption() throws BusinessDomainException {
        if (this.mOld == null) {
            return;
        }
        if (this.mInsurance.getBeginWorkExemption() == null) {
            return;
        }
        if (this.mOld.getBeginWorkExemption() == null && this.mInsurance.getBeginWorkExemption() != null && this.mInsurance.getDuesGroupHI() != 3) {
            throw EmployeeExceptionMapper.makeCheckDuesGroupNecessaryDomainException();
        }
    }

    public void specialCheckLumpSumAndPersongroup(Date checkDate) throws BusinessDomainException {
        block3: {
            try {
                if (this.mInsurance.getEmployee().noCheckForEvPT()) {
                    return;
                }
                Tax tax = this.mEmployee.getTax(VDate.getDateMax(), checkDate);
                TaxacationEnum taxacation = tax.getTaxacation();
                this.mEmployee.specialCheckLumpSumAndPersongroup(this.mInsurance, taxacation, checkDate);
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                throw e;
            }
        }
    }

    public void checkPersonGroupAndInsolvencyDuty() throws BusinessDomainException {
        if ((this.mInsurance.getPersonGroup() < 900 || this.mInsurance.getPersonGroup() > 999) && this.mInsurance.getPersonGroup() != 107 && this.mInsurance.getPersonGroup() != 111 && this.mEmployee.isInsolvencyAssessable() && !this.mInsurance.getInsolvencyDuty()) {
            throw EmployeeExceptionMapper.makeCheckInsolvencyDomainException();
        }
    }

    public void checkHealthFundMerger(String healthFundType, HealthFund hf, Date validTimePoint) throws BusinessDomainException {
        if (hf == null) {
            return;
        }
        HealthFundTP hftp = hf.getHealthFundTP(validTimePoint, validTimePoint);
        if (hftp.getStandardCompanyNumberValidUntil() == null) {
            return;
        }
        if (DateHelper.beforeOrEqual((Date)hftp.getStandardCompanyNumberValidUntil(), (Date)validTimePoint)) {
            throw HealthFundExceptionMapper.makeMergedHealthfundDomainException((String)healthFundType, (String)hftp.getStandardCompanyNumber(), (Date)hftp.getStandardCompanyNumberValidUntil(), (String)hftp.getStandardCompanyNumberSuccessor());
        }
    }

    public void checkAssessmentHealthFundPostCondition() throws BusinessDomainException {
        if (!DateHelper.equal((Date)this.mInsurance.getValidUntil(), (Date)VDate.getDateMax()) || !DateHelper.equal((Date)this.mInsurance.getEffectiveUntil(), (Date)VDate.getDateMax())) {
            return;
        }
        if (this.mInsurance.getAssessmentHealthFund() != null || this.mInsurance.getAssessmentDuty().value() != 0) {
            if (this.getPlantOrCompanyAssessable()) {
                if (this.mInsurance.getAssessmentDuty().value() == 0) {
                    throw EmployeeExceptionMapper.makeAssessmentDutyEnumAndAssessmentHealthFundDomainException();
                }
                HealthFund healthFund = null;
                Plant plant = null;
                AssignmentPCompanyHealthFundTP[] appurtenantHFtp = null;
                healthFund = this.mEmployee.getAssessmentHealthFund(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                if (healthFund == null) {
                    throw EmployeeExceptionMapper.makeAssessmentHealthFundMissingDomainException();
                }
                plant = this.mEmployee.getAppurtenantPlant(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                if (plant != null) {
                    appurtenantHFtp = AssignmentPCompanyHealthFund.getAssignmentPCompanyHealthFunds((AssignmentPCompanyHealthFundFilterStruct[])new AssignmentPCompanyHealthFundFilterStruct[]{new AssignmentPCompanyHealthFundFilterStruct(this.mEmployee.getPCompany().getObjectid(), plant.getObjectid(), healthFund.getObjectid())}, null, (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom());
                }
                if (appurtenantHFtp == null || appurtenantHFtp.length < 1) {
                    if (((ICustomerControls)UtilitiesManager.getBean((String)"customerControls", ICustomerControls.class)).healthFundAssignmentToPlantIsNecessary()) {
                        throw EmployeeExceptionMapper.makeAssessmentHealthFundIsNotAssignedToPlantDomainException();
                    }
                    appurtenantHFtp = AssignmentPCompanyHealthFund.getAssignmentPCompanyHealthFunds((AssignmentPCompanyHealthFundFilterStruct[])new AssignmentPCompanyHealthFundFilterStruct[]{new AssignmentPCompanyHealthFundFilterStruct(this.mEmployee.getPCompany().getObjectid(), "", healthFund.getObjectid())}, null, (Date)this.mInsurance.getEffectiveFrom(), (Date)this.mInsurance.getValidFrom());
                }
                if (appurtenantHFtp.length < 1) {
                    throw EmployeeExceptionMapper.makeAssessmentHealthFundIsNotAssignedDomainException();
                }
                switch (this.mInsurance.getAssessmentDuty().value()) {
                    case 1: {
                        if (appurtenantHFtp[0].getAssessment1() != 0) break;
                        throw EmployeeExceptionMapper.makeAssessment1IsNotInHealthFundDomainException();
                    }
                    case 3: {
                        if (appurtenantHFtp[0].getAssessment2() != 0) break;
                        throw EmployeeExceptionMapper.makeAssessment2IsNotInHealthFundDomainException();
                    }
                    case 2: {
                        if (appurtenantHFtp[0].getAssessment1() != 0 && appurtenantHFtp[0].getAssessment2() != 0) break;
                        throw EmployeeExceptionMapper.makeAssessment1or2IsNotInHealthFundDomainException();
                    }
                }
            } else if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)new VDate(2006, 0, 1).getDate()) && this.mInsurance.getAssessmentHealthFund() == null && this.mInsurance.getAssessmentDuty().value() != 0) {
                throw EmployeeExceptionMapper.makeNoAssessmentHelthfundForEmployeeDomainException();
            }
        }
        if (this.mInsurance.getAssessmentHealthFund() != null) {
            try {
                this.mInsurance.getAssessmentHealthFund().getHealthFundTP(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                    throw EmployeeExceptionMapper.makeAssessmentHealthfundTPmissingDomainException();
                }
                throw e;
            }
            if (this.mInsurance.getSpecialChecks()) {
                this.checkHealthFundMerger("Die ausgew\u00e4hlte Umlagekasse", this.mInsurance.getAssessmentHealthFund(), this.mInsurance.getValidFrom());
            }
        }
    }

    public void checkCompleteOccupationLong(Date testDate) throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)testDate, (Date)START_OF_OCCOPATION_LONG) && this.mInsurance.isDEUVAdviceable()) {
            boolean occupationNeeded = true;
            if (this.mInsurance.getPersonGroup() == 108 || this.mInsurance.getPersonGroup() == 116) {
                occupationNeeded = false;
            }
            if (this.mInsurance.getPersonGroup() == 107 || this.mInsurance.getPersonGroup() == 111 || this.mInsurance.getPersonGroup() == 204) {
                this.checkOccupationExt(true);
                if (this.mInsurance.getOccupationLong() != null) {
                    if (this.mInsurance.getSpecialChecks()) {
                        this.checkValidityAfter2018();
                    }
                    this.mInsurance.getOccupationLong().checkTimePeriod(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
                }
                return;
            }
            if (occupationNeeded) {
                if (this.mInsurance.getOccupationLong() == null) {
                    throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"ausge\u00fcbte T\u00e4tigkeit");
                }
            } else if (this.mInsurance.getOccupationLong() != null) {
                throw EmployeeExceptionMapper.makeOccupationLongNotAllowedNotAllowedDomainException();
            }
            this.checkOccupationExt(occupationNeeded);
        }
        if (this.mInsurance.getOccupationLong() != null) {
            if (this.mInsurance.getSpecialChecks()) {
                this.checkValidityAfter2018();
            }
            this.mInsurance.getOccupationLong().checkTimePeriod(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
        }
    }

    public void checkRetirementPension() throws BusinessDomainException {
        if (!this.mInsurance.getSpecialChecks() && this.mEmployee.isLastDateOfWithdrawalJournalized()) {
            return;
        }
        this.checkPensionFirst();
        this.checkPensionSecond();
        this.checkPensionFourth();
    }

    public void checkPensionFirst() throws BusinessDomainException {
        if (!this.mInsurance.getSpecialChecks()) {
            return;
        }
        if (this.mInsurance.getPersonGroup() >= 900 || this.mInsurance.getPersonGroup() == 109 || this.mInsurance.getPersonGroup() == 110 || this.mInsurance.getPersonGroup() == 190) {
            return;
        }
        if ((this.mInsurance.getTypeOfPension() == 4 || this.mInsurance.getTypeOfPension() == 9 || this.mInsurance.getTypeOfPension() == 10) && StringMapper.isNullString((String)this.mInsurance.getNoExcemptionOfInsuranceSGBVI())) {
            throw EmployeeExceptionMapper.makeNoExcemptionOfInsuranceSGBVIFalse0DomainException();
        }
    }

    public void checkPensionSecond() throws BusinessDomainException {
        if (this.mInsurance.getPersonGroup() >= 900 || this.mInsurance.getPersonGroup() == 109 || this.mInsurance.getPersonGroup() == 110 || this.mInsurance.getPersonGroup() == 190) {
            return;
        }
        if ((this.mInsurance.getTypeOfPension() == 4 || this.mInsurance.getTypeOfPension() == 9 || this.mInsurance.getTypeOfPension() == 10) && this.mInsurance.getPersonGroup() != 119 && this.mInsurance.getPersonGroup() != 120) {
            throw EmployeeExceptionMapper.makeTypeOfPensionAndPersongroupDontCorrespondingDomainException();
        }
        if ((this.mInsurance.getPersonGroup() == 119 || this.mInsurance.getPersonGroup() == 120) && this.mInsurance.getTypeOfPension() != 4 && this.mInsurance.getTypeOfPension() != 9 && this.mInsurance.getTypeOfPension() != 10) {
            throw EmployeeExceptionMapper.makeTypeOfPensionAndPersongroupDontCorrespondingDomainException();
        }
    }

    public void checkPensionFourth() throws BusinessDomainException {
        if ((this.mInsurance.getTypeOfPension() == 4 || this.mInsurance.getTypeOfPension() == 9 || this.mInsurance.getTypeOfPension() == 10) && this.mInsurance.getPersonGroup() == 119 && StringMapper.equal((String)this.mInsurance.getNoExcemptionOfInsuranceSGBVI(), (String)"J")) {
            throw EmployeeExceptionMapper.makeOnlyPersonGroup120AllowedDomainException();
        }
        if ((this.mInsurance.getTypeOfPension() == 4 || this.mInsurance.getTypeOfPension() == 9 || this.mInsurance.getTypeOfPension() == 10) && this.mInsurance.getPersonGroup() == 120 && StringMapper.equal((String)this.mInsurance.getNoExcemptionOfInsuranceSGBVI(), (String)"N")) {
            throw EmployeeExceptionMapper.makeNoExcemptionOfInsuranceSGBVIFalse1DomainException();
        }
    }

    private void checkUseTransitionBy31122022() throws BusinessDomainException {
        if (this.mInsurance.getUseTransitionBy31122022() && this.mInsurance.getPersonGroup() != 109) {
            throw EmployeeExceptionMapper.makeOnlyPersonGroup109AllowedDomainException();
        }
    }

    private void checkExclusionFacts() throws BusinessDomainException {
        if (this.mInsurance.getHealthFundKVdR() == null) {
            return;
        }
        if (this.mInsurance.getBeginKVDR() != null) {
            if (this.mInsurance.getIsNoPensionForParagraph229() && this.mInsurance.getExclusionFacts() != ExclusionFactsEnum.GRUNDSTELLUNG) {
                throw EmployeeExceptionMapper.makeExclusionFactsFalse1DomainException();
            }
            if (!this.mInsurance.getIsNoPensionForParagraph229() && this.mInsurance.getExclusionFacts() == ExclusionFactsEnum.GRUNDSTELLUNG) {
                throw EmployeeExceptionMapper.makeExclusionFactsFalse2DomainException();
            }
        }
        if (this.mInsurance.getDateCapitalPayment() == null) {
            return;
        }
        if (this.mInsurance.getBeginCapitalPayment() != null) {
            if (this.mInsurance.getIsNoPensionForPar229Capital() && this.mInsurance.getExclusionFactsCapital() != ExclusionFactsEnum.GRUNDSTELLUNG) {
                throw EmployeeExceptionMapper.makeExclusionFactsFalse1DomainException();
            }
            if (!this.mInsurance.getIsNoPensionForPar229Capital() && this.mInsurance.getExclusionFactsCapital() == ExclusionFactsEnum.GRUNDSTELLUNG) {
                throw EmployeeExceptionMapper.makeExclusionFactsFalse2DomainException();
            }
        }
    }

    private void checkOrphanBenefit() throws BusinessDomainException {
        if (!this.mInsurance.getIsNoPensionForParagraph229() && this.mInsurance.getOrphanBenefit() != OrphanBenefitEnum.GRUNDSTELLUNG) {
            throw EmployeeExceptionMapper.makeOrphanBenefitFalseDomainException();
        }
    }

    public void specialCheckPensionFirst() throws BusinessDomainException {
        if (!this.mInsurance.getSpecialChecks() && this.mEmployee.isLastDateOfWithdrawalJournalized()) {
            return;
        }
        if (this.mInsurance.getPersonGroup() >= 900 || this.mInsurance.getPersonGroup() == 109 || this.mInsurance.getPersonGroup() == 110 || this.mInsurance.getPersonGroup() == 190) {
            return;
        }
        if ((this.mInsurance.getTypeOfPension() == 4 || this.mInsurance.getTypeOfPension() == 9 || this.mInsurance.getTypeOfPension() == 10) && StringMapper.isNullString((String)this.mInsurance.getNoExcemptionOfInsuranceSGBVI())) {
            throw EmployeeExceptionMapper.makeNoExcemptionOfInsuranceSGBVIFalse0DomainException();
        }
    }

    public void specialcheckIndividualAmountForKVdR() throws BusinessDomainException {
        Date dateMarginal = new VDate(2011, 0, 1).getDate();
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidUntil(), (Date)dateMarginal) && this.mInsurance.getChoiseOfDuesHI().value() == 3) {
            throw EmployeeExceptionMapper.makeIndividualAmountNotAllowedException();
        }
        if (DateHelper.afterOrEqual((Date)this.mInsurance.getValidFrom(), (Date)dateMarginal) && this.mInsurance.getChoiseOfDuesNI().value() == 5) {
            throw EmployeeExceptionMapper.makeIndividualAmountNotAllowedException();
        }
    }

    public void extendedCheckDecreaseOfDuesInReducedHours(Date calculationTimePoint) throws BusinessDomainException {
        Insurance insurance = (Insurance)this.mInsurance.getEmployee().getInsuranceHistory().getItemOrNull(VDate.getDateMax(), DateHelper.getLastDayOfMonth((Date)calculationTimePoint));
        if (insurance == null) {
            return;
        }
        if (!insurance.isDecreaseOfDuesInReducedHours()) {
            return;
        }
        GeneralEmploymentOffice employmentOffice = insurance.getEmployee().getAppurtenantEmploymentOfficeForKug(VDate.getDateMax(), VDate.getDateMax());
        if (employmentOffice == null || employmentOffice.getBeginKugBezug() == null || employmentOffice.getEndKugBezug() == null) {
            throw EmployeeExceptionMapper.makeCheckDecreaseOfDuesInReduceHoursdDomainException();
        }
        if (!DateHelper.beforeOrEqual((Date)employmentOffice.getBeginKugBezug(), (Date)DateHelper.getFirstDayOfMonth((Date)calculationTimePoint)) || !DateHelper.afterOrEqual((Date)employmentOffice.getEndKugBezug(), (Date)DateHelper.getLastDayOfMonth((Date)calculationTimePoint))) {
            throw EmployeeExceptionMapper.makeCheckDecreaseOfDuesInReduceHoursdDomainException();
        }
    }

    private void checkLegalHealthFund() throws BusinessDomainException {
        if (this.mInsurance.getLegalHealthFund() == null) {
            return;
        }
        if (this.mInsurance.getRecipientPHI() != null) {
            throw EmployeeExceptionMapper.makeLeagalAndPrivateHFNotAllowedDomainException();
        }
        this.mInsurance.getLegalHealthFund().checkTimePeriod(this.mInsurance.getEffectiveFrom(), this.mInsurance.getValidFrom());
        if (this.mInsurance.getSpecialChecks()) {
            this.checkHealthFundMerger("Die ausgew\u00e4hlte Krankenkasse", this.mInsurance.getLegalHealthFund(), this.mInsurance.getValidFrom());
        }
    }

    public void isLegalHealthFundRequired() throws BusinessDomainException {
        if (!this.mInsurance.getSpecialChecks() && this.mEmployee.isLastDateOfWithdrawalJournalized()) {
            return;
        }
        if ((this.mInsurance.getPersonGroup() == 106 || this.isActuallyPgs109() || this.mInsurance.getPersonGroup() == 110) && this.mInsurance.getLegalHealthFund() == null && this.mInsurance.getRecipientPHI() == null) {
            throw EmployeeExceptionMapper.makeLeagalOrPrivateHFIsMissingDomainException();
        }
    }

    private void checkCreateOfTaskReminderIsNecessary() {
        Date lastDateOfWithdrawal;
        String reminderName = "";
        String reminderNameOld = "";
        Date actDate = new Date();
        if (this.mOld == null && this.mInsurance.getDateNoExemptionPF() != null && DateHelper.after((Date)this.mInsurance.getDateNoExemptionPF(), (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber(this.mEmployee, "Verzicht auf RV-Freiheit ");
            this.createTaskReminder(reminderName, this.mInsurance.getDateNoExemptionPF());
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.getDateNoExemptionPF(), (Date)this.mInsurance.getDateNoExemptionPF())) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber(this.mEmployee, "Verzicht auf RV-Freiheit ");
            reminderNameOld = new StringBuffer("Verzicht auf RV-Freiheit f\u00fcr Firma/PNR: ").append(this.mEmployee.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.getDateNoExemptionPF() != null) {
                TaskReminderHelper.deleteTaskReminder(reminderNameOld, this.mOld.getDateNoExemptionPF());
                TaskReminderHelper.deleteTaskReminder(reminderName, this.mOld.getDateNoExemptionPF());
            }
            if (this.mInsurance.getDateNoExemptionPF() != null && DateHelper.after((Date)this.mInsurance.getDateNoExemptionPF(), (Date)actDate)) {
                this.createTaskReminder(reminderName, this.mInsurance.getDateNoExemptionPF());
            }
        }
        if (this.mOld == null && this.mInsurance.getDateOfReceipt() != null && DateHelper.after((Date)this.mInsurance.getDateOfReceipt(), (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber(this.mEmployee, "Elterneigenschaft PV ");
            this.createTaskReminder(reminderName, this.mInsurance.getDateOfReceipt());
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.getDateOfReceipt(), (Date)this.mInsurance.getDateOfReceipt())) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber(this.mEmployee, "Elterneigenschaft PV ");
            reminderNameOld = new StringBuffer("Elterneigenschaft PV f\u00fcr Firma/PNR: ").append(this.mEmployee.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.getDateOfReceipt() != null) {
                TaskReminderHelper.deleteTaskReminder(reminderNameOld, this.mOld.getDateOfReceipt());
                TaskReminderHelper.deleteTaskReminder(reminderName, this.mOld.getDateOfReceipt());
            }
            if (this.mInsurance.getDateOfReceipt() != null && DateHelper.after((Date)this.mInsurance.getDateOfReceipt(), (Date)actDate)) {
                this.createTaskReminder(reminderName, this.mInsurance.getDateOfReceipt());
            }
        }
        if ((lastDateOfWithdrawal = this.mInsurance.getEmployee().getLastDateOfWithdrawal()) == null && this.mOld == null && this.mInsurance.getEndKVDR() != null) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber(this.mEmployee, "Mit Erfassung Enddatum Versorgungsbezug auch Austrittsdatum erfassen");
            this.createTaskReminder(reminderName, this.mInsurance.getEndKVDR());
        }
        if (lastDateOfWithdrawal == null && this.mOld != null && this.mOld.getEndKVDR() == null && this.mInsurance.getEndKVDR() != null) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber(this.mEmployee, "Mit Erfassung Enddatum Versorgungsbezug auch Austrittsdatum erfassen");
            this.createTaskReminder(reminderName, this.mInsurance.getEndKVDR());
        }
    }

    public void createTaskReminder(String reminderName, Date reminderDate) {
        TaskReminderHelper.createTaskReminder(reminderName, reminderDate, "", SessionContext.getInstance().getSession().getUserCode());
    }

    private boolean isGfbPgs109() {
        if (this.mInsurance.getPersonGroup() != 109) {
            return false;
        }
        return this.isActuallyPgs109();
    }

    private boolean isActuallyPgs109() {
        if (this.mInsurance.getPersonGroup() != 109) {
            return false;
        }
        return this.mInsurance.getSpecialCategoryOfPersons() != SpecialCategoryEnum.SCE_GLEITZONENREGELUNG || !this.mInsurance.getUseTransitionBy31122022();
    }

    public static boolean isActuallyPgs109(Insurance insurance) {
        if (insurance.getPersonGroup() != 109) {
            return false;
        }
        return insurance.getSpecialCategoryOfPersons() != SpecialCategoryEnum.SCE_GLEITZONENREGELUNG || !insurance.getUseTransitionBy31122022();
    }

    private boolean isTransitionAreaBy31122023() {
        return this.mInsurance.getPersonGroup() == 109 && this.mInsurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && this.mInsurance.getUseTransitionBy31122022();
    }

    private void isUseTransitionBy31122022() throws BusinessDomainException {
        if (this.mInsurance.getUseTransitionBy31122022() && (DateHelper.after((Date)this.mInsurance.getValidFrom(), (Date)END_OF_USE_TRANSITION_BY_31122022) || DateHelper.afterOrEqual((Date)this.mInsurance.getEmployee().getJournalizedUntil(), (Date)END_OF_USE_TRANSITION_BY_31122022) && DateHelper.between((Date)END_OF_USE_TRANSITION_BY_31122022, (Date)this.mInsurance.getValidFrom(), (Date)this.mInsurance.getValidUntil()))) {
            throw EmployeeExceptionMapper.makeUseTransitioNotAllowedDomainException();
        }
    }

    private IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

