/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.elo2.account;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.elo2.AdviceStateEnum;
import com.varial.personnel.domain.elo2.ReasonOfDeliveryEnum;
import com.varial.personnel.domain.elo2.account.Elo2AccountData;
import com.varial.personnel.domain.elo2.account.Elo2AccountPersistencyManager;
import com.varial.personnel.domain.elo2.account.Elo2Advice;
import com.varial.personnel.domain.elo2.dueab.Elo2Dueab;
import com.varial.personnel.domain.elo2.dueab.Elo2DueabPersistencyManager;
import com.varial.personnel.domain.elo2.duean.Elo2Duean;
import com.varial.personnel.domain.elo2.duean.Elo2DueanPersistencyManager;
import com.varial.personnel.domain.elo2.dueum.Elo2Dueum;
import com.varial.personnel.domain.elo2.dueum.Elo2DueumPersistencyManager;
import com.varial.personnel.domain.elo2.elstam.Elo2Elstam;
import com.varial.personnel.domain.elo2.elstam.Elo2ElstamPersistencyManager;
import com.varial.personnel.domain.elo2.mapper.AdviceStateEnumMapper;
import com.varial.personnel.domain.elo2.mapper.ReasonOfDeliveryEnumMapper;
import com.varial.personnel.domain.elo2.transfer.Elo2VorlaufsatzBean;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.global.taxoffice.TaxOffice;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.library.ReportFilterMapper;
import com.varial.personnel.domain.reports.library.ReportValues;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class Elo2Account
extends PersistentObject
implements IEmployeeReferenced {
    private static final int PRIORITY = 1;
    public static final String N = "N";
    public static final String J = "J";
    public static final String X = "X";
    public static final String K = "K";
    private Employee mEmployee;
    private Date mEffectiveFrom;
    private Date mValidFrom;
    private Date mValidUntil;
    private ReasonOfDeliveryEnum mReasonOfDelivery;
    private PCompany mPCompany;
    private Plant mPlant;
    private String mTaxnumber;
    private TaxOffice mTaxOffice;
    private String mCreatedOn;
    private boolean mTransmitted;
    private String mCanceled;
    private int mCurrentFileNumber;
    private Elo2Duean mElo2Duean;
    private Elo2Dueab mElo2Dueab;
    private Elo2Dueum mElo2Dueum;
    private Elo2Elstam mElo2Elstam;
    private String mErrorMessage;
    private AdviceStateEnum mAdviceState;
    private Date mTransmissionDate;
    private Master master;
    private Tax tax;
    private String mEmployerTaxNumber;
    private int mAnswerFileNumber;
    private String mOrdnungsMerkmal;
    private Elo2VorlaufsatzBean vorlaufSatzBeanForClient;
    private boolean mIsManual;
    private boolean mDeleted;
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("userPersistencyManager", IUserPersistencyManager.class);

    protected Elo2Account(int priority) {
        super(priority);
    }

    public Elo2Account(Employee employee) {
        super(1);
        this.mEmployee = employee;
    }

    public Elo2Account(Employee employee, boolean readOnly) {
        super(1, readOnly);
        this.mEmployee = employee;
    }

    public Elo2Account(String oid) {
        super(1, oid);
    }

    public Elo2Account(String objectId, int version) {
        super(1, objectId, version);
    }

    protected void load() {
        Elo2AccountPersistencyManager.load((Elo2Account)this);
    }

    protected void saveImpl() throws BusinessDomainException {
        Elo2AccountPersistencyManager.save((Elo2Account)this);
    }

    protected void deleteImpl() {
        Elo2AccountPersistencyManager.delete((Elo2Account)this);
    }

    public String getDomainKey() {
        this.requireLoaded();
        return DateMapper.toString((Date)this.mValidFrom) + " / " + this.mReasonOfDelivery.toString();
    }

    public static Elo2Account getElo2Account(String objectID) {
        return new Elo2Account(objectID);
    }

    public Elo2VorlaufsatzBean getVorlaufSatzBeanForClient() throws BusinessDomainException {
        if (this.vorlaufSatzBeanForClient == null) {
            this.vorlaufSatzBeanForClient = new Elo2VorlaufsatzBean();
            CompanyFoundations compFound = new ReportValues().getPCompanyFoundations(this.mPCompany.getObjectid(), VDate.getDateMax(), VDate.getDateMax());
            User user = userPersistencyManager.getUserByCode(this.getLastuser());
            String federalStateDesc = compFound.getFoundations().getFederalState().getActiveFederalStateTP().getLongDescription();
            this.vorlaufSatzBeanForClient.setDeFirma(compFound.getFoundations().getShortDescription());
            this.vorlaufSatzBeanForClient.setDeStr(compFound.getFoundations().getPostalAddress().getStreet());
            this.vorlaufSatzBeanForClient.setDePlz(compFound.getFoundations().getPostalAddress().getPostalCode());
            this.vorlaufSatzBeanForClient.setDeOrt(compFound.getFoundations().getPostalAddress().getCity());
            this.vorlaufSatzBeanForClient.setDeLand(federalStateDesc);
            this.vorlaufSatzBeanForClient.setArbgStnr(this.getEmployerTaxNumber());
            this.vorlaufSatzBeanForClient.setErstellungsdatum(this.getCreatedOn());
            this.vorlaufSatzBeanForClient.setUhrzeit(Elo2Advice.parseTimeFromTimestamp((String)this.getCreatedOn()));
            if (user == null) {
                this.vorlaufSatzBeanForClient.setDeAnsprech("");
                this.vorlaufSatzBeanForClient.setDeTelefon("");
                this.vorlaufSatzBeanForClient.setDeEmail("");
            } else {
                this.vorlaufSatzBeanForClient.setDeAnsprech(user.getName());
                this.vorlaufSatzBeanForClient.setDeTelefon(user.getPhone());
                this.vorlaufSatzBeanForClient.setDeEmail(user.getEmail());
            }
        }
        return this.vorlaufSatzBeanForClient;
    }

    public void setData(Elo2AccountData data) {
        this.mEmployee = data.getEmployee();
        this.mEffectiveFrom = data.getEffectiveFrom();
        this.mValidFrom = data.getValidFrom();
        this.mValidUntil = data.getValidUntil();
        this.mReasonOfDelivery = data.getReasonOfDelivery();
        this.mPCompany = data.getPCompany();
        this.mPlant = data.getPlant();
        this.mTaxnumber = data.getTaxnumber();
        this.mTaxOffice = data.getTaxOffice();
        this.mCreatedOn = data.getCreatedOn();
        this.mTransmitted = data.getTransmitted();
        this.mCanceled = data.getCanceled();
        this.mCurrentFileNumber = data.getCurrentFileNumber();
        this.mErrorMessage = data.getErrorMessage();
        this.mAdviceState = data.getAdviceState();
        this.mTransmissionDate = data.getTransmissionDate();
        this.mEmployerTaxNumber = data.getEmployerTaxNumber();
        this.mAnswerFileNumber = data.getAnswerFileNumber();
        this.mOrdnungsMerkmal = data.getOrdnungsMerkmal();
        this.mIsManual = data.getIsManual();
        this.mDeleted = data.isDeleted();
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public Date getEffectiveFrom() {
        this.requireLoaded();
        return this.mEffectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.mEffectiveFrom = effectiveFrom;
    }

    public Date getValidFrom() {
        this.requireLoaded();
        return this.mValidFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.mValidFrom = validFrom;
    }

    public Date getValidUntil() {
        this.requireLoaded();
        return this.mValidUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.mValidUntil = validUntil;
    }

    public ReasonOfDeliveryEnum getReasonOfDelivery() {
        this.requireLoaded();
        return this.mReasonOfDelivery;
    }

    public void setReasonOfDelivery(ReasonOfDeliveryEnum reasonOfDelivery) {
        this.mReasonOfDelivery = reasonOfDelivery;
    }

    public PCompany getPCompany() {
        this.requireLoaded();
        return this.mPCompany;
    }

    public void setPCompany(PCompany pCompany) {
        this.mPCompany = pCompany;
    }

    public Plant getPlant() {
        this.requireLoaded();
        return this.mPlant;
    }

    public void setPlant(Plant plant) {
        this.mPlant = plant;
    }

    public String getTaxnumber() {
        this.requireLoaded();
        return this.mTaxnumber;
    }

    public void setTaxnumber(String taxnumber) {
        this.mTaxnumber = taxnumber;
    }

    public TaxOffice getTaxOffice() {
        this.requireLoaded();
        return this.mTaxOffice;
    }

    public void setTaxOffice(TaxOffice taxOffice) {
        this.mTaxOffice = taxOffice;
    }

    public String getCreatedOn() {
        this.requireLoaded();
        return this.mCreatedOn;
    }

    public void setCreatedOn(String createdOn) {
        this.mCreatedOn = createdOn;
    }

    public boolean getTransmitted() {
        this.requireLoaded();
        return this.mTransmitted;
    }

    public void setTransmitted(boolean transmitted) {
        this.mTransmitted = transmitted;
    }

    public Date getTransmissionDate() {
        this.requireLoaded();
        return this.mTransmissionDate;
    }

    public void setTransmissionDate(Date transmissionDate) {
        this.mTransmissionDate = transmissionDate;
    }

    public String getCanceled() {
        this.requireLoaded();
        return this.mCanceled;
    }

    public void setCanceled(String canceled) {
        this.mCanceled = canceled;
    }

    public int getCurrentFileNumber() {
        this.requireLoaded();
        return this.mCurrentFileNumber;
    }

    public void setCurrentFileNumber(int currentFileNumber) {
        this.mCurrentFileNumber = currentFileNumber;
    }

    public int getAnswerFileNumber() {
        this.requireLoaded();
        return this.mAnswerFileNumber;
    }

    public void setAnswerFileNumber(int answerFileNumber) {
        this.mAnswerFileNumber = answerFileNumber;
    }

    public String getErrorMessage() {
        this.requireLoaded();
        return this.mErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public String getEmployerTaxNumber() {
        this.requireLoaded();
        return this.mEmployerTaxNumber;
    }

    public void setEmployerTaxNumber(String employerTaxNumber) {
        this.mEmployerTaxNumber = employerTaxNumber;
    }

    public String getOrdnungsMerkmal() {
        this.requireLoaded();
        return this.mOrdnungsMerkmal;
    }

    public void setOrdnungsMerkmal(String ordnungsMerkmal) {
        this.mOrdnungsMerkmal = ordnungsMerkmal;
    }

    public boolean getIsManual() {
        this.requireLoaded();
        return this.mIsManual;
    }

    public void setIsManual(boolean isManual) {
        this.mIsManual = isManual;
    }

    public boolean isDeleted() {
        this.requireLoaded();
        return this.mDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.mDeleted = deleted;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Elo2Duean getElo2Duean() {
        Criterion filter;
        Elo2Duean[] ans;
        if (this.mElo2Duean == null && (ans = Elo2DueanPersistencyManager.query(null, (Criterion)(filter = Restrictions.eq((String)"oidelo2account", (String)this.getObjectid())), (boolean)true)) != null && ans.length > 0) {
            this.mElo2Duean = ans[0];
        }
        return this.mElo2Duean;
    }

    public void setElo2Duean(Elo2Duean an) {
        this.mElo2Duean = an;
    }

    public Elo2Dueab getElo2Dueab() {
        Criterion filter;
        Elo2Dueab[] abs;
        if (this.mElo2Dueab == null && (abs = Elo2DueabPersistencyManager.query(null, (Criterion)(filter = Restrictions.eq((String)"oidelo2account", (String)this.getObjectid())), (boolean)true)) != null && abs.length > 0) {
            this.mElo2Dueab = abs[0];
        }
        return this.mElo2Dueab;
    }

    public void setElo2Dueab(Elo2Dueab ab) {
        this.mElo2Dueab = ab;
    }

    public Elo2Dueum getElo2Dueum() {
        Criterion filter;
        Elo2Dueum[] ums;
        if (this.mElo2Dueum == null && (ums = Elo2DueumPersistencyManager.query(null, (Criterion)(filter = Restrictions.eq((String)"oidelo2account", (String)this.getObjectid())), (boolean)true)) != null && ums.length > 0) {
            this.mElo2Dueum = ums[0];
        }
        return this.mElo2Dueum;
    }

    public void setElo2Dueum(Elo2Dueum um) {
        this.mElo2Dueum = um;
    }

    public Elo2Elstam getElo2Elstam() {
        Criterion filter;
        Elo2Elstam[] elstams;
        if (this.mElo2Elstam == null && (elstams = Elo2ElstamPersistencyManager.query(null, (Criterion)(filter = Restrictions.eq((String)"oidelo2account", (String)this.getObjectid())), (boolean)true)) != null && elstams.length > 0) {
            this.mElo2Elstam = elstams[0];
        }
        return this.mElo2Elstam;
    }

    public void addError(String errorMessage) {
        this.mErrorMessage = StringMapper.isNullString((String)this.getErrorMessage()) ? errorMessage : this.mErrorMessage.trim() + ", " + errorMessage;
        if (this.mErrorMessage.length() > 254) {
            this.mErrorMessage = this.mErrorMessage.substring(0, 254);
        }
    }

    public AdviceStateEnum getAdviceState() {
        return this.mAdviceState;
    }

    public void setAdviceState(AdviceStateEnum adviceState) {
        this.mAdviceState = adviceState;
    }

    public int getPersNr() {
        return this.mEmployee.getPersonnelnumber();
    }

    public String getPersonnelNumber() {
        if (this.mEmployee == null) {
            return "";
        }
        return Integer.toString(this.mEmployee.getPersonnelnumber());
    }

    public String getEmployeeDomainKey() {
        return this.mEmployee.getDomainKey();
    }

    public String getKzHag() {
        if (this.tax == null) {
            this.fetchTax();
        }
        if (this.tax != null) {
            return this.tax.getSidelineEmployer() ? N : J;
        }
        return "";
    }

    private void fetchTax() {
        this.tax = this.mEmployee.getActiveTax();
    }

    public String getSurName() throws BusinessDomainException {
        if (this.master == null) {
            if (this.mEmployee == null) {
                return "";
            }
            this.fetchMaster();
        }
        return this.master.getSurname();
    }

    public String getFirstName() throws BusinessDomainException {
        if (this.master == null) {
            if (this.mEmployee == null) {
                return "";
            }
            this.fetchMaster();
        }
        return this.master.getFirstname();
    }

    public String getBirthDateAsString() throws BusinessDomainException {
        if (this.master == null) {
            this.fetchMaster();
        }
        if (!StringMapper.isNullString((String)this.master.getDateOfBirthELSTAM())) {
            return this.master.getDateOfBirthELSTAM();
        }
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.master.getDateOfBirth());
    }

    private void fetchMaster() throws BusinessDomainException {
        this.master = this.mEmployee.getMaster(VDate.getDateMax(), VDate.getDateMax());
    }

    public static Elo2Account[] getAccountsByRod(String oidPCompany, ReasonOfDeliveryEnum reasonOfDelivery) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidpCompany", (String)oidPCompany));
        filter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)reasonOfDelivery)));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        Elo2Account[] accounts = Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom")}, (Criterion)filter, (boolean)true);
        return accounts;
    }

    public static Elo2Account[] getNewestAccountByRod(String oidPCompany, String oidEmployee, ReasonOfDeliveryEnum reasonOfDelivery) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidemployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"oidpCompany", (String)oidPCompany));
        filter.add(Restrictions.eq((String)"reasonofdelivery", (String)ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)reasonOfDelivery)));
        filter.add(Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        Elo2Account[] accounts = Elo2AccountPersistencyManager.query((Order[])new Order[]{Order.desc((String)"validfrom")}, (Criterion)filter, (boolean)true);
        return accounts;
    }

    public static Elo2Account[] getElo2Accounts(String oidPCompany, Date validFrom, Date validUntil, boolean registration, boolean suspension, boolean modification, boolean elstam, boolean onlyOpenAccounts, boolean withDeleted, ReportFirstFilterStruct firstfilter, ReportSecondFilterStruct[] secondfilters) {
        List employeeFilters = ReportFilterMapper.getFilterFromReportFilter((String)oidPCompany, (ReportFirstFilterStruct)firstfilter, (ReportSecondFilterStruct[])secondfilters);
        if (employeeFilters.size() == 0) {
            return new Elo2Account[0];
        }
        Criterion accFilter = Elo2Account.createFilterForGetElo2Accounts(validFrom, validUntil, registration, suspension, modification, elstam, onlyOpenAccounts, withDeleted);
        ArrayList<Elo2Account> result = new ArrayList<Elo2Account>();
        for (Criterion each : employeeFilters) {
            Criterion filter = Restrictions.and((Criterion)accFilter, (Criterion)each);
            Elo2Account[] accounts = Elo2AccountPersistencyManager.query(null, (Criterion)filter, (boolean)true);
            result.addAll(Arrays.asList(accounts));
        }
        ArrayList<Elo2Account> accountsToRemove = new ArrayList<Elo2Account>();
        for (Elo2Account acc : result) {
            if (acc.getReasonOfDelivery() != ReasonOfDeliveryEnum.ELSTAM || acc.getAdviceState() == AdviceStateEnum.RECEIPTCREATED) continue;
            accountsToRemove.add(acc);
        }
        result.removeAll(accountsToRemove);
        Collections.sort(result, new Comparator<Elo2Account>(){

            @Override
            public int compare(Elo2Account elo2Account1, Elo2Account elo2Account2) {
                return elo2Account1.getCreatedOn().compareTo(elo2Account2.getCreatedOn());
            }
        });
        return result.toArray(new Elo2Account[result.size()]);
    }

    private static Criterion createFilterForGetElo2Accounts(Date validFrom, Date validUntil, boolean registration, boolean suspension, boolean modification, boolean elstam, boolean onlyOpenAccounts, boolean withDeleted) {
        Criterion filterStructs = Restrictions.and((Criterion)Restrictions.lt((String)"createdon", (String)Elo2Advice.formatElo2TimestampForQuery((Date)DateHelper.tomorrow((Date)validUntil))), (Criterion)Restrictions.ge((String)"createdon", (String)Elo2Advice.formatElo2TimestampForQuery((Date)validFrom)));
        ArrayList<String> reasonOfDeliveries = new ArrayList<String>();
        if (registration) {
            reasonOfDeliveries.add(ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ANMELDUNG));
            reasonOfDeliveries.add(ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ANMELDUNG_SONSTIGERGRUND));
        }
        if (suspension) {
            reasonOfDeliveries.add(ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ABMELDUNG));
            reasonOfDeliveries.add(ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ABMELDUNG_SONSTIGERGRUND));
        }
        if (modification) {
            reasonOfDeliveries.add(ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.UMMELDUNG));
            reasonOfDeliveries.add(ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.UMMELDUNG_SONSTIGERGRUND));
        }
        if (elstam) {
            reasonOfDeliveries.add(ReasonOfDeliveryEnumMapper.toString((ReasonOfDeliveryEnum)ReasonOfDeliveryEnum.ELSTAM));
        }
        if (onlyOpenAccounts) {
            filterStructs = Restrictions.and((Criterion)filterStructs, (Criterion)Restrictions.ne((String)"additionalenum1", (String)AdviceStateEnumMapper.toString((AdviceStateEnum)AdviceStateEnum.RECEIPTCREATED)));
        }
        if (!reasonOfDeliveries.isEmpty()) {
            filterStructs = Restrictions.and((Criterion)filterStructs, (Criterion)Restrictions.in((String)"reasonofdelivery", (String[])reasonOfDeliveries.toArray(new String[reasonOfDeliveries.size()])));
        }
        if (!withDeleted) {
            filterStructs = Restrictions.and((Criterion)filterStructs, (Criterion)Restrictions.ne((String)"deleted", (String)BooleanMapper.toString((boolean)true)));
        }
        return filterStructs;
    }
}

