/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eel.eeldbvo;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvoPart;
import com.varial.personnel.domain.eel.eeldbvo.IEelDbvoPartPersistencyManager;
import com.varial.personnel.domain.eel.eeldbvo.IEelDbvoPersistencyManager;
import com.varial.personnel.domain.eel.eeldslw.EelDslw;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.ArrayList;
import java.util.Date;

public class EelDbvo
extends PersistentObject {
    private static final int PRIORITY = 10;
    private static final String DBVO = "DBVO";
    private final IEelDbvoPersistencyManager pm = (IEelDbvoPersistencyManager)UtilitiesManager.getBean((String)"eelDbvoPersistencyManager", IEelDbvoPersistencyManager.class);
    private int mGrundAv;
    private Date mAuAbag;
    private Date mAuAbsv;
    private int mKzAkau;
    private Date mMonatsfristab;
    private int mAnzahlAu;
    private EelDbvoPart[] mEelDbvoParts;
    private EelDslw mEelDslw;

    public EelDbvo() {
        super(10);
    }

    public static EelDbvo getEelDbvo(String objectID) {
        return new EelDbvo(objectID);
    }

    private EelDbvo(String objectID) {
        super(10, objectID);
    }

    public EelDbvo(String objectId, int version) {
        super(10, objectId, version);
    }

    protected EelDbvo(boolean readOnly) {
        super(10, readOnly);
    }

    public EelDbvo(EelDslw dslw) {
        this();
        this.mEelDslw = dslw;
    }

    protected void saveImpl() {
        this.pm.save(this);
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public EelDslw getEelDslw() {
        this.requireLoaded();
        return this.mEelDslw;
    }

    public void setEelDslw(EelDslw eelDslw) {
        this.mEelDslw = eelDslw;
    }

    public String getKennung() {
        this.requireLoaded();
        return DBVO;
    }

    public int getGrundAv() {
        this.requireLoaded();
        return this.mGrundAv;
    }

    public void setGrundAv(int grundAv) {
        this.mGrundAv = grundAv;
    }

    public Date getAuAbag() {
        this.requireLoaded();
        return this.mAuAbag;
    }

    public void setAuAbag(Date auAbag) {
        this.mAuAbag = auAbag;
    }

    public Date getAuAbsv() {
        this.requireLoaded();
        return this.mAuAbsv;
    }

    public void setAuAbsv(Date auAbsv) {
        this.mAuAbsv = auAbsv;
    }

    public int getKzAkau() {
        this.requireLoaded();
        return this.mKzAkau;
    }

    public void setKzAkau(int kzAkau) {
        this.mKzAkau = kzAkau;
    }

    public Date getMonatsfristab() {
        this.requireLoaded();
        return this.mMonatsfristab;
    }

    public void setMonatsfristab(Date monatsfristab) {
        this.mMonatsfristab = monatsfristab;
    }

    public int getAnzahlAu() {
        this.requireLoaded();
        return this.mAnzahlAu;
    }

    public void setAnzahlAu(int anzahlAu) {
        this.mAnzahlAu = anzahlAu;
    }

    public EelDbvoPart[] getEelDbvoParts() {
        if (this.mEelDbvoParts == null) {
            this.mEelDbvoParts = this.isNew() ? new EelDbvoPart[0] : ((IEelDbvoPartPersistencyManager)UtilitiesManager.getBean((String)"eelDbvoPartPersistencyManager", IEelDbvoPartPersistencyManager.class)).query(new Order[]{Order.desc((String)"beginnau")}, Restrictions.eq((String)"oideeldbvo", (String)this.getObjectid()), true);
        }
        return this.mEelDbvoParts;
    }

    public void setEelDbvoParts(EelDbvoPart[] eelDbvoParts) throws BusinessDomainException {
        this.mEelDbvoParts = this.getEelDbvoParts();
        if (this.mEelDbvoParts != null) {
            for (EelDbvoPart eelDbvoPart : this.mEelDbvoParts) {
                if (eelDbvoPart.isNew()) continue;
                eelDbvoPart.makeSaveable();
                eelDbvoPart.destroy();
            }
        }
        this.mEelDbvoParts = eelDbvoParts;
    }

    public EelDbvo createNew(EelDslw dslw) throws BusinessDomainException {
        this.requireLoaded();
        EelDbvo bo = dslw.createDbvo();
        bo.mGrundAv = this.mGrundAv;
        bo.mAuAbag = this.mAuAbag;
        bo.mAuAbsv = this.mAuAbsv;
        bo.mKzAkau = this.mKzAkau;
        bo.mAnzahlAu = this.mAnzahlAu;
        bo.mMonatsfristab = this.mMonatsfristab;
        EelDbvoPart[] parts = new EelDbvoPart[this.getEelDbvoParts().length];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.getEelDbvoParts()[i].createNew(bo);
        }
        bo.setEelDbvoParts(parts);
        return bo;
    }

    public EelDbvo createNewForReason11and12(EelDslw dslw) throws BusinessDomainException {
        this.requireLoaded();
        EelDbvo bo = dslw.createDbvo();
        ArrayList<EelDbvoPart> parts = new ArrayList<EelDbvoPart>();
        for (int i = 0; i < this.getEelDbvoParts().length; ++i) {
            if (this.getEelDbvoParts()[i].getKzAu() != 1 && this.getEelDbvoParts()[i].getKzAu() != 5) continue;
            EelDbvoPart part = this.getEelDbvoParts()[i].createNew(bo);
            part.setKzAu(1);
            part.setKzNachweis(0);
            part.setTeilNachweisAuBeginn(null);
            part.setTeilNachweisAuEnde(null);
            part.setTeilAnrAuBeginn(null);
            part.setTeilAnrAuEnde(null);
            parts.add(part);
            if (this.getEelDbvoParts()[i].getKzAu() != 5) continue;
            part.setBeginnAu(this.getEelDbvoParts()[i].getTeilAnrAuBeginn());
            part.setEndeAu(this.getEelDbvoParts()[i].getTeilAnrAuEnde());
        }
        if (parts.size() < 1) {
            return null;
        }
        bo.mGrundAv = 3;
        bo.mAuAbag = this.mAuAbag;
        bo.setAuAbsv(null);
        bo.mAnzahlAu = parts.size();
        bo.setEelDbvoParts(parts.toArray(new EelDbvoPart[parts.size()]));
        return bo;
    }

    public String toString() {
        return "EelDbvo [mGrundAv=" + this.mGrundAv + ", mAuAbag=" + this.mAuAbag + ", mAuAbsv=" + this.mAuAbsv + ", mKzAkau=" + this.mKzAkau + ", mAnzahlAu=" + this.mAnzahlAu + ", mMonatsfristab=" + this.mMonatsfristab + "]";
    }

    public String getGrund() {
        return "" + this.getGrundAv();
    }

    public String getAuBeginn() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getAuAbag());
    }

    public String getAuBeginnSV() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getAuAbsv());
    }

    public String getKzak() {
        return "" + this.getKzAkau();
    }

    public Boolean getHasParts() {
        if (this.getEelDbvoParts().length > 0) {
            return true;
        }
        return false;
    }

    public String getMonatsfristabR() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getMonatsfristab());
    }
}

