/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau.mapper;

import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.mapper.ExceptionMapper;

public class EauExceptionMapper {
    private static final String CLASS_GENERAL = "PYEau";
    private static final int NO_RESPONSE_FOR_SUCCESSION = 10;
    private static final int NO_DELETE_ALLOWED = 11;
    private static final int CANCELLATION_NOT_ALLOWED = 12;
    private static final int NO_MESSAGES_CREATED = 13;
    private static final int SUCCESSION_NOT_ALLOWED = 14;
    private static final int RETRY_NOT_ALLOWED = 15;
    private static final int RETRY_NOT_ALLOWED_DAYS_LATER = 16;
    private static final int NO_MESSAGES_FOR_TRANSFER = 17;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYEau", new ErrorMessage[]{new ErrorMessage(10, "F\u00fcr diese Meldung kann erst ein Folgeabruf erzeugt werden wenn eine R\u00fcckmeldung mit AU-Zeitraum eingelesen wurde."), new ErrorMessage(11, "Diese Meldung kann nicht gel\u00f6scht werden, da sie bereits \u00fcbermittelt wurde."), new ErrorMessage(12, "Diese Meldung kann nicht storniert werden, da sie noch nicht \u00fcbermittelt, bereits storniert oder R\u00fcckmeldungen mit AU-Zeitr\u00e4umen eingelesen wurden."), new ErrorMessage(13, "Es konnten keine Meldungen aufgebaut werden."), new ErrorMessage(14, "F\u00fcr diese Meldung kann fr\u00fchstens am ersten Kalendertag nach Ende der Vor-AU ein Folgeabruf erzeugt werden."), new ErrorMessage(15, "Der erneute Erstabruf ist nicht m\u00f6glich bzw. nicht notwendig, da der Erstabruf noch nicht \u00fcbermittelt wurde."), new ErrorMessage(16, "Aufgrund entsprechender R\u00fcckmeldungen gibt es eine Sperrfrist f\u00fcr den erneuten Abruf: "), new ErrorMessage(17, "Keine ungesendeten Meldungen vorhanden.")});

    public static BusinessDomainException makeMissingResponseForSuccessionException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)10, (String)mErrorList.getDefaultString(10));
    }

    public static BusinessDomainException makeNoDeleteAllowedDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)message, (int)11, (String)mErrorList.getDefaultString(11));
    }

    public static BusinessDomainException makeCancellationNotAllowedDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)message, (int)12, (String)mErrorList.getDefaultString(12));
    }

    public static BusinessDomainException makeNoMessagesDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)13, (String)mErrorList.getDefaultString(13));
    }

    public static BusinessDomainException makeSuccessionNotAllowedException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)14, (String)mErrorList.getDefaultString(14));
    }

    public static BusinessDomainException makeRetryNotAllowedException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)15, (String)mErrorList.getDefaultString(15));
    }

    public static BusinessDomainException makeCancellationNotAllowedDaysLaterDomainException(String message, int days, String kz) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)("Kennzeichen der R\u00fcckmeldung: " + kz + "\\\\nSperrfrist: " + days + " Tag(e)\\\\n" + message), (int)16, (String)mErrorList.getDefaultString(16));
    }

    public static BusinessDomainException makeNoMessagesForTransferDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)17, (String)mErrorList.getDefaultString(17));
    }
}

