/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuvmessaging;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuvmessaging.mapper.DeuvmessagingExceptionMapper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public final class SiVersionCheck {
    private static final LocalDate GLOBAL_MAXDATE_JW = LocalDate.of(2026, 2, 28);
    private static final LocalDate GLOBAL_MAXDATE = LocalDate.of(2027, 2, 28);

    private SiVersionCheck() {
    }

    public static String getVersionWarningMessage(Type type) {
        String result = null;
        if (SiVersionCheck.isVersionWarningNecessary(type)) {
            result = "Achtung! Sie nutzen eine alte Datensatzversion, die nur noch bis zum " + SiVersionCheck.getMaxDate(type).format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + " \u00fcbermittelt werden darf. Die Installation des neuen Releases ist erforderlich!";
        }
        return result;
    }

    public static void checkVersionValidness(Type type) throws BusinessDomainException {
        SiVersionCheck.checkVersionValidness(type, true);
    }

    public static BusinessDomainException checkVersionValidness(Type type, boolean throwException) throws BusinessDomainException {
        BusinessDomainException exception = null;
        if (SiVersionCheck.isVersionInvalid(type)) {
            String errorMessage = "Sie nutzen eine ung\u00fcltige Datensatzversion, die ab " + SiVersionCheck.getMaxDate(type).plusDays(1L).format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + " nicht mehr \u00fcbermittelt werden darf. Installieren Sie den neuen Releasestand!";
            exception = DeuvmessagingExceptionMapper.makeSiVersionCheckDomainException((String)errorMessage);
        }
        if (throwException && exception != null) {
            throw exception;
        }
        return exception;
    }

    private static boolean isVersionWarningNecessary(Type type) {
        return LocalDate.now().plusMonths(1L).isAfter(SiVersionCheck.getMaxDate(type));
    }

    private static boolean isVersionInvalid(Type type) {
        return LocalDate.now().isAfter(SiVersionCheck.getMaxDate(type));
    }

    private static LocalDate getMaxDate(Type type) {
        switch (type) {
            case DEUV: {
                return GLOBAL_MAXDATE_JW;
            }
            case DSBD: {
                return GLOBAL_MAXDATE;
            }
            case DSAK: {
                return GLOBAL_MAXDATE;
            }
            case DSVV: {
                return GLOBAL_MAXDATE;
            }
            case AAG: {
                return GLOBAL_MAXDATE;
            }
            case EEL: {
                return GLOBAL_MAXDATE_JW;
            }
            case ZMV: {
                return GLOBAL_MAXDATE;
            }
            case AEINS: {
                return GLOBAL_MAXDATE;
            }
            case EAU: {
                return GLOBAL_MAXDATE;
            }
        }
        return GLOBAL_MAXDATE;
    }

    public static enum Type {
        DEUV,
        DSBD,
        DSAK,
        DSVV,
        AAG,
        EEL,
        ZMV,
        AEINS,
        EAU;

    }
}

