/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.personnel.domain.deuv.DeuvComponents;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.TypeOfAccountEnum;
import com.varial.personnel.domain.deuv.deuvdsbd.DEUVDsbd;
import com.varial.personnel.domain.deuv.deuvdsbd.DEUVDsbdPersistencyManager;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.BasicAcknowledgement;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.basictypes.FileWithText;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeuvAcknowledgement
extends BasicAcknowledgement<DEUVAccount> {
    public static final String[] FILENAMEFILTER = new String[]{"EDUA0", "TDUA0"};
    private static final String VF = "DEUEV";
    private static final String VFMM_AGSV = "(?:AGDEU|AGTRV|AGBVD)";
    private static final String VFMM_SVAG = "(?:KVDEU|RVTAG|BVAGD)";
    private static final Pattern DSME_V10 = Pattern.compile(DeuvComponents.getDsmePattern_V10("DEUEV"));
    private static final Pattern DSME_V11 = Pattern.compile(DeuvComponents.getDsmePattern_V11("DEUEV"));
    private static final Pattern DSBD_V04 = Pattern.compile("DSBDBTRAG(?<ABSN>.{15})(?<EPNR>.{15})04(?<ED>\\d{20})\\d(?<FEHLERANZ>\\d)(?<BBNRBB>.{15})(?<DTEREIGNIS>\\d{8}).{3}(?<BBNRAS>.{15})(?<GD>.{2}).{5}.{30}.{30}.{30}.{10}.{34}.{33}.{9}(?<RF>\\d{3})(?<RFERG>\\d{2}).{5}.{10}(?<KENNZEND>[ B]).{15}.{1}.{30}.{20}.{20}.{70}(?<AZVU>.{20})(?<DsId>.{32})(?<KENNZNAME>[JN])(?<KENNZANSCHRIFT>[JN])(?<KENNZANSPRECH>[JN]).{7}.{8}(?<MMPA>[JN])(?<MMTN>[JN]).{5}(?<DatenBausteine>.*)");
    private static final Pattern DSBD_V05 = Pattern.compile("DSBDBTRAG(?<ABSN>.{15})(?<EPNR>.{15})05(?<ED>\\d{20})\\d(?<FEHLERANZ>\\d)(?<BBNRBB>.{15})(?<DTEREIGNIS>\\d{8}).{3}(?<BBNRAS>.{15})(?<GD>.{2}).{5}.{30}.{30}.{30}.{10}.{34}.{33}.{9}(?<RF>\\d{3})(?<RFERG>\\d{2})(?<UNRS>\\d{15})(?<KENNZEND>[ B]).{15}(?<KENNZUNRS>[JN]).{30}.{20}.{20}.{70}(?<AZVU>.{20})(?<DsId>.{32})(?<KENNZNAME>[JN])(?<KENNZANSCHRIFT>[JN])(?<KENNZANSPRECH>[JN]).{7}.{8}(?<MMPA>[JN])(?<MMTN>[JN]).{5}(?<DatenBausteine>.*)");
    private static final Pattern DSFZ = Pattern.compile("DSFZDEUEV(?<KENNZST>[JN])(?<ABSN>.{15})(?<EPNR>.{15})01(?<ED>\\d{20}).{7}.{8}(?<DsId>.{32})(?<DsIdUr>.{32})\\d(?<FEHLERANZ>\\d)(?<BBNRVU>.{15})(?<AZVU>.{20})(?<BBNRAS>.{15})(?<VSNR>.{12})(?<GD>\\d{2})(?<BE>\\d{8})(?<EE>\\d{8}).{100}(?<MMNA>[JN])(?<MMGB>[JN])(?<MMAN>[JN])(?<DatenBausteine>.*)");
    public static final String DSME_WARNING = "DSMEH";
    private static final Map<Integer, List<FileWithText>> mImportedFileNumbers = new HashMap<Integer, List<FileWithText>>();

    public DeuvAcknowledgement(DEUVSender deuvSender) {
        super(deuvSender);
    }

    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    public String getProcedureName() {
        return "DE\u00dcV-Meldeverfahren";
    }

    protected String getVF() {
        return VF;
    }

    protected String getVFMM_AG_SV() {
        return VFMM_AGSV;
    }

    protected String getVFMM_SV_AG() {
        return VFMM_SVAG;
    }

    protected PerfidiaDataType getPerfidiaDataType() {
        return PerfidiaDataType.AGDEU;
    }

    public void processFiles(DEUVRecipient deuvRecipient) throws BusinessDomainException {
        mImportedFileNumbers.clear();
        super.processFiles(deuvRecipient);
    }

    protected void processErrorFreeFile(File file, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        if (!this.checkAlreadyImported(file, fileNumberSend, null)) {
            for (DEUVAccount account : this.getDeuvAccountsForFilenumber(fileNumberSend)) {
                account.setAdviceState(AdviceStateEnum.ERFOLGREICH);
            }
            for (DEUVDsbd dsbd : this.getDsbdsForFilenumber(fileNumberSend)) {
                dsbd.setAdviceState(AdviceStateEnum.ERFOLGREICH);
            }
            this.addFileNumberToMap(file, fileNumberSend, null);
            this.addFileForReport(file, this.getAdviceStateDesc(AdviceStateEnum.ERFOLGREICH));
        }
    }

    protected void processFileError(File file, int fileNumberSend, int fileNumberRecv, String errors) throws BusinessDomainException {
        if (!this.checkAlreadyImported(file, fileNumberSend, errors)) {
            for (DEUVAccount account : this.getDeuvAccountsForFilenumber(fileNumberSend)) {
                if (account.getAdviceState() == AdviceStateEnum.ERFOLGREICH) continue;
                account.setAdviceState(AdviceStateEnum.FEHLER_DATEI);
                account.setErrorMessage(errors);
            }
            for (DEUVDsbd dsbd : this.getDsbdsForFilenumber(fileNumberSend)) {
                dsbd.setAdviceState(AdviceStateEnum.FEHLER_DATEI);
                dsbd.setErrorMessage(errors);
            }
            this.addFileNumberToMap(file, fileNumberSend, errors);
            this.addFileForReport(file, this.getAdviceStateDesc(AdviceStateEnum.FEHLER_DATEI) + errors);
        }
    }

    protected void processDatasetErrors(File file, int fileNumberSend, int fileNumberRecv, List<String> datasets) throws BusinessDomainException {
        List<DEUVAccount> accounts = this.getDeuvAccountsForFilenumber(fileNumberSend);
        List<DEUVDsbd> dsbds = this.getDsbdsForFilenumber(fileNumberSend);
        for (String dataSet : datasets) {
            if (dataSet.startsWith("DSBD")) {
                this.processDsbdError(dataSet, dsbds);
                continue;
            }
            if (dataSet.startsWith("DSFZ")) {
                this.processDsfzError(dataSet, accounts);
                continue;
            }
            this.processDsmeError(dataSet, accounts);
        }
        for (DEUVAccount account : accounts) {
            account.setAdviceState(AdviceStateEnum.ERFOLGREICH);
        }
        for (DEUVDsbd dsbd : dsbds) {
            dsbd.setAdviceState(AdviceStateEnum.ERFOLGREICH);
        }
        this.addFileForReport(file, accounts.isEmpty() && dsbds.isEmpty());
    }

    private List<DEUVAccount> getDeuvAccountsForFilenumber(int fileNumber) {
        Criterion filter = Restrictions.and((Criterion)Restrictions.eq((String)DEUVAccountPersistencyManager.CURRENTFILENUMBER, (String)String.valueOf(fileNumber)), (Criterion)this.getSenderRecipientFilter());
        ArrayList<DEUVAccount> result = new ArrayList<DEUVAccount>();
        for (DEUVAccount account : DEUVAccountPersistencyManager.query(null, (Criterion)filter)) {
            account.makeSaveable();
            result.add(account);
        }
        return result;
    }

    private List<DEUVDsbd> getDsbdsForFilenumber(int fileNumber) {
        Criterion filter = Restrictions.and((Criterion)Restrictions.eq((String)"CURRENTFILENUMBER", (String)String.valueOf(fileNumber)), (Criterion)this.getSenderRecipientFilter());
        ArrayList<DEUVDsbd> result = new ArrayList<DEUVDsbd>();
        for (DEUVDsbd account : DEUVDsbdPersistencyManager.query(null, (Criterion)filter, (boolean)false)) {
            account.makeSaveable();
            result.add(account);
        }
        return result;
    }

    private void processDsmeError(String dataSet, List<DEUVAccount> accounts) throws BusinessDomainException {
        DEUVAccount account;
        Matcher matcherDsme = this.checkInputGetMatcher(dataSet, 559, DSME_V10, false);
        if (matcherDsme == null) {
            matcherDsme = this.checkInputGetMatcher(dataSet, 559, DSME_V11);
        }
        if ((account = this.findMessageSend(matcherDsme, accounts)) != null) {
            this.checkForInvalidInsuranceNo(account);
        }
    }

    private void processDsfzError(String dataSet, List<DEUVAccount> accounts) throws BusinessDomainException {
        Matcher matcherDsfz = this.checkInputGetMatcher(dataSet, 326, DSFZ);
        DEUVAccount account = this.findMessageSend(matcherDsfz, accounts);
        if (account == null) {
            // empty if block
        }
    }

    private void processDsbdError(String dataSet, List<DEUVDsbd> dsbds) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(dataSet, 541, DSBD_V04, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(dataSet, 541, DSBD_V05);
        }
        boolean found = false;
        String datensatzId = matcher.group("DsId");
        for (DEUVDsbd dsbd : dsbds) {
            if (!StringMapper.equalWithTrim((String)dsbd.getDatensatzId(), (String)datensatzId)) continue;
            found = true;
            int anzFehler = Integer.valueOf(matcher.group("FEHLERANZ"));
            if (anzFehler > 0) {
                String rest = matcher.group("DatenBausteine");
                String errors = this.getDbfeErrorString(this.getDbfes(rest));
                dsbd.setAdviceState(AdviceStateEnum.FEHLER_KERNPRUEFUNG);
                dsbd.setErrorMessage(errors);
            }
            dsbds.remove(dsbd);
            break;
        }
        if (!found) {
            // empty if block
        }
    }

    private DEUVAccount findMessageSend(Matcher matcher, List<DEUVAccount> accounts) {
        DEUVAccount found = null;
        String datensatzId = matcher.group("DsId");
        for (DEUVAccount account : accounts) {
            String datensatzIdCheck = account.getTypeOfAccount() == TypeOfAccountEnum.DSME ? account.getDEUVDsme().getDatensatzId() : account.getDeuvDsfz().getDsid();
            if (!StringMapper.equalWithTrim((String)datensatzIdCheck, (String)datensatzId)) continue;
            found = account;
            int anzFehler = Integer.valueOf(matcher.group("FEHLERANZ"));
            if (anzFehler > 0) {
                String rest = matcher.group("DatenBausteine");
                List dbfes = this.getDbfeList(rest);
                String errors = this.getDbfeErrorString(this.getDbfes(rest));
                if (this.hasOnlyDsmeWarnings(dbfes)) {
                    account.setAdviceState(AdviceStateEnum.ERFOLGREICH);
                    account.setErrorMessage("Hinweis: " + errors);
                } else {
                    account.setAdviceState(AdviceStateEnum.FEHLER_KERNPRUEFUNG);
                    account.setErrorMessage(errors);
                }
                if (account.getTypeOfAccount() == TypeOfAccountEnum.DSME) {
                    this.mDatasetsWithErrors.add(account);
                }
            }
            accounts.remove((Object)account);
            break;
        }
        return found;
    }

    private boolean hasOnlyDsmeWarnings(List<String> dbfes) {
        for (String dbfe : dbfes) {
            if (dbfe.startsWith(DSME_WARNING)) continue;
            return false;
        }
        return true;
    }

    private void checkForInvalidInsuranceNo(DEUVAccount account) {
        if (DeuvHelper.isVsnrError((String)account.getErrorMessage())) {
            this.createInsuranceNoTaskReminder(account.getEmployee());
        }
    }

    private void createInsuranceNoTaskReminder(Employee employee) {
        String message = TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber(employee, "Versicherungs-Nr. ist ung\u00fcltig und muss ersetzt werden!");
        String advice = " Versicherungs-Nr. in Mitarbeiter - Sozialversicherung l\u00f6schen und Versicherungsnummernabfrage durchf\u00fchren.";
        TaskReminderHelper.createTaskReminder(message, new Date(), message + " Versicherungs-Nr. in Mitarbeiter - Sozialversicherung l\u00f6schen und Versicherungsnummernabfrage durchf\u00fchren.");
    }

    private boolean checkAlreadyImported(File file, int fileNumberSend, String errors) {
        if (mImportedFileNumbers.containsKey(fileNumberSend)) {
            List<FileWithText> files = mImportedFileNumbers.get(fileNumberSend);
            if (!"DBFENCSZH10".equals(files.get(0).getText())) {
                mImportedFileNumbers.get(fileNumberSend).add(new FileWithText(file, errors == null ? "DBFENCSZH10" : errors));
            }
            return true;
        }
        return false;
    }

    private void addFileNumberToMap(File file, int fileNumberSend, String errors) {
        ArrayList<FileWithText> files = new ArrayList<FileWithText>();
        files.add(new FileWithText(file, errors == null ? "DBFENCSZH10" : errors));
        mImportedFileNumbers.put(fileNumberSend, files);
    }

    public Map<Integer, List<FileWithText>> getImportedfilenumbers() {
        return mImportedFileNumbers;
    }
}

