/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv.dsvv.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvComponents;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuv.dsvv.receive.VsnrReceiveData;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dban;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbgb;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbna;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.framework.PFileHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RvsnrReceive
extends BasicReceive<VsnrReceiveData> {
    private static final String[] FILENAMEFILTER = new String[]{"EVSA0", "TVSA0"};
    private static final Pattern VOSZ_KVRV_AG = RvsnrReceive.getVoszPattern("(KVDEU|RVTAG)");
    private static final Pattern DSME_V10 = Pattern.compile(DeuvComponents.getDsmePattern_V10("RVSNR"));
    private static final Pattern DSME_V11 = Pattern.compile(DeuvComponents.getDsmePattern_V11("RVSNR"));

    public RvsnrReceive(DEUVSender deuvSender) {
        super(deuvSender);
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    @Override
    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile(file, "R\u00fcckmeldung Sozialversicherungsnummer");
        LinkedList<String> records = PFileHelper.getFileLines(file, "ISO-8859-1");
        Matcher matcherVosz = VOSZ_KVRV_AG.matcher((CharSequence)records.getFirst());
        return matcherVosz.matches();
    }

    @Override
    public String getProcedureName() {
        return "R\u00fcckmeldungen SV-Nummern";
    }

    @Override
    public String getFileDescription() {
        return "R\u00fcckmeldung(en)";
    }

    @Override
    public String getActionName() {
        return "importieren";
    }

    public void readRvsnrs() throws BusinessDomainException {
        this.initFiles();
        Iterator iterator = this.mFiles.keySet().iterator();
        while (iterator.hasNext()) {
            DEUVRecipient each;
            this.mRecipient = each = (DEUVRecipient)iterator.next();
            for (File file : (List)this.mFiles.get(each)) {
                this.readReceivedsForFile(file);
            }
        }
    }

    private void readReceivedsForFile(File input) throws BusinessDomainException {
        this.mCurrent = input;
        LinkedList<String> records = PFileHelper.getFileLines(input, "ISO-8859-1");
        Matcher matcherVosz = VOSZ_KVRV_AG.matcher((CharSequence)records.getFirst());
        if (matcherVosz.matches()) {
            records.pollFirst();
            records.pollLast();
            while (!records.isEmpty()) {
                VsnrReceiveData vsnr = this.createVsnrReceive((String)records.pollFirst());
                this.mImporteds.add(vsnr);
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcherVosz);
        }
        this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.RVSNR, this.mRecipient, Integer.parseInt(matcherVosz.group(2)));
        this.mPerfidiaResult.addReceivedFile(input);
    }

    private VsnrReceiveData createVsnrReceive(String input) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 559, DSME_V10, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(input, 559, DSME_V11);
        }
        VsnrReceiveData vsnr = this.initDsme(matcher);
        String rest = matcher.group("DatenBausteine");
        if (vsnr.hasMmme()) {
            rest = rest.substring(147);
        }
        if (vsnr.hasMmna()) {
            Dbna dbna = new Dbna();
            vsnr.setDbna(dbna);
            rest = this.initDbna(rest, dbna);
        }
        if (vsnr.hasMmgb()) {
            Dbgb dbgb = new Dbgb();
            vsnr.setDbgb(dbgb);
            rest = this.initDbgb(rest, dbgb);
        }
        if (vsnr.hasMman()) {
            Dban dban = new Dban();
            vsnr.setDban(dban);
            this.initDban(rest, dban);
        }
        return vsnr;
    }

    private VsnrReceiveData initDsme(Matcher matcher) {
        int i = 3;
        String vsnr = this.asString(matcher.group(i++));
        String bbnrvu = this.asString(matcher.group(i++));
        String azvu = this.asString(matcher.group(i++));
        i += 3;
        boolean mmme = this.asBoolean(matcher.group(i++));
        boolean mmna = this.asBoolean(matcher.group(i++));
        boolean mmgb = this.asBoolean(matcher.group(i++));
        boolean mman = this.asBoolean(matcher.group(i++));
        Employee employee = Deuv.findEmployeeByAz((String)azvu);
        VsnrReceiveData vsnrReceive = new VsnrReceiveData(employee);
        if (employee == null) {
            vsnrReceive.setErrorMessage("Zuordnung zu einem Mitarbeiter nicht m\u00f6glich!");
        }
        vsnrReceive.setVersicherungsnr(vsnr);
        vsnrReceive.setAzvu(azvu);
        vsnrReceive.setBbnrvu(bbnrvu);
        vsnrReceive.setMmme(mmme);
        vsnrReceive.setMmna(mmna);
        vsnrReceive.setMmgb(mmgb);
        vsnrReceive.setMman(mman);
        vsnrReceive.setPerfidiaFile(this.mCurrent.getPath());
        vsnrReceive.setReceiveType(VsnrReceiveData.RvsnrReceiveType.RVSNR);
        return vsnrReceive;
    }
}

