/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.servantimpl.eau;

import com.infor.igf.core.persistency.PersistencyContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.eau.EauAccountStruct;
import com.varial.personnel.domain.eau.EauAdviceStruct;
import com.varial.personnel.domain.eau.EauInformationStruct;
import com.varial.personnel.domain.eau.EauPresetStruct;
import com.varial.personnel.domain.eau.advice.EauAdvice;
import com.varial.personnel.domain.eau.advice.mapper.EauAdviceMapper;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eauaccount.EauAdviceStateEnum;
import com.varial.personnel.domain.eau.eauaccount.IEauAccountPersistencyManager;
import com.varial.personnel.domain.eau.eauaccount.mapper.EauAccountMapper;
import com.varial.personnel.domain.eau.eaudxag.EauDxag;
import com.varial.personnel.domain.eau.eauinformation.IEauInformationPersistencyManager;
import com.varial.personnel.domain.eau.eauinformation.mapper.EauInformationMapper;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVCompanyStruct;
import com.varial.personnel.domain.reports.eau.EauAccountReport;
import com.varial.personnel.domain.reports.eau.EauProtocolReport;
import com.varial.personnel.domain.reports.eau.EauTransferProtocolReport;
import com.varial.personnel.domain.reports.eau.receive.EauReceiveProtocolReport;
import com.varial.personnel.framework.access.PersonnelRightList;
import com.varial.personnel.framework.filter.EmployeeExtendedFilterStruct;
import com.varial.personnel.persistency.eau.eauinformation.EauinformationContainer;
import com.varial.personnel.servantimpl.eau.EauServantService;
import com.varial.personnel.servantimpl.employee.SpecialAccessServantBase;
import com.varial.serverbase.mapper.DateMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EauServantImpl
extends SpecialAccessServantBase
implements EauServantService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEauData(AuthorizationToken token, String oidPCompany, EauPresetStruct[] eauPresetSeq, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEauAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EauProtocolReport command = new EauProtocolReport(token, callback, oidPCompany, eauPresetSeq);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSuccessionEauData(AuthorizationToken token, String oidPCompany, String oidEauAccount) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEauAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EauAccount account = EauAccount.getEauAccount(oidEauAccount);
            account = account.getLastSuccessor();
            EauAdvice advice = new EauAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany));
            EauAccount succession = advice.createSuccession(account);
            advice.checkAttributes(succession);
            if (!succession.hasErrors()) {
                succession.setAdviceState(EauAdviceStateEnum.BEREIT);
            }
            succession.makeSaveable();
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryRequest(AuthorizationToken token, String oidPCompany, String oidEauAccount) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEauAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EauAccount account = EauAccount.getEauAccount(oidEauAccount);
            EauAdvice advice = new EauAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany));
            EauAccount retry = advice.retry(account);
            advice.checkAttributes(retry);
            if (!retry.hasErrors()) {
                retry.setAdviceState(EauAdviceStateEnum.BEREIT);
            }
            retry.makeSaveable();
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EauAdviceStruct getEauAdvice(AuthorizationToken token, String oidEauAccount) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            EauAccount account = EauAccount.getEauAccount(oidEauAccount);
            token.checkAccess(PersonnelRightList.getReadEauAccount(), account.getEmployee().getPCompany().getObjectid());
            EauAdviceStruct eauAdviceStruct = EauAdviceMapper.toIdl((EauAccount)account);
            return eauAdviceStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEauAccounts(AuthorizationToken token, String oidPCompany, EauAccountStruct[] accountSeq) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEauAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            for (EauAccountStruct accountStruct : accountSeq) {
                EauAccount account = EauAccount.getEauAccount(accountStruct.oidTs.objectid);
                account.setEmployee(EauServantImpl.getIEmployeePM().getEmployee(accountStruct.oidEmployee));
                EauAdvice advice = new EauAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany));
                advice.deleteAccount(account);
            }
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEauAccount(AuthorizationToken token, String oidPCompany, String oidEauAccount) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEauAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EauAccount account = EauAccount.getEauAccount(oidEauAccount);
            EauAdvice advice = new EauAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany));
            advice.makeCancellation(account);
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeEauDataTransfer(AuthorizationToken token, DEUVCompanyStruct[] companySeq, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEauFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EauTransferProtocolReport command = new EauTransferProtocolReport(token, callback, companySeq);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveEauDataTransfer(AuthorizationToken token, String oidDEUVSender, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeEauFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EauReceiveProtocolReport command = new EauReceiveProtocolReport(token, callback, oidDEUVSender);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printEauAccount(AuthorizationToken token, String oidPCompany, String oidEauAccount, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            token.checkAccess(PersonnelRightList.getReadEauAccount(), oidPCompany);
            EauAccountReport command = new EauAccountReport(token, callback, oidEauAccount);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EauAccountStruct setEauData(AuthorizationToken token, String oidPCompany, EauAccountStruct eauAccount, EauAdviceStruct eauAdvice) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEauAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EauAccount account = new EauAccount(eauAccount.oidTs.objectid, eauAccount.oidTs.version);
            EauAccountMapper.fillEauAccount((EauAccount)account, (EauAccountStruct)eauAccount);
            EauDxag dxag = new EauDxag(account.getEauDxag().getObjectid());
            EauAdviceMapper.fillDxag((EauDxag)dxag, (EauAdviceStruct)eauAdvice);
            account.setEauDxag(dxag);
            dxag.makeSaveable();
            dxag.setDatensatzid(account.getObjectid());
            EauAdvice advice = new EauAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany));
            account.setErrorMessage("");
            account.setAdviceState(EauAdviceStateEnum.AUFGEBAUT);
            advice.checkAttributes(account);
            if (!account.hasErrors()) {
                account.setAdviceState(EauAdviceStateEnum.BEREIT);
            }
            account.makeSaveable();
            this.getContext().flush();
            EauAccountStruct eauAccountStruct = EauAccountMapper.toIdl((EauAccount)account);
            return eauAccountStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EauInformationStruct[] getEauInformations(AuthorizationToken token, String oidPCompany, String oidEmployee, String fromDate, String untilDate, int reasonOfDelivery, int adviceState, EmployeeExtendedFilterStruct extendedFilter, boolean onlyWithPeriod, boolean refreshStatus) throws BusinessDomainException {
        try {
            List<Criterion> empFilterList;
            token.checkAccess(refreshStatus ? PersonnelRightList.getUpdateEauAccount() : PersonnelRightList.getReadEauAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            if (refreshStatus) {
                this.beginUpdateService();
            } else {
                this.beginQueryService();
            }
            Conjunction filter = EauAccount.createFilterEauAccount(DateMapper.toDate((String)fromDate), DateMapper.toDate((String)untilDate), reasonOfDelivery, adviceState);
            if (refreshStatus && (empFilterList = EauAccount.getEmployeeFilter(oidPCompany, extendedFilter, oidEmployee)) != null) {
                for (Criterion empFilter : empFilterList) {
                    EauAccount[] eauAccounts = EauServantImpl.getIEauAccountPM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filter, empFilter, Restrictions.eq((String)"advicestate", (String)("" + EauAdviceStateEnum.toInt((EauAdviceStateEnum)EauAdviceStateEnum.AUFGEBAUT)))}), false);
                    EauAdvice advice = new EauAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany));
                    for (EauAccount eauAccount : eauAccounts) {
                        eauAccount.setErrorMessage("");
                        advice.checkAttributes(eauAccount);
                        if (!eauAccount.hasErrors()) {
                            eauAccount.setAdviceState(EauAdviceStateEnum.BEREIT);
                        }
                        eauAccount.makeSaveable();
                        this.getContext().flush();
                    }
                }
            }
            if (onlyWithPeriod) {
                filter.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNotNull((String)"AUABKK"), Restrictions.isNotNull((String)"AUBISVORAUSSICHT"), Restrictions.isNotNull((String)"STATIONAB"), Restrictions.isNotNull((String)"STATIONBIS")}));
            }
            Order[] sort = new Order[]{Order.asc((String)"AKTENZEICHENVU"), Order.asc((String)"CREATEDON"), Order.asc((String)"DXKKOBJECTTS")};
            ArrayList<EauinformationContainer> eauInformations = new ArrayList<EauinformationContainer>();
            List<Criterion> empFilterList2 = EauAccount.getEmployeeFilter(oidPCompany, extendedFilter, oidEmployee);
            if (empFilterList2 != null) {
                for (Criterion empFilter : empFilterList2) {
                    EauinformationContainer[] rows = EauServantImpl.getIEauInformationPM().query(sort, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
                    eauInformations.addAll(Arrays.asList(rows));
                }
            }
            EauInformationStruct[] eauInformationStructArray = EauInformationMapper.toIdl((EauinformationContainer[])((EauinformationContainer[])this.filterSpecialAccess((PersistencyContainer[])eauInformations.toArray(new EauinformationContainer[eauInformations.size()]))));
            return eauInformationStructArray;
        }
        finally {
            this.endService();
        }
    }

    private static IEauInformationPersistencyManager getIEauInformationPM() {
        return (IEauInformationPersistencyManager)UtilitiesManager.getBean((String)"eauInformationPersistencyManager", IEauInformationPersistencyManager.class);
    }

    private static IEauAccountPersistencyManager getIEauAccountPM() {
        return (IEauAccountPersistencyManager)UtilitiesManager.getBean((String)"eauAccountPersistencyManager", IEauAccountPersistencyManager.class);
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

