/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.redhhcompensationreport;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ReportBeanDataSource;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.redhhcompensationreport.IRedHHListDataSource;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHAntragDataSource;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHEinzellisteDataSource;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHEmployee;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHListBean;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;

public class RedHHListDataSource
extends JRAbstractBeanDataSource
implements IRedHHListDataSource {
    private final NumberFormat amountFormat = RedHHListDataSource.createNumberFormat(2);
    private final EmployeeForReportGenerator generator;
    private List<RedHHEmployee> employees;
    private final List<RedHHEmployee> eeSV50;
    private final List<RedHHEmployee> eeSV100;
    private Iterator<RedHHEmployee> iterator;
    private RedHHListBean currentBean;
    private int serialnumber;
    private BigDecimal solluebertrag;
    private BigDecimal istuebertrag;
    private BigDecimal kuguebertrag;
    private BigDecimal psvuebertrag;
    private BigDecimal psvweiterbuebertrag;
    private final boolean internalUse;
    private final boolean more6Month;
    private final boolean forPlantDepartment;
    private final String plantDepartment;
    private final String mOidPlant;
    private boolean mCorrection = false;
    private final boolean mRequesterFromCompany;

    private static NumberFormat createNumberFormat(int scale) {
        NumberFormat result = NumberFormat.getInstance(Locale.GERMANY);
        result.setMinimumFractionDigits(scale);
        result.setMaximumFractionDigits(scale);
        return result;
    }

    protected String format(BigDecimal bigDecimalValue) {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)bigDecimalValue)) {
            return "";
        }
        return this.amountFormat.format(bigDecimalValue);
    }

    public RedHHListDataSource(EmployeeForReportGenerator generator, boolean internalUse, boolean more6Month, boolean forPlantDepartment, String plantDepartment, String oidPlant, boolean requesterFromCompany) {
        super(false);
        this.generator = generator;
        this.internalUse = internalUse;
        this.eeSV50 = new ArrayList<RedHHEmployee>();
        this.eeSV100 = new ArrayList<RedHHEmployee>();
        this.more6Month = more6Month;
        this.forPlantDepartment = forPlantDepartment;
        this.plantDepartment = plantDepartment;
        this.mOidPlant = oidPlant;
        this.mRequesterFromCompany = requesterFromCompany;
    }

    public String getAnzKugBerechtigte() throws BusinessDomainException {
        int result = 0;
        for (RedHHEmployee each : this.getEmployees()) {
            if (!each.isAnzahlKugBezieher()) continue;
            ++result;
        }
        return String.valueOf(result);
    }

    private List<RedHHEmployee> getEmployees() throws BusinessDomainException {
        if (this.employees == null) {
            this.setEmployees(this.createEmployees());
        }
        return this.employees;
    }

    public void setEmployees(List<RedHHEmployee> employees) {
        this.employees = employees;
        this.iterator = employees.iterator();
        this.currentBean = null;
        this.initTotals();
    }

    private List<RedHHEmployee> createEmployees() throws BusinessDomainException {
        for (EmployeeForReport each : this.generator.getEmployeesForReport()) {
            RedHHEmployee current = new RedHHEmployee(each, this.generator, this.more6Month);
            if (!current.isAbrechnungsliste()) continue;
            if (!this.internalUse && this.generator.isJournalizationRequired(current.getEmployee())) {
                throw ReportExceptionMapper.makeEmployeeNotJournalized();
            }
            if (current.isPauschalierteSV50()) {
                this.eeSV50.add(current);
                continue;
            }
            this.eeSV100.add(current);
        }
        return this.eeSV100;
    }

    public void setSV100Mode() {
        this.setEmployees(this.eeSV100);
    }

    public void setSV50Mode() {
        this.setEmployees(this.eeSV50);
    }

    public String getInsgesamtAuszahlung() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        for (RedHHEmployee each : this.getEmployees()) {
            result = result.add(each.getAuszuKug());
        }
        return this.format(result);
    }

    public Map<String, Object> getParameters() {
        throw new UnsupportedOperationException();
    }

    public Object getFieldValue(JRField field) throws JRException {
        try {
            return this.getFieldValue(this.currentBean, field);
        }
        catch (JRException e) {
            if (e.getCause() == null) {
                // empty if block
            }
            throw e;
        }
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentBean = new RedHHListBean(this, this.totals(this.iterator.next()), this.employees);
            if (this.currentBean.isCorrection()) {
                this.mCorrection = true;
            }
        }
        return hasNext;
    }

    private RedHHEmployee totals(RedHHEmployee ee) {
        BigDecimal resultQ;
        ++this.serialnumber;
        this.solluebertrag = this.solluebertrag.add(ee.getSollEnt());
        this.istuebertrag = this.istuebertrag.add(ee.getIstEnt());
        this.kuguebertrag = this.kuguebertrag.add(ee.getAuszuKug());
        BigDecimal result = ee.getPauschalierteSV();
        if (result != null && result.signum() != -1) {
            this.psvuebertrag = this.psvuebertrag.add(result);
        }
        if ((resultQ = ee.getPauschalierteSVWeiterb()) != null && resultQ.signum() != -1) {
            this.psvweiterbuebertrag = this.psvweiterbuebertrag.add(resultQ);
        }
        return ee;
    }

    private void initTotals() {
        this.serialnumber = 0;
        this.solluebertrag = BigDecimal.ZERO;
        this.istuebertrag = BigDecimal.ZERO;
        this.kuguebertrag = BigDecimal.ZERO;
        this.psvuebertrag = BigDecimal.ZERO;
        this.psvweiterbuebertrag = BigDecimal.ZERO;
    }

    public void moveFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() throws BusinessDomainException {
        this.getEmployees();
        return this.eeSV50.isEmpty() && this.eeSV100.isEmpty();
    }

    public int getSerialnumber() {
        return this.serialnumber;
    }

    public BigDecimal getSolluebertrag() {
        return this.solluebertrag;
    }

    public BigDecimal getIstuebertrag() {
        return this.istuebertrag;
    }

    public BigDecimal getKuguebertrag() {
        return this.kuguebertrag;
    }

    public BigDecimal getPsvuebertrag() {
        return this.psvuebertrag;
    }

    public BigDecimal getPsvweiterbuebertrag() {
        return this.psvweiterbuebertrag;
    }

    public boolean hasSV100Mode() throws BusinessDomainException {
        this.getEmployees();
        return !this.eeSV100.isEmpty();
    }

    public boolean hasSV50Mode() throws BusinessDomainException {
        this.getEmployees();
        return !this.eeSV50.isEmpty();
    }

    public boolean isPauschalierteSV50() throws BusinessDomainException {
        this.getEmployees();
        return !this.more6Month && this.employees == this.eeSV50;
    }

    public boolean isPauschalierteSV100() throws BusinessDomainException {
        this.getEmployees();
        return this.employees == this.eeSV100;
    }

    public boolean isPauschalierteSV6Month() throws BusinessDomainException {
        this.getEmployees();
        return this.more6Month && this.employees == this.eeSV50;
    }

    public JRDataSource getAntragDataSource() {
        return new RedHHAntragDataSource(this.generator, this.eeSV50, this.eeSV100, this.internalUse, this.more6Month, this.forPlantDepartment, this.plantDepartment, this.mCorrection, this.getSolluebertrag(), this.getIstuebertrag(), this.mOidPlant, this.mRequesterFromCompany);
    }

    public JRDataSource getEinzellisteDataSource() throws BusinessDomainException {
        final RedHHEinzellisteDataSource ds = new RedHHEinzellisteDataSource(this.generator, this.eeSV50, this.eeSV100, this.more6Month, this.mOidPlant, this.mRequesterFromCompany);
        ReportBeanDataSource dataSource = new ReportBeanDataSource(ds){

            protected boolean doNext() throws JRException {
                return ds.next();
            }
        };
        return dataSource;
    }

    public boolean isInternalUse() {
        return this.internalUse;
    }

    public String getOidPlant() {
        return this.mOidPlant;
    }

    public EmployeeForReportGenerator getGenerator() {
        return this.generator;
    }

    public boolean isRequesterFromCompany() {
        return this.mRequesterFromCompany;
    }
}

