/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.redhhcompensationreport;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHEmployee;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHListDataSource;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHListHelper;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class RedHHListBean {
    private final NumberFormat amountFormat = RedHHListBean.createNumberFormat(2);
    private final RedHHListDataSource ds;
    private final RedHHEmployee ee;
    private boolean correctionList = false;
    private final RedHHListHelper redHHListHelper;
    List<RedHHEmployee> employees;

    public RedHHListBean(RedHHListDataSource dataSource, RedHHEmployee ee, List<RedHHEmployee> employees) {
        this.ds = dataSource;
        this.ee = ee;
        this.redHHListHelper = new RedHHListHelper(this.ds.getOidPlant(), ee.getEmployee(), this.ds.getGenerator(), this.ds.isRequesterFromCompany());
        this.employees = employees;
    }

    private static NumberFormat createNumberFormat(int scale) {
        NumberFormat result = NumberFormat.getInstance(Locale.GERMANY);
        result.setMinimumFractionDigits(scale);
        result.setMaximumFractionDigits(scale);
        return result;
    }

    protected String format(BigDecimal bigDecimalValue) {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)bigDecimalValue)) {
            return this.amountFormat.format(BigDecimal.ZERO);
        }
        return this.amountFormat.format(bigDecimalValue);
    }

    protected String format(boolean booleanValue) {
        if (booleanValue) {
            return "X";
        }
        return "";
    }

    protected String format(int i) {
        if (i < 0) {
            return "";
        }
        return String.valueOf(i);
    }

    protected String format(Object fallback) {
        if (fallback == null) {
            return "";
        }
        return String.valueOf(fallback);
    }

    public String get00InternerGebrauch() {
        if (this.ds.isInternalUse()) {
            return "Interner Gebrauch";
        }
        return "";
    }

    public String get00pauschalierteSVErst50() throws BusinessDomainException {
        return this.format(this.ds.isPauschalierteSV50());
    }

    public String get00pauschalierteSVErst100() throws BusinessDomainException {
        return this.format(this.ds.isPauschalierteSV100());
    }

    public String get00pauschalierteSVErst6Month() throws BusinessDomainException {
        return this.format(this.ds.isPauschalierteSV6Month());
    }

    public String get00KugStammnummer() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getStammnummer());
    }

    public String get00Betriebsnummer() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getGeneralEmploymentOffice().getEmployerNumber());
    }

    public String get00ArbeitsausfallNr() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getGeneralEmploymentOffice().getWorkingLossNumber());
    }

    public String get00Ableitungsnr() throws BusinessDomainException {
        return this.format(this.redHHListHelper.getAbleitungsnummer());
    }

    public String get00Abrechnungsmonat() {
        return this.format(this.ee.getMonJahr());
    }

    public String get00Zielgebiet1() {
        return "";
    }

    public String get00Zielgebiet2() {
        return "";
    }

    public String get00Uebergangsgebiet() {
        return "";
    }

    public boolean isCorrection() {
        return this.correctionList || this.ee.isCorrection();
    }

    public String get00KorrekturListe() {
        if (!this.correctionList) {
            for (RedHHEmployee each : this.employees) {
                if (!each.isCorrection()) continue;
                this.correctionList = true;
            }
        }
        return this.format(this.correctionList);
    }

    public String get01Laufnummer() {
        return this.format(this.ds.getSerialnumber());
    }

    public String get01Korrektur() {
        if (this.correctionList || this.ee.isCorrection()) {
            this.correctionList = true;
            return this.format("k");
        }
        return this.format("");
    }

    public String get02Vermerk() {
        if (this.ee.isQuarantaene()) {
            return this.format("Q");
        }
        return this.format("");
    }

    public String get02NameVorname() throws BusinessDomainException {
        return this.ee.getPnr() + " " + this.ee.getNamVorn();
    }

    public String get02Versicherungsnummer() throws BusinessDomainException {
        return this.format(this.ee.getVsNr());
    }

    public String get02Faktor() throws BusinessDomainException {
        return RedHHListBean.createNumberFormat(3).format(this.ee.getPercentageSplit());
    }

    public String get03KugAusfallstunden() {
        return this.format(this.ee.getKugStd());
    }

    public String get03Krankengeldstunden() {
        return this.format(this.ee.getKrgStd());
    }

    public String get03StundenInsgesamt() {
        return this.format(this.ee.getInsStd());
    }

    public String get04SollUebertrag() {
        return this.format(this.ds.getSolluebertrag());
    }

    public String get04Sollentgelt() {
        return this.format(this.ee.getSollEnt());
    }

    public String get05Istentgelt() {
        return this.format(this.ee.getIstEnt());
    }

    public String get05IstUebertrag() {
        return this.format(this.ds.getIstuebertrag());
    }

    public String get06Lohnsteuerklasse() throws BusinessDomainException {
        return this.format(this.ee.getLohnsteuerklasse());
    }

    public String get06Bezugsmonat() throws BusinessDomainException {
        int bm = this.ee.getBezugsmonat();
        if (bm < 1) {
            return "";
        }
        return this.format(bm);
    }

    public String get06Leistungssatz() throws BusinessDomainException {
        BigDecimal result = this.ee.getPauschalierteSV();
        BigDecimal resultQ = this.ee.getPauschalierteSVWeiterb();
        if (!(result != null && result.signum() != -1 || resultQ != null && resultQ.signum() != -1)) {
            return "";
        }
        return this.format(this.ee.getLeistungssatz());
    }

    public String get07RLS_Soll() {
        return this.format(this.ee.getRechnLeiSoll());
    }

    public String get08RLS_Ist() {
        return this.format(this.ee.getRechnLeiIst());
    }

    public String get09Durchscnittliche() {
        return this.format(this.ee.getDurchschnLeist());
    }

    public String get10Auszuzahlendes() {
        return this.format(this.ee.getAuszuKug());
    }

    public String get10SVErstattung() {
        BigDecimal result = this.ee.getPauschalierteSV();
        if (result == null || result.signum() == -1) {
            return "";
        }
        return this.format(result);
    }

    public String get10SVErstattungWeiterb() {
        BigDecimal result = this.ee.getPauschalierteSVWeiterb();
        if (result == null || result.signum() == -1) {
            return "";
        }
        return this.format(result);
    }

    public String get10UebertragSumme() {
        return this.format(this.ds.getKuguebertrag());
    }

    public String get10SummePauschalierteSV() {
        return this.format(this.ds.getPsvuebertrag());
    }

    public String get10SummePauschalierteSVWeiterb() {
        return this.format(this.ds.getPsvweiterbuebertrag());
    }
}

