/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.accidentinsurancefund;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFund;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundFilterStruct;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundPersistencyManager;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTP;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTPComparator;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTPPersistencyManager;
import com.varial.personnel.domain.global.accidentinsurancefund.classofrisk.ClassOfRisk;
import com.varial.personnel.domain.global.accidentinsurancefund.mapper.AccidentInsuranceFundExceptionMapper;
import com.varial.personnel.domain.global.accidentinsurancefund.mapper.AccidentInsuranceFundFilterStructMapper;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.uv.UvHelper;
import com.varial.personnel.domain.uv.dsas.UvDsas;
import com.varial.personnel.domain.uv.dssd.IUvDssdPersistencyManager;
import com.varial.personnel.domain.uv.dssd.UvDssd;
import com.varial.personnel.domain.uv.dssd.dbgt.UvDssdDbgt;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class AccidentInsuranceFund
extends PersonnelPersistenceObject<AccidentInsuranceFundTP> {
    private static final int PRIORITY = 1;
    public static final String CLASSNAME = "AccidentInsuranceFund";
    private static final List<String> BBNR_A07 = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("01010208", "01049190", "01050957", "01064065", "01068720", "01068753", "01068844", "01189862", "01382538", "01451656", "01627953", "01681222", "02263080", "02379637", "02392703", "02815840", "02849281", "02851059", "03038099", "03256232", "03391394", "03401249", "03414654", "03688519", "03701377", "03704917", "03762598", "04052546", "04780990", "04894715", "05106929", "05107691", "05108022", "05110801", "05115806", "05149156", "05152469", "05187448", "05496293", "05511668", "05513897", "05531980", "05992524", "06189403", "06768471", "06788287", "06836127", "06842045", "06866168", "06950548", "06961313", "06987200", "07235792", "07282717", "08174239", "08328449", "08566045", "09201901", "09322747", "09645070", "09681929", "09701917", "09893349", "09893418", "09911352", "10699813", "10703999", "10746707", "10769044", "12348087", "13174951", "13385729", "14066582", "14150158", "15005416", "15025808", "15087927", "15141364", "15186676", "15197214", "15250094", "15441926", "15451428", "16716004", "16758885", "16858459", "18477668", "18484827", "18484877", "18626026", "19648110", "19771678", "20001207", "20003700", "20009557", "20152790", "20345417", "21030061", "21030094", "21030118", "21204943", "21209528", "21338045", "21351004", "21353175", "21353335", "22611298", "22761735", "23440749", "23920870", "24246911", "24246944", "24246966", "24247013", "24247057", "24257492", "24257506", "24257517", "25464828", "25929874", "26125562", "26473029", "26883105", "27151135", "27225872", "28143238", "28884833", "29029801", "29036720", "29040361", "29042175", "29059513", "29086457", "29183810", "29213484", "29214533", "29589718", "31178065", "31245738", "31458451", "31608112", "31608123", "31646744", "31866616", "31866627", "31906829", "31946918", "32000187", "32064004", "32649976", "33269764", "33403814", "33469653", "33480226", "34217193", "34239086", "34364261", "34364283", "34364294", "34687999", "35069028", "35305796", "35425854", "37038284", "37253715", "37808594", "37866005", "37912740", "37916971", "37969316", "38342593", "39819966", "39841424", "40258196", "40375520", "42286617", "42810690", "42884688", "44139996", "44515618", "44849616", "44861264", "44888436", "44958180", "46111136", "47128182", "47662180", "47880388", "48626018", "48680060", "48964826", "49005902", "49556573", "52065405", "52702929", "52717470", "52738475", "52738486", "52742028", "52822456", "52900064", "52998038", "53149588", "54303511", "54745587", "55403979", "55422654", "55423519", "55521346", "60159984", "60711712", "61410424", "61635458", "62279404", "62279415", "62324784", "62547259", "62965848", "63626510", "63800761", "63805915", "63886548", "63886559", "64478181", "64941159", "65010463", "65817253", "66013505", "66337061", "66539327", "67334480", "67350937", "67370338", "67389271", "67548444", "67788116", "68286805", "68518946", "69224420", "72420704", "74089216", "75662184", "75932959", "76091373", "76195130", "76221392", "76291644", "76530682", "76533878", "76579098", "76621410", "76645624", "77188587", "81116759", "81346677", "83420411", "84344563", "86201316", "86465720", "86878444", "87513504", "87661138", "87661150", "87661161", "87661172", "87661183", "87661207", "87710461", "87741942", "88015536", "88270171", "88897383", "90200249", "90207155", "90212232", "90250694", "90276713", "90338426", "90404860", "90671277", "90899481", "92101232", "92197094", "90261506", "92658081", "95230337", "98008696", "98008709", "98009072", "98093144", "98096568", "98097240", "98098070", "98516054", "98705576", "99011352", "28645365", "28970968")));
    public static final List<String> BBNR_A08 = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("08270878", "13174962", "29139336", "39892693", "47009510", "47042806", "67545123", "72305544", "87108525")));
    public static final List<String> BBNR_A09 = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("01064065", "01627953", "01681222", "02379637", "03701377", "07235792", "09322747", "13385729", "16716004", "18477668", "18626026", "18645029", "20345417", "21204943", "26125562", "28143238", "29086457", "29214533", "34239086", "44861264", "53149588", "55423519", "67334480", "87661207", "88270171", "90276713", "98705576")));
    private static final List<String> BBNR_A09_FIRE_BRIGADE = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("01627953", "09322747", "13385729", "18645029", "18645029", "29214533", "98705576")));
    public static final List<String> BBNR_NOT_ALLOWED_FOR_LB_OR_AS = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("14066582", "15087927", "15141364", "15186676", "15197214", "15250094", "18484827", "18484877", "29029801", "29036720", "29059513", "31608112", "32064004", "34217193", "34364283", "34364294", "37916971", "42884688", "44888436", "48626018", "49005902", "52717470", "52738475", "52742028", "61635458", "62279404", "63800761", "63886548", "66337061", "67350937", "75932959", "87661138", "87661183", "87741942", "99011352")));
    private String mAccidentInsuranceFundKey;

    public AccidentInsuranceFund() {
        super(1);
    }

    public static AccidentInsuranceFund getAccidentInsuranceFund(String objectID) {
        return AccidentInsuranceFundPersistencyManager.getAccidentInsuranceFund((String)objectID);
    }

    public AccidentInsuranceFund(String objectID) {
        super(1, objectID);
    }

    public AccidentInsuranceFund(String objectId, int version) {
        super(1, objectId, version);
    }

    protected AccidentInsuranceFund(boolean readOnly) {
        super(1, readOnly);
    }

    protected void load() {
        AccidentInsuranceFundPersistencyManager.load((AccidentInsuranceFund)this);
    }

    protected void saveImpl() {
        AccidentInsuranceFundPersistencyManager.save((AccidentInsuranceFund)this);
    }

    protected void deleteImpl() {
        AccidentInsuranceFundPersistencyManager.delete((AccidentInsuranceFund)this);
    }

    protected void destroyImpl() {
        if (this.mHistory != null) {
            List list = this.mHistory.getAll();
            for (int i = 0; i < list.size(); ++i) {
                ((AccidentInsuranceFundTP)list.get(i)).remove();
            }
        }
    }

    public String getAccidentInsuranceFundKey() {
        this.requireLoaded();
        return this.mAccidentInsuranceFundKey;
    }

    public void setAccidentInsuranceFundKey(String accidentInsuranceFund) {
        this.protocol(CLASSNAME, this.mAccidentInsuranceFundKey, accidentInsuranceFund);
        this.mAccidentInsuranceFundKey = accidentInsuranceFund;
    }

    public PersonnelHistory<AccidentInsuranceFundTP> getHistory() {
        this.requireLoaded();
        if (this.mHistory == null) {
            this.mHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getSpecialHistory());
        }
        return this.mHistory;
    }

    public AccidentInsuranceFundTP[] getAccidentInsuranceFundTPs() {
        this.requireLoaded();
        return (AccidentInsuranceFundTP[])this.listToArray(this.getHistory().getAll(), AccidentInsuranceFundTP.class);
    }

    public AccidentInsuranceFundTP[] getSpecialHistory() {
        if (this.isNew()) {
            return new AccidentInsuranceFundTP[0];
        }
        return AccidentInsuranceFundTPPersistencyManager.getAccidentInsuranceFundHistory((AccidentInsuranceFund)this);
    }

    public AccidentInsuranceFundTP[] getAccidentInsuranceFundHistory(Date destinationTimepoint) {
        if (this.isNew()) {
            return new AccidentInsuranceFundTP[0];
        }
        List items = this.getHistory().getItems(destinationTimepoint);
        return items.toArray(new AccidentInsuranceFundTP[items.size()]);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return this.mAccidentInsuranceFundKey;
    }

    public void setData(String accidentInsuranceFundKey) {
        this.mAccidentInsuranceFundKey = accidentInsuranceFundKey;
    }

    public AccidentInsuranceFundTP getAccidentInsuranceFundTP(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        this.requireLoaded();
        return (AccidentInsuranceFundTP)this.getHistory().getItem(effectiveTimePoint, validTimePoint);
    }

    public AccidentInsuranceFundTP[] getEffectiveAccidentInsuranceFundTPs(Date effectiveTimepoint) {
        return this.getAccidentInsuranceFundHistory(effectiveTimepoint);
    }

    public AccidentInsuranceFundTP[] getCurrentEffectiveAccidentInsuranceFundTPs() {
        List items = this.getHistory().getItems(new Date());
        return items.toArray(new AccidentInsuranceFundTP[items.size()]);
    }

    public AccidentInsuranceFundTP[] getActiveEffectiveAccidentInsuranceFundHistory() {
        List items = this.getHistory().getItems(VDate.getDateMax());
        return items.toArray(new AccidentInsuranceFundTP[items.size()]);
    }

    public AccidentInsuranceFundTP getCurrentAccidentInsuranceFundTP() throws BusinessDomainException {
        return (AccidentInsuranceFundTP)this.mHistory.getItem(new Date(), new Date());
    }

    public static AccidentInsuranceFundTP[] getActiveAccidentInsuranceFunds(AccidentInsuranceFundFilterStruct[] filter, Order[] sortierung) {
        AccidentInsuranceFundTP[] atpArray = AccidentInsuranceFundTPPersistencyManager.queryAll((Order[])sortierung, (Criterion)AccidentInsuranceFundFilterStructMapper.toFilter((AccidentInsuranceFundFilterStruct[])filter));
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(atpArray, new AccidentInsuranceFundTPComparator());
        }
        return atpArray;
    }

    public AccidentInsuranceFundTP getActiveAccidentInsuranceFundTP() {
        AccidentInsuranceFundTP[] atpArray = AccidentInsuranceFundTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidaccidentins", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (AccidentInsuranceFund)this, (boolean)true);
        if (atpArray.length == 0) {
            ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return atpArray[0];
    }

    public static AccidentInsuranceFundTP[] getAccidentInsuranceFunds(AccidentInsuranceFundFilterStruct[] filters, Order[] sortierung, Date effectiveTimepoint, Date validTimepoint) throws BusinessDomainException {
        if (validTimepoint == null) {
            throw AccidentInsuranceFundExceptionMapper.makeValidTimepointIsEmptyDomainException((String)"getAccidentInsuranceFunds");
        }
        if (effectiveTimepoint == null) {
            effectiveTimepoint = validTimepoint;
        }
        if (DateHelper.before((Date)effectiveTimepoint, (Date)validTimepoint)) {
            effectiveTimepoint = validTimepoint;
        }
        AccidentInsuranceFundTP[] atpArray = AccidentInsuranceFundTPPersistencyManager.queryAll((Order[])sortierung, (Criterion)AccidentInsuranceFundFilterStructMapper.toFilter((AccidentInsuranceFundFilterStruct[])filters, (Date)effectiveTimepoint, (Date)validTimepoint));
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(atpArray, new AccidentInsuranceFundTPComparator());
        }
        return atpArray;
    }

    public AccidentInsuranceFundTP getObjectFromObjectId(Date effectiveTimepoint, Date validTimepoint) throws BusinessDomainException {
        AccidentInsuranceFundTP[] atpArray;
        if (validTimepoint == null) {
            throw AccidentInsuranceFundExceptionMapper.makeValidTimepointIsEmptyDomainException((String)"getObjectFromObjectId");
        }
        if (effectiveTimepoint == null) {
            effectiveTimepoint = validTimepoint;
        }
        if (DateHelper.before((Date)effectiveTimepoint, (Date)validTimepoint)) {
            effectiveTimepoint = validTimepoint;
        }
        if ((atpArray = AccidentInsuranceFundTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidaccidentins", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimepoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimepoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimepoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimepoint))}), (AccidentInsuranceFund)this, (boolean)true)).length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return atpArray[0];
    }

    public static AccidentInsuranceFundTP[] getPCompanyAccidentInsuranceFunds(AccidentInsuranceFundFilterStruct[] idlFilters, Order[] sortierung, String oidPCompany, String oidEmployee, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        PCompany pCompany;
        AssignmentPCompanyAccidentInsuranceFundTP[] assiAIF;
        Plant plant = null;
        if (!StringMapper.isNullString((String)oidEmployee)) {
            Employee ee = AccidentInsuranceFund.getIEmployeePM().getEmployee(oidEmployee);
            plant = ee.getAppurtenantPlant(effectiveTimePoint, validTimePoint);
        }
        if ((assiAIF = AccidentInsuranceFund.getAssignmentAccidentInsuranceFundTPs(pCompany = PCompanyPersistencyManager.getPCompany((String)oidPCompany), plant, oidEmployee, effectiveTimePoint, validTimePoint)).length == 0) {
            return new AccidentInsuranceFundTP[0];
        }
        Criterion mFilters = AccidentInsuranceFundFilterStructMapper.toFilter((AccidentInsuranceFundFilterStruct[])idlFilters, (Date)effectiveTimePoint, (Date)validTimePoint);
        ArrayList<String> oidList = new ArrayList<String>();
        for (int i = 0; i < assiAIF.length; ++i) {
            if (assiAIF[i].getMembershipNotValid() && DateHelper.afterOrEqual((Date)validTimePoint, (Date)assiAIF[i].getValidFrom())) continue;
            oidList.add(assiAIF[i].getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund().getObjectid());
        }
        String[] oidArray = new String[oidList.size()];
        if ((oidArray = oidList.toArray(oidArray)).length > 0) {
            mFilters = Restrictions.and((Criterion)mFilters, (Criterion)Restrictions.in((String)"objectidRoot", (String[])oidArray));
        }
        AccidentInsuranceFundTP[] aiftpa = AccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)mFilters);
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(aiftpa, new AccidentInsuranceFundTPComparator());
        }
        return aiftpa;
    }

    private static AssignmentPCompanyAccidentInsuranceFundTP[] getAssignmentAccidentInsuranceFundTPs(PCompany pc, Plant plant, String oidEmployee, Date effectiveTimePoint, Date validTimePoint) {
        AssignmentPCompanyAccidentInsuranceFundTP[] assiAIFForPlant = new AssignmentPCompanyAccidentInsuranceFundTP[]{};
        AssignmentPCompanyAccidentInsuranceFundTP[] assiAIF = new AssignmentPCompanyAccidentInsuranceFundTP[]{};
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))});
        if (plant != null) {
            assiAIFForPlant = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filters, Restrictions.eq((String)"oidPCompany", (String)pc.getObjectid()), Restrictions.eq((String)"oidPlant", (String)plant.getObjectid())}));
        }
        if (StringMapper.isNullString((String)oidEmployee) && (plant == null || assiAIFForPlant.length == 0)) {
            assiAIF = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filters, Restrictions.eq((String)"oidPCompany", (String)pc.getObjectid())}));
        }
        if (!(StringMapper.isNullString((String)oidEmployee) || plant != null && assiAIFForPlant.length != 0)) {
            assiAIF = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filters, Restrictions.eq((String)"oidPCompany", (String)pc.getObjectid()), Restrictions.isNull((String)"oidPlant")}));
        }
        if (assiAIFForPlant.length > 0) {
            String[] oids = new String[assiAIFForPlant.length];
            for (int i = 0; i < assiAIFForPlant.length; ++i) {
                oids[i] = assiAIFForPlant[i].getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund().getObjectid();
            }
            assiAIF = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filters, Restrictions.eq((String)"oidPCompany", (String)pc.getObjectid()), Restrictions.isNull((String)"oidPlant"), Restrictions.not((Criterion)Restrictions.in((String)"oidaccidentins", (String[])oids))}));
            ArrayList<AssignmentPCompanyAccidentInsuranceFundTP> list = new ArrayList<AssignmentPCompanyAccidentInsuranceFundTP>();
            list.addAll(Arrays.asList(assiAIFForPlant));
            list.addAll(Arrays.asList(assiAIF));
            assiAIF = new AssignmentPCompanyAccidentInsuranceFundTP[list.size()];
            assiAIF = list.toArray(assiAIF);
        }
        return assiAIF;
    }

    public static AccidentInsuranceFundTP[] getPCompanyAllAccidentInsuranceFunds(AccidentInsuranceFundFilterStruct[] idlFilters, Order[] sortierung, String oidPCompany, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        String[] oidArray = AccidentInsuranceFund.getAllAccidentInsuranceFundOidsOfPCompany(oidPCompany, VDate.getDateMax(), validTimePoint);
        Criterion filters = AccidentInsuranceFundFilterStructMapper.toFilter((AccidentInsuranceFundFilterStruct[])idlFilters, (Date)effectiveTimePoint, (Date)validTimePoint);
        if (oidArray.length > 0) {
            filters = Restrictions.and((Criterion)filters, (Criterion)Restrictions.in((String)"objectidRoot", (String[])oidArray));
        }
        AccidentInsuranceFundTP[] aiftpa = AccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)filters);
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(aiftpa, new AccidentInsuranceFundTPComparator());
        }
        return aiftpa;
    }

    private static String[] getAllAccidentInsuranceFundOidsOfPCompany(String oidPCompany, Date effectiveTimePoint, Date validTimePoint) {
        return AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.getAllAccidentInsuranceFundOidsOfPCompany((String)oidPCompany, (Date)effectiveTimePoint, (Date)validTimePoint);
    }

    public ClassOfRisk getCompleteClassOfRisk(Date effectiveTimePoint, Date validTimePoint, String classOfRisk, String serialNumberAlpha) {
        ClassOfRisk classOfRiskClass = null;
        AccidentInsuranceFundTP accidentInsuranceFundTP = null;
        try {
            accidentInsuranceFundTP = this.getAccidentInsuranceFundTP(effectiveTimePoint, validTimePoint);
        }
        catch (BusinessDomainException businessDomainException) {
            // empty catch block
        }
        if (accidentInsuranceFundTP != null) {
            classOfRiskClass = accidentInsuranceFundTP.getClassOfRisk(classOfRisk, serialNumberAlpha);
        }
        return classOfRiskClass;
    }

    public void checkTimePeriod(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.getAccidentInsuranceFundTP(effectiveFrom, validFrom);
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public void checkAccidentInsuranceFund(GeneralEmploymentOffice generalEmploymentOffice, AccidentInsuranceFund differentAccidentInsuranceFund, String classOfRisk, Date effectiveTimePoint, Date validTimePoint, int zeile) throws BusinessDomainException {
        if (differentAccidentInsuranceFund == null) {
            if (zeile == 0) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"BG der Gefahrtarifstelle");
            }
            throw EmployeeExceptionMapper.makeAIFClassOfRiskMissingDomainException((String)String.valueOf(zeile));
        }
        this.checkFictiveClassOfRisk(differentAccidentInsuranceFund, classOfRisk, generalEmploymentOffice, effectiveTimePoint, validTimePoint);
        Date validTP = validTimePoint;
        if (!StringMapper.equal((String)this.getObjectid(), (String)differentAccidentInsuranceFund.getObjectid())) {
            String stdCompanyNo = this.getAccidentInsuranceFundTP(effectiveTimePoint, validTimePoint).getStdCompanyNoOfAccIns();
            Date dateMarginal = new VDate(2014, 0, 1).getDate();
            if (DateHelper.afterOrEqual((Date)validTimePoint, (Date)dateMarginal) ? !StringMapper.equal((String)stdCompanyNo, (String)"63800761") && !StringMapper.equal((String)stdCompanyNo, (String)"14066582") : !StringMapper.equal((String)stdCompanyNo, (String)"29029801") && !StringMapper.equal((String)stdCompanyNo, (String)"63800761") && !StringMapper.equal((String)stdCompanyNo, (String)"14066582")) {
                throw EmployeeExceptionMapper.makeDifferentClassOfRiskNotAllowedDomainException((String)this.getAccidentInsuranceFundKey());
            }
            validTP = new VDate(validTimePoint).addYears(-1).getDate();
        }
        this.subCheckClassOfRisk(differentAccidentInsuranceFund, classOfRisk, effectiveTimePoint, validTP, zeile);
    }

    private void subCheckClassOfRisk(AccidentInsuranceFund aif, String classOfRisk, Date effectiveTimePoint, Date validTimePoint, int zeile) throws BusinessDomainException {
        if (StringMapper.isNullString((String)classOfRisk)) {
            if (zeile == 0) {
                throw EmployeeExceptionMapper.makeClassOfRiskMissingDomainException();
            }
            throw EmployeeExceptionMapper.makeClassOfRiskMissingDomainException((String)String.valueOf(zeile));
        }
        ClassOfRisk[] classOfRisks = aif.getAccidentInsuranceFundTP(effectiveTimePoint, validTimePoint).getClassesOfRisk();
        if (classOfRisks.length == 0) {
            throw EmployeeExceptionMapper.makeClassOfRiskMissingDomainException();
        }
        boolean found = false;
        ClassOfRisk foundedClassOfRisk = null;
        for (int i = 0; i < classOfRisks.length; ++i) {
            if (!StringMapper.equal((String)classOfRisks[i].getClassOfRisk(), (String)classOfRisk)) continue;
            found = true;
            foundedClassOfRisk = classOfRisks[i];
            break;
        }
        if (!found) {
            throw EmployeeExceptionMapper.makeClassOfRiskNotInAccInsFundDomainException();
        }
        if (foundedClassOfRisk != null) {
            foundedClassOfRisk.checkLegalClassOfRisk(validTimePoint);
        }
    }

    private void checkFictiveClassOfRisk(AccidentInsuranceFund aif, String classOfRisk, GeneralEmploymentOffice generalEmploymentOffice, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        if (generalEmploymentOffice != null && StringMapper.equal((String)"77777777", (String)classOfRisk) && !BBNR_A07.contains(generalEmploymentOffice.getEmployerNumber())) {
            throw EmployeeExceptionMapper.makeClassOfRisk77777777NotAllowedDomainException();
        }
        if (BBNR_A08.contains(aif.getAccidentInsuranceFundTP(effectiveTimePoint, validTimePoint).getStdCompanyNoOfAccIns()) && !StringMapper.equal((String)"88888888", (String)classOfRisk)) {
            throw EmployeeExceptionMapper.makeClassOfRisk88888888NotAllowedDomainException();
        }
        if (StringMapper.equal((String)"99999999", (String)classOfRisk) && !BBNR_A09.contains(aif.getAccidentInsuranceFundTP(effectiveTimePoint, validTimePoint).getStdCompanyNoOfAccIns())) {
            throw EmployeeExceptionMapper.makeClassOfRisk99999999NotAllowedDomainException();
        }
    }

    public UvDssd subCheckClassOfRiskAgainstDssd(GeneralEmploymentOffice generalEmploymentOffice, PCompany company, Plant plant, AccidentInsuranceFund headAif, AccidentInsuranceFund aif, String classOfRisk, Date effectiveTimePoint, Date validTimePoint, int zeile, boolean callFromDialog) throws BusinessDomainException {
        boolean bl;
        ArrayList<String> vorgangsids;
        HashSet<String> mnrUnrs;
        if (this.isNotValidForDsas(headAif, generalEmploymentOffice.getEmployerNumber())) {
            return null;
        }
        int jahr = new VDate(validTimePoint).getYear();
        if (jahr < 2017) {
            return null;
        }
        AssignmentPCompanyAccidentInsuranceFundTP[] assignmentAifTPsForPlant = new AssignmentPCompanyAccidentInsuranceFundTP[]{};
        AssignmentPCompanyAccidentInsuranceFundTP[] assignmentAifTPsForCompany = new AssignmentPCompanyAccidentInsuranceFundTP[]{};
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))});
        if (plant != null) {
            assignmentAifTPsForPlant = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filters, Restrictions.eq((String)"oidPCompany", (String)company.getObjectid()), Restrictions.eq((String)"oidPlant", (String)plant.getObjectid()), Restrictions.eq((String)"oidAccidentIns", (String)headAif.getObjectid())}));
        }
        if (assignmentAifTPsForPlant.length > 1) {
            throw EmployeeExceptionMapper.makeMultipleAssignmentAccInsDomainException((String)plant.getPlantKey());
        }
        assignmentAifTPsForCompany = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filters, Restrictions.eq((String)"oidPCompany", (String)company.getObjectid()), Restrictions.isNull((String)"oidPlant"), Restrictions.eq((String)"oidAccidentIns", (String)headAif.getObjectid())}));
        if (assignmentAifTPsForPlant.length == 0 && assignmentAifTPsForCompany.length == 0) {
            throw EmployeeExceptionMapper.makeAssignmentAifIsMissingDomainException((String)headAif.getAccidentInsuranceFundKey());
        }
        if (assignmentAifTPsForPlant.length > 0 && assignmentAifTPsForPlant[0].getMembershipNotValid()) {
            throw EmployeeExceptionMapper.makeAifMemebershipNotValidDomainException((String)DateMapper.toDDMMYYYYPointSeparationString((Date)assignmentAifTPsForPlant[0].getValidFrom()));
        }
        if (assignmentAifTPsForCompany.length > 0 && assignmentAifTPsForCompany[0].getMembershipNotValid()) {
            throw EmployeeExceptionMapper.makeAifMemebershipNotValidDomainException((String)DateMapper.toDDMMYYYYPointSeparationString((Date)assignmentAifTPsForCompany[0].getValidFrom()));
        }
        UvDsas[] dsasForPlant = new UvDsas[]{};
        UvDsas[] dsasForCompany = new UvDsas[]{};
        if (assignmentAifTPsForPlant.length > 0 && (dsasForPlant = UvHelper.getUvDsasForAssAIF((AssignmentPCompanyAccidentInsuranceFund)assignmentAifTPsForPlant[0].getAssignmentPCompanyAccidentInsuranceFund(), (int)jahr)).length > 1) {
            mnrUnrs = new HashSet<String>();
            for (UvDsas each : dsasForPlant) {
                mnrUnrs.add(each.getUnrsOrMnr());
            }
            if (dsasForPlant.length != mnrUnrs.size()) {
                throw EmployeeExceptionMapper.makeMultipleRequestAccInsDomainException((String)plant.getPlantKey(), (int)jahr);
            }
        }
        if (dsasForPlant.length == 0 && assignmentAifTPsForCompany.length == 0) {
            if (callFromDialog || UvHelper.noFurtherDsasNecessary((AssignmentPCompanyAccidentInsuranceFund)assignmentAifTPsForPlant[0].getAssignmentPCompanyAccidentInsuranceFund(), (String)assignmentAifTPsForPlant[0].getMembershipNumber(), (String)assignmentAifTPsForPlant[0].getUnrs(), (int)jahr)) {
                return null;
            }
            throw EmployeeExceptionMapper.makeNoDsasFoundDomainException((String)headAif.getAccidentInsuranceFundKey(), (int)jahr);
        }
        if (dsasForPlant.length == 0 && (dsasForCompany = UvHelper.getUvDsasForAssAIF((AssignmentPCompanyAccidentInsuranceFund)assignmentAifTPsForCompany[0].getAssignmentPCompanyAccidentInsuranceFund(), (int)jahr)).length > 1) {
            mnrUnrs = new HashSet();
            for (UvDsas each : dsasForCompany) {
                mnrUnrs.add(each.getUnrsOrMnr());
            }
            if (dsasForCompany.length != mnrUnrs.size()) {
                throw EmployeeExceptionMapper.makeMultipleRequestAccInsDomainException((String)company.getPCompanyKey(), (int)jahr);
            }
        }
        if (dsasForPlant.length == 0 && dsasForCompany.length == 0) {
            if (callFromDialog || UvHelper.noFurtherDsasNecessary((AssignmentPCompanyAccidentInsuranceFund)assignmentAifTPsForCompany[0].getAssignmentPCompanyAccidentInsuranceFund(), (String)assignmentAifTPsForCompany[0].getMembershipNumber(), (String)assignmentAifTPsForCompany[0].getUnrs(), (int)jahr)) {
                return null;
            }
            throw EmployeeExceptionMapper.makeNoDsasFoundDomainException((String)headAif.getAccidentInsuranceFundKey(), (int)jahr);
        }
        UvDssd[] dssdForPlant = new UvDssd[]{};
        UvDssd[] dssdForCompany = new UvDssd[]{};
        if (dsasForPlant.length > 0) {
            vorgangsids = new ArrayList<String>();
            for (UvDsas uvDsas : dsasForPlant) {
                vorgangsids.add(uvDsas.getVorgangsId());
            }
            dssdForPlant = ((IUvDssdPersistencyManager)UtilitiesManager.getBean((String)"uvDssdPersistencyManager", IUvDssdPersistencyManager.class)).query(new Order[]{Order.desc((String)"ED")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"VORGANGSID", vorgangsids), Restrictions.eq((String)"JAHR", (String)String.valueOf(jahr))}), true);
        } else {
            vorgangsids = new ArrayList();
            for (UvDsas uvDsas : dsasForCompany) {
                vorgangsids.add(uvDsas.getVorgangsId());
            }
            dssdForCompany = ((IUvDssdPersistencyManager)UtilitiesManager.getBean((String)"uvDssdPersistencyManager", IUvDssdPersistencyManager.class)).query(new Order[]{Order.desc((String)"ED")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"VORGANGSID", vorgangsids), Restrictions.eq((String)"JAHR", (String)String.valueOf(jahr))}), true);
        }
        int beitragsmassstab = 0;
        UvDssd validDssd = null;
        Date validFrom = DateHelper.getFirstDayOfMonth((Date)validTimePoint);
        Date validUntil = DateHelper.getLastDayOfMonth((Date)validTimePoint);
        if (dssdForPlant.length > 0) {
            for (UvDssd dssd : dssdForPlant) {
                if (!DateHelper.beforeOrEqual((Date)validFrom, (Date)dssd.getMnrgbis()) || !DateHelper.afterOrEqual((Date)validUntil, (Date)dssd.getMnrgvon())) continue;
                beitragsmassstab = dssd.getBeitragsmassstab();
                validDssd = dssd;
                break;
            }
        }
        if (dssdForCompany.length > 0) {
            for (UvDssd dssd : dssdForCompany) {
                if (!DateHelper.beforeOrEqual((Date)validFrom, (Date)dssd.getMnrgbis()) || !DateHelper.afterOrEqual((Date)validUntil, (Date)dssd.getMnrgvon())) continue;
                beitragsmassstab = dssd.getBeitragsmassstab();
                validDssd = dssd;
                break;
            }
        }
        if (validDssd == null) {
            if (callFromDialog) {
                return null;
            }
            if (dsasForPlant.length > 0) {
                throw EmployeeExceptionMapper.makeNoDssdFoundForPlantDomainException((String)plant.getPlantKey(), (String)headAif.getAccidentInsuranceFundKey(), (int)jahr);
            }
            throw EmployeeExceptionMapper.makeNoDssdFoundForCompanyDomainException((String)company.getPCompanyKey(), (String)headAif.getAccidentInsuranceFundKey(), (int)jahr);
        }
        if (beitragsmassstab == 4 || beitragsmassstab == 5 || beitragsmassstab == 6) {
            return validDssd;
        }
        if (validDssd.getDbgts().length == 0) {
            throw EmployeeExceptionMapper.makeNoDssdDbgtFoundDomainException();
        }
        boolean bl2 = false;
        for (UvDssdDbgt each : validDssd.getDbgts()) {
            if (!StringMapper.equal((String)aif.getAccidentInsuranceFundTP(effectiveTimePoint, validTimePoint).getStdCompanyNoOfAccIns(), (String)each.getBbnrgt()) || !StringMapper.equal((String)classOfRisk, (String)each.getGtst()) || !DateHelper.beforeOrEqual((Date)validFrom, (Date)each.getGtstBis()) || !DateHelper.afterOrEqual((Date)validUntil, (Date)each.getGtstVon())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw EmployeeExceptionMapper.makeByReasonOfDssdDbgtGtNotAllowedDomainException((String)classOfRisk);
        }
        return validDssd;
    }

    public boolean isNotValidForDsas(String stdCompanyNoEmployer) throws BusinessDomainException {
        return this.isNotValidForDsas(this, stdCompanyNoEmployer);
    }

    private boolean isNotValidForDsas(AccidentInsuranceFund aif, String stdCompanyNoEmployer) {
        String stdCompanyNoAif = aif.getActiveAccidentInsuranceFundTP().getStdCompanyNoOfAccIns();
        return BBNR_A08.contains(stdCompanyNoAif) || BBNR_A09_FIRE_BRIGADE.contains(stdCompanyNoAif) || BBNR_A07.contains(stdCompanyNoEmployer);
    }
}

