/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreak;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreakPersistencyManager;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;

public class SteuerungZVKBrutto2014Formula {
    private final ValuePositionLibrary wplib;
    private final GlobalLibrary gllib;
    private final EmployeeLibrary eelib;
    private final CalculationLibrary callib;
    private BigDecimal mAnteilMug = BigDecimal.ZERO;

    public SteuerungZVKBrutto2014Formula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib) {
        this.callib = calLib;
        this.eelib = eeLib;
        this.gllib = glLib;
        this.wplib = wpLib;
    }

    public void steuerung() throws BusinessDomainException {
        BigDecimal bruttoKorrektur;
        BigInteger tempBigI = this.wplib.result().movePointRight(2).toBigInteger();
        BigDecimal tempBigD = new BigDecimal(tempBigI).movePointLeft(2);
        if (tempBigD.compareTo(this.wplib.result()) != 0) {
            this.gllib.erzeugeWiedervorlageBruchteileVonCent(this.wplib.genesisParent().getValueType().getValueTypeKey());
        }
        if (this.eelib.marbPgs() == 110 || !this.zvkpflichtig()) {
            this.wplib.loescheWertPosition(this.wplib.wertPosition());
            return;
        }
        ValuePosition parent = this.wplib.parent();
        BigDecimal eingangswert = this.wplib.result();
        eingangswert = this.checkEintrittsdatumZVK(eingangswert);
        eingangswert = this.bruttoKorrektur(parent, eingangswert);
        if (parent.getValueType().getValueTypeKey() == 99991 && !BigDecimalMapper.isZero((BigDecimal)(bruttoKorrektur = eingangswert.subtract(this.wplib.result())))) {
            parent.setResult(parent.getResult().add(bruttoKorrektur));
            switch (this.wplib.wertartenNummer()) {
                case 100903: {
                    ValuePosition nextSDZVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType((int)100907));
                    if (nextSDZVP == null) break;
                    nextSDZVP.setResult(nextSDZVP.getResult().subtract(bruttoKorrektur));
                    break;
                }
                default: {
                    ValuePosition nextlfdVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType((int)100906));
                    if (nextlfdVP == null) break;
                    nextlfdVP.setResult(nextlfdVP.getResult().subtract(bruttoKorrektur));
                }
            }
        }
        this.callib.result(eingangswert);
        this.wplib.persistentBuffer5(this.mAnteilMug);
        this.erzeugeWertpositionen(eingangswert);
        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)this.callib.berchnungWirksamAb())) {
            this.checkZVKBrutti();
        }
    }

    private BigDecimal checkEintrittsdatumZVK(BigDecimal eingangswert) throws BusinessDomainException {
        BigDecimal resultat = eingangswert;
        Date marbEintritt = this.eelib.marbEintritt();
        Date eintrittsdatumZVK = this.eelib.marbZVKEintritt();
        Date letzterTagDesMonats = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
        Date ersterTagDesMonats = DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb());
        if (DateHelper.after((Date)marbEintritt, (Date)ersterTagDesMonats)) {
            ersterTagDesMonats = marbEintritt;
        }
        if (DateHelper.afterOrEqual((Date)eintrittsdatumZVK, (Date)ersterTagDesMonats) && DateHelper.compare((Date)eintrittsdatumZVK, (Date)marbEintritt) != 0 && DateHelper.between((Date)eintrittsdatumZVK, (Date)ersterTagDesMonats, (Date)letzterTagDesMonats)) {
            int kalendertage = DateHelper.getDiffInDays((Date)letzterTagDesMonats, (Date)ersterTagDesMonats) + 1;
            int zvktage = DateHelper.getDiffInDays((Date)letzterTagDesMonats, (Date)eintrittsdatumZVK) + 1;
            resultat = resultat.multiply(BigDecimal.valueOf(zvktage)).divide(BigDecimal.valueOf(kalendertage), 2, RoundingMode.HALF_UP);
            new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), DateHelper.addMonths((Date)this.callib.berchnungGueltigAb(), (int)1), this.getClass().getName());
        }
        return resultat;
    }

    private BigDecimal bruttoKorrektur(ValuePosition parent, BigDecimal eingangswert) throws BusinessDomainException {
        BigDecimal resultat = eingangswert;
        switch (this.wplib.wertartenNummer()) {
            case 100903: {
                resultat = this.zwoelftelungsRegel(resultat);
                resultat = this.checkATZ(parent, resultat);
                break;
            }
            case 100902: {
                if (parent.getValueType().getValueTypeKey() == 99991) {
                    this.wplib.wertPosition().setPersistentBuffer1(resultat);
                    break;
                }
                if (this.wurdeZVKFiktivBereitsBerechnet()) {
                    resultat = BigDecimal.ZERO;
                    break;
                }
                resultat = this.differenzVollmonat();
                resultat = this.checkFehlzeiten(resultat);
                resultat = this.checkATZ(parent, resultat);
                if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungWirksamAb()))) {
                    this.setFiktivBruttoDiff(this.getFiktivBruttoAusSichtVormonat().subtract(resultat));
                }
                this.wplib.wertPosition().setPersistentBuffer1(resultat);
                if (!DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungWirksamAb()))) break;
                this.wplib.setze99991Zurueck();
                this.callib.resetValuepositionHistoryIndex();
                break;
            }
            case 100905: {
                resultat = this.wplib.result();
                resultat = this.checkFehlzeiten(resultat);
                resultat = this.checkATZ(parent, resultat);
                break;
            }
            case 100904: {
                resultat = this.wplib.result();
                break;
            }
            default: {
                resultat = this.checkATZ(parent, resultat);
            }
        }
        BigDecimal aufgelZVKBrutto = this.holeaufgelaufenesZVKBrutto();
        if (parent.getValueType().getValueTypeKey() != 99992 && aufgelZVKBrutto.add(resultat).compareTo(this.gllib.zvkMaximalGrenze()) > 0) {
            resultat = this.gllib.zvkMaximalGrenze().subtract(aufgelZVKBrutto);
        }
        return resultat;
    }

    private BigDecimal checkATZ(ValuePosition parent, BigDecimal eingangswert) throws BusinessDomainException {
        BigDecimal result = eingangswert;
        if (parent.getValueType().getValueTypeKey() != 99992 && this.eelib.marbPgs() == 103 && !this.eelib.zvkAltersteilzeitVor2003()) {
            result = eingangswert.add(eingangswert.multiply(BigDecimal.valueOf(80L)).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        }
        return result;
    }

    private BigDecimal checkFehlzeiten(BigDecimal eingangswert) throws BusinessDomainException {
        EEAbsentTimeTP[] fehlzeiten;
        BigDecimal resultat = eingangswert;
        int fehltageGesamt = 0;
        int fehltageGesamtFiktiv = 0;
        int fehltageMutterschutz = 0;
        for (EEAbsentTimeTP fehlz : fehlzeiten = this.eelib.aktuelleFehlzeiten()) {
            if (!fehlz.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb()).getCutByPartTimePayPeriod()) continue;
            int lFehltage = this.ermittleKalendertage(fehlz);
            if (StringMapper.equalWithTrim((String)fehlz.getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"M")) {
                fehltageGesamt += lFehltage;
                fehltageGesamtFiktiv += lFehltage;
                fehltageMutterschutz += lFehltage;
                continue;
            }
            if (StringMapper.equalWithTrim((String)fehlz.getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"K") || StringMapper.equalWithTrim((String)fehlz.getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"G") || StringMapper.equalWithTrim((String)fehlz.getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"VG")) {
                fehltageGesamt += lFehltage;
                fehltageGesamtFiktiv += lFehltage;
                continue;
            }
            fehltageGesamt += lFehltage;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)BigDecimal.valueOf(fehltageGesamt))) {
            resultat = resultat.multiply(BigDecimal.valueOf(fehltageGesamtFiktiv)).divide(BigDecimal.valueOf(fehltageGesamt), 2, RoundingMode.HALF_UP);
        }
        if (fehltageMutterschutz > 0) {
            this.mAnteilMug = resultat.multiply(BigDecimal.valueOf(fehltageMutterschutz)).divide(BigDecimal.valueOf(fehltageGesamtFiktiv), 2, RoundingMode.HALF_UP);
        }
        return resultat;
    }

    private int ermittleKalendertage(EEAbsentTimeTP fehlz) throws BusinessDomainException {
        int result = 0;
        Date from = DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb());
        boolean fehlzrelevant = false;
        if (DateHelper.afterOrEqual((Date)fehlz.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb())) && DateHelper.beforeOrEqual((Date)fehlz.getValidFrom(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            fehlzrelevant = true;
        }
        if (DateHelper.between((Date)fehlz.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)from), (Date)DateHelper.getLastDayOfMonth((Date)from))) {
            from = fehlz.getValidFrom();
        }
        Date until = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
        if (DateHelper.between((Date)fehlz.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)until), (Date)DateHelper.getLastDayOfMonth((Date)until))) {
            until = fehlz.getValidUntil();
        }
        if (fehlzrelevant) {
            result = DateHelper.getDiffInDays((Date)until, (Date)from) + 1;
        }
        return result;
    }

    private BigDecimal holeaufgelaufenesZVKBrutto() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{100901, 100902, 100903, 100904, 100905, 100908}))) {
            result = result.add(vPos.getResult());
        }
        return result;
    }

    private BigDecimal differenzVollmonat() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal wertAktMonat = BigDecimal.ZERO;
        BigDecimal wertVollmonat = BigDecimal.ZERO;
        block3: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), new ValueType[0])) {
            ValuePosition[] vpArray2;
            boolean addiert = false;
            for (ValuePosition vPos2 : vpArray2 = this.wplib.getFolgen(vPos)) {
                switch (vPos2.getValueType().getValueTypeKey()) {
                    case 100901: 
                    case 100904: {
                        if (vPos.getValueType().getValueTypeKey() >= 99991) break;
                        wertVollmonat = wertVollmonat.add(vPos.getPersistentBuffer3());
                        wertAktMonat = wertAktMonat.add(vPos.getResult());
                        addiert = true;
                        break;
                    }
                }
                if (addiert) continue block3;
            }
        }
        return wertVollmonat.subtract(wertAktMonat);
    }

    private BigDecimal getFiktivBruttoAusSichtVormonat() throws BusinessDomainException {
        Date wirksamAb = DateHelper.addMonths((Date)this.callib.berchnungWirksamAb(), (int)-1);
        ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(wirksamAb, DateHelper.getLastDayOfMonth((Date)wirksamAb), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{100902}));
        BigDecimal fiktivBrutto = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray) {
            fiktivBrutto = fiktivBrutto.add(vPos.getResult());
        }
        return fiktivBrutto;
    }

    private void setFiktivBruttoDiff(BigDecimal fiktivBruttoDiff) throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)fiktivBruttoDiff)) {
            ValuePosition[] vpArray;
            for (ValuePosition vp : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{99991, 100906}))) {
                if (vp.getValueType().getValueTypeKey() == 99991) {
                    vp.setResult(vp.getResult().add(fiktivBruttoDiff));
                    this.wplib.addNeueWertPosition(100902, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fiktivBruttoDiff, false, (PersistentObject)vp);
                    continue;
                }
                vp.setResult(vp.getResult().add(fiktivBruttoDiff.negate()));
            }
            this.callib.setKenzeichenZVKRR(true);
        }
    }

    private boolean wurdeZVKFiktivBereitsBerechnet() throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{100902}))) {
            if (!vPos.getEvaluateComplete()) continue;
            return true;
        }
        return false;
    }

    private BigDecimal zwoelftelungsRegel(BigDecimal eingangswert) throws BusinessDomainException {
        int abrechnungsMonat;
        BigDecimal divident = BigDecimal.valueOf(12L);
        BigDecimal divisor = BigDecimal.valueOf(12L);
        BigDecimal svTage = this.wplib.svTage();
        boolean mutterschutzImAktuellenMonat = false;
        if (svTage.compareTo(BigDecimal.ZERO) == 0) {
            EEAbsentTimeTP[] fehlzeiten = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb());
            boolean relevanteFehlzeit = false;
            for (EEAbsentTimeTP fehlzeit : fehlzeiten) {
                if (fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey().compareTo("5.1") == 0 && DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2018, 0, 1).getDate())) {
                    relevanteFehlzeit = true;
                }
                if (fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey().compareTo("4.5") != 0) continue;
                mutterschutzImAktuellenMonat = true;
            }
            if (relevanteFehlzeit && !mutterschutzImAktuellenMonat) {
                divident = divident.subtract(BigDecimal.ONE);
            }
        }
        if (!mutterschutzImAktuellenMonat) {
            Date ausrittsdatum;
            Date startdatum = DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb());
            if (DateHelper.before((Date)startdatum, (Date)this.gllib.firmaBerechnungsStart())) {
                EECarriedForwardSystemSIBreak[] vortraege = EECarriedForwardSystemSIBreakPersistencyManager.getEECarriedForwardSystemSIBreak((Employee)this.eelib.marb());
                EECarriedForwardSystemSIBreak vortragAlt = null;
                for (EECarriedForwardSystemSIBreak vortrag : vortraege) {
                    if (vortrag.getAbsentTime().getDEUVAbsentTimeKey().compareTo("5.1") == 0) {
                        Date validfrom = vortrag.getValidFrom();
                        if (!(DateHelper.equal((Date)vortrag.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)vortrag.getValidFrom())) || vortragAlt != null && DateHelper.equal((Date)DateHelper.yesterday((Date)validfrom), (Date)vortragAlt.getValidUntil()))) {
                            validfrom = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)vortrag.getValidFrom()));
                        }
                        Date validuntil = vortrag.getValidUntil();
                        if (!DateHelper.equal((Date)vortrag.getValidUntil(), (Date)DateHelper.getLastDayOfMonth((Date)vortrag.getValidUntil()))) {
                            validuntil = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)vortrag.getValidUntil()));
                        }
                        while (DateHelper.before((Date)validfrom, (Date)validuntil)) {
                            divident = divident.subtract(BigDecimal.ONE);
                            validfrom = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)validfrom));
                        }
                    }
                    vortragAlt = vortrag;
                }
                startdatum = this.gllib.firmaBerechnungsStart();
            }
            Date eintrittsdatum = this.eelib.marbEintritt();
            Date date = ausrittsdatum = this.eelib.marbAustritt() != null ? this.eelib.marbAustritt() : VDate.getDateMax();
            while (DateHelper.before((Date)startdatum, (Date)DateHelper.getLastDayOfYear((Date)this.callib.berchnungGueltigAb()))) {
                EEAbsentTimeTP[] fehlzeiten = this.eelib.aktuelleFehlzeitenfuerMonat(startdatum);
                boolean relevanteFehlzeit = false;
                for (EEAbsentTimeTP fehlzeit : fehlzeiten) {
                    if (fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey().compareTo("5.1") != 0) continue;
                    Date ersterTagDesMonats = DateHelper.getFirstDayOfMonth((Date)startdatum);
                    ersterTagDesMonats = DateHelper.before((Date)ersterTagDesMonats, (Date)eintrittsdatum) ? eintrittsdatum : ersterTagDesMonats;
                    Date letzterTagDesMonats = DateHelper.getLastDayOfMonth((Date)startdatum);
                    Date date2 = letzterTagDesMonats = DateHelper.after((Date)letzterTagDesMonats, (Date)ausrittsdatum) ? ausrittsdatum : letzterTagDesMonats;
                    if (!DateHelper.beforeOrEqual((Date)fehlzeit.getValidFrom(), (Date)ersterTagDesMonats) || !DateHelper.afterOrEqual((Date)fehlzeit.getValidUntil(), (Date)letzterTagDesMonats)) continue;
                    relevanteFehlzeit = true;
                }
                if (DateHelper.before((Date)startdatum, (Date)this.callib.berchnungGueltigAb())) {
                    ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), startdatum, DateHelper.getLastDayOfMonth((Date)startdatum), ValueTypeHelper.getValueTypes((int[])new int[]{130590, 100902, 100905}));
                    svTage = BigDecimal.ZERO;
                    BigDecimal fiktivesEntgelt = BigDecimal.ZERO;
                    block9: for (ValuePosition vp : vpArray) {
                        switch (vp.getValueType().getValueTypeKey()) {
                            case 130590: {
                                svTage = svTage.add(vp.getFactor1());
                                continue block9;
                            }
                            case 100902: 
                            case 100905: {
                                fiktivesEntgelt = fiktivesEntgelt.add(vp.getResult());
                            }
                        }
                    }
                    if (svTage.compareTo(BigDecimal.ZERO) == 0 && fiktivesEntgelt.compareTo(BigDecimal.ZERO) == 0 && relevanteFehlzeit) {
                        divident = divident.subtract(BigDecimal.ONE);
                    }
                } else if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2018, 0, 1).getDate()) && relevanteFehlzeit) {
                    divident = divident.subtract(BigDecimal.ONE);
                }
                startdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)startdatum));
            }
        }
        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2018, 0, 1).getDate()) && divident.compareTo(BigDecimal.valueOf(12L)) < 0 && (abrechnungsMonat = DateHelper.getMonth((Date)this.callib.berchnungGueltigAb()) + 1) < 12) {
            divident = divident.add(BigDecimal.valueOf(abrechnungsMonat)).subtract(BigDecimal.valueOf(12L));
        }
        return eingangswert.multiply(divident).divide(divisor, 2, RoundingMode.HALF_UP);
    }

    private void checkZVKBrutti() throws BusinessDomainException {
        if (!this.callib.isZVKBruttoCheckedForCaculationCase()) {
            ValuePosition[] vpArray;
            this.callib.setZVKBruttoCheckedForCalculationCase(true);
            BigDecimal zvkBruttoLfdAkt = BigDecimal.ZERO;
            BigDecimal zvkBruttoFiktivAkt = BigDecimal.ZERO;
            BigDecimal zvkBruttoSdZAkt = BigDecimal.ZERO;
            BigDecimal zvkBrutto100Akt = BigDecimal.ZERO;
            block10: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.zvkBruttis())) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 100901: {
                        zvkBruttoLfdAkt = zvkBruttoLfdAkt.add(vPos.getResult());
                        continue block10;
                    }
                    case 100902: 
                    case 100905: {
                        zvkBruttoFiktivAkt = zvkBruttoFiktivAkt.add(vPos.getResult());
                        continue block10;
                    }
                    case 100903: 
                    case 100908: {
                        zvkBruttoSdZAkt = zvkBruttoSdZAkt.add(vPos.getResult());
                        continue block10;
                    }
                    default: {
                        zvkBrutto100Akt = zvkBrutto100Akt.add(vPos.getResult());
                    }
                }
            }
            BigDecimal zvkBruttoLfdAlt = BigDecimal.ZERO;
            BigDecimal zvkBruttoFiktivAlt = BigDecimal.ZERO;
            BigDecimal zvkBruttoSdZAlt = BigDecimal.ZERO;
            BigDecimal zvkBrutto100Alt = BigDecimal.ZERO;
            block11: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.callib.berchnungWirksamAb())), DateHelper.yesterday((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.zvkBruttis())) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 100901: {
                        zvkBruttoLfdAlt = zvkBruttoLfdAlt.add(vPos.getResult());
                        continue block11;
                    }
                    case 100902: 
                    case 100905: {
                        zvkBruttoFiktivAlt = zvkBruttoFiktivAlt.add(vPos.getResult());
                        continue block11;
                    }
                    case 100903: 
                    case 100908: {
                        zvkBruttoSdZAlt = zvkBruttoSdZAlt.add(vPos.getResult());
                        continue block11;
                    }
                    default: {
                        zvkBrutto100Alt = zvkBrutto100Alt.add(vPos.getResult());
                    }
                }
            }
            if (zvkBruttoLfdAlt.compareTo(zvkBruttoLfdAkt) == 0 && zvkBruttoFiktivAlt.compareTo(zvkBruttoFiktivAkt) == 0 && zvkBruttoSdZAlt.compareTo(zvkBruttoSdZAkt) == 0 && zvkBrutto100Alt.compareTo(zvkBrutto100Akt) == 0) {
                this.callib.setUnchangedZVKBrutto(true);
            }
        }
    }

    private ValueType[] zvkBruttis() {
        return ValueTypeHelper.getValueTypes((int[])new int[]{100901, 100902, 100903, 100904, 100905, 100908});
    }

    private void erzeugeWertpositionen(BigDecimal eingangswert) throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)eingangswert)) {
            if (!this.eelib.isMarbZVKPflichtig()) {
                this.wplib.wertPosition().makeReadOnly();
            } else {
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzUmlageAn())) {
                    this.erzeugeANUmlage(eingangswert);
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzUmlageAg())) {
                    this.erzeugeAGUmlage(eingangswert);
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzZusatzbeitragAn())) {
                    this.erzeugeANZusatzbeitrag(eingangswert);
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzZusatzbeitragAg())) {
                    this.erzeugeAGZusatzbeitrag(eingangswert);
                }
                if (this.sanierungsgeldErzeugen()) {
                    this.erzeugeSanierungsgeld(eingangswert);
                }
            }
        }
    }

    private void erzeugeSanierungsgeld(BigDecimal eingangswert) throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 100901: {
                this.wplib.addNeueWertPosition(100911, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100902: 
            case 100905: {
                this.wplib.addNeueWertPosition(100912, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert.subtract(this.mAnteilMug), false);
                break;
            }
            case 100904: {
                this.wplib.addNeueWertPosition(100914, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100903: 
            case 100908: {
                this.wplib.addNeueWertPosition(100913, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
            }
        }
    }

    private void erzeugeAGZusatzbeitrag(BigDecimal eingangswert) throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 100901: {
                this.wplib.addNeueWertPosition(100931, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100902: 
            case 100905: {
                this.wplib.addNeueWertPosition(100932, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert.subtract(this.mAnteilMug), false);
                break;
            }
            case 100904: {
                this.wplib.addNeueWertPosition(100934, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100903: 
            case 100908: {
                this.wplib.addNeueWertPosition(100933, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
            }
        }
    }

    private void erzeugeANZusatzbeitrag(BigDecimal eingangswert) throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 100901: {
                this.wplib.addNeueWertPosition(100921, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100902: 
            case 100905: {
                this.wplib.addNeueWertPosition(100922, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert.subtract(this.mAnteilMug), false);
                break;
            }
            case 100904: {
                this.wplib.addNeueWertPosition(100924, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100903: 
            case 100908: {
                this.wplib.addNeueWertPosition(100923, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
            }
        }
    }

    private void erzeugeAGUmlage(BigDecimal eingangswert) throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 100901: {
                this.wplib.addNeueWertPosition(100951, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100902: 
            case 100905: {
                this.wplib.addNeueWertPosition(100952, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert.subtract(this.mAnteilMug), false);
                break;
            }
            case 100904: {
                this.wplib.addNeueWertPosition(100954, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100903: 
            case 100908: {
                this.wplib.addNeueWertPosition(100953, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
            }
        }
    }

    private void erzeugeANUmlage(BigDecimal eingangswert) throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 100901: {
                this.wplib.addNeueWertPosition(100941, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100902: 
            case 100905: {
                this.wplib.addNeueWertPosition(100942, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert.subtract(this.mAnteilMug), false);
                break;
            }
            case 100904: {
                this.wplib.addNeueWertPosition(100944, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
                break;
            }
            case 100903: 
            case 100908: {
                this.wplib.addNeueWertPosition(100943, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, eingangswert, false);
            }
        }
    }

    private boolean sanierungsgeldErzeugen() throws BusinessDomainException {
        return !this.gllib.zvkSanierungsGeldAlsBetrag();
    }

    private boolean zvkpflichtig() throws BusinessDomainException {
        boolean result = false;
        if ((this.eelib.marbAustritt() == null || DateHelper.afterOrEqual((Date)this.eelib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) && (this.eelib.zvkBerechnungZusatzbeitrag().value() != 0 || this.eelib.zvkBerechnungUmlage().value() != 0) && DateHelper.beforeOrEqual((Date)(this.eelib.marbZVKEintritt() == null ? new VDate(2010, 0, 1).getDate() : this.eelib.marbZVKEintritt()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb())) && DateHelper.afterOrEqual((Date)(this.eelib.marbZVKAustritt() == null ? new VDate(2099, 11, 31).getDate() : this.eelib.marbZVKAustritt()), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            result = true;
        }
        return result;
    }
}

