/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.evaluation.formula.LohnsteuerErmittlung2016Formula;
import com.varial.personnel.domain.evaluation.formula.LohnsteuerErmittlungDBA2025Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class LohnsteuerErmittlungDBA2016Formula
extends LohnsteuerErmittlung2016Formula {
    private static final BigDecimal BD10 = BigDecimal.valueOf(10L);
    private static final BigDecimal BD15 = BigDecimal.valueOf(15L);
    private static final BigDecimal BD1000000 = BigDecimal.valueOf(1000000L);
    private int land = 0;
    private int mLZZ = 0;
    private BigDecimal vfrblzz_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal brutto_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal dbafreib_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal stdba_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal stg_CENT_0NK = BigDecimal.ZERO;

    public LohnsteuerErmittlungDBA2016Formula(CalculationLibrary calcLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary glLibrary, boolean pauschaleSteuerermittlungATZ_KUG, boolean atz_IG_Metall) {
        super(calcLibrary, employeeLibrary, glLibrary, pauschaleSteuerermittlungATZ_KUG, atz_IG_Metall);
    }

    public void lstdba2016() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2025, 0, 1).getDate())) {
            new LohnsteuerErmittlungDBA2025Formula(this.callib, this.eelib, this.gllib, this.mPauschaleSteuerermittlungATZ_KUG).lstdba2025();
        } else {
            if (this.eelib.taxacation() == 12) {
                this.land = 1;
            }
            this.mLZZ = this.eelib.lzz();
            this.msst();
            this.lst2016();
            if (this.land == 1) {
                this.mvfrb();
            }
            this.mmaxst();
            this.callib.verbrFreibetrDBATR(this.vfrblzz_CENT_0NK.divide(BD100, 2, RoundingMode.HALF_UP));
        }
    }

    private void msst() {
        this.eelib.setLohnsteuerberechnungDBA(true);
        this.eelib.lzz(this.mLZZ);
        this.callib.entsch(BigDecimal.ZERO);
        this.callib.jre4(this.callib.jvbez());
        this.callib.re4(this.callib.vbez());
        this.callib.sonstb(this.callib.vbs());
        this.callib.vkapa(BigDecimal.ZERO);
        this.callib.vmt(BigDecimal.ZERO);
    }

    private void mvfrb() throws BusinessDomainException {
        this.jw_CENT_0NK = this.vfrb_CENT_0NK;
        this.upanteil();
        this.vfrblzz_CENT_0NK = this.anteil1_CENT_0NK.add(this.vfrbs2_CENT_0NK);
        if (this.eelib.stkl() == 1) {
            this.jw_CENT_0NK = this.wvfrb_CENT_0NK;
            this.upanteil();
            this.wvfrb_CENT_0NK = this.anteil1_CENT_0NK;
            this.jw_CENT_0NK = BD1000000;
            this.upanteil();
            this.dbafreib_CENT_0NK = this.anteil1_CENT_0NK.subtract(this.vfrblzz_CENT_0NK).add(this.vfrbs2_CENT_0NK);
            this.umvfrb();
        }
        this.msst();
        this.lst2016();
    }

    private void umvfrb() throws BusinessDomainException {
        if (this.dbafreib_CENT_0NK.compareTo(this.wvfrb_CENT_0NK) < 0) {
            this.eelib.lzzfreib(this.eelib.lzzfreib().add(this.dbafreib_CENT_0NK));
            this.vfrblzz_CENT_0NK = this.vfrblzz_CENT_0NK.add(this.dbafreib_CENT_0NK);
        } else {
            this.eelib.lzzfreib(this.eelib.lzzfreib().add(this.wvfrb_CENT_0NK));
            this.vfrblzz_CENT_0NK = this.vfrblzz_CENT_0NK.add(this.wvfrb_CENT_0NK);
        }
        this.dbafreib_CENT_0NK = BD1000000.subtract(this.vfrbs1_CENT_0NK).subtract(this.vfrbs2_CENT_0NK);
        if (this.dbafreib_CENT_0NK.compareTo(BigDecimal.ZERO) > 0) {
            if (this.dbafreib_CENT_0NK.compareTo(this.wvfrbm_CENT_0NK) < 0) {
                this.eelib.jfreib(this.eelib.jfreib().add(this.dbafreib_CENT_0NK));
                if (this.dbafreib_CENT_0NK.compareTo(this.wvfrbo_CENT_0NK) > 0) {
                    this.vfrblzz_CENT_0NK = this.vfrblzz_CENT_0NK.add(this.dbafreib_CENT_0NK).subtract(this.wvfrbo_CENT_0NK);
                }
            } else {
                this.eelib.jfreib(this.eelib.jfreib().add(this.wvfrbm_CENT_0NK));
                this.vfrblzz_CENT_0NK = this.vfrblzz_CENT_0NK.add(this.wvfrbm_CENT_0NK).subtract(this.wvfrbo_CENT_0NK);
            }
        }
    }

    private void mmaxst() throws BusinessDomainException {
        this.stg_CENT_0NK = this.callib.lstlzz().add(this.callib.solzlzz()).add(this.callib.sts()).add(this.callib.solzs());
        this.brutto_CENT_0NK = this.callib.vbez().add(this.callib.vbs());
        this.stdba_CENT_0NK = this.land == 1 ? this.brutto_CENT_0NK.multiply(BD10).divide(BD100, 0, RoundingMode.DOWN) : (this.land == 2 ? this.brutto_CENT_0NK.multiply(BD15).divide(BD100, 0, RoundingMode.DOWN) : (this.eelib.vjahr() < 2030 ? this.brutto_CENT_0NK.multiply(BD5).divide(BD100, 0, RoundingMode.DOWN) : this.brutto_CENT_0NK.multiply(BD10).divide(BD100, 0, RoundingMode.DOWN)));
        if (this.stdba_CENT_0NK.compareTo(this.stg_CENT_0NK) < 0) {
            this.st1_EURO_0NK = this.stg_CENT_0NK.subtract(this.stdba_CENT_0NK);
            if (this.callib.solzs().compareTo(this.st1_EURO_0NK) < 0) {
                this.st1_EURO_0NK = this.st1_EURO_0NK.subtract(this.callib.solzs());
                this.callib.solzs(BigDecimal.ZERO);
                if (this.callib.solzlzz().compareTo(this.st1_EURO_0NK) < 0) {
                    this.st1_EURO_0NK = this.st1_EURO_0NK.subtract(this.callib.solzlzz());
                    this.callib.solzlzz(BigDecimal.ZERO);
                    if (this.callib.sts().compareTo(this.st1_EURO_0NK) < 0) {
                        this.st1_EURO_0NK = this.st1_EURO_0NK.subtract(this.callib.sts());
                        this.callib.sts(BigDecimal.ZERO);
                        this.callib.lstlzz(this.callib.lstlzz().subtract(this.st1_EURO_0NK));
                    } else {
                        this.callib.sts(this.callib.sts().subtract(this.st1_EURO_0NK));
                    }
                } else {
                    this.callib.solzlzz(this.callib.solzlzz().subtract(this.st1_EURO_0NK));
                }
            } else {
                this.callib.solzs(this.callib.solzs().subtract(this.st1_EURO_0NK));
            }
        }
    }

    private void upanteil() {
        switch (this.mLZZ) {
            case 1: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK;
                break;
            }
            case 2: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK.divide(BD12, 0, RoundingMode.DOWN);
                break;
            }
            case 3: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK.multiply(BD7).divide(BD360, 0, RoundingMode.DOWN);
                break;
            }
            default: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK.divide(BD360, 0, RoundingMode.DOWN);
            }
        }
    }
}

