/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.employment;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.costunit.CostUnit;
import com.varial.personnel.domain.designationtype.designation.Designation;
import com.varial.personnel.domain.designationtype.personincharge.PersonInCharge;
import com.varial.personnel.domain.elo2.account.Elo2AccountPersistencyManager;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECalculationHistoric;
import com.varial.personnel.domain.employee.employment.DsmRgnOnPartOfEnum;
import com.varial.personnel.domain.employee.employment.EmploymentCategoryEnum;
import com.varial.personnel.domain.employee.employment.EmploymentData;
import com.varial.personnel.domain.employee.employment.GroupOfPerformanceEnum;
import com.varial.personnel.domain.employee.employment.IEmployment;
import com.varial.personnel.domain.employee.employment.IEmploymentPersistencyManager;
import com.varial.personnel.domain.employee.employment.InsolvencyDsmRgnReasonEnum;
import com.varial.personnel.domain.employee.employment.InsolvencyEntryReasonEnum;
import com.varial.personnel.domain.employee.employment.TypeOfEarnedIncomEnum;
import com.varial.personnel.domain.employee.employment.TypeOfEmploymentEnum;
import com.varial.personnel.domain.employee.employment.TypeOfTimeOffEnum;
import com.varial.personnel.domain.employee.employment.partcostcenter.IPartCostCenterPersistencyManager;
import com.varial.personnel.domain.employee.employment.partcostcenter.PartCostCenter;
import com.varial.personnel.domain.employee.employment.partcostunit.IPartCostUnitPersistencyManager;
import com.varial.personnel.domain.employee.employment.partcostunit.PartCostUnit;
import com.varial.personnel.domain.employee.employment.partemployeegroup.IPartEmployeeGroupPersistencyManager;
import com.varial.personnel.domain.employee.employment.partemployeegroup.PartEmployeeGroup;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.vblu.EEVBLU;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.global.occupation.Occupation;
import com.varial.personnel.domain.global.occupationgroup.OccupationGroup;
import com.varial.personnel.domain.global.state.State;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.math.BigDecimal;
import java.util.Date;

public class Employment
extends PersonnelTimedPersistenceObject
implements IEmployment {
    private static final int PRIORITY = 30;
    private Employee mEmployee;
    private Date mDateOfEntry;
    private Date mDateOfWithDrawal;
    private Date mDateOfEntrySI;
    private Date mDateOfWithDrawalSI;
    private Plant mPlant;
    private Designation mEmployeeCircle;
    private Designation mLocation;
    private CostCenter mCostCenter;
    private CostUnit mCostUnit;
    private Designation mOffice;
    private Designation mOrgUnit;
    private Designation mDepartment;
    private PersonInCharge mPersonInCharge1;
    private PersonInCharge mPersonInCharge2;
    private PersonInCharge mPersonInCharge3;
    private String mInHouseAddress;
    private String mDebitorCode;
    private String mCreditorCode;
    private String mEmployeeIdCard;
    private Date mContractStart;
    private Date mProbationStart;
    private Date mProbationEnd;
    private Date mAllowableEntryDate;
    private Date mEntryDateBranche;
    private Designation mEntryReason;
    private boolean mLimitedEmployment;
    private Date mEmploymentLtdBy;
    private boolean mLimitedWorkPermit;
    private Date mWorkPermitLtdBy;
    private boolean mLtdResidencePermit;
    private Date mResidPermitLtdBy;
    private Date mPassportValidTo;
    private Occupation mOccupationPriorER;
    private OccupationGroup mOccupationGroupPriorER;
    private Occupation mOccupationReEntry;
    private OccupationGroup mOccupationGroupReEntry;
    private Date mDateDsmRgn;
    private Date mDsmRgnBy;
    private Designation mDsmRgnReason;
    private Designation mWithDrawalReason;
    private DsmRgnOnPartOfEnum mDsmRgnOnPartOf;
    private BigDecimal mAmountCompensation;
    private PartCostCenter[] mPartCostCenters;
    private PartCostCenter[] mNewPartCostCenters;
    private PartEmployeeGroup[] mPartEmployeeGroups;
    private PartEmployeeGroup[] mNewPartEmployeeGroups;
    private PartCostUnit[] mPartCostUnits;
    private PartCostUnit[] mNewPartCostUnits;
    private EmploymentCategoryEnum mEmploymentCategory;
    private GroupOfPerformanceEnum mGroupOfPerformance;
    private String mPersonnelnumberOld;
    private Designation mEmployeeGroup;
    private Designation mEmployeeFunction;
    private Designation mScaleRule;
    private String mPaymentGroup;
    private String mPCompanyKeyOfMigration;
    private String mPersonnelnumberOfMigration;
    private TypeOfEmploymentEnum mTypeOfEmployment;
    private String mDiffWorkplacePostalcode;
    private String mDiffWorkplaceDomicile;
    private State mDiffWorkplaceState;
    private BigDecimal mEarnedIncome;
    private TypeOfEarnedIncomEnum mTypeOfEarnedIncome;
    private BigDecimal mNetIncome;
    private String mReasonForTransferU1;
    private String mReasonForTransferU2BT;
    private String mReasonForTransferU2ZU;
    private boolean mAutomaticPersonInCharge1;
    private boolean mAutomaticPersonInCharge2;
    private boolean mEarnedIncomeRelevantForCalculation;
    private TypeOfTimeOffEnum mTypeOfTimeOff;
    private BigDecimal mCarriedForwardMonthlyNetZU;
    private BigDecimal mCarriedForwardDailyNetZU;
    private boolean mAssignment;
    private BigDecimal mMaternityBenefit;
    private BigDecimal mAverageMonthlyGrossPay;
    private BigDecimal mAverageMonthlyNetPay;
    private BigDecimal mCalendarDailyNetPay;
    private Date mPresumableDateOfDelivery;
    private Date mAllowanceLtdBy;
    private InsolvencyEntryReasonEnum mInsolvencyEntryReason;
    private InsolvencyDsmRgnReasonEnum mInsolvencyDsmRgnReason;
    private PlantPlace mPlantPlace;
    private boolean mNoExportAsciiInfoSystem;
    private boolean mWithDrawalDeath;
    private int mAuCertificateFrom;
    private boolean mLimitedByPurpose;
    private boolean mPartCostCentersLoaded = false;
    private boolean mPartCostUnitsLoaded = false;
    private boolean mPartEmployeeGroupsLoaded = false;
    private Employment mOld = null;
    private boolean mSpecialChecks = true;
    public boolean mNoChecks = false;
    public boolean mCheckInsolvency = true;

    public Employment(Employee ee) {
        super(30);
        this.mEmployee = ee;
    }

    protected Employment(String objectID) {
        super(30, objectID);
    }

    public Employment(String objectID, int version, Employee ee) {
        super(30, objectID, version);
        this.mEmployee = ee;
    }

    protected Employment(boolean readOnly) {
        super(30, readOnly);
    }

    protected Employment(Employee ee, boolean readOnly) {
        super(30, readOnly);
        this.mEmployee = ee;
    }

    protected void load() {
        this.getEmploymentPM().load(this);
    }

    protected void saveImpl() {
        this.getEmploymentPM().save(this);
    }

    protected void deleteImpl() {
        this.getEmploymentPM().delete(this);
    }

    public void firstExecuteImpl() throws BusinessDomainException {
        int i;
        if (this.mNewPartCostCenters != null) {
            if (this.getPartCostCenters() != null) {
                for (i = 0; i < this.mPartCostCenters.length; ++i) {
                    this.mPartCostCenters[i].makeSaveable();
                    this.mPartCostCenters[i].unregisterLastExecute();
                    this.mPartCostCenters[i].destroy();
                }
            }
            for (i = 0; i < this.mNewPartCostCenters.length; ++i) {
                this.mNewPartCostCenters[i].makeSaveable();
                this.mNewPartCostCenters[i].registerForLastExecute();
            }
        }
        if (this.mNewPartEmployeeGroups != null) {
            if (this.getPartEmployeeGroups() != null) {
                for (i = 0; i < this.mPartEmployeeGroups.length; ++i) {
                    this.mPartEmployeeGroups[i].makeSaveable();
                    this.mPartEmployeeGroups[i].unregisterLastExecute();
                    this.mPartEmployeeGroups[i].destroy();
                }
            }
            for (i = 0; i < this.mNewPartEmployeeGroups.length; ++i) {
                this.mNewPartEmployeeGroups[i].makeSaveable();
                this.mNewPartEmployeeGroups[i].registerForLastExecute();
            }
        }
        if (this.mNewPartCostUnits != null) {
            if (this.getPartCostUnits() != null) {
                for (i = 0; i < this.mPartCostUnits.length; ++i) {
                    this.mPartCostUnits[i].makeSaveable();
                    this.mPartCostUnits[i].unregisterLastExecute();
                    this.mPartCostUnits[i].destroy();
                }
            }
            for (i = 0; i < this.mNewPartCostUnits.length; ++i) {
                this.mNewPartCostUnits[i].makeSaveable();
                this.mNewPartCostUnits[i].registerForLastExecute();
            }
        }
    }

    protected void destroyImpl() {
    }

    public void makeSaveable() {
        int i;
        super.makeSaveable();
        if (this.getPartCostCenters() != null) {
            for (i = 0; i < this.mPartCostCenters.length; ++i) {
                this.mPartCostCenters[i].makeSaveable();
            }
        }
        if (this.getPartEmployeeGroups() != null) {
            for (i = 0; i < this.mPartEmployeeGroups.length; ++i) {
                this.mPartEmployeeGroups[i].makeSaveable();
            }
        }
        if (this.getPartCostUnits() != null) {
            for (i = 0; i < this.mPartCostUnits.length; ++i) {
                this.mPartCostUnits[i].makeSaveable();
            }
        }
    }

    public void makeReadOnly() {
        int i;
        super.makeReadOnly();
        for (i = 0; i < this.getPartCostCenters().length; ++i) {
            this.mPartCostCenters[i].makeReadOnly();
        }
        if (this.mNewPartCostCenters != null) {
            for (i = 0; i < this.mNewPartCostCenters.length; ++i) {
                this.mNewPartCostCenters[i].makeReadOnly();
            }
        }
        for (i = 0; i < this.getPartEmployeeGroups().length; ++i) {
            this.mPartEmployeeGroups[i].makeReadOnly();
        }
        if (this.mNewPartEmployeeGroups != null) {
            for (i = 0; i < this.mNewPartEmployeeGroups.length; ++i) {
                this.mNewPartEmployeeGroups[i].makeReadOnly();
            }
        }
        for (i = 0; i < this.getPartCostUnits().length; ++i) {
            this.mPartCostUnits[i].makeReadOnly();
        }
        if (this.mNewPartCostUnits != null) {
            for (i = 0; i < this.mNewPartCostUnits.length; ++i) {
                this.mNewPartCostUnits[i].makeReadOnly();
            }
        }
    }

    public void registerForLastExecute() {
        int i;
        super.registerForLastExecute();
        if (this.getPartCostCenters() != null) {
            for (i = 0; i < this.mPartCostCenters.length; ++i) {
                this.mPartCostCenters[i].registerForLastExecute();
            }
        }
        if (this.mNewPartCostCenters != null) {
            for (i = 0; i < this.mNewPartCostCenters.length; ++i) {
                this.mNewPartCostCenters[i].registerForLastExecute();
            }
        }
        if (this.getPartEmployeeGroups() != null) {
            for (i = 0; i < this.mPartEmployeeGroups.length; ++i) {
                this.mPartEmployeeGroups[i].registerForLastExecute();
            }
        }
        if (this.mNewPartEmployeeGroups != null) {
            for (i = 0; i < this.mNewPartEmployeeGroups.length; ++i) {
                this.mNewPartEmployeeGroups[i].registerForLastExecute();
            }
        }
        if (this.getPartCostUnits() != null) {
            for (i = 0; i < this.mPartCostUnits.length; ++i) {
                this.mPartCostUnits[i].registerForLastExecute();
            }
        }
        if (this.mNewPartCostUnits != null) {
            for (i = 0; i < this.mNewPartCostUnits.length; ++i) {
                this.mNewPartCostUnits[i].registerForLastExecute();
            }
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mEmployee.getDomainKey()).append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    public void setData(EmploymentData data) {
        this.mEffectiveFrom = data.getEffectiveFrom();
        this.mEffectiveUntil = data.getEffectiveUntil();
        this.mValidFrom = data.getValidFrom();
        this.mValidUntil = data.getValidUntil();
        this.mDateOfEntry = data.getDateOfEntry();
        this.mDateOfWithDrawal = data.getDateOfWithDrawal();
        this.mDateOfEntrySI = data.getDateOfEntrySI();
        this.mDateOfWithDrawalSI = data.getDateOfWithDrawalSI();
        this.mContractStart = data.getContractStart();
        this.mProbationStart = data.getProbationStart();
        this.mProbationEnd = data.getProbationEnd();
        this.mAllowableEntryDate = data.getAllowableEntryDate();
        this.mEntryDateBranche = data.getEntryDateBranche();
        this.mEntryReason = data.getEntryReason();
        this.mLimitedEmployment = data.getLimitedEmployment();
        this.mEmploymentLtdBy = data.getEmploymentLtdBy();
        this.mLimitedWorkPermit = data.getLimitedWorkPermit();
        this.mWorkPermitLtdBy = data.getWorkPermitLtdBy();
        this.mLtdResidencePermit = data.getLtdResidencePermit();
        this.mResidPermitLtdBy = data.getResidPermitLtdBy();
        this.mPassportValidTo = data.getPassportValidTo();
        this.mOccupationPriorER = data.getOccupationPriorER();
        this.mOccupationGroupPriorER = data.getOccupationGroupPriorER();
        this.mOccupationReEntry = data.getOccupationReEntry();
        this.mOccupationGroupReEntry = data.getOccupationGroupReEntry();
        this.mDateDsmRgn = data.getDateDsmRgn();
        this.mDsmRgnBy = data.getDsmRgnBy();
        this.mDsmRgnReason = data.getDsmRgnReason();
        this.mWithDrawalReason = data.getWithDrawalReason();
        this.mDsmRgnOnPartOf = data.getDsmRgnOnPartOf();
        this.mAmountCompensation = data.getAmountCompensation();
        this.mPlant = data.getPlant();
        this.mEmployeeCircle = data.getEmployeeCircle();
        this.mEmployeeGroup = data.getEmployeeGroup();
        this.mEmployeeFunction = data.getEmployeeFunction();
        this.mLocation = data.getLocation();
        this.mCostCenter = data.getCostCenter();
        this.mCostUnit = data.getCostUnit();
        this.mOffice = data.getOffice();
        this.mOrgUnit = data.getOrgUnit();
        this.mDepartment = data.getDepartment();
        this.mPersonInCharge1 = data.getPersonInCharge1();
        this.mPersonInCharge2 = data.getPersonInCharge2();
        this.mPersonInCharge3 = data.getPersonInCharge3();
        this.mInHouseAddress = data.getInHouseAddress();
        this.mDebitorCode = data.getDebitorCode();
        this.mCreditorCode = data.getCreditorCode();
        this.mEmployeeIdCard = data.getEmployeeIdCard();
        this.mPartCostCenters = data.getPartCostCenters();
        this.mPartEmployeeGroups = data.getPartEmployeeGroups();
        this.mPartCostUnits = data.getPartCostUnits();
        this.mEmploymentCategory = data.getEmploymentCategory();
        this.mGroupOfPerformance = data.getGroupOfPerformance();
        this.mPersonnelnumberOld = data.getPersonnelnumberOld();
        this.mScaleRule = data.getScaleRule();
        this.mPaymentGroup = data.getPaymentGroup();
        this.mPCompanyKeyOfMigration = data.getPCompanyKeyOfMigration();
        this.mPersonnelnumberOfMigration = data.getPersonnelnumberOfMigration();
        this.mTypeOfEmployment = data.getTypeOfEmployment();
        this.mDiffWorkplacePostalcode = data.getDiffWorkplacePostalcode();
        this.mDiffWorkplaceDomicile = data.getDiffWorkplaceDomicile();
        this.mDiffWorkplaceState = data.getDiffWorkplaceState();
        this.mEarnedIncome = data.getEarnedIncome();
        this.mTypeOfEarnedIncome = data.getTypeOfEarnedIncome();
        this.mNetIncome = data.getNetIncome();
        this.mReasonForTransferU1 = data.getReasonForTransferU1();
        this.mReasonForTransferU2BT = data.getReasonForTransferU2BT();
        this.mReasonForTransferU2ZU = data.getReasonForTransferU2ZU();
        this.mAutomaticPersonInCharge1 = data.getAutomaticPersonInCharge1();
        this.mAutomaticPersonInCharge2 = data.getAutomaticPersonInCharge2();
        this.mEarnedIncomeRelevantForCalculation = data.getEarnedIncomeRelevantForCalculation();
        this.mTypeOfTimeOff = data.getTypeOfTimeOff();
        this.mCarriedForwardMonthlyNetZU = data.getCarriedForwardMonthlyNetZU();
        this.mCarriedForwardDailyNetZU = data.getCarriedForwardDailyNetZU();
        this.mAssignment = data.getAssignment();
        this.mMaternityBenefit = data.getMaternityBenefit();
        this.mAverageMonthlyGrossPay = data.getAverageMonthlyGrossPay();
        this.mAverageMonthlyNetPay = data.getAverageMonthlyNetPay();
        this.mCalendarDailyNetPay = data.getCalendarDailyNetPay();
        this.mPresumableDateOfDelivery = data.getPresumableDateofdelivery();
        this.mAllowanceLtdBy = data.getAllowanceLtdBy();
        this.mPlantPlace = data.getPlantPlace();
        this.mInsolvencyEntryReason = data.getInsolvencyEntryReason();
        this.mInsolvencyDsmRgnReason = data.getInsolvencyDsmRgnReason();
        this.mNoExportAsciiInfoSystem = data.getNoExportAsciiInfoSystem();
        this.mWithDrawalDeath = data.getWithDrawalDeath();
        this.mAuCertificateFrom = data.getAuCertificateFrom();
        this.mLimitedByPurpose = data.getLimitedByPurpose();
    }

    public Employment createNew() {
        PartCostUnit[] pcuArray;
        PartEmployeeGroup[] pegArray;
        int i;
        PartCostCenter[] pccArray;
        this.requireLoaded();
        Employment result = this.getEmploymentPM().createEmployment(this.mEmployee);
        result.mEffectiveFrom = this.mEffectiveFrom;
        result.mEffectiveUntil = this.mEffectiveUntil;
        result.mValidFrom = this.mValidFrom;
        result.mValidUntil = this.mValidUntil;
        result.mDateOfEntry = this.mDateOfEntry;
        result.mDateOfWithDrawal = this.mDateOfWithDrawal;
        result.mDateOfEntrySI = this.mDateOfEntrySI;
        result.mDateOfWithDrawalSI = this.mDateOfWithDrawalSI;
        result.mContractStart = this.mContractStart;
        result.mProbationStart = this.mProbationStart;
        result.mProbationEnd = this.mProbationEnd;
        result.mAllowableEntryDate = this.mAllowableEntryDate;
        result.mEntryDateBranche = this.mEntryDateBranche;
        result.mEntryReason = this.mEntryReason;
        result.mLimitedEmployment = this.mLimitedEmployment;
        result.mEmploymentLtdBy = this.mEmploymentLtdBy;
        result.mLimitedWorkPermit = this.mLimitedWorkPermit;
        result.mWorkPermitLtdBy = this.mWorkPermitLtdBy;
        result.mLtdResidencePermit = this.mLtdResidencePermit;
        result.mResidPermitLtdBy = this.mResidPermitLtdBy;
        result.mPassportValidTo = this.mPassportValidTo;
        result.mOccupationPriorER = this.mOccupationPriorER;
        result.mOccupationGroupPriorER = this.mOccupationGroupPriorER;
        result.mOccupationReEntry = this.mOccupationReEntry;
        result.mOccupationGroupReEntry = this.mOccupationGroupReEntry;
        result.mDateDsmRgn = this.mDateDsmRgn;
        result.mDsmRgnBy = this.mDsmRgnBy;
        result.mDsmRgnReason = this.mDsmRgnReason;
        result.mWithDrawalReason = this.mWithDrawalReason;
        result.mDsmRgnOnPartOf = this.mDsmRgnOnPartOf;
        result.mAmountCompensation = this.getAmountCompensation();
        result.mPlant = this.mPlant;
        result.mEmployeeCircle = this.mEmployeeCircle;
        result.mEmployeeGroup = this.mEmployeeGroup;
        result.mEmployeeFunction = this.mEmployeeFunction;
        result.mLocation = this.mLocation;
        result.mCostCenter = this.mCostCenter;
        result.mCostUnit = this.mCostUnit;
        result.mOffice = this.mOffice;
        result.mOrgUnit = this.mOrgUnit;
        result.mPersonInCharge1 = this.mPersonInCharge1;
        result.mDepartment = this.mDepartment;
        result.mPersonInCharge2 = this.mPersonInCharge2;
        result.mPersonInCharge3 = this.mPersonInCharge3;
        result.mInHouseAddress = this.mInHouseAddress;
        result.mDebitorCode = this.mDebitorCode;
        result.mCreditorCode = this.mCreditorCode;
        result.mEmployeeIdCard = this.mEmployeeIdCard;
        result.mEmploymentCategory = this.mEmploymentCategory;
        result.mGroupOfPerformance = this.mGroupOfPerformance;
        result.mPersonnelnumberOld = this.mPersonnelnumberOld;
        result.mScaleRule = this.mScaleRule;
        result.mPaymentGroup = this.mPaymentGroup;
        if (this.mNewPartCostCenters != null) {
            pccArray = new PartCostCenter[this.mNewPartCostCenters.length];
            for (i = 0; i < this.mNewPartCostCenters.length; ++i) {
                pccArray[i] = this.mNewPartCostCenters[i].createNew(result);
            }
            result.setPartCostCenters(pccArray);
        } else {
            pccArray = new PartCostCenter[this.getPartCostCenters().length];
            for (i = 0; i < this.mPartCostCenters.length; ++i) {
                pccArray[i] = this.mPartCostCenters[i].createNew(result);
            }
            result.setPartCostCenters(pccArray);
        }
        if (this.mNewPartEmployeeGroups != null) {
            pegArray = new PartEmployeeGroup[this.mNewPartEmployeeGroups.length];
            for (i = 0; i < this.mNewPartEmployeeGroups.length; ++i) {
                pegArray[i] = this.mNewPartEmployeeGroups[i].createNew(result);
            }
            result.setPartEmployeeGroups(pegArray);
        } else {
            pegArray = new PartEmployeeGroup[this.getPartEmployeeGroups().length];
            for (i = 0; i < this.mPartEmployeeGroups.length; ++i) {
                pegArray[i] = this.mPartEmployeeGroups[i].createNew(result);
            }
            result.setPartEmployeeGroups(pegArray);
        }
        if (this.mNewPartCostUnits != null) {
            pcuArray = new PartCostUnit[this.mNewPartCostUnits.length];
            for (i = 0; i < this.mNewPartCostUnits.length; ++i) {
                pcuArray[i] = this.mNewPartCostUnits[i].createNew(result);
            }
            result.setPartCostUnits(pcuArray);
        } else {
            pcuArray = new PartCostUnit[this.getPartCostUnits().length];
            for (i = 0; i < this.mPartCostUnits.length; ++i) {
                pcuArray[i] = this.mPartCostUnits[i].createNew(result);
            }
            result.setPartCostUnits(pcuArray);
        }
        result.mPCompanyKeyOfMigration = this.mPCompanyKeyOfMigration;
        result.mPersonnelnumberOfMigration = this.mPersonnelnumberOfMigration;
        result.mTypeOfEmployment = this.mTypeOfEmployment;
        result.mDiffWorkplacePostalcode = this.mDiffWorkplacePostalcode;
        result.mDiffWorkplaceDomicile = this.mDiffWorkplaceDomicile;
        result.mDiffWorkplaceState = this.mDiffWorkplaceState;
        result.mEarnedIncome = this.mEarnedIncome;
        result.mTypeOfEarnedIncome = this.mTypeOfEarnedIncome;
        result.mNetIncome = this.mNetIncome;
        result.mReasonForTransferU1 = this.mReasonForTransferU1;
        result.mReasonForTransferU2BT = this.mReasonForTransferU2BT;
        result.mReasonForTransferU2ZU = this.mReasonForTransferU2ZU;
        result.mAutomaticPersonInCharge1 = this.mAutomaticPersonInCharge1;
        result.mAutomaticPersonInCharge2 = this.mAutomaticPersonInCharge2;
        result.mEarnedIncomeRelevantForCalculation = this.mEarnedIncomeRelevantForCalculation;
        result.mTypeOfTimeOff = this.mTypeOfTimeOff;
        result.mCarriedForwardMonthlyNetZU = this.mCarriedForwardMonthlyNetZU;
        result.mCarriedForwardDailyNetZU = this.mCarriedForwardDailyNetZU;
        result.mAssignment = this.mAssignment;
        result.mMaternityBenefit = this.mMaternityBenefit;
        result.mAverageMonthlyGrossPay = this.mAverageMonthlyGrossPay;
        result.mAverageMonthlyNetPay = this.mAverageMonthlyNetPay;
        result.mCalendarDailyNetPay = this.mCalendarDailyNetPay;
        result.mPresumableDateOfDelivery = this.mPresumableDateOfDelivery;
        result.mAllowanceLtdBy = this.mAllowanceLtdBy;
        result.mPlantPlace = this.mPlantPlace;
        result.mInsolvencyEntryReason = this.mInsolvencyEntryReason;
        result.mInsolvencyDsmRgnReason = this.mInsolvencyDsmRgnReason;
        result.mNoExportAsciiInfoSystem = this.mNoExportAsciiInfoSystem;
        result.mWithDrawalDeath = this.mWithDrawalDeath;
        result.mAuCertificateFrom = this.mAuCertificateFrom;
        result.mLimitedByPurpose = this.mLimitedByPurpose;
        return result;
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public Date getDateOfEntry() {
        this.requireLoaded();
        return this.mDateOfEntry;
    }

    public void setDateOfEntry(Date dateOfEntry) {
        this.mDateOfEntry = dateOfEntry;
    }

    public Date getDateOfWithDrawal() {
        this.requireLoaded();
        return this.mDateOfWithDrawal;
    }

    public void setDateOfWithDrawal(Date dateOfWithDrawal) {
        this.mDateOfWithDrawal = dateOfWithDrawal;
    }

    public Date getDateOfEntrySI() {
        this.requireLoaded();
        return this.mDateOfEntrySI;
    }

    public void setDateOfEntrySI(Date dateOfEntrySI) {
        this.mDateOfEntrySI = dateOfEntrySI;
    }

    public Date getDateOfWithDrawalSI() {
        this.requireLoaded();
        return this.mDateOfWithDrawalSI;
    }

    public void setDateOfWithDrawalSI(Date dateOfWithDrawalSI) {
        this.mDateOfWithDrawalSI = dateOfWithDrawalSI;
    }

    public Date getContractStart() {
        this.requireLoaded();
        return this.mContractStart;
    }

    public void setContractStart(Date contractStart) {
        this.mContractStart = contractStart;
    }

    public Date getProbationStart() {
        this.requireLoaded();
        return this.mProbationStart;
    }

    public void setProbationStart(Date probationStart) {
        this.mProbationStart = probationStart;
    }

    public Date getProbationEnd() {
        this.requireLoaded();
        return this.mProbationEnd;
    }

    public void setProbationEnd(Date probationEnd) {
        this.mProbationEnd = probationEnd;
    }

    public Date getAllowableEntryDate() {
        this.requireLoaded();
        return this.mAllowableEntryDate;
    }

    public void setAllowableEntryDate(Date allowableEntryDate) {
        this.mAllowableEntryDate = allowableEntryDate;
    }

    public Date getEntryDateBranche() {
        this.requireLoaded();
        return this.mEntryDateBranche;
    }

    public void setEntryDateBranche(Date entryDateBranche) {
        this.mEntryDateBranche = entryDateBranche;
    }

    public Designation getEntryReason() {
        this.requireLoaded();
        return this.mEntryReason;
    }

    public void setEntryReason(Designation entryReason) {
        this.mEntryReason = entryReason;
    }

    public boolean getLimitedEmployment() {
        this.requireLoaded();
        return this.mLimitedEmployment;
    }

    public void setLimitedEmployment(boolean limitedEmployment) {
        this.mLimitedEmployment = limitedEmployment;
    }

    public Date getEmploymentLtdBy() {
        this.requireLoaded();
        return this.mEmploymentLtdBy;
    }

    public void setEmploymentLtdBy(Date employmentLtdBy) {
        this.mEmploymentLtdBy = employmentLtdBy;
    }

    public boolean getLimitedWorkPermit() {
        this.requireLoaded();
        return this.mLimitedWorkPermit;
    }

    public void setLimitedWorkPermit(boolean limitedWorkPermit) {
        this.mLimitedWorkPermit = limitedWorkPermit;
    }

    public Date getWorkPermitLtdBy() {
        this.requireLoaded();
        return this.mWorkPermitLtdBy;
    }

    public void setWorkPermitLtdBy(Date workPermitLtdBy) {
        this.mWorkPermitLtdBy = workPermitLtdBy;
    }

    public boolean getLtdResidencePermit() {
        this.requireLoaded();
        return this.mLtdResidencePermit;
    }

    public void setLtdResidencePermit(boolean ltdResidencePermit) {
        this.mLtdResidencePermit = ltdResidencePermit;
    }

    public Date getResidPermitLtdBy() {
        this.requireLoaded();
        return this.mResidPermitLtdBy;
    }

    public void setResidPermitLtdBy(Date residPermitLtdBy) {
        this.mResidPermitLtdBy = residPermitLtdBy;
    }

    public Date getPassportValidTo() {
        this.requireLoaded();
        return this.mPassportValidTo;
    }

    public void setPassportValidTo(Date passportValidTo) {
        this.mPassportValidTo = passportValidTo;
    }

    public Occupation getOccupationPriorER() {
        this.requireLoaded();
        return this.mOccupationPriorER;
    }

    public void setOccupationPriorER(Occupation occupationPriorER) {
        this.mOccupationPriorER = occupationPriorER;
    }

    public OccupationGroup getOccupationGroupPriorER() {
        this.requireLoaded();
        return this.mOccupationGroupPriorER;
    }

    public void setOccupationGroupPriorER(OccupationGroup occupationGroupPriorER) {
        this.mOccupationGroupPriorER = occupationGroupPriorER;
    }

    public Occupation getOccupationReEntry() {
        this.requireLoaded();
        return this.mOccupationReEntry;
    }

    public void setOccupationReEntry(Occupation occupationReEntry) {
        this.mOccupationReEntry = occupationReEntry;
    }

    public OccupationGroup getOccupationGroupReEntry() {
        this.requireLoaded();
        return this.mOccupationGroupReEntry;
    }

    public void setOccupationGroupReEntry(OccupationGroup occupationGroupReEntry) {
        this.mOccupationGroupReEntry = occupationGroupReEntry;
    }

    public Date getDateDsmRgn() {
        this.requireLoaded();
        return this.mDateDsmRgn;
    }

    public void setDateDsmRgn(Date dateDsmRgn) {
        this.mDateDsmRgn = dateDsmRgn;
    }

    public Date getDsmRgnBy() {
        this.requireLoaded();
        return this.mDsmRgnBy;
    }

    public void setDsmRgnBy(Date dsmRgnBy) {
        this.mDsmRgnBy = dsmRgnBy;
    }

    public Designation getDsmRgnReason() {
        this.requireLoaded();
        return this.mDsmRgnReason;
    }

    public void setDsmRgnReason(Designation dsmRgnReason) {
        this.mDsmRgnReason = dsmRgnReason;
    }

    public Designation getWithDrawalReason() {
        this.requireLoaded();
        return this.mWithDrawalReason;
    }

    public void setWithDrawalReason(Designation withDrawalReason) {
        this.mWithDrawalReason = withDrawalReason;
    }

    public DsmRgnOnPartOfEnum getDsmRgnOnPartOf() {
        this.requireLoaded();
        return this.mDsmRgnOnPartOf;
    }

    public void setDsmRgnOnPartOf(DsmRgnOnPartOfEnum dsmRgnOnPartOf) {
        this.mDsmRgnOnPartOf = dsmRgnOnPartOf;
    }

    public BigDecimal getAmountCompensation() {
        this.requireLoaded();
        return this.mAmountCompensation == null ? BigDecimal.valueOf(0L, 2) : this.mAmountCompensation;
    }

    public void setAmountCompensation(BigDecimal amountCompensation) {
        this.mAmountCompensation = amountCompensation;
    }

    public Plant getPlant() {
        this.requireLoaded();
        return this.mPlant;
    }

    public void setPlant(Plant plant) {
        this.mPlant = plant;
    }

    public Designation getEmployeeCircle() {
        this.requireLoaded();
        return this.mEmployeeCircle;
    }

    public void setEmployeeCircle(Designation employeeCircle) {
        this.mEmployeeCircle = employeeCircle;
    }

    public Designation getEmployeeGroup() {
        this.requireLoaded();
        return this.mEmployeeGroup;
    }

    public void setEmployeeGroup(Designation employeeGroup) {
        this.mEmployeeGroup = employeeGroup;
    }

    public Designation getEmployeeFunction() {
        this.requireLoaded();
        return this.mEmployeeFunction;
    }

    public void setEmployeeFunction(Designation employeeFunction) {
        this.mEmployeeFunction = employeeFunction;
    }

    public Designation getLocation() {
        this.requireLoaded();
        return this.mLocation;
    }

    public void setLocation(Designation location) {
        this.mLocation = location;
    }

    public CostCenter getCostCenter() {
        this.requireLoaded();
        return this.mCostCenter;
    }

    public void setCostCenter(CostCenter costCenter) {
        this.mCostCenter = costCenter;
    }

    public CostUnit getCostUnit() {
        this.requireLoaded();
        return this.mCostUnit;
    }

    public void setCostUnit(CostUnit costUnit) {
        this.mCostUnit = costUnit;
    }

    public Designation getOffice() {
        this.requireLoaded();
        return this.mOffice;
    }

    public void setOffice(Designation office) {
        this.mOffice = office;
    }

    public Designation getOrgUnit() {
        this.requireLoaded();
        return this.mOrgUnit;
    }

    public void setOrgUnit(Designation orgUnit) {
        this.mOrgUnit = orgUnit;
    }

    public Designation getDepartment() {
        this.requireLoaded();
        return this.mDepartment;
    }

    public void setDepartment(Designation department) {
        this.mDepartment = department;
    }

    public PersonInCharge getPersonInCharge1() {
        this.requireLoaded();
        return this.mPersonInCharge1;
    }

    public void setPersonInCharge1(PersonInCharge personInCharge1) {
        this.mPersonInCharge1 = personInCharge1;
    }

    public PersonInCharge getPersonInCharge2() {
        this.requireLoaded();
        return this.mPersonInCharge2;
    }

    public void setPersonInCharge2(PersonInCharge personInCharge2) {
        this.mPersonInCharge2 = personInCharge2;
    }

    public PersonInCharge getPersonInCharge3() {
        this.requireLoaded();
        return this.mPersonInCharge3;
    }

    public void setPersonInCharge3(PersonInCharge personInCharge3) {
        this.mPersonInCharge3 = personInCharge3;
    }

    public String getInHouseAddress() {
        this.requireLoaded();
        return this.mInHouseAddress;
    }

    public void setInHouseAddress(String inHouseAddress) {
        this.mInHouseAddress = inHouseAddress;
    }

    public String getDebitorCode() {
        this.requireLoaded();
        return this.mDebitorCode;
    }

    public void setDebitorCode(String debitorCode) {
        this.mDebitorCode = debitorCode;
    }

    public String getCreditorCode() {
        this.requireLoaded();
        return this.mCreditorCode;
    }

    public void setCreditorCode(String creditorCode) {
        this.mCreditorCode = creditorCode;
    }

    public String getEmployeeIdCard() {
        this.requireLoaded();
        return this.mEmployeeIdCard;
    }

    public void setEmployeeIdCard(String employeeIdCard) {
        this.mEmployeeIdCard = employeeIdCard;
    }

    public PartCostCenter[] getPartCostCenters() {
        if (!this.mPartCostCentersLoaded) {
            this.mPartCostCenters = ((IPartCostCenterPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("partCostCenterPersistencyManager", IPartCostCenterPersistencyManager.class)).getPartCostCenters(this);
            this.mPartCostCentersLoaded = true;
        }
        return this.mPartCostCenters;
    }

    public void setPartCostCenters(PartCostCenter[] partCostCenters) {
        this.mNewPartCostCenters = partCostCenters;
    }

    public PartEmployeeGroup[] getPartEmployeeGroups() {
        if (!this.mPartEmployeeGroupsLoaded) {
            this.mPartEmployeeGroups = ((IPartEmployeeGroupPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("partEmployeeGroupPersistencyManager", IPartEmployeeGroupPersistencyManager.class)).getPartEmployeeGroup(this);
            this.mPartEmployeeGroupsLoaded = true;
        }
        return this.mPartEmployeeGroups;
    }

    public void setPartEmployeeGroups(PartEmployeeGroup[] partEmployeeGroups) {
        this.mNewPartEmployeeGroups = partEmployeeGroups;
    }

    public PartCostUnit[] getPartCostUnits() {
        if (!this.mPartCostUnitsLoaded) {
            this.mPartCostUnits = ((IPartCostUnitPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("partCostUnitPersistencyManager", IPartCostUnitPersistencyManager.class)).getPartCostUnit(this);
            this.mPartCostUnitsLoaded = true;
        }
        return this.mPartCostUnits;
    }

    public void setPartCostUnits(PartCostUnit[] partCostUnits) {
        this.mNewPartCostUnits = partCostUnits;
    }

    public EmploymentCategoryEnum getEmploymentCategory() {
        this.requireLoaded();
        return this.mEmploymentCategory;
    }

    public void setEmploymentCategory(EmploymentCategoryEnum employmentCategory) {
        this.mEmploymentCategory = employmentCategory;
    }

    public GroupOfPerformanceEnum getGroupOfPerformance() {
        this.requireLoaded();
        return this.mGroupOfPerformance;
    }

    public void setGroupOfPerformance(GroupOfPerformanceEnum groupOfPerformance) {
        this.mGroupOfPerformance = groupOfPerformance;
    }

    public String getPersonnelnumberOld() {
        this.requireLoaded();
        return this.mPersonnelnumberOld;
    }

    public void setPersonnelnumberOld(String personnelnumberOld) {
        this.mPersonnelnumberOld = personnelnumberOld;
    }

    public Designation getScaleRule() {
        this.requireLoaded();
        return this.mScaleRule;
    }

    public void setScaleRule(Designation scaleRule) {
        this.mScaleRule = scaleRule;
    }

    public String getPaymentGroup() {
        this.requireLoaded();
        return this.mPaymentGroup;
    }

    public void setPaymentGroup(String paymentGroup) {
        this.mPaymentGroup = paymentGroup;
    }

    public void checkAttributes() throws BusinessDomainException {
        this.requireLoaded();
        this.mEmployee.checkAttributes();
        this.checkDates();
        this.checkDateOfEntry();
        this.checkDependencyFromDateOfEntry();
        this.checkAssignments();
        this.checkTimePeriods();
        this.checkCompDependentAssignments();
        if (this.mNoChecks) {
            return;
        }
        if (this.mSpecialChecks) {
            this.specialCheckDates();
        }
        this.checkDatesOfWithDrawalAndDatesOfDsmRgn();
        this.checkProbation();
        this.checkNewPartCostCenters();
        this.checkVWECostCenters();
        this.checkNewPartEmployeeGroups();
        this.checkNewPartCostUnits();
        this.checkCreateOfTaskReminderIsNecessary();
        if (this.mSpecialChecks) {
            this.checkPlantPlace();
        }
        this.checkTypeOfEarnedIncomAndTypeOfTimeOff();
        this.checkPersonnelnumberAndElstam();
        if (this.mCheckInsolvency) {
            this.checkInsolvency();
        }
    }

    private void checkDependencyFromDateOfEntry() throws BusinessDomainException {
        if (this.mEmploymentLtdBy != null && DateHelper.before((Date)this.mEmploymentLtdBy, (Date)this.mDateOfEntry)) {
            throw EmployeeExceptionMapper.makeDependencyFromDateOfEntryFalseDomainException((String)"befristetes Arbeitsverh\u00e4ltnis bis");
        }
        if (this.mWorkPermitLtdBy != null && DateHelper.before((Date)this.mWorkPermitLtdBy, (Date)this.mDateOfEntry)) {
            throw EmployeeExceptionMapper.makeDependencyFromDateOfEntryFalseDomainException((String)"befristetes Arbeitserlaubnis bis");
        }
        if (this.mResidPermitLtdBy != null && DateHelper.before((Date)this.mResidPermitLtdBy, (Date)this.mDateOfEntry)) {
            throw EmployeeExceptionMapper.makeDependencyFromDateOfEntryFalseDomainException((String)"befristetes Aufenthaltserlaubnis bis");
        }
    }

    private void checkInsolvency() throws BusinessDomainException {
        if (this.mInsolvencyEntryReason != InsolvencyEntryReasonEnum.IERE_E0 && this.getStatusByInsolvency() != StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN && this.getStatusByInsolvency() != StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN && this.getStatusByInsolvency() != StatusByInsolvencyEnum.SBIE_FUER_WEITERBESCHAEFTIGTE_AN) {
            throw EmployeeExceptionMapper.makeInsolvenyEntryReasonNotAllowedDomainException();
        }
        if (this.mInsolvencyDsmRgnReason != InsolvencyDsmRgnReasonEnum.IDRRE_A0 && this.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_KEINEN) {
            throw EmployeeExceptionMapper.makeInsolvenyWithdrawalReasonNotAllowedDomainException();
        }
        if (this.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_INSOLVENT) {
            Date dateMarginal = this.mEmployee.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getFoundations().getInsolventlyFrom();
            if (dateMarginal != null) {
                if (this.mDateOfWithDrawal != null && DateHelper.equal((Date)this.mDateOfWithDrawal, (Date)DateHelper.yesterday((Date)dateMarginal))) {
                    if (this.mInsolvencyDsmRgnReason == InsolvencyDsmRgnReasonEnum.IDRRE_A0) {
                        throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Austrittsgrund bei Insolvenz");
                    }
                } else if (this.mInsolvencyDsmRgnReason != InsolvencyDsmRgnReasonEnum.IDRRE_A0) {
                    throw EmployeeExceptionMapper.makeInsolvenyWithdrawalReasonNotValidDomainException();
                }
            }
            if (this.mInsolvencyDsmRgnReason == InsolvencyDsmRgnReasonEnum.IDRRE_A4) {
                throw EmployeeExceptionMapper.makeInsolvenyWithdrawalReasonNotValidDomainException();
            }
        }
        if (this.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_WEITERBESCHAEFTIGTE_AN) {
            if (this.mInsolvencyEntryReason == InsolvencyEntryReasonEnum.IERE_E0) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Eintrittsgrund bei Insolvenz");
            }
            if (this.mInsolvencyEntryReason == InsolvencyEntryReasonEnum.IERE_E3) {
                throw EmployeeExceptionMapper.makeInsolvenyEntryReasonNotValidDomainException();
            }
            if (this.mInsolvencyDsmRgnReason != InsolvencyDsmRgnReasonEnum.IDRRE_A1 && this.mInsolvencyDsmRgnReason != InsolvencyDsmRgnReasonEnum.IDRRE_A2 && this.mInsolvencyDsmRgnReason != InsolvencyDsmRgnReasonEnum.IDRRE_A3) {
                throw EmployeeExceptionMapper.makeInsolvenyWithdrawalReasonNotValidDomainException();
            }
        }
        if (this.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN || this.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN) {
            if (this.mInsolvencyEntryReason == InsolvencyEntryReasonEnum.IERE_E0) {
                throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Eintrittsgrund bei Insolvenz");
            }
            if (this.mInsolvencyEntryReason != InsolvencyEntryReasonEnum.IERE_E3) {
                throw EmployeeExceptionMapper.makeInsolvenyEntryReasonNotValidDomainException();
            }
            if (this.mDateOfWithDrawal != null && this.mInsolvencyDsmRgnReason != InsolvencyDsmRgnReasonEnum.IDRRE_A4) {
                throw EmployeeExceptionMapper.makeInsolvenyWithdrawalReasonNotValidDomainException();
            }
        }
    }

    private StatusByInsolvencyEnum getStatusByInsolvency() throws BusinessDomainException {
        return this.mEmployee.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getFoundations().getStatusByInsolvency();
    }

    private void checkPersonnelnumberAndElstam() throws BusinessDomainException {
        long count;
        if (this.mOld == null) {
            return;
        }
        if (this.mEmployee.getPersonnelnumber() != this.mOld.getEmployee().getPersonnelnumber() && (count = Elo2AccountPersistencyManager.getRowCount((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"reasonofdelivery", (String)"0"), Restrictions.eq((String)"reasonofdelivery", (String)"1"), Restrictions.eq((String)"reasonofdelivery", (String)"2")}), Restrictions.ne((String)"additionalenum1", (String)"4"), Restrictions.eq((String)"deleted", (String)"F")}))) > 0L) {
            throw EmployeeExceptionMapper.makeChangeOfPnoNotAllowedDomainException();
        }
    }

    protected void checkTypeOfEarnedIncomAndTypeOfTimeOff() throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEarnedIncome)) {
            return;
        }
        if (this.mTypeOfEarnedIncome == TypeOfEarnedIncomEnum.TOEIE_STUNDENLOHN) {
            if (this.mTypeOfTimeOff != TypeOfTimeOffEnum.TOTOE_ARBEITSSTUNDEN) {
                throw EmployeeExceptionMapper.makeCombinationTypeOfEarnedAndTypeOfTimeOffFalseDomainException();
            }
            return;
        }
        if (this.mTypeOfEarnedIncome == TypeOfEarnedIncomEnum.TOEIE_MONATSLOHN && this.mTypeOfTimeOff != TypeOfTimeOffEnum.TOTOE_KALENDERTAGE && this.mTypeOfTimeOff != TypeOfTimeOffEnum.TOTOE_ARBEITSTAGE) {
            throw EmployeeExceptionMapper.makeCombinationTypeOfEarnedAndTypeOfTimeOffFalseDomainException();
        }
    }

    private void checkProbation() throws BusinessDomainException {
        if (this.mProbationStart == null && this.mProbationEnd == null) {
            return;
        }
        if (this.mProbationStart == null && this.mProbationEnd != null || this.mProbationStart != null && this.mProbationEnd == null) {
            throw EmployeeExceptionMapper.makeProbationDateNotPlausibleDomainException();
        }
        if (DateHelper.before((Date)this.mProbationEnd, (Date)this.mProbationStart)) {
            throw EmployeeExceptionMapper.makeProbationDateNotPlausibleDomainException();
        }
    }

    private void checkTimePeriods() throws BusinessDomainException {
        this.checkTimePeriods((PersonnelPersistenceObject)this.mPlant);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mEmployeeCircle);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mEmployeeGroup);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mEmployeeFunction);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mLocation);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mCostCenter);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mCostUnit);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mOffice);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mOrgUnit);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mDepartment);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mPersonInCharge1);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mPersonInCharge2);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mPersonInCharge3);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mEntryReason);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mOccupationPriorER);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mOccupationGroupPriorER);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mOccupationReEntry);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mOccupationGroupReEntry);
        this.checkTimePeriods((PersonnelPersistenceObject)this.mDsmRgnReason);
    }

    public void checkCreateOfTaskReminderIsNecessary() {
        this.requireLoaded();
        if (this.mOld != null) {
            this.mOld.requireLoaded();
        }
        String reminderName = "";
        String reminderNameOld = "";
        Date actDate = new Date();
        if (this.mEmployee.isNew() && this.mProbationEnd != null && DateHelper.after((Date)this.mProbationEnd, (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf der Probezeit ");
            this.createTaskReminder(reminderName, this.mProbationEnd);
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.mProbationEnd, (Date)this.mProbationEnd)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf der Probezeit ");
            reminderNameOld = new StringBuffer("Ablauf der Probezeit f\u00fcr Firma/PNR: ").append(this.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.mProbationEnd != null) {
                TaskReminderHelper.deleteTaskReminder((String)reminderNameOld, (Date)this.mOld.mProbationEnd);
                TaskReminderHelper.deleteTaskReminder((String)reminderName, (Date)this.mOld.mProbationEnd);
            }
            if (this.mProbationEnd != null && DateHelper.after((Date)this.mProbationEnd, (Date)actDate)) {
                this.createTaskReminder(reminderName, this.mProbationEnd);
            }
        }
        if (this.mEmployee.isNew() && this.mEmploymentLtdBy != null && DateHelper.after((Date)this.mEmploymentLtdBy, (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf befristetes Arbeitsverh\u00e4ltnis ");
            this.createTaskReminder(reminderName, this.mEmploymentLtdBy);
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.mEmploymentLtdBy, (Date)this.mEmploymentLtdBy)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf befristetes Arbeitsverh\u00e4ltnis ");
            reminderNameOld = new StringBuffer("Ablauf befristetes Arbeitsverh\u00e4ltnis f\u00fcr Firma/Pnr: ").append(this.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.mEmploymentLtdBy != null) {
                TaskReminderHelper.deleteTaskReminder((String)reminderNameOld, (Date)this.mOld.mEmploymentLtdBy);
                TaskReminderHelper.deleteTaskReminder((String)reminderName, (Date)this.mOld.mEmploymentLtdBy);
            }
            if (this.mEmploymentLtdBy != null && DateHelper.after((Date)this.mEmploymentLtdBy, (Date)actDate)) {
                this.createTaskReminder(reminderName, this.mEmploymentLtdBy);
            }
        }
        if (this.mEmployee.isNew() && this.mWorkPermitLtdBy != null && DateHelper.after((Date)this.mWorkPermitLtdBy, (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf befristete Arbeitserlaubnis ");
            this.createTaskReminder(reminderName, this.mWorkPermitLtdBy);
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.mWorkPermitLtdBy, (Date)this.mWorkPermitLtdBy)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf befristete Arbeitserlaubnis ");
            reminderNameOld = new StringBuffer("Ablauf befristete Arbeitserlaubnis f\u00fcr Firma/Pnr: ").append(this.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.mWorkPermitLtdBy != null) {
                TaskReminderHelper.deleteTaskReminder((String)reminderNameOld, (Date)this.mOld.mWorkPermitLtdBy);
                TaskReminderHelper.deleteTaskReminder((String)reminderName, (Date)this.mOld.mWorkPermitLtdBy);
            }
            if (this.mWorkPermitLtdBy != null && DateHelper.after((Date)this.mWorkPermitLtdBy, (Date)actDate)) {
                this.createTaskReminder(reminderName, this.mWorkPermitLtdBy);
            }
        }
        if (this.mEmployee.isNew() && this.mResidPermitLtdBy != null && DateHelper.after((Date)this.mResidPermitLtdBy, (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf befristete Aufenthaltserlaubnis ");
            this.createTaskReminder(reminderName, this.mResidPermitLtdBy);
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.mResidPermitLtdBy, (Date)this.mResidPermitLtdBy)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf befristete Aufenthaltserlaubnis ");
            reminderNameOld = new StringBuffer("Ablauf befristete Aufenthaltserlaubnis f\u00fcr Firma/Pnr: ").append(this.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.mResidPermitLtdBy != null) {
                TaskReminderHelper.deleteTaskReminder((String)reminderNameOld, (Date)this.mOld.mResidPermitLtdBy);
                TaskReminderHelper.deleteTaskReminder((String)reminderName, (Date)this.mOld.mResidPermitLtdBy);
            }
            if (this.mResidPermitLtdBy != null) {
                this.createTaskReminder(reminderName, this.mResidPermitLtdBy);
            }
        }
        if (this.mEmployee.isNew() && this.mDateOfWithDrawal != null && DateHelper.after((Date)this.mDateOfWithDrawal, (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Austritt ");
            this.createTaskReminder(reminderName, this.mDateOfWithDrawal);
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.mDateOfWithDrawal, (Date)this.mDateOfWithDrawal)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Austritt ");
            reminderNameOld = new StringBuffer("Austritt f\u00fcr Firma/Pnr: ").append(this.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.mDateOfWithDrawal != null) {
                TaskReminderHelper.deleteTaskReminder((String)reminderNameOld, (Date)this.mOld.mDateOfWithDrawal);
                TaskReminderHelper.deleteTaskReminder((String)reminderName, (Date)this.mOld.mDateOfWithDrawal);
            }
            if (this.mDateOfWithDrawal != null && DateHelper.after((Date)this.mDateOfWithDrawal, (Date)actDate)) {
                this.createTaskReminder(reminderName, this.mDateOfWithDrawal);
            }
        }
        if (this.mEmployee.isNew() && this.mAllowanceLtdBy != null && DateHelper.after((Date)this.mAllowanceLtdBy, (Date)actDate)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf Studienbescheinigung ");
            this.createTaskReminder(reminderName, this.mAllowanceLtdBy);
        }
        if (this.mOld != null && !DateHelper.equal((Date)this.mOld.mAllowanceLtdBy, (Date)this.mAllowanceLtdBy)) {
            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Ablauf Studienbescheinigung ");
            reminderNameOld = new StringBuffer("Ablauf Studienbescheinigung f\u00fcr Firma/Pnr: ").append(this.getPCompany().getPCompanyKey()).append(" / ").append(this.mEmployee.getPersonnelnumber()).toString();
            if (this.mOld.mAllowanceLtdBy != null) {
                TaskReminderHelper.deleteTaskReminder((String)reminderNameOld, (Date)this.mOld.mAllowanceLtdBy);
                TaskReminderHelper.deleteTaskReminder((String)reminderName, (Date)this.mOld.mAllowanceLtdBy);
            }
            if (this.mAllowanceLtdBy != null && DateHelper.after((Date)this.mAllowanceLtdBy, (Date)actDate)) {
                this.createTaskReminder(reminderName, this.mAllowanceLtdBy);
            }
        }
    }

    public void createTaskReminder(String reminderName, Date reminderDate) {
        TaskReminderHelper.createTaskReminder((String)reminderName, (Date)reminderDate, (String)"", (String)SessionContext.getInstance().getSession().getUserCode());
    }

    public void checkDateOfWithDrawal() throws BusinessDomainException {
        if (this.getDateOfWithDrawal() == null) {
            throw EmployeeExceptionMapper.makeDateOfWithDrawalMissingDomainException();
        }
    }

    public void checkCancellationOfWithDrawal(Employment old) throws BusinessDomainException {
        if (this.getEmployee().getSuccessor() != null) {
            throw EmployeeExceptionMapper.makeNoCancellationOfWithdrawalSuccessorExistDomainException();
        }
        this.setDateOfWithDrawal(null);
        this.setDateOfWithDrawalSI(null);
        this.setWithDrawalReason(null);
        if (old.getDateOfWithDrawal() == null) {
            throw EmployeeExceptionMapper.makeCancellationOfWithDrawalNotPossibleDomainException();
        }
    }

    public void checkReEntry(Employment old) throws BusinessDomainException {
        this.requireLoaded();
        if (old == null) {
            return;
        }
        old.requireLoaded();
        this.setDateOfWithDrawal(null);
        this.setDateOfWithDrawalSI(null);
        this.setDateDsmRgn(null);
        this.setDsmRgnBy(null);
        this.setDsmRgnReason(null);
        this.setWithDrawalReason(null);
        this.setInsolvencyDsmRgnReason(InsolvencyDsmRgnReasonEnum.IDRRE_A0);
        this.setDsmRgnOnPartOf(DsmRgnOnPartOfEnum.DROTPOE_ohne_Angabe);
        this.setAmountCompensation(null);
        if (old.mDateOfWithDrawal == null) {
            throw EmployeeExceptionMapper.makeEmployeeNotWithdrawDomainException();
        }
        if (this.mEmployee.isPredecessor()) {
            throw EmployeeExceptionMapper.makeReentryNotPossibleDomainException();
        }
        if (DateHelper.equal((Date)this.mDateOfEntry, (Date)new VDate(old.mDateOfWithDrawal).addDays(1).getDate())) {
            throw EmployeeExceptionMapper.makeNoReEntryDomainException();
        }
        if (DateHelper.equal((Date)old.mValidFrom, (Date)this.mValidFrom)) {
            throw EmployeeExceptionMapper.makeNewTimePeriodIsNecessaryDomainException();
        }
        if (DateHelper.before((Date)this.mValidFrom, (Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfEntry))) {
            throw EmployeeExceptionMapper.makeNewTimePeriodIsNecessaryDomainException();
        }
        if (DateHelper.after((Date)this.mValidFrom, (Date)DateHelper.getLastDayOfMonth((Date)this.mDateOfEntry))) {
            throw EmployeeExceptionMapper.makeMonthOfValidfromAndDateofentryDontCorrespondingDomainException();
        }
        if (DateHelper.beforeOrEqual((Date)this.mDateOfEntry, (Date)old.mDateOfEntry)) {
            throw EmployeeExceptionMapper.makeDateOfReEntryBeforeOldDateOfEntryDomainException();
        }
        if (DateHelper.beforeOrEqual((Date)this.mDateOfEntry, (Date)old.mDateOfWithDrawal)) {
            throw EmployeeExceptionMapper.makeDateOfReEntryBeforeOldDateOfWithdrawalDomainException();
        }
        if (new VDate(this.mDateOfEntry).getYear() == new VDate(old.mDateOfWithDrawal).getYear() && new VDate(this.mDateOfEntry).getMonth() == new VDate(old.mDateOfWithDrawal).getMonth()) {
            throw EmployeeExceptionMapper.makeMonthOfReEntryNotGreaterMonthOfWithdrawalDomainException();
        }
        if (this.mDateOfWithDrawal != null && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)this.mDateOfEntry)) {
            throw EmployeeExceptionMapper.makeDateOfWithDrawalBeforeDateOfEntryDomainException();
        }
    }

    public void checkDates() throws BusinessDomainException {
        this.requireLoaded();
        super.checkDates();
        boolean firstOfHistorie = this.mEmployee.getEmploymentHistory() == null;
        Date[] dates = this.mEmployee.checkDates(firstOfHistorie, this.getValidFrom());
        this.setEffectiveFrom(dates[0]);
        this.setValidFrom(dates[1]);
    }

    private void checkDateOfEntry() throws BusinessDomainException {
        if (this.getDateOfEntry() == null) {
            throw EmployeeExceptionMapper.makeDateOfEntryMissingDomainException();
        }
    }

    protected void checkDatesOfWithDrawalAndDatesOfDsmRgn() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mDateOfEntry != null) {
            if (this.mDateOfWithDrawal != null && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)this.mDateOfEntry)) {
                throw EmployeeExceptionMapper.makeDateOfWithDrawalBeforeDateOfEntryDomainException();
            }
            if (this.mDateOfWithDrawalSI != null && DateHelper.before((Date)this.mDateOfWithDrawalSI, (Date)this.mDateOfEntry)) {
                throw EmployeeExceptionMapper.makeDateOfWithDrawalSIBeforeDateOfEntryDomainException();
            }
            if (this.mDateOfWithDrawal != null) {
                Date oldWithdrawal;
                if (DateHelper.before((Date)this.mDateOfWithDrawal, (Date)this.mValidFrom)) {
                    throw EmployeeExceptionMapper.makeDateOfWithDrawalBeforeValidFromDomainException();
                }
                if (this.mOld != null && (oldWithdrawal = this.mOld.getDateOfWithDrawal()) != null && DateHelper.before((Date)this.mDateOfEntry, (Date)oldWithdrawal) && DateHelper.after((Date)this.mValidFrom, (Date)oldWithdrawal)) {
                    throw EmployeeExceptionMapper.makeCorrectionOfWithDrawalIsFalseDomainException();
                }
            }
        }
    }

    public void specialCheckDateOfWithdrawal() throws BusinessDomainException {
        block14: {
            if (this.mDateOfWithDrawal != null) {
                String reminderName;
                block13: {
                    block12: {
                        IEECalculationHistoric ch = (IEECalculationHistoric)UtilitiesManager.getBean((String)"eeCalculationHistoric", IEECalculationHistoric.class);
                        Date calculationStart = ch.getCalculationHistoric(this.getPCompany().getActiveCompanyFoundation().getCalculationStart());
                        if (this.mOld == null && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)calculationStart) || this.mOld != null && !DateHelper.equal((Date)this.mDateOfWithDrawal, (Date)this.mOld.getDateOfWithDrawal()) && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)calculationStart)) {
                            throw EmployeeExceptionMapper.makeWithdrawalBeforeCalculationStartDomainException();
                        }
                        if (DateHelper.before((Date)DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), (Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfEntry))) {
                            throw EmployeeExceptionMapper.makeValidFromBeforeEntryNotAllowedDomainException((String)DateMapper.toString((Date)this.mDateOfEntry));
                        }
                        try {
                            Insurance insurance = this.mEmployee.getInsurance(this.mEffectiveFrom, this.mValidFrom);
                            if (insurance.getHealthFundKVdR() != null && insurance.getBeginKVDR() != null && (insurance.getEndKVDR() == null || DateHelper.equal((Date)insurance.getEndKVDR(), (Date)this.mDateOfWithDrawal))) {
                                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Mit Mitarbeiteraustritt auch Enddatum Versorgungsbezug pr\u00fcfen ");
                                this.createTaskReminder(reminderName, this.mDateOfWithDrawal);
                            }
                        }
                        catch (BusinessDomainException e) {
                            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block12;
                            throw e;
                        }
                    }
                    try {
                        EEZVK eezvk = this.mEmployee.getEEZVK(this.mEffectiveFrom, this.mValidFrom);
                        if (eezvk.getDateOfWithdrawl() == null) {
                            reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Mit Mitarbeiteraustritt auch ZVK-Austritt pr\u00fcfen ");
                            this.createTaskReminder(reminderName, this.mDateOfWithDrawal);
                        }
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block13;
                        throw e;
                    }
                }
                try {
                    EEVBLU eevblu = this.mEmployee.getEEVBLU(this.mEffectiveFrom, this.mValidFrom);
                    if (eevblu.getDateOfWithdrawal() == null) {
                        reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.mEmployee, (String)"Mit Mitarbeiteraustritt auch VBLU-Austritt pr\u00fcfen ");
                        this.createTaskReminder(reminderName, this.mDateOfWithDrawal);
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block14;
                    throw e;
                }
            }
        }
    }

    public void specialCheckDateOfWithdrawalAndSuccessor(Employment employmentOld) throws BusinessDomainException {
        if (DateHelper.equal((Date)employmentOld.getDateOfEntry(), (Date)this.mDateOfEntry) && employmentOld.getDateOfWithDrawal() != null && (this.mDateOfWithDrawal == null || this.mDateOfWithDrawal != null && !DateHelper.equal((Date)employmentOld.getDateOfWithDrawal(), (Date)this.mDateOfWithDrawal)) && this.mEmployee.getSuccessor() != null) {
            throw EmployeeExceptionMapper.makeNoCancellationOfWithdrawalSuccessorExistDomainException();
        }
    }

    protected void checkAssignments() throws BusinessDomainException {
        Date dateOfWithdrawal = this.mEmployee.getLastDateOfWithdrawal();
        if (dateOfWithdrawal != null && DateHelper.beforeOrEqual((Date)dateOfWithdrawal, (Date)this.mEmployee.getJournalizedUntil())) {
            return;
        }
        this.requireLoaded();
        CompanySettings companySettings = null;
        companySettings = this.getPCompany().getCompanySettings(this.mEffectiveFrom, this.mValidFrom);
        if (companySettings != null) {
            if (companySettings.getUsePlants()) {
                if (this.mPlant == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung einer Betriebsst\u00e4tte");
                }
            } else if (this.mPlant != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung einer Betriebsst\u00e4tte");
            }
            if (companySettings.getUseEmployeeCircle()) {
                if (this.mEmployeeCircle == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung eines Mitarbeiterkreises");
                }
            } else if (this.mEmployeeCircle != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung eines Mitarbeiterkreises");
            }
            if (companySettings.getUseEmployeeGroup()) {
                if (this.mEmployeeGroup == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung einer Mitarbeitergruppe");
                }
            } else if (this.mEmployeeGroup != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung einer Mitarbeitergruppe");
            }
            if (companySettings.getUseEmployeeFunction()) {
                if (this.mEmployeeFunction == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung einer Mitarbeiterfunktion");
                }
            } else if (this.mEmployeeFunction != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung einer Mitarbeiterfunktion");
            }
            if (companySettings.getUseCostCenter()) {
                if (this.mCostCenter == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung einer Kostenstelle");
                }
            } else if (this.mCostCenter != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung einer Kostenstelle");
            }
            if (companySettings.getUseCostUnit()) {
                if (this.mCostUnit == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung eines Kostentr\u00e4gers");
                }
            } else if (this.mCostUnit != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung eines Kostentr\u00e4gers");
            }
            if (companySettings.getUseDepartment()) {
                if (this.mDepartment == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung einer Abteilung");
                }
            } else if (this.mDepartment != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung einer Abteilung");
            }
            if (companySettings.getUseOrgUnit()) {
                if (this.mOrgUnit == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung einer Org. Einheit");
                }
            } else if (this.mOrgUnit != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung einer Org. Einheit");
            }
            if (companySettings.getUseLocation()) {
                if (this.mLocation == null) {
                    throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung eines Standortes");
                }
            } else if (this.mLocation != null) {
                throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung eines Standortes");
            }
            this.checkPersonInCharge(companySettings);
        }
    }

    protected void checkPersonInCharge(CompanySettings companySettings) throws BusinessDomainException {
        if (companySettings.getUsePersonInCharge1()) {
            if (this.mPersonInCharge1 == null && !this.mAutomaticPersonInCharge1) {
                throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung eines Bearbeiters 1");
            }
        } else if (this.mPersonInCharge1 != null || this.mAutomaticPersonInCharge1) {
            throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung eines Bearbeiters 1");
        }
        if (companySettings.getUsePersonInCharge2()) {
            if (this.mPersonInCharge2 == null && !this.mAutomaticPersonInCharge2) {
                throw EmployeeExceptionMapper.makeAssignmentMissingDomainException((String)"Die Zuordnung eines Bearbeiters 2");
            }
        } else if (this.mPersonInCharge2 != null || this.mAutomaticPersonInCharge2) {
            throw EmployeeExceptionMapper.makeAssignmentNotPermittedDomainException((String)"Die Zuordnung eines Bearbeiters 2");
        }
    }

    public void checkNewPartCostCenters() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mNewPartCostCenters != null && this.mNewPartCostCenters.length > 0) {
            int i;
            BigDecimal sumPercentage = BigDecimal.valueOf(0L, 2);
            for (i = 0; i < this.mNewPartCostCenters.length; ++i) {
                if (this.mNewPartCostCenters[i].getCostCenter() != null) continue;
                throw EmployeeExceptionMapper.makeCostCenterMissingDomainException((String)String.valueOf(i + 1));
            }
            for (i = 0; i < this.mNewPartCostCenters.length; ++i) {
                sumPercentage = sumPercentage.add(this.mNewPartCostCenters[i].getPercentage());
                for (int j = i + 1; j < this.mNewPartCostCenters.length; ++j) {
                    if (!StringMapper.equal((String)this.mNewPartCostCenters[i].getCostCenter().getCostCenter(), (String)this.mNewPartCostCenters[j].getCostCenter().getCostCenter())) continue;
                    throw EmployeeExceptionMapper.makePartCostCentersDontDifferentDomainException((String)this.mNewPartCostCenters[i].getCostCenter().getCostCenter());
                }
            }
            if (sumPercentage.compareTo(BigDecimal.valueOf(10000L, 2)) == 1) {
                throw EmployeeExceptionMapper.makeCostCentersPercentagesFalseDomainException();
            }
        }
    }

    private void checkNewPartEmployeeGroups() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mNewPartEmployeeGroups != null && this.mNewPartEmployeeGroups.length > 0) {
            int i;
            BigDecimal sumPercentage = BigDecimal.valueOf(0L, 2);
            for (i = 0; i < this.mNewPartEmployeeGroups.length; ++i) {
                if (this.mNewPartEmployeeGroups[i].getEmployeeGroup() != null) continue;
                throw EmployeeExceptionMapper.makeEmployeeGroupMissingDomainException((String)String.valueOf(i + 1));
            }
            for (i = 0; i < this.mNewPartEmployeeGroups.length; ++i) {
                sumPercentage = sumPercentage.add(this.mNewPartEmployeeGroups[i].getPercentage());
                for (int j = i + 1; j < this.mNewPartEmployeeGroups.length; ++j) {
                    if (!StringMapper.equal((String)this.mNewPartEmployeeGroups[i].getEmployeeGroup().getDesignation(), (String)this.mNewPartEmployeeGroups[j].getEmployeeGroup().getDesignation())) continue;
                    throw EmployeeExceptionMapper.makePartEmployeeGroupsDontDifferentDomainException((String)this.mNewPartEmployeeGroups[i].getEmployeeGroup().getDesignation());
                }
            }
            if (sumPercentage.compareTo(BigDecimal.valueOf(10000L, 2)) == 1) {
                throw EmployeeExceptionMapper.makeEmployeeGroupsPercentagesFalseDomainException();
            }
        }
    }

    public void checkNewPartCostUnits() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mNewPartCostUnits != null && this.mNewPartCostUnits.length > 0) {
            int i;
            BigDecimal sumPercentage = BigDecimal.valueOf(0L, 2);
            for (i = 0; i < this.mNewPartCostUnits.length; ++i) {
                if (this.mNewPartCostUnits[i].getCostUnit() != null) continue;
                throw EmployeeExceptionMapper.makeCostUnitMissingDomainException((String)String.valueOf(i + 1));
            }
            for (i = 0; i < this.mNewPartCostUnits.length; ++i) {
                sumPercentage = sumPercentage.add(this.mNewPartCostUnits[i].getPercentage());
                for (int j = i + 1; j < this.mNewPartCostUnits.length; ++j) {
                    if (!StringMapper.equal((String)this.mNewPartCostUnits[i].getCostUnit().getCostUnit(), (String)this.mNewPartCostUnits[j].getCostUnit().getCostUnit())) continue;
                    throw EmployeeExceptionMapper.makePartCostUnitsDontDifferentDomainException((String)this.mNewPartCostUnits[i].getCostUnit().getCostUnit());
                }
            }
            if (sumPercentage.compareTo(BigDecimal.valueOf(10000L, 2)) == 1) {
                throw EmployeeExceptionMapper.makeCostUnitsPercentagesFalseDomainException();
            }
        }
    }

    public boolean isWithdrawal(Employment old) {
        this.requireLoaded();
        if (old == null) {
            return this.mDateOfWithDrawal != null;
        }
        old.requireLoaded();
        return DateHelper.compareDateWithNull((Date)old.mDateOfWithDrawal, (Date)this.mDateOfWithDrawal) != 0;
    }

    public void compareToOld(Employment old) throws BusinessDomainException {
        if (old == null) {
            return;
        }
        this.requireLoaded();
        old.requireLoaded();
        this.mOld = old;
        if (!PersonnelPersistenceObject.isEqual((IPersistentObject)old.mPlant, (IPersistentObject)this.mPlant)) {
            this.mValuateNeeded = true;
            return;
        }
        if (!PersonnelPersistenceObject.isEqual((IPersistentObject)old.mPlantPlace, (IPersistentObject)this.mPlantPlace)) {
            this.mValuateNeeded = true;
            return;
        }
        if (DateHelper.compareDateWithNull((Date)old.mAllowableEntryDate, (Date)this.mAllowableEntryDate) != 0) {
            this.mValuateNeeded = true;
            return;
        }
        if (DateHelper.compareDateWithNull((Date)old.mDateOfEntrySI, (Date)this.mDateOfEntrySI) != 0) {
            this.mValuateNeeded = true;
            return;
        }
        if (DateHelper.compareDateWithNull((Date)old.mDateOfWithDrawal, (Date)this.mDateOfWithDrawal) != 0) {
            this.mValuateNeeded = true;
            return;
        }
        if (DateHelper.compareDateWithNull((Date)old.mDateOfWithDrawalSI, (Date)this.mDateOfWithDrawalSI) != 0) {
            this.mValuateNeeded = true;
            return;
        }
        if (old.mTypeOfTimeOff != this.mTypeOfTimeOff) {
            this.mValuateNeeded = true;
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.mCarriedForwardMonthlyNetZU, (BigDecimal)this.mCarriedForwardMonthlyNetZU)) {
            this.mValuateNeeded = true;
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.mCarriedForwardDailyNetZU, (BigDecimal)this.mCarriedForwardDailyNetZU)) {
            this.mValuateNeeded = true;
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.mAverageMonthlyGrossPay, (BigDecimal)this.mAverageMonthlyGrossPay)) {
            this.mValuateNeeded = true;
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.mAverageMonthlyNetPay, (BigDecimal)this.mAverageMonthlyNetPay)) {
            this.mValuateNeeded = true;
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.mCalendarDailyNetPay, (BigDecimal)this.mCalendarDailyNetPay)) {
            this.mValuateNeeded = true;
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.mMaternityBenefit, (BigDecimal)this.mMaternityBenefit)) {
            this.mValuateNeeded = true;
            return;
        }
        if (old.mTypeOfEarnedIncome != this.mTypeOfEarnedIncome) {
            this.mValuateNeeded = true;
            return;
        }
        if (old.mWithDrawalDeath != this.mWithDrawalDeath) {
            this.mValuateNeeded = true;
            return;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Class<?> c = ((Object)((Object)this)).getClass();
        b.append(c.getName().substring(c.getPackage().getName().length() + 1));
        b.append('{').append(DateMapper.toString((Date)this.mEffectiveFrom));
        b.append(',').append(DateMapper.toString((Date)this.mValidFrom));
        b.append(',').append(DateMapper.toString((Date)this.mValidUntil));
        if (this.isReadOnly()) {
            b.append(',').append("readonly");
        } else if (this.isNew()) {
            b.append(',').append("insert");
        } else {
            b.append(',').append("update");
        }
        b.append('}');
        return b.toString();
    }

    protected void specialCheckDates() throws BusinessDomainException {
        Date validFrom = DateHelper.getFirstDayOfMonth((Date)this.mValidFrom);
        if (DateHelper.before((Date)validFrom, (Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfEntry))) {
            throw EmployeeExceptionMapper.makeValidFromBeforeEntryNotAllowedDomainException((String)DateMapper.toString((Date)this.mDateOfEntry));
        }
        Employment employment = null;
        try {
            employment = this.mEmployee.getEmployment(this.mEffectiveFrom, this.mValidFrom);
        }
        catch (Exception e) {
            return;
        }
        if (employment == null) {
            return;
        }
        if (employment.getDateOfWithDrawal() == null) {
            if (this.mDateOfWithDrawal != null && DateHelper.beforeOrEqual((Date)this.mDateOfWithDrawal, (Date)this.mEmployee.getJournalizedUntil()) && DateHelper.before((Date)this.mValidFrom, (Date)this.mDateOfWithDrawal)) {
                throw FrameWorkExceptionMapper.makeChangeAfterJournalizeNotAllowedDomainException((String)"Austrittsdatum");
            }
            return;
        }
        if (this.mOld == null) {
            return;
        }
        if (!DateHelper.equal((Date)employment.getDateOfWithDrawal(), (Date)this.mDateOfWithDrawal)) {
            throw EmployeeExceptionMapper.makeOldAndNewWithdrawalNotEqualDomainException();
        }
        if (DateHelper.before((Date)this.mDateOfWithDrawal, (Date)this.mEmployee.getJournalizedUntil()) && DateHelper.before((Date)validFrom, (Date)DateHelper.getFirstDayOfMonth((Date)this.mDateOfWithDrawal))) {
            throw FrameWorkExceptionMapper.makeChangeAfterJournalizeNotAllowedDomainException((String)"Austrittsdatum");
        }
    }

    public void setSpecialChecks(boolean specialChecks) {
        this.mSpecialChecks = specialChecks;
    }

    public String getRootDomainKey() {
        return this.getEmployee().getDomainKey();
    }

    public String getNaturalLanguageClassName() {
        return "Mitarbeiter - Besch\u00e4ftigung";
    }

    public void checkVWECostCenters() throws BusinessDomainException {
        this.requireLoaded();
        this.mEmployee.checkVWECostCenter(this.mCostCenter, this.mEffectiveFrom, this.mValidFrom);
        if (this.mNewPartCostCenters == null) {
            return;
        }
        for (PartCostCenter pcc : this.mNewPartCostCenters) {
            this.mEmployee.checkVWECostCenter(pcc.getCostCenter(), this.mEffectiveFrom, this.mValidFrom);
        }
    }

    protected PCompany getPCompany() {
        return this.mEmployee.getPCompany();
    }

    public String getPCompanyKeyOfMigration() {
        this.requireLoaded();
        return this.mPCompanyKeyOfMigration;
    }

    public void setPCompanyKeyOfMigration(String pCompanyKeyOfMigration) {
        this.mPCompanyKeyOfMigration = pCompanyKeyOfMigration;
    }

    public String getPersonnelnumberOfMigration() {
        this.requireLoaded();
        return this.mPersonnelnumberOfMigration;
    }

    public void setPersonnelnumberOfMigration(String personnelnumberOfMigration) {
        this.mPersonnelnumberOfMigration = personnelnumberOfMigration;
    }

    public TypeOfEmploymentEnum getTypeOfEmployment() {
        this.requireLoaded();
        return this.mTypeOfEmployment;
    }

    public void setTypeOfEmployment(TypeOfEmploymentEnum typeOfEmployment) {
        this.mTypeOfEmployment = typeOfEmployment;
    }

    public String getDiffWorkplacePostalcode() {
        this.requireLoaded();
        return this.mDiffWorkplacePostalcode;
    }

    public void setDiffWorkplacePostalcode(String postalcode) {
        this.mDiffWorkplacePostalcode = postalcode;
    }

    public String getDiffWorkplaceDomicile() {
        this.requireLoaded();
        return this.mDiffWorkplaceDomicile;
    }

    public void setDiffWorkplaceDomicile(String domicile) {
        this.mDiffWorkplaceDomicile = domicile;
    }

    public State getDiffWorkplaceState() {
        this.requireLoaded();
        return this.mDiffWorkplaceState;
    }

    public void setDiffWorkplaceState(State state) {
        this.mDiffWorkplaceState = state;
    }

    public boolean isDiffWorkplace() {
        return !StringMapper.isNullString((String)this.getDiffWorkplaceDomicile());
    }

    public BigDecimal getEarnedIncome() {
        this.requireLoaded();
        return this.mEarnedIncome;
    }

    public void setEarnedIncome(BigDecimal earnedIncome) {
        this.mEarnedIncome = earnedIncome;
    }

    public TypeOfEarnedIncomEnum getTypeOfEarnedIncome() {
        this.requireLoaded();
        return this.mTypeOfEarnedIncome;
    }

    public void setTypeOfEarnedIncome(TypeOfEarnedIncomEnum typeOfEarnedIncome) {
        this.mTypeOfEarnedIncome = typeOfEarnedIncome;
    }

    public BigDecimal getNetIncome() {
        this.requireLoaded();
        return this.mNetIncome;
    }

    public void setNetIncome(BigDecimal netIncome) {
        this.mNetIncome = netIncome;
    }

    public String getReasonForTransferU1() {
        this.requireLoaded();
        return this.mReasonForTransferU1;
    }

    public void setReasonForTransferU1(String reasonForTransferU1) {
        this.mReasonForTransferU1 = reasonForTransferU1;
    }

    public String getReasonForTransferU2BT() {
        this.requireLoaded();
        return this.mReasonForTransferU2BT;
    }

    public void setReasonForTransferU2BT(String reasonForTransferU2BT) {
        this.mReasonForTransferU2BT = reasonForTransferU2BT;
    }

    public String getReasonForTransferU2ZU() {
        this.requireLoaded();
        return this.mReasonForTransferU2ZU;
    }

    public void setReasonForTransferU2ZU(String reasonForTransferU2ZU) {
        this.mReasonForTransferU2ZU = reasonForTransferU2ZU;
    }

    public boolean getAutomaticPersonInCharge1() {
        this.requireLoaded();
        return this.mAutomaticPersonInCharge1;
    }

    public void setmAutomaticPersonInCharge1(boolean automaticPersonInCharge1) {
        this.mAutomaticPersonInCharge1 = automaticPersonInCharge1;
    }

    public boolean getAutomaticPersonInCharge2() {
        this.requireLoaded();
        return this.mAutomaticPersonInCharge2;
    }

    public void setmAutomaticPersonInCharge2(boolean automaticPersonInCharge2) {
        this.mAutomaticPersonInCharge2 = automaticPersonInCharge2;
    }

    public boolean getEarnedIncomeRelevantForCalculation() {
        this.requireLoaded();
        return this.mEarnedIncomeRelevantForCalculation;
    }

    public void setEarnedIncomeRelevantForCalculation(boolean earnedIncomeRelevantForCalculation) {
        this.mEarnedIncomeRelevantForCalculation = earnedIncomeRelevantForCalculation;
    }

    public TypeOfTimeOffEnum getTypeOfTimeOff() {
        this.requireLoaded();
        return this.mTypeOfTimeOff;
    }

    public void setTypeOfTimeOff(TypeOfTimeOffEnum typeOfTimeOff) {
        this.mTypeOfTimeOff = typeOfTimeOff;
    }

    public BigDecimal getCarriedForwardMonthlyNetZU() {
        this.requireLoaded();
        return this.mCarriedForwardMonthlyNetZU;
    }

    public void setCarriedForwardMonthlyNetZU(BigDecimal carriedForwardMonthlyNetZU) {
        this.mCarriedForwardMonthlyNetZU = carriedForwardMonthlyNetZU;
    }

    public BigDecimal getCarriedForwardDailyNetZU() {
        this.requireLoaded();
        return this.mCarriedForwardDailyNetZU;
    }

    public void setCarriedForwardDailyNetZU(BigDecimal carriedForwardDailyNetZU) {
        this.mCarriedForwardDailyNetZU = carriedForwardDailyNetZU;
    }

    public boolean getAssignment() {
        this.requireLoaded();
        return this.mAssignment;
    }

    public void setAssignment(boolean assignment) {
        this.mAssignment = assignment;
    }

    public BigDecimal getMaternityBenefit() {
        this.requireLoaded();
        return this.mMaternityBenefit;
    }

    public void setMaternityBenefit(BigDecimal maternityBenefit) {
        this.mMaternityBenefit = maternityBenefit;
    }

    public BigDecimal getAverageMonthlyGrossPay() {
        this.requireLoaded();
        return this.mAverageMonthlyGrossPay;
    }

    public void setAverageMonthlyGrossPay(BigDecimal averageMonthlyGrossPay) {
        this.mAverageMonthlyGrossPay = averageMonthlyGrossPay;
    }

    public BigDecimal getAverageMonthlyNetPay() {
        this.requireLoaded();
        return this.mAverageMonthlyNetPay;
    }

    public void setAverageMonthlyNetPay(BigDecimal averageMonthlyNetPay) {
        this.mAverageMonthlyNetPay = averageMonthlyNetPay;
    }

    public BigDecimal getCalendarDailyNetPay() {
        this.requireLoaded();
        return this.mCalendarDailyNetPay;
    }

    public void setCalendarDailyNetPay(BigDecimal calendarDailyNetPay) {
        this.mCalendarDailyNetPay = calendarDailyNetPay;
    }

    public Date getPresumableDateOfDelivery() {
        this.requireLoaded();
        return this.mPresumableDateOfDelivery;
    }

    public void setPresumableDateOfDelivery(Date presumableDateOfDelivery) {
        this.mPresumableDateOfDelivery = presumableDateOfDelivery;
    }

    public Date getAllowanceLtdBy() {
        this.requireLoaded();
        return this.mAllowanceLtdBy;
    }

    public void setAllowanceLtdBy(Date allowanceLtdBy) {
        this.mAllowanceLtdBy = allowanceLtdBy;
    }

    public PlantPlace getPlantPlace() {
        this.requireLoaded();
        return this.mPlantPlace;
    }

    public void setPlantPlace(PlantPlace plantPlace) {
        this.mPlantPlace = plantPlace;
    }

    public InsolvencyEntryReasonEnum getInsolvencyEntryReason() {
        this.requireLoaded();
        return this.mInsolvencyEntryReason;
    }

    public void setInsolvencyEntryReason(InsolvencyEntryReasonEnum insolvencyEntryReason) {
        this.mInsolvencyEntryReason = insolvencyEntryReason;
    }

    public InsolvencyDsmRgnReasonEnum getInsolvencyDsmRgnReason() {
        this.requireLoaded();
        return this.mInsolvencyDsmRgnReason;
    }

    public void setInsolvencyDsmRgnReason(InsolvencyDsmRgnReasonEnum insolvencyDsmRgnReason) {
        this.mInsolvencyDsmRgnReason = insolvencyDsmRgnReason;
    }

    public boolean getNoExportAsciiInfoSystem() {
        this.requireLoaded();
        return this.mNoExportAsciiInfoSystem;
    }

    public void setNoExportAsciiInfoSystem(boolean noExportAsciiInfoSystem) {
        this.mNoExportAsciiInfoSystem = noExportAsciiInfoSystem;
    }

    public boolean getWithDrawalDeath() {
        this.requireLoaded();
        return this.mWithDrawalDeath;
    }

    public void setWithDrawalDeath(boolean withDrawalDeath) {
        this.mWithDrawalDeath = withDrawalDeath;
    }

    public int getAuCertificateFrom() {
        this.requireLoaded();
        return this.mAuCertificateFrom;
    }

    public void setAuCertificateFrom(int auCertificateFrom) {
        this.mAuCertificateFrom = auCertificateFrom;
    }

    public boolean getLimitedByPurpose() {
        this.requireLoaded();
        return this.mLimitedByPurpose;
    }

    public void setLimitedByPurpose(boolean limitedByPurpose) {
        this.mLimitedByPurpose = limitedByPurpose;
    }

    public void setCheckInsolvency(boolean checkInsolvency) {
        this.mCheckInsolvency = checkInsolvency;
    }

    public int getEmploymentYears(Date timePoint) {
        this.requireLoaded();
        VDate vDate1 = new VDate(timePoint);
        if (this.mDateOfWithDrawal != null && DateHelper.before((Date)this.mDateOfWithDrawal, (Date)timePoint)) {
            vDate1 = new VDate(this.mDateOfWithDrawal);
        }
        VDate vDate2 = this.mAllowableEntryDate != null ? new VDate(this.mAllowableEntryDate) : new VDate(this.mDateOfEntry);
        int years = 0;
        if (vDate1.getMonth() < vDate2.getMonth()) {
            years = vDate1.getYear() - vDate2.getYear() - 1;
        }
        if (vDate1.getMonth() == vDate2.getMonth()) {
            years = vDate1.getDay() < vDate2.getDay() ? vDate1.getYear() - vDate2.getYear() - 1 : vDate1.getYear() - vDate2.getYear();
        }
        if (vDate1.getMonth() > vDate2.getMonth()) {
            years = vDate1.getYear() - vDate2.getYear();
        }
        return years;
    }

    private IEmploymentPersistencyManager getEmploymentPM() {
        return (IEmploymentPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("employmentPersistencyManager", IEmploymentPersistencyManager.class);
    }

    public void specialCheckPersonInCharge() throws BusinessDomainException {
    }

    public void checkPlantPlace() throws BusinessDomainException {
        if (this.getPlantPlace() != null) {
            this.checkTimePeriods((PersonnelPersistenceObject)this.mPlantPlace);
            if (this.mPlant == null) {
                throw EmployeeExceptionMapper.makePlantPlaceIsNotAssignedDomainException();
            }
            if (!StringMapper.equal((String)this.mPlant.getObjectid(), (String)this.mPlantPlace.getPlant().getObjectid())) {
                throw EmployeeExceptionMapper.makePlantPlaceIsNotAssignedDomainException();
            }
        }
    }

    public void specialcheckPlantPlace(Date validFrom) throws BusinessDomainException {
    }

    private void checkCompDependentAssignments() throws BusinessDomainException {
        if (this.mPlant != null && !this.mPlant.getHeadCompany().equals((Object)this.mEmployee.getPCompany())) {
            throw EmployeeExceptionMapper.makePlantIsNotAssignedDomainException();
        }
        if (this.mCostCenter != null && !this.mCostCenter.getPCompany().equals((Object)this.mEmployee.getPCompany())) {
            throw EmployeeExceptionMapper.makeCostCenterIsNotAssignedDomainException();
        }
        if (this.mCostUnit != null && !this.mCostUnit.getPCompany().equals((Object)this.mEmployee.getPCompany())) {
            throw EmployeeExceptionMapper.makeCostUnitIsNotAssignedDomainException();
        }
    }
}

