/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau.eaudxkk;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eaudxkk.EauDxkk;
import com.varial.personnel.domain.eau.eaudxkk.IEauDxkkPersistencyManager;
import com.varial.personnel.persistency.eau.eaudxkk.EaudxkkContainer;
import com.varial.personnel.persistency.eau.eaudxkk.IEaudxkkDao;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;

public class EauDxkkPersistencyManager
implements IEauDxkkPersistencyManager {
    private static IEaudxkkDao dao = (IEaudxkkDao)UtilitiesManager.getApplicationContext().getBean("eaudxkkDao");

    public EauDxkk getEauDxkk(String objectID) {
        return new EauDxkk(objectID);
    }

    public EauDxkk[] query(Order[] sort, Criterion filters, boolean readOnly) {
        try {
            EaudxkkContainer[] containers = dao.getRows(sort, filters);
            int count = containers.length;
            EauDxkk[] result = new EauDxkk[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new EauDxkk(readOnly);
                this.fillEauDxkk(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void fillEauDxkk(EauDxkk bo, EaudxkkContainer container) {
        EauAccount eauAccount = null;
        if (!StringMapper.isNullString((String)container.oideauaccount)) {
            eauAccount = EauAccount.getEauAccount(container.oideauaccount);
        }
        bo.setEauAccount(eauAccount);
        if (container.versionsnr < 99) {
            bo.setEauVersion(10001);
        } else {
            bo.setEauVersion(container.versionsnr);
        }
        bo.setBbnrabsender(container.bbnrabsender);
        bo.setBbnrempfaenger(container.bbnrempfaenger);
        bo.setDatumerstellung(container.ed);
        bo.setProdid(container.prodid);
        bo.setModid(container.modid);
        bo.setDatensatzid(container.datensatzid);
        bo.setAzvu(container.azvu);
        bo.setKennzstorno(container.stornokennzeichen);
        bo.setDatensatzidursprung(container.datensatzidursprun);
        bo.setBbnrverursacher(container.bbnrverursacher);
        bo.setBbnrabrechnungsstelle(container.bbnrabrstelle);
        bo.setGeschlecht(container.geschlecht);
        bo.setVorname(container.vorname);
        bo.setFamilienname(container.familienname);
        bo.setVsnr(container.versicherungsnr);
        bo.setAuabag(container.auabag);
        bo.setAuabkk(container.auabkk);
        bo.setAubisvoraussicht(container.aubisvoraussicht);
        bo.setFestgestelltam(container.festgestelltam);
        bo.setKzaktuelleau(container.kzaktuelleau);
        bo.setArbeitsunfall(container.arbeitsunfall);
        bo.setDarztzugewiesen(container.darztzugewiesen);
        bo.setSonstigerunfall(container.sonstigerunfall);
        bo.setStationab(container.stationab);
        bo.setStationbis(container.stationbis);
        bo.setErstbescheinigung(container.erstbescheinigung);
        bo.setFolgebescheinigung(container.folgebescheinigung);
        bo.setMessage(container.reserve1);
        bo.setMmDbap(container.mmdbap);
        bo.setObjectid(container.getObjectid());
        bo.setVersion(container.getVersion());
        bo.setLastuser(container.getLastUserid());
        bo.setTimestamp(container.getObjectTS());
    }

    public void load(EauDxkk eauDxkk) {
        EaudxkkContainer container = null;
        try {
            container = dao.getRowByObjectID(eauDxkk.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)eauDxkk.getObjectid());
        }
        this.fillEauDxkk(eauDxkk, container);
    }

    public void save(EauDxkk eauDxkk) {
        EaudxkkContainer container = dao.getInitializedInstance();
        this.fillContainer(container, eauDxkk);
        try {
            container = eauDxkk.isNew() ? dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        eauDxkk.setObjectid(container.getObjectid());
        eauDxkk.setVersion(container.getVersion());
        eauDxkk.setLastuser(container.getLastUserid());
        eauDxkk.setTimestamp(container.getObjectTS());
    }

    private void fillContainer(EaudxkkContainer container, EauDxkk bo) {
        container.oideauaccount = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getEauAccount());
        container.kennung = bo.getKennung();
        container.versionsnr = bo.getEauVersion();
        if (container.versionsnr > 99) {
            container.versionsnr = 10;
        }
        container.bbnrabsender = bo.getBbnrabsender();
        container.bbnrempfaenger = bo.getBbnrempfaenger();
        container.ed = bo.getDatumerstellung();
        container.prodid = bo.getProdid();
        container.modid = bo.getModid();
        container.datensatzid = bo.getDatensatzid();
        container.azvu = bo.getAzvu();
        container.stornokennzeichen = bo.getKennzstorno();
        container.datensatzidursprun = bo.getDatensatzidursprung();
        container.bbnrverursacher = bo.getBbnrverursacher();
        container.bbnrabrstelle = bo.getBbnrabrechnungsstelle();
        container.geschlecht = bo.getGeschlecht();
        container.vorname = bo.getVorname();
        container.familienname = bo.getFamilienname();
        container.versicherungsnr = bo.getVsnr();
        container.auabag = bo.getAuabag();
        container.auabkk = bo.getAuabkk();
        container.aubisvoraussicht = bo.getAubisvoraussicht();
        container.festgestelltam = bo.getFestgestelltam();
        container.kzaktuelleau = bo.getKzaktuelleau();
        container.arbeitsunfall = bo.getArbeitsunfall();
        container.darztzugewiesen = bo.getDarztzugewiesen();
        container.sonstigerunfall = bo.getSonstigerunfall();
        container.stationab = bo.getStationab();
        container.stationbis = bo.getStationbis();
        container.erstbescheinigung = bo.getErstbescheinigung();
        container.folgebescheinigung = bo.getFolgebescheinigung();
        container.reserve1 = bo.getMessage();
        container.mmdbap = bo.hasMmDbap();
        container.setObjectid(bo.getObjectid());
        container.setObjectTS(bo.getTimestamp());
        container.setLastUserid(bo.getLastuser());
        container.setVersion(bo.getVersion());
    }

    public void delete(EauDxkk eauDxkk) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), eauDxkk.getObjectid(), eauDxkk.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public boolean exists(Criterion criterion) {
        try {
            return dao.exists(criterion);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }
}

