/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.dskk;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbna;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.dskk.DskkEmployee;
import com.varial.personnel.domain.dskk.DskkReportComparator;
import com.varial.personnel.domain.dskk.dbam.DskkDbam;
import com.varial.personnel.domain.dskk.dbbg.DskkDbbg;
import com.varial.personnel.domain.dskk.dbmb.DskkDbmb;
import com.varial.personnel.domain.dskk.dbmm.DskkDbmm;
import com.varial.personnel.domain.dskk.dbna.DskkDbna;
import com.varial.personnel.domain.dskk.dskk.DeuvDskk;
import com.varial.personnel.domain.dskk.dskk.DeuvDskkPersistencyManager;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.deuvdskk.EEDeuvDskk;
import com.varial.personnel.domain.employee.deuvdskk.EEDeuvDskkTP;
import com.varial.personnel.domain.employee.deuvdskk.EEDeuvDskkTPPersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.io.File;
import java.io.FilenameFilter;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DskkReceive
extends BasicReceive<DeuvDskk> {
    private static final Date START_OF_DSKK_2015 = DateMapper.toDate((String)"2015-01-01");
    private static final String[] FILENAMEFILTER = new String[]{"ESAG0", "TSAG0"};
    private static final Pattern VOSZ_KV_AG = DskkReceive.getVoszPattern((String)"KVDEU");
    private static final Pattern DSKK_V03_V04 = Pattern.compile("DSKKDEUEV(?<ABSN>.{15})(?<EPNR>.{15})(?:03|04)(?<ED>\\d{20})00(?<VSNR>.{12}).{17}(?<AZKK>.{20})(?<BBNRAG>.{15})(?<AZAG>.{20})(?<BBNRAS>.{15}).{3}(?<GD>\\d{2}).{3}(?<MMMM>[JN])(?<MMMB>[JN])(?<MMAM>[JN])(?<MMMG>[JN])(?<MMNA>[JN])(?<MMKU>[JN]).{1}.{13}(?<DSID>.{32})(?<DSIDUR>.{32}).{32}(?<REST>.*)");
    private static final Pattern DBMM = Pattern.compile("DBMM(?<KENNZST>[JN]).{1}(?<ZRBG>\\d{8})(?<ZREN>\\d{8})(?<REST>.*)");
    private static final Pattern DBMB = Pattern.compile("DBMB(?<KENNZST>[JN])(?<MGST>[JN])(?<ZRBM>\\d{8}).{50}(?<REST>.*)");
    private static final Pattern DBAM = Pattern.compile("DBAM(?<AFKJ>\\d{4}).{47}(?<REST>.*)");
    private static final Pattern DBBG = Pattern.compile("DBBG(?<KENNZST>[JN])(?<GAEGKV>\\d{7})(?<GAEGRV>\\d{7})(?<GAEGALV>\\d{7})(?<EGAKV>\\d{7})(?<EGARV>\\d{7})(?<EGALV>\\d{7})(?<ZRBG>\\d{8})(?<ZREN>\\d{8})(?<KENNZRK>[ OW])(?<SVTG>\\d{2})(?<KENNZKVL>[JN])(?<KENNZRVL>[JNV])(?<KENNZALVL>[JNV])(?<KENNZKVE>[ JN])(?<KENNZRVE>[ JNV])(?<KENNZALVE>[ JNV]).{23}(?<REST>.*)");
    private static final Pattern DBKB = Pattern.compile("DBKB(?<KENNZKB>\\d).{15}(?<REST>.*)");
    private static final int DSKK_V03_LENGTH = 286;
    private static final int DBMM_LENGTH = 22;
    private static final int DBMB_LENGTH = 64;
    private static final int DBAM_LENGTH = 55;
    private static final int DBBG_LENGTH = 95;
    private static final int DBKB_LENGTH = 20;
    private final List<DeuvDskk> mErrors = new ArrayList<DeuvDskk>();
    private DeuvDskk[] mReceiveds;
    private Deque<DskkEmployee> mDskkEmployees;
    private final Date mCreatedOn = VDate.getCurrentLocalizedDateAndTime();
    private int mCreateCounter;

    public DskkReceive(DEUVSender deuvSender) {
        super(deuvSender);
    }

    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile((File)file, (String)"Meldungen Krankenkasse");
        LinkedList records = PFileHelper.getFileLines((File)file, (String)ISO_8859_1);
        Matcher matcherKV = VOSZ_KV_AG.matcher((CharSequence)records.pollFirst());
        return matcherKV.matches() && ((String)records.getFirst()).startsWith("DSKK");
    }

    public String getProcedureName() {
        return "Meldungen der Krankenkassen (DSKK)";
    }

    public String getFileDescription() {
        return "Meldung(en) der Krankenkassen";
    }

    public String getActionName() {
        return "importieren";
    }

    public Set<DEUVRecipient> getDeuvRecipients() throws BusinessDomainException {
        this.initFiles();
        return this.mFiles.keySet();
    }

    public void readDeuvDskks(DEUVRecipient deuvRecipient) throws BusinessDomainException {
        this.initFiles();
        this.mRecipient = deuvRecipient;
        for (File file : (List)this.mFiles.get(deuvRecipient)) {
            this.readDeuvDskks(file);
        }
    }

    private void readDeuvDskks(File file) throws BusinessDomainException {
        int currentFileNumber;
        this.mCurrent = file;
        LinkedList records = PFileHelper.getFileLines((File)file, (String)ISO_8859_1);
        Matcher matcherKV = VOSZ_KV_AG.matcher((CharSequence)records.pollFirst());
        if (matcherKV.matches()) {
            currentFileNumber = Integer.parseInt(matcherKV.group(1));
            records.pollLast();
            while (!records.isEmpty()) {
                String dataset = (String)records.pollFirst();
                if (dataset.startsWith("DSME")) continue;
                DeuvDskk dskk = this.readDskk(dataset, currentFileNumber);
                this.mImporteds.add(dskk);
            }
        } else {
            throw new IllegalStateException(file.getPath() + " don't match: " + matcherKV);
        }
        this.mAcknowledgement.addProcessedFile(file, PerfidiaDataType.SAG, this.mRecipient, currentFileNumber);
        this.mPerfidiaResult.addReceivedFile(file);
    }

    private DeuvDskk readDskk(String input, int currentFileNumber) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 286, DSKK_V03_V04);
        DeuvDskk dskk = this.createDeuvDskk(currentFileNumber, matcher);
        this.updateDskk(dskk);
        if (dskk.hasDbmb() && !dskk.hasError()) {
            this.checkMemberShipHI(dskk);
        }
        dskk.setSerialNumber(++this.mCreateCounter);
        for (DeuvDskk each : this.getReceiveds()) {
            if (!each.isEqual(dskk)) continue;
            each.makeSaveable();
            each.destroy();
            break;
        }
        return dskk;
    }

    private DeuvDskk createDeuvDskk(int currentFileNumber, Matcher matcher) throws BusinessDomainException {
        DeuvDskk dskk = this.initDeuvDskk(this.mRecipient, currentFileNumber, matcher);
        String rest = matcher.group("REST");
        if (dskk.hasDbmm()) {
            rest = this.initDbmm(rest, dskk.createDbmm());
        }
        if (dskk.hasDbmb()) {
            rest = this.initDbmb(rest, dskk.createDbmb());
        }
        if (dskk.hasDbam()) {
            rest = this.initDbam(rest, dskk.createDbam());
        }
        if (dskk.hasDbbg()) {
            rest = this.initDbbg(rest, dskk.createDbbg());
        }
        if (dskk.hasDbna()) {
            DskkDbna dskkDbna = dskk.createDbna();
            Dbna dbna = new Dbna();
            dskkDbna.setDbnaData(dbna);
            rest = this.initDbna(rest, dbna);
        }
        if (dskk.hasDbkb()) {
            rest = this.initDbkb(rest, dskk);
        }
        return dskk;
    }

    private DeuvDskk initDeuvDskk(DEUVRecipient responder, int currentFileNumber, Matcher matcher) {
        DeuvDskk dskk = new DeuvDskk();
        dskk.setCanceled("N");
        dskk.setDEUVSender(this.getDeuvSender());
        dskk.setDEUVRecipient(responder);
        dskk.setCurrentFileNumber(currentFileNumber);
        dskk.setCreatedOn(this.mCreatedOn);
        dskk.setBbnrab(this.asString(matcher.group("ABSN")));
        dskk.setBbnrep(this.asString(matcher.group("EPNR")));
        dskk.setEd(this.asString(matcher.group("ED")));
        dskk.setVsnr(this.asString(matcher.group("VSNR")));
        dskk.setAzkk(this.asString(matcher.group("AZKK")));
        dskk.setBbnrag(this.asString(matcher.group("BBNRAG")));
        dskk.setAzag(this.asString(matcher.group("AZAG")));
        dskk.setBbnras(this.asString(matcher.group("BBNRAS")));
        dskk.setGd(this.asString(matcher.group("GD")));
        dskk.setMmmm(this.asString(matcher.group("MMMM")));
        dskk.setMmmb(this.asString(matcher.group("MMMB")));
        dskk.setMmam(this.asString(matcher.group("MMAM")));
        dskk.setMmmg(this.asString(matcher.group("MMMG")));
        dskk.setMmna(this.asString(matcher.group("MMNA")));
        dskk.setMmku(matcher.group("MMKU"));
        dskk.setDatensatzid(this.asString(matcher.group("DSID")));
        dskk.setDatensatzidursprung(this.asString(matcher.group("DSIDUR")));
        dskk.setMmmz("N");
        dskk.setMmgb("N");
        dskk.setMman("N");
        return dskk;
    }

    private String initDbmm(String input, DskkDbmm dbmm) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 22, DBMM);
        dbmm.setKennzst(this.asString(matcher.group("KENNZST")));
        dbmm.setZrbg(PDateHelper.toDateYYYYMMDD((String)matcher.group("ZRBG")));
        dbmm.setZren(PDateHelper.toDateYYYYMMDD((String)matcher.group("ZREN")));
        return matcher.group("REST");
    }

    private String initDbmb(String input, DskkDbmb dbmb) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 64, DBMB);
        dbmb.setKennzst(this.asString(matcher.group("KENNZST")));
        dbmb.setMgst(this.asString(matcher.group("MGST")));
        dbmb.setZrbm(PDateHelper.toDateYYYYMMDD((String)matcher.group("ZRBM")));
        return matcher.group("REST");
    }

    private String initDbam(String input, DskkDbam dbam) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 55, DBAM);
        dbam.setAfkj(this.asInteger(matcher.group("AFKJ")));
        return matcher.group("REST");
    }

    private String initDbkb(String input, DeuvDskk dskk) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 20, DBKB);
        dskk.setKennzkb(this.asInteger(matcher.group("KENNZKB")));
        return matcher.group("REST");
    }

    private String initDbbg(String input, DskkDbbg dbbg) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 95, DBBG);
        dbbg.setKennzst(this.asString(matcher.group("KENNZST")));
        dbbg.setGaegKV(this.asCents(matcher.group("GAEGKV")));
        dbbg.setGaegRV(this.asCents(matcher.group("GAEGRV")));
        dbbg.setGaegALV(this.asCents(matcher.group("GAEGALV")));
        dbbg.setEgaKV(this.asCents(matcher.group("EGAKV")));
        dbbg.setEgaRV(this.asCents(matcher.group("EGARV")));
        dbbg.setEgaALV(this.asCents(matcher.group("EGALV")));
        dbbg.setZrbg(PDateHelper.toDateYYYYMMDD((String)matcher.group("ZRBG")));
        dbbg.setZren(PDateHelper.toDateYYYYMMDD((String)matcher.group("ZREN")));
        dbbg.setKennzRk(this.asString(matcher.group("KENNZRK")));
        dbbg.setSvtg(this.asString(matcher.group("SVTG")));
        dbbg.setKennzLfdKV(this.asString(matcher.group("KENNZKVL")));
        dbbg.setKennzLfdRV(this.asString(matcher.group("KENNZRVL")));
        dbbg.setKennzLfdALV(this.asString(matcher.group("KENNZALVL")));
        dbbg.setKennzEgaKV(this.asString(matcher.group("KENNZKVE")));
        dbbg.setKennzEgaRV(this.asString(matcher.group("KENNZRVE")));
        dbbg.setKennzEgaALV(this.asString(matcher.group("KENNZALVE")));
        return matcher.group("REST");
    }

    private void updateDskk(DeuvDskk dskk) throws BusinessDomainException {
        dskk.setCanceled(dskk.isCancelation() ? "J" : "N");
        dskk.setLongReasonOfDeliv(dskk.getGd());
        this.setDates(dskk, DeuvBasics.deuvDateStringToDate((String)dskk.getEd()));
        if (dskk.hasDbmm()) {
            DskkDbmm dbmm = dskk.getDbmm();
            this.setDates(dskk, dbmm.getZrbg(), dbmm.getZrbg(), dbmm.getZren());
        }
        if (dskk.hasDbbg()) {
            DskkDbbg dbbg = dskk.getDbbg();
            this.setDates(dskk, dbbg.getZrbg(), dbbg.getZrbg(), dbbg.getZren());
        }
        if (dskk.hasDbam()) {
            int year = dskk.getDbam().getAfkj();
            Date validFrom = PDateHelper.toDate((LocalDate)LocalDate.of(year, Month.JANUARY, 1));
            Date validUntil = PDateHelper.toDate((LocalDate)LocalDate.of(year, Month.DECEMBER, 31));
            this.setDates(dskk, validUntil, validFrom, validUntil);
        }
        if (this.isDskkForCompany(dskk)) {
            return;
        }
        Employee employee = null;
        if (dskk.hasDbmm() || dskk.hasDbbg() || dskk.hasDbam()) {
            employee = Deuv.findEmployeeByAzOrVsnr((String)dskk.getAzag(), (String)dskk.getVsnr(), (String)dskk.getBbnrag(), (Date)dskk.getValidFrom(), (Date)dskk.getValidUntil());
        } else if (dskk.hasDbmb() || dskk.hasDbkb()) {
            Date validDate = null;
            if (dskk.hasDbmb() && (validDate = dskk.getDbmb().getZrbm()) != null) {
                employee = Deuv.findEmployeeByAzOrVsnr((String)dskk.getAzag(), (String)dskk.getVsnr(), (String)dskk.getBbnrag(), (Date)validDate);
                this.setDates(dskk, validDate);
            }
            if (employee == null) {
                employee = Deuv.findEmployeeByAz((String)dskk.getAzag());
            }
        }
        if (employee == null) {
            dskk.addError("Es konnte kein Mitarbeiter zugeordnet werden!");
            dskk.makeReadOnly();
        } else {
            if (dskk.hasDbmm() && DateHelper.before((Date)dskk.getValidFrom(), (Date)DeuvHelper.getCalculationStart((PCompany)employee.getPCompany()))) {
                dskk.addError("Zeitraum teilweise vor Berechnungstart. GKV-Monatsmeldungen(58) m\u00fcssen teilweise manuell erstellt werden!");
            }
            dskk.setEmployee(employee);
        }
    }

    private void setDates(DeuvDskk dskk, Date date) {
        this.setDates(dskk, date, date, date);
    }

    private void setDates(DeuvDskk dskk, Date effectiveFrom, Date validFrom, Date validUntil) {
        dskk.setEffectiveFrom(effectiveFrom);
        dskk.setValidFrom(validFrom);
        dskk.setValidUntil(validUntil);
    }

    private boolean isDskkForCompany(DeuvDskk dskk) {
        return "06".equals(dskk.getGd());
    }

    private void checkMemberShipHI(DeuvDskk dskk) throws BusinessDomainException {
        DskkDbmb dbmb = dskk.getDbmb();
        DEUVAccount refAccount = this.getReferenceDeuvAccount(dskk.getEmployee(), dbmb);
        if (refAccount == null) {
            dskk.addError("Zugeh\u00f6rige Anmeldung nicht gefunden! Bitte pr\u00fcfen!");
            return;
        }
        if ("J".equals(dbmb.getMgst())) {
            if (DateHelper.before((Date)refAccount.getValidFrom(), (Date)dbmb.getZrbm())) {
                dskk.addError("Krk-Wechsel zu falschem Termin! Bitte korrigieren!");
            }
        } else if (dbmb.getZrbm() == null && !this.isPKV(dskk.getEmployee(), dskk.getEmployee().getMaximumDateOfEntry())) {
            dskk.addError("Anmeldung an unzust\u00e4ndige Krankenkasse! Bitte korrigieren!");
        }
    }

    private DEUVAccount getReferenceDeuvAccount(Employee employee, DskkDbmb dbmb) throws BusinessDomainException {
        DEUVAccount[] query;
        DEUVAccount result = null;
        Criterion filter = Restrictions.and((Criterion)Restrictions.eq((String)"OIDEMPLOYEE", (String)employee.getObjectid()), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"REASONOFDELIVERY", (String)"10"), (Criterion)Restrictions.eq((String)"REASONOFDELIVERY", (String)"11")));
        Order[] sort = new Order[]{Order.desc((String)"CREATEDON")};
        if (dbmb.getZrbm() != null && (query = DEUVAccountPersistencyManager.query((Order[])sort, (Criterion)Restrictions.and((Criterion)filter, (Criterion)Restrictions.eq((String)"VALIDFROM", (String)DateMapper.toString((Date)dbmb.getZrbm()))))).length > 0) {
            result = query[0];
        }
        if (result == null) {
            filter = Restrictions.and((Criterion)filter, (Criterion)Restrictions.le((String)"CREATEDON", (String)dbmb.getDeuvDskk().getEd()));
            if (dbmb.getZrbm() != null) {
                filter = Restrictions.and((Criterion)filter, (Criterion)Restrictions.le((String)"VALIDFROM", (String)DateMapper.toString((Date)dbmb.getZrbm())));
            }
            for (DEUVAccount deuvAccount : query = DEUVAccountPersistencyManager.query((Order[])sort, (Criterion)filter)) {
                if (!deuvAccount.getDEUVDsme().getBbnrKrankenkasse().equals(dbmb.getDeuvDskk().getBbnrab())) continue;
                result = deuvAccount;
                break;
            }
        }
        return result;
    }

    private boolean isPKV(Employee employee, Date validDate) {
        if (employee != null) {
            Insurance insurance = (Insurance)employee.getInsuranceHistory().getItemOrNull(validDate);
            return insurance != null && insurance.getPrivateHI();
        }
        return false;
    }

    private List<DeuvDskk> getReferences() throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.isNotNull((String)"OIDEMPLOYEE"), Restrictions.ge((String)"VALIDFROM", (String)DateMapper.toString((Date)START_OF_DSKK_2015)), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"GD", (String)"01"), Restrictions.eq((String)"GD", (String)"02"), Restrictions.eq((String)"GD", (String)"03")})});
        DeuvDskk[] query = DeuvDskkPersistencyManager.query(null, (Criterion)filter, (boolean)true);
        List relevantPCompanys = this.getDeuvSender().getAssignedPCompanies(true);
        ArrayList<DeuvDskk> references = new ArrayList<DeuvDskk>();
        for (DeuvDskk dskk : query) {
            if (!relevantPCompanys.contains(dskk.getEmployee().getPCompany())) continue;
            references.add(dskk);
        }
        Collections.sort(references, new Comparator<DeuvDskk>(){

            @Override
            public int compare(DeuvDskk o1, DeuvDskk o2) {
                int result = o1.compareToCancellation(o2);
                if (result == 0) {
                    result = StringMapper.compareTo((String)o1.getEd(), (String)o2.getEd());
                }
                return result;
            }
        });
        for (DeuvDskk each : references) {
            if (!each.hasError()) continue;
            each.makeSaveable();
            each.clearError();
        }
        LinkedList<DeuvDskk> normals = new LinkedList<DeuvDskk>();
        LinkedList<DeuvDskk> stornos = new LinkedList<DeuvDskk>();
        for (DeuvDskk each : references) {
            if (each.isCancelation()) {
                each.reorgCanceled("J");
                stornos.addLast(each);
                continue;
            }
            normals.addLast(each);
        }
        references.clear();
        while (!normals.isEmpty() && !stornos.isEmpty()) {
            int diff = ((DeuvDskk)normals.getFirst()).compareToCancellation((DeuvDskk)stornos.getFirst());
            if (diff == 0) {
                ((DeuvDskk)normals.removeFirst()).reorgCanceled("X");
                ((DeuvDskk)stornos.removeFirst()).reorgCanceled("J");
                continue;
            }
            if (diff < 0) {
                references.add((DeuvDskk)normals.removeFirst());
                continue;
            }
            stornos.removeFirst();
        }
        while (!normals.isEmpty()) {
            references.add((DeuvDskk)normals.removeFirst());
        }
        ArrayList<DeuvDskk> obsoletes = new ArrayList<DeuvDskk>();
        DeuvDskk prev = null;
        ListIterator it = references.listIterator(references.size());
        while (it.hasPrevious()) {
            DeuvDskk each = (DeuvDskk)it.previous();
            if (prev != null && each.compareToCancellation(prev) == 0) {
                each.reorgCanceled("X");
                obsoletes.add(each);
            }
            prev = each;
        }
        references.removeAll(obsoletes);
        obsoletes.clear();
        for (DeuvDskk each : references) {
            if (!"S".equals(each.getCanceled()) && !"M".equals(each.getCanceled())) continue;
            each.makeReadOnly();
            obsoletes.add(each);
        }
        references.removeAll(obsoletes);
        for (DeuvDskk each : references) {
            each.reorgCanceled("N");
        }
        return references;
    }

    private void initDskkEmployees() throws BusinessDomainException {
        this.mDskkEmployees = new LinkedList<DskkEmployee>();
        HashSet<Employee> employees = new HashSet<Employee>();
        List<DeuvDskk> references = this.getReferences();
        for (DeuvDskk each : references) {
            employees.add(each.getEmployee());
        }
        List<EEDeuvDskk> calculateds = this.getEEDeuvDskks();
        for (EEDeuvDskk each : calculateds) {
            employees.add(each.getEmployee());
        }
        employees.remove(null);
        for (Employee ee : employees) {
            DskkEmployee current = new DskkEmployee(ee);
            current.updateReferences(references);
            current.updateCalculateds(calculateds);
            this.mDskkEmployees.add(current);
        }
    }

    private DeuvDskk[] getReceiveds() {
        if (this.mReceiveds == null) {
            this.mReceiveds = DeuvDskkPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"OIDDEUVSENDER", (String)this.getDeuvSender().getObjectid()), (boolean)true);
        }
        return this.mReceiveds;
    }

    public List<DeuvDskk> getCreatedsAndErrors() {
        ArrayList<DeuvDskk> result = new ArrayList<DeuvDskk>(this.mErrors);
        for (DeuvDskk deuvDskk : this.mImporteds) {
            if (result.contains(deuvDskk)) continue;
            result.add(deuvDskk);
        }
        Collections.sort(result, new DskkReportComparator());
        return Collections.unmodifiableList(result);
    }

    public void addErrorDeuvDskk(List<DeuvDskk> errors) {
        LocalDate minCreatedOn = LocalDate.now().minusMonths(6L);
        for (DeuvDskk deuvDskk : errors) {
            if (!minCreatedOn.isBefore(DateHelper.toLocalDate((Date)deuvDskk.getCreatedOn()))) continue;
            this.mErrors.add(deuvDskk);
        }
    }

    private List<EEDeuvDskk> getEEDeuvDskks() {
        ArrayList<EEDeuvDskk> result = new ArrayList<EEDeuvDskk>();
        List pCompanyOids = this.getDeuvSender().getAssignedPCompanies(true).stream().map(PersistentObject::getObjectid).collect(Collectors.toList());
        if (!pCompanyOids.isEmpty()) {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"OIDPCOMPANY", pCompanyOids), Restrictions.eq((String)"EFFECTIVEUNTIL", (String)VDate.getDateMaxAsString()), Restrictions.ge((String)"VALIDFROM", (String)DateMapper.toString((Date)START_OF_DSKK_2015)), Restrictions.eq((String)"DELETED", (String)BooleanMapper.toString((boolean)false))});
            for (EEDeuvDskkTP tp : EEDeuvDskkTPPersistencyManager.queryAll(null, (Criterion)filter, (boolean)true)) {
                result.add(tp.getEEDeuvDskk());
            }
        }
        return result;
    }

    public boolean hasDskkEmployee() throws BusinessDomainException {
        if (this.mDskkEmployees == null) {
            this.initDskkEmployees();
        }
        return !this.mDskkEmployees.isEmpty();
    }

    public DskkEmployee nextDskkEmployee() throws BusinessDomainException {
        return this.mDskkEmployees.pollFirst();
    }

    public int getCountDskkEmployees() throws BusinessDomainException {
        if (this.mDskkEmployees == null) {
            this.initDskkEmployees();
        }
        return this.mDskkEmployees.size();
    }

    public boolean hasImporteds() {
        return !this.mImporteds.isEmpty() || !this.mErrors.isEmpty();
    }
}

