/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.deuv.DateInterval;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.DeuvComponents;
import com.varial.personnel.domain.deuv.IDbanData;
import com.varial.personnel.domain.deuv.IDbgbData;
import com.varial.personnel.domain.deuv.IDbnaData;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAdvice;
import com.varial.personnel.domain.deuv.deuvaccount.PersonalCurrentData;
import com.varial.personnel.domain.deuv.deuvaccount.TypeOfAccountEnum;
import com.varial.personnel.domain.deuv.deuvdsfz.DEUVDsfz;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.system.sibreak.EECarriedForwardSystemSIBreak;
import com.varial.personnel.domain.employee.insurance.ContributionScaleVHIEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.deutscherv.gb0500.kernpruefung.krips.impl.Krips;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kernpruefung.Rueckgabe;

public class DsfzEmployee {
    private static final Date START_OF_DSFZ_2024 = DateMapper.toDate((String)"2024-01-01");
    private static final String N = "N";
    private static final String J = "J";
    public static String FZ_E_5_1 = "5.1";
    public static int GD_17 = 17;
    public static int GD_37 = 37;
    private final DEUVAdvice mDeuvAdvice;
    private final Employee mEmployee;
    private final List<DEUVAccount> mCreateds;
    private final Date mEffectiveFrom;
    private final Date mJournalizedUntil;
    private PersonalCurrentData mPersonalCurrentData;

    public DsfzEmployee(DEUVAdvice deuvAdvice, Employee employee) throws BusinessDomainException {
        this.mDeuvAdvice = deuvAdvice;
        this.mEmployee = employee;
        this.mCreateds = new ArrayList<DEUVAccount>();
        this.mJournalizedUntil = deuvAdvice.isPreview() ? PDateHelper.getLastDayNextMonth((Date)this.mEmployee.getJournalizedUntil()) : this.mEmployee.getJournalizedUntil();
        this.mEffectiveFrom = DateHelper.tomorrow((Date)this.mJournalizedUntil);
    }

    public void createAccounts() throws BusinessDomainException {
        for (DateInterval absentTime : this.getAbsentTimes()) {
            if (!this.isAbsentTimeRelevant(absentTime)) continue;
            Date validFrom = absentTime.getValidFrom();
            if (DateHelper.beforeOrEqual((Date)validFrom, (Date)this.mJournalizedUntil)) {
                this.mCreateds.add(this.createAccount(validFrom, null, GD_17));
            }
            for (Date changeDate : this.getHealthFundChangeDates(absentTime.getValidFrom(), absentTime.getValidUntil())) {
                this.mCreateds.add(this.createAccount(changeDate, null, GD_17));
                validFrom = changeDate;
            }
            Date validUntil = absentTime.getValidUntil();
            if (!DateHelper.beforeOrEqual((Date)validUntil, (Date)this.mJournalizedUntil) || !this.isHIDuty(validUntil) && !this.isVoluntaryHI(validUntil)) continue;
            this.mCreateds.add(this.createAccount(validFrom, absentTime.getValidUntil(), GD_37));
        }
    }

    private List<DateInterval> getAbsentTimes() throws BusinessDomainException {
        DateInterval cfInterval;
        Order[] sort = new Order[]{Order.asc((String)"validfrom")};
        EEAbsentTimeTP[] eeAT = EEAbsentTimeTPPersistencyManager.queryAll((Order[])sort, (Criterion)this.createEeabsentimeallFilter(), (boolean)true);
        ArrayList<DateInterval> absentTimes = new ArrayList<DateInterval>();
        DateInterval last = null;
        for (EEAbsentTimeTP eeAbsentTimeTP : eeAT) {
            if (last != null) {
                if (DateHelper.equal((Date)DateHelper.tomorrow((Date)last.getValidUntil()), (Date)eeAbsentTimeTP.getValidFrom())) {
                    last = new DateInterval(last.getValidFrom(), eeAbsentTimeTP.getValidUntil());
                    continue;
                }
                absentTimes.add(last);
            }
            last = new DateInterval(eeAbsentTimeTP.getValidFrom(), eeAbsentTimeTP.getValidUntil());
        }
        if (last != null) {
            absentTimes.add(last);
        }
        if (!absentTimes.isEmpty() && DateHelper.afterOrEqual((Date)this.mDeuvAdvice.getCalculationStart(), (Date)START_OF_DSFZ_2024) && DateHelper.equal((Date)((DateInterval)absentTimes.get(0)).getValidFrom(), (Date)this.mDeuvAdvice.getCalculationStart()) && (cfInterval = this.getCFAbsentTime()) != null) {
            absentTimes.set(0, new DateInterval(cfInterval.getValidFrom(), ((DateInterval)absentTimes.get(0)).getValidUntil()));
        }
        for (DateInterval each : absentTimes) {
            Date withdrawal = this.mEmployee.getNextDateOfWithdrawal(each.getValidFrom(), this.mJournalizedUntil);
            if (withdrawal == null || !DateHelper.before((Date)withdrawal, (Date)each.getValidUntil())) continue;
            each = new DateInterval(each.getValidFrom(), withdrawal);
        }
        return absentTimes;
    }

    public DateInterval getCFAbsentTime() throws BusinessDomainException {
        DateInterval result = null;
        for (EECarriedForwardSystemSIBreak each : this.mEmployee.getEECarriedForwardSystemSIBreak()) {
            if (!DateHelper.equal((Date)each.getValidUntil(), (Date)DateHelper.yesterday((Date)this.mDeuvAdvice.getCalculationStart())) || !FZ_E_5_1.equals(each.getAbsentTime().getDEUVAbsentTimeKey())) continue;
            result = new DateInterval(each.getValidFrom(), each.getValidUntil());
            break;
        }
        return result;
    }

    private Criterion createEeabsentimeallFilter() {
        String effectiveTimePoint = DateMapper.toString((Date)this.mJournalizedUntil);
        String validDate = DateMapper.toString((Date)DateHelper.yesterday((Date)START_OF_DSFZ_2024));
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"deuvrelevant", (String)BooleanMapper.toString((boolean)true)), Restrictions.eq((String)"deuvabsenttimekey", (String)FZ_E_5_1), Restrictions.eq((String)"deleted", (String)BooleanMapper.toString((boolean)false)), Restrictions.le((String)"effectivefrom", (String)effectiveTimePoint), Restrictions.ge((String)"effectiveuntil", (String)effectiveTimePoint), Restrictions.ge((String)"validuntil", (String)validDate)});
    }

    private boolean isAbsentTimeRelevant(DateInterval absentTime) {
        if (DateHelper.before((Date)absentTime.getValidFrom(), (Date)START_OF_DSFZ_2024)) {
            return false;
        }
        if (this.isVoluntaryHI(absentTime.getValidFrom())) {
            return true;
        }
        if (this.isHIDuty(absentTime.getValidFrom())) {
            return this.isCalendary(absentTime.getValidFrom(), absentTime.getValidUntil());
        }
        return false;
    }

    private boolean isHIDuty(Date validTimePoint) {
        Insurance insurance = this.getInsurance(validTimePoint);
        return insurance != null && (insurance.getDuesGroupHI() == 1 || insurance.getDuesGroupHI() == 3);
    }

    private boolean isVoluntaryHI(Date validTimePoint) {
        Insurance insurance = this.getInsurance(validTimePoint);
        if (insurance == null) {
            return false;
        }
        return insurance.getDuesGroupHI() == 9 || insurance.getDuesGroupHI() == 0 && insurance.getContScaleVHI() != ContributionScaleVHIEnum.CSE_KEINE;
    }

    public boolean isCalendary(Date beginDate, Date endDate) {
        boolean result = false;
        LocalDate checkEnd = DateHelper.toLocalDate((Date)DateHelper.min((Date)endDate, (Date)this.mJournalizedUntil));
        LocalDate beginn = DateHelper.toLocalDate((Date)beginDate);
        result = beginn.getDayOfMonth() == 1 ? !checkEnd.isBefore(beginn.with(TemporalAdjusters.lastDayOfMonth())) : !checkEnd.isBefore(beginn.plusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()));
        return result;
    }

    private List<Date> getHealthFundChangeDates(Date validFrom, Date validUntil) {
        List insuranceTPs = this.mEmployee.getInsuranceHistory().getPeriods(this.mJournalizedUntil, validFrom, validUntil);
        ArrayList<Date> changeDates = new ArrayList<Date>();
        HealthFund last = null;
        for (Insurance tp : insuranceTPs) {
            Date validTP;
            if (last != null && !tp.getHealthFund().equals((Object)last) && (this.isHIDuty(validTP = tp.getValidFrom()) || this.isVoluntaryHI(validTP))) {
                changeDates.add(tp.getValidFrom());
            }
            last = tp.getHealthFund();
        }
        return changeDates;
    }

    private DEUVAccount createAccount(Date validFrom, Date validUntil, int abgabegrund) throws BusinessDomainException {
        Date validTP = validUntil == null ? validFrom : validUntil;
        DEUVAccount dsfzAccount = new DEUVAccount();
        dsfzAccount.setEmployee(this.mEmployee);
        dsfzAccount.setEffectiveFrom(this.mEffectiveFrom);
        dsfzAccount.setValidFrom(validFrom);
        dsfzAccount.setValidUntil(validUntil == null ? VDate.getDateMax() : validUntil);
        dsfzAccount.setCreatedOn(this.mDeuvAdvice.getCreatedOn());
        dsfzAccount.setCanceled(N);
        dsfzAccount.setLongReasonOfDeliv(String.valueOf(abgabegrund));
        dsfzAccount.setReasonOfDelivery(abgabegrund);
        dsfzAccount.setDEUVSender(this.mDeuvAdvice.getDEUVSender());
        dsfzAccount.setDEUVRecipient(this.getDEUVRecipient(validFrom));
        Insurance insurance = this.getInsurance(validTP);
        dsfzAccount.setInsuranceNo(this.getPersonalCurrentData().getInsuranceNo());
        dsfzAccount.setPersongroup(insurance.getPersonGroup());
        DEUVDsfz dsfz = dsfzAccount.createDeuvDsfz();
        dsfz.setKennzst(N);
        dsfz.setAbsn(DeuvHelper.getDeuvSenderStdCompNo((DEUVSender)this.mDeuvAdvice.getDEUVSender()));
        dsfz.setEpnr(DeuvHelper.getHealthFundStdCompNo((HealthFund)insurance.getHealthFund(), (Date)new Date()));
        dsfz.setEd(this.mDeuvAdvice.getCreatedOn());
        dsfz.setProdid(DeuvBasics.getProdId());
        dsfz.setModid(DeuvBasics.getModId());
        dsfz.setBbnrvu(this.getEECompanyPlant(validTP).getCompanyNumber());
        dsfz.setAzvu(Deuv.toAzVerursacher((String)this.mEmployee.getIDString()));
        dsfz.setVsnr(dsfzAccount.getInsuranceNo());
        dsfz.setGd(abgabegrund);
        dsfz.setBe(validFrom);
        dsfz.setEe(validUntil);
        this.getPersonalCurrentData().fill((IDbnaData)dsfz.createDeuvDbna());
        this.getPersonalCurrentData().fill((IDbanData)dsfz.createDeuvDban());
        if (StringMapper.isNullString((String)dsfz.getVsnr())) {
            this.getPersonalCurrentData().fill((IDbgbData)dsfz.createDeuvDbgb());
        }
        return dsfzAccount;
    }

    public void makeResults() throws BusinessDomainException {
        DEUVAccount storno;
        LinkedList<DEUVAccount> existing = new LinkedList<DEUVAccount>(this.getActiveTransmitted());
        this.mCreateds.sort(Comparator.comparing(DEUVAccount::getValidFrom).thenComparing(DEUVAccount::getReasonOfDelivery));
        LinkedList<DEUVAccount> createds = new LinkedList<DEUVAccount>(this.mCreateds);
        this.mCreateds.clear();
        while (!createds.isEmpty() && !existing.isEmpty()) {
            DEUVAccount existent = (DEUVAccount)((Object)existing.getFirst());
            DEUVAccount created = (DEUVAccount)((Object)createds.getFirst());
            switch (this.compareAccounts(existent, created)) {
                case 0: {
                    created.makeReadOnly();
                    existing.removeFirst();
                    createds.removeFirst();
                    break;
                }
                case -1: {
                    storno = this.makeCancellation(existent);
                    this.checkForErrors(storno);
                    this.mCreateds.add(storno);
                    existing.removeFirst();
                    break;
                }
                case 1: {
                    this.checkForErrors(created);
                    created.setSerialNumber(this.mDeuvAdvice.incrementCounter());
                    this.mCreateds.add(created);
                    createds.removeFirst();
                    break;
                }
            }
        }
        for (DEUVAccount account : existing) {
            storno = this.makeCancellation(account);
            this.checkForErrors(storno);
            this.mCreateds.add(storno);
        }
        for (DEUVAccount account : createds) {
            this.checkForErrors(account);
            account.setSerialNumber(this.mDeuvAdvice.incrementCounter());
            this.mCreateds.add(account);
        }
    }

    private List<DEUVAccount> getActiveTransmitted() throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.OIDEMPLOYEE, (String)this.mEmployee.getObjectid()), Restrictions.eq((String)DEUVAccountPersistencyManager.TYPEOFACCOUNT, (String)TypeOfAccountEnum.toDBString((TypeOfAccountEnum)TypeOfAccountEnum.DSFZ)), Restrictions.ge((String)DEUVAccountPersistencyManager.VALIDFROM, (String)DateMapper.toString((Date)START_OF_DSFZ_2024))});
        ArrayList<DEUVAccount> existents = new ArrayList<DEUVAccount>(Arrays.asList(DEUVAccountPersistencyManager.query(null, (Criterion)filter)));
        for (DEUVAccount each : new ArrayList<DEUVAccount>(existents)) {
            if (!each.getTransmitted()) {
                existents.remove((Object)each);
                each.makeSaveable();
                each.destroy();
                continue;
            }
            if (this.hasFileError(each)) {
                existents.remove((Object)each);
                continue;
            }
            if (each.getDeuvDsfz() == null || !each.getDeuvDsfz().getKennzst().equals(J)) continue;
            each.reorgCancelled(J);
        }
        existents.sort(Comparator.comparing(DEUVAccount::getValidFrom).thenComparing(DEUVAccount::getReasonOfDelivery).thenComparing(DEUVAccount::getCreatedOn));
        LinkedList<DEUVAccount> toCheck = new LinkedList<DEUVAccount>(existents);
        while (!toCheck.isEmpty()) {
            DEUVAccount current = (DEUVAccount)((Object)toCheck.remove(0));
            if ("X".equals(current.getCanceled()) || current.getAdviceState() == AdviceStateEnum.STORNIERT) {
                for (DEUVAccount each : toCheck) {
                    if (!J.equals(each.getCanceled()) || this.compareAccounts(current, each) != 0) continue;
                    toCheck.remove((Object)each);
                    existents.remove((Object)each);
                    existents.remove((Object)current);
                    current = null;
                    break;
                }
                if (current == null) continue;
                current.reorgCancelled(N);
                continue;
            }
            if (!J.equals(current.getCanceled())) continue;
            existents.remove((Object)current);
        }
        for (DEUVAccount each : existents) {
            each.loadAdvicedState(null);
        }
        return existents;
    }

    private int compareAccounts(DEUVAccount existing, DEUVAccount created) {
        int result = DateHelper.compare((Date)existing.getValidFrom(), (Date)created.getValidFrom());
        if (result == 0 && existing.getDeuvDsfz().isDifferent(created.getDeuvDsfz())) {
            result = -1;
        }
        return result;
    }

    private boolean hasFileError(DEUVAccount account) {
        if (account.getAdviceState() == AdviceStateEnum.FEHLER_DATEI) {
            return true;
        }
        return account.getAdviceState() == AdviceStateEnum.FEHLER_KERNPRUEFUNG && account.getErrorMessage().matches("DSFZ.50.*");
    }

    public DEUVAccount makeCancellation(DEUVAccount account) throws BusinessDomainException {
        account.reorgCancelled("X");
        DEUVAccount storno = this.makeDeuvAccountCopy(account);
        storno.setTransmitted(false);
        storno.setAdviceState(AdviceStateEnum.AUFGEBAUT);
        storno.setEeCertificate(false);
        storno.setCurrentFileNumber(0);
        storno.setCanceled(J);
        storno.setErrorMessage(null);
        storno.setManually(false);
        DEUVDsfz dsfz = storno.getDeuvDsfz();
        dsfz.setKennzst(J);
        dsfz.setAzvu(Deuv.toCancellation((String)dsfz.getAzvu()));
        dsfz.updateVersionNr();
        dsfz.setProdid(DeuvBasics.getProdId());
        dsfz.setModid(DeuvBasics.getModId());
        dsfz.setEd(this.mDeuvAdvice.getCreatedOn());
        storno.setCreatedOn(this.mDeuvAdvice.getCreatedOn());
        account.setDEUVRecipient(this.mDeuvAdvice.getupdatedDeuvRecipient(account.getDEUVRecipient(), account.getDeuvDsfz().getEpnr()));
        dsfz.setDsidur(account.getDeuvDsfz().getDsid());
        storno.setInsuranceNo(this.getPersonalCurrentData().getInsuranceNo());
        dsfz.setVsnr(storno.getInsuranceNo());
        storno.setSerialNumber(-this.mDeuvAdvice.incrementCounter());
        return storno;
    }

    private DEUVAccount makeDeuvAccountCopy(DEUVAccount old) {
        DEUVAccount account = new DEUVAccount();
        account.setEmployee(old.getEmployee());
        account.setPCompany(old.getPCompany());
        account.setEffectiveFrom(this.mEffectiveFrom);
        account.setCreatedOn(this.mDeuvAdvice.getCreatedOn());
        account.setValidFrom(old.getValidFrom());
        account.setValidUntil(old.getValidUntil());
        account.setReasonOfDelivery(old.getReasonOfDelivery());
        account.setLongReasonOfDeliv(old.getLongReasonOfDeliv());
        account.setDEUVSender(old.getDEUVSender());
        account.setDEUVRecipient(old.getDEUVRecipient());
        account.setInsuranceNo(old.getInsuranceNo());
        account.setPersongroup(old.getPersongroup());
        account.setDuesgroups(old.getDuesgroups());
        account.setPayment(old.getPayment());
        DEUVDsfz dsfz = old.getDeuvDsfz().createNew(account);
        if (old.getDEUVDbna() != null) {
            old.getDEUVDbna().createNew(dsfz);
        }
        if (old.getDEUVDbgb() != null) {
            old.getDEUVDbgb().createNew(dsfz);
        }
        if (old.getDEUVDban() != null) {
            old.getDEUVDban().createNew(dsfz);
        }
        return account;
    }

    private void checkForErrors(DEUVAccount check) {
        Krips kernpruefung = new Krips();
        String dsfzString = DeuvComponents.getContentDsfz((DEUVDsfz)check.getDeuvDsfz());
        String vosz = check.getContentVoszForCheck();
        Rueckgabe rueckgabe = kernpruefung.pruefe(dsfzString, vosz);
        List errors = new ArrayList();
        if (rueckgabe.getReturnCode() >= 2) {
            errors = DeuvHelper.removeInvalidErrors((Rueckgabe)rueckgabe, (String[])new String[]{"DSFZ060"});
        }
        check.setErrorMessage(DeuvHelper.getErrorMessage((String)check.getErrorMessage(), errors, (boolean)true));
    }

    private Insurance getInsurance(Date validTimePoint) {
        return (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(this.mJournalizedUntil, validTimePoint);
    }

    private DEUVRecipient getDEUVRecipient(Date validTimePoint) throws BusinessDomainException {
        HealthFund healthFund = this.getInsurance(validTimePoint).getHealthFund();
        return this.mDeuvAdvice.getDEUVRecipient(healthFund);
    }

    protected PersonalCurrentData getPersonalCurrentData() throws BusinessDomainException {
        if (this.mPersonalCurrentData == null) {
            Date personalCurrentDate = DateHelper.max((Date)this.mJournalizedUntil, (Date)new Date());
            this.mPersonalCurrentData = new PersonalCurrentData(this.mEmployee, personalCurrentDate);
        }
        return this.mPersonalCurrentData;
    }

    private IEECompanyPlant getEECompanyPlant(Date validTimePoint) {
        IEECompanyPlant eeCompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        eeCompanyPlant.setEmployee(this.mEmployee);
        eeCompanyPlant.setEffectiveFrom(this.mEffectiveFrom);
        eeCompanyPlant.setValidFrom(validTimePoint);
        return eeCompanyPlant;
    }

    protected Date getBeforeCalculationStart() throws BusinessDomainException {
        return DateHelper.yesterday((Date)this.mDeuvAdvice.getCalculationStart());
    }

    public Collection<DEUVAccount> getResult() {
        return Collections.unmodifiableCollection(this.mCreateds);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('[').append(this.mEmployee);
        builder.append(',').append(this.mCreateds);
        builder.append(']');
        return builder.toString();
    }
}

