/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.bea.dben;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.bea.basics.GrundFiktivBruttoEnum;
import com.varial.personnel.domain.bea.dben.BeaDbenPersistencyManager;
import com.varial.personnel.domain.bea.dsab.BeaDsab;
import com.varial.personnel.domain.bea.mapper.BeaExceptionMapper;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BeaDben
extends PersistentObject {
    private final BeaDbenPersistencyManager pm = (BeaDbenPersistencyManager)UtilitiesManager.getBean((String)"beaDbenPersistencyManager", BeaDbenPersistencyManager.class);
    private static final int PRIORITY = 10;
    private static final String DBEN = "DBEN";
    private BeaDsab mBeaDsab;
    private Date mMonatbeg;
    private Date mMonatend;
    private String mKennzrk;
    private BigDecimal mSvbreglf;
    private BigDecimal mSvbrege;
    private BigDecimal mFibr;
    private String mMia;
    private Date mMiabeg;
    private Date mMiaend;
    private GrundFiktivBruttoEnum mFibgr;

    public BeaDben() {
        super(10);
    }

    public BeaDben(String objectID) {
        super(10, objectID);
    }

    public BeaDben(String objectId, int version) {
        super(10, objectId, version);
    }

    protected BeaDben(boolean readOnly) {
        super(10, readOnly);
    }

    public BeaDben(BeaDsab dsab) {
        this();
        this.mBeaDsab = dsab;
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        this.pm.save(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public BeaDsab getBeaDsab() {
        this.requireLoaded();
        return this.mBeaDsab;
    }

    public void setBeaDsab(BeaDsab beaDsab) {
        this.mBeaDsab = beaDsab;
    }

    public String getKennung() {
        return DBEN;
    }

    public Date getMonatbeg() {
        this.requireLoaded();
        return this.mMonatbeg;
    }

    public void setMonatbeg(Date monatbeg) {
        this.mMonatbeg = monatbeg;
    }

    public Date getMonatend() {
        this.requireLoaded();
        return this.mMonatend;
    }

    public void setMonatend(Date monatend) {
        this.mMonatend = monatend;
    }

    public String getKennzrk() {
        this.requireLoaded();
        return this.mKennzrk;
    }

    public void setKennzrk(String kennzrk) {
        this.mKennzrk = kennzrk;
    }

    public BigDecimal getSvbreglf() {
        this.requireLoaded();
        return this.mSvbreglf;
    }

    public void setSvbreglf(BigDecimal svbreglf) {
        this.mSvbreglf = svbreglf;
    }

    public BigDecimal getSvbrege() {
        this.requireLoaded();
        return this.mSvbrege;
    }

    public void setSvbrege(BigDecimal svbrege) {
        this.mSvbrege = svbrege;
    }

    public BigDecimal getFibr() {
        this.requireLoaded();
        return this.mFibr;
    }

    public void setFibr(BigDecimal fibr) {
        this.mFibr = fibr;
    }

    public String getMia() {
        this.requireLoaded();
        return this.mMia;
    }

    public void setMia(String mia) {
        this.mMia = mia;
    }

    public Date getMiabeg() {
        this.requireLoaded();
        return this.mMiabeg;
    }

    public void setMiabeg(Date miabeg) {
        this.mMiabeg = miabeg;
    }

    public Date getMiaend() {
        this.requireLoaded();
        return this.mMiaend;
    }

    public void setMiaend(Date miaend) {
        this.mMiaend = miaend;
    }

    public GrundFiktivBruttoEnum getFibgr() {
        this.requireLoaded();
        return this.mFibgr;
    }

    public void setFibgr(GrundFiktivBruttoEnum fibgr) {
        this.mFibgr = fibgr;
    }

    public BeaDben createNew(BeaDsab dsab) {
        this.requireLoaded();
        BeaDben bo = dsab.createDben();
        bo.setMonatbeg(this.mMonatbeg);
        bo.setMonatend(this.mMonatend);
        bo.setKennzrk(this.mKennzrk);
        bo.setSvbreglf(this.mSvbreglf);
        bo.setSvbrege(this.mSvbrege);
        bo.setFibr(this.mFibr);
        bo.setMia(this.mMia);
        bo.setMiabeg(this.mMiabeg);
        bo.setMiaend(this.mMiaend);
        bo.setFibgr(this.mFibgr);
        return bo;
    }

    public void init() {
        this.mMonatbeg = null;
        this.mMonatend = null;
        this.mKennzrk = "";
        this.mSvbreglf = BigDecimal.ZERO;
        this.mSvbrege = BigDecimal.ZERO;
        this.mFibr = BigDecimal.ZERO;
        this.mMia = "N";
        this.mMiabeg = null;
        this.mMiaend = null;
        this.mFibgr = GrundFiktivBruttoEnum.KEIN;
    }

    public String toString() {
        return "BeaDben [ , mMonatbeg = " + this.mMonatbeg + ", mMonatend = " + this.mMonatend + ", mKennzrk = " + this.mKennzrk + ", mSvbreglf = " + this.mSvbreglf + ", mSvbrege = " + this.mSvbrege + ", mFibr = " + this.mFibr + ", mMia = " + this.mMia + ", mMiabeg = " + this.mMiabeg + ", mMiaend = " + this.mMiaend + ", mFibgr = " + this.mFibgr + "]";
    }

    public String getMonatbegR() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getMonatbeg());
    }

    public String getMonatendR() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getMonatend());
    }

    public String getMiabegR() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getMiabeg());
    }

    public String getMiaendR() {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)this.getMiaend());
    }

    public String getSvbreglfR() {
        return BigDecimalMapper.toString((BigDecimal)this.getSvbreglf());
    }

    public String getSvbregeR() {
        return BigDecimalMapper.toString((BigDecimal)this.getSvbrege());
    }

    public String getFibrR() {
        return BigDecimalMapper.toString((BigDecimal)this.getFibr());
    }

    public List<String> checkAttributes(List<Date> dateWithReason04and09, Date end) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (DateHelper.afterOrEqual((Date)new Date(), (Date)PDateHelper.toDate((LocalDate)LocalDate.of(2025, Month.JANUARY, 1))) && DateHelper.afterOrEqual((Date)this.getMonatbeg(), (Date)PDateHelper.toDate((LocalDate)LocalDate.of(2025, Month.JANUARY, 1)))) {
            this.setKennzrk("");
        } else if (StringMapper.isNullString((String)this.getKennzrk())) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(157));
        }
        if (this.getMonatbeg() == null || this.getMonatend() == null) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(158));
        }
        for (Date date : dateWithReason04and09) {
            if (!DateHelper.between((Date)date, (Date)this.mMonatbeg, (Date)this.mMonatend) || StringMapper.equal((String)this.mMia, (String)"J") && this.mMiabeg != null && this.mMiaend != null) continue;
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(9));
        }
        if (!StringMapper.equal((String)this.mMia, (String)"J") && !StringMapper.equal((String)this.mMia, (String)"N")) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(211));
        }
        if (StringMapper.equal((String)this.mMia, (String)"N") && (this.mMiabeg != null || this.mMiaend != null)) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(187));
        }
        if (StringMapper.equal((String)this.mMia, (String)"J") && this.mMiabeg == null) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(181));
        }
        if (this.mMiabeg != null && this.mMiaend == null || this.mMiabeg == null && this.mMiaend != null) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(182));
        }
        if (!(this.mMiabeg == null || this.mMiaend == null || this.mMonatbeg == null || this.mMonatend == null || DateHelper.between((Date)this.mMiabeg, (Date)this.mMonatbeg, (Date)this.mMonatend) && DateHelper.between((Date)this.mMiaend, (Date)this.mMonatbeg, (Date)this.mMonatend))) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(183));
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.getFibr()) && GrundFiktivBruttoEnum.KEIN.equals((Object)this.getFibgr())) {
            errorList.add(BeaExceptionMapper.mErrorList.getDefaultString(10));
        }
        return errorList;
    }

    public String getFibgrR() {
        return this.getFibgr().toString();
    }
}

