/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.rvbea.response;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.companyplant.TypeOfBusinessEnum;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccountPersistencyManager;
import com.varial.personnel.domain.deuv.deuvaccount.adviceable.ValueInterval;
import com.varial.personnel.domain.deuv.deuvaccount.mapper.DEUVAccountExceptionMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.rvbea.dxar.RvbeaDxar;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class RvbeaObstacles {
    private static int REASON_11 = 11;
    private static int REASON_13 = 13;
    private static int REASON_14 = 14;
    private static int REASON_15 = 15;
    private static int REASON_16 = 16;
    private static int REASON_18 = 18;

    private RvbeaObstacles() {
    }

    public static final int getObstacle(Employee employee, Date month) throws BusinessDomainException {
        if (RvbeaObstacles.isCompanyInactiv(employee.getPCompany(), DateHelper.getFirstDayOfMonth((Date)month), DateHelper.getLastDayOfMonth((Date)month))) {
            return REASON_18;
        }
        if (BigDecimalMapper.isZero((BigDecimal)RvbeaObstacles.calculatePayment(employee, DateHelper.getFirstDayOfMonth((Date)month), DateHelper.getLastDayOfMonth((Date)month)))) {
            return REASON_15;
        }
        return 0;
    }

    public static final int getObstacle(RvbeaDxar dxar) throws BusinessDomainException {
        Employee employee = dxar.getEmployee();
        boolean isGML57 = "GML57".equals(dxar.getAnfgr());
        if (employee == null) {
            Date withdrawal;
            Employee each;
            List employees = Deuv.getEmployeesByVsnr((String)dxar.getVsnr());
            if (employees.isEmpty()) {
                return REASON_11;
            }
            Iterator iterator = employees.iterator();
            while (iterator.hasNext() && (!RvbeaObstacles.isInEmployment(each = (Employee)iterator.next(), RvbeaObstacles.getStartMonth(dxar), RvbeaObstacles.getEndMonth(dxar)) || (withdrawal = (employee = each).getLastDateOfWithdrawal()) != null && !DateHelper.afterOrEqual((Date)withdrawal, (Date)RvbeaObstacles.getLastDayEndMonth(dxar)))) {
            }
            if (employee == null) {
                return isGML57 ? REASON_14 : REASON_15;
            }
            dxar.setEmployee(employee);
        }
        if (RvbeaObstacles.isCompanyInactiv(employee.getPCompany(), RvbeaObstacles.getFirstDayStartMonth(dxar), RvbeaObstacles.getLastDayEndMonth(dxar))) {
            return REASON_18;
        }
        if (isGML57) {
            for (DEUVAccount each : RvbeaObstacles.getReason57Accounts(employee, RvbeaObstacles.getFirstDayStartMonth(dxar))) {
                if (!DateHelper.afterOrEqual((Date)each.getValidUntil(), (Date)RvbeaObstacles.getLastDayEndMonth(dxar))) continue;
                return REASON_13;
            }
            if (RvbeaObstacles.allPeriodsUntilWithdrawalTransmitted(employee)) {
                return REASON_14;
            }
        }
        if (BigDecimalMapper.isZero((BigDecimal)RvbeaObstacles.calculatePayment(employee, RvbeaObstacles.getFirstDayStartMonth(dxar), RvbeaObstacles.getLastDayEndMonth(dxar)))) {
            return REASON_15;
        }
        if (isGML57) {
            for (DEUVAccount each : RvbeaObstacles.getDeuvAccounts(employee, RvbeaObstacles.getFirstDayStartMonth(dxar))) {
                if (!DateHelper.afterOrEqual((Date)each.getValidDate(), (Date)RvbeaObstacles.getLastDayEndMonth(dxar))) continue;
                return REASON_16;
            }
        }
        return 0;
    }

    private static boolean isInEmployment(Employee employee, Date validFrom, Date validUntil) {
        Date current = validFrom;
        while (DateHelper.beforeOrEqual((Date)current, (Date)validUntil)) {
            if (employee.isMonthOfEmployment(current, VDate.getDateMax())) {
                return true;
            }
            current = PDateHelper.getFirstDayNextMonth((Date)current);
        }
        return false;
    }

    private static DEUVAccount[] getReason57Accounts(Employee employee, Date minValidFrom) {
        Criterion filter = Restrictions.and((Criterion)RvbeaObstacles.getDeuvAccountFilter(employee, minValidFrom), (Criterion)Restrictions.eq((String)DEUVAccountPersistencyManager.LONGREASONOFDELIV, (String)"57.01"));
        return DEUVAccountPersistencyManager.query(null, (Criterion)filter);
    }

    private static DEUVAccount[] getDeuvAccounts(Employee employee, Date minValidFrom) {
        return DEUVAccountPersistencyManager.query(null, (Criterion)RvbeaObstacles.getDeuvAccountFilter(employee, minValidFrom));
    }

    private static Criterion getDeuvAccountFilter(Employee employee, Date minValidFrom) {
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.OIDEMPLOYEE, (String)employee.getObjectid()), DEUVAccount.getFilterForDsme(), Restrictions.le((String)DEUVAccountPersistencyManager.VALIDFROM, (String)DateMapper.toString((Date)minValidFrom)), Restrictions.eq((String)DEUVAccountPersistencyManager.CANCELED, (String)"N"), Restrictions.eq((String)DEUVAccountPersistencyManager.TRANSMITTED, (String)"T")});
    }

    private static boolean allPeriodsUntilWithdrawalTransmitted(Employee employee) {
        Date lastwithdrawal = employee.getLastDateOfWithdrawal();
        if (lastwithdrawal != null) {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)DEUVAccountPersistencyManager.OIDEMPLOYEE, (String)employee.getObjectid()), Restrictions.eq((String)DEUVAccountPersistencyManager.CANCELED, (String)"N"), Restrictions.eq((String)DEUVAccountPersistencyManager.TRANSMITTED, (String)"T"), DEUVAccount.getFilterForDsme(), Restrictions.ge((String)DEUVAccountPersistencyManager.VALIDUNTIL, (String)DateMapper.toString((Date)lastwithdrawal))});
            for (DEUVAccount each : DEUVAccountPersistencyManager.query(null, (Criterion)filter)) {
                if (!DateHelper.afterOrEqual((Date)each.getValidDate(), (Date)lastwithdrawal)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCompanyInactiv(PCompany pCompany, Date validFrom, Date valiUntil) throws BusinessDomainException {
        CompanyFoundations foundations = pCompany.getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax());
        boolean result = false;
        if (DateHelper.after((Date)foundations.getCalculationStart(), (Date)valiUntil)) {
            result = true;
        } else if (foundations.getFoundations().getTypeOfBusiness() == TypeOfBusinessEnum.TYBE_BETRIEBSAUFGABE && DateHelper.before((Date)DateHelper.yesterday((Date)foundations.getValidFrom()), (Date)validFrom)) {
            result = true;
        } else if (foundations.getFoundations().getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_INSOLVENT && DateHelper.before((Date)DateHelper.yesterday((Date)foundations.getFoundations().getInsolventlyFrom()), (Date)validFrom)) {
            result = true;
        }
        return result;
    }

    private static BigDecimal calculatePayment(Employee employee, Date start, Date end) throws BusinessDomainException {
        ValueType vt = RvbeaObstacles.getValueType(130510);
        Criterion filter = ValueInterval.createValuePositionFilter((Employee)employee, (Date)VDate.getDateMax(), (ValueType)vt);
        ValueInterval vi = new ValueInterval(filter);
        return vi.calculate(start, end);
    }

    private static ValueType getValueType(int number) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)number);
        if (vt == null) {
            throw DEUVAccountExceptionMapper.makeMissValueTypeDomainException((int)number);
        }
        return vt;
    }

    private static Date getStartMonth(RvbeaDxar dxar) {
        return PDateHelper.toDate((LocalDate)LocalDate.of(dxar.getEbjahrvon(), dxar.getEbmonatvon(), 1).with(TemporalAdjusters.lastDayOfMonth()));
    }

    private static Date getFirstDayStartMonth(RvbeaDxar dxar) {
        return PDateHelper.toDate((LocalDate)LocalDate.of(dxar.getEbjahrvon(), dxar.getEbmonatvon(), 1));
    }

    private static Date getEndMonth(RvbeaDxar dxar) {
        return PDateHelper.toDate((LocalDate)LocalDate.of(dxar.getEbjahrbis(), dxar.getEbmonatbis(), 1));
    }

    private static Date getLastDayEndMonth(RvbeaDxar dxar) {
        return PDateHelper.toDate((LocalDate)LocalDate.of(dxar.getEbjahrbis(), dxar.getEbmonatbis(), 1).with(TemporalAdjusters.lastDayOfMonth()));
    }
}

