/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eau;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.DeuvBasicComponents;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.basictypes.ContactPerson;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.eau.EauComponents;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eauaccount.EauAdviceStateEnum;
import com.varial.personnel.domain.eau.eaudxag.EauDxag;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.rvbea.transfer.BasicRvbeaTransfer;
import com.varial.personnel.framework.PFileHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class EauTransfer
extends BasicRvbeaTransfer<EauAccount> {
    private static String FEATURE = "EAA";
    private static final String VERSION = "020000";
    private final List<EauAccount> mTransmitted = new ArrayList<EauAccount>();

    protected String getFileHeader() throws BusinessDomainException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getContentVosx()).append("\r\n");
        builder.append(this.getContentDxko()).append("\r\n");
        return builder.toString();
    }

    protected String getContentVosx() throws BusinessDomainException {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"VOSX", (int)4);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)VERSION, (int)6);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getFeature(), (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getSenderStdCompNo(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getRecipientStdCompNo(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)this.getCreatedOnString(), (int)20);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)this.getFileNumber(), (int)6);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        return builder.toString();
    }

    protected String getContentDxko() throws BusinessDomainException {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DXKO", (int)4);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)VERSION, (int)6);
        DeuvBasicComponents.append((StringBuilder)builder, (String)DeuvBasics.getProdId(), (int)7);
        DeuvBasicComponents.append((StringBuilder)builder, (String)DeuvBasics.getModId(), (int)8);
        String[] names = this.getSenderNameLong().split("\\r\\n?|\\n");
        DeuvBasicComponents.append((StringBuilder)builder, (String)names[0], (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(names.length > 1 ? names[1] : ""), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(names.length > 2 ? names[2] : ""), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getSenderPostalcode(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getSenderCity(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getSenderStreet(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)9);
        DeuvBasicComponents.append((StringBuilder)builder, (String)(this.getPersonSex() != null ? this.getPersonSex().toLowerCase() : "x"), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getPersonName(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getPersonTel(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getPersonFax(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)this.getPersonEmail(), (int)70);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        return builder.toString();
    }

    public EauTransfer(DEUVSenderTP deuvSenderTP, DEUVRecipientTP recipientTP, PCompany pCompany, List<EauAccount> dataSets) {
        super(deuvSenderTP, recipientTP, pCompany, dataSets);
    }

    public void createTransferFile(List<EauAccount> dataSets) throws BusinessDomainException {
        this.setDataSets(dataSets);
        this.createTransferFile();
    }

    public void createTransferFile() throws BusinessDomainException {
        this.removeInvalid();
        if (this.mDataSets.isEmpty()) {
            return;
        }
        this.mDeuvRecipientTP.setFileNumberEAU(this.mDeuvRecipientTP.getFileNumberEAU() + 1);
        this.mDeuvRecipientTP.makeSaveable();
        this.mCurrentPerfidiaFile = PerfidiaHelper.createPerfidiaFile((DEUVSender)this.mDeuvSenderTP.getDEUVSender(), (DEUVRecipient)this.mDeuvRecipientTP.getDEUVRecipient(), (String)FEATURE, (int)this.mDeuvRecipientTP.getFileNumberEAU());
        BufferedWriter writer = null;
        try {
            writer = this.mPerfidiaResult.initPerfidiaFile(this.mCurrentPerfidiaFile);
            writer.append(this.getFileHeader());
            for (EauAccount account : this.mDataSets) {
                account.setAdviceState(EauAdviceStateEnum.UEBERMITTELT);
                account.setCurrentFileNumber(this.mDeuvRecipientTP.getFileNumberEAU());
                account.makeSaveable();
                EauDxag dxag = account.getEauDxag();
                dxag.makeSaveable();
                writer.append(EauComponents.getContentDxag((EauDxag)dxag));
                writer.append(EauTransfer.getLineSeparator());
                this.mTransmitted.add(account);
            }
            writer.append(this.getContentNcsx()).append(EauTransfer.getLineSeparator());
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                PFileHelper.close(writer);
                throw throwable;
            }
        }
        PFileHelper.close((Closeable)writer);
    }

    private void removeInvalid() {
        ArrayList<EauAccount> invalids = new ArrayList<EauAccount>();
        for (EauAccount account : this.mDataSets) {
            if (StringMapper.isNullString((String)account.getErrorMessage())) continue;
            invalids.add(account);
        }
        this.mDataSets.removeAll(invalids);
    }

    protected String getFeature() {
        return FEATURE;
    }

    public int getFileNumber() {
        return this.mDeuvRecipientTP.getFileNumberEAU();
    }

    protected DeuvHelper.TypeOfCommunication getTypeOfCommunication() {
        return DeuvHelper.TypeOfCommunication.EAU;
    }

    public List<EauAccount> getTransmitteds() {
        return this.mTransmitted;
    }

    protected ContactPerson getContactPerson() throws BusinessDomainException {
        if (this.mContactPerson == null) {
            this.mContactPerson = DeuvHelper.getCommunication((DEUVSenderTP)this.mDeuvSenderTP, (DeuvHelper.TypeOfCommunication)this.getTypeOfCommunication());
        }
        return this.mContactPerson;
    }
}

