/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.servantimpl.reports.wagetax;

import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.framework.basictypes.ReportExportFormatEnum;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.attributive.AttributiveCompany;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.mapper.PaymentExceptionMapper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.reportdatatransfer.mapper.ReportDataTransferExceptionMapper;
import com.varial.personnel.domain.reports.wagetax.RetroActiveTreatmentEnum;
import com.varial.personnel.domain.reports.wagetax.WageTaxReport;
import com.varial.personnel.framework.access.PersonnelRightList;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.checkup.NameOfPayment;
import com.varial.personnel.servantimpl.employee.SpecialAccessServantBase;
import com.varial.personnel.servantimpl.reports.wagetax.WageTaxServantService;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;

public class WageTaxServantImpl
extends SpecialAccessServantBase
implements WageTaxServantService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printWageTaxFirst(AuthorizationToken token, ReportFirstFilterStruct filter, ReportSortStruct[] sorts, String oidPCompany, String name, String forEffectiveDate, String forValidDate, String password, boolean payment, boolean internalUse, boolean dataTransfer, boolean cancelationCollectionOrder, boolean computationAmountRefunded, RetroActiveTreatmentEnum retroActiveType, ReportFileStructCallback callback, ReportExportFormatEnum format, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            TransactionMode transactionMode;
            if (DateMapper.toDate((String)forEffectiveDate) == null) {
                forEffectiveDate = forValidDate;
            }
            if (dataTransfer || payment) {
                this.beginUpdateService();
                transactionMode = TransactionMode.UPDATE;
            } else {
                this.beginQueryService();
                transactionMode = TransactionMode.READONLY;
            }
            if (DateMapper.toDate((String)forValidDate) == null) {
                throw ReportExceptionMapper.makeValidTimepointIsEmptyDomainException("printWageTaxFirst");
            }
            PCompany pCompany = this.getPCompany(filter.oidPCompany);
            token.checkAccess(PersonnelRightList.getPrintWageTaxRight(), pCompany.getObjectid());
            this.setTokenForSpecialAccess(token);
            if (payment && dataTransfer) {
                throw ReportDataTransferExceptionMapper.makeNoSameUseOfDataTransferAndPayment();
            }
            if (payment && internalUse) {
                throw PaymentExceptionMapper.makeNoSameUseOfInternalUseAndPayment();
            }
            if (payment) {
                if (pCompany.getIsMultiple()) {
                    AttributiveCompany[] attributiveCompanys;
                    for (AttributiveCompany each : attributiveCompanys = pCompany.getAttributiveCompany()) {
                        new NameOfPayment(name, each.getAttributiveCompany()).checkNameOfPayment();
                    }
                } else {
                    new NameOfPayment(name, pCompany).checkNameOfPayment();
                }
                if (PDateHelper.getDiffInMonths((Date)DateMapper.toDate((String)forEffectiveDate), (Date)DateMapper.toDate((String)forValidDate)) != 0) {
                    throw ReportExceptionMapper.makeNoDateEqualForPaidReport();
                }
            }
            WageTaxReport command = new WageTaxReport(token, callback, transactionMode, filter, sorts, DateMapper.toDate((String)forEffectiveDate), DateMapper.toDate((String)forValidDate), name, password, payment, dataTransfer, internalUse, cancelationCollectionOrder, computationAmountRefunded, retroActiveType, format);
            lazyHolder.setLowPriorityRunnable((Runnable)((Object)command));
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printWageTaxSecond(AuthorizationToken token, ReportSecondFilterStruct[] filters, ReportSortStruct[] sorts, String forEffectiveDate, String forValidDate, String password, boolean internalUse, boolean dataTransfer, boolean cancelationCollectionOrder, boolean computationAmountRefunded, RetroActiveTreatmentEnum retroActiveType, ReportFileStructCallback callback, ReportExportFormatEnum format, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            TransactionMode transactionMode;
            if (dataTransfer) {
                this.beginUpdateService();
                transactionMode = TransactionMode.UPDATE;
            } else {
                this.beginQueryService();
                transactionMode = TransactionMode.READONLY;
            }
            PCompany pCompany = this.getPCompany(filters[0].oidPCompany);
            token.checkAccess(PersonnelRightList.getPrintWageTaxRight(), pCompany.getObjectid());
            this.setTokenForSpecialAccess(token);
            if (DateMapper.toDate((String)forValidDate) == null) {
                throw ReportExceptionMapper.makeValidTimepointIsEmptyDomainException("printWageTaxSecond");
            }
            if (DateMapper.toDate((String)forEffectiveDate) == null) {
                forEffectiveDate = forValidDate;
            }
            if (!internalUse && filters.length > 0) {
                throw ReportExceptionMapper.makeNoUseSecondReportFilterSelection();
            }
            WageTaxReport command = new WageTaxReport(token, callback, transactionMode, filters, sorts, DateMapper.toDate((String)forEffectiveDate), DateMapper.toDate((String)forValidDate), password, dataTransfer, internalUse, cancelationCollectionOrder, computationAmountRefunded, retroActiveType, format);
            lazyHolder.setLowPriorityRunnable((Runnable)((Object)command));
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printWageTaxThird(AuthorizationToken token, ReportThirdFilterStruct filter, ReportSortStruct[] sorts, String forEffectiveDate, String forValidDate, String password, boolean internalUse, boolean dataTransfer, boolean cancelationCollectionOrder, boolean computationAmountRefunded, RetroActiveTreatmentEnum retroActiveType, ReportFileStructCallback callback, ReportExportFormatEnum format, LazyRunnableHolder lazyHolder) throws BusinessDomainException {
        try {
            TransactionMode transactionMode;
            if (dataTransfer) {
                this.beginUpdateService();
                transactionMode = TransactionMode.UPDATE;
            } else {
                this.beginQueryService();
                transactionMode = TransactionMode.READONLY;
            }
            PCompany pCompany = this.getPCompany(filter.oidPCompany);
            token.checkAccess(PersonnelRightList.getPrintWageTaxRight(), pCompany.getObjectid());
            this.setTokenForSpecialAccess(token);
            WageTaxReport command = new WageTaxReport(token, callback, transactionMode, filter, sorts, DateMapper.toDate((String)forEffectiveDate), DateMapper.toDate((String)forValidDate), password, dataTransfer, internalUse, cancelationCollectionOrder, computationAmountRefunded, retroActiveType, format);
            lazyHolder.setLowPriorityRunnable((Runnable)((Object)command));
            return;
        }
        finally {
            this.endService();
        }
    }

    private PCompany getPCompany(String oidPCompany) {
        PCompany pCompany = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
        if (pCompany.getIsSuperiorForConsolidation()) {
            pCompany = pCompany.getSuperiorCompanyForConsolidation();
        }
        return pCompany;
    }
}

