/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.servantimpl.employee.eeskill;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.idl.SortierungStructMapper;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.eeskill.EESkill;
import com.varial.personnel.domain.employee.eeskill.EESkillFilterStruct;
import com.varial.personnel.domain.employee.eeskill.EESkillStruct;
import com.varial.personnel.domain.employee.eeskill.EESkillStructCallback;
import com.varial.personnel.domain.employee.eeskill.EESkillTP;
import com.varial.personnel.domain.employee.eeskill.IEESkillPersistencyManager;
import com.varial.personnel.domain.employee.eeskill.IEESkillTPPersistencyManager;
import com.varial.personnel.domain.employee.eeskill.mapper.EESkillFilterStructMapper;
import com.varial.personnel.domain.employee.eeskill.mapper.IEESkillMapper;
import com.varial.personnel.domain.employee.eeskill.mapper.IEESkillTPMapper;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.access.PersonnelRightList;
import com.varial.personnel.servantimpl.employee.SpecialAccessServantBase;
import com.varial.personnel.servantimpl.employee.eeskill.EESkillQueryCommand;
import com.varial.personnel.servantimpl.employee.eeskill.EESkillServantService;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.query.SortierungElementStruct;
import com.varial.serverbase.query.SortierungStruct;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EESkillServantImpl
extends SpecialAccessServantBase
implements EESkillServantService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct createEESkill(AuthorizationToken token, EESkillStruct struct) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEESkillRight(), struct.root.ee.oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            Employee ee = this.getIEmployeePM().getEmployee(struct.root.ee.oidTs.objectid);
            EESkill eeSkill = this.getIEESkillPM().createEESkill(ee);
            this.getIEESkillMapper().fillEESkill(eeSkill, struct);
            EESkillTP eeSkillTP = this.getIEESkillTPPM().createEESkillTP(eeSkill);
            this.getIEESkillTPMapper().fillEESkillTP(eeSkillTP, struct.history);
            eeSkill.addHistory(eeSkillTP, true);
            this.getContext().flush();
            EESkillStruct eESkillStruct = this.getIEESkillMapper().map(eeSkill.getActiveEESkillTP());
            return eESkillStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct[] getAllEESkillHistory(AuthorizationToken token, String oidEESkill) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            EESkill eeSkill = this.getIEESkillPM().getEESkill(oidEESkill);
            token.checkAccess(PersonnelRightList.getReadEESkillRight(), eeSkill.getEmployee().getPCompany().getObjectid());
            EESkillStruct[] eESkillStructArray = this.getIEESkillMapper().map(eeSkill.getSpecialHistory());
            return eESkillStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct setEESkill(AuthorizationToken token, EESkillStruct struct, boolean removeNew) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEESkillRight(), struct.root.ee.oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EESkill eeSkill = this.getIEESkillPM().getEESkill(struct.root.oidTs.objectid);
            this.getIEESkillMapper().fillEESkill(eeSkill, struct);
            EESkillTP eeSkillTP = this.getIEESkillTPPM().createEESkillTP(struct.history.oidTs.objectid, struct.history.oidTs.version, eeSkill);
            this.getIEESkillTPMapper().fillEESkillTP(eeSkillTP, struct.history);
            eeSkill.setHistory(eeSkillTP, false, DateMapper.toDate((String)struct.history.timePeriod.effectiveFrom));
            this.getContext().flush();
            EESkillStruct eESkillStruct = this.getIEESkillMapper().map(eeSkill.getActiveEESkillTP());
            return eESkillStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct getObjectFromObjectId(AuthorizationToken token, String oidEESkill, String effectiveTimePoint, String validTimePoint) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            EESkill eeSkill = this.getIEESkillPM().getEESkill(oidEESkill);
            EESkillStruct eESkillStruct = this.getIEESkillMapper().map(eeSkill.getObjectFromObjectId(DateMapper.toDate((String)effectiveTimePoint), DateMapper.toDate((String)validTimePoint)));
            return eESkillStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getActiveEESkillsCB(AuthorizationToken token, EESkillFilterStruct[] filter, SortierungStruct sortierung, EESkillStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            token.checkAccess(PersonnelRightList.getReadEESkillRight(), filter[0].oidPCompany);
            this.beginQueryService();
            if (sortierung.sortierungElements.length == 0) {
                sortierung = new SortierungStruct(new SortierungElementStruct[]{new SortierungElementStruct("personnelnumber", true)});
            }
            Junction filters = Restrictions.conjunction().add(EESkillFilterStructMapper.toFilter((EESkillFilterStruct[])filter)).add(Restrictions.sqlRestriction((String)"validuntil = ( select max(validuntil) from smeeskilltp_T A where A.oidsmeeskill = smeeskillall_v.oidsmeeskill and A.effectiveuntil  = ? )", (String)VDate.getDateMaxAsString()));
            int maxRows = 50;
            EESkillQueryCommand command = new EESkillQueryCommand(token, SortierungStructMapper.map((SortierungStruct)sortierung), (Criterion)filters, callback, 50);
            lazyRunnable.setStandardRunnable((Runnable)command);
            return;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct[] getEffectiveEESkillHistory(AuthorizationToken token, String oidEESkill, String destinationTimePoint) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            EESkill eeSkill = this.getIEESkillPM().getEESkill(oidEESkill);
            token.checkAccess(PersonnelRightList.getReadEESkillRight(), eeSkill.getEmployee().getPCompany().getObjectid());
            EESkillStruct[] eESkillStructArray = this.getIEESkillMapper().map(eeSkill.getEffectivEESkillTP(DateMapper.toDate((String)destinationTimePoint)));
            return eESkillStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct[] getActiveEESkills(AuthorizationToken token, EESkillFilterStruct[] filter, SortierungStruct sortierung) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            token.checkAccess(PersonnelRightList.getReadEESkillRight(), filter[0].oidPCompany);
            this.beginQueryService();
            EESkillTP[] actives = this.getIEESkillPM().getActiveEESkills(filter, SortierungStructMapper.map((SortierungStruct)sortierung));
            EESkillStruct[] eESkillStructArray = this.getIEESkillMapper().map((EESkillTP[])this.filterSpecialAccess((IEmployeeReferenced[])actives));
            return eESkillStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEESkill(AuthorizationToken token, String oidEmployee, String oidEESkill, int versionEESkill) throws BusinessDomainException {
        try {
            this.beginUpdateService();
            Employee ee = this.getIEmployeePM().getEmployee(oidEmployee);
            token.checkAccess(PersonnelRightList.getUpdateEESkillRight(), ee.getPCompany().getObjectid());
            this.setTokenForSpecialAccess(token);
            EESkill eeSkill = this.getIEESkillPM().createEESkill(oidEESkill, versionEESkill);
            eeSkill.setEmployee(ee);
            Date valuateEffectiveFrom = DateHelper.tomorrow((Date)ee.getJournalizedUntil());
            Date valuateValidFrom = DateHelper.getFirstDayOfMonth((Date)eeSkill.getActiveEffectiveEESkillHistory()[0].getValidFrom());
            valuateValidFrom = ee.checkAndCorrectValidFromStartOfValuate(valuateEffectiveFrom, valuateValidFrom);
            eeSkill.deleteEESkill();
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, ee, valuateEffectiveFrom, valuateValidFrom, eeSkill.getClass().getName());
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct[] getActiveEffectiveEESkillHistory(AuthorizationToken token, String oidEESkill) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            EESkill eeSkill = this.getIEESkillPM().getEESkill(oidEESkill);
            token.checkAccess(PersonnelRightList.getReadEESkillRight(), eeSkill.getEmployee().getPCompany().getObjectid());
            EESkillStruct[] eESkillStructArray = this.getIEESkillMapper().map(eeSkill.getActiveEffectiveEESkillHistory());
            return eESkillStructArray;
        }
        finally {
            this.endService();
        }
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private IEESkillPersistencyManager getIEESkillPM() {
        return (IEESkillPersistencyManager)UtilitiesManager.getBean((String)"eeSkillPersistencyManager", IEESkillPersistencyManager.class);
    }

    private IEESkillTPPersistencyManager getIEESkillTPPM() {
        return (IEESkillTPPersistencyManager)UtilitiesManager.getBean((String)"eeSkillTPPersistencyManager", IEESkillTPPersistencyManager.class);
    }

    private IEESkillMapper getIEESkillMapper() {
        return (IEESkillMapper)UtilitiesManager.getBean((String)"eeSkillIdlMapper", IEESkillMapper.class);
    }

    private IEESkillTPMapper getIEESkillTPMapper() {
        return (IEESkillTPMapper)UtilitiesManager.getBean((String)"eeSkillTPIdlMapper", IEESkillTPMapper.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct addEESkill(AuthorizationToken token, EESkillStruct struct, boolean removeNew) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateEESkillRight(), struct.root.ee.oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            EESkill eeSkill = this.getIEESkillPM().getEESkill(struct.root.oidTs.objectid);
            this.getIEESkillMapper().fillEESkill(eeSkill, struct);
            EESkillTP eeSkillTP = this.getIEESkillTPPM().createEESkillTP(struct.history.oidTs.objectid, struct.history.oidTs.version, eeSkill);
            this.getIEESkillTPMapper().fillEESkillTP(eeSkillTP, struct.history);
            eeSkill.addHistory(eeSkillTP, true);
            eeSkillTP.getEESkill().makeSaveable();
            this.getContext().flush();
            EESkillStruct eESkillStruct = this.getIEESkillMapper().map(eeSkill.getActiveEESkillTP());
            return eESkillStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EESkillStruct[] getSkillsForEmployeeCopy(AuthorizationToken token, String oidEmployee, String validFrom) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            Employee ee = this.getIEmployeePM().getEmployee(oidEmployee);
            token.checkAccess(PersonnelRightList.getReadEESkillRight(), ee.getPCompany().getObjectid());
            EESkill[] boArray = ee.getEESkills();
            ArrayList<EESkillTP> result = new ArrayList<EESkillTP>();
            for (EESkill element : boArray) {
                List tpArray = element.getHistory().getPeriods(VDate.getDateMax(), DateMapper.toDate((String)validFrom), VDate.getDateMax());
                for (EESkillTP element2 : tpArray) {
                    result.add(element2);
                }
            }
            EESkill[] eESkillArray = this.getIEESkillMapper().map(result.toArray(new EESkillTP[result.size()]));
            return eESkillArray;
        }
        finally {
            this.endService();
        }
    }
}

