/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.servantimpl.aeins;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.LazyRunnableHolder;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.personnel.domain.aeins.AEinsAccountStruct;
import com.varial.personnel.domain.aeins.AEinsAdvice;
import com.varial.personnel.domain.aeins.AEinsAdviceStruct;
import com.varial.personnel.domain.aeins.AEinsAdviceStructPackage.OptDxaa;
import com.varial.personnel.domain.aeins.AEinsAdviceStructPackage.OptDxab;
import com.varial.personnel.domain.aeins.AEinsDxa1Struct;
import com.varial.personnel.domain.aeins.AEinsDxagStruct;
import com.varial.personnel.domain.aeins.AEinsDxaoStruct;
import com.varial.personnel.domain.aeins.AEinsDxavStruct;
import com.varial.personnel.domain.aeins.AEinsExceptionMapper;
import com.varial.personnel.domain.aeins.AEinsKontaktSWStruct;
import com.varial.personnel.domain.aeins.AEinsPresetStruct;
import com.varial.personnel.domain.aeins.TypeOfRecordUnion;
import com.varial.personnel.domain.aeins.account.AEinsAccount;
import com.varial.personnel.domain.aeins.account.AEinsAdviceStateEnum;
import com.varial.personnel.domain.aeins.account.IAEinsAccountPersistencyManager;
import com.varial.personnel.domain.aeins.account.mapper.AEinsAccountMapper;
import com.varial.personnel.domain.aeins.anschrift.AEinsAnschrift;
import com.varial.personnel.domain.aeins.dxa1.AEinsDxa1;
import com.varial.personnel.domain.aeins.dxa1.mapper.AEinsDxa1Mapper;
import com.varial.personnel.domain.aeins.dxaa.AEinsDxaa;
import com.varial.personnel.domain.aeins.dxaa.mapper.AEinsDxaaMapper;
import com.varial.personnel.domain.aeins.dxab.AEinsDxab;
import com.varial.personnel.domain.aeins.dxab.mapper.AEinsDxabMapper;
import com.varial.personnel.domain.aeins.dxag.AEinsDxag;
import com.varial.personnel.domain.aeins.dxag.mapper.AEinsDxagMapper;
import com.varial.personnel.domain.aeins.dxao.AEinsDxao;
import com.varial.personnel.domain.aeins.dxao.mapper.AEinsDxaoMapper;
import com.varial.personnel.domain.aeins.dxav.AEinsDxav;
import com.varial.personnel.domain.aeins.dxav.mapper.AEinsDxavMapper;
import com.varial.personnel.domain.aeins.kontaktsw.AEinsKontaktSW;
import com.varial.personnel.domain.aeins.kontaktsw.mapper.AEinsKontaktSWMapper;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.reports.aeins.AEinsApplicationReceiptReport;
import com.varial.personnel.domain.reports.aeins.AEinsTransferProtocolReport;
import com.varial.personnel.domain.reports.aeins.receive.AEinsReceiveProtocolReport;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVCompanyStruct;
import com.varial.personnel.framework.access.PersonnelRightList;
import com.varial.personnel.servantimpl.aeins.AEinsServantService;
import com.varial.personnel.servantimpl.employee.SpecialAccessServantBase;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;

public class AEinsServantImpl
extends SpecialAccessServantBase
implements AEinsServantService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEinsAccountStruct setAEinsData(AuthorizationToken token, String oidPCompany, AEinsAccountStruct struct, AEinsAdviceStruct adviceStruct) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            AEinsAccount account = new AEinsAccount(struct.oidTs.objectid);
            if (AEinsAdviceStateEnum.UEBERMITTELT.equals((Object)account.getAdviceState()) || AEinsAdviceStateEnum.VERARBEITET.equals((Object)account.getAdviceState()) || AEinsAdviceStateEnum.BEWILLIGT.equals((Object)account.getAdviceState())) {
                throw AEinsExceptionMapper.makeEditNotAllowedException();
            }
            AEinsAccountMapper.fillAEinsAccount((AEinsAccount)account, (AEinsAccountStruct)struct);
            switch (adviceStruct.typeofrecord.discriminator().value()) {
                case 0: {
                    AEinsDxa1 dxa1 = new AEinsDxa1(account.getDxa1().getObjectid());
                    dxa1.makeSaveable();
                    this.removeChilds(dxa1, adviceStruct.typeofrecord.dxa1());
                    this.getContext().flush();
                    dxa1 = new AEinsDxa1(account.getDxa1().getObjectid());
                    dxa1.makeSaveable();
                    AEinsDxa1Mapper.fill((AEinsDxa1)dxa1, (AEinsDxa1Struct)adviceStruct.typeofrecord.dxa1());
                    dxa1.setDatensatzid(account.getObjectid());
                    account.setDxa1(dxa1);
                    account.setValidFrom(dxa1.getBeginnentsendung());
                    account.setValidUntil(dxa1.getEndeentsendung());
                    break;
                }
                case 1: {
                    AEinsDxav dxav = new AEinsDxav(account.getDxav().getObjectid());
                    dxav.makeSaveable();
                    this.removeChilds(dxav, adviceStruct.typeofrecord.dxav());
                    this.getContext().flush();
                    dxav = new AEinsDxav(account.getDxav().getObjectid());
                    dxav.makeSaveable();
                    AEinsDxavMapper.fill((AEinsDxav)dxav, (AEinsDxavStruct)adviceStruct.typeofrecord.dxav());
                    dxav.setDatensatzid(account.getObjectid());
                    account.setDxav(dxav);
                    account.setValidFrom(dxav.getBeginnantrag());
                    account.setValidUntil(dxav.getEndeantrag());
                    break;
                }
                case 2: {
                    AEinsDxao dxao = new AEinsDxao(account.getDxao().getObjectid());
                    dxao.makeSaveable();
                    this.removeChilds(dxao, adviceStruct.typeofrecord.dxao());
                    this.getContext().flush();
                    dxao = new AEinsDxao(account.getDxao().getObjectid());
                    dxao.makeSaveable();
                    AEinsDxaoMapper.fill((AEinsDxao)dxao, (AEinsDxaoStruct)adviceStruct.typeofrecord.dxao());
                    dxao.setDatensatzid(account.getObjectid());
                    account.setDxao(dxao);
                    account.setValidFrom(dxao.getBeginnentsendung());
                    account.setValidUntil(dxao.getEndeentsendung());
                    break;
                }
                case 3: {
                    AEinsDxag dxag = new AEinsDxag(account.getDxag().getObjectid());
                    dxag.makeSaveable();
                    this.removeChilds(dxag, adviceStruct.typeofrecord.dxag());
                    this.getContext().flush();
                    dxag = new AEinsDxag(account.getDxag().getObjectid());
                    dxag.makeSaveable();
                    AEinsDxagMapper.fill((AEinsDxag)dxag, (AEinsDxagStruct)adviceStruct.typeofrecord.dxag());
                    dxag.setDatensatzid(account.getObjectid());
                    account.setDxag(dxag);
                    account.setValidFrom(dxag.getBeginnentsendung());
                    account.setValidUntil(dxag.getEndeentsendung());
                }
            }
            AEinsAdvice advice = new AEinsAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany), account.getEmployee());
            account.setErrorMessage("");
            account.setAdviceState(AEinsAdviceStateEnum.AUFGEBAUT);
            advice.check(account);
            if (!account.hasErrors()) {
                account.setAdviceState(AEinsAdviceStateEnum.BEREIT);
            }
            account.makeSaveable();
            this.getContext().flush();
            AEinsAccountStruct aEinsAccountStruct = AEinsAccountMapper.toIdl((AEinsAccount)account);
            return aEinsAccountStruct;
        }
        finally {
            this.endService();
        }
    }

    private void removeChilds(AEinsDxa1 bo, AEinsDxa1Struct struct) throws BusinessDomainException {
        if (bo.getAEinsAnschrift().length != struct.anschriften.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsAnschrift()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (!struct.hasKontakt.discriminator()) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsKontakt()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsStelle().length != struct.stellen.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsStelle()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsEntsendung().length != struct.entsendungen.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsEntsendung()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (!struct.hasAbloesung.discriminator()) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsAbloesung()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (!struct.hasKontaktAG.discriminator()) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsKontaktAG()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsStelleschiff().length != struct.stellenschiff.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsStelleschiff()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
    }

    private void removeChilds(AEinsDxav bo, AEinsDxavStruct struct) throws BusinessDomainException {
        if (bo.getAEinsAnschrift().length != struct.anschriften.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsAnschrift()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (!struct.hasKontakt.discriminator()) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsKontakt()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsAusland().length != struct.auslandseinsaetze.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsAusland()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getEinsatzort().length != struct.stellen.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getEinsatzort()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsKontaktSW().length != struct.kontaktesw.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsKontaktSW()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
    }

    private void removeChilds(AEinsDxao bo, AEinsDxaoStruct struct) throws BusinessDomainException {
        if (bo.getAEinsAnschrift().length != struct.anschriften.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsAnschrift()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsStelle().length != struct.stellen.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsStelle()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (!struct.hasKontaktAG.discriminator()) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsKontaktAG()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
    }

    private void removeChilds(AEinsDxag bo, AEinsDxagStruct struct) throws BusinessDomainException {
        if (bo.getAEinsAnschrift().length != struct.anschriften.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsAnschrift()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsKontaktSW().length != struct.kontaktesw.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsKontaktSW()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (!struct.hasStelledeutsch.discriminator()) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsStelledeutsch()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
        if (bo.getAEinsStelle().length != struct.stellen.length) {
            for (AEinsAnschrift aEinsAnschrift : bo.getAEinsStelle()) {
                aEinsAnschrift.makeSaveable();
                aEinsAnschrift.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEinsAccountStruct[] getAEinsAccounts(AuthorizationToken token, String oidPCompany, String oidEmployee, String fromDate, String untilDate, int reasonOfDelivery, int adviceState, String oidPlant) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getReadAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            AEinsAccount[] accounts = AEinsAccount.getAEinsAccount((String)oidPCompany, (String)oidPlant, (String)oidEmployee, (Date)DateMapper.toDate((String)fromDate), (Date)DateMapper.toDate((String)untilDate), (int)reasonOfDelivery, (int)adviceState);
            AEinsAccountStruct[] aEinsAccountStructArray = AEinsAccountMapper.toIdl((AEinsAccount[])accounts);
            return aEinsAccountStructArray;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeAEinsDataTransfer(AuthorizationToken token, DEUVCompanyStruct[] companySeq, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeAEinsFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            AEinsTransferProtocolReport command = new AEinsTransferProtocolReport(token, callback, companySeq);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEinsAdviceStruct getSuggestionOfAEinsData(AuthorizationToken token, String oidPCompany, String oidEmployee, int reasonOfDelivery, AEinsPresetStruct preset) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            PCompany comp = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
            Employee emp = AEinsServantImpl.getIEmployeePM().getEmployee(oidEmployee);
            AEinsAdvice advice = new AEinsAdvice(comp, emp, reasonOfDelivery, preset);
            AEinsAdviceStruct aEinsAdviceStruct = advice.createSuggestion();
            return aEinsAdviceStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAEinsAccounts(AuthorizationToken token, String oidPCompany, AEinsAccountStruct[] accountSeq) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            AEinsAccount account = null;
            AEinsAdvice advice = null;
            for (AEinsAccountStruct aeinsAccount : accountSeq) {
                account = AEinsServantImpl.getIAEinsAccountPM().getAEinsAccount(aeinsAccount.oidTs.objectid);
                account.setEmployee(AEinsServantImpl.getIEmployeePM().getEmployee(aeinsAccount.oidEmployee));
                advice = new AEinsAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany));
                advice.deleteAccount(account);
            }
            this.getContext().flush();
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEinsAccountStruct createAEinsData(AuthorizationToken token, String oidPCompany, String oidEmployee, AEinsAdviceStruct struct) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            AEinsAdvice advice = new AEinsAdvice(PCompanyPersistencyManager.getPCompany((String)oidPCompany), AEinsServantImpl.getIEmployeePM().getEmployee(oidEmployee));
            AEinsAccount account = null;
            switch (struct.typeofrecord.discriminator().value()) {
                case 0: {
                    AEinsDxa1 dxa1 = new AEinsDxa1();
                    dxa1.createAEinsAn();
                    dxa1.createAEinsFirma();
                    AEinsDxa1Mapper.fill((AEinsDxa1)dxa1, (AEinsDxa1Struct)struct.typeofrecord.dxa1());
                    dxa1.makeSaveable();
                    account = advice.createAccount(dxa1);
                    dxa1.setAccount(account);
                    account.setDxa1(dxa1);
                    break;
                }
                case 1: {
                    AEinsDxav dxav = new AEinsDxav();
                    dxav.createAEinsAn();
                    dxav.createAEinsFirma();
                    AEinsDxavMapper.fill((AEinsDxav)dxav, (AEinsDxavStruct)struct.typeofrecord.dxav());
                    dxav.makeSaveable();
                    account = advice.createAccount(dxav);
                    dxav.setAccount(account);
                    account.setDxav(dxav);
                    break;
                }
                case 2: {
                    AEinsDxao dxao = new AEinsDxao();
                    dxao.createAEinsAn();
                    dxao.createAEinsFirma();
                    AEinsDxaoMapper.fill((AEinsDxao)dxao, (AEinsDxaoStruct)struct.typeofrecord.dxao());
                    dxao.makeSaveable();
                    account = advice.createAccount(dxao);
                    dxao.setAccount(account);
                    account.setDxao(dxao);
                    break;
                }
                case 3: {
                    AEinsDxag dxag = new AEinsDxag();
                    dxag.createAEinsAn();
                    dxag.createAEinsFirma();
                    AEinsDxagMapper.fill((AEinsDxag)dxag, (AEinsDxagStruct)struct.typeofrecord.dxag());
                    dxag.makeSaveable();
                    account = advice.createAccount(dxag);
                    dxag.setAccount(account);
                    account.setDxag(dxag);
                }
            }
            account.setAdviceState(AEinsAdviceStateEnum.AUFGEBAUT);
            advice.check(account);
            if (!account.hasErrors()) {
                account.setAdviceState(AEinsAdviceStateEnum.BEREIT);
            }
            account.makeSaveable();
            this.getContext().flush();
            AEinsAccountStruct aEinsAccountStruct = AEinsAccountMapper.toIdl(account);
            return aEinsAccountStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveAEinsDataTransfer(AuthorizationToken token, String oidDEUVSender, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getMakeAEinsFileTransfer());
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            this.removeDuplicateResponse();
            this.getContext().flush();
            AEinsReceiveProtocolReport command = new AEinsReceiveProtocolReport(token, callback, oidDEUVSender);
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    private void removeDuplicateResponse() throws BusinessDomainException {
        for (AEinsAccount each : AEinsAccount.getAEinsAccounts()) {
            AEinsDxab[] dxabs;
            AEinsDxaa[] dxaas = each.getDxaas();
            if (dxaas.length > 1) {
                for (int i = 1; i < dxaas.length; ++i) {
                    dxaas[i].makeSaveable();
                    dxaas[i].destroy();
                    dxaas[i].registerForFirstExecute();
                }
            }
            if ((dxabs = each.getDxabs()).length <= 1) continue;
            for (int i = 1; i < dxabs.length; ++i) {
                dxabs[i].makeSaveable();
                dxabs[i].destroy();
                dxabs[i].registerForFirstExecute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEinsAdviceStruct getAEinsAdvice(AuthorizationToken token, String oidAccount) throws BusinessDomainException {
        try {
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            AEinsAccount account = AEinsServantImpl.getIAEinsAccountPM().getAEinsAccount(oidAccount);
            TypeOfRecordUnion typeOfRecordUnion = new TypeOfRecordUnion();
            OptDxab optDxab = new OptDxab();
            OptDxaa optDxaa = new OptDxaa();
            if (account.getDxa1() != null) {
                typeOfRecordUnion.dxa1(AEinsDxa1Mapper.toIdl((AEinsDxa1)account.getDxa1()));
            } else if (account.getDxav() != null) {
                typeOfRecordUnion.dxav(AEinsDxavMapper.toIdl((AEinsDxav)account.getDxav()));
            } else if (account.getDxao() != null) {
                typeOfRecordUnion.dxao(AEinsDxaoMapper.toIdl((AEinsDxao)account.getDxao()));
            } else if (account.getDxag() != null) {
                typeOfRecordUnion.dxag(AEinsDxagMapper.toIdl((AEinsDxag)account.getDxag()));
            } else {
                throw new IllegalArgumentException("Missing DXA1, DXAV, DXAO and DXAG.");
            }
            if (account.getDxab() != null) {
                optDxab.dxab(AEinsDxabMapper.map((AEinsDxab)account.getDxab()));
            }
            if (account.getDxaa() != null) {
                optDxaa.dxaa(AEinsDxaaMapper.map((AEinsDxaa)account.getDxaa()));
            }
            AEinsAdviceStruct aEinsAdviceStruct = new AEinsAdviceStruct(typeOfRecordUnion, optDxab, optDxaa);
            return aEinsAdviceStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printApplicationReceipt(AuthorizationToken token, String oidPCompany, String oidAccount, ReportFileStructCallback callback, LazyRunnableHolder lazyRunnable) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getReadAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            AEinsApplicationReceiptReport command = new AEinsApplicationReceiptReport(token, callback, AEinsServantImpl.getIAEinsAccountPM().getAEinsAccount(oidAccount));
            lazyRunnable.setLowPriorityRunnable((Runnable)command);
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEinsAdviceStruct getCancellationAndSuggestionOfNew(AuthorizationToken token, String oidPCompany, AEinsAccountStruct struct) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginUpdateService();
            PCompany comp = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
            Employee emp = AEinsServantImpl.getIEmployeePM().getEmployee(struct.oidEmployee);
            AEinsAccount account = AEinsServantImpl.getIAEinsAccountPM().getAEinsAccount(struct.oidTs.objectid);
            if (account.getAdviceState().equals((Object)AEinsAdviceStateEnum.AUFGEBAUT) || account.getAdviceState().equals((Object)AEinsAdviceStateEnum.BEREIT)) {
                throw AEinsExceptionMapper.makeNoCancellationAllowedDomainException(account.getAktenzeichenVU() + " " + account.getValidFrom());
            }
            account.setEmployee(emp);
            AEinsAccount clone = account.createNew();
            String createdOnString = DeuvBasics.getCurrentDeuvDateString();
            switch (clone.getReason()) {
                case DXA1: {
                    AEinsDxa1 dxa1 = clone.getDxa1();
                    dxa1.setVorgangsid(account.getDxa1().getDatensatzid());
                    dxa1.setVersionsnummer("010500");
                    dxa1.setDatumerstellung(createdOnString);
                    break;
                }
                case DXAV: {
                    AEinsDxav dxav = clone.getDxav();
                    dxav.setVorgangsid(account.getDxav().getDatensatzid());
                    dxav.setVersionsnummer("010400");
                    dxav.setDatumerstellung(createdOnString);
                    break;
                }
                case DXAO: {
                    AEinsDxao dxao = clone.getDxao();
                    dxao.setVorgangsid(account.getDxao().getDatensatzid());
                    dxao.setVersionsnummer("010000");
                    dxao.setDatumerstellung(createdOnString);
                    break;
                }
                case DXAG: {
                    AEinsDxag dxag = clone.getDxag();
                    dxag.setVorgangsid(account.getDxag().getDatensatzid());
                    dxag.setVersionsnummer("010100");
                    dxag.setDatumerstellung(createdOnString);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The reason of delivery " + clone.getReason().ordinal() + " is not supported.");
                }
            }
            clone.makeReadOnly();
            AEinsAdvice advice = new AEinsAdvice(comp);
            advice.deleteAccount(account);
            this.getContext().flush();
            AEinsAdviceStruct aEinsAdviceStruct = advice.createSuggestion(clone);
            return aEinsAdviceStruct;
        }
        finally {
            this.endService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEinsKontaktSWStruct getContactPreset(AuthorizationToken token, String oidPCompany, String oidEmployee, String validTimePoint, int artanschriftwechsel) throws BusinessDomainException {
        try {
            token.checkAccess(PersonnelRightList.getUpdateAEinsAccount(), oidPCompany);
            this.setTokenForSpecialAccess(token);
            this.beginQueryService();
            PCompany comp = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
            Employee emp = AEinsServantImpl.getIEmployeePM().getEmployee(oidEmployee);
            AEinsAdvice advice = new AEinsAdvice(comp, emp);
            AEinsKontaktSWStruct aEinsKontaktSWStruct = AEinsKontaktSWMapper.map((AEinsKontaktSW)advice.getContactPreset(artanschriftwechsel, DateMapper.toDate((String)validTimePoint)));
            return aEinsKontaktSWStruct;
        }
        finally {
            this.endService();
        }
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private static IAEinsAccountPersistencyManager getIAEinsAccountPM() {
        return (IAEinsAccountPersistencyManager)UtilitiesManager.getBean((String)"aEinsAccountPersistencyManager", IAEinsAccountPersistencyManager.class);
    }
}

