/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.framework.checkup;

import de.werum.dguv.mgnr.plausi.PlausiFacade;
import de.werum.dguv.mgnr.plausi.PlausiResult;

public final class MembershipNumberOfAIF {
    private MembershipNumberOfAIF() {
    }

    public static String checkMembershipNumber(String stdCompanyNo, String membershipNumber) {
        PlausiFacade plausiFacade = PlausiFacade.getInstance();
        PlausiResult result = plausiFacade.doPlausi(2, stdCompanyNo, membershipNumber);
        if (result.getErrorStatus() <= 0) {
            return "";
        }
        return result.getErrorText();
    }

    public static String checkUNRS(String unrs) {
        int checkDigit;
        int i;
        if (!unrs.matches("\\d{15}")) {
            return "Die Unternehmensnummer muss 15stellig numerisch sein.";
        }
        char[] unrsChars = unrs.toCharArray();
        int sum = 0;
        for (i = 0; i < 11; i += 2) {
            sum += Character.getNumericValue(unrsChars[i]) * 4;
        }
        for (i = 1; i < 11; i += 2) {
            sum += Character.getNumericValue(unrsChars[i]) * 9;
        }
        int evaluated = 10 - sum % 10;
        if (evaluated == 10) {
            evaluated = 0;
        }
        if (evaluated != (checkDigit = Character.getNumericValue(unrsChars[11]))) {
            return "Die Pr\u00fcfziffer der Unternehmensnummer ist falsch";
        }
        return "";
    }
}

