/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.uv.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFund;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.uv.UvHelper;
import com.varial.personnel.domain.uv.dsas.UvDsas;
import com.varial.personnel.domain.uv.dsln.UvDsln;
import com.varial.personnel.domain.uv.dssd.UvDssd;
import com.varial.personnel.domain.uv.dssd.dbgt.UvDssdDbgt;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UvsddReceive
extends BasicReceive<UvDssd> {
    private static final String[] FILENAMEFILTER = new String[]{"EUVU0", "TUVU0"};
    private static final Pattern VOSZ_UV_AG = UvsddReceive.getVoszPattern((String)"UVTUN");
    private static final String V01 = "V01";
    private static final String V02 = "V02";
    private static final Pattern DSSD_V01 = Pattern.compile("DSSDUVSDD(?<ABSN>.{15})(?<EPNR>.{15})01.{2}.{2}(?<ED>\\d{20}).{100}(?<DSID>.{32})(?<VOID>.{32}).{100}(?<BBNRLB>.{15})(?<BBNRAS>.{15})(?<LFDNR>\\d{3})(?<BBNRUV>.{15})(?<MNR>.{20})(?<MNRGVON>\\d{8})(?<MNRGBIS>\\d{8})(?<JAHR>\\d{4}).{30}.{30}.{30}.{30}.{30}(?<BEITRAG>\\d{1})(?<ANZGTST>\\d{2})(?<REST>.*)");
    private static final Pattern DSSD_V02 = Pattern.compile("DSSDUVSDD(?<ABSN>.{15})(?<EPNR>.{15})02.{2}.{2}(?<ED>\\d{20}).{100}(?<DSID>.{32})(?<VOID>.{32}).{35}(?<ENDZUST>[JN]).{3}(?<UNRS>\\d{15})(?<UNRSVON>\\d{8})(?<UNRSBIS>\\d{8}).{30}(?<BBNRLB>.{15})(?<BBNRAS>.{15})(?<LFDNR>\\d{3})(?<BBNRUV>.{15})(?<MNR>.{20})(?<MNRGVON>\\d{8})(?<MNRGBIS>\\d{8})(?<JAHR>\\d{4}).{30}.{30}.{30}.{30}.{30}(?<BEITRAG>\\d{1})(?<ANZGTST>\\d{2})(?<REST>.*)");
    private static final int DSSD_LENGTH = 570;
    private static final Pattern GTST = Pattern.compile("(.{15})(.{8})(.{50})(\\d{8})(\\d{8})(.*)");
    private static final int GTST_LENGTH = 89;
    private final PersistencySession mSession;
    private UvDssd[] mReceiveds;
    private String mVersion;
    private final List<String> mFilesForReport = new ArrayList<String>();

    public UvsddReceive(DEUVSender deuvSender, PersistencySession session) {
        super(deuvSender);
        this.mSession = session;
    }

    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    public List<File> getFilesForProcessing() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_DGUV);
        return this.getFileList();
    }

    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile((File)file, (String)"R\u00fcckmeldung UV-Stammdatendienst");
        LinkedList records = PFileHelper.getFileLines((File)file, (String)ISO_8859_1);
        Matcher matcherVosz = VOSZ_UV_AG.matcher((CharSequence)records.getFirst());
        return matcherVosz.matches();
    }

    public String getProcedureName() {
        return "UV-Meldeverfahren (Stammdatendienst)";
    }

    public String getFileDescription() {
        return "Stammdatenr\u00fcckmeldungen(DSSD)";
    }

    public String getActionName() {
        return "importieren";
    }

    public void readUvDssds() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_DGUV);
        for (File file : this.getFileList()) {
            this.readUvDssdReceives(file);
        }
    }

    private void readUvDssdReceives(File input) throws BusinessDomainException {
        this.mCurrent = input;
        this.mReceiveds = null;
        LinkedList records = PFileHelper.getFileLines((File)input, (String)ISO_8859_1);
        Matcher matcherVosz = VOSZ_UV_AG.matcher((CharSequence)records.getFirst());
        if (matcherVosz.matches()) {
            records.pollFirst();
            records.pollLast();
            while (!records.isEmpty()) {
                this.readDssd((String)records.pollFirst());
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcherVosz);
        }
        int subFolderNr = PerfidiaHelper.getPerfidiaSubFolderNumber((DEUVSender)this.mDeuvSender, (TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_DGUV);
        this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.UVSDD, subFolderNr, Integer.parseInt(matcherVosz.group(1)));
        this.mPerfidiaResult.addReceivedFile(input);
        this.mFilesForReport.add(input.getAbsolutePath());
    }

    private void readDssd(String input) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 570, DSSD_V01, false);
        if (matcher == null) {
            matcher = this.checkInputGetMatcher(input, 570, DSSD_V02);
            this.mVersion = V02;
        } else {
            this.mVersion = V01;
        }
        UvDssd dssd = this.createUvDssd(matcher);
        for (UvDssd each : this.getReceiveds(dssd.getEd())) {
            if (!each.isEqual(dssd)) continue;
            if (this.isReplacePossible(each)) {
                each.makeSaveable();
                each.destroy();
                break;
            }
            dssd.makeReadOnly();
            dssd.setErrorMessage("Die R\u00fcckmeldung wurde bereits importiert und konnte nicht ersetzt werden, da bereits ein Lohnnachweis erstellt wurde.");
            break;
        }
        this.mImporteds.add(dssd);
        if (!dssd.hasErrors()) {
            this.updateData(dssd);
        }
        this.mSession.flush();
    }

    private boolean isReplacePossible(UvDssd exiting) throws BusinessDomainException {
        UvDsln[] dslns;
        boolean replacePossible = true;
        for (UvDsln dsln : dslns = UvHelper.getUvDslnPM().query(null, Restrictions.eq((String)"oiduvdssd", (String)exiting.getObjectid()), false)) {
            if (!dsln.getTransmitted() && dsln.hasError()) continue;
            replacePossible = false;
            break;
        }
        if (replacePossible) {
            for (UvDsln dsln : dslns) {
                dsln.destroy();
            }
        }
        return replacePossible;
    }

    private UvDssd createUvDssd(Matcher matcher) throws BusinessDomainException {
        UvDssd dssd = this.initUvDssd(matcher);
        String rest = matcher.group("REST");
        if (dssd.getAnzGtst() > 0) {
            this.initGTSTs(rest, dssd);
        }
        return dssd;
    }

    private UvDssd initUvDssd(Matcher matcher) {
        UvDssd dssd = new UvDssd();
        dssd.setBbnrab(this.asString(matcher.group("ABSN")));
        dssd.setBbnrep(this.asString(matcher.group("EPNR")));
        dssd.setEd(this.asString(matcher.group("ED")));
        dssd.setDatensatzId(this.asString(matcher.group("DSID")));
        dssd.setVorgangsId(this.asString(matcher.group("VOID")));
        dssd.setBbnrlb(this.asString(matcher.group("BBNRLB")));
        dssd.setBbnras(this.asString(matcher.group("BBNRAS")));
        dssd.setLfdNr(this.asInteger(matcher.group("LFDNR")));
        dssd.setBbnruv(this.asString(matcher.group("BBNRUV")));
        dssd.setMnr(this.asString(matcher.group("MNR")));
        dssd.setJahr(this.asInteger(matcher.group("JAHR")));
        dssd.setBeitragsmassstab(this.asInteger(matcher.group("BEITRAG")));
        dssd.setAnzGtst(this.asInteger(matcher.group("ANZGTST")));
        if (this.mVersion == V01) {
            dssd.setVersionsNr(1);
            dssd.setMnrgvon(PDateHelper.toDateYYYYMMDD((String)matcher.group("MNRGVON")));
            dssd.setMnrgbis(PDateHelper.toDateYYYYMMDD((String)matcher.group("MNRGBIS")));
        } else {
            dssd.setVersionsNr(2);
            dssd.setEndOfResponsibilty(this.asBoolean(matcher.group("ENDZUST")));
            dssd.setUnrs(this.asString(matcher.group("UNRS")));
            dssd.setMnrgvon(PDateHelper.toDateYYYYMMDD((String)matcher.group("UNRSVON")));
            dssd.setMnrgbis(PDateHelper.toDateYYYYMMDD((String)matcher.group("UNRSBIS")));
        }
        return dssd;
    }

    private void updateData(UvDssd dssd) throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"VORGANGSID", (String)dssd.getVorgangsId()), Restrictions.eq((String)"BBNRAS", (String)dssd.getBbnras()), Restrictions.eq((String)"BBNRLB", (String)dssd.getBbnrlb()), Restrictions.le((String)"ED", (String)dssd.getEd()), Restrictions.ne((String)"CANCELED", (String)"J"), Restrictions.ne((String)"CANCELED", (String)"S"), Restrictions.eq((String)"ISMASTER", (String)"T"), Restrictions.isNull((String)"ERRORMESSAGE")});
        UvDsas[] query = UvHelper.getUvDsasPM().query(new Order[]{Order.desc((String)"ED")}, (Criterion)filter, true);
        ArrayList<UvDsas> dsass = new ArrayList<UvDsas>();
        for (UvDsas master : query) {
            dsass.add(master);
            Conjunction dummyFilter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"VORGANGSID", (String)master.getVorgangsId()), Restrictions.eq((String)"ED", (String)master.getEd()), Restrictions.eq((String)"ISMASTER", (String)"F")});
            for (UvDsas dummy : UvHelper.getUvDsasPM().query(null, (Criterion)dummyFilter, true)) {
                dsass.add(dummy);
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        boolean updated = false;
        for (UvDsas dsas : dsass) {
            if ("N".equals(dsas.getCanceled())) {
                this.updateAssAif(dsas, dssd, errors);
                updated = true;
            }
            if (!dsas.isMaster() || dssd.getUvDsas() != null) continue;
            dssd.setUvDsas(dsas);
            dssd.setPCompany(dsas.getPCompany());
            dssd.setAccidentInsuranceFund(dsas.getAccidentInsuranceFund());
        }
        if (dsass.isEmpty()) {
            errors.add("Die zugeh\u00f6rige Abfrage wurde nicht gefunden");
            dssd.makeReadOnly();
        } else if (!updated) {
            errors.add("Die zugeh\u00f6rige Abfrage wurde bereits storniert");
        }
        dssd.setErrorMessage(DeuvHelper.getErrorMessage((String)dssd.getErrorMessage(), errors, (boolean)true));
    }

    private void updateAssAif(UvDsas dsas, UvDssd dssd, List<String> errors) throws BusinessDomainException {
        if (!dsas.getMnr().equals(dssd.getMnr())) {
            this.updateAssMembershipNumber(dsas, dssd);
        }
        boolean mnrFound = false;
        Date minValidUntil = DateHelper.max((Date)DeuvHelper.getCalculationStart((PCompany)dsas.getPCompany()), (Date)DateMapper.toDate((String)"2016-01-01"));
        for (AssignmentPCompanyAccidentInsuranceFundTP assAifTp : dsas.getAssignmentPCompanyAIF().getHistory().getAll()) {
            if (!DateHelper.afterOrEqual((Date)assAifTp.getValidUntil(), (Date)minValidUntil) || !dssd.getMnr().equals(assAifTp.getMembershipNumber()) || !dssd.getBbnrlb().equals(UvHelper.getBbnrLB((AssignmentPCompanyAccidentInsuranceFundTP)assAifTp, (Date)assAifTp.getValidUntil())) || !dssd.getBbnras().equals(UvHelper.getBbnrAS((AssignmentPCompanyAccidentInsuranceFundTP)assAifTp, (Date)assAifTp.getValidUntil()))) continue;
            if (assAifTp.getSerialNumber() == 0) {
                assAifTp.setSerialNumber(dssd.getLfdNr());
                assAifTp.makeSaveable();
            } else if (assAifTp.getSerialNumber() != dssd.getLfdNr()) {
                errors.add(this.getSerialNumberError(assAifTp));
            }
            if (DateHelper.afterOrEqual((Date)assAifTp.getValidUntil(), (Date)DateMapper.toDate((String)"2023-01-01"))) {
                if (StringMapper.isNullString((String)assAifTp.getUnrs())) {
                    if (assAifTp.isReadOnly()) {
                        assAifTp.makeSaveable();
                    }
                    assAifTp.setUnrs(dssd.getUnrs());
                } else if (!assAifTp.getUnrs().equals(dssd.getUnrs())) {
                    errors.add(this.getUnrsError());
                }
            }
            mnrFound = true;
        }
        if (!mnrFound) {
            errors.add(this.getMembershipNumberError());
        }
    }

    private void updateAssMembershipNumber(UvDsas dsas, UvDssd dssd) throws BusinessDomainException {
        if (dssd.getJahr() < 2017) {
            return;
        }
        for (AssignmentPCompanyAccidentInsuranceFundTP assAifTp : dsas.getAssignmentPCompanyAIF().getHistory().getAll()) {
            if (!assAifTp.getMembershipNumber().equals(dsas.getMnr())) continue;
            if (DateHelper.afterOrEqual((Date)assAifTp.getValidFrom(), (Date)dssd.getMnrgvon())) {
                assAifTp.setMembershipNumber(dssd.getMnr());
                assAifTp.makeSaveable();
                continue;
            }
            if (!VDate.isDateMax((Date)assAifTp.getValidUntil())) continue;
            assAifTp.setValidFrom(dssd.getMnrgvon());
            assAifTp.setMembershipNumber(dssd.getMnr());
            assAifTp.getAssignmentPCompanyAccidentInsuranceFund().clearHistory();
            assAifTp.getAssignmentPCompanyAccidentInsuranceFund().addHistory(assAifTp, true);
        }
    }

    private String getSerialNumberError(AssignmentPCompanyAccidentInsuranceFundTP assAifTp) throws BusinessDomainException {
        AssignmentPCompanyAccidentInsuranceFund assAif = assAifTp.getAssignmentPCompanyAccidentInsuranceFund();
        String error = "Die Zuordung Firmen - BG(" + assAif.getPCompany().getPCompanyKey();
        if (assAif.getPlant() != null) {
            error = error + "," + assAif.getPlant().getPlantKey();
        }
        String bbnruv = assAif.getAccidentInsuranceFund().getAccidentInsuranceFundTP(VDate.getDateMax(), VDate.getDateMax()).getStdCompanyNoOfAccIns();
        error = error + "," + bbnruv + "," + DateMapper.toDDMMYYYYPointSeparationString((Date)assAifTp.getValidFrom()) + ") enth\u00e4lt bereits die laufende Nummer: " + assAifTp.getSerialNumber();
        return error;
    }

    private String getMembershipNumberError() {
        return "Kein Zeitraum mit der zur\u00fcckgemeldeten Mitgliedsnummer gefunden (m\u00f6glicherweise abweichend von der Abfrage?)";
    }

    private String getUnrsError() {
        return "Die zur\u00fcckgemeldete Unternehmensnummer stimmt nicht mit der bereits Erfassten \u00fcberein. Bitte pr\u00fcfen.";
    }

    private void initGTSTs(String input, UvDssd dssd) throws BusinessDomainException {
        String rest = input;
        UvDssdDbgt[] dbgts = new UvDssdDbgt[dssd.getAnzGtst()];
        for (int i = 0; i < dssd.getAnzGtst(); ++i) {
            dbgts[i] = new UvDssdDbgt(dssd);
            rest = this.initGTST(rest, dbgts[i]);
        }
        dssd.setDbgts(dbgts);
    }

    private String initGTST(String input, UvDssdDbgt dbgt) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 89, GTST);
        int i = 1;
        String bbnrgt = this.asString(matcher.group(i++));
        String gtst = this.asString(matcher.group(i++));
        String gtstname = this.asString(matcher.group(i++));
        Date gtstvon = PDateHelper.toDateYYYYMMDD((String)matcher.group(i++));
        Date gtstbis = PDateHelper.toDateYYYYMMDD((String)matcher.group(i++));
        dbgt.setBbnrgt(bbnrgt);
        dbgt.setGtst(gtst);
        dbgt.setGtstName(gtstname);
        dbgt.setGtstVon(gtstvon);
        dbgt.setGtstBis(gtstbis);
        return matcher.group(i);
    }

    private UvDssd[] getReceiveds(String ed) {
        if (this.mReceiveds == null) {
            this.mReceiveds = UvHelper.getUvDssdPM().query(null, Restrictions.eq((String)"ED", (String)ed), true);
        }
        return this.mReceiveds;
    }

    public String getFilesAsString() {
        StringBuffer sb = new StringBuffer();
        for (String each : this.mFilesForReport) {
            sb.append(each + "\n");
        }
        return sb.toString();
    }

    public static void deleteUnassignedDssd() throws BusinessDomainException {
        for (UvDssd each : UvHelper.getUvDssdPM().query(null, Restrictions.isNull((String)"oiduvdsas"), false)) {
            each.destroy();
        }
    }
}

