/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.uv.mapper;

import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.mapper.ExceptionMapper;

public class UvExceptionMapper {
    private static final String CLASS_GENERAL = "PYUv";
    private static final int YEAR_BEFORE_2016_FAILURE = 10;
    private static final int REQUEST_FOR_YEAR_TOO_EARLY_FAILURE = 12;
    private static final int MISSING_DSSD_FAILURE = 50;
    private static final int NO_DATE_ALLOWED_FOR_REASON_FAILURE = 51;
    private static final int DATE_NOT_IN_YEAR_FAILURE = 52;
    private static final int CANCELATION_NOT_ALLOWED = 60;
    private static final int NO_DATA_AVAILABLE = 61;
    private static final int CANCELATION_ERROR = 62;
    private static final int UNRS_FALSE = 100;
    @Errors
    private static final ErrorList ERRORLIST = new ErrorList("PYUv", new ErrorMessage[]{new ErrorMessage(10, "Stammdatenabfragen sind erst f\u00fcr Jahre ab 2016 m\u00f6glich!"), new ErrorMessage(12, "Die Stammdatenabfrage f\u00fcr das Jahr ist noch nicht m\u00f6glich!"), new ErrorMessage(50, "Keine zur\u00fcckgemeldeten Stammdaten f\u00fcr diese Abfrage gefunden!"), new ErrorMessage(51, "F\u00fcr diesen Meldegrund ist die Angabe eines Stichtages nicht zul\u00e4ssig"), new ErrorMessage(52, "Der Stichtag liegt au\u00dferhalb des Jahres der Abfrage!"), new ErrorMessage(60, "Die Stornierung dieser Meldung ist nicht zul\u00e4ssig"), new ErrorMessage(62, "Stornomeldung enth\u00e4lt Fehler: "), new ErrorMessage(61, "F\u00fcr diesen Lohnnachweis wurde keine Beitragsabrechnung-UV gespeichert!")});

    public static BusinessDomainException makeYearBefore2016FailureDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)10, (String)ERRORLIST.getDefaultString(10));
    }

    public static BusinessDomainException makeRequestForYearTooEarlyFailureDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)12, (String)ERRORLIST.getDefaultString(12));
    }

    public static BusinessDomainException makeMissingDssdFailureDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)50, (String)ERRORLIST.getDefaultString(50));
    }

    public static BusinessDomainException makeNoDateAllowedForReasonDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)51, (String)ERRORLIST.getDefaultString(51));
    }

    public static BusinessDomainException makeDateNotInYearFailureDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)52, (String)ERRORLIST.getDefaultString(52));
    }

    public static BusinessDomainException makeCancelationNotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)60, (String)ERRORLIST.getDefaultString(60));
    }

    public static BusinessDomainException makeCancelationErrorDomainException(String errorMessage) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)62, (String)(ERRORLIST.getDefaultString(62) + errorMessage));
    }

    public static BusinessDomainException makeNoDateAvailableDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)61, (String)ERRORLIST.getDefaultString(61));
    }

    public static BusinessDomainException makeUnrsFalseDomainException(String error) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)100, (String)error);
    }
}

