/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.uv;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFund;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundPersistencyManager;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.companyplant.TypeOfBusinessEnum;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbap;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFundTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.uv.UvComponents;
import com.varial.personnel.domain.uv.UvCreate;
import com.varial.personnel.domain.uv.UvHelper;
import com.varial.personnel.domain.uv.dsas.UvDsas;
import com.varial.personnel.domain.uv.dsas.dbap.UvDsasDbap;
import com.varial.personnel.domain.uv.dsln.UvDsln;
import com.varial.personnel.domain.uv.dssd.UvDssd;
import com.varial.personnel.domain.uv.mapper.UvExceptionMapper;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.werum.uvkp.plausi.KernpruefungDSAS;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kernpruefung.Rueckgabe;

public class UvsddCreate
extends UvCreate {
    private static String UV10 = "UV10";
    private static int YEAR2023 = 2023;
    private final List<UvDsas> mCreateds = new ArrayList<UvDsas>();
    private final List<UvDsas> mDummys = new ArrayList<UvDsas>();
    private final List<UvDsas> mRefDummys = new ArrayList<UvDsas>();
    private final List<String> mVorgangsIDsWithError = new ArrayList<String>();

    public UvsddCreate(int year, DEUVSenderTP senderTP) {
        super(year, senderTP);
    }

    public void createMessagesForCompany(PCompany pCompany) throws BusinessDomainException {
        this.mPCompany = pCompany;
        this.mCreateds.clear();
        this.mDummys.clear();
        this.mRefDummys.clear();
        this.mVorgangsIDsWithError.clear();
        this.checkYear();
        AssignmentPCompanyAccidentInsuranceFund[] assAifs = AssignmentPCompanyAccidentInsuranceFundPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid()));
        Arrays.sort(assAifs, Comparator.comparing(AssignmentPCompanyAccidentInsuranceFund::getPlantKey));
        for (AssignmentPCompanyAccidentInsuranceFund assAif : assAifs) {
            for (AssignmentPCompanyAccidentInsuranceFundTP assTP : this.getRelevantTps(assAif)) {
                UvDsas dsas = this.createMessage(assTP);
                this.checkCreated(dsas);
                if (!dsas.isMaster()) continue;
                this.checkForErrors(dsas);
                if (!dsas.hasErrors()) {
                    this.initDbap(dsas);
                }
                this.mCreateds.add(dsas);
            }
        }
        this.compareToTransmitteds();
    }

    public void cancelUvDsas(UvDsas dsas) throws BusinessDomainException {
        UvDsas[] dummys;
        if (!this.isErrorFree(dsas.getAdviceState(), dsas.getEd()) || this.hasValidUvDslns(dsas.getVorgangsId())) {
            throw UvExceptionMapper.makeCancelationNotAllowedDomainException();
        }
        UvDsas storno = this.makeCancelation(dsas);
        if (storno.hasErrors()) {
            throw UvExceptionMapper.makeCancelationErrorDomainException(storno.getErrorMessage());
        }
        storno.setCanceled("S");
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"VORGANGSID", (String)dsas.getVorgangsId()), Restrictions.eq((String)"ED", (String)dsas.getEd()), Restrictions.eq((String)"ISMASTER", (String)"F")});
        for (UvDsas each : dummys = UvsddCreate.getUvDsasPM().query(null, (Criterion)filter, false)) {
            this.setStateToCanceled(each);
        }
        this.mCreateds.add(storno);
        this.mPCompany = dsas.getPCompany();
    }

    private UvDsas createMessage(AssignmentPCompanyAccidentInsuranceFundTP assTP) throws BusinessDomainException {
        UvDsas dsas = new UvDsas();
        AccidentInsuranceFund aif = assTP.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund();
        dsas.setBbnruv(aif.getActiveAccidentInsuranceFundTP().getStdCompanyNoOfAccIns());
        dsas.setMnr(assTP.getMembershipNumber());
        dsas.setMnrpin(assTP.getPin());
        dsas.setLfdNr(assTP.getSerialNumber());
        dsas.setBbnrlb(UvHelper.getBbnrLB((AssignmentPCompanyAccidentInsuranceFundTP)assTP, (Date)assTP.getValidUntil()));
        dsas.setBbnras(UvHelper.getBbnrAS((AssignmentPCompanyAccidentInsuranceFundTP)assTP, (Date)assTP.getValidUntil()));
        dsas.setPCompany(this.mPCompany);
        dsas.setAccidentInsuranceFund(aif);
        dsas.setAssignmentPCompanyAIF(assTP.getAssignmentPCompanyAccidentInsuranceFund());
        dsas.setValidFrom(assTP.getValidFrom());
        dsas.setValidUntil(assTP.getValidUntil());
        dsas.setVorgangsId(UvHelper.toVorgangsId((UvDsas)dsas));
        this.fillBasicData(dsas);
        return dsas;
    }

    private void fillBasicData(UvDsas dsas) throws BusinessDomainException {
        String bbnrab = this.mDeuvSenderTP.getStdCompanyNumber();
        String bbnrep = DataRecipientUtil.getBbnr((TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_DGUV);
        dsas.setBbnrab(bbnrab);
        dsas.setBbnrep(bbnrep);
        dsas.setEd(this.getCreatedOn());
        dsas.setFehlerKennz("0");
        dsas.setFehlerAnz(0);
        dsas.setProdId(DeuvBasics.getProdId());
        dsas.setModId(DeuvBasics.getModId());
        dsas.setKennzst("N");
        dsas.setJahr(this.mYear);
        dsas.setAfgrund(UV10);
        dsas.setTransmitted(false);
        dsas.setCurrentFileNumber(0);
        dsas.setCanceled("N");
        dsas.setAdviceState(AdviceStateEnum.AUFGEBAUT);
    }

    private UvDsasDbap initDbap(UvDsas dsas) throws BusinessDomainException {
        UvDsasDbap result = dsas.createDbap();
        Dbap dbap = new Dbap();
        DeuvHelper.fillDbap((Dbap)dbap, (DEUVSenderTP)this.mDeuvSenderTP, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.UV);
        result.setDbapData(dbap);
        return result;
    }

    private List<AssignmentPCompanyAccidentInsuranceFundTP> getRelevantTps(AssignmentPCompanyAccidentInsuranceFund assAif) throws BusinessDomainException {
        ArrayList<AssignmentPCompanyAccidentInsuranceFundTP> result = new ArrayList<AssignmentPCompanyAccidentInsuranceFundTP>();
        AssignmentPCompanyAccidentInsuranceFundTP lastTp = null;
        for (AssignmentPCompanyAccidentInsuranceFundTP current : assAif.getHistory().getPeriods(VDate.getDateMax(), this.getFirstDayOfYear(), this.getLastDayOfYear())) {
            if (lastTp == null) {
                lastTp = current;
                continue;
            }
            if (this.equalTps(lastTp, current)) {
                lastTp.setValidUntil(current.getValidUntil());
                continue;
            }
            if (this.isValidAif(lastTp)) {
                result.add(lastTp);
            }
            lastTp = current;
        }
        if (lastTp != null && this.isValidAif(lastTp)) {
            result.add(lastTp);
        }
        return result;
    }

    private boolean equalTps(AssignmentPCompanyAccidentInsuranceFundTP tp1, AssignmentPCompanyAccidentInsuranceFundTP tp2) throws BusinessDomainException {
        AccidentInsuranceFund aif2;
        AccidentInsuranceFund aif1 = tp1.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund();
        return aif1.equals((Object)(aif2 = tp2.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund())) && StringMapper.equal((String)tp1.getMembershipNumber(), (String)tp2.getMembershipNumber()) && StringMapper.equal((String)UvHelper.getBbnrAS((AssignmentPCompanyAccidentInsuranceFundTP)tp1, (Date)tp1.getValidUntil()), (String)UvHelper.getBbnrAS((AssignmentPCompanyAccidentInsuranceFundTP)tp2, (Date)tp2.getValidUntil())) && StringMapper.equal((String)UvHelper.getBbnrLB((AssignmentPCompanyAccidentInsuranceFundTP)tp1, (Date)tp1.getValidUntil()), (String)UvHelper.getBbnrLB((AssignmentPCompanyAccidentInsuranceFundTP)tp2, (Date)tp2.getValidUntil())) && tp1.getMembershipNotValid() == tp2.getMembershipNotValid();
    }

    private boolean isValidAif(AssignmentPCompanyAccidentInsuranceFundTP assAifTp) throws BusinessDomainException {
        Date validUntil;
        boolean valid;
        AccidentInsuranceFund aif = assAifTp.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund();
        AccidentInsuranceFundTP aifTP = (AccidentInsuranceFundTP)aif.getHistory().getItemOrNull(VDate.getDateMax());
        boolean bl = valid = !StringMapper.isNullString((String)aifTP.getStdCompanyNoOfAccIns());
        if (valid) {
            boolean bl2 = valid = !aif.isNotValidForDsas(UvHelper.getBbnrLB((AssignmentPCompanyAccidentInsuranceFundTP)assAifTp, (Date)assAifTp.getValidUntil()));
        }
        if (valid && (validUntil = ((AccidentInsuranceFundTP)aif.getHistory().getItemOrNull(VDate.getDateMax())).getValidUntilOfConsolidation()) != null && DateHelper.before((Date)validUntil, (Date)this.getFirstDayOfYear())) {
            valid = false;
        }
        if (valid) {
            boolean bl3 = valid = !assAifTp.getMembershipNotValid();
        }
        if (valid) {
            CompanyFoundations compfound;
            PlantFoundations plantfound;
            Plant plant = assAifTp.getAssignmentPCompanyAccidentInsuranceFund().getPlant();
            if (plant != null && (plantfound = (PlantFoundations)this.getFoundations(plant.getPlantFoundationsHistory())) != null) {
                valid = this.checkFoundationsValid(plantfound.getFoundations());
            }
            if (valid && (compfound = this.getFoundations(this.getPCompany().getCompanyFoundationsHistory())) != null) {
                valid = this.checkFoundationsValid(compfound.getFoundations());
            }
        }
        return valid;
    }

    private <T extends PersonnelTimedPersistenceObject> T getFoundations(PersonnelHistory<T> history) throws BusinessDomainException {
        PersonnelTimedPersistenceObject foundationsFirst;
        PersonnelTimedPersistenceObject result = history.getItemOrNull(this.getFirstDayOfYear());
        if (result == null && DateHelper.beforeOrEqual((Date)(foundationsFirst = history.getItem(0)).getValidFrom(), (Date)this.getLastDayOfYear())) {
            result = foundationsFirst;
        }
        return (T)result;
    }

    private boolean checkFoundationsValid(Foundations foundation) {
        return foundation.getTypeOfBusiness() == TypeOfBusinessEnum.TYBE_AKTIVER_BETRIEB && foundation.getStatusByInsolvency() != StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN && foundation.getStatusByInsolvency() != StatusByInsolvencyEnum.SBIE_FUER_SPAETER_FREIGESTELLTE_AN;
    }

    private void checkYear() throws BusinessDomainException {
        if (this.mYear < 2016) {
            throw UvExceptionMapper.makeYearBefore2016FailureDomainException();
        }
        LocalDate minimumDate = LocalDate.of(this.mYear - 1, Month.NOVEMBER, 1);
        if (LocalDate.now().isBefore(minimumDate)) {
            throw UvExceptionMapper.makeRequestForYearTooEarlyFailureDomainException();
        }
    }

    private void checkForErrors(UvDsas check) {
        Object errorMessage = "";
        for (UvDssd uvDssd : UvHelper.getUvDssdForAssAIF((AssignmentPCompanyAccidentInsuranceFund)check.getAssignmentPCompanyAIF())) {
            if (uvDssd.getBeitragsmassstab() < 4 || uvDssd.getJahr() >= check.getJahr() || !uvDssd.getMnr().equals(check.getMnr()) || check.getJahr() == YEAR2023) continue;
            errorMessage = "*** HINWEIS: Die Abfrage wird nicht erstellt, da der Beitragsma\u00dfstab 4, 5 oder 6 zur\u00fcckgemeldet wurde. ***";
            check.setErrorMessage((String)errorMessage);
            return;
        }
        if (check.getLfdNr() == 0) {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDCOMPACCINS", (String)check.getAssignmentPCompanyAIF().getObjectid()), Restrictions.eq((String)"CANCELED", (String)"N"), Restrictions.eq((String)"ISMASTER", (String)"T"), Restrictions.eq((String)"TRANSMITTED", (String)"T"), Restrictions.isNull((String)"ERRORMESSAGE")});
            for (UvDsas uvDsas : UvsddCreate.getUvDsasPM().query(null, (Criterion)filter, true)) {
                boolean error = false;
                if (uvDsas.getJahr() != check.getJahr() && StringMapper.equal((String)uvDsas.getBbnras(), (String)check.getBbnras()) && StringMapper.equal((String)uvDsas.getBbnrlb(), (String)check.getBbnrlb())) {
                    if (uvDsas.getMnr().equals(check.getMnr())) {
                        error = true;
                    } else {
                        for (UvDssd each : UvDssd.getDssds((UvDsas)uvDsas)) {
                            if (!each.getMnr().equals(check.getMnr())) continue;
                            error = true;
                            break;
                        }
                    }
                }
                if (!error) continue;
                errorMessage = (String)errorMessage + "Die lfd. Nr. darf nicht 0 sein, weil bereits eine Abfrage f\u00fcr " + uvDsas.getJahr() + " erstellt wurde(R\u00fcckmeldung noch nicht eingelesen?). ";
                break;
            }
        } else {
            UvDssd[] existing = UvsddCreate.getUvDssdPM().query(new Order[]{Order.desc((String)"JAHR")}, this.getFilterForUvdssd(check), true);
            boolean valid = false;
            for (UvDssd each : existing) {
                if (!"N".equals(each.getUvDsas().getCanceled())) continue;
                valid = true;
                break;
            }
            if (!valid) {
                errorMessage = (String)errorMessage + "Es existiert keine (g\u00fcltige) R\u00fcckmeldung(DSSD) mit dieser lfd. Nr. ";
            }
        }
        this.checkForCoreErrors(check, (String)errorMessage);
    }

    private void checkForCoreErrors(UvDsas check, String errorMessage) {
        KernpruefungDSAS kernpruefungDSAS = new KernpruefungDSAS();
        Rueckgabe rueckgabe = kernpruefungDSAS.pruefe(UvComponents.getContentUvDsas((UvDsas)check), null);
        List errors = new ArrayList();
        if (rueckgabe.getReturnCode() >= 2) {
            errors = DeuvHelper.removeInvalidErrors((Rueckgabe)rueckgabe, (String[])new String[]{"DSAS110", "DSAS031"});
        }
        check.setErrorMessage(DeuvHelper.getErrorMessage((String)errorMessage, errors, (boolean)true));
    }

    private Criterion getFilterForUvdssd(UvDsas uvDsas) {
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)uvDsas.getPCompany().getObjectid()), Restrictions.eq((String)"bbnruv", (String)uvDsas.getBbnruv()), Restrictions.eq((String)"bbnrlb", (String)uvDsas.getBbnrlb()), Restrictions.eq((String)"bbnras", (String)uvDsas.getBbnras()), Restrictions.eq((String)"mnr", (String)uvDsas.getMnr()), Restrictions.eq((String)"lfdnr", (String)String.valueOf(uvDsas.getLfdNr()))});
    }

    private void checkCreated(UvDsas check) {
        for (UvDsas each : this.mCreateds) {
            if (!StringMapper.equal((String)each.getBbnras(), (String)check.getBbnras()) || !StringMapper.equal((String)each.getBbnrlb(), (String)check.getBbnrlb()) || !StringMapper.equal((String)each.getBbnruv(), (String)check.getBbnruv()) || each.getLfdNr() != check.getLfdNr() || !StringMapper.equal((String)each.getMnr(), (String)check.getMnr())) continue;
            check.setVorgangsId(each.getVorgangsId());
            check.setMaster(false);
            this.mDummys.add(check);
            break;
        }
    }

    private void compareToTransmitteds() throws BusinessDomainException {
        UvDsas storno;
        LinkedList<UvDsas> existing = new LinkedList<UvDsas>(this.getActiveTransmitted());
        this.mCreateds.sort((dsas1, dsas2) -> StringMapper.compareTo((String)dsas1.getVorgangsId(), (String)dsas2.getVorgangsId()));
        LinkedList<UvDsas> createds = new LinkedList<UvDsas>(this.mCreateds);
        this.mCreateds.clear();
        while (!existing.isEmpty() && !createds.isEmpty()) {
            UvDsas existent = (UvDsas)existing.getFirst();
            UvDsas created = (UvDsas)createds.getFirst();
            switch (this.compareUvDsass(existent, created)) {
                case 0: {
                    created.makeReadOnly();
                    this.makeDummysReadonly(created);
                    existing.removeFirst();
                    createds.removeFirst();
                    break;
                }
                case -1: {
                    if (!this.isRejected(existent.getAdviceState()) && !existent.isCanceledManually()) {
                        storno = this.makeCancelation(existent);
                        this.mCreateds.add(storno);
                    }
                    existing.removeFirst();
                    break;
                }
                case 1: {
                    this.checkForDependencyError(created);
                    this.mCreateds.add(created);
                    createds.removeFirst();
                    break;
                }
            }
        }
        for (UvDsas existent : existing) {
            if (this.isRejected(existent.getAdviceState()) || existent.isCanceledManually()) continue;
            storno = this.makeCancelation(existent);
            this.mCreateds.add(storno);
        }
        for (UvDsas created : createds) {
            this.checkForDependencyError(created);
            this.mCreateds.add(created);
        }
        this.mCreateds.sort(Comparator.comparing(UvDsas::getBbnruv).thenComparing(UvDsas::getPlantKey).thenComparing(UvDsas::getMnr).thenComparing(UvDsas::getCanceled));
    }

    private List<UvDsas> getActiveTransmitted() throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDPCOMPANY", (String)this.mPCompany.getObjectid()), Restrictions.eq((String)"JAHR", (String)String.valueOf(this.mYear))});
        UvDsas[] query = UvsddCreate.getUvDsasPM().query(null, (Criterion)filter, true);
        ArrayList<UvDsas> withoutDummys = new ArrayList<UvDsas>();
        for (UvDsas uvDsas : query) {
            if (uvDsas.isMaster()) {
                withoutDummys.add(uvDsas);
                continue;
            }
            this.mRefDummys.add(uvDsas);
        }
        ArrayList<UvDsas> existents = new ArrayList<UvDsas>(withoutDummys);
        for (UvDsas uvDsas : withoutDummys) {
            if (!uvDsas.getTransmitted()) {
                existents.remove(uvDsas);
                this.destroyDummys(uvDsas);
                uvDsas.makeSaveable();
                uvDsas.destroy();
                continue;
            }
            if (!uvDsas.hasFileError()) continue;
            existents.remove(uvDsas);
        }
        existents.sort(Comparator.comparing(UvDsas::getVorgangsId).thenComparing(UvDsas::getEd));
        LinkedList inputs = new LinkedList(existents);
        while (!inputs.isEmpty()) {
            UvDsas current = (UvDsas)inputs.remove(0);
            if ("X".equals(current.getCanceled()) || current.getAdviceState() == AdviceStateEnum.STORNIERT) {
                for (UvDsas each : inputs) {
                    if (!"J".equals(each.getKennzst()) || !current.equalForCancellation(each)) continue;
                    inputs.remove(each);
                    existents.remove(each);
                    if (each.isCanceledManually()) {
                        current.setCanceled("S");
                    } else {
                        existents.remove(current);
                    }
                    current = null;
                    break;
                }
                if (current == null) continue;
                this.resetCanceledState(current);
                for (UvDsas dummy : this.mRefDummys) {
                    if (!StringMapper.equal((String)current.getVorgangsId(), (String)dummy.getVorgangsId()) || !StringMapper.equal((String)current.getEd(), (String)dummy.getEd())) continue;
                    this.resetCanceledState(dummy);
                }
                continue;
            }
            if (!"J".equals(current.getKennzst())) continue;
            existents.remove(current);
        }
        inputs = new LinkedList(existents);
        block5: while (!inputs.isEmpty()) {
            UvDsas current = (UvDsas)inputs.remove(0);
            if (!this.isRejected(current.getAdviceState())) continue;
            for (UvDsas each : inputs) {
                if (!StringMapper.equal((String)current.getVorgangsId(), (String)each.getVorgangsId())) continue;
                existents.remove(current);
                continue block5;
            }
        }
        return existents;
    }

    private int compareUvDsass(UvDsas existent, UvDsas created) {
        int result = StringMapper.compareTo((String)existent.getVorgangsId(), (String)created.getVorgangsId());
        if (result == 0 && this.areDifferent(existent, created)) {
            result = -1;
        }
        if (result < 0) {
            result = -1;
        }
        if (result > 0) {
            result = 1;
        }
        return result;
    }

    private boolean areDifferent(UvDsas existent, UvDsas created) {
        boolean equal;
        boolean bl = equal = existent.getJahr() == created.getJahr() && StringMapper.equal((String)existent.getBbnruv(), (String)created.getBbnruv()) && StringMapper.equal((String)existent.getBbnras(), (String)created.getBbnras()) && StringMapper.equal((String)existent.getBbnrlb(), (String)created.getBbnrlb());
        if (equal) {
            if (this.isRejected(existent.getAdviceState())) {
                equal = StringMapper.equal((String)existent.getMnrpin(), (String)created.getMnrpin()) && existent.getLfdNr() == created.getLfdNr();
            } else {
                boolean bl2 = equal = !StringMapper.isNullString((String)created.getMnrpin());
            }
        }
        if (equal && !(equal = StringMapper.equal((String)existent.getMnr(), (String)created.getMnr()))) {
            UvDssd[] dssds;
            for (UvDssd uvDssd : dssds = UvsddCreate.getUvDssdPM().query(null, Restrictions.eq((String)"oiduvdsas", (String)existent.getObjectid()), true)) {
                if (!StringMapper.equal((String)uvDssd.getMnr(), (String)created.getMnr())) continue;
                equal = true;
                break;
            }
        }
        return !equal;
    }

    private void makeDummysReadonly(UvDsas master) {
        for (UvDsas dummy : this.mDummys) {
            if (!StringMapper.equal((String)master.getVorgangsId(), (String)dummy.getVorgangsId())) continue;
            dummy.makeReadOnly();
        }
    }

    private void cancelDummys(UvDsas master) {
        for (UvDsas dummy : this.mRefDummys) {
            if (!StringMapper.equal((String)master.getVorgangsId(), (String)dummy.getVorgangsId()) || !StringMapper.equal((String)master.getEd(), (String)dummy.getEd())) continue;
            this.setStateToCanceled(dummy);
        }
    }

    private void destroyDummys(UvDsas master) throws BusinessDomainException {
        ArrayList<UvDsas> destroyed = new ArrayList<UvDsas>();
        for (UvDsas dummy : this.mRefDummys) {
            if (!StringMapper.equal((String)master.getVorgangsId(), (String)dummy.getVorgangsId()) || !StringMapper.equal((String)master.getEd(), (String)dummy.getEd())) continue;
            destroyed.add(dummy);
            dummy.makeSaveable();
            dummy.destroy();
        }
        this.mRefDummys.removeAll(destroyed);
    }

    public List<UvDsas> getCreateds() {
        return this.mCreateds;
    }

    public void getUntransmitteds(PCompany pCompany) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDPCOMPANY", (String)pCompany.getObjectid()), Restrictions.eq((String)"JAHR", (String)String.valueOf(this.mYear)), Restrictions.eq((String)"TRANSMITTED", (String)BooleanMapper.toString((boolean)false)), Restrictions.isNull((String)"ERRORMESSAGE"), Restrictions.eq((String)"ISMASTER", (String)"T")});
        Order[] sort = new Order[]{Order.asc((String)"BBNRUV"), Order.asc((String)"MNR"), Order.asc((String)"CANCELED")};
        UvDsas[] untransmitteds = UvsddCreate.getUvDsasPM().query(sort, (Criterion)filter, false);
        this.mCreateds.clear();
        for (UvDsas dsas : untransmitteds) {
            this.mCreateds.add(dsas);
        }
        this.mPCompany = pCompany;
    }

    public UvDsas makeCancelation(UvDsas existent) {
        UvDsas storno = existent.makeCopy();
        storno.setCurrentFileNumber(0);
        storno.setTransmitted(false);
        storno.setAdviceState(AdviceStateEnum.AUFGEBAUT);
        storno.setCanceled("J");
        storno.setKennzst("J");
        storno.setProdId(DeuvBasics.getProdId());
        storno.setModId(DeuvBasics.getModId());
        storno.setEd(this.getCreatedOn());
        String errorMessage = "";
        if (this.isResponseMissing(existent.getAdviceState(), existent.getEd())) {
            errorMessage = UvHelper.getResponseMissingMessage();
            this.mVorgangsIDsWithError.add(storno.getVorgangsId());
        } else if (this.hasValidUvDslns(existent.getVorgangsId())) {
            errorMessage = UvHelper.getUvDslnAlreadyTransmittedMessage();
            this.mVorgangsIDsWithError.add(storno.getVorgangsId());
        } else {
            existent.setCanceled("X");
            existent.setAdviceState(AdviceStateEnum.STORNIERT);
            existent.makeSaveable();
            this.cancelDummys(existent);
        }
        this.checkForCoreErrors(storno, errorMessage);
        return storno;
    }

    private void setStateToCanceled(UvDsas dsas) {
        if (!dsas.getCanceled().equals("X") || dsas.getAdviceState() != AdviceStateEnum.STORNIERT) {
            dsas.setCanceled("X");
            dsas.setAdviceState(AdviceStateEnum.STORNIERT);
            dsas.makeSaveable();
        }
    }

    private void resetCanceledState(UvDsas dsas) {
        AdviceStateEnum transmitted;
        AdviceStateEnum adviceStateEnum = transmitted = this.isCreated2019(dsas.getEd()) ? AdviceStateEnum.ERFOLGREICH : AdviceStateEnum.UEBERMITTELT;
        if (!dsas.isMaster()) {
            transmitted = AdviceStateEnum.AUFGEBAUT;
        }
        if (!dsas.getCanceled().equals("N") || dsas.getAdviceState() != transmitted) {
            dsas.setCanceled("N");
            dsas.setAdviceState(transmitted);
            dsas.makeSaveable();
        }
    }

    private void checkForDependencyError(UvDsas dsas) {
        if (this.mVorgangsIDsWithError.contains(dsas.getVorgangsId()) && !dsas.hasErrors()) {
            dsas.setErrorMessage(DeuvHelper.getErrorMessage((String)"Abh\u00e4ngigkeit zu fehlerhafter Meldung", (boolean)true));
        }
    }

    private boolean hasValidUvDslns(String vorgangsId) {
        UvDsln[] existing = UvsddCreate.getUvDslnPM().query(new Order[]{Order.desc((String)"ed")}, Restrictions.eq((String)"VORGANGSID", (String)vorgangsId), true);
        if (existing.length == 0) {
            return false;
        }
        UvDsln last = existing[0];
        boolean isValid = this.isErrorFree(last.getAdviceState(), last.getEd());
        if ("J".equals(last.getKennzst())) {
            return !isValid;
        }
        return isValid;
    }

    private Date getFirstDayOfYear() {
        return DateHelper.getFirstDayOfYear((Date)this.mYearDate);
    }

    private Date getLastDayOfYear() {
        return DateHelper.getLastDayOfYear((Date)this.mYearDate);
    }

    public PCompany getPCompany() {
        return this.mPCompany;
    }
}

