/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.uv;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.MatchMode;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFund;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.companyplant.TypeOfBusinessEnum;
import com.varial.personnel.domain.deuv.COR;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.DeuvHelper;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbap;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.ISpecialAccess;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.uv.UvComponents;
import com.varial.personnel.domain.uv.UvCreate;
import com.varial.personnel.domain.uv.UvHelper;
import com.varial.personnel.domain.uv.UvelnEmployee;
import com.varial.personnel.domain.uv.dsas.UvDsas;
import com.varial.personnel.domain.uv.dsln.UvDsln;
import com.varial.personnel.domain.uv.dsln.dbap.UvDslnDbap;
import com.varial.personnel.domain.uv.dsln.dbgt.UvDslnDbgt;
import com.varial.personnel.domain.uv.dsln.uveln.UvEln;
import com.varial.personnel.domain.uv.dssd.UvDssd;
import com.varial.personnel.domain.uv.dssd.dbgt.UvDssdDbgt;
import com.varial.personnel.domain.uv.mapper.UvExceptionMapper;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGenerator;
import com.varial.serverbase.query.PutDataException;
import de.werum.uvkp.plausi.KernpruefungDSLN;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import kernpruefung.Rueckgabe;

public class UvelnCreate
extends UvCreate {
    private static String UV01 = "UV01";
    private static String UV05 = "UV05";
    private static String UV06 = "UV06";
    private static String UV08 = "UV08";
    private static String A09 = "A09";
    private final List<UvDsln> mCreateds;
    private final List<String> mVorgangsIDsWithError;
    private UvDssd mDssd;
    private List<AssignmentPCompanyAccidentInsuranceFund> mAssAifDsas;
    private final SpecialAccess mSpecialAccess;
    private final ProgressBarUpdater mProgressBar;

    public UvelnCreate(int year, DEUVSenderTP senderTP, SpecialAccess specialAccess, ProgressBarUpdater progressBar) {
        super(year, senderTP);
        this.mSpecialAccess = specialAccess;
        this.mProgressBar = progressBar;
        this.mCreateds = new ArrayList<UvDsln>();
        this.mVorgangsIDsWithError = new ArrayList<String>();
    }

    public void createMessagesForCompany(PCompany pCompany) throws BusinessDomainException, PutDataException {
        this.mPCompany = pCompany;
        this.mAssAifCompany = null;
        this.mCreateds.clear();
        this.mVorgangsIDsWithError.clear();
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mPCompany.getObjectid()), Restrictions.eq((String)"jahr", (String)String.valueOf(this.mYear)), Restrictions.isNotNull((String)"oiduvdsas")});
        List<UvDssd> uvDssd = Arrays.asList(UvelnCreate.getUvDssdPM().query(new Order[]{Order.asc((String)"vorgangsid"), Order.desc((String)"ED")}, (Criterion)filter, true));
        this.mProgressBar.setTotal(uvDssd.size() + 1);
        for (UvDssd dssd : uvDssd) {
            this.mProgressBar.update(this.getProgressString(this.mPCompany, dssd));
            if (!this.isDssdValid(dssd)) continue;
            this.mDssd = dssd;
            UvDsln dsln = this.createDsln(this.getReason());
            this.checkPreviousYears(dsln);
            this.mCreateds.add(dsln);
        }
        this.compareToTransmitteds();
    }

    private boolean isDssdValid(UvDssd dssd) {
        boolean valid = "N".equals(dssd.getUvDsas().getCanceled());
        if (this.mDssd != null && StringMapper.equal((String)this.mDssd.getVorgangsId(), (String)dssd.getVorgangsId())) {
            valid = false;
        }
        if (dssd.getBeitragsmassstab() > 3) {
            valid = false;
        }
        return valid && this.isMembershipNumberActiv(dssd);
    }

    public void createMessage(UvDsas uvDsas, String reason, Date duesDate) throws BusinessDomainException, PutDataException {
        if (UV06.equals(reason)) {
            if (duesDate == null || !PDateHelper.between((Date)duesDate, (Date)this.mYearDate, (Date)DateHelper.getLastDayOfYear((Date)this.mYearDate))) {
                throw UvExceptionMapper.makeDateNotInYearFailureDomainException();
            }
        } else if (duesDate != null) {
            throw UvExceptionMapper.makeNoDateAllowedForReasonDomainException();
        }
        Criterion filter = Restrictions.eq((String)"oiduvdsas", (String)uvDsas.getObjectid());
        UvDssd[] uvDssd = UvelnCreate.getUvDssdPM().query(new Order[]{Order.desc((String)"ED")}, filter, true);
        if (uvDssd.length <= 0) {
            throw UvExceptionMapper.makeMissingDssdFailureDomainException();
        }
        this.mDssd = uvDssd[0];
        this.mPCompany = uvDsas.getPCompany();
        this.mProgressBar.setTotal(2);
        this.mProgressBar.update(this.getProgressString(this.mPCompany, this.mDssd));
        if (this.isMembershipNumberActiv(this.mDssd)) {
            UvDsln dsln;
            if (UV06.equals(reason)) {
                this.mDssd.setMnrgbis(DateHelper.min((Date)this.mDssd.getMnrgbis(), (Date)duesDate));
                dsln = this.createDsln(reason);
                dsln.setCanceled("M");
            } else {
                dsln = this.createDsln(this.getReason());
            }
            this.checkPreviousYears(dsln);
            this.mCreateds.add(dsln);
        }
        this.compareToTransmitteds(this.mDssd.getVorgangsId(), this.mDssd.getJahr());
    }

    private UvDsln createDsln(String reason) throws BusinessDomainException {
        UvDsln dsln = this.createMessage();
        if (reason.startsWith("UV")) {
            dsln.setMdgrund(reason);
        } else {
            dsln.setMdgrund(UV01);
            dsln.setErrorMessage(reason);
        }
        if (this.mDssd.hasErrors()) {
            dsln.setErrorMessage(DeuvHelper.getErrorMessage((String)("Bei \u00dcbernahme DSSD: " + this.mDssd.getErrorMessage()), (boolean)true));
        } else if (!dsln.hasError()) {
            this.initUvDssdDbgt(dsln);
            this.fillDslnDbgts(dsln);
            this.checkForErrors(dsln);
        }
        return dsln;
    }

    private void initUvDssdDbgt(UvDsln dsln) {
        ArrayList<UvDslnDbgt> dbgts = new ArrayList<UvDslnDbgt>();
        for (UvDssdDbgt dssddbgt : this.mDssd.getDbgts()) {
            UvDslnDbgt dslndbgt = new UvDslnDbgt(dsln);
            dslndbgt.setBbnrgt(dssddbgt.getBbnrgt());
            dslndbgt.setGtst(dssddbgt.getGtst());
            dslndbgt.setUvegsumme(BigDecimal.ZERO);
            dslndbgt.setArbstdsumme(BigDecimal.ZERO);
            dbgts.add(dslndbgt);
        }
        dsln.setDbgts(dbgts.toArray(new UvDslnDbgt[dbgts.size()]));
    }

    private void fillDslnDbgts(UvDsln dsln) throws BusinessDomainException {
        this.mAssAifDsas = this.getAllAssignmentForDsas();
        Deque<Employee> employees = this.getEmployees(this.mAssAifDsas);
        if (!this.hasJournalizedEmployees(employees)) {
            dsln.setErrorMessage("Die Mitarbeiter sind nicht ausreichend journalisiert!");
            return;
        }
        if (!this.checkUvDataOfEmployees(employees, dsln)) {
            dsln.setErrorMessage("Nicht alle MA haben g\u00fcltige UV-Daten. Siehe Pr\u00fcflauf.");
            return;
        }
        ArrayList<UvelnEmployee> withoutUvDuty = new ArrayList<UvelnEmployee>();
        ArrayList<Employee> notJournalized = new ArrayList<Employee>();
        while (!employees.isEmpty()) {
            UvelnEmployee uvelnEmployee = new UvelnEmployee(employees.removeFirst(), this);
            List uvMonths = uvelnEmployee.getUvMonths(dsln.getValidFrom(), dsln.getValidUntil());
            if (uvMonths.isEmpty()) {
                if (!uvelnEmployee.isUvFreeEmployment() || uvelnEmployee.isKVdR(dsln.getValidFrom(), dsln.getValidUntil())) continue;
                withoutUvDuty.add(uvelnEmployee);
                continue;
            }
            if (this.isJournalized(uvelnEmployee, dsln.getValidUntil())) {
                List cors = uvelnEmployee.createCors(uvMonths, dsln.getValidFrom(), dsln.getValidUntil());
                if (cors == null || cors.isEmpty()) continue;
                this.addCorsToDbgts(dsln, cors, uvelnEmployee);
                continue;
            }
            notJournalized.add(uvelnEmployee.getEmployee());
        }
        if (!notJournalized.isEmpty()) {
            dsln.setErrorMessage(this.getJournalizedError(notJournalized));
        }
        UvDslnDbgt dbgtNoDuty = new UvDslnDbgt(dsln);
        dbgtNoDuty.makeReadOnly();
        if (withoutUvDuty.isEmpty()) {
            UvEln uvEln = new UvEln(dsln);
            uvEln.makeReadOnly();
            dbgtNoDuty.addEmployeeBean(uvEln);
        } else {
            for (UvelnEmployee employee : withoutUvDuty) {
                dbgtNoDuty.setAnzversgtst(dbgtNoDuty.getAnzversgtst() + 1);
                dbgtNoDuty.addEmployeeBean(this.createEmployeeBean(employee, dbgtNoDuty));
            }
        }
        dsln.setWithoutUvDuty(dbgtNoDuty);
    }

    private void checkPreviousYears(UvDsln dsln) throws BusinessDomainException {
        UvDssd[] oldDssds;
        if (!UV08.equals(dsln.getMdgrund())) {
            return;
        }
        UvDssd dssdBackup = this.mDssd;
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.like((String)"VORGANGSID", (String)UvHelper.getOidAssAifFromVorgangsId((String)dsln.getVorgangsId()), (MatchMode)MatchMode.START), Restrictions.lt((String)"JAHR", (String)String.valueOf(this.mYear)), Restrictions.ge((String)"JAHR", (String)String.valueOf(this.mYear - 2)), Restrictions.isNotNull((String)"oiduvdsas")});
        Order[] sort = new Order[]{Order.asc((String)"JAHR"), Order.desc((String)"ED")};
        for (UvDssd dssd : oldDssds = UvelnCreate.getUvDssdPM().query(sort, (Criterion)filter, true)) {
            if (!this.isDssdValid(dssd)) continue;
            this.mDssd = dssd;
            UvDsln[] oldDslns = UvelnCreate.getUvDslnPM().query(new Order[]{Order.asc((String)"ED")}, Restrictions.eq((String)"oiduvdssd", (String)dssd.getObjectid()), true);
            boolean oldDslnFound = false;
            for (UvDsln oldDsln : oldDslns) {
                if (oldDsln.getTransmitted()) {
                    if (!"N".equals(oldDsln.getCanceled())) continue;
                    oldDslnFound = true;
                    break;
                }
                oldDsln.makeSaveable();
                oldDsln.destroy();
                break;
            }
            if (oldDslnFound) continue;
            UvDsln dslnPrevios = this.createDsln(this.getReason());
            this.mCreateds.add(dslnPrevios);
        }
        this.mDssd = dssdBackup;
    }

    private void checkForErrors(UvDsln check) {
        KernpruefungDSLN kernpruefungDSLN = new KernpruefungDSLN();
        Rueckgabe rueckgabe = kernpruefungDSLN.pruefe(UvComponents.getContentUvDsln((UvDsln)check), null);
        List errors = new ArrayList();
        if (rueckgabe.getReturnCode() >= 2) {
            errors = DeuvHelper.removeInvalidErrors((Rueckgabe)rueckgabe, (String[])new String[]{"DSLN110"});
        }
        check.setErrorMessage(DeuvHelper.getErrorMessage((String)check.getErrorMessage(), errors, (boolean)true));
    }

    private Deque<Employee> getEmployees(List<AssignmentPCompanyAccidentInsuranceFund> assAif) throws BusinessDomainException {
        Employee[] employees = null;
        if (!this.isUsingPlant() || this.mDssd.getUvDsas().getAssignmentPCompanyAIF().getPlant() == null) {
            employees = this.getAllEmployees();
        } else {
            ArrayList<String> oidPlants = new ArrayList<String>();
            for (AssignmentPCompanyAccidentInsuranceFund each : assAif) {
                if (each.getPlant() == null) continue;
                oidPlants.add(each.getPlant().getObjectid());
            }
            Junction filters = Restrictions.conjunction().add(Restrictions.in((String)"oidplant", oidPlants)).add(Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString())).add(Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.getDssdValidUntil()))).add(Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.getDssdValidFrom())));
            SelectGenerator selector = new SelectGenerator("employment_t", new String[]{"oidemployee"}, null, (Criterion)filters, null, true, String.class, new String[]{""});
            String[] result = (String[])selector.select();
            employees = new Employee[result.length];
            for (int i = 0; i < result.length; ++i) {
                employees[i] = this.getEmployeePM().getEmployee(result[i]);
            }
        }
        this.mSpecialAccess.filter((ISpecialAccess[])employees);
        List<Employee> empList = Arrays.asList(employees);
        empList.sort(Comparator.comparing(Employee::getPersonnelnumber));
        return new LinkedList<Employee>(empList);
    }

    private boolean isUsingPlant() throws BusinessDomainException {
        return this.mPCompany.getCompanySettings(VDate.getDateMax(), VDate.getDateMax()).getUsePlants();
    }

    private Employee[] getAllEmployees() {
        return this.getEmployeePM().query(new Order[]{Order.asc((String)"PERSONNELNUMBER")}, Restrictions.eq((String)"OIDPCOMPANY", (String)this.mPCompany.getObjectid()), true);
    }

    private List<AssignmentPCompanyAccidentInsuranceFund> getAllAssignmentForDsas() {
        UvDsas[] dsass = UvelnCreate.getUvDsasPM().query(null, Restrictions.eq((String)"VORGANGSID", (String)this.mDssd.getVorgangsId()), true);
        ArrayList<AssignmentPCompanyAccidentInsuranceFund> assAif = new ArrayList<AssignmentPCompanyAccidentInsuranceFund>();
        for (UvDsas each : dsass) {
            assAif.add(each.getAssignmentPCompanyAIF());
        }
        return assAif;
    }

    private void addCorsToDbgts(UvDsln dsln, List<COR> cors, UvelnEmployee employee) throws BusinessDomainException {
        boolean assigned = false;
        block0: for (COR cor : cors) {
            if (!StringMapper.equal((String)dsln.getBbnruv(), (String)UvelnCreate.getBbnr((AccidentInsuranceFund)cor.getAif(), (Date)this.getDssdValidUntil())) || !StringMapper.equal((String)dsln.getMnr(), (String)cor.getMembershipNr())) continue;
            for (UvDslnDbgt dbgt : dsln.getDbgts()) {
                if (!StringMapper.equal((String)dbgt.getBbnrgt(), (String)UvelnCreate.getBbnr((AccidentInsuranceFund)cor.getAifCor(), (Date)this.getDssdValidUntil())) || !StringMapper.equal((String)dbgt.getGtst(), (String)cor.getCor())) continue;
                if (this.mDssd.getBeitragsmassstab() == 1) {
                    dbgt.setUvegsumme(dbgt.getUvegsumme().add(UvelnCreate.roundHalfUp((BigDecimal)cor.getPayment())));
                }
                dbgt.setArbstdsumme(dbgt.getArbstdsumme().add(UvelnCreate.roundUp((BigDecimal)cor.getWorktime())));
                dbgt.addEmployeeBean(this.createEmployeeBean(employee, dbgt, cor));
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)cor.getPayment())) {
                    dbgt.setAnzversgtst(dbgt.getAnzversgtst() + 1);
                    assigned = true;
                    continue block0;
                }
                if (!cor.isReducedByYearlyLimit()) continue block0;
                assigned = true;
                continue block0;
            }
        }
        if (assigned) {
            dsln.setAnzvers(dsln.getAnzvers() + 1);
        }
    }

    private UvEln createEmployeeBean(UvelnEmployee employee, UvDslnDbgt dbgt) throws BusinessDomainException {
        UvEln bean = new UvEln(dbgt.getUvDsln());
        bean.setCount(dbgt.getEmployeeBeans().size() + 1);
        bean.setPersonnelnumber(employee.getPersonnelnumber());
        bean.setInsuranceNo(employee.getInsuranceNo());
        bean.setName(employee.getName());
        bean.setBbnrgt(dbgt.getBbnrgt());
        bean.setGtst(dbgt.getGtst());
        bean.setOccupation(employee.getOccupationLongDescription(this.getDssdValidUntil()));
        return bean;
    }

    private UvEln createEmployeeBean(UvelnEmployee employee, UvDslnDbgt dbgt, COR cor) throws BusinessDomainException {
        UvEln bean = this.createEmployeeBean(employee, dbgt);
        if (this.mDssd.getBeitragsmassstab() == 1) {
            bean.setPayment(UvelnCreate.roundHalfUp((BigDecimal)cor.getPayment()));
        }
        bean.setWorktime(UvelnCreate.roundUp((BigDecimal)cor.getWorktime()));
        return bean;
    }

    private UvDsln createMessage() throws BusinessDomainException {
        UvDsln dsln = new UvDsln();
        this.fillBasicData(dsln);
        dsln.setVorgangsId(this.mDssd.getVorgangsId());
        dsln.setBbnruv(this.mDssd.getBbnruv());
        dsln.setMnr(this.mDssd.getMnr());
        dsln.setMnrpin(this.mDssd.getUvDsas().getMnrpin());
        dsln.setLfdNr(this.mDssd.getLfdNr());
        dsln.setBbnrlb(this.mDssd.getBbnrlb());
        dsln.setBbnras(this.mDssd.getBbnras());
        dsln.setUvgrund(this.getUvGrund());
        dsln.setAnuv(this.mDssd.getAnzGtst());
        dsln.setPCompany(this.mPCompany);
        dsln.setAccidentInsuranceFund(this.mDssd.getUvDsas().getAccidentInsuranceFund());
        dsln.setUvDssd(this.mDssd);
        dsln.setValidFrom(DateHelper.max((Date)this.getCalculationStart(), (Date)this.getDssdValidFrom()));
        dsln.setValidUntil(this.getDssdValidUntil());
        return dsln;
    }

    private void fillBasicData(UvDsln dsln) throws BusinessDomainException {
        String bbnrab = this.mDeuvSenderTP.getStdCompanyNumber();
        String bbnrep = DataRecipientUtil.getBbnr((TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_DGUV);
        dsln.setBbnrab(bbnrab);
        dsln.setBbnrep(bbnrep);
        dsln.setEd(this.getCreatedOn());
        dsln.setFehlerKennz("0");
        dsln.setFehlerAnz(0);
        dsln.setProdId(DeuvBasics.getProdId());
        dsln.setModId(DeuvBasics.getModId());
        dsln.setKennzst("N");
        dsln.setJahr(this.mDssd.getJahr());
        dsln.setTransmitted(false);
        dsln.setCurrentFileNumber(0);
        dsln.setCanceled("N");
        dsln.setAdviceState(AdviceStateEnum.AUFGEBAUT);
        this.initDbap(dsln);
    }

    private UvDslnDbap initDbap(UvDsln dsln) throws BusinessDomainException {
        UvDslnDbap result = dsln.createDbap();
        Dbap dbap = new Dbap();
        DeuvHelper.fillDbap((Dbap)dbap, (DEUVSenderTP)this.mDeuvSenderTP, (DeuvHelper.TypeOfCommunication)DeuvHelper.TypeOfCommunication.UV);
        result.setDbapData(dbap);
        return result;
    }

    private boolean hasJournalizedEmployees(Deque<Employee> employees) {
        boolean result = false;
        for (Employee employee : employees) {
            if (!DateHelper.afterOrEqual((Date)employee.getJournalizedUntil(), (Date)this.getDssdValidUntil())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean checkUvDataOfEmployees(Deque<Employee> employees, UvDsln dsln) throws BusinessDomainException {
        return true;
    }

    private boolean isJournalized(UvelnEmployee employee, Date minJournalized) {
        return DateHelper.afterOrEqual((Date)employee.getJournalizedUntil(), (Date)minJournalized);
    }

    private String getJournalizedError(List<Employee> notJournalized) {
        StringBuilder builder = new StringBuilder();
        for (Employee employee : notJournalized) {
            if (builder.length() == 0) {
                builder.append("Folgende MA sind nicht ausreichend journalisiert: ");
            } else {
                builder.append(", ");
            }
            builder.append(employee.getPersonnelnumber());
        }
        return builder.toString();
    }

    private String getReason() throws BusinessDomainException {
        Date membershipChangeDate;
        Date insolvencyDate;
        CompanyFoundations companyFoundations;
        Date membershipEndDate;
        String reason = UV01;
        Date validUntil = null;
        Date endOfBusinessDate = this.getEndOfBusinessDate();
        if (endOfBusinessDate != null) {
            if (DateHelper.before((Date)endOfBusinessDate, (Date)this.getDssdValidFrom())) {
                return "Betriebsaufgabe bereits vor Zeitraum des Lohnnnachweises";
            }
            validUntil = endOfBusinessDate;
            reason = UV05;
        }
        if ((membershipEndDate = this.getMembershipEndDate()) != null) {
            if (DateHelper.before((Date)membershipEndDate, (Date)this.getDssdValidFrom())) {
                return "Mitgliedschaft bereits vor Zeitraum des Lohnnnachweises beendet";
            }
            if (validUntil == null || DateHelper.before((Date)membershipEndDate, (Date)validUntil)) {
                validUntil = membershipEndDate;
                reason = UV05;
            }
        }
        if ((companyFoundations = (CompanyFoundations)this.mPCompany.getCompanyFoundationsHistory().getItemOrNull(this.getDssdValidUntil())) != null && companyFoundations.getFoundations().getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_INSOLVENT && DateHelper.beforeOrEqual((Date)(insolvencyDate = DateHelper.yesterday((Date)companyFoundations.getFoundations().getInsolventlyFrom())), (Date)this.getDssdValidUntil())) {
            if (DateHelper.before((Date)insolvencyDate, (Date)this.getDssdValidFrom())) {
                return "Insolvenz bereits vor Zeitraum des Lohnnnachweises";
            }
            if (validUntil == null || DateHelper.before((Date)insolvencyDate, (Date)validUntil)) {
                validUntil = insolvencyDate;
                reason = UV08;
            }
        }
        if ((membershipChangeDate = this.getMembershipChangeDate()) != null && (validUntil == null || DateHelper.before((Date)membershipChangeDate, (Date)validUntil))) {
            validUntil = membershipChangeDate;
            reason = UV05;
        }
        if (validUntil != null) {
            this.mDssd.setMnrgbis(DateHelper.min((Date)this.getDssdValidUntil(), (Date)validUntil));
        }
        return reason;
    }

    private Date getEndOfBusinessDate() throws BusinessDomainException {
        List companyFoundations = this.mPCompany.getCompanyFoundationsHistory().getPeriods(VDate.getDateMax(), this.getDssdValidFrom(), DateHelper.tomorrow((Date)this.getDssdValidUntil()));
        Date result = null;
        for (CompanyFoundations each : companyFoundations) {
            Date endOfBusiness;
            if (each.getFoundations().getTypeOfBusiness() != TypeOfBusinessEnum.TYBE_BETRIEBSAUFGABE || !DateHelper.beforeOrEqual((Date)(endOfBusiness = DateHelper.yesterday((Date)each.getValidFrom())), (Date)this.getDssdValidUntil())) continue;
            result = endOfBusiness;
            break;
        }
        return result;
    }

    private Date getMembershipEndDate() {
        List assTPs = this.mDssd.getUvDsas().getAssignmentPCompanyAIF().getHistory().getPeriods(VDate.getDateMax(), this.getDssdValidFrom(), DateHelper.tomorrow((Date)this.getDssdValidUntil()));
        Date result = null;
        for (AssignmentPCompanyAccidentInsuranceFundTP each : assTPs) {
            if (!each.getMembershipNotValid()) continue;
            result = DateHelper.yesterday((Date)each.getValidFrom());
            break;
        }
        return result;
    }

    private Date getMembershipChangeDate() {
        List assTPs = this.mDssd.getUvDsas().getAssignmentPCompanyAIF().getHistory().getPeriods(VDate.getDateMax(), this.getDssdValidFrom(), DateHelper.tomorrow((Date)this.getDssdValidUntil()));
        Date result = null;
        String membershipNumberLast = null;
        for (AssignmentPCompanyAccidentInsuranceFundTP each : assTPs) {
            Date changeDate;
            if (membershipNumberLast != null && !membershipNumberLast.equals(each.getMembershipNumber()) && DateHelper.beforeOrEqual((Date)(changeDate = DateHelper.yesterday((Date)each.getValidFrom())), (Date)this.getDssdValidUntil())) {
                result = changeDate;
                break;
            }
            membershipNumberLast = each.getMembershipNumber();
        }
        return result;
    }

    private boolean isMembershipNumberActiv(UvDssd dssd) {
        List assTPs = dssd.getUvDsas().getAssignmentPCompanyAIF().getHistory().getPeriods(VDate.getDateMax(), dssd.getMnrgvon(), dssd.getMnrgbis());
        boolean result = false;
        for (AssignmentPCompanyAccidentInsuranceFundTP each : assTPs) {
            if (!dssd.getMnr().equals(each.getMembershipNumber())) continue;
            result = true;
            break;
        }
        return result;
    }

    private void compareToTransmitteds() throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.mPCompany.getObjectid()), Restrictions.eq((String)"jahr", (String)String.valueOf(this.mYear))});
        this.compareToTransmitteds(this.getActiveTransmitted((Criterion)filter));
    }

    private void compareToTransmitteds(String vorgangsId, int jahr) throws BusinessDomainException {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"vorgangsid", (String)vorgangsId), Restrictions.eq((String)"jahr", (String)String.valueOf(jahr))});
        this.compareToTransmitteds(this.getActiveTransmitted((Criterion)filter));
    }

    private void compareToTransmitteds(List<UvDsln> activeTransmitted) throws BusinessDomainException {
        UvDsln storno;
        LinkedList<UvDsln> existing = new LinkedList<UvDsln>(activeTransmitted);
        this.mCreateds.sort(Comparator.comparing(UvDsln::getVorgangsId));
        LinkedList<UvDsln> createds = new LinkedList<UvDsln>(this.mCreateds);
        this.mCreateds.clear();
        while (!existing.isEmpty() && !createds.isEmpty()) {
            UvDsln existent = (UvDsln)existing.getFirst();
            UvDsln created = (UvDsln)createds.getFirst();
            switch (this.compareUvDslns(existent, created)) {
                case 0: {
                    created.makeReadOnly();
                    existing.removeFirst();
                    createds.removeFirst();
                    break;
                }
                case -1: {
                    if (!this.isRejected(existent.getAdviceState())) {
                        storno = this.makeCancellation(existent);
                        this.mCreateds.add(storno);
                    }
                    existing.removeFirst();
                    break;
                }
                case 1: {
                    this.checkForDependencyError(created);
                    this.checkForCancelled(created);
                    this.mCreateds.add(created);
                    createds.removeFirst();
                    break;
                }
            }
        }
        for (UvDsln existent : existing) {
            if (this.isRejected(existent.getAdviceState())) continue;
            storno = this.makeCancellation(existent);
            this.mCreateds.add(storno);
        }
        for (UvDsln created : createds) {
            this.checkForDependencyError(created);
            this.checkForCancelled(created);
            this.mCreateds.add(created);
        }
    }

    private List<UvDsln> getActiveTransmitted(Criterion filter) throws BusinessDomainException {
        UvDsln current;
        List<UvDsln> query = Arrays.asList(UvelnCreate.getUvDslnPM().query(null, filter, true));
        ArrayList<UvDsln> existents = new ArrayList<UvDsln>(query);
        for (UvDsln uvDsln : query) {
            if (!uvDsln.getTransmitted()) {
                existents.remove(uvDsln);
                uvDsln.makeSaveable();
                uvDsln.destroy();
                continue;
            }
            if (!uvDsln.hasFileError()) continue;
            existents.remove(uvDsln);
        }
        existents.sort(Comparator.comparing(UvDsln::getVorgangsId).thenComparing(UvDsln::getEd));
        LinkedList<UvDsln> inputs = new LinkedList<UvDsln>(existents);
        while (!inputs.isEmpty()) {
            current = (UvDsln)inputs.remove(0);
            if ("X".equals(current.getCanceled()) || current.getAdviceState() == AdviceStateEnum.STORNIERT) {
                for (UvDsln each : inputs) {
                    if (!"J".equals(each.getKennzst()) || current.isDifferent(each)) continue;
                    inputs.remove(each);
                    existents.remove(each);
                    existents.remove(current);
                    current = null;
                    break;
                }
                if (current == null) continue;
                this.resetCanceledState(current);
                continue;
            }
            if (!"J".equals(current.getKennzst())) continue;
            existents.remove(current);
        }
        inputs = new LinkedList<UvDsln>(existents);
        block3: while (!inputs.isEmpty()) {
            current = (UvDsln)inputs.remove(0);
            if (!this.isRejected(current.getAdviceState())) continue;
            for (UvDsln each : inputs) {
                if (!StringMapper.equal((String)current.getVorgangsId(), (String)each.getVorgangsId())) continue;
                existents.remove(current);
                continue block3;
            }
        }
        return existents;
    }

    private int compareUvDslns(UvDsln existent, UvDsln created) {
        int result = StringMapper.compareTo((String)existent.getVorgangsId(), (String)created.getVorgangsId());
        if (result == 0 && created.isDifferent(existent)) {
            result = -1;
            created.setCancelledDsln(existent);
            if (created.hasError()) {
                existent.setErrorMessage("Stornierung wird nicht \u00fcbermittelt, da neue Meldung fehlerhaft!");
            }
        }
        if (result < 0) {
            result = -1;
        }
        if (result > 0) {
            result = 1;
        }
        return result;
    }

    public UvDsln makeCancellation(UvDsln existent) {
        UvDsln storno = existent.makeCopy();
        storno.setCurrentFileNumber(0);
        storno.setTransmitted(false);
        storno.setAdviceState(AdviceStateEnum.AUFGEBAUT);
        storno.setCanceled("J");
        storno.setKennzst("J");
        storno.setProdId(DeuvBasics.getProdId());
        storno.setModId(DeuvBasics.getModId());
        storno.setEd(this.getCreatedOn());
        if (this.isResponseMissing(existent.getAdviceState(), existent.getEd())) {
            storno.setErrorMessage(UvHelper.getResponseMissingMessage());
            this.mVorgangsIDsWithError.add(storno.getVorgangsId());
        } else if (existent.hasError()) {
            storno.setErrorMessage(existent.getErrorMessage());
        } else {
            existent.setCanceled("X");
            existent.setAdviceState(AdviceStateEnum.STORNIERT);
            existent.makeSaveable();
        }
        this.checkForErrors(storno);
        return storno;
    }

    private void resetCanceledState(UvDsln dsln) {
        AdviceStateEnum transmitted;
        AdviceStateEnum adviceStateEnum = transmitted = this.isCreated2019(dsln.getEd()) ? AdviceStateEnum.ERFOLGREICH : AdviceStateEnum.UEBERMITTELT;
        if (!dsln.getCanceled().equals("N") || dsln.getAdviceState() != transmitted) {
            dsln.setCanceled("N");
            dsln.setAdviceState(transmitted);
            dsln.makeSaveable();
        }
    }

    private void checkForDependencyError(UvDsln dsln) {
        if (this.mVorgangsIDsWithError.contains(dsln.getVorgangsId()) && !dsln.hasError()) {
            dsln.setErrorMessage(DeuvHelper.getErrorMessage((String)"Abh\u00e4ngigkeit zu fehlerhafter Meldung", (boolean)true));
        }
    }

    private void checkForCancelled(UvDsln created) throws BusinessDomainException {
        UvDsln old;
        if (created.getCancelledDsln() != null && (old = created.getCancelledDsln()).getUvElns().length > 0) {
            UvelnCreate.fillUvDsln(old);
            this.findCorrections(old, created);
            return;
        }
        this.createCorrectionDbgt(created, null);
    }

    private void findCorrections(UvDsln old, UvDsln created) {
        LinkedList oldEmployeeBeans = new LinkedList();
        for (UvDslnDbgt dbgt : old.getDbgts()) {
            oldEmployeeBeans.addAll(dbgt.getEmployeeBeans());
        }
        LinkedList newEmployeeBeans = new LinkedList();
        for (UvDslnDbgt dbgt : created.getDbgts()) {
            newEmployeeBeans.addAll(dbgt.getEmployeeBeans());
        }
        int beitragsmassstab = created.getUvDssd().getBeitragsmassstab();
        ArrayList<UvEln> corrections = new ArrayList<UvEln>();
        while (!oldEmployeeBeans.isEmpty() && !newEmployeeBeans.isEmpty()) {
            UvEln oldEmployeeBean = (UvEln)oldEmployeeBeans.getFirst();
            UvEln newEmployeeBean = (UvEln)newEmployeeBeans.getFirst();
            switch (this.compareUvElns(oldEmployeeBean, newEmployeeBean, beitragsmassstab)) {
                case 0: {
                    oldEmployeeBeans.removeFirst();
                    newEmployeeBeans.removeFirst();
                    break;
                }
                case -1: {
                    this.addCorrectionBean(created, oldEmployeeBean, "O", corrections);
                    oldEmployeeBeans.removeFirst();
                    break;
                }
                case 1: {
                    newEmployeeBean.setTypeOfCorrection("X");
                    this.addCorrectionBean(created, newEmployeeBean, "W", corrections);
                    newEmployeeBeans.removeFirst();
                }
            }
        }
        for (UvEln bean : oldEmployeeBeans) {
            this.addCorrectionBean(created, bean, "O", corrections);
        }
        for (UvEln bean : newEmployeeBeans) {
            bean.setTypeOfCorrection("X");
            this.addCorrectionBean(created, bean, "W", corrections);
        }
        this.createCorrectionDbgt(created, corrections);
    }

    private void addCorrectionBean(UvDsln created, UvEln bean, String typeOfCorrection, List<UvEln> corrections) {
        UvEln correctionBean = bean.createCopy(created);
        correctionBean.setTypeOfCorrection(typeOfCorrection);
        correctionBean.setCount(corrections.size() + 1);
        corrections.add(correctionBean);
    }

    private int compareUvElns(UvEln uvEln1, UvEln uvEln2, int beitragsmassstab) {
        int result = StringMapper.compareTo((String)uvEln1.getGtst(), (String)uvEln2.getGtst());
        if (result == 0) {
            result = StringMapper.compareTo((String)uvEln1.getBbnrgt(), (String)uvEln2.getBbnrgt());
        }
        if (result == 0) {
            result = Integer.compare(uvEln1.getPersonnelnumber(), uvEln2.getPersonnelnumber());
        }
        if (result == 0) {
            switch (beitragsmassstab) {
                case 1: {
                    result = BigDecimalMapper.compareTo((BigDecimal)uvEln1.getPayment(), (BigDecimal)uvEln2.getPayment());
                    break;
                }
                case 2: {
                    result = BigDecimalMapper.compareTo((BigDecimal)uvEln1.getWorktime(), (BigDecimal)uvEln2.getWorktime());
                    break;
                }
            }
        }
        if (result < 0) {
            result = -1;
        }
        if (result > 0) {
            result = 1;
        }
        return result;
    }

    private void createCorrectionDbgt(UvDsln dsln, List<UvEln> corrections) {
        UvDslnDbgt correctionDbgt = new UvDslnDbgt(dsln);
        correctionDbgt.makeReadOnly();
        correctionDbgt.setCorrection(true);
        if (corrections == null || corrections.isEmpty()) {
            UvEln uvEln = new UvEln(dsln);
            uvEln.makeReadOnly();
            correctionDbgt.addEmployeeBean(uvEln);
        } else {
            for (UvEln bean : corrections) {
                correctionDbgt.addEmployeeBean(bean);
            }
        }
        dsln.setCorrections(correctionDbgt);
    }

    public boolean isAssAifValid(AssignmentPCompanyAccidentInsuranceFund assAif) {
        return this.mAssAifDsas != null && assAif != null && this.mAssAifDsas.contains(assAif);
    }

    public List<UvDsln> getCreateds() {
        this.mCreateds.sort(Comparator.comparing(UvDsln::getBbnruv).thenComparing(UvDsln::getMnr).thenComparing(UvDsln::getCanceled));
        return this.mCreateds;
    }

    public void removeInvalidsFromCreateds() {
        ArrayList<UvDsln> stornos = new ArrayList<UvDsln>();
        for (UvDsln uvDsln : this.mCreateds) {
            if (!"J".equals(uvDsln.getKennzst())) continue;
            stornos.add(uvDsln);
        }
        this.mCreateds.removeAll(stornos);
        ArrayList<UvDsln> invalids = new ArrayList<UvDsln>();
        for (UvDsln uvDsln : this.mCreateds) {
            if (!uvDsln.hasError()) continue;
            invalids.add(uvDsln);
        }
        this.mCreateds.removeAll(invalids);
    }

    private Date getDssdValidFrom() {
        Date validFrom = null;
        if (this.mDssd != null) {
            validFrom = this.mDssd.getMnrgvon();
        }
        return validFrom;
    }

    private Date getDssdValidUntil() {
        Date validFrom = null;
        if (this.mDssd != null) {
            validFrom = this.mDssd.getMnrgbis();
        }
        return validFrom;
    }

    private String getUvGrund() {
        return this.mDssd != null && this.mDssd.getBeitragsmassstab() == 1 ? "" : A09;
    }

    public PCompany getPCompany() {
        return this.mPCompany;
    }

    public static List<UvDsln> getUntransmitted(PCompany pCompany, int year) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)pCompany.getObjectid()), Restrictions.eq((String)"jahr", (String)String.valueOf(year)), Restrictions.eq((String)"transmitted", (String)BooleanMapper.toString((boolean)false)), Restrictions.isNull((String)"errormessage")});
        UvDsln[] untransmitteds = UvelnCreate.getUvDslnPM().query(null, (Criterion)filter, false);
        ArrayList<UvDsln> result = new ArrayList<UvDsln>();
        for (UvDsln dsln : untransmitteds) {
            result.add(dsln);
        }
        result.sort(Comparator.comparing(UvDsln::getBbnruv).thenComparing(UvDsln::getMnr).thenComparing(UvDsln::getCanceled));
        return result;
    }

    public static void fillUvDsln(UvDsln dsln) throws BusinessDomainException {
        UvEln uvEln;
        UvEln[] employeeBeans = dsln.getUvElns();
        if (employeeBeans.length == 0) {
            throw UvExceptionMapper.makeNoDateAvailableDomainException();
        }
        UvDslnDbgt[] dbgts = dsln.getDbgts();
        UvDslnDbgt dbgtNoDuty = new UvDslnDbgt(dsln);
        dbgtNoDuty.makeReadOnly();
        dsln.setWithoutUvDuty(dbgtNoDuty);
        UvDslnDbgt dbgtCorrections = new UvDslnDbgt(dsln);
        dbgtCorrections.makeReadOnly();
        dbgtCorrections.setCorrection(true);
        dsln.setCorrections(dbgtCorrections);
        UvDslnDbgt current = null;
        for (UvEln each : employeeBeans) {
            if (each.isCorrection()) {
                dbgtCorrections.addEmployeeBean(each);
                continue;
            }
            if (each.getBbnrgt().isEmpty()) {
                dbgtNoDuty.addEmployeeBean(each);
                continue;
            }
            if (current == null || !UvelnCreate.match(current, each)) {
                current = null;
                for (UvDslnDbgt dbgt : dbgts) {
                    if (!UvelnCreate.match(dbgt, each)) continue;
                    current = dbgt;
                    break;
                }
                if (current == null) {
                    throw new IllegalArgumentException("kein zugeh\u00f6riger Gefahrtarif:" + each.toString());
                }
            }
            current.addEmployeeBean(each);
        }
        if (dbgtNoDuty.getEmployeeBeans().isEmpty()) {
            uvEln = new UvEln(dsln);
            uvEln.makeReadOnly();
            dbgtNoDuty.addEmployeeBean(uvEln);
        }
        if (dbgtCorrections.getEmployeeBeans().isEmpty()) {
            uvEln = new UvEln(dsln);
            uvEln.makeReadOnly();
            dbgtCorrections.addEmployeeBean(uvEln);
        }
    }

    private static boolean match(UvDslnDbgt dbgt, UvEln employeeBean) {
        return StringMapper.equal((String)dbgt.getBbnrgt(), (String)employeeBean.getBbnrgt()) && StringMapper.equal((String)dbgt.getGtst(), (String)employeeBean.getGtst());
    }

    private IEmployeePersistencyManager getEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private String getProgressString(PCompany pCompany, UvDssd dssd) {
        return "Aufbau UV-Lohnnachweis: " + pCompany.getPCompanyKey() + "/" + dssd.getMnr();
    }
}

