/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.typeofvalue;

import com.infor.igf.core.event.EventFactory;
import com.infor.igf.core.event.EventPublisher;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.pcompany.mapper.PCompanyExceptionMapper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTPData;
import com.varial.personnel.domain.typeofvalue.ValueTypeTPPersistencyManager;
import com.varial.personnel.domain.typeofvalue.basictypes.CategoryEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ClassificationEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.ClassificationEnumMapper;
import com.varial.personnel.domain.typeofvalue.coefficient.ValueTypeCoefficient;
import com.varial.personnel.domain.typeofvalue.coefficient.assignment.AssignmentEnum;
import com.varial.personnel.domain.typeofvalue.coefficient.assignment.FixAssignmentEnum;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.domain.typeofvalue.evaluation.ValueTypeEvaluation;
import com.varial.personnel.domain.typeofvalue.formula.ValueTypeFormula;
import com.varial.personnel.domain.typeofvalue.foundation.ValueTypeFoundation;
import com.varial.personnel.domain.typeofvalue.foundation.general.FoundationGeneral;
import com.varial.personnel.domain.typeofvalue.mapper.ValueTypeExceptionMapper;
import com.varial.personnel.framework.ComparatorException;
import com.varial.personnel.framework.D;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.springframework.dao.DataAccessException;

public class ValueTypeTP
extends PersonnelTimedPersistenceObject {
    private static final String EVENT_PUBLISHER_ID = "com.infor.igf.core.event.messageSender";
    private static final int PRIORITY = 3;
    private ValueType mValueType;
    private boolean mActive;
    private ValueTypeFoundation mFoundation;
    private ValueTypeEvaluation mEvaluation;
    private ValueTypeCoefficient mFactor1;
    private ValueTypeCoefficient mFactor2;
    private ValueTypeCoefficient mResult;
    private ConsequenceOfValueType[] mConsequences;
    private ConsequenceOfValueType[] mNewConsequences;
    private ConsequenceOfValueType[] mConsequencesForOrientation;
    private ConsequenceOfValueType[] mNewConsequencesForOrientation;
    private ValueTypeFormula[] mFormulaRows;
    private ValueTypeFormula[] mNewFormulaRows;
    private boolean mSpecialChecks = true;
    private ValueTypeTP mOld = null;

    public ValueTypeTP(ValueType vt) {
        super(3);
        this.mValueType = vt;
    }

    public ValueTypeTP(ValueType vt, boolean readOnly) {
        super(3, readOnly);
        this.mValueType = vt;
    }

    public static ValueTypeTP getValueTypeTP(String objectID) {
        return new ValueTypeTP(objectID);
    }

    private ValueTypeTP(String objectID) {
        super(3, objectID);
    }

    public ValueTypeTP(String objectId, int version) {
        super(3, objectId, version);
    }

    protected ValueTypeTP(ValueType vt, boolean active, ValueTypeFoundation vtf, ValueTypeEvaluation vte, ValueTypeCoefficient factor1, ValueTypeCoefficient factor2, ValueTypeCoefficient result, ConsequenceOfValueType[] covtArray, ConsequenceOfValueType[] covtfoArray, ValueTypeFormula[] formulaArray, boolean readOnly) {
        super(3, readOnly);
        this.mValueType = vt;
        this.mActive = active;
        this.mFoundation = vtf;
        this.mEvaluation = vte;
        this.mFactor1 = factor1;
        this.mFactor2 = factor2;
        this.mResult = result;
        this.mConsequences = covtArray;
        this.mConsequencesForOrientation = covtfoArray;
        this.mFormulaRows = formulaArray;
    }

    protected void saveImpl() {
        ValueTypeTPPersistencyManager.save((ValueTypeTP)this);
        EventPublisher sender = (EventPublisher)UtilitiesManager.getBeanSilent((String)EVENT_PUBLISHER_ID, EventPublisher.class);
        if (sender != null) {
            sender.publish(EventFactory.createCacheEvent((EventFactory.Action)EventFactory.Action.CLEAR, (EventFactory.CacheId)EventFactory.CacheId.VALUE_TYPE));
        }
    }

    protected void load() {
        ValueTypeTPPersistencyManager.load((ValueTypeTP)this);
    }

    protected void deleteImpl() {
        ValueTypeTPPersistencyManager.delete((ValueTypeTP)this);
        EventPublisher sender = (EventPublisher)UtilitiesManager.getBeanSilent((String)EVENT_PUBLISHER_ID, EventPublisher.class);
        if (sender != null) {
            sender.publish(EventFactory.createCacheEvent((EventFactory.Action)EventFactory.Action.CLEAR, (EventFactory.CacheId)EventFactory.CacheId.VALUE_TYPE));
        }
    }

    protected void destroyImpl() throws BusinessDomainException {
        int i;
        this.mFoundation.makeSaveable();
        this.mFoundation.destroy();
        this.mEvaluation.makeSaveable();
        this.mEvaluation.destroy();
        this.mFactor1.makeSaveable();
        this.mFactor1.destroy();
        this.mFactor2.makeSaveable();
        this.mFactor2.destroy();
        this.mResult.makeSaveable();
        this.mResult.destroy();
        for (i = 0; i < this.getConsequenceOfValueType().length; ++i) {
            this.mConsequences[i].makeSaveable();
            this.mConsequences[i].destroy();
        }
        for (i = 0; i < this.getConsequenceForOrientation().length; ++i) {
            this.mConsequencesForOrientation[i].makeSaveable();
            this.mConsequencesForOrientation[i].destroy();
        }
        for (i = 0; i < this.getFormulaRows().length; ++i) {
            this.mFormulaRows[i].makeSaveable();
            this.mFormulaRows[i].destroy();
        }
    }

    public void firstExecuteImpl() throws BusinessDomainException {
        int i;
        if (this.mNewConsequences != null) {
            if (this.getConsequenceOfValueType() != null) {
                for (i = 0; i < this.getConsequenceOfValueType().length; ++i) {
                    this.getConsequenceOfValueType()[i].makeSaveable();
                    this.getConsequenceOfValueType()[i].unregisterLastExecute();
                    this.getConsequenceOfValueType()[i].destroy();
                }
            }
            for (i = 0; i < this.mNewConsequences.length; ++i) {
                this.mNewConsequences[i].makeSaveable();
                this.mNewConsequences[i].registerForLastExecute();
            }
        }
        if (this.mNewConsequencesForOrientation != null) {
            if (this.getConsequenceForOrientation() != null) {
                for (i = 0; i < this.getConsequenceForOrientation().length; ++i) {
                    this.getConsequenceForOrientation()[i].makeSaveable();
                    this.getConsequenceForOrientation()[i].unregisterLastExecute();
                    this.getConsequenceForOrientation()[i].destroy();
                }
            }
            for (i = 0; i < this.mNewConsequencesForOrientation.length; ++i) {
                this.mNewConsequencesForOrientation[i].makeSaveable();
                this.mNewConsequencesForOrientation[i].registerForLastExecute();
            }
        }
        if (this.mFormulaRows != null) {
            if (this.getFormulaRows() != null) {
                for (i = 0; i < this.getFormulaRows().length; ++i) {
                    this.getFormulaRows()[i].makeSaveable();
                    this.getFormulaRows()[i].unregisterLastExecute();
                    this.getFormulaRows()[i].destroy();
                }
            }
            for (i = 0; i < this.mNewFormulaRows.length; ++i) {
                this.mNewFormulaRows[i].makeSaveable();
                this.mNewFormulaRows[i].registerForLastExecute();
            }
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mValueType.getDomainKey()).append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    public PersonnelTimedPersistenceObject createNew() {
        ValueTypeTP result = new ValueTypeTP(this.getValueType());
        result.mEffectiveFrom = this.getEffectiveFrom();
        result.mEffectiveUntil = this.getEffectiveUntil();
        result.mValidFrom = this.getValidFrom();
        result.mValidUntil = this.getValidUntil();
        result = this.fillNew(result);
        return result;
    }

    public ValueTypeTP fillNew(ValueTypeTP result) {
        ValueTypeFormula[] formulaArray;
        int i;
        ConsequenceOfValueType[] covtfoArray;
        int i2;
        ConsequenceOfValueType[] covtArray;
        result.mActive = this.getActive();
        result.mFoundation = this.getValueTypeFoundation().createNew();
        result.mEvaluation = this.getValueTypeEvaluation().createNew();
        result.mFactor1 = this.getFactor1().createNew();
        result.mFactor2 = this.getFactor2().createNew();
        result.mResult = this.getResult().createNew();
        if (this.mNewConsequences != null) {
            covtArray = new ConsequenceOfValueType[this.mNewConsequences.length];
            for (i2 = 0; i2 < this.mNewConsequences.length; ++i2) {
                covtArray[i2] = this.mNewConsequences[i2].createNew(result);
            }
        } else {
            covtArray = new ConsequenceOfValueType[this.mConsequences.length];
            for (i2 = 0; i2 < this.mConsequences.length; ++i2) {
                covtArray[i2] = this.mConsequences[i2].createNew(result);
            }
        }
        result.mConsequences = covtArray;
        if (this.mNewConsequencesForOrientation != null) {
            covtfoArray = new ConsequenceOfValueType[this.mNewConsequencesForOrientation.length];
            for (i = 0; i < this.mNewConsequencesForOrientation.length; ++i) {
                covtfoArray[i] = this.mNewConsequencesForOrientation[i].createNew(result);
            }
        } else {
            covtfoArray = new ConsequenceOfValueType[this.mConsequencesForOrientation.length];
            for (i = 0; i < this.mConsequencesForOrientation.length; ++i) {
                covtfoArray[i] = this.mConsequencesForOrientation[i].createNew(result);
            }
        }
        result.mConsequencesForOrientation = covtfoArray;
        if (this.mNewFormulaRows != null) {
            formulaArray = new ValueTypeFormula[this.mNewFormulaRows.length];
            for (int i3 = 0; i3 < this.mNewFormulaRows.length; ++i3) {
                formulaArray[i3] = this.mNewFormulaRows[i3].createNew(result);
            }
        } else {
            formulaArray = new ValueTypeFormula[this.mFormulaRows.length];
            for (int i4 = 0; i4 < this.mFormulaRows.length; ++i4) {
                formulaArray[i4] = this.mFormulaRows[i4].createNew(result);
            }
        }
        result.mFormulaRows = formulaArray;
        return result;
    }

    public void setData(ValueTypeTPData data) {
        this.mEffectiveFrom = data.getEffectiveFrom();
        this.mEffectiveUntil = data.getEffectiveUntil();
        this.mValidFrom = data.getValidFrom();
        this.mValidUntil = data.getValidUntil();
        this.mActive = data.getActive();
        this.mFoundation = data.getFoundation();
        this.mEvaluation = data.getEvaluation();
        this.mFactor1 = data.getFactor1();
        this.mFactor2 = data.getFactor2();
        this.mResult = data.getResult();
        this.mConsequences = data.getConsequences();
        this.mConsequencesForOrientation = data.getConsequencesForOrientation();
        this.mFormulaRows = data.getFormulaRows();
    }

    public final void makeSaveableOnlyTP() {
        super.makeSaveable();
    }

    public final void makeSaveable() {
        int i;
        this.mEvaluation.makeSaveable();
        this.mFoundation.makeSaveable();
        this.mFactor1.makeSaveable();
        this.mFactor2.makeSaveable();
        this.mResult.makeSaveable();
        super.makeSaveable();
        if (this.mConsequences != null) {
            for (i = 0; i < this.mConsequences.length; ++i) {
                this.mConsequences[i].makeSaveable();
            }
        }
        if (this.mConsequencesForOrientation != null) {
            for (i = 0; i < this.mConsequencesForOrientation.length; ++i) {
                this.mConsequencesForOrientation[i].makeSaveable();
            }
        }
        if (this.mFormulaRows != null) {
            for (i = 0; i < this.mFormulaRows.length; ++i) {
                this.mFormulaRows[i].makeSaveable();
            }
        }
    }

    public final void makeReadOnly() {
        int i;
        this.mEvaluation.makeReadOnly();
        this.mFoundation.makeReadOnly();
        this.mFactor1.makeReadOnly();
        this.mFactor2.makeReadOnly();
        this.mResult.makeReadOnly();
        super.makeReadOnly();
        if (this.mConsequences != null) {
            for (i = 0; i < this.mConsequences.length; ++i) {
                this.mConsequences[i].makeReadOnly();
            }
        }
        if (this.mNewConsequences != null) {
            for (i = 0; i < this.mNewConsequences.length; ++i) {
                this.mNewConsequences[i].makeReadOnly();
            }
        }
        if (this.mConsequencesForOrientation != null) {
            for (i = 0; i < this.mConsequencesForOrientation.length; ++i) {
                this.mConsequencesForOrientation[i].makeReadOnly();
            }
        }
        if (this.mNewConsequencesForOrientation != null) {
            for (i = 0; i < this.mNewConsequencesForOrientation.length; ++i) {
                this.mNewConsequencesForOrientation[i].makeReadOnly();
            }
        }
        if (this.mFormulaRows != null) {
            for (i = 0; i < this.mFormulaRows.length; ++i) {
                this.mFormulaRows[i].makeReadOnly();
            }
        }
        if (this.mNewFormulaRows != null) {
            for (i = 0; i < this.mNewFormulaRows.length; ++i) {
                this.mNewFormulaRows[i].makeReadOnly();
            }
        }
    }

    public void registerForLastExecute() {
        int i;
        this.mEvaluation.registerForLastExecute();
        this.mFoundation.registerForLastExecute();
        this.mFactor1.registerForLastExecute();
        this.mFactor2.registerForLastExecute();
        this.mResult.registerForLastExecute();
        super.registerForLastExecute();
        if (this.mConsequences != null) {
            for (i = 0; i < this.mConsequences.length; ++i) {
                this.mConsequences[i].registerForLastExecute();
            }
        }
        if (this.mNewConsequences != null) {
            for (i = 0; i < this.mNewConsequences.length; ++i) {
                this.mNewConsequences[i].registerForLastExecute();
            }
        }
        if (this.mConsequencesForOrientation != null) {
            for (i = 0; i < this.mConsequencesForOrientation.length; ++i) {
                this.mConsequencesForOrientation[i].registerForLastExecute();
            }
        }
        if (this.mNewConsequencesForOrientation != null) {
            for (i = 0; i < this.mNewConsequencesForOrientation.length; ++i) {
                this.mNewConsequencesForOrientation[i].registerForLastExecute();
            }
        }
        if (this.mFormulaRows != null) {
            for (i = 0; i < this.mFormulaRows.length; ++i) {
                this.mFormulaRows[i].registerForLastExecute();
            }
        }
        if (this.mNewFormulaRows != null) {
            for (i = 0; i < this.mNewFormulaRows.length; ++i) {
                this.mNewFormulaRows[i].registerForLastExecute();
            }
        }
    }

    public synchronized ValueType getValueType() {
        this.requireLoaded();
        return this.mValueType;
    }

    public void setValueType(ValueType vt) {
        this.mValueType = vt;
    }

    public synchronized boolean getActive() {
        this.requireLoaded();
        return this.mActive;
    }

    public void setActive(boolean active) {
        this.protocol("Active", this.mActive, active);
        this.mActive = active;
    }

    public synchronized ValueTypeFoundation getValueTypeFoundation() {
        this.requireLoaded();
        return this.mFoundation;
    }

    public void setValueTypeFoundation(ValueTypeFoundation valueTypeFoundation) {
        this.mFoundation = valueTypeFoundation;
    }

    public synchronized ValueTypeEvaluation getValueTypeEvaluation() {
        this.requireLoaded();
        return this.mEvaluation;
    }

    public void setValueTypeEvaluation(ValueTypeEvaluation vte) {
        this.mEvaluation = vte;
    }

    public synchronized ValueTypeCoefficient getFactor1() {
        this.requireLoaded();
        return this.mFactor1;
    }

    public void setFactor1(ValueTypeCoefficient vtc) {
        this.mFactor1 = vtc;
    }

    public synchronized ValueTypeCoefficient getFactor2() {
        this.requireLoaded();
        return this.mFactor2;
    }

    public void setFactor2(ValueTypeCoefficient vtc) {
        this.mFactor2 = vtc;
    }

    public synchronized ValueTypeCoefficient getResult() {
        this.requireLoaded();
        return this.mResult;
    }

    public void setResult(ValueTypeCoefficient vtc) {
        this.mResult = vtc;
    }

    public synchronized ConsequenceOfValueType[] getConsequenceOfValueType() {
        this.requireLoaded();
        return this.mConsequences;
    }

    public synchronized ValueTypeFormula[] getFormulaRows() {
        this.requireLoaded();
        return this.mFormulaRows;
    }

    public void setFormulaRows(ValueTypeFormula[] newArray) {
        this.mNewFormulaRows = newArray;
    }

    public synchronized ConsequenceOfValueType[] getAllConsequenceOfValueType() {
        this.requireLoaded();
        ConsequenceOfValueType[] allConsequences = new ConsequenceOfValueType[this.mConsequences.length + this.mConsequencesForOrientation.length];
        System.arraycopy(this.mConsequences, 0, allConsequences, 0, this.mConsequences.length);
        System.arraycopy(this.mConsequencesForOrientation, 0, allConsequences, this.mConsequences.length, this.mConsequencesForOrientation.length);
        return allConsequences;
    }

    public void setConsequenceOfValueType(ConsequenceOfValueType[] newArray) {
        this.mNewConsequences = newArray;
    }

    public synchronized ConsequenceOfValueType[] getConsequenceForOrientation() {
        this.requireLoaded();
        return this.mConsequencesForOrientation;
    }

    public void setConsequenceForOrientation(ConsequenceOfValueType[] newArray) {
        this.mNewConsequencesForOrientation = newArray;
    }

    public void checkAttributes() throws BusinessDomainException {
        this.checkDates();
        this.checkValueTypeKey();
        this.getValueTypeFoundation().checkAttributes(this);
        this.getValueTypeEvaluation().checkAttributes(this.mEffectiveFrom, this.mValidFrom);
        if (this.mOld == null) {
            this.getFactor1().checkAttributes(null, this);
            this.getFactor2().checkAttributes(null, this);
            this.getResult().checkAttributes(null, this);
        } else {
            this.getFactor1().checkAttributes(this.mOld.getFactor1(), this);
            this.getFactor2().checkAttributes(this.mOld.getFactor2(), this);
            this.getResult().checkAttributes(this.mOld.getResult(), this);
        }
        this.checkConsequences();
        this.checkConsequencesForOrientation();
        this.checkGrossWageJournalSummarised();
        this.checkCompressToSummary();
        this.checkFormulaRows();
    }

    private void checkValueTypeKey() throws BusinessDomainException {
        if (this.mValueType.getValueTypeKey() <= 0) {
            throw FrameWorkExceptionMapper.makeInputIsMissingDomainException((String)"Schl\u00fcssel Wertart");
        }
    }

    private void checkCompressToSummary() throws BusinessDomainException {
        if (!this.getValueTypeFoundation().getGeneral().isCompressToSummary()) {
            return;
        }
        if (this.getValueTypeFoundation().getGeneral().getCategory() != CategoryEnum.CE_Bruttobezug && this.getValueTypeFoundation().getGeneral().getCategory() != CategoryEnum.CE_zur_Information) {
            throw ValueTypeExceptionMapper.makeCompressToSummaryNotAllowedDomainException();
        }
        if (this.getFactor1().getAssignment().getAssignmentSelection() == AssignmentEnum.AE_Fest && this.getFactor1().getAssignment().getFixAssignment() == FixAssignmentEnum.FAE_Erfassung && this.getFactor2().getAssignment().getAssignmentSelection() == AssignmentEnum.AE_Fest && this.getFactor2().getAssignment().getFixAssignment() == FixAssignmentEnum.FAE_Erfassung && this.getResult().getAssignment().getAssignmentSelection() == AssignmentEnum.AE_Fest && this.getResult().getAssignment().getFixAssignment() == FixAssignmentEnum.FAE_keine_Zuordnung) {
            throw ValueTypeExceptionMapper.makeCompressToSummaryNotAllowedDomainException();
        }
    }

    private void checkGrossWageJournalSummarised() throws BusinessDomainException {
        if (this.getValueType().getValueTypeKey() <= 99899) {
            return;
        }
        if (!this.getValueTypeFoundation().getPrintSettings().isPrintOnGrossWageJournal()) {
            return;
        }
        if (this.getValueTypeFoundation().getGeneral().isCategory(CategoryEnum.CE_SYS_Summen_Position) && !this.isConsequenceSummarised()) {
            return;
        }
        throw ValueTypeExceptionMapper.makeGrossWageJournalSummarisedDomainException();
    }

    private boolean isConsequenceSummarised() throws BusinessDomainException {
        if (this.getConsequenceOfValueType() != null) {
            for (ConsequenceOfValueType each : this.getConsequenceOfValueType()) {
                ValueType vt = each.getConsequenceOfValueType();
                ValueTypeTP tp = vt.getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom());
                ValueTypeFoundation foundation = tp.getValueTypeFoundation();
                FoundationGeneral general = foundation.getGeneral();
                if (!general.isCategory(CategoryEnum.CE_SYS_Summen_Position)) continue;
                return true;
            }
        }
        return false;
    }

    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        if (this.getValueType().getPcompany() == null) {
            if (DateHelper.before((Date)this.getValidFrom(), (Date)pb.getSystemStart())) {
                this.setValidFrom(pb.getSystemStart());
            }
        } else {
            Date minValidFrom = this.getValueType().getPcompany().getStartOfHistory();
            if (DateHelper.before((Date)this.getValidFrom(), (Date)minValidFrom)) {
                throw PCompanyExceptionMapper.makeStartHistoryBeforePCompanyFoundationValidFromDomainException((String)"ValueTypeTP.checkDates");
            }
        }
        if (this.getValueType().isNew()) {
            this.setEffectiveFrom(pb.getSystemStart());
        }
    }

    public void checkConsequences() throws BusinessDomainException {
        if (this.mNewConsequences != null) {
            ConsequenceOfValueType[] array = this.mNewConsequences;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    throw ValueTypeExceptionMapper.makeNoConsequenceObjectFoundInConsequencsDomainException((String)Integer.toString(i));
                }
                ValueType vt = array[i].getConsequenceOfValueType();
                if (vt == null) {
                    throw ValueTypeExceptionMapper.makeNoValueTypeFoundInConsequenceDomainException((String)Integer.toString(i));
                }
                if (!array[i].getForOrientation() && array[i].getValueTypeTP().getValueType().getValueTypeKey() < 100000 && vt.getValueTypeKey() >= 99899) {
                    throw ValueTypeExceptionMapper.makeFalseConsequenceVt((String)Integer.toString(i));
                }
                try {
                    ValueTypeTP vttp = vt.getValueTypeTP(this.getEffectiveUntil(), this.getValidFrom());
                    ValueTypeFoundation vtf = vttp.getValueTypeFoundation();
                    if (vtf == null) {
                        throw ValueTypeExceptionMapper.makeNoFoundationFoundForConsequenceVTDomainException((String)Integer.toString(vt.getValueTypeKey()));
                    }
                    FoundationGeneral vtfg = vtf.getGeneral();
                    if (vtfg == null) {
                        throw ValueTypeExceptionMapper.makeNoGeneralObjectFoundInFoundationOfConsequenceVTDomainException((String)Integer.toString(vt.getValueTypeKey()));
                    }
                    if (array[i].getForClassification().value() != vtfg.getClassification().value()) {
                        throw ValueTypeExceptionMapper.makeClassOfConsequencesAndOfVTNotEqualDomainException((String)Integer.toString(vt.getValueTypeKey()));
                    }
                    if (this.getValueType().getValueTypeKey() > 99997 || this.getValueTypeFoundation().getGeneral().getRankingNumber() < vtfg.getRankingNumber()) continue;
                    throw ValueTypeExceptionMapper.makeRankingNumberOfConsequenceBeforeRankingNumberOfValueTypeDomainException((String)Integer.toString(vt.getValueTypeKey()));
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                        throw ValueTypeExceptionMapper.makeNoHistoryForConsequenceException((String)Integer.toString(vt.getValueTypeKey()));
                    }
                    throw e;
                }
            }
        }
    }

    public void checkConsequencesForOrientation() throws BusinessDomainException {
        if (this.mNewConsequencesForOrientation != null || this.getConsequenceForOrientation() != null) {
            ConsequenceOfValueType[] array = this.mNewConsequencesForOrientation == null ? this.getConsequenceForOrientation() : this.mNewConsequencesForOrientation;
            if (this.mSpecialChecks && this.mValueType.getValueTypeKey() <= 99899) {
                boolean findBruttolohn = false;
                boolean findLStPfl = false;
                boolean findSVBeitragsPfl = false;
                boolean findNettolohn = false;
                boolean findKuGSollentgelt = false;
                boolean findSVBeitragsPflFiktiv = false;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i].getForClassification().value() != array[i].getConsequenceOfValueType().getValueTypeTP(this.getEffectiveFrom(), this.getValidFrom()).getValueTypeFoundation().getGeneral().getClassification().value()) {
                        throw ValueTypeExceptionMapper.makeClassOfConsequencesForOrientationAndOfVTNotEqualDomainException((String)Integer.toString(i + 1));
                    }
                    if (array[i].getForClassification() == ClassificationEnum.CE_Einordnung && array[i].getConsequenceOfValueType().getValueTypeKey() == 100200) {
                        findBruttolohn = true;
                    } else if (array[i].getForClassification() == ClassificationEnum.CE_Lohnsteuerpflicht && array[i].getConsequenceOfValueType().getValueTypeKey() != 104200) {
                        findLStPfl = true;
                    } else if (array[i].getForClassification() == ClassificationEnum.CE_SV_Beitragspflicht && array[i].getConsequenceOfValueType().getValueTypeKey() != 128200 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129210 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129220 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129505 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129200 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129400 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129505 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129510 && array[i].getConsequenceOfValueType().getValueTypeKey() != 129511 && array[i].getConsequenceOfValueType().getValueTypeKey() != 130530 && array[i].getConsequenceOfValueType().getValueTypeKey() != 130635) {
                        findSVBeitragsPfl = true;
                    } else if (array[i].getForClassification() == ClassificationEnum.CE_Kurzarbeitergeld && (array[i].getConsequenceOfValueType().getValueTypeKey() == 150320 || array[i].getConsequenceOfValueType().getValueTypeKey() == 150310)) {
                        findKuGSollentgelt = true;
                    } else if (array[i].getForClassification() == ClassificationEnum.CE_Nettolohn) {
                        findNettolohn = true;
                    } else if (array[i].getForClassification() == ClassificationEnum.CE_SV_Beitragspflicht && (array[i].getConsequenceOfValueType().getValueTypeKey() == 130530 || array[i].getConsequenceOfValueType().getValueTypeKey() == 130635)) {
                        findSVBeitragsPflFiktiv = true;
                    }
                    if (array[i].getForClassification() != ClassificationEnum.CE_EFZ_Versicherung || array[i].getConsequenceOfValueType().getValueTypeKey() != 372220) continue;
                    throw ValueTypeExceptionMapper.makeVTForOrientationNotAllowedDomainException((String)ClassificationEnumMapper.toSpecialString((ClassificationEnum)ClassificationEnum.CE_EFZ_Versicherung), (String)Integer.toString(372220));
                }
                if (findSVBeitragsPflFiktiv && (findBruttolohn || findNettolohn)) {
                    throw ValueTypeExceptionMapper.makeClassifikationNettoAndBruttoNotAllowed();
                }
                if ((findBruttolohn || findLStPfl) && !findNettolohn) {
                    throw ValueTypeExceptionMapper.makeClassificationNettolohnIsMissingDomainException();
                }
                if (findSVBeitragsPfl && !findSVBeitragsPflFiktiv && !findNettolohn) {
                    throw ValueTypeExceptionMapper.makeClassificationNettolohnIsMissingDomainException();
                }
                if (findKuGSollentgelt && !findNettolohn) {
                    throw ValueTypeExceptionMapper.makeClassificationNettolohnIsMissingDomainException();
                }
            }
        }
    }

    public void checkFormulaRows() throws BusinessDomainException {
        if (this.mNewFormulaRows != null) {
            ValueTypeFormula[] array;
            for (ValueTypeFormula vtf : array = this.mNewFormulaRows) {
                if (vtf == null) {
                    throw ValueTypeExceptionMapper.makeEmptyFormulaRowFoundDomainException();
                }
                vtf.checkAttributes();
            }
        }
    }

    public void compareToOld(ValueTypeTP old) throws BusinessDomainException {
        D.enter();
        this.requireLoaded();
        if (old == null) {
            this.mValuateNeeded = false;
            return;
        }
        old.requireLoaded();
        this.mOld = old;
        this.mValuateNeeded = this.mFoundation.compareToOld(old.mFoundation) || this.mEvaluation.compareToOld(old.mEvaluation) || this.mFactor1.compareToOld(old.mFactor1) || this.mFactor2.compareToOld(old.mFactor2) || this.mResult.compareToOld(old.mResult) || this.compareConsequencesToOld(this.mNewConsequences, old.mConsequences) || this.compareConsequencesToOld(this.mNewConsequencesForOrientation, old.mConsequencesForOrientation) || this.compareFormulaRowsToOld(this.mNewFormulaRows, old.mFormulaRows);
        D.leave();
    }

    private boolean compareConsequencesToOld(ConsequenceOfValueType[] array, ConsequenceOfValueType[] old) throws BusinessDomainException {
        if (array == null && old == null) {
            return false;
        }
        if (array == null || old == null) {
            return true;
        }
        if (array.length == 0 && old.length == 0) {
            return false;
        }
        if (array.length != old.length) {
            return true;
        }
        Comparator<ConsequenceOfValueType> comparator = new Comparator<ConsequenceOfValueType>(){

            @Override
            public int compare(ConsequenceOfValueType o1, ConsequenceOfValueType o2) {
                try {
                    int v1 = o1.getConsequenceOfValueType().getValueTypeKey();
                    int v2 = o2.getConsequenceOfValueType().getValueTypeKey();
                    return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
                }
                catch (ApplicationException e) {
                    throw new ComparatorException((Throwable)e);
                }
                catch (DataAccessException e) {
                    throw new ComparatorException((Throwable)e);
                }
            }
        };
        Arrays.sort(array, comparator);
        Arrays.sort(old, comparator);
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].compareToOld(old[i])) continue;
            return true;
        }
        return false;
    }

    private boolean compareFormulaRowsToOld(ValueTypeFormula[] array, ValueTypeFormula[] old) throws BusinessDomainException {
        if (array == null && old == null) {
            return false;
        }
        if (array == null || old == null) {
            return true;
        }
        if (array.length == 0 && old.length == 0) {
            return false;
        }
        if (array.length != old.length) {
            return true;
        }
        Comparator<ValueTypeFormula> comparator = new Comparator<ValueTypeFormula>(){

            @Override
            public int compare(ValueTypeFormula o1, ValueTypeFormula o2) {
                try {
                    int ps1 = o1.getProcessingSequence();
                    int ps2 = o2.getProcessingSequence();
                    return ps1 < ps2 ? -1 : (ps1 == ps2 ? 0 : 1);
                }
                catch (ApplicationException e) {
                    throw new ComparatorException((Throwable)e);
                }
                catch (DataAccessException e) {
                    throw new ComparatorException((Throwable)e);
                }
            }
        };
        Arrays.sort(array, comparator);
        Arrays.sort(old, comparator);
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].compareToOld(old[i])) continue;
            return true;
        }
        return false;
    }

    public void checkAgainstInterval(Date validFrom) throws BusinessDomainException {
        this.getValueTypeFoundation().getGeneral().getInterval().check(validFrom);
    }

    public void checkAgainstFactor1(BigDecimal factor1) throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)factor1)) {
            block0 : switch (this.getValueTypeEvaluation().getPieceWork().getPieceWork().value()) {
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    switch (this.getFactor1().getAssignment().getAssignmentSelection().value()) {
                        case 0: {
                            switch (this.getFactor1().getAssignment().getFixAssignment().value()) {
                                case 1: {
                                    break block0;
                                }
                            }
                            throw ValueTypeExceptionMapper.makeFactor1AndValueTypeDontCorrespondingDomainException();
                        }
                    }
                    throw ValueTypeExceptionMapper.makeFactor1AndValueTypeDontCorrespondingDomainException();
                }
            }
        }
    }

    public void checkAgainstFactor2(BigDecimal factor2) throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)factor2)) {
            block0 : switch (this.getFactor2().getAssignment().getAssignmentSelection().value()) {
                case 0: {
                    switch (this.getFactor2().getAssignment().getFixAssignment().value()) {
                        case 1: {
                            break block0;
                        }
                    }
                    throw ValueTypeExceptionMapper.makeFactor2AndValueTypeDontCorrespondingDomainException();
                }
                default: {
                    throw ValueTypeExceptionMapper.makeFactor2AndValueTypeDontCorrespondingDomainException();
                }
            }
        }
    }

    public void checkAgainstResult(BigDecimal result) throws BusinessDomainException {
        if (!BigDecimalMapper.isZero((BigDecimal)result)) {
            block0 : switch (this.getResult().getAssignment().getAssignmentSelection().value()) {
                case 0: {
                    switch (this.getResult().getAssignment().getFixAssignment().value()) {
                        case 1: {
                            break block0;
                        }
                    }
                    throw ValueTypeExceptionMapper.makeResultAndValueTypeDontCorrespondingDomainException();
                }
                default: {
                    throw ValueTypeExceptionMapper.makeResultAndValueTypeDontCorrespondingDomainException();
                }
            }
        }
    }

    public String getRootDomainKey() {
        return this.getValueType().getDomainKey();
    }

    public String getNaturalLanguageClassName() {
        return "Wertart";
    }

    public void setSpecialChecks(boolean specialChecks) {
        this.mSpecialChecks = specialChecks;
    }
}

