/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.rvbea.response;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.mapper.DeuvmessagingExceptionMapper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.rvbea.dxar.RvbeaDxar;
import com.varial.personnel.domain.rvbea.dxeb.RvbeaDxeb;
import com.varial.personnel.domain.rvbea.dxeb.field.DxebField;
import com.varial.personnel.domain.rvbea.response.DxebValues;
import com.varial.personnel.domain.rvbea.response.RvbeaObstacles;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RvbeaDxebCreate {
    private static String NO_OBSTACLE = "Es wurde kein Hinderungsgrund ermittelt.";
    private final DEUVSender mDeuvSender;
    private final List<RvbeaDxar> mCreateds;

    public RvbeaDxebCreate(DEUVSender deuvSender) {
        this.mDeuvSender = deuvSender;
        this.mCreateds = new ArrayList<RvbeaDxar>();
    }

    public void createResponses(List<RvbeaDxar> dxars) throws BusinessDomainException {
        for (RvbeaDxar dxar : dxars) {
            if (!StringMapper.isNullString((String)dxar.getErrorMessage()) || dxar.isReadOnly()) continue;
            this.createResponse(dxar);
        }
    }

    public void updateResponse(RvbeaDxar dxar) throws BusinessDomainException {
        RvbeaDxeb dxebOld = dxar.getRvbeaDxeb();
        if (dxebOld != null) {
            dxar.setRvbeaDxeb(null);
            dxebOld.makeSaveable();
            dxebOld.destroy();
        }
        this.createResponse(dxar);
        if (this.isGML57(dxar) && dxar.getRvbeaDxeb() == null) {
            dxar.setErrorMessage(NO_OBSTACLE);
        }
        this.mCreateds.add(dxar);
    }

    private void createResponse(RvbeaDxar dxar) throws BusinessDomainException {
        int obstacle = RvbeaObstacles.getObstacle((RvbeaDxar)dxar);
        if (obstacle == 0) {
            if (!this.isGML57(dxar)) {
                dxar.setRvbeaDxeb(this.createCertificate(dxar));
            }
        } else {
            dxar.setRvbeaDxeb(this.createObstacle(obstacle, dxar));
        }
    }

    private RvbeaDxeb createCertificate(RvbeaDxar dxar) throws BusinessDomainException {
        Employee employee = dxar.getEmployee();
        DxebValues dxebValues = new DxebValues(employee, dxar.getEbWerte());
        ArrayList<DxebField> dxebFields = new ArrayList<DxebField>();
        LocalDate from = LocalDate.of(dxar.getEbjahrvon(), dxar.getEbmonatvon(), 1);
        LocalDate until = LocalDate.of(dxar.getEbjahrbis(), dxar.getEbmonatbis(), 1).with(TemporalAdjusters.lastDayOfMonth());
        while (from.isBefore(until)) {
            Date month = PDateHelper.toDate((LocalDate)from);
            int obstacles = RvbeaObstacles.getObstacle((Employee)employee, (Date)month);
            if (obstacles > 0) {
                DxebField dxebField = new DxebField(from.getYear(), from.getMonthValue(), 0, "Hinderungsgrund", String.valueOf(obstacles));
                dxebFields.add(dxebField);
            } else {
                dxebFields.addAll(dxebValues.getDxebFields(month));
            }
            from = from.plusMonths(1L);
        }
        RvbeaDxeb dxeb = this.createDxeb(dxar);
        for (DxebField dxebField : dxebFields) {
            dxebField.setDxeb(dxeb);
        }
        dxeb.setDxebFields(dxebFields.toArray(new DxebField[dxebFields.size()]));
        return dxeb;
    }

    public void checkDxar(RvbeaDxar dxar) throws BusinessDomainException {
        RvbeaDxeb dxeb = dxar.getRvbeaDxeb();
        if (dxeb != null && (dxeb.getAdviceState() == AdviceStateEnum.UEBERMITTELT || dxeb.getAdviceState() == AdviceStateEnum.ERFOLGREICH)) {
            throw DeuvmessagingExceptionMapper.makeDxebNotAllowedTransmittedDomainException();
        }
        if (dxar.getReason57Account() != null) {
            throw DeuvmessagingExceptionMapper.makeDxebNotAllowed57CreatedDomainException();
        }
    }

    private RvbeaDxeb createObstacle(int obstacle, RvbeaDxar dxar) {
        RvbeaDxeb dxeb = this.createDxeb(dxar);
        dxeb.setHinderungsgrund(obstacle);
        return dxeb;
    }

    private RvbeaDxeb createDxeb(RvbeaDxar dxar) {
        RvbeaDxeb dxeb = new RvbeaDxeb();
        dxeb.setBbnras(dxar.getBbnras());
        dxeb.setBbnrvu(dxar.getBbnrvu());
        dxeb.setBezugsid(dxar.getDsid());
        dxeb.setVsnr(dxar.getVsnr());
        if (dxar.getEmployee() != null) {
            dxeb.setAzvu(Deuv.toAzVerursacher((String)dxar.getEmployee().getIDString()));
        } else {
            dxeb.setAzvu(dxar.getAzvu());
        }
        dxeb.setAnfgr(dxar.getAnfgr());
        dxeb.setAnfgrvers(dxar.getAnfgrvers());
        dxeb.setDxar(dxar);
        dxeb.setDeuvSender(this.mDeuvSender);
        return dxeb;
    }

    private boolean isGML57(RvbeaDxar dxar) {
        return "GML57".equals(dxar.getAnfgr());
    }

    public List<RvbeaDxar> getCreateds() {
        return this.mCreateds;
    }
}

