/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.rvbea.response;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.MultiplyEmploymentEnum;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.tax.ChurchTaxEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.rvbea.dxeb.field.DxebField;
import com.varial.personnel.domain.rvbea.response.DxebFieldInfo;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DxebValues {
    @DxebFieldInfo(id=3, key="Eb_Bbegtag", keyPerf="EB-BBEGTAG", name="Besch\u00e4ftigungsbeginn")
    private Date mEbBbegtag;
    @DxebFieldInfo(id=4, key="Eb_Bendtag", keyPerf="EB-BENDTAG", name="Besch\u00e4ftigungsende")
    private Date mEbBendtag;
    @DxebFieldInfo(id=5, key="Persgr", keyPerf="PERSGR", name="PGS")
    private int mPersgr;
    @DxebFieldInfo(id=6, key="Bygr", keyPerf="BYGR", name="BGS")
    private String mBygr;
    @DxebFieldInfo(id=7, key="Ebv_Kipv", keyPerf="EBV-KIPV", name="PV-Zuschlag")
    private String mEbvKipv;
    @DxebFieldInfo(id=8, key="Kennzgle", keyPerf="KENNZGLE", name="Midijob")
    private String mKennzgle;
    @DxebFieldInfo(id=9, key="Nbbnrkk", keyPerf="NBBNRKK", name="BBNR Krk.")
    private String mNbbnrkk;
    @DxebFieldInfo(id=10, key="Kennzrk", keyPerf="KENNZRK", name="Rechtskreis")
    private String mKennzrk;
    @DxebFieldInfo(id=11, key="Kennzmf", keyPerf="KENNZMF", name="MfB")
    private String mKennzmf;
    @DxebFieldInfo(id=12, key="Stkl", keyPerf="STKL", name="Steuerklasse")
    private int mStkl;
    @DxebFieldInfo(id=13, key="Fkt", keyPerf="FKT", name="Steuerfaktor")
    private BigDecimal mFkt;
    @DxebFieldInfo(id=14, key="Kinfrb", keyPerf="KINFRB", name="ZKF")
    private BigDecimal mKinfrb;
    @DxebFieldInfo(id=15, key="Kzkist", keyPerf="KZKIST", name="Abzug KiSt")
    private String mKzkist;
    @DxebFieldInfo(id=16, key="Stfbja", keyPerf="STFBJA", name="Frei-/Hinzu.betrag Jahr")
    private BigDecimal mStfbja;
    @DxebFieldInfo(id=17, key="Stfbmo", keyPerf="STFBMO", name="Frei-/Hinzu.betrag Monat")
    private BigDecimal mStfbmo;
    @DxebFieldInfo(id=18, key="Sttg", keyPerf="STTG", name="Steuertage")
    private int mSttg;
    @DxebFieldInfo(id=19, key="Svtg", keyPerf="SVTG", name="SV-Tage")
    private int mSvtg;
    @DxebFieldInfo(id=20, key="Ebv_Brutto", keyPerf="EBV-BRUTTO", name="Gesamtbrutto ")
    private BigDecimal mEbvBrutto;
    @DxebFieldInfo(id=21, key="Ebv_Stbrlf", keyPerf="EBV-STBRLF", name="Steuerbrutto lfd.")
    private BigDecimal mEbvStbrlf;
    @DxebFieldInfo(id=22, key="Ebv_Stbrso", keyPerf="EBV-STBRSO", name="Steuerbrutto EGA")
    private BigDecimal mEbvStbrso;
    @DxebFieldInfo(id=23, key="Ebv_Svbrlf", keyPerf="EBV-SVBRLF", name="SV-Brutto lfd.")
    private BigDecimal mEbvSvbrlf;
    @DxebFieldInfo(id=24, key="Ebv_Svbre", keyPerf="EBV-SVBRE", name="SV-Brutto EGA")
    private BigDecimal mEbvSvbre;
    @DxebFieldInfo(id=25, key="Pst37b", keyPerf="PST37B", name="PSt-Brutto 37b")
    private BigDecimal mPst37b;
    @DxebFieldInfo(id=26, key="Pst40_1", keyPerf="PST40_1", name="PSt-Brutto 40 Abs.1 ")
    private BigDecimal mPst401;
    @DxebFieldInfo(id=27, key="Pst40_2", keyPerf="PST40_2", name="PSt-Brutto 40 Abs.2 ")
    private BigDecimal mPst402;
    @DxebFieldInfo(id=28, key="Pst40a", keyPerf="PST40A", name="PSt-Brutto 40a Abs.2 ")
    private BigDecimal mPst40a;
    @DxebFieldInfo(id=29, key="Pst40b", keyPerf="PST40B", name="PSt-Brutto 40b ")
    private BigDecimal mPst40b;
    @DxebFieldInfo(id=30, key="Pst_Sonst", keyPerf="PST_SONST", name="PSt-Brutto Sonstiges")
    private BigDecimal mPstSonst;
    @DxebFieldInfo(id=31, key="Lstlf", keyPerf="LSTLF", name="LSt lfd.")
    private BigDecimal mLstlf;
    @DxebFieldInfo(id=32, key="Lstso", keyPerf="LSTSO", name="LSt EGA")
    private BigDecimal mLstso;
    @DxebFieldInfo(id=33, key="Solilf", keyPerf="SOLILF", name="SolZ lfd.")
    private BigDecimal mSolilf;
    @DxebFieldInfo(id=34, key="Soliso", keyPerf="SOLISO", name="SolZ EGA")
    private BigDecimal mSoliso;
    @DxebFieldInfo(id=35, key="Kistlf", keyPerf="KISTLF", name="KiSt lfd.")
    private BigDecimal mKistlf;
    @DxebFieldInfo(id=36, key="Kistso", keyPerf="KISTSO", name="KiSt EGA")
    private BigDecimal mKistso;
    @DxebFieldInfo(id=37, key="Kv_Bruttolf", keyPerf="KV-BRUTTOLF", name="KV-Brutto lfd.")
    private BigDecimal mKvBruttolf;
    @DxebFieldInfo(id=38, key="Kv_Bruttoe", keyPerf="KV-BRUTTOE", name="KV-Brutto EGA")
    private BigDecimal mKvBruttoe;
    @DxebFieldInfo(id=39, key="Rv_Bruttolf", keyPerf="RV-BRUTTOLF", name="RV-Brutto lfd.")
    private BigDecimal mRvBruttolf;
    @DxebFieldInfo(id=40, key="Rv_Bruttoe", keyPerf="RV-BRUTTOE", name="RV-Brutto EGA")
    private BigDecimal mRvBruttoe;
    @DxebFieldInfo(id=41, key="Av_Bruttolf", keyPerf="AV-BRUTTOLF", name="AV-Brutto lfd.")
    private BigDecimal mAvBruttolf;
    @DxebFieldInfo(id=42, key="Av_Bruttoe", keyPerf="AV-BRUTTOE", name="AV-Brutto lfd.")
    private BigDecimal mAvBruttoe;
    @DxebFieldInfo(id=43, key="Pv_Bruttolf", keyPerf="PV-BRUTTOLF", name="PV-Brutto lfd.")
    private BigDecimal mPvBruttolf;
    @DxebFieldInfo(id=44, key="Pv_Bruttoe", keyPerf="PV-BRUTTOE", name="PV-Brutto EGA")
    private BigDecimal mPvBruttoe;
    @DxebFieldInfo(id=45, key="Kvlf", keyPerf="KVLF", name="KV-Beitrag AN lfd.")
    private BigDecimal mKvlf;
    @DxebFieldInfo(id=46, key="Kve", keyPerf="KVE", name="KV-Beitrag AN EGA")
    private BigDecimal mKve;
    @DxebFieldInfo(id=47, key="Rvlf", keyPerf="RVLF", name="RV-Beitrag AN lfd.")
    private BigDecimal mRvlf;
    @DxebFieldInfo(id=48, key="Rve", keyPerf="RVE", name="RV-Beitrag AN EGA")
    private BigDecimal mRve;
    @DxebFieldInfo(id=49, key="Avlf", keyPerf="AVLF", name="AV-Beitrag AN lfd.")
    private BigDecimal mAvlf;
    @DxebFieldInfo(id=50, key="Ave", keyPerf="AVE", name="AV-Beitrag AN EGA")
    private BigDecimal mAve;
    @DxebFieldInfo(id=51, key="Pvlf", keyPerf="PVLF", name="PV-Beitrag AN lfd.")
    private BigDecimal mPvlf;
    @DxebFieldInfo(id=52, key="Pve", keyPerf="PVE", name="PV-Beitrag AN EGA")
    private BigDecimal mPve;
    @DxebFieldInfo(id=53, key="Ebv_Netto", keyPerf="EBV-NETTO", name="Netto (gesetzl.)")
    private BigDecimal mEbvNetto;
    @DxebFieldInfo(id=54, key="Anbfkv", keyPerf="ANBFKV", name="AN-Beitrag frw. KV")
    private BigDecimal mAnbfkv;
    @DxebFieldInfo(id=55, key="Agzfkv", keyPerf="AGZFKV", name="AGZ frw./priv. KV")
    private BigDecimal mAgzfkv;
    @DxebFieldInfo(id=56, key="Agzrv", keyPerf="AGZRV", name="AG-Zuschuss BV")
    private BigDecimal mAgzrv;
    @DxebFieldInfo(id=57, key="Anbfpv", keyPerf="ANBFPV", name="AN-Beitrag frw. PV")
    private BigDecimal mAnbfpv;
    @DxebFieldInfo(id=58, key="Agzfpv", keyPerf="AGZFPV", name="AGZ frw./priv. PV")
    private BigDecimal mAgzfpv;
    @DxebFieldInfo(id=59, key="Sonett", keyPerf="SONETT", name="Sonst. Be-/Abz\u00fcge")
    private BigDecimal mSonett;
    @DxebFieldInfo(id=60, key="Austrag", keyPerf="AUSTRAG", name="Auszahlungsbetrag")
    private BigDecimal mAustrag;
    @DxebFieldInfo(id=61, key="Meldbru", keyPerf="MELDBRU", name="SV-Meldebrutto")
    private BigDecimal mMeldbru;
    private static IValuepositionDao dao = (IValuepositionDao)UtilitiesManager.getApplicationContext().getBean("valuepositionDao");
    private final Employee mEmployee;
    private final List<String> mRequestedFields;
    private final Date mEffectiveTimePoint;
    private Date mCurrentFrom;
    private Employment mEmployment;
    private Insurance mInsurance;
    private Tax mTax;

    public DxebValues(Employee employee, List<String> requestedFields) {
        this.mEmployee = employee;
        this.mRequestedFields = requestedFields;
        this.mEffectiveTimePoint = employee.getJournalizedUntil();
    }

    public List<DxebField> getDxebFields(Date validTimePoint) throws BusinessDomainException {
        this.mCurrentFrom = validTimePoint;
        this.initializeFields();
        this.fillFields();
        int ebJahr = DateHelper.toLocalDate((Date)this.mCurrentFrom).getYear();
        int ebMonat = DateHelper.toLocalDate((Date)this.mCurrentFrom).getMonthValue();
        ArrayList<DxebField> dxebFields = new ArrayList<DxebField>();
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(DxebFieldInfo.class) || !this.isRequestedField(field)) continue;
            try {
                Object result = field.get(this);
                DxebField newDxebField = new DxebField(ebJahr, ebMonat, this.getId(field), this.getKey(field), this.convert(result, this.getKey(field)));
                dxebFields.add(newDxebField);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return dxebFields;
    }

    private boolean isRequestedField(Field field) {
        return this.mRequestedFields.contains(this.getKey(field));
    }

    private final String convert(Object obj, String key) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            return DateMapper.toYYYYMMDDString((Date)((Date)obj));
        }
        if (obj instanceof BigDecimal) {
            return BigDecimalMapper.toString((BigDecimal)((BigDecimal)obj));
        }
        if (obj instanceof Integer) {
            if ("Stkl".equals(key)) {
                return String.valueOf(obj);
            }
            return String.format("%02d", obj);
        }
        return obj.toString();
    }

    private DxebFieldInfo getAnnotation(Field field) {
        return field.getAnnotation(DxebFieldInfo.class);
    }

    private int getId(Field field) {
        return this.getAnnotation(field).id();
    }

    private String getKey(Field field) {
        return this.getAnnotation(field).key();
    }

    private void initializeFields() {
        this.mEbBbegtag = null;
        this.mEbBendtag = null;
        this.mPersgr = 0;
        this.mBygr = "";
        this.mEbvKipv = "N";
        this.mKennzgle = "N";
        this.mNbbnrkk = "";
        this.mKennzrk = "";
        this.mKennzmf = "N";
        this.mStkl = 0;
        this.mFkt = BigDecimalMapper.ZERO;
        this.mKinfrb = BigDecimalMapper.ZERO;
        this.mKzkist = "N";
        this.mStfbja = BigDecimalMapper.ZERO;
        this.mStfbmo = BigDecimalMapper.ZERO;
        this.mSttg = 0;
        this.mSvtg = 0;
        this.mEbvBrutto = BigDecimalMapper.ZERO;
        this.mEbvStbrlf = BigDecimalMapper.ZERO;
        this.mEbvStbrso = BigDecimalMapper.ZERO;
        this.mEbvSvbrlf = BigDecimalMapper.ZERO;
        this.mEbvSvbre = BigDecimalMapper.ZERO;
        this.mPst37b = BigDecimalMapper.ZERO;
        this.mPst401 = BigDecimalMapper.ZERO;
        this.mPst402 = BigDecimalMapper.ZERO;
        this.mPst40a = BigDecimalMapper.ZERO;
        this.mPst40b = BigDecimalMapper.ZERO;
        this.mPstSonst = BigDecimalMapper.ZERO;
        this.mLstlf = BigDecimalMapper.ZERO;
        this.mLstso = BigDecimalMapper.ZERO;
        this.mSolilf = BigDecimalMapper.ZERO;
        this.mSoliso = BigDecimalMapper.ZERO;
        this.mKistlf = BigDecimalMapper.ZERO;
        this.mKistso = BigDecimalMapper.ZERO;
        this.mKvBruttolf = BigDecimalMapper.ZERO;
        this.mKvBruttoe = BigDecimalMapper.ZERO;
        this.mRvBruttolf = BigDecimalMapper.ZERO;
        this.mRvBruttoe = BigDecimalMapper.ZERO;
        this.mAvBruttolf = BigDecimalMapper.ZERO;
        this.mAvBruttoe = BigDecimalMapper.ZERO;
        this.mPvBruttolf = BigDecimalMapper.ZERO;
        this.mPvBruttoe = BigDecimalMapper.ZERO;
        this.mKvlf = BigDecimalMapper.ZERO;
        this.mKve = BigDecimalMapper.ZERO;
        this.mRvlf = BigDecimalMapper.ZERO;
        this.mRve = BigDecimalMapper.ZERO;
        this.mAvlf = BigDecimalMapper.ZERO;
        this.mAve = BigDecimalMapper.ZERO;
        this.mPvlf = BigDecimalMapper.ZERO;
        this.mPve = BigDecimalMapper.ZERO;
        this.mEbvNetto = BigDecimalMapper.ZERO;
        this.mAnbfkv = BigDecimalMapper.ZERO;
        this.mAgzfkv = BigDecimalMapper.ZERO;
        this.mAgzrv = BigDecimalMapper.ZERO;
        this.mAnbfpv = BigDecimalMapper.ZERO;
        this.mAgzfpv = BigDecimalMapper.ZERO;
        this.mSonett = BigDecimalMapper.ZERO;
        this.mAustrag = BigDecimalMapper.ZERO;
        this.mMeldbru = BigDecimalMapper.ZERO;
    }

    private void fillFields() throws BusinessDomainException {
        this.mEmployment = (Employment)this.mEmployee.getEmploymentHistory().getItemOrNull(this.mEffectiveTimePoint, DateHelper.getLastDayOfMonth((Date)this.mCurrentFrom));
        this.mInsurance = (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(this.mEffectiveTimePoint, DateHelper.getLastDayOfMonth((Date)this.mCurrentFrom));
        this.mTax = (Tax)this.mEmployee.getTaxHistory().getItemOrNull(this.mEffectiveTimePoint, DateHelper.getLastDayOfMonth((Date)this.mCurrentFrom));
        IEECompanyPlant eeCompanyPlant = this.getEECompanyPlant(DateHelper.getLastDayOfMonth((Date)this.mCurrentFrom));
        this.mEbBbegtag = this.mEmployment.getDateOfEntry();
        this.mEbBendtag = this.mEmployment.getDateOfWithDrawal() != null && DateHelper.between((Date)this.mEmployment.getDateOfWithDrawal(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCurrentFrom), (Date)DateHelper.getLastDayOfMonth((Date)this.mCurrentFrom)) ? this.mEmployment.getDateOfWithDrawal() : PDateHelper.toDate((LocalDate)LocalDate.parse("9999-12-31"));
        if (this.mInsurance != null) {
            this.mPersgr = this.mInsurance.getPersonGroup();
            this.mBygr = this.mInsurance.getDuesGroups();
            if (this.mInsurance.getNIChildEducation()) {
                this.mEbvKipv = "J";
            }
            if (this.mInsurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG) {
                this.mKennzgle = "J";
            }
            if (this.mInsurance.getHealthFund() != null) {
                this.mNbbnrkk = this.mInsurance.getHealthFund().getHealthFundTP(this.mEffectiveTimePoint, this.mCurrentFrom).getStandardCompanyNumber();
            }
            if (this.mInsurance.getMultiplyEmployment() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS || this.mInsurance.getMultiplyEmployment() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_OHNE_BV || this.mInsurance.getMultiplyEmployment() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS_OHNE_BV) {
                this.mKennzmf = "J";
            }
        }
        this.mKennzrk = eeCompanyPlant.getLawArea();
        if (this.mTax != null) {
            this.mStkl = this.mTax.getTaxBracket();
            this.mFkt = this.mTax.getPercentageSplit();
            this.mKinfrb = this.mTax.getChildRelief();
            if (this.mTax.getChurchTaxEE() != ChurchTaxEnum.CTE_KEIN_EINTRAG && this.mTax.getChurchTaxDeduction()) {
                this.mKzkist = "J";
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getFreeAllowanceYY())) {
                this.mStfbja = this.mTax.getFreeAllowanceYY();
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getAddAmountYY())) {
                this.mStfbja = this.mTax.getAddAmountYY();
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getFreeAllowanceMM())) {
                this.mStfbmo = this.mTax.getFreeAllowanceMM();
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTax.getAddAmountMM())) {
                this.mStfbmo = this.mTax.getAddAmountMM();
            }
        }
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()));
        filter.add(Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mEffectiveTimePoint))));
        filter.add(Restrictions.ge((String)"effectiveUntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mEffectiveTimePoint))));
        filter.add(Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mCurrentFrom))));
        filter.add(Restrictions.ge((String)"validUntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mCurrentFrom))));
        filter.add(Restrictions.le((String)"valuetypenumber", (String)"890100"));
        Order[] sort = new Order[]{Order.desc((String)"valuetypenumber")};
        PersistencyDataSet dataset = dao.getDataSet(sort, (Criterion)filter);
        while (dataset.hasNext()) {
            ValuepositionContainer valuePositionContainer = (ValuepositionContainer)dataset.getNext();
            this.fillFieldFromValuePosition(valuePositionContainer);
        }
        this.mMeldbru = BigDecimal.ZERO;
    }

    private void fillFieldFromValuePosition(ValuepositionContainer container) {
        BigDecimal result = container.results;
        if (result == null) {
            result = BigDecimalMapper.ZERO;
        }
        switch (container.valuetypenumber) {
            case 100100: {
                this.mEbvBrutto = this.mEbvBrutto.add(result);
                break;
            }
            case 101510: {
                this.mPst401 = this.mPst401.add(result);
                break;
            }
            case 101550: 
            case 101560: 
            case 101570: 
            case 101580: 
            case 101590: 
            case 101600: {
                this.mPst402 = this.mPst402.add(result);
                break;
            }
            case 101610: {
                this.mPst37b = this.mPst37b.add(result);
                break;
            }
            case 101650: 
            case 101660: 
            case 101670: 
            case 101680: {
                this.mPst40a = this.mPst40a.add(result);
                break;
            }
            case 101750: 
            case 101760: 
            case 101770: 
            case 101780: {
                this.mPst40b = this.mPst40b.add(result);
                break;
            }
            case 110100: {
                this.mEbvStbrlf = this.mEbvStbrlf.add(result);
                break;
            }
            case 110200: {
                this.mEbvStbrso = this.mEbvStbrso.add(result);
                break;
            }
            case 110590: {
                this.mSttg += container.factor1.intValue();
                break;
            }
            case 130110: {
                this.mEbvSvbrlf = this.mEbvSvbrlf.add(result);
                break;
            }
            case 130200: {
                this.mEbvSvbre = this.mEbvSvbre.add(result);
                break;
            }
            case 130590: {
                this.mSvtg += container.factor1.intValue();
                break;
            }
            case 130591: {
                this.mSvtg += result.intValue();
                break;
            }
            case 220100: {
                this.mLstlf = this.mLstlf.add(result);
                break;
            }
            case 220200: {
                this.mLstso = this.mLstso.add(result);
                break;
            }
            case 223100: {
                this.mSolilf = this.mSolilf.add(result);
                break;
            }
            case 226100: {
                this.mKistlf = this.mKistlf.add(result);
                break;
            }
            case 226200: {
                this.mKistso = this.mKistso.add(result);
                break;
            }
            case 321110: {
                this.mKvBruttolf = this.mKvBruttolf.add(result);
                break;
            }
            case 321200: {
                this.mKvBruttoe = this.mKvBruttoe.add(result);
                break;
            }
            case 322110: {
                this.mKvlf = this.mKvlf.add(result);
                break;
            }
            case 322200: {
                this.mKve = this.mKve.add(result);
                break;
            }
            case 327110: {
                this.mRvBruttolf = this.mRvBruttolf.add(result);
                break;
            }
            case 327200: {
                this.mRvBruttoe = this.mRvBruttoe.add(result);
                break;
            }
            case 328110: {
                this.mRvlf = this.mRvlf.add(result);
                break;
            }
            case 328200: {
                this.mRve = this.mRve.add(result);
                break;
            }
            case 333110: {
                this.mAvBruttolf = this.mAvBruttolf.add(result);
                break;
            }
            case 333200: {
                this.mAvBruttoe = this.mAvBruttoe.add(result);
                break;
            }
            case 334110: {
                this.mAvlf = this.mAvlf.add(result);
                break;
            }
            case 334200: {
                this.mAve = this.mAve.add(result);
                break;
            }
            case 339110: {
                this.mPvBruttolf = this.mPvBruttolf.add(result);
                break;
            }
            case 339200: {
                this.mPvBruttoe = this.mPvBruttoe.add(result);
                break;
            }
            case 340110: {
                this.mPvlf = this.mPvlf.add(result);
                break;
            }
            case 340200: {
                this.mPve = this.mPve.add(result);
                break;
            }
            case 700000: {
                this.mEbvNetto = this.mEbvNetto.add(result);
                break;
            }
            case 770000: 
            case 770005: {
                this.mAnbfkv = this.mAnbfkv.add(result);
                break;
            }
            case 770020: 
            case 770025: 
            case 770030: 
            case 770035: 
            case 770040: 
            case 770045: 
            case 770050: 
            case 770055: 
            case 770120: 
            case 770130: 
            case 770140: 
            case 770150: {
                this.mAgzfkv = this.mAgzfkv.add(result);
                break;
            }
            case 771000: {
                this.mAnbfpv = this.mAnbfpv.add(result);
                break;
            }
            case 771020: 
            case 771030: 
            case 771040: 
            case 771050: 
            case 771120: 
            case 771130: 
            case 771140: 
            case 771150: {
                this.mAgzfpv = this.mAgzfpv.add(result);
                break;
            }
            case 775050: {
                this.mAgzrv = this.mAgzrv.add(result);
                break;
            }
            case 106000: 
            case 250510: 
            case 250610: 
            case 702000: {
                this.mSonett = this.mSonett.subtract(result);
                break;
            }
            case 710020: 
            case 750210: 
            case 760000: {
                this.mSonett = this.mSonett.add(result);
                break;
            }
            case 760300: 
            case 774050: 
            case 795000: {
                this.mSonett = this.mSonett.subtract(result);
                break;
            }
            case 795002: {
                this.mSonett = this.mSonett.add(result);
                break;
            }
            case 795004: 
            case 795006: 
            case 795200: 
            case 795300: 
            case 795400: {
                this.mSonett = this.mSonett.subtract(result);
                break;
            }
            case 860000: {
                this.mSonett = this.mSonett.add(result);
                break;
            }
            case 861000: 
            case 861004: 
            case 861006: 
            case 862000: 
            case 862004: 
            case 862006: 
            case 863000: 
            case 863004: 
            case 863006: 
            case 864000: 
            case 870000: 
            case 871000: 
            case 880000: 
            case 882000: 
            case 886200: 
            case 889990: {
                this.mSonett = this.mSonett.subtract(result);
                break;
            }
            case 890000: {
                this.mAustrag = this.mAustrag.add(result);
            }
        }
    }

    private IEECompanyPlant getEECompanyPlant(Date validTimePoint) {
        IEECompanyPlant eeCompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        eeCompanyPlant.setEmployee(this.mEmployee);
        eeCompanyPlant.setEffectiveFrom(this.mEffectiveTimePoint);
        eeCompanyPlant.setValidFrom(validTimePoint);
        return eeCompanyPlant;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(", EbMonatEbBbegtag: ").append(this.mEbBbegtag);
        builder.append(", EbMonatEbBendtag: ").append(this.mEbBendtag);
        builder.append(", EbMonatPersgr: ").append(this.mPersgr);
        builder.append(", EbMonatBygr: ").append(this.mBygr);
        builder.append(", EbMonatEbvKipv: ").append(this.mEbvKipv);
        builder.append(", EbMonatKennzgle: ").append(this.mKennzgle);
        builder.append(", EbMonatNbbnrkk: ").append(this.mNbbnrkk);
        builder.append(", EbMonatKennzrk: ").append(this.mKennzrk);
        builder.append(", Kennzmf: ").append(this.mKennzmf);
        builder.append(", Stkl: ").append(this.mStkl);
        builder.append(", Fkt: ").append(this.mFkt);
        builder.append(", Kinfrb: ").append(this.mKinfrb);
        builder.append(", Kzkist: ").append(this.mKzkist);
        builder.append(", Stfbja: ").append(this.mStfbja);
        builder.append(", Stfbmo: ").append(this.mStfbmo);
        builder.append(", Sttg: ").append(this.mSttg);
        builder.append(", Svtg: ").append(this.mSvtg);
        builder.append(", EbvBrutto: ").append(this.mEbvBrutto);
        builder.append(", EbvStbrlf: ").append(this.mEbvStbrlf);
        builder.append(", EbvStbrso: ").append(this.mEbvStbrso);
        builder.append(", EbvSvbrlf: ").append(this.mEbvSvbrlf);
        builder.append(", EbvSvbre: ").append(this.mEbvSvbre);
        builder.append(", Pst37b: ").append(this.mPst37b);
        builder.append(", Pst401: ").append(this.mPst401);
        builder.append(", Pst402: ").append(this.mPst402);
        builder.append(", Pst40a: ").append(this.mPst40a);
        builder.append(", Pst40b: ").append(this.mPst40b);
        builder.append(", PstSonst: ").append(this.mPstSonst);
        builder.append(", Lstlf: ").append(this.mLstlf);
        builder.append(", Lstso: ").append(this.mLstso);
        builder.append(", Solilf: ").append(this.mSolilf);
        builder.append(", Soliso: ").append(this.mSoliso);
        builder.append(", Kistlf: ").append(this.mKistlf);
        builder.append(", Kistso: ").append(this.mKistso);
        builder.append(", KvBruttolf: ").append(this.mKvBruttolf);
        builder.append(", KvBruttoe: ").append(this.mKvBruttoe);
        builder.append(", RvBruttolf: ").append(this.mRvBruttolf);
        builder.append(", RvBruttoe: ").append(this.mRvBruttoe);
        builder.append(", AvBruttolf: ").append(this.mAvBruttolf);
        builder.append(", AvBruttoe: ").append(this.mAvBruttoe);
        builder.append(", PvBruttolf: ").append(this.mPvBruttolf);
        builder.append(", PvBruttoe: ").append(this.mPvBruttoe);
        builder.append(", Kvlf: ").append(this.mKvlf);
        builder.append(", Kve: ").append(this.mKve);
        builder.append(", Rvlf: ").append(this.mRvlf);
        builder.append(", Rve: ").append(this.mRve);
        builder.append(", Avlf: ").append(this.mAvlf);
        builder.append(", Ave: ").append(this.mAve);
        builder.append(", Pvlf: ").append(this.mPvlf);
        builder.append(", Pve: ").append(this.mPve);
        builder.append(", EbvNetto: ").append(this.mEbvNetto);
        builder.append(", Anbfkv: ").append(this.mAnbfkv);
        builder.append(", Agzfkv: ").append(this.mAgzfkv);
        builder.append(", Agzrv: ").append(this.mAgzrv);
        builder.append(", Anbfpv: ").append(this.mAnbfpv);
        builder.append(", Agzfpv: ").append(this.mAgzfpv);
        builder.append(", Sonett: ").append(this.mSonett);
        builder.append(", Austrag: ").append(this.mAustrag);
        builder.append(", Meldbru: ").append(this.mMeldbru);
        return builder.toString();
    }
}

