/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetaxperemployee;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.personnel.domain.companyplant.CompanyPlantCommunication;
import com.varial.personnel.domain.companyplant.GeneralTaxOffice;
import com.varial.personnel.domain.companyplant.RegistrationPeriodEnum;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.SortCriteriaEnum;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.ErrorReportBean;
import com.varial.personnel.domain.reports.library.ErrorReportFactory;
import com.varial.personnel.domain.reports.library.ReporBeanSortComparator;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.ReportValues;
import com.varial.personnel.domain.reports.mapper.PaymentExceptionMapper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.wagetax.RetroActiveTreatmentEnum;
import com.varial.personnel.domain.reports.wagetax.WageTaxEmployeeBean;
import com.varial.personnel.domain.reports.wagetaxperemployee.ChurchTaxExpression;
import com.varial.personnel.domain.reports.wagetaxperemployee.EmployeeChurchTaxExpression;
import com.varial.personnel.domain.reports.wagetaxperemployee.WTPerEmployeeSplitChurchTaxPauschSubReportBean;
import com.varial.personnel.domain.reports.wagetaxperemployee.WTPerEmployeeSplitChurchTaxtLfdSBZSubReportBean;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeBean;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeHelper;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeReportBean;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeReportSortComparator;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeValuePositionFactory;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.persistency.calculation.calculationbasic.ICalculationbasicDao;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.DatabaseExceptionStruct;
import com.varial.serverbase.query.PutDataException;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;

public class WageTaxPerEmployeeReportDataSource
implements JRDataSource {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("userPersistencyManager", IUserPersistencyManager.class);
    private static final String error_1 = "1*: Mitarbeiter hat keine Besteuerungsdaten ";
    private static final String error_2 = "2*: Mitarbeiter hat keine Werte";
    private static final String error_3 = "3*: Mitarbeiter ohne Steuerklasse, weder pauschal KfB (25%), GfB (20%), noch Aushilfskraft in Land und Forstwirtschaft (5%)";
    private static final String error_4 = "4*: Mitarbeiter hat keine Wertpositionen (1015-(10,50,60,70,80,90),101600,1017-(50,60,70))";
    private String error_5 = "";
    private final ISpecialAccessPersistencyContext mSpecialAccessPersistencyContext;
    protected RegistrationPeriodEnum mAnmeldezeitraum = RegistrationPeriodEnum.RPE_MONATLICH;
    protected String mStaticText_internalUse = "";
    protected ReportValues mReportValues;
    protected String mVersion;
    protected PCompany mEePCompany;
    private Date mCalculationStartDate;
    protected Iterator<WageTaxEmployeeBean> mEmployeeWageTaxEFRit;
    protected WageTaxEmployeeBean mEWT;
    protected WageTaxEmployeeBean mEWTNext;
    private boolean LSJA = false;
    private boolean LSJATemp = false;
    protected boolean mPayment;
    protected boolean mInternalUse;
    private boolean mSecondChurchTaxFooter = false;
    private boolean mAndruckMonat = false;
    private String FIELD_seitenwechsel = "Seitenwechesl_1";
    protected String mCurrentOidPCompany = "";
    protected int FIELD_zahl_an = 0;
    protected int FIELD_zahl_an_bav = 0;
    protected static final String[] mValueTypeNumbers = new String[]{"101510", "101550", "101560", "101570", "101580", "101590", "101600", "101750", "101760", "101770", "101000", "101680", "110000", "220100", "220200", "223100", "223200", "226100", "226200", "227100", "227200", "250510", "710510", "710520", "710620", "710610", "760100", "760110", "760120", "760130", "760400", "760410", "760420", "760430", "760450", "760460", "760470", "760480", "220050", "223050", "226050", "227050", "250610", "760010", "728300", "728800", "101610", "760500", "760600", "102590"};
    private static final String[] mVTNumberForRegarded = new String[]{"101510", "101550", "101560", "101570", "101580", "101590", "101600", "101750", "101760", "101770"};
    private static final String[] mVTNumberForArbeitsKammer = new String[]{"250510", "250610"};
    protected Date mForEffectiveDate;
    protected Date mEffectiveDateEPP;
    protected Date mForValidDate;
    protected Date mListFirstDate;
    protected Date mListEndDate;
    protected Date mField_monat_jahr;
    protected Date mVersatzMonat;
    protected String mUserString = "";
    protected User mUser;
    protected String FIELD_jahr = "";
    private String FIELD_jahr_zusatz = "";
    private String FIELD_monat = "";
    private String FIELD_anmeldezeitraum = "";
    protected String FIELD_steuernummer = "";
    protected String mEmployerFinanzamtBezeichnung = "";
    private String FIELD_finanzamt_nr = "";
    protected String FIELD_arbeitgeber_bezeichnung = "";
    protected String FIELD_pcompany_plant_key = "";
    protected String FIELD_finanzamt_bezeichnung = "";
    private String church_1_long_text = "";
    private String church_2_long_text = "";
    private String church_3_long_text = "";
    private String church_4_long_text = "";
    private String church_5_long_text = "";
    private String church_6_long_text = "";
    private String church_7_long_text = "";
    private String church_1_value = "";
    private String church_2_value = "";
    private String church_3_value = "";
    private String church_4_value = "";
    private String church_5_value = "";
    private String church_6_value = "";
    private String church_7_value = "";
    private String church_1_short_text = "";
    private String church_2_short_text = "";
    private String church_3_short_text = "";
    private String church_4_short_text = "";
    private String church_5_short_text = "";
    private String church_6_short_text = "";
    private String church_7_short_text = "";
    private BigDecimal church_1_summ = BigDecimal.ZERO;
    private BigDecimal church_2_summ = BigDecimal.ZERO;
    private BigDecimal church_3_summ = BigDecimal.ZERO;
    private BigDecimal church_4_summ = BigDecimal.ZERO;
    private BigDecimal church_5_summ = BigDecimal.ZERO;
    private BigDecimal church_6_summ = BigDecimal.ZERO;
    private BigDecimal church_7_summ = BigDecimal.ZERO;
    private BigDecimal FIELD_pausch_brutto = BigDecimal.ZERO;
    private BigDecimal FIELD_lst_lfd = BigDecimal.ZERO;
    private BigDecimal FIELD_lst_pau = BigDecimal.ZERO;
    private BigDecimal FIELD_lst_son = BigDecimal.ZERO;
    private BigDecimal FIELD_lst_zwi_su = BigDecimal.ZERO;
    private BigDecimal FIELD_soli_lfd = BigDecimal.ZERO;
    private BigDecimal FIELD_soli_pau = BigDecimal.ZERO;
    private BigDecimal FIELD_soli_son = BigDecimal.ZERO;
    private BigDecimal FIELD_soli_zwi_su = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_lfd = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_pau = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_son = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_zwi_su = BigDecimal.ZERO;
    private BigDecimal FIELD_st_pfl = BigDecimal.ZERO;
    private BigDecimal FIELD_summe_an_st = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_lst_zwi_su = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_soli_zwi_su = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_kist_zwi_su = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_lst_informativ = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_soli_informativ = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_kist_informativ = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_kist_informativ_an = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_kist_informativ_eg = BigDecimal.ZERO;
    private BigDecimal FIELD_summe_erst = BigDecimal.ZERO;
    private BigDecimal FIELD_ak = BigDecimal.ZERO;
    private BigDecimal FIELD_kindergeld = BigDecimal.ZERO;
    private BigDecimal FIELD_energiepreispauschale = BigDecimal.ZERO;
    private BigDecimal FIELD_foederbetrag_bav = BigDecimal.ZERO;
    private int employeeLSTJA_aschluss = 0;
    private BigDecimal FIELD_kist_lfd_an = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_pau_an = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_son_an = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_kist_zwi_su_an = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_lfd_eg = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_pau_eg = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_son_eg = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_kist_zwi_su_eg = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_pau_ver = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_pau_ver_bis_2006_rk = BigDecimal.ZERO;
    private BigDecimal FIELD_kist_pau_ver_bis_2006_ev = BigDecimal.ZERO;
    private String FIELD_kist_an = "";
    private String FIELD_kist_eg = "";
    private BigDecimal FIELD_pausch_brutto_37b = BigDecimal.ZERO;
    private BigDecimal summe_lst_lfd = BigDecimal.ZERO;
    private BigDecimal summe_lst_pau = BigDecimal.ZERO;
    private BigDecimal summe_lst_son = BigDecimal.ZERO;
    private BigDecimal summe_lst_zwi_su = BigDecimal.ZERO;
    private BigDecimal summe_soli_lfd = BigDecimal.ZERO;
    private BigDecimal summe_soli_pau = BigDecimal.ZERO;
    private BigDecimal summe_soli_son = BigDecimal.ZERO;
    private BigDecimal summe_soli_zwi_su = BigDecimal.ZERO;
    private BigDecimal summe_kist_lfd = BigDecimal.ZERO;
    private BigDecimal summe_kist_pau = BigDecimal.ZERO;
    private BigDecimal summe_kist_pau_ver = BigDecimal.ZERO;
    private BigDecimal summe_kist_son = BigDecimal.ZERO;
    private BigDecimal summe_kist_zwi_su = BigDecimal.ZERO;
    private BigDecimal summe_ak = BigDecimal.ZERO;
    private BigDecimal summe_summe_an = BigDecimal.ZERO;
    private BigDecimal summe_lja_lst = BigDecimal.ZERO;
    private BigDecimal summe_lja_soli = BigDecimal.ZERO;
    private BigDecimal summe_lja_kist = BigDecimal.ZERO;
    private BigDecimal summe_summe_lja = BigDecimal.ZERO;
    private BigDecimal summe_ergebnis_lst = BigDecimal.ZERO;
    private BigDecimal summe_ergebnis_soli = BigDecimal.ZERO;
    private BigDecimal summe_ergebnis_kist = BigDecimal.ZERO;
    private BigDecimal summe_summe_ergebnis = BigDecimal.ZERO;
    private BigDecimal summe_kindergeld = BigDecimal.ZERO;
    private BigDecimal summe_foederbetrag_bav = BigDecimal.ZERO;
    private boolean summe_kg_groesseres_feld = false;
    private String mParameterStaticText_PersonnelNumber = "";
    private String mParameterStaticText_NameSurname = "";
    private String mParameterStaticText_StPflBrutto = "";
    private String mParameterStaticText_PauschBrutto = "";
    private String mParameterStaticText_LstLfd = "";
    private String mParameterStaticText_LstSbz = "";
    private String mParameterStaticText_LstPausch = "";
    private String mParameterStaticText_Lst = "";
    private String mParameterStaticText_SolzLfd = "";
    private String mParameterStaticText_SolzSbz = "";
    private String mParameterStaticText_SolzPausch = "";
    private String mParameterStaticText_Solz = "";
    private String mParameterStaticText_KistLfd = "";
    private String mParameterStaticText_KistSbz = "";
    private String mParameterStaticText_KistPausch = "";
    private String mParameterStaticText_Kist = "";
    private String mParameterStaticText_Summ = "";
    private String mParameterStaticText_KiGeld = "";
    private String mParameter_ReportTitle_value = "";
    private String mParameterStaticText_CompanyTitle_value = "";
    private String mParameterStaticText_CurrencyTitle = "";
    private String mParameterStaticText_DateTitle = "";
    private String mParameterStaticText_UserTitle = "";
    private String mParameterStaticText_PageTitle = "";
    private final List<WageTaxPerEmployeeReportBean> mSubreportCollection = new LinkedList<WageTaxPerEmployeeReportBean>();
    private final List<WageTaxPerEmployeeReportBean> mSubreportCollectionTemp = new LinkedList<WageTaxPerEmployeeReportBean>();
    protected String mFirstFilterKammerBeitragOidPlant = "";
    protected boolean mUsePerfidia;
    private RetroActiveTreatmentEnum mRetroActiveType;
    private boolean mChurchTaxSplit = false;
    protected final Map<String, List<String>> mEmployeePersonnelNumberHM = new HashMap<String, List<String>>();
    protected List<WageTaxEmployeeBean> mWageTaxEmployeesBeanLi = new LinkedList<WageTaxEmployeeBean>();
    protected List<ErrorReportBean> mWageTaxErrorLi = new LinkedList<ErrorReportBean>();
    private final JasperReport mErrorEmployeeSubJasperReport;
    private String mErrorReportDescription = "";
    protected ErrorReportFactory mErrorReportFactory = new ErrorReportFactory();
    private final List<String> mErrorList;
    private EmployeeForReportGenerator generator;
    private ReportSortStruct[] mSorts;
    private final AllCallback mCallback;
    protected boolean mSecondRun;
    protected boolean mHatKammerbeitrag;
    protected boolean mIsSuperiorForConsolidation;
    protected boolean mBerichtigungEPP = false;
    boolean mIsEPPMonat = false;
    protected BigDecimal mEPPAktuellerMonat = BigDecimal.ZERO;
    protected BigDecimal mEPPVormonatMonat = BigDecimal.ZERO;
    protected PCompany mPCompanyForConsolidation;
    protected WageTaxPerEmployeeHelper mWageTaxPerEmployeeHelper;
    private ReportHelper mReportHelper;
    protected final ProgressBarUpdater mProgressBar;
    private int mCountEmployeeWageTaxEFRit;
    private static ICalculationbasicDao daoCalculationbasic = (ICalculationbasicDao)UtilitiesManager.getApplicationContext().getBean("calculationbasicDao");

    public WageTaxPerEmployeeReportDataSource(AllCallback callback, ISpecialAccessPersistencyContext sapc, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, boolean payment, boolean usePerfidia, boolean internalUse, boolean churchTaxSplit, List<String> errorList, ProgressBarUpdater progressBar) throws BusinessDomainException, PutDataException {
        this.mCallback = callback;
        this.mErrorList = errorList;
        this.mSpecialAccessPersistencyContext = sapc;
        this.mUserString = SessionContext.getInstance().getSession().getUserCode();
        this.mChurchTaxSplit = churchTaxSplit;
        this.mProgressBar = progressBar;
        this.mCountEmployeeWageTaxEFRit = 0;
        this.mErrorEmployeeSubJasperReport = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/reports/ErrorLandscapeSubReport.jrxml");
        this.mErrorReportDescription = "Einzelliste Lohnsteueranmeldung";
        this.startWorking(firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, forValidDate, payment, usePerfidia, internalUse);
    }

    public WageTaxPerEmployeeReportDataSource(AllCallback callback, ISpecialAccessPersistencyContext sapc, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, boolean payment, boolean usePerfidia, boolean internalUse, RetroActiveTreatmentEnum retroActiveType, List<String> errorList, ProgressBarUpdater progressBar) throws BusinessDomainException, PutDataException {
        this.mCallback = callback;
        this.mRetroActiveType = retroActiveType;
        this.mSpecialAccessPersistencyContext = sapc;
        this.mUserString = SessionContext.getInstance().getSession().getUserCode();
        this.mErrorList = errorList;
        this.mProgressBar = progressBar;
        this.mCountEmployeeWageTaxEFRit = 0;
        this.mErrorReportDescription = "Lohnsteueranmeldung";
        this.mErrorEmployeeSubJasperReport = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/reports/ErrorPortraitSubReport.jrxml");
        this.startWorking(firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, forValidDate, payment, usePerfidia, internalUse);
    }

    protected void initWageTaxReportDataSourceWork(boolean usePerfidia, String perfidiaPath) throws BusinessDomainException {
    }

    private void startWorking(ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, boolean payment, boolean usePerfidia, boolean internalUse) throws BusinessDomainException, PutDataException {
        String oidPCompany;
        this.mSorts = sorts;
        this.mUser = userPersistencyManager.query(this.mUserString);
        this.mVersion = Version.getVersion();
        this.mPayment = payment;
        this.mForValidDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        if (firstFilter != null) {
            oidPCompany = firstFilter.oidPCompany;
        } else if (secondFilters != null) {
            oidPCompany = secondFilters[0].oidPCompany;
        } else if (thirdFilter != null) {
            oidPCompany = thirdFilter.oidPCompany;
        } else {
            throw new IllegalArgumentException();
        }
        PCompany pCompany = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
        if (pCompany.getIsSuperiorForConsolidation()) {
            oidPCompany = pCompany.getSuperiorCompanyForConsolidation().getObjectid();
        }
        this.mReportValues = new ReportValues();
        GeneralTaxOffice generalTaxOffice = this.mReportValues.getPCompanyGeneralTaxOfficeTP(oidPCompany, forEffectiveDate, forValidDate);
        switch (generalTaxOffice.getOffsetInMonths().value()) {
            case 1: {
                this.mVersatzMonat = this.mForValidDate;
                this.FIELD_jahr_zusatz = "";
                break;
            }
            case 0: {
                this.mVersatzMonat = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
                this.FIELD_jahr_zusatz = " aus Abrechnung " + ReportHelper.getMonthDescription((int)new VDate(this.mForValidDate).getMonth()) + " " + DateMapper.toYYYYString((Date)this.mForValidDate);
                break;
            }
            case 2: {
                this.mVersatzMonat = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate));
                this.FIELD_jahr_zusatz = " aus Abrechnung " + ReportHelper.getMonthDescription((int)new VDate(this.mForValidDate).getMonth()) + " " + DateMapper.toYYYYString((Date)this.mForValidDate);
            }
        }
        if (generalTaxOffice.getRegistrationPeriod() == RegistrationPeriodEnum.RPE_MONATLICH && DateHelper.equal((Date)DateHelper.getLastDayOfMonth((Date)this.mVersatzMonat), (Date)new VDate(2022, 7, 31).getDate())) {
            this.mIsEPPMonat = true;
        } else if (generalTaxOffice.getRegistrationPeriod() == RegistrationPeriodEnum.RPE_VIERTELJAEHRLICH && DateHelper.equal((Date)DateHelper.getLastDayOfMonth((Date)this.mVersatzMonat), (Date)new VDate(2022, 8, 30).getDate())) {
            this.mIsEPPMonat = true;
        } else if (generalTaxOffice.getRegistrationPeriod() == RegistrationPeriodEnum.RPE_JAEHRLICH && DateHelper.equal((Date)DateHelper.getLastDayOfMonth((Date)this.mVersatzMonat), (Date)new VDate(2022, 11, 31).getDate())) {
            this.mIsEPPMonat = true;
        }
        if (this.mIsEPPMonat && DateHelper.after((Date)forEffectiveDate, (Date)DateHelper.getLastDayOfMonth((Date)forValidDate)) && DateHelper.beforeOrEqual((Date)forEffectiveDate, (Date)new VDate(2023, 0, 31).getDate())) {
            this.mBerichtigungEPP = true;
            this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
            this.mEffectiveDateEPP = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
            this.error_5 = "5*: Mitarbeiter ist nicht bis einschlie\u00dflich Wirksamkeitsmonat journalisiert";
        } else {
            this.mEffectiveDateEPP = this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
            this.error_5 = "5*: Mitarbeiter ist nicht bis einschlie\u00dflich G\u00fcltigkeitsmonat journalisiert";
        }
        this.mInternalUse = internalUse;
        this.mUsePerfidia = usePerfidia;
        this.mWageTaxPerEmployeeHelper = (WageTaxPerEmployeeHelper)UtilitiesManager.getBean((String)"wageTaxPerEmployeeHelper", WageTaxPerEmployeeHelper.class);
        this.mWageTaxPerEmployeeHelper.initHelper(this.mForEffectiveDate, this.mForValidDate);
        this.mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
        this.generator = this.mBerichtigungEPP ? new EmployeeForReportGenerator(this.mSpecialAccessPersistencyContext, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, DateHelper.getFirstDayOfMonth((Date)this.mForValidDate), DateHelper.getLastDayOfMonth((Date)forEffectiveDate), this.mErrorList) : new EmployeeForReportGenerator(this.mSpecialAccessPersistencyContext, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, DateHelper.getFirstDayOfMonth((Date)this.mForValidDate), DateHelper.getLastDayOfMonth((Date)this.mForValidDate), this.mErrorList);
        EmployeeForReport[] efrs = this.generator.getEmployeesForReport();
        this.mCurrentOidPCompany = this.generator.getPCompanyForSettings().getObjectid();
        this.mIsSuperiorForConsolidation = this.generator.isSuperiorForConsolidation();
        if (this.mIsSuperiorForConsolidation) {
            this.mPCompanyForConsolidation = this.generator.getPCompany();
        }
        this.mEePCompany = this.generator.getPCompanyForSettings();
        String perfidiaPath = this.mReportValues.getCompanyTaxOfficePerfidiaPath(this.mCurrentOidPCompany, this.mForEffectiveDate, this.mForValidDate);
        this.mCalculationStartDate = this.mReportHelper.getCalculationStartDate(this.mEePCompany.getCompanyFoundations(this.mForEffectiveDate, this.mForValidDate));
        this.initWageTaxReportDataSourceWork(usePerfidia, perfidiaPath);
        this.handlingEmployeeForReportError();
        if (firstFilter != null && !firstFilter.oidPlant.equals("")) {
            this.mFirstFilterKammerBeitragOidPlant = firstFilter.oidPlant;
        }
        LinkedList<EmployeeForReport> employeesLi = new LinkedList<EmployeeForReport>();
        LinkedList<String> oidEmployees = new LinkedList<String>();
        for (int i = 0; i < efrs.length; ++i) {
            if (oidEmployees.contains(efrs[i].getOidEmployee())) continue;
            oidEmployees.add(efrs[i].getOidEmployee());
            employeesLi.add(efrs[i]);
            String oidPlant = efrs[i].getOidPlant();
            if (oidPlant.length() > 0) {
                GeneralTaxOffice plantTaxOffice = this.mReportValues.getPlantGeneralTaxOfficeTP(oidPlant, this.mForEffectiveDate, this.mForValidDate);
                efrs[i].setTaxOffice(plantTaxOffice == null ? generalTaxOffice : plantTaxOffice);
                continue;
            }
            efrs[i].setTaxOffice(generalTaxOffice);
        }
        this.getOverSteuerungsModulEmployeeBeans(employeesLi);
        this.sortEmployeeBeans();
        if (this.mErrorReportFactory.isFilled()) {
            String perfidiaMessage = "";
            if (this.mUsePerfidia) {
                perfidiaMessage = "im Druckmodus";
            }
            String message = "M\u00f6gliche fehlerhafte Daten sind vorhanden\nSiehe Fehlerprotokoll " + perfidiaMessage;
            this.setException(message, message);
            if (!this.mInternalUse) {
                this.mWageTaxEmployeesBeanLi.clear();
            }
        } else if (this.mWageTaxEmployeesBeanLi.isEmpty()) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        if (!this.mWageTaxEmployeesBeanLi.isEmpty()) {
            this.mCountEmployeeWageTaxEFRit = this.mWageTaxEmployeesBeanLi.size();
            this.mEmployeeWageTaxEFRit = this.mWageTaxEmployeesBeanLi.iterator();
            this.addEmployees(this.mWageTaxEmployeesBeanLi);
            this.getFirstNext();
        }
        this.resetDataEmployee();
        this.resetDataSumme();
        this.initParameters();
    }

    protected boolean handleRegistrationPeriodSettings(GeneralTaxOffice generalTaxOffice) {
        this.mAnmeldezeitraum = generalTaxOffice.getRegistrationPeriod();
        switch (this.mAnmeldezeitraum.value()) {
            case 0: {
                this.mListFirstDate = DateHelper.getFirstDayOfMonth((Date)this.mForValidDate);
                this.mListFirstDate = DateHelper.before((Date)this.mListFirstDate, (Date)this.mCalculationStartDate) ? this.mCalculationStartDate : this.mListFirstDate;
                this.mListEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
                this.mAndruckMonat = false;
                this.FIELD_monat = ReportHelper.getMonthDescription((int)new VDate(this.mVersatzMonat).getMonth());
                this.FIELD_jahr = DateMapper.toYYYYString((Date)this.mVersatzMonat);
                this.mField_monat_jahr = this.mVersatzMonat;
                this.FIELD_anmeldezeitraum = StringMapper.fillUpWithZero((String)Integer.toString(new VDate(this.mVersatzMonat).getMonth() + 1), (int)2);
                break;
            }
            case 1: {
                if (DateHelper.getMonth((Date)this.mForValidDate) != 2 && DateHelper.getMonth((Date)this.mForValidDate) != 5 && DateHelper.getMonth((Date)this.mForValidDate) != 8 && DateHelper.getMonth((Date)this.mForValidDate) != 11) {
                    return false;
                }
                this.mListFirstDate = DateHelper.getFirstDayOfMonth((Date)DateHelper.getFirstDayOfQuartal((Date)this.mForValidDate));
                this.mListFirstDate = DateHelper.before((Date)this.mListFirstDate, (Date)this.mCalculationStartDate) ? this.mCalculationStartDate : this.mListFirstDate;
                this.mListEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
                this.mAndruckMonat = true;
                if (DateHelper.getMonth((Date)this.mForValidDate) == 2) {
                    this.FIELD_anmeldezeitraum = "41";
                    this.FIELD_monat = "1. Quartal";
                } else if (DateHelper.getMonth((Date)this.mForValidDate) == 5) {
                    this.FIELD_anmeldezeitraum = "42";
                    this.FIELD_monat = "2. Quartal";
                } else if (DateHelper.getMonth((Date)this.mForValidDate) == 8) {
                    this.FIELD_anmeldezeitraum = "43";
                    this.FIELD_monat = "3. Quartal";
                } else if (DateHelper.getMonth((Date)this.mForValidDate) == 11) {
                    this.FIELD_anmeldezeitraum = "44";
                    this.FIELD_monat = "4. Quartal";
                }
                this.FIELD_jahr = DateMapper.toYYYYString((Date)this.mForValidDate);
                this.mField_monat_jahr = this.mForValidDate;
                break;
            }
            case 2: {
                if (DateHelper.getMonth((Date)this.mForValidDate) != 11) {
                    return false;
                }
                this.mListFirstDate = DateHelper.getFirstDayOfMonth((Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate));
                this.mListFirstDate = DateHelper.before((Date)this.mListFirstDate, (Date)this.mCalculationStartDate) ? this.mCalculationStartDate : this.mListFirstDate;
                this.mListEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
                this.mAndruckMonat = true;
                this.FIELD_monat = "";
                this.FIELD_jahr = DateMapper.toYYYYString((Date)this.mForValidDate);
                this.mField_monat_jahr = this.mForValidDate;
                this.FIELD_anmeldezeitraum = "19";
            }
        }
        return true;
    }

    protected void sortEmployeeBeans() throws BusinessDomainException {
        int[] intArray = new int[4];
        boolean sortierenNachPnr = true;
        boolean sortierenNachAGSchluessel = true;
        for (ReportSortStruct sort : this.mSorts) {
            if (sort.criteria == SortCriteriaEnum.SCE_plant) {
                boolean bl = sortierenNachAGSchluessel = sort.key;
            }
            if (sort.criteria != SortCriteriaEnum.SCE_employee) continue;
            sortierenNachPnr = sort.key;
        }
        intArray[0] = sortierenNachAGSchluessel ? 16 : 0;
        intArray[1] = sortierenNachPnr ? 1 : 13;
        intArray[2] = 2;
        intArray[3] = 3;
        Collections.sort(this.mWageTaxEmployeesBeanLi, new WageTaxPerEmployeeReportSortComparator(intArray));
    }

    private void getFirstNext() {
        if (this.mEmployeeWageTaxEFRit.hasNext()) {
            this.mEWTNext = this.mEmployeeWageTaxEFRit.next();
        }
    }

    private void handlingEmployeeForReportError() throws BusinessDomainException {
        if (!this.mErrorList.isEmpty()) {
            String[] names = this.mErrorList.toArray(new String[this.mErrorList.size()]);
            this.mErrorList.clear();
            BusinessDomainException e = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(names);
            if (this.mInternalUse) {
                this.mCallback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)e));
            } else {
                throw e;
            }
        }
    }

    protected void getOverSteuerungsModulEmployeeBeans(List<EmployeeForReport> employeesLi) throws BusinessDomainException, PutDataException {
        this.mProgressBar.setTotal(employeesLi.size());
        for (EmployeeForReport currentEmployee : employeesLi) {
            this.mProgressBar.update(currentEmployee.getPCompanyKey() + " / " + currentEmployee.getPersonnelNumber());
            if (!this.handleRegistrationPeriodSettings(currentEmployee.getTaxOffice())) continue;
            Date currentEmployeeValidFromDate = DateHelper.getFirstDayOfMonth((Date)this.mListFirstDate);
            Date currentEmployeeValidUntilDate = DateHelper.getLastDayOfMonth((Date)this.mListFirstDate);
            Date effectiveDate = currentEmployeeValidFromDate;
            Date dateOfWithDrawal = currentEmployee.getDateOfWithDrawal();
            if (this.mBerichtigungEPP && dateOfWithDrawal != null && DateHelper.before((Date)dateOfWithDrawal, (Date)currentEmployeeValidFromDate)) {
                Employment employeeTaxContainer = this.mReportValues.getEmployeeEmploymentTP(currentEmployee.getOidEmployee(), this.mEffectiveDateEPP, this.mEffectiveDateEPP);
                dateOfWithDrawal = employeeTaxContainer.getDateOfWithDrawal();
            }
            while (DateHelper.before((Date)currentEmployeeValidFromDate, (Date)this.mListEndDate)) {
                boolean useEmployee = dateOfWithDrawal != null ? (DateHelper.before((Date)dateOfWithDrawal, (Date)currentEmployeeValidFromDate) ? this.hasCalculationbasics(currentEmployee.getOidEmployee(), effectiveDate, currentEmployeeValidFromDate) : true) : true;
                if (useEmployee) {
                    TaxContainer employeeTaxContainer = this.mReportValues.getEmployeeTaxContainer(currentEmployee.getOidEmployee(), effectiveDate, currentEmployeeValidFromDate);
                    if (employeeTaxContainer == null && !this.mBerichtigungEPP) {
                        if (this.mInternalUse) {
                            String employerDescription = this.mReportValues.getCompanyLongDescription(currentEmployee.getOidPCompany(), effectiveDate, currentEmployeeValidFromDate);
                            this.mErrorReportFactory.addErrorMessageEmployeeToEmployer(currentEmployee.getOidPCompany(), employerDescription, 1, "1* G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)currentEmployeeValidFromDate), currentEmployee, currentEmployeeValidFromDate);
                        }
                        currentEmployeeValidFromDate = DateHelper.tomorrow((Date)currentEmployeeValidUntilDate);
                        currentEmployeeValidUntilDate = DateHelper.getLastDayOfMonth((Date)currentEmployeeValidFromDate);
                        effectiveDate = currentEmployeeValidFromDate;
                        continue;
                    }
                    int index = this.mWageTaxPerEmployeeHelper.getRunIndex(currentEmployee, effectiveDate, currentEmployeeValidUntilDate);
                    this.mHatKammerbeitrag = index == 2;
                    for (int i = 1; i <= index; ++i) {
                        this.mSecondRun = i == 2;
                        this.getEmployeeBeans(currentEmployee, effectiveDate, currentEmployeeValidFromDate, currentEmployeeValidUntilDate);
                    }
                }
                currentEmployeeValidFromDate = DateHelper.tomorrow((Date)currentEmployeeValidUntilDate);
                currentEmployeeValidUntilDate = DateHelper.getLastDayOfMonth((Date)currentEmployeeValidFromDate);
                effectiveDate = currentEmployeeValidFromDate;
            }
        }
    }

    protected void getEmployeeBeans(EmployeeForReport currentEmployee, Date effectiveDate, Date currentEmployeeValidFromDate, Date currentEmployeeValidUntilDate) throws BusinessDomainException {
        this.getWageBean(currentEmployee, effectiveDate, currentEmployeeValidFromDate, currentEmployeeValidUntilDate);
        this.getRetroactiveCorrektionBean(currentEmployee.getOidEmployee(), effectiveDate, currentEmployeeValidUntilDate);
    }

    private void getWageBean(EmployeeForReport currentEmployee, Date effectiveDate, Date currentEmployeeValidFromDate, Date currentEmployeeValidUntilDate) throws BusinessDomainException {
        WageTaxEmployeeBean eWT = this.getEmployeeProperties(currentEmployee, effectiveDate, currentEmployeeValidFromDate, currentEmployeeValidUntilDate);
        Date checkDate = this.mForValidDate;
        if (this.mBerichtigungEPP) {
            checkDate = this.mEffectiveDateEPP;
        }
        if (DateHelper.after((Date)checkDate, (Date)eWT.getJournalizeduntil()) && !this.mSecondRun && !this.mInternalUse) {
            this.mErrorReportFactory.addErrorMessageEmployeeToEmployer(eWT.getOidPCompany(), 5, "5* G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)checkDate), eWT);
        }
        if (this.employeeToBeRegarded(eWT)) {
            eWT.setValidDate(currentEmployeeValidUntilDate);
            eWT.setEmployeeStartDate(currentEmployeeValidFromDate);
            eWT.setEmployeeEndDate(currentEmployeeValidUntilDate);
            this.resetDataEmployee();
            this.getDataFor(eWT, false);
            this.setBigDecimalValues(eWT);
            if (!this.areFieldsValuesZero(eWT)) {
                eWT.setOnlyForReturnCalculation(false);
            } else {
                eWT.setOnlyForReturnCalculation(true);
            }
            eWT.setAnmeldezeitraumMonatBez(this.FIELD_monat);
            eWT.setAnmeldezeitraumMonatZahl(this.FIELD_anmeldezeitraum);
            eWT.setAndruckMonat(this.mAndruckMonat);
            eWT.setStatus("z");
            if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)eWT.getSt_pfl()) && BigDecimalMapper.isZeroOrNull((BigDecimal)eWT.getPausch_brutto()) && BigDecimalMapper.isZeroOrNull((BigDecimal)eWT.getEnergiepreispauschale()) && eWT.isWithDrawal())) {
                if (StringMapper.equal((String)eWT.getLicense(), (String)"AK")) {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)eWT.getAk())) {
                        this.mWageTaxEmployeesBeanLi.add(eWT);
                    }
                } else if (!this.mHatKammerbeitrag || this.mSecondRun) {
                    this.mWageTaxEmployeesBeanLi.add(eWT);
                }
            }
        }
    }

    private void getRetroactiveCorrektionBean(String oidEmployee, Date effectiveDate, Date validDate) throws BusinessDomainException {
        if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate), (Date)DateHelper.getFirstDayOfMonth((Date)validDate))) {
            Date journalizedUntil = this.mReportValues.getEmployeeJournalizedUntil(oidEmployee);
            boolean isToMakeRA = false;
            if (this.mInternalUse) {
                isToMakeRA = true;
            }
            if (!this.mInternalUse && ReportHelper.getDiffInMonths((Date)DateHelper.getFirstDayOfMonth((Date)journalizedUntil), (Date)DateHelper.getFirstDayOfMonth((Date)validDate)) >= 0) {
                isToMakeRA = true;
            }
            if (isToMakeRA) {
                Date rCValidFrom = ReportEmployeesHandlingHelper.getRetroactiveCorrectionDate((String[])new String[]{oidEmployee}, (Date)effectiveDate, (Date)DateHelper.getFirstDayOfMonth((Date)validDate), (Date)this.mCalculationStartDate);
                rCValidFrom = DateHelper.getFirstDayOfMonth((Date)rCValidFrom);
                if (DateHelper.afterOrEqual((Date)(journalizedUntil = DateHelper.getFirstDayOfMonth((Date)journalizedUntil)), (Date)DateHelper.getFirstDayOfMonth((Date)validDate))) {
                    journalizedUntil = DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)validDate)));
                }
                Date oldEffectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate));
                while (DateHelper.beforeOrEqual((Date)rCValidFrom, (Date)journalizedUntil)) {
                    EmployeeForReport[] newEmployees;
                    WageTaxPerEmployeeBean eWTOld;
                    Date rCValidUntil;
                    block23: {
                        EmployeeForReport[] oldEmployees;
                        block22: {
                            rCValidUntil = DateHelper.getLastDayOfMonth((Date)rCValidFrom);
                            oldEmployees = null;
                            try {
                                oldEmployees = this.generator.getEmployeesForReport(oidEmployee, oldEffectiveDate, rCValidFrom, rCValidUntil);
                            }
                            catch (BusinessDomainException dE) {
                                if (dE.getErrorNumber() == 103) break block22;
                                throw dE;
                            }
                        }
                        eWTOld = null;
                        if (oldEmployees != null) {
                            EmployeeForReport oldRCEFR = oldEmployees[0];
                            Date oldEmployeeStartDateRC = DateHelper.before((Date)rCValidFrom, (Date)oldRCEFR.getDateOfEntry()) ? oldRCEFR.getDateOfEntry() : rCValidFrom;
                            Date oldEmployeeEndDate = oldRCEFR.getDateOfWithDrawal() == null ? oldRCEFR.getEmploymentValidUntil() : oldRCEFR.getDateOfWithDrawal();
                            oldEmployeeEndDate = DateHelper.after((Date)oldEmployeeEndDate, (Date)rCValidUntil) ? rCValidUntil : oldEmployeeEndDate;
                            oldEmployeeEndDate = DateHelper.before((Date)oldEmployeeEndDate, (Date)oldEmployeeStartDateRC) ? DateHelper.getLastDayOfMonth((Date)oldEmployeeStartDateRC) : oldEmployeeEndDate;
                            eWTOld = this.getEmployeeProperties(oldRCEFR, oldEffectiveDate, oldEmployeeStartDateRC, oldEmployeeEndDate);
                            ((WageTaxEmployeeBean)eWTOld).setAnmeldezeitraumMonatBez(this.FIELD_monat);
                            ((WageTaxEmployeeBean)eWTOld).setAnmeldezeitraumMonatZahl(this.FIELD_anmeldezeitraum);
                            ((WageTaxEmployeeBean)eWTOld).setAndruckMonat(this.mAndruckMonat);
                        }
                        newEmployees = null;
                        try {
                            newEmployees = this.generator.getEmployeesForReport(oidEmployee, effectiveDate, rCValidFrom, rCValidUntil);
                        }
                        catch (BusinessDomainException dE) {
                            if (dE.getErrorNumber() == 103) break block23;
                            throw dE;
                        }
                    }
                    WageTaxPerEmployeeBean eWTNew = null;
                    if (newEmployees != null) {
                        EmployeeForReport newRCEFR = newEmployees[0];
                        Date employeeStartDateRC = DateHelper.before((Date)rCValidFrom, (Date)newRCEFR.getDateOfEntry()) ? newRCEFR.getDateOfEntry() : rCValidFrom;
                        Date employeeEndDateRC = newRCEFR.getDateOfWithDrawal() == null ? newRCEFR.getEmploymentValidUntil() : newRCEFR.getDateOfWithDrawal();
                        employeeEndDateRC = DateHelper.after((Date)employeeEndDateRC, (Date)rCValidUntil) ? rCValidUntil : employeeEndDateRC;
                        employeeEndDateRC = DateHelper.before((Date)employeeEndDateRC, (Date)employeeStartDateRC) ? DateHelper.getLastDayOfMonth((Date)employeeStartDateRC) : employeeEndDateRC;
                        eWTNew = this.getEmployeeProperties(newRCEFR, effectiveDate, employeeStartDateRC, employeeEndDateRC);
                        ((WageTaxEmployeeBean)eWTNew).setAnmeldezeitraumMonatBez(this.FIELD_monat);
                        ((WageTaxEmployeeBean)eWTNew).setAnmeldezeitraumMonatZahl(this.FIELD_anmeldezeitraum);
                        ((WageTaxEmployeeBean)eWTNew).setAndruckMonat(this.mAndruckMonat);
                    }
                    if (this.employeeToBeRegarded((WageTaxEmployeeBean)eWTOld)) {
                        this.resetDataEmployee();
                        this.getDataFor((WageTaxEmployeeBean)eWTOld, true);
                        this.setBigDecimalValues((WageTaxEmployeeBean)eWTOld);
                        if (eWTOld != null && !this.areFieldsValuesZero((WageTaxEmployeeBean)eWTOld)) {
                            eWTOld.setIsEmployeeToBeRegarded(true);
                            eWTOld.setStatus("storno");
                            eWTOld.setValidDate(validDate);
                        }
                    }
                    if (this.employeeToBeRegarded((WageTaxEmployeeBean)eWTNew)) {
                        this.resetDataEmployee();
                        this.getDataFor((WageTaxEmployeeBean)eWTNew, true);
                        this.setBigDecimalValues((WageTaxEmployeeBean)eWTNew);
                        if (eWTNew != null && !this.areFieldsValuesZero((WageTaxEmployeeBean)eWTNew)) {
                            eWTNew.setIsEmployeeToBeRegarded(true);
                            eWTNew.setStatus("neu");
                            eWTNew.setValidDate(validDate);
                        }
                    }
                    this.resetDataEmployee();
                    this.resetDataSumme();
                    if (eWTOld != null && eWTNew == null && eWTOld.getIsEmployeeToBeRegarded()) {
                        ((WageTaxEmployeeBean)eWTOld).setBigDecimalValuesNegative();
                        this.addWageTaxPerEmployeeRCToCollection((WageTaxEmployeeBean)eWTOld);
                    }
                    if (eWTOld == null && eWTNew != null && eWTNew.getIsEmployeeToBeRegarded()) {
                        this.addWageTaxPerEmployeeRCToCollection((WageTaxEmployeeBean)eWTNew);
                    }
                    if (eWTOld != null && eWTNew != null) {
                        if (eWTOld.getIsEmployeeToBeRegarded() && !eWTNew.getIsEmployeeToBeRegarded()) {
                            ((WageTaxEmployeeBean)eWTOld).setBigDecimalValuesNegative();
                            this.addWageTaxPerEmployeeRCToCollection((WageTaxEmployeeBean)eWTOld);
                        }
                        if (!eWTOld.getIsEmployeeToBeRegarded() && eWTNew.getIsEmployeeToBeRegarded()) {
                            this.addWageTaxPerEmployeeRCToCollection((WageTaxEmployeeBean)eWTNew);
                        }
                        if (eWTOld.getIsEmployeeToBeRegarded() && eWTNew.getIsEmployeeToBeRegarded() && !this.mWageTaxPerEmployeeHelper.areOldNewValuesEqual((WageTaxEmployeeBean)eWTOld, (WageTaxEmployeeBean)eWTNew)) {
                            ((WageTaxEmployeeBean)eWTOld).setBigDecimalValuesNegative();
                            this.addWageTaxPerEmployeeRCToCollection((WageTaxEmployeeBean)eWTOld);
                            this.addWageTaxPerEmployeeRCToCollection((WageTaxEmployeeBean)eWTNew);
                        }
                    }
                    rCValidFrom = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)rCValidUntil));
                }
            }
        }
    }

    private void addWageTaxPerEmployeeRCToCollection(WageTaxEmployeeBean eWT) {
        if (StringMapper.equal((String)eWT.getLicense(), (String)"AK")) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)eWT.getAk())) {
                this.mWageTaxEmployeesBeanLi.add(eWT);
            }
        } else if (!this.mHatKammerbeitrag || this.mSecondRun) {
            this.mWageTaxEmployeesBeanLi.add(eWT);
        }
    }

    private void setBigDecimalValues(WageTaxEmployeeBean eWT) {
        eWT.setBigDecimalValues(this.FIELD_st_pfl, this.FIELD_pausch_brutto, this.FIELD_lst_lfd, this.FIELD_lst_son, this.FIELD_lst_pau, this.FIELD_soli_lfd, this.FIELD_soli_son, this.FIELD_soli_pau, this.FIELD_kist_lfd, this.FIELD_kist_son, this.FIELD_kist_pau, this.FIELD_erst_lst_zwi_su, this.FIELD_erst_soli_zwi_su, this.FIELD_erst_kist_zwi_su, this.FIELD_erst_lst_informativ, this.FIELD_erst_soli_informativ, this.FIELD_erst_kist_informativ, this.FIELD_ak, this.FIELD_kist_lfd_an, this.FIELD_kist_pau_an, this.FIELD_kist_son_an, this.FIELD_erst_kist_zwi_su_an, this.FIELD_kist_lfd_eg, this.FIELD_kist_pau_eg, this.FIELD_kist_son_eg, this.FIELD_erst_kist_zwi_su_eg, this.FIELD_kist_pau_ver, this.FIELD_kist_pau_ver_bis_2006_rk, this.FIELD_kist_pau_ver_bis_2006_ev, this.FIELD_erst_kist_informativ_an, this.FIELD_erst_kist_informativ_eg, this.FIELD_kindergeld, this.FIELD_energiepreispauschale, this.FIELD_foederbetrag_bav);
        eWT.setKist_an(this.FIELD_kist_an);
        eWT.setKist_eg(this.FIELD_kist_eg);
        if (this.employeeLSTJA_aschluss != 0) {
            eWT.setEmployeeLStJA_asschluss(this.employeeLSTJA_aschluss);
        }
    }

    protected void checkForJournalisationEinzelnachweis(WageTaxEmployeeBean eWT) throws BusinessDomainException {
        Date checkDate = this.mForValidDate;
        if (this.mBerichtigungEPP) {
            checkDate = this.mEffectiveDateEPP;
        }
        if (ReportHelper.getDiffInMonths((Date)checkDate, (Date)eWT.getJournalizeduntil()) > 0) {
            String message = "\n Mitarbeiter: " + ReportHelper.removeZeroFromLeft((String)eWT.getPersonnelNumber()) + " " + eWT.getSurname() + ", " + eWT.getFirstname();
            throw ReportExceptionMapper.makeEmployeeNotJournalized(message);
        }
    }

    protected WageTaxEmployeeBean getEmployeeProperties(EmployeeForReport currentEmployee, Date effectiveDate, Date currentEmployeeValidFromDate, Date currentEmployeeValidUntilDate) throws BusinessDomainException {
        TaxContainer employeeTaxContainer;
        String plantTaxNumber;
        WageTaxEmployeeBean eWT = this.mWageTaxPerEmployeeHelper.getEmployeeWageTaxBean(currentEmployee);
        Date tempEmployeeEndDate = currentEmployeeValidUntilDate;
        if (eWT.getDateOfWithDrawal() != null && DateHelper.before((Date)eWT.getDateOfWithDrawal(), (Date)DateHelper.getFirstDayOfYear((Date)this.mListFirstDate))) {
            tempEmployeeEndDate = DateHelper.getLastDayOfMonth((Date)currentEmployeeValidFromDate);
        }
        eWT.setEmployeeEffectiveDate(effectiveDate);
        eWT.setEmployeeStartDate(currentEmployeeValidFromDate);
        eWT.setEmployeeEndDate(tempEmployeeEndDate);
        eWT.setEmployeeJournalizedUntil(this.mReportValues.getEmployeeJournalizedUntil(currentEmployee.getOidEmployee()));
        if (!this.mInternalUse) {
            this.checkForJournalisationEinzelnachweis(eWT);
        }
        if (this.mPayment && ReportHelper.getDiffInMonths((Date)this.mForValidDate, (Date)eWT.getEmployeeJournalizedUntil()) > 0) {
            throw PaymentExceptionMapper.makeNotJournelizedEmployeeDomainException();
        }
        if (!(StringMapper.isNullString((String)eWT.getOidPlant()) || this.mSecondRun || StringMapper.isNullString((String)(plantTaxNumber = this.mWageTaxPerEmployeeHelper.getPlantTaxNumber(eWT.getOidPlant(), eWT.getOidEmployee(), effectiveDate, currentEmployeeValidFromDate))))) {
            this.setWageTaxPerEmployeePlants(effectiveDate, currentEmployeeValidFromDate, eWT, plantTaxNumber);
        }
        if (StringMapper.isNullString((String)eWT.getPlantTaxNumber())) {
            this.setWageTaxPerEmployeePCompany(eWT);
        }
        if ((employeeTaxContainer = this.mReportValues.getEmployeeTaxContainer(eWT.getOidEmployee(), effectiveDate, currentEmployeeValidFromDate)) != null) {
            eWT.setEmployeeChurchtaxee(employeeTaxContainer.churchtaxee);
            eWT.setEmployeeChurchtaxspouse(employeeTaxContainer.churchtaxspouse);
            if (eWT.getLicense().equals("AK") && !this.mSecondRun) {
                eWT.setCalculateEmployeeKammerBeitrag(true);
            } else {
                eWT.setCalculateEmployeeKammerBeitrag(employeeTaxContainer.associationee);
            }
            eWT.setEmployeeLStJAUnterzahlungInfoLSt(!employeeTaxContainer.itunderpayment);
            eWT.setEmployeeLStJAUnterzahlungInfoSoli(!employeeTaxContainer.scunderpayment);
            eWT.setEmployeeLStJAUnterzahlungInfoKist(!employeeTaxContainer.ctunderpayment);
            eWT.setEmployeeTaxacation(employeeTaxContainer.taxacation);
            eWT.setEmployeeTaxbracket(employeeTaxContainer.taxbracket);
            if (eWT.getEmployeeChurchtaxee() == 0 || eWT.getEmployeeChurchtaxspouse() == 0) {
                int[] churchTax = this.mReportValues.getCarriedForwardOfEntryChruchTax(eWT.getOidEmployee(), currentEmployeeValidFromDate);
                if (eWT.getEmployeeChurchtaxee() == 0) {
                    eWT.setEmployeeChurchtaxee(churchTax[0]);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    eWT.setEmployeeChurchtaxspouse(churchTax[1]);
                }
            }
        }
        long valuePositionsLiRowCount = ReportEmployeesHandlingHelper.getValuePositionsLiCount((String)eWT.getOidEmployee(), (String[])mValueTypeNumbers, (Date)effectiveDate, (Date)currentEmployeeValidFromDate, (Date)tempEmployeeEndDate);
        if (this.mIsEPPMonat && DateHelper.afterOrEqual((Date)effectiveDate, (Date)new VDate(2022, 6, 1).getDate()) && DateHelper.beforeOrEqual((Date)effectiveDate, (Date)new VDate(2023, 0, 31).getDate())) {
            long epp = ReportEmployeesHandlingHelper.getValuePositionsLiCount((String)eWT.getOidEmployee(), (String[])new String[]{"102590"}, (Date)effectiveDate, (Date)new VDate(2022, 7, 1).getDate(), (Date)new VDate(2022, 11, 31).getDate());
            valuePositionsLiRowCount += epp;
        }
        eWT.setValuePositionliCount(valuePositionsLiRowCount);
        return eWT;
    }

    protected void setWageTaxPerEmployeePCompany(WageTaxEmployeeBean eWT) throws BusinessDomainException {
        String companyLongDescription = this.mReportValues.getCompanyLongDescription(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate);
        eWT.setPCompanyFstateregionKey(this.mReportValues.getCompanyFederalState(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate).getFederalState());
        eWT.setPCompanySplitlumpsumct(this.mReportValues.getPCompanySplitlumpsumct(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate));
        eWT.setPCompanyTaxNumber(this.mReportValues.getCompanyTaxNumber(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate));
        eWT.setPCompanyFamilyFundKey(this.mReportValues.getCompanyFamilyFundKey(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate));
        try {
            eWT.setPCompanyTaxOfficeLongDescription(this.mReportValues.getCompanyTaxOfficeLongDescription(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate));
            eWT.setPcompanyTaxOfficeNumber(this.mReportValues.getCompanyTaxOfficeNumber(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate));
            CompanyPlantCommunication communication = this.mReportValues.getCompanyFoundations(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate).getCommunication();
            if (communication != null) {
                eWT.setEmail(communication.getEMail());
                eWT.setTelefonnummer(communication.getPhone());
            }
        }
        catch (BusinessDomainException e) {
            BusinessDomainException dE = e;
            this.mErrorReportFactory.addErrorMessageToEmployer(eWT.getOidPCompany(), companyLongDescription, dE.getErrorNumber(), this.mForEffectiveDate, this.mForValidDate, dE.getMessage());
        }
        if (new VDate(eWT.getEmployeeStartDate()).getMonth() == 11) {
            eWT.setPcompanyLStJA(this.mReportValues.getPCompanyLSTJA(eWT.getOidPCompany(), this.mForEffectiveDate, this.mForValidDate));
            eWT.setEmployerLStJA(eWT.getPcompanyLStJA());
            Tax employeeTax = this.mReportValues.getEmployeeTax(eWT.getOidEmployee(), this.mForEffectiveDate, this.mForValidDate);
            if (employeeTax != null && employeeTax.getIncomeTaxReturnYY().value() == 1) {
                eWT.setEmployeeLStJA(true);
            }
        }
        eWT.setEmployerOid(eWT.getOidPCompany());
        eWT.setEmployerTaxNumber(eWT.getPCompanyTaxNumber());
        eWT.setEmployerLongDescription(companyLongDescription);
        eWT.setEmployerTaxOfficeLongDescription(eWT.getPCompanyTaxOfficeLongDescription());
        eWT.setEmployerTaxOfficeNumber(eWT.getPcompanyTaxOfficeNumber());
        eWT.setEmployerKey(eWT.getPCompanyKey());
        eWT.setEmployerFstateregionKey(eWT.getPCompanyFstateregionKey());
        eWT.setEmployerSplitlumpsumct(eWT.getPCompanySplitlumpsumct());
        eWT.setEmployerFamilyFundKey(eWT.getPCompanyFamilyFundKey());
    }

    private void setWageTaxPerEmployeePlants(Date effectiveDate, Date employeeStartDate, WageTaxEmployeeBean eWT, String plantTaxNumber) throws BusinessDomainException {
        this.mWageTaxPerEmployeeHelper.setWageTaxPerEmployeePlants(eWT, plantTaxNumber, this.mErrorReportFactory, this.mUsePerfidia, effectiveDate, employeeStartDate);
    }

    protected boolean employeeToBeRegarded(WageTaxEmployeeBean eWT) {
        if (eWT == null) {
            return false;
        }
        if (!this.mBerichtigungEPP && eWT.getValuePositionliCount() == 0L) {
            if (DateHelper.equal((Date)eWT.getEmployeeEffectiveDate(), (Date)this.mForEffectiveDate) && this.mInternalUse && (eWT.getDateOfWithDrawal() == null || eWT.getDateOfWithDrawal() != null && DateHelper.afterOrEqual((Date)eWT.getDateOfWithDrawal(), (Date)this.mForValidDate))) {
                this.mErrorReportFactory.addErrorMessageEmployeeToEmployer(eWT.getOidPCompany(), 2, "2* G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)eWT.getEmployeeStartDate()) + ", aus Sicht: " + DateMapper.toDDMMYYYYPointSeparationString((Date)eWT.getEmployeeEffectiveDate()), eWT);
            }
            if (eWT.getEmployeeTaxbracket() >= 1 && eWT.getEmployeeTaxbracket() <= 6 || eWT.getEmployeeTaxacation() == 3 || eWT.getEmployeeTaxacation() == 4 || eWT.getEmployeeTaxacation() == 6 || eWT.getEmployeeTaxacation() == 5 || eWT.getEmployeeTaxacation() == 1) {
                return true;
            }
            if (this.mInternalUse) {
                this.mErrorReportFactory.addErrorMessageEmployeeToEmployer(eWT.getOidPCompany(), 3, "3* G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)eWT.getEmployeeStartDate()) + ", aus Sicht: " + DateMapper.toDDMMYYYYPointSeparationString((Date)eWT.getEmployeeEffectiveDate()), eWT);
            }
            if (eWT.getValuePositionliCount() != 0L) {
                long valuePositionsLiRowCount = ReportEmployeesHandlingHelper.getValuePositionsLiCount((String)eWT.getOidEmployee(), (String[])mVTNumberForRegarded, (Date)eWT.getEmployeeEffectiveDate(), (Date)eWT.getEmployeeStartDate(), (Date)eWT.getEmployeeEndDate());
                if (this.mInternalUse && valuePositionsLiRowCount == 0L && (eWT.getDateOfWithDrawal() == null || eWT.getDateOfWithDrawal() != null && DateHelper.afterOrEqual((Date)eWT.getDateOfWithDrawal(), (Date)this.mForValidDate))) {
                    this.mErrorReportFactory.addErrorMessageEmployeeToEmployer(eWT.getOidPCompany(), 4, "4* G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)eWT.getEmployeeStartDate()), eWT);
                }
            } else if (this.mInternalUse && (eWT.getDateOfWithDrawal() == null || eWT.getDateOfWithDrawal() != null && DateHelper.afterOrEqual((Date)eWT.getDateOfWithDrawal(), (Date)this.mForValidDate))) {
                this.mErrorReportFactory.addErrorMessageEmployeeToEmployer(eWT.getOidPCompany(), 2, "2* G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)eWT.getEmployeeStartDate()), eWT);
            }
            return false;
        }
        return true;
    }

    protected void getDataFor(WageTaxEmployeeBean eWT, boolean kommtAusRR) throws BusinessDomainException {
        if (this.mBerichtigungEPP || eWT.getValuePositionliCount() != 0L) {
            this.distinguishWageTaxValues(eWT, kommtAusRR);
        }
        this.FIELD_lst_zwi_su = this.FIELD_lst_zwi_su.add(this.FIELD_lst_lfd).add(this.FIELD_lst_pau).add(this.FIELD_lst_son);
        this.FIELD_soli_zwi_su = this.FIELD_soli_zwi_su.add(this.FIELD_soli_lfd).add(this.FIELD_soli_pau).add(this.FIELD_soli_son);
        this.FIELD_kist_zwi_su = this.FIELD_kist_zwi_su.add(this.FIELD_kist_lfd).add(this.FIELD_kist_pau).add(this.FIELD_kist_son);
        this.FIELD_summe_an_st = this.FIELD_summe_an_st.add(this.FIELD_lst_zwi_su).add(this.FIELD_soli_zwi_su).add(this.FIELD_kist_zwi_su).add(this.FIELD_ak).subtract(this.FIELD_kindergeld).subtract(this.FIELD_foederbetrag_bav).subtract(this.FIELD_energiepreispauschale);
    }

    protected void distinguishWageTaxValues(WageTaxEmployeeBean eWT, boolean kommtAusRR) {
        if (eWT.getLicense().equals("AK") && eWT.getCalculateEmployeeKammerBeitrag()) {
            this.getValuesKammerBeitrag(eWT);
        } else {
            this.setWageTaxValues(eWT, kommtAusRR);
            if (!StringMapper.equal((String)eWT.getLicense(), (String)"AK") && !this.mSecondRun) {
                this.getValuesKammerBeitrag(eWT);
            }
        }
    }

    private void setWageTaxValues(WageTaxEmployeeBean eWT, boolean kommtAusRR) {
        Date gueltigAb = new VDate(2022, 7, 1).getDate();
        Date gueltigBis = new VDate(2022, 7, 31).getDate();
        Date monatVon = DateHelper.getFirstDayOfMonth((Date)this.mVersatzMonat);
        Date monatVBis = DateHelper.getLastDayOfMonth((Date)this.mVersatzMonat);
        switch (this.mAnmeldezeitraum.value()) {
            case 1: {
                gueltigAb = new VDate(2022, 8, 1).getDate();
                gueltigBis = new VDate(2022, 8, 30).getDate();
                monatVon = eWT.getEmployeeStartDate();
                monatVBis = eWT.getEmployeeEndDate();
                break;
            }
            case 2: {
                gueltigAb = new VDate(2022, 11, 1).getDate();
                gueltigBis = new VDate(2022, 11, 31).getDate();
                monatVon = eWT.getEmployeeStartDate();
                monatVBis = eWT.getEmployeeEndDate();
            }
        }
        boolean mitEEP = false;
        if (!kommtAusRR && DateHelper.afterOrEqual((Date)this.mVersatzMonat, (Date)gueltigAb) && DateHelper.beforeOrEqual((Date)this.mVersatzMonat, (Date)gueltigBis) && DateHelper.equal((Date)monatVon, (Date)new VDate(2022, 7, 1).getDate()) && DateHelper.equal((Date)monatVBis, (Date)new VDate(2022, 7, 31).getDate())) {
            mitEEP = true;
        }
        WageTaxPerEmployeeValuePositionFactory wTPEValuePositionFactory = new WageTaxPerEmployeeValuePositionFactory(this.mChurchTaxSplit, mitEEP);
        wTPEValuePositionFactory.getValues(eWT, this.mEffectiveDateEPP, mValueTypeNumbers);
        this.FIELD_pausch_brutto = this.FIELD_pausch_brutto.add(wTPEValuePositionFactory.getFIELD_pausch_brutto());
        this.FIELD_st_pfl = this.FIELD_st_pfl.add(wTPEValuePositionFactory.getFIELD_st_pfl());
        this.FIELD_lst_lfd = this.FIELD_lst_lfd.add(wTPEValuePositionFactory.getFIELD_lst_lfd());
        this.FIELD_lst_son = this.FIELD_lst_son.add(wTPEValuePositionFactory.getFIELD_lst_son());
        this.FIELD_soli_lfd = this.FIELD_soli_lfd.add(wTPEValuePositionFactory.getFIELD_soli_lfd());
        this.FIELD_soli_son = this.FIELD_soli_son.add(wTPEValuePositionFactory.getFIELD_soli_son());
        this.FIELD_kist_lfd = this.FIELD_kist_lfd.add(wTPEValuePositionFactory.getFIELD_kist_lfd());
        this.FIELD_kist_son = this.FIELD_kist_son.add(wTPEValuePositionFactory.getFIELD_kist_son());
        this.FIELD_lst_pau = this.FIELD_lst_pau.add(wTPEValuePositionFactory.getFIELD_lst_pau());
        this.FIELD_soli_pau = this.FIELD_soli_pau.add(wTPEValuePositionFactory.getFIELD_soli_pau());
        this.FIELD_kist_pau = this.FIELD_kist_pau.add(wTPEValuePositionFactory.getFIELD_kist_pau());
        this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.add(wTPEValuePositionFactory.getFIELD_erst_lst_zwi_su());
        this.FIELD_erst_lst_informativ = this.FIELD_erst_lst_informativ.add(wTPEValuePositionFactory.getFIELD_erst_lst_informativ());
        this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.add(wTPEValuePositionFactory.getFIELD_erst_soli_zwi_su());
        this.FIELD_erst_soli_informativ = this.FIELD_erst_soli_informativ.add(wTPEValuePositionFactory.getFIELD_erst_soli_informativ());
        this.FIELD_erst_kist_zwi_su = this.FIELD_erst_kist_zwi_su.add(wTPEValuePositionFactory.getFIELD_erst_kist_zwi_su());
        this.FIELD_erst_kist_informativ = this.FIELD_erst_kist_informativ.add(wTPEValuePositionFactory.getFIELD_erst_kist_informativ());
        this.FIELD_pausch_brutto_37b = this.FIELD_pausch_brutto_37b.add(wTPEValuePositionFactory.getFIELD_lst_pau_37b());
        this.FIELD_kindergeld = this.FIELD_kindergeld.add(wTPEValuePositionFactory.getFIELD_kindergeld());
        this.FIELD_energiepreispauschale = this.FIELD_energiepreispauschale.add(wTPEValuePositionFactory.getFIELD_energiepreispauschale());
        this.FIELD_foederbetrag_bav = this.FIELD_foederbetrag_bav.add(wTPEValuePositionFactory.getFIELD_foederbetrag_bav());
        this.employeeLSTJA_aschluss = wTPEValuePositionFactory.getEmployeeLSTJA_aschluss();
        if (this.mChurchTaxSplit) {
            this.FIELD_kist_lfd_an = this.FIELD_kist_lfd_an.add(wTPEValuePositionFactory.getFIELD_kist_lfd_an());
            this.FIELD_kist_pau_an = this.FIELD_kist_pau_an.add(wTPEValuePositionFactory.getFIELD_kist_pau_an());
            this.FIELD_kist_son_an = this.FIELD_kist_son_an.add(wTPEValuePositionFactory.getFIELD_kist_son_an());
            this.FIELD_erst_kist_zwi_su_an = this.FIELD_erst_kist_zwi_su_an.add(wTPEValuePositionFactory.getFIELD_erst_kist_zwi_su_an());
            this.FIELD_kist_lfd_eg = this.FIELD_kist_lfd_eg.add(wTPEValuePositionFactory.getFIELD_kist_lfd_eg());
            this.FIELD_kist_pau_eg = this.FIELD_kist_pau_eg.add(wTPEValuePositionFactory.getFIELD_kist_pau_eg());
            this.FIELD_kist_son_eg = this.FIELD_kist_son_eg.add(wTPEValuePositionFactory.getFIELD_kist_son_eg());
            this.FIELD_erst_kist_zwi_su_eg = this.FIELD_erst_kist_zwi_su_eg.add(wTPEValuePositionFactory.getFIELD_erst_kist_zwi_su_eg());
            this.FIELD_kist_pau_ver = this.FIELD_kist_pau_ver.add(wTPEValuePositionFactory.getFIELD_kist_pau_ver());
            this.FIELD_kist_pau_ver_bis_2006_rk = this.FIELD_kist_pau_ver_bis_2006_rk.add(wTPEValuePositionFactory.getFIELD_kist_pau_ver_bis_2006_rk());
            this.FIELD_kist_pau_ver_bis_2006_ev = this.FIELD_kist_pau_ver_bis_2006_ev.add(wTPEValuePositionFactory.getFIELD_kist_pau_ver_bis_2006_ev());
            this.FIELD_kist_an = wTPEValuePositionFactory.getEmpCTE_an().getTextShort();
            this.FIELD_kist_eg = wTPEValuePositionFactory.getEmpCTE_eg().getTextShort();
            this.FIELD_erst_kist_informativ_an = wTPEValuePositionFactory.getFIELD_erst_kist_informativ_an();
            this.FIELD_erst_kist_informativ_eg = wTPEValuePositionFactory.getFIELD_erst_kist_informativ_eg();
        }
    }

    private void getValuesKammerBeitrag(WageTaxEmployeeBean eWT) {
        WageTaxPerEmployeeValuePositionFactory wTPEValuePositionFactory = new WageTaxPerEmployeeValuePositionFactory(this.mChurchTaxSplit, false);
        wTPEValuePositionFactory.getValuesKammerBeitrag(eWT, mVTNumberForArbeitsKammer);
        this.FIELD_ak = this.FIELD_ak.add(wTPEValuePositionFactory.getFIELD_ak());
    }

    private void setChurchTaxValuesFooter(BigDecimal kistZwichenSumme, int ChurchTaxInt) {
        block0 : switch (this.mEWT.getEmployerFstateregionKey()) {
            case 3: {
                switch (ChurchTaxInt) {
                    case 1: 
                    case 4: 
                    case 5: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 4: {
                switch (ChurchTaxInt) {
                    case 1: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 5: {
                switch (ChurchTaxInt) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 16: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 6: {
                switch (ChurchTaxInt) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 11: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 10: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 14: {
                        this.church_5_summ = this.church_5_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 13: {
                        this.church_6_summ = this.church_6_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_7_summ = this.church_7_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 7: {
                switch (ChurchTaxInt) {
                    case 1: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 14: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 9: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 10: {
                        this.church_5_summ = this.church_5_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 7: {
                        this.church_6_summ = this.church_6_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_7_summ = this.church_7_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 8: {
                switch (ChurchTaxInt) {
                    case 1: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 12: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 8: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 15: {
                        this.church_5_summ = this.church_5_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_6_summ = this.church_6_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 9: {
                switch (ChurchTaxInt) {
                    case 1: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 17: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 10: {
                switch (ChurchTaxInt) {
                    case 1: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 13: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 11: 
            case 12: {
                switch (ChurchTaxInt) {
                    case 1: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 1: {
                if (DateHelper.before((Date)this.mEWT.getEmployeeStartDate(), (Date)new VDate(2008, 0, 1).getDate())) {
                    switch (ChurchTaxInt) {
                        case 1: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                            break;
                        }
                        case 2: {
                            this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        }
                    }
                    break;
                }
                switch (ChurchTaxInt) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 18: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 3: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                switch (ChurchTaxInt) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                    }
                }
                break;
            }
            case 2: {
                switch (ChurchTaxInt) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.church_1_summ = this.church_1_summ.add(kistZwichenSumme);
                        break block0;
                    }
                    case 2: {
                        this.church_2_summ = this.church_2_summ.add(kistZwichenSumme);
                        break block0;
                    }
                    case 18: {
                        this.church_3_summ = this.church_3_summ.add(kistZwichenSumme);
                        break block0;
                    }
                    case 3: {
                        this.church_4_summ = this.church_4_summ.add(kistZwichenSumme);
                    }
                }
            }
        }
    }

    private void addSumme(Date employeeStartDate) {
        BigDecimal lstZwichenSumme = this.mEWT.getLst_lfd().add(this.mEWT.getLst_pau()).add(this.mEWT.getLst_son());
        BigDecimal soliZwichenSumme = this.mEWT.getSoli_lfd().add(this.mEWT.getSoli_pau()).add(this.mEWT.getSoli_son());
        BigDecimal kistZwichenSumme = this.mEWT.getKist_lfd().add(this.mEWT.getKist_pau()).add(this.mEWT.getKist_son());
        BigDecimal lstSoliKistSumme = lstZwichenSumme.add(soliZwichenSumme).add(kistZwichenSumme);
        this.summe_lst_lfd = this.summe_lst_lfd.add(this.mEWT.getLst_lfd());
        this.summe_lst_son = this.summe_lst_son.add(this.mEWT.getLst_son());
        this.summe_lst_pau = this.summe_lst_pau.add(this.mEWT.getLst_pau());
        this.summe_lst_zwi_su = this.summe_lst_zwi_su.add(lstZwichenSumme);
        this.summe_soli_lfd = this.summe_soli_lfd.add(this.mEWT.getSoli_lfd());
        this.summe_soli_son = this.summe_soli_son.add(this.mEWT.getSoli_son());
        this.summe_soli_pau = this.summe_soli_pau.add(this.mEWT.getSoli_pau());
        this.summe_soli_zwi_su = this.summe_soli_zwi_su.add(soliZwichenSumme);
        this.summe_kist_lfd = this.summe_kist_lfd.add(this.mEWT.getKist_lfd());
        this.summe_kist_son = this.summe_kist_son.add(this.mEWT.getKist_son());
        this.summe_kist_zwi_su = this.summe_kist_zwi_su.add(kistZwichenSumme);
        if (this.mChurchTaxSplit) {
            this.summe_kist_pau_ver = this.summe_kist_pau_ver.add(this.mEWT.getKist_pau_ver());
            this.summe_kist_pau = this.summe_kist_pau.add(this.mEWT.getKist_pau_an()).add(this.mEWT.getKist_pau_eg());
            if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2007, 0, 1).getDate())) {
                if (DateHelper.before((Date)employeeStartDate, (Date)new VDate(2007, 0, 1).getDate())) {
                    this.summe_kist_pau_ver = this.summe_kist_pau_ver.add(this.mEWT.getKist_pau_ver_bis_2006_ev()).add(this.mEWT.getKist_pau_ver_bis_2006_rk());
                }
            } else {
                this.summe_kist_pau = this.summe_kist_pau.add(this.mEWT.getKist_pau_ver_bis_2006_ev()).add(this.mEWT.getKist_pau_ver_bis_2006_rk());
            }
            BigDecimal kistZwichenSummeAN = this.mEWT.getKist_lfd_an().add(this.mEWT.getKist_pau_an()).add(this.mEWT.getKist_son_an()).add(this.mEWT.getErst_kist_zwi_su_an());
            BigDecimal kistZwichenSummeEG = this.mEWT.getKist_lfd_eg().add(this.mEWT.getKist_pau_eg()).add(this.mEWT.getKist_son_eg()).add(this.mEWT.getErst_kist_zwi_su_eg());
            this.setChurchTaxValuesFooter(kistZwichenSummeAN, this.mEWT.getEmployeeChurchtaxee());
            this.setChurchTaxValuesFooter(kistZwichenSummeEG, this.mEWT.getEmployeeChurchtaxspouse());
            if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2007, 0, 1).getDate())) {
                this.church_1_summ = this.church_1_summ.add(this.mEWT.getKist_pau_ver_bis_2006_ev());
                this.church_2_summ = this.church_2_summ.add(this.mEWT.getKist_pau_ver_bis_2006_rk());
            }
        } else {
            this.summe_kist_pau = this.summe_kist_pau.add(this.mEWT.getKist_pau());
        }
        this.summe_ak = this.summe_ak.add(this.mEWT.getAk());
        this.summe_kindergeld = this.summe_kindergeld.add(this.mEWT.getKindergeld()).add(this.mEWT.getEnergiepreispauschale());
        if (BigDecimalMapper.compareTo((BigDecimal)this.summe_kindergeld, (BigDecimal)BigDecimal.valueOf(100000L)) >= 0) {
            this.summe_kg_groesseres_feld = true;
        }
        this.summe_foederbetrag_bav = this.summe_foederbetrag_bav.add(this.mEWT.getFoederbetrag_bav());
        lstSoliKistSumme = lstSoliKistSumme.add(this.mEWT.getAk()).subtract(this.mEWT.getKindergeld()).subtract(this.mEWT.getFoederbetrag_bav()).subtract(this.mEWT.getEnergiepreispauschale());
        this.summe_summe_an = this.summe_summe_an.add(lstSoliKistSumme);
        this.summe_summe_ergebnis = this.summe_summe_ergebnis.add(lstSoliKistSumme);
        this.summe_ergebnis_lst = this.summe_ergebnis_lst.add(lstZwichenSumme).add(this.mEWT.getErst_lst_zwi_su());
        this.summe_ergebnis_soli = this.summe_ergebnis_soli.add(soliZwichenSumme).add(this.mEWT.getErst_soli_zwi_su());
        this.summe_ergebnis_kist = this.summe_ergebnis_kist.add(kistZwichenSumme).add(this.mEWT.getErst_kist_zwi_su());
        if (new VDate(employeeStartDate).getMonth() == 11 && this.mEWT.getEmployeeLStJA_asschluss() == 0) {
            this.FIELD_summe_erst = this.FIELD_summe_erst.add(this.mEWT.getErst_lst_zwi_su()).add(this.mEWT.getErst_soli_zwi_su()).add(this.mEWT.getErst_kist_zwi_su());
            this.summe_lja_lst = this.summe_lja_lst.add(this.mEWT.getErst_lst_zwi_su());
            this.summe_lja_soli = this.summe_lja_soli.add(this.mEWT.getErst_soli_zwi_su());
            this.summe_lja_kist = this.summe_lja_kist.add(this.mEWT.getErst_kist_zwi_su());
            BigDecimal erstattungenSumme = this.mEWT.getErst_lst_zwi_su().add(this.mEWT.getErst_soli_zwi_su()).add(this.mEWT.getErst_kist_zwi_su());
            this.summe_summe_lja = this.summe_summe_lja.add(erstattungenSumme);
            this.summe_summe_ergebnis = this.summe_summe_ergebnis.add(erstattungenSumme);
        }
    }

    protected void resetDataEmployee() {
        this.FIELD_pausch_brutto = BigDecimal.ZERO;
        this.FIELD_lst_lfd = BigDecimal.ZERO;
        this.FIELD_lst_son = BigDecimal.ZERO;
        this.FIELD_lst_pau = BigDecimal.ZERO;
        this.FIELD_soli_lfd = BigDecimal.ZERO;
        this.FIELD_soli_son = BigDecimal.ZERO;
        this.FIELD_soli_pau = BigDecimal.ZERO;
        this.FIELD_kist_lfd = BigDecimal.ZERO;
        this.FIELD_kist_son = BigDecimal.ZERO;
        this.FIELD_kist_pau = BigDecimal.ZERO;
        this.FIELD_ak = BigDecimal.ZERO;
        this.FIELD_erst_lst_zwi_su = BigDecimal.ZERO;
        this.FIELD_erst_soli_zwi_su = BigDecimal.ZERO;
        this.FIELD_erst_kist_zwi_su = BigDecimal.ZERO;
        this.FIELD_erst_lst_informativ = BigDecimal.ZERO;
        this.FIELD_erst_soli_informativ = BigDecimal.ZERO;
        this.FIELD_erst_kist_informativ = BigDecimal.ZERO;
        this.FIELD_st_pfl = BigDecimal.ZERO;
        this.FIELD_lst_zwi_su = BigDecimal.ZERO;
        this.FIELD_soli_zwi_su = BigDecimal.ZERO;
        this.FIELD_kist_zwi_su = BigDecimal.ZERO;
        this.FIELD_summe_an_st = BigDecimal.ZERO;
        this.FIELD_summe_erst = BigDecimal.ZERO;
        this.FIELD_kist_lfd_an = BigDecimal.ZERO;
        this.FIELD_kist_pau_an = BigDecimal.ZERO;
        this.FIELD_kist_son_an = BigDecimal.ZERO;
        this.FIELD_erst_kist_zwi_su_an = BigDecimal.ZERO;
        this.FIELD_kist_lfd_eg = BigDecimal.ZERO;
        this.FIELD_kist_pau_eg = BigDecimal.ZERO;
        this.FIELD_kist_son_eg = BigDecimal.ZERO;
        this.FIELD_erst_kist_zwi_su_eg = BigDecimal.ZERO;
        this.FIELD_kist_pau_ver = BigDecimal.ZERO;
        this.FIELD_kist_pau_ver_bis_2006_rk = BigDecimal.ZERO;
        this.FIELD_kist_pau_ver_bis_2006_ev = BigDecimal.ZERO;
        this.FIELD_erst_kist_informativ_an = BigDecimal.ZERO;
        this.FIELD_erst_kist_informativ_eg = BigDecimal.ZERO;
        this.FIELD_kist_an = "";
        this.FIELD_kist_eg = "";
        this.FIELD_pausch_brutto_37b = BigDecimal.ZERO;
        this.FIELD_kindergeld = BigDecimal.ZERO;
        this.FIELD_energiepreispauschale = BigDecimal.ZERO;
        this.FIELD_foederbetrag_bav = BigDecimal.ZERO;
        this.employeeLSTJA_aschluss = 0;
    }

    private void setHeaderValues() {
        this.FIELD_steuernummer = this.mEWT.getEmployerTaxNumber();
        this.FIELD_finanzamt_bezeichnung = this.mEWT.getEmployerTaxOfficeLongDescription();
        this.FIELD_finanzamt_nr = this.mEWT.getEmployerTaxOfficeNumber();
        this.FIELD_arbeitgeber_bezeichnung = this.mEWT.getEmployerLongDescription();
        this.FIELD_pcompany_plant_key = this.mEWT.getEmployerKey();
        this.FIELD_seitenwechsel = this.FIELD_seitenwechsel.equals("Seitenwechesl_1") ? "Seitenwechesl_2" : "Seitenwechesl_1";
        this.LSJATemp = this.LSJA;
        if (this.mChurchTaxSplit) {
            this.setChurchTaxExpressions();
        }
        this.mSubreportCollectionTemp.clear();
        this.mSubreportCollectionTemp.addAll(this.mSubreportCollection);
    }

    private void setChurchTaxExpressions() {
        EmployeeChurchTaxExpression[] employeeChurchTaxExpression = ChurchTaxExpression.getFederalChurchtaxExpression((int)this.mEWT.getEmployerFstateregionKey());
        block9: for (int i = 0; i < employeeChurchTaxExpression.length; ++i) {
            switch (i) {
                case 0: {
                    this.church_1_short_text = employeeChurchTaxExpression[i].getTextShort();
                    this.church_1_long_text = employeeChurchTaxExpression[i].getText();
                    this.church_1_value = ReportHelper.toCurrencyFormat((Object)this.church_1_summ);
                    continue block9;
                }
                case 1: {
                    this.church_2_short_text = employeeChurchTaxExpression[i].getTextShort();
                    this.church_2_long_text = employeeChurchTaxExpression[i].getText();
                    this.church_2_value = ReportHelper.toCurrencyFormat((Object)this.church_2_summ);
                    continue block9;
                }
                case 2: {
                    this.church_3_short_text = employeeChurchTaxExpression[i].getTextShort();
                    this.church_3_long_text = employeeChurchTaxExpression[i].getText();
                    this.church_3_value = ReportHelper.toCurrencyFormat((Object)this.church_3_summ);
                    continue block9;
                }
                case 3: {
                    this.church_4_short_text = employeeChurchTaxExpression[i].getTextShort();
                    this.church_4_long_text = employeeChurchTaxExpression[i].getText();
                    this.church_4_value = ReportHelper.toCurrencyFormat((Object)this.church_4_summ);
                    continue block9;
                }
                case 4: {
                    this.church_5_short_text = employeeChurchTaxExpression[i].getTextShort();
                    this.church_5_long_text = employeeChurchTaxExpression[i].getText();
                    this.church_5_value = ReportHelper.toCurrencyFormat((Object)this.church_5_summ);
                    this.mSecondChurchTaxFooter = true;
                    continue block9;
                }
                case 5: {
                    this.church_6_short_text = employeeChurchTaxExpression[i].getTextShort();
                    this.church_6_long_text = employeeChurchTaxExpression[i].getText();
                    this.church_6_value = ReportHelper.toCurrencyFormat((Object)this.church_6_summ);
                    continue block9;
                }
                case 6: {
                    this.church_7_short_text = employeeChurchTaxExpression[i].getTextShort();
                    this.church_7_long_text = employeeChurchTaxExpression[i].getText();
                    this.church_7_value = ReportHelper.toCurrencyFormat((Object)this.church_7_summ);
                }
            }
        }
    }

    protected void setErrorEmployeersList(String oidPCompany) {
        List employerLi = this.mErrorReportFactory.getReportErrorLi();
        if (employerLi != null && !employerLi.isEmpty()) {
            int[] intArray = new int[]{0, 1, 2, 4};
            Collections.sort(employerLi, new ReporBeanSortComparator(intArray, null));
            ErrorReportBean errorReportBean = new ErrorReportBean(DateMapper.toYYYYString((Date)this.mForValidDate), ReportHelper.getMonthDescription((int)new VDate(this.mListEndDate).getMonth()), "", this.FIELD_pcompany_plant_key + " / " + this.FIELD_arbeitgeber_bezeichnung, "Euro", DateMapper.toDDMMYYYYPointSeparationString((Date)new Date()), this.mUserString, "World Edition (" + this.mVersion + ")", this.mErrorReportDescription, this.mStaticText_internalUse, error_1, error_2, error_3, error_4, this.error_5, this.mErrorEmployeeSubJasperReport, employerLi);
            this.mWageTaxErrorLi.add(errorReportBean);
        }
    }

    protected void setErrorEmployeersList() {
        List employerLi = this.mErrorReportFactory.getReportErrorLi();
        if (employerLi != null && !employerLi.isEmpty()) {
            int[] intArray = new int[]{0, 1, 2, 4};
            Collections.sort(employerLi, new ReporBeanSortComparator(intArray, null));
            ErrorReportBean errorReportBean = new ErrorReportBean(DateMapper.toYYYYString((Date)this.mForValidDate), ReportHelper.getMonthDescription((int)new VDate(this.mListEndDate).getMonth()), "", this.FIELD_pcompany_plant_key + " / " + this.FIELD_arbeitgeber_bezeichnung, "Euro", DateMapper.toDDMMYYYYPointSeparationString((Date)new Date()), this.mUserString, "World Edition (" + this.mVersion + ")", this.mErrorReportDescription, this.mStaticText_internalUse, error_1, error_2, error_3, error_4, this.error_5, this.mErrorEmployeeSubJasperReport, employerLi);
            this.mWageTaxErrorLi.add(errorReportBean);
        }
    }

    protected void resetDataSumme() {
        this.mSubreportCollection.clear();
        this.summe_lst_lfd = BigDecimal.ZERO;
        this.summe_lst_son = BigDecimal.ZERO;
        this.summe_lst_pau = BigDecimal.ZERO;
        this.summe_lst_zwi_su = BigDecimal.ZERO;
        this.summe_soli_lfd = BigDecimal.ZERO;
        this.summe_soli_son = BigDecimal.ZERO;
        this.summe_soli_pau = BigDecimal.ZERO;
        this.summe_soli_zwi_su = BigDecimal.ZERO;
        this.summe_kist_lfd = BigDecimal.ZERO;
        this.summe_kist_son = BigDecimal.ZERO;
        this.summe_kist_pau = BigDecimal.ZERO;
        this.summe_kist_pau_ver = BigDecimal.ZERO;
        this.summe_kist_zwi_su = BigDecimal.ZERO;
        this.summe_ak = BigDecimal.ZERO;
        this.summe_kindergeld = BigDecimal.ZERO;
        this.summe_foederbetrag_bav = BigDecimal.ZERO;
        this.summe_summe_an = BigDecimal.ZERO;
        this.summe_lja_lst = BigDecimal.ZERO;
        this.summe_lja_soli = BigDecimal.ZERO;
        this.summe_lja_kist = BigDecimal.ZERO;
        this.summe_summe_lja = BigDecimal.ZERO;
        this.summe_ergebnis_lst = BigDecimal.ZERO;
        this.summe_ergebnis_soli = BigDecimal.ZERO;
        this.summe_ergebnis_kist = BigDecimal.ZERO;
        this.summe_summe_ergebnis = BigDecimal.ZERO;
        this.church_1_summ = BigDecimal.ZERO;
        this.church_2_summ = BigDecimal.ZERO;
        this.church_3_summ = BigDecimal.ZERO;
        this.church_4_summ = BigDecimal.ZERO;
        this.church_5_summ = BigDecimal.ZERO;
        this.church_6_summ = BigDecimal.ZERO;
        this.church_7_summ = BigDecimal.ZERO;
        this.LSJA = false;
        this.mSecondChurchTaxFooter = false;
        this.summe_kg_groesseres_feld = false;
    }

    protected boolean getHasNext() {
        return this.mEmployeeWageTaxEFRit != null && (this.mEmployeeWageTaxEFRit.hasNext() || this.mEWTNext != null);
    }

    protected boolean isChangeBetweenBeans() {
        if (this.mEWTNext == null) {
            this.setErrorEmployeersList(this.mEWT.getEmployerOid());
            return true;
        }
        return !StringMapper.equal((String)(this.mEWT.getEmployerOid() + this.mEWT.getEmployerTaxNumber()), (String)(this.mEWTNext.getEmployerOid() + this.mEWTNext.getEmployerTaxNumber()));
    }

    public boolean next() throws JRException {
        this.resetDataSumme();
        try {
            while (this.getHasNext()) {
                this.mEWT = this.mEWTNext;
                this.mEWTNext = null;
                this.getFirstNext();
                boolean leaveNaxt = this.isChangeBetweenBeans();
                if (leaveNaxt) {
                    this.buildCollection();
                    this.addSumme(this.mEWT.getEmployeeStartDate());
                    this.setHeaderValues();
                    return true;
                }
                this.buildCollection();
                this.addSumme(this.mEWT.getEmployeeStartDate());
            }
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        return false;
    }

    protected boolean areFieldsValuesZero(WageTaxEmployeeBean eWT) {
        BigDecimal bDzero = BigDecimal.ZERO;
        if (eWT.getEmployeeTaxacation() == 5) {
            return false;
        }
        return eWT.getLst_lfd().equals(bDzero) && eWT.getLst_pau().equals(bDzero) && eWT.getLst_son().equals(bDzero) && eWT.getErst_lst_zwi_su().equals(bDzero) && eWT.getSoli_lfd().equals(bDzero) && eWT.getSoli_pau().equals(bDzero) && eWT.getSoli_son().equals(bDzero) && eWT.getErst_soli_zwi_su().equals(bDzero) && eWT.getKist_lfd().equals(bDzero) && eWT.getKist_pau().equals(bDzero) && eWT.getKist_son().equals(bDzero) && eWT.getSt_pfl().equals(bDzero) && eWT.getPausch_brutto().equals(bDzero) && eWT.getAk().equals(bDzero) && eWT.getKist_pau_ver_bis_2006_ev().equals(bDzero) && eWT.getKist_pau_ver_bis_2006_rk().equals(bDzero) && eWT.getKist_lfd_an().equals(bDzero) && eWT.getKist_pau_an().equals(bDzero) && eWT.getKist_son_an().equals(bDzero) && eWT.getErst_kist_zwi_su_an().equals(bDzero) && eWT.getKist_lfd_eg().equals(bDzero) && eWT.getKist_pau_eg().equals(bDzero) && eWT.getKist_son_eg().equals(bDzero) && eWT.getErst_kist_zwi_su_eg().equals(bDzero) && eWT.getKindergeld().equals(bDzero) && eWT.getEnergiepreispauschale().equals(bDzero) && eWT.getFIELD_foerderbetragBAV().equals(bDzero);
    }

    private String setLStJAUnterzahlungLSt() {
        if (!this.mEWT.isEmployeeLStJAUnterzahlungInfoLSt()) {
            return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_lst_zwi_su());
        }
        return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_lst_informativ());
    }

    private String setLStJAUnterzahlungSoli() {
        if (!this.mEWT.isEmployeeLStJAUnterzahlungInfoSoli()) {
            return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_soli_zwi_su());
        }
        return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_soli_informativ());
    }

    private String setLStJAUnterzahlungKist() {
        if (!this.mEWT.isEmployeeLStJAUnterzahlungInfoKist()) {
            return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_zwi_su());
        }
        return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_informativ());
    }

    private String setLStJAUnterzahlungANKist() {
        if (!this.mEWT.isEmployeeLStJAUnterzahlungInfoKist()) {
            return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_zwi_su_an());
        }
        return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_informativ_an());
    }

    private String setLStJAUnterzahlungEGKist() {
        if (!this.mEWT.isEmployeeLStJAUnterzahlungInfoKist()) {
            return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_zwi_su_eg());
        }
        return ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_informativ_eg());
    }

    private void buildCollection() {
        Date dateOfWithDrawal;
        Object monat_jahr = "";
        if (!StringMapper.equal((String)this.mEWT.getStatus(), (String)"z")) {
            monat_jahr = ReportHelper.getMonthDescription((int)new VDate(this.mEWT.getEmployeeStartDate()).getMonth()) + " / " + Integer.toString(new VDate(this.mEWT.getEmployeeStartDate()).getYear());
        }
        Object bez_monat = "";
        if (this.mEWT.getAndruckMonat()) {
            bez_monat = ReportHelper.getMonthDescription((int)new VDate(this.mEWT.getValidDate()).getMonth()) + " / " + Integer.toString(new VDate(this.mEWT.getValidDate()).getYear());
        }
        String text_LStJA = "";
        boolean employeeWithLStJAValues = false;
        String erstLStJAInforVerrechnungLSt = "";
        String erstLStJAInforVerrechnungSoli = "";
        String erstLStJAInforVerrechnungKist = "";
        String erstLStJAInforVerrechnungKist_an = "";
        String erstLStJAInforVerrechnungKist_eg = "";
        if (new VDate(this.mEWT.getEmployeeStartDate()).getMonth() == 11) {
            boolean lstJAValues = false;
            lstJAValues = BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_lst_zwi_su()) ? lstJAValues : true;
            lstJAValues = BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_lst_zwi_su()) ? lstJAValues : true;
            boolean bl = lstJAValues = BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_lst_zwi_su()) ? lstJAValues : true;
            if (this.mEWT.getEmployerLStJA() || !lstJAValues) {
                if (this.mEWT.getEmployeeLStJA() || !lstJAValues) {
                    if (this.mEWT.getEmployeeLStJA_asschluss() != 0) {
                        switch (this.mEWT.getEmployeeLStJA_asschluss()) {
                            case 1: {
                                text_LStJA = "Lohnersatzleistung: Kein LStJA";
                                break;
                            }
                            case 2: {
                                text_LStJA = "Anzahl \"U\": Kein LStJA";
                                break;
                            }
                            case 3: {
                                text_LStJA = "Vorsorgepauschale: Kein LStJA";
                                break;
                            }
                            case 4: {
                                text_LStJA = "Ausl\u00e4ndische Eink\u00fcnfte: Kein LStJA";
                                break;
                            }
                            case 5: {
                                text_LStJA = "Aufstockungsbetr\u00e4ge nach dem Altersteilzeitgesetz: Kein LStJA";
                                break;
                            }
                            case 6: {
                                text_LStJA = "Kein st\u00e4ndiges Dienstverh\u00e4ltnis im Kalenderjahr: Kein LStJA";
                                break;
                            }
                            case 7: {
                                text_LStJA = "Steuerklassenwechsel: Kein LStJA";
                            }
                        }
                    } else if (!(BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_lst_zwi_su()) && BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_soli_zwi_su()) && BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_kist_zwi_su()) && BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_lst_informativ()) && BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_soli_informativ()) && BigDecimalMapper.isZero((BigDecimal)this.mEWT.getErst_soli_informativ()))) {
                        this.LSJA = true;
                        employeeWithLStJAValues = true;
                        BigDecimal bLStJA = this.mEWT.getErst_lst_zwi_su().add(this.mEWT.getErst_soli_zwi_su()).add(this.mEWT.getErst_kist_zwi_su());
                        if (!BigDecimalMapper.isZero((BigDecimal)bLStJA)) {
                            if (BigDecimalMapper.compareTo((BigDecimal)BigDecimal.ZERO, (BigDecimal)bLStJA) > 0) {
                                text_LStJA = "LStJA-Erstattung";
                                erstLStJAInforVerrechnungLSt = ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_lst_zwi_su());
                                erstLStJAInforVerrechnungSoli = ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_soli_zwi_su());
                                erstLStJAInforVerrechnungKist = ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_zwi_su());
                                erstLStJAInforVerrechnungKist_an = ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_zwi_su_an());
                                erstLStJAInforVerrechnungKist_eg = ReportHelper.toCurrencyFormat((Object)this.mEWT.getErst_kist_zwi_su_eg());
                            }
                            if (BigDecimalMapper.compareTo((BigDecimal)BigDecimal.ZERO, (BigDecimal)bLStJA) < 0) {
                                text_LStJA = "LStJA-Unterzahlung verrechnet";
                                erstLStJAInforVerrechnungLSt = this.setLStJAUnterzahlungLSt();
                                erstLStJAInforVerrechnungSoli = this.setLStJAUnterzahlungSoli();
                                erstLStJAInforVerrechnungKist = this.setLStJAUnterzahlungKist();
                                erstLStJAInforVerrechnungKist_an = this.setLStJAUnterzahlungANKist();
                                erstLStJAInforVerrechnungKist_eg = this.setLStJAUnterzahlungEGKist();
                            }
                        } else {
                            text_LStJA = "LStJA-Unterzahlung info";
                            erstLStJAInforVerrechnungLSt = this.setLStJAUnterzahlungLSt();
                            erstLStJAInforVerrechnungSoli = this.setLStJAUnterzahlungSoli();
                            erstLStJAInforVerrechnungKist = this.setLStJAUnterzahlungKist();
                            erstLStJAInforVerrechnungKist_an = this.setLStJAUnterzahlungANKist();
                            erstLStJAInforVerrechnungKist_eg = this.setLStJAUnterzahlungEGKist();
                        }
                    } else {
                        text_LStJA = "LStJA f\u00fcr den Mitarbeiter nicht erforderlich";
                    }
                } else {
                    text_LStJA = "Mitarbeiter: Kein LStJA gesetzt";
                }
            } else {
                text_LStJA = "Firma/Betriebsst\u00e4tte: Kein LStJA durch AG";
            }
        }
        BigDecimal lstZwichenSumme = this.mEWT.getLst_lfd().add(this.mEWT.getLst_pau()).add(this.mEWT.getLst_son());
        BigDecimal soliZwichenSumme = this.mEWT.getSoli_lfd().add(this.mEWT.getSoli_pau()).add(this.mEWT.getSoli_son());
        BigDecimal kistZwichenSumme = this.mEWT.getKist_lfd().add(this.mEWT.getKist_pau()).add(this.mEWT.getKist_son());
        BigDecimal kistZwichenSummeAN = this.mEWT.getKist_lfd_an().add(this.mEWT.getKist_pau_an()).add(this.mEWT.getKist_son_an());
        BigDecimal kistZwichenSummeEG = this.mEWT.getKist_lfd_eg().add(this.mEWT.getKist_pau_eg()).add(this.mEWT.getKist_son_eg());
        BigDecimal lstSoliKistSumme = lstZwichenSumme.add(soliZwichenSumme).add(kistZwichenSumme).add(this.mEWT.getAk()).subtract(this.mEWT.getKindergeld()).subtract(this.mEWT.getFoederbetrag_bav()).subtract(this.mEWT.getEnergiepreispauschale());
        BigDecimal erstattungenSumme = this.mEWT.getErst_lst_zwi_su().add(this.mEWT.getErst_soli_zwi_su()).add(this.mEWT.getErst_kist_zwi_su());
        Date date = dateOfWithDrawal = this.mEWT.getDateOfWithDrawal() != null ? this.mEWT.getDateOfWithDrawal() : this.mEWT.getValidDate();
        if (DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)this.mEWT.getValidDate()), (Date)dateOfWithDrawal) || !BigDecimalMapper.isZeroOrNull((BigDecimal)lstSoliKistSumme)) {
            WageTaxPerEmployeeReportBean wageTaxPerEmployeeReportBean = new WageTaxPerEmployeeReportBean((String)bez_monat, (String)monat_jahr, this.mEWT.getStatus().equals("z") ? "" : this.mEWT.getStatus(), this.mEWT.getSurname() + ", " + this.mEWT.getFirstname(), ReportHelper.removeZeroFromLeft((String)this.mEWT.getPersonnelNumber()), text_LStJA, ReportHelper.toCurrencyFormat((Object)this.mEWT.getLst_lfd()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getLst_pau()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getLst_son()), ReportHelper.toCurrencyFormat((Object)lstZwichenSumme), ReportHelper.toCurrencyFormat((Object)this.mEWT.getSoli_lfd()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getSoli_pau()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getSoli_son()), ReportHelper.toCurrencyFormat((Object)soliZwichenSumme), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_lfd()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_son()), ReportHelper.toCurrencyFormat((Object)kistZwichenSumme), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_lfd_an()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_an()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_son_an()), ReportHelper.toCurrencyFormat((Object)kistZwichenSummeAN), this.mEWT.getKist_an(), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_lfd_eg()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_eg()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_son_eg()), ReportHelper.toCurrencyFormat((Object)kistZwichenSummeEG), this.mEWT.getKist_eg(), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_ver()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_ver_bis_2006_rk()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_ver_bis_2006_ev()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getSt_pfl()), ReportHelper.toCurrencyFormat((Object)lstSoliKistSumme), erstLStJAInforVerrechnungLSt, erstLStJAInforVerrechnungSoli, erstLStJAInforVerrechnungKist, erstLStJAInforVerrechnungKist_an, erstLStJAInforVerrechnungKist_eg, employeeWithLStJAValues ? ReportHelper.toCurrencyFormat((Object)erstattungenSumme) : "", ReportHelper.toCurrencyFormat((Object)this.mEWT.getPausch_brutto()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getAk()), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKindergeld().add(this.mEWT.getEnergiepreispauschale())), ReportHelper.toCurrencyFormat((Object)this.mEWT.getFoederbetrag_bav()));
            if (this.mChurchTaxSplit) {
                LinkedList<WTPerEmployeeSplitChurchTaxtLfdSBZSubReportBean> wTPESplitChurchTaxSubreportLi = new LinkedList<WTPerEmployeeSplitChurchTaxtLfdSBZSubReportBean>();
                if (!StringMapper.isNullString((String)this.mEWT.getKist_an())) {
                    wTPESplitChurchTaxSubreportLi.add(this.getWTPEChurchTaxSplitSubReportBean(ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_lfd_an()), this.mEWT.getKist_an(), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_son_an())));
                }
                if (!StringMapper.isNullString((String)this.mEWT.getKist_eg())) {
                    wTPESplitChurchTaxSubreportLi.add(this.getWTPEChurchTaxSplitSubReportBean(ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_lfd_eg()), this.mEWT.getKist_eg(), ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_son_eg())));
                }
                if (wTPESplitChurchTaxSubreportLi.isEmpty()) {
                    wTPESplitChurchTaxSubreportLi.add(this.getWTPEChurchTaxSplitSubReportBean("0,00", "", "0,00"));
                }
                wageTaxPerEmployeeReportBean.setgetWTPerEmployeeChurchTaxSplitLfDSBZSubreportCollection(wTPESplitChurchTaxSubreportLi);
                LinkedList<WTPerEmployeeSplitChurchTaxPauschSubReportBean> wTPESplitChurchTaxPauschSubreportLi = new LinkedList<WTPerEmployeeSplitChurchTaxPauschSubReportBean>();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEWT.getKist_pau_ver_bis_2006_ev())) {
                    wTPESplitChurchTaxPauschSubreportLi.add(new WTPerEmployeeSplitChurchTaxPauschSubReportBean(ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_ver_bis_2006_ev()) + " ev *3"));
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEWT.getKist_pau_ver_bis_2006_rk())) {
                    wTPESplitChurchTaxPauschSubreportLi.add(new WTPerEmployeeSplitChurchTaxPauschSubReportBean(ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_ver_bis_2006_rk()) + " rk *3"));
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEWT.getKist_pau_an())) {
                    wTPESplitChurchTaxPauschSubreportLi.add(new WTPerEmployeeSplitChurchTaxPauschSubReportBean(ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_an()) + " " + this.mEWT.getKist_an()));
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEWT.getKist_pau_eg())) {
                    wTPESplitChurchTaxPauschSubreportLi.add(new WTPerEmployeeSplitChurchTaxPauschSubReportBean(ReportHelper.toCurrencyFormat((Object)this.mEWT.getKist_pau_eg()) + " " + this.mEWT.getKist_eg()));
                }
                if (wTPESplitChurchTaxPauschSubreportLi.isEmpty()) {
                    WTPerEmployeeSplitChurchTaxPauschSubReportBean wTPESChurchTaxPauschSubReportBean = new WTPerEmployeeSplitChurchTaxPauschSubReportBean("0,00");
                    switch (wTPESplitChurchTaxSubreportLi.size()) {
                        case 1: {
                            wTPESplitChurchTaxPauschSubreportLi.add(wTPESChurchTaxPauschSubReportBean);
                            break;
                        }
                        case 2: {
                            wTPESplitChurchTaxPauschSubreportLi.add(wTPESChurchTaxPauschSubReportBean);
                            wTPESplitChurchTaxPauschSubreportLi.add(wTPESChurchTaxPauschSubReportBean);
                        }
                    }
                }
                wageTaxPerEmployeeReportBean.setWTPerEmployeeSplitChurchTaxPauschSubreportCollection(wTPESplitChurchTaxPauschSubreportLi);
                LinkedList<WTPerEmployeeSplitChurchTaxPauschSubReportBean> wTPESplitChurchTaxKiStColumnSubreportLi = new LinkedList<WTPerEmployeeSplitChurchTaxPauschSubReportBean>();
                wTPESplitChurchTaxKiStColumnSubreportLi.add(new WTPerEmployeeSplitChurchTaxPauschSubReportBean(ReportHelper.toCurrencyFormat((Object)kistZwichenSumme)));
                if (!StringMapper.isNullString((String)erstLStJAInforVerrechnungKist_an)) {
                    wTPESplitChurchTaxKiStColumnSubreportLi.add(new WTPerEmployeeSplitChurchTaxPauschSubReportBean(erstLStJAInforVerrechnungKist_an + " " + this.mEWT.getKist_an()));
                }
                if (!StringMapper.isNullString((String)erstLStJAInforVerrechnungKist_eg)) {
                    wTPESplitChurchTaxKiStColumnSubreportLi.add(new WTPerEmployeeSplitChurchTaxPauschSubReportBean(erstLStJAInforVerrechnungKist_eg + " " + this.mEWT.getKist_eg()));
                }
                wageTaxPerEmployeeReportBean.setWTPerEmployeeSplitChurchTaxKiStColumnSubreportCollection(wTPESplitChurchTaxKiStColumnSubreportLi);
            }
            this.mSubreportCollection.add(wageTaxPerEmployeeReportBean);
        }
    }

    private WTPerEmployeeSplitChurchTaxtLfdSBZSubReportBean getWTPEChurchTaxSplitSubReportBean(String kistLfd, String kistDescribtion, String kistSBZ) {
        return new WTPerEmployeeSplitChurchTaxtLfdSBZSubReportBean(kistLfd, kistDescribtion, kistSBZ);
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put("Parameter_User", this.mUserString);
        parameters.put("parameterStaticText_ReportTitle", this.mParameter_ReportTitle_value);
        parameters.put("parameterStaticText_CompanyTitle", this.mParameterStaticText_CompanyTitle_value);
        parameters.put("parameterStaticText_CurrencyTitle", this.mParameterStaticText_CurrencyTitle);
        parameters.put("parameterStaticText_UserTitle", this.mParameterStaticText_UserTitle);
        parameters.put("parameterStaticText_DateTitle", this.mParameterStaticText_DateTitle);
        parameters.put("parameterStaticText_PageTitle", this.mParameterStaticText_PageTitle);
        parameters.put("parameterStaticText_PersonnelNumber", this.mParameterStaticText_PersonnelNumber);
        parameters.put("parameterStaticText_NameSurname", this.mParameterStaticText_NameSurname);
        parameters.put("parameterStaticText_StPflBrutto", this.mParameterStaticText_StPflBrutto);
        parameters.put("parameterStaticText_PauschBrutto", this.mParameterStaticText_PauschBrutto);
        parameters.put("parameterStaticText_LstLfd", this.mParameterStaticText_LstLfd);
        parameters.put("parameterStaticText_LstSbz", this.mParameterStaticText_LstSbz);
        parameters.put("parameterStaticText_LstPausch", this.mParameterStaticText_LstPausch);
        parameters.put("parameterStaticText_Lst", this.mParameterStaticText_Lst);
        parameters.put("parameterStaticText_SolzLfd", this.mParameterStaticText_SolzLfd);
        parameters.put("parameterStaticText_SolzSbz", this.mParameterStaticText_SolzSbz);
        parameters.put("parameterStaticText_SolzPausch", this.mParameterStaticText_SolzPausch);
        parameters.put("parameterStaticText_Solz", this.mParameterStaticText_Solz);
        parameters.put("parameterStaticText_KistSbz", this.mParameterStaticText_KistLfd);
        parameters.put("parameterStaticText_KistSbz", this.mParameterStaticText_KistSbz);
        parameters.put("parameterStaticText_KistPausch", this.mParameterStaticText_KistPausch);
        parameters.put("parameterStaticText_LstPausch", this.mParameterStaticText_Kist);
        parameters.put("parameterStaticText_LstPausch", this.mParameterStaticText_Summ);
        parameters.put("internalUse", this.mStaticText_internalUse);
        parameters.put("subreport_errorReport", this.mErrorEmployeeSubJasperReport);
        parameters.put("parameterStaticText_KiGeld", this.mParameterStaticText_KiGeld);
        return parameters;
    }

    private void initParameters() {
        this.mParameter_ReportTitle_value = "Einzelliste Lohnsteueranmeldung";
        this.mParameterStaticText_CompanyTitle_value = "Firma";
        this.mParameterStaticText_CurrencyTitle = "W\u00e4hrung";
        this.mParameterStaticText_DateTitle = "Datum";
        this.mParameterStaticText_UserTitle = "Benutzer";
        this.mParameterStaticText_PageTitle = "Seite";
        this.mParameterStaticText_PersonnelNumber = "Pers-Nr.";
        this.mParameterStaticText_NameSurname = "Name, Vorname";
        this.mParameterStaticText_StPflBrutto = "St.pfl-Brutto";
        this.mParameterStaticText_PauschBrutto = "Pausch.-Brutto";
        this.mParameterStaticText_LstLfd = "LSt-lfd";
        this.mParameterStaticText_LstSbz = "LSt-SBZ";
        this.mParameterStaticText_LstPausch = "LSt-pausch";
        this.mParameterStaticText_Lst = "* LSt";
        this.mParameterStaticText_SolzLfd = "Solz-lfd";
        this.mParameterStaticText_SolzSbz = "SolZ-SBZ";
        this.mParameterStaticText_SolzPausch = "SolZ-pausch";
        this.mParameterStaticText_Solz = "* SolZ";
        this.mParameterStaticText_KistLfd = "KiSt-lfd";
        this.mParameterStaticText_KistSbz = "KiSt-SBZ";
        this.mParameterStaticText_KistPausch = "KiSt-pausch";
        this.mParameterStaticText_Kist = "* KiSt";
        this.mParameterStaticText_Summ = "Summe";
        this.mStaticText_internalUse = this.mInternalUse ? "Interner Gebrauch" : "";
        this.mParameterStaticText_KiGeld = this.mIsEPPMonat && DateHelper.afterOrEqual((Date)this.mForEffectiveDate, (Date)new VDate(2022, 6, 1).getDate()) && DateHelper.beforeOrEqual((Date)this.mForEffectiveDate, (Date)new VDate(2023, 0, 31).getDate()) ? "KG/EPP" : "Ki-Geld";
    }

    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        if (fieldName.equals("subreport_bean")) {
            return this.mSubreportCollectionTemp;
        }
        if (fieldName.equals("seitenwechsel")) {
            return this.FIELD_seitenwechsel;
        }
        if (fieldName.equals("version")) {
            return this.mVersion;
        }
        if (fieldName.equals("jahr")) {
            return this.FIELD_jahr + this.FIELD_jahr_zusatz;
        }
        if (fieldName.equals("monat_bez")) {
            return this.mEWT.getAnmeldezeitraumMonatBez();
        }
        if (fieldName.equals("steuernummer")) {
            return this.FIELD_steuernummer;
        }
        if (fieldName.equals("finanzamt_bezeichnung")) {
            return this.FIELD_finanzamt_bezeichnung;
        }
        if (fieldName.equals("finanzamt_nr")) {
            return this.FIELD_finanzamt_nr;
        }
        if (fieldName.equals("employer_longdescription")) {
            return this.FIELD_arbeitgeber_bezeichnung;
        }
        if (fieldName.equals("employer_key")) {
            return this.FIELD_pcompany_plant_key;
        }
        if (fieldName.equals("summe_an_st")) {
            return ReportHelper.toCurrencyFormat((Object)this.FIELD_summe_an_st);
        }
        if (fieldName.equals("summe_erst")) {
            return ReportHelper.toCurrencyFormat((Object)this.FIELD_summe_erst);
        }
        if (this.LSJATemp) {
            if (fieldName.equals("text_summe_lstja")) {
                return "Summen LStJA";
            }
            if (fieldName.equals("text_ergebnis_nach_lstja")) {
                return "Gesamtsummen";
            }
            if (fieldName.equals("summe_lja_lst")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_lja_lst);
            }
            if (fieldName.equals("summe_lja_soli")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_lja_soli);
            }
            if (fieldName.equals("summe_lja_kist")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_lja_kist);
            }
            if (fieldName.equals("summe_summe_lja")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_summe_lja);
            }
            if (fieldName.equals("summe_ergebnis_lst")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_ergebnis_lst);
            }
            if (fieldName.equals("summe_ergebnis_soli")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_ergebnis_soli);
            }
            if (fieldName.equals("summe_ergebnis_kist")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_ergebnis_kist);
            }
            if (fieldName.equals("summe_summe_ergebnis")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_summe_ergebnis);
            }
        }
        if (fieldName.equals("summe_lst_lfd")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_lst_lfd);
        }
        if (fieldName.equals("summe_lst_pau")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_lst_pau);
        }
        if (fieldName.equals("summe_lst_son")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_lst_son);
        }
        if (fieldName.equals("summe_lst_zwi_su")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_lst_zwi_su);
        }
        if (fieldName.equals("summe_soli_lfd")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_soli_lfd);
        }
        if (fieldName.equals("summe_soli_pau")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_soli_pau);
        }
        if (fieldName.equals("summe_soli_son")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_soli_son);
        }
        if (fieldName.equals("summe_soli_zwi_su")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_soli_zwi_su);
        }
        if (fieldName.equals("summe_kist_lfd")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_kist_lfd);
        }
        if (fieldName.equals("summe_kist_pau")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_kist_pau);
        }
        if (fieldName.equals("summe_kist_son")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_kist_son);
        }
        if (fieldName.equals("summe_kist_zwi_su")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_kist_zwi_su);
        }
        if (fieldName.equals("summe_summe_an")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_summe_an);
        }
        if (fieldName.equals("summe_ak")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_ak);
        }
        if (fieldName.equals("summe_kg")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_kindergeld);
        }
        if (fieldName.equals("summe_bav")) {
            return ReportHelper.toCurrencyFormat((Object)this.summe_foederbetrag_bav);
        }
        if (fieldName.equals("summe_kg_groesseres_feld")) {
            return this.summe_kg_groesseres_feld;
        }
        if (this.mChurchTaxSplit) {
            if (fieldName.equals("summe_kist_pau_ver")) {
                return ReportHelper.toCurrencyFormat((Object)this.summe_kist_pau_ver);
            }
            if (fieldName.equals("secondChurchTaxFooter")) {
                return this.mSecondChurchTaxFooter;
            }
            if (fieldName.equals("churchTaxSplit")) {
                return this.mChurchTaxSplit;
            }
            if (fieldName.equals("religiosKuerzel")) {
                return "Rel.-K\u00fcrzel";
            }
            if (fieldName.equals("religiosBezeichnung")) {
                return "Religionsbezeichnung, Betrag";
            }
            if (fieldName.equals("religiosBetrag")) {
                return "Betrag";
            }
            if (fieldName.equals("church_1_long_text")) {
                return this.church_1_long_text;
            }
            if (fieldName.equals("church_2_long_text")) {
                return this.church_2_long_text;
            }
            if (fieldName.equals("church_3_long_text")) {
                return this.church_3_long_text;
            }
            if (fieldName.equals("church_4_long_text")) {
                return this.church_4_long_text;
            }
            if (fieldName.equals("church_5_long_text")) {
                return this.church_5_long_text;
            }
            if (fieldName.equals("church_6_long_text")) {
                return this.church_6_long_text;
            }
            if (fieldName.equals("church_7_long_text")) {
                return this.church_7_long_text;
            }
            if (fieldName.equals("church_1_value")) {
                return this.church_1_value;
            }
            if (fieldName.equals("church_2_value")) {
                return this.church_2_value;
            }
            if (fieldName.equals("church_3_value")) {
                return this.church_3_value;
            }
            if (fieldName.equals("church_4_value")) {
                return this.church_4_value;
            }
            if (fieldName.equals("church_5_value")) {
                return this.church_5_value;
            }
            if (fieldName.equals("church_6_value")) {
                return this.church_6_value;
            }
            if (fieldName.equals("church_7_value")) {
                return this.church_7_value;
            }
            if (fieldName.equals("church_1_short_text")) {
                return this.church_1_short_text;
            }
            if (fieldName.equals("church_2_short_text")) {
                return this.church_2_short_text;
            }
            if (fieldName.equals("church_3_short_text")) {
                return this.church_3_short_text;
            }
            if (fieldName.equals("church_4_short_text")) {
                return this.church_4_short_text;
            }
            if (fieldName.equals("church_5_short_text")) {
                return this.church_5_short_text;
            }
            if (fieldName.equals("church_6_short_text")) {
                return this.church_6_short_text;
            }
            if (fieldName.equals("church_7_short_text")) {
                return this.church_7_short_text;
            }
        }
        if (fieldName.equals("subreport_error_employer_bean")) {
            return this.mWageTaxErrorLi;
        }
        return null;
    }

    public Date getForValidDate() {
        return this.mForValidDate;
    }

    public Date getEffectiveDateEPP() {
        return this.mEffectiveDateEPP;
    }

    protected void setException(String message, String details) {
        this.mCallback.setException(new DatabaseExceptionStruct("", message, details));
    }

    protected boolean hasCalculationbasics(String oidEmployee, Date effectiveDate, Date validDate) {
        boolean hasCalculation = false;
        try {
            PersistencyDataSet CalculationbasicDatas = daoCalculationbasic.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate)))}));
            if (CalculationbasicDatas.hasNext()) {
                hasCalculation = true;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return hasCalculation;
    }

    private void addEmployees(List<WageTaxEmployeeBean> wageTaxEmployeesBeanLi) {
        for (WageTaxEmployeeBean bean : wageTaxEmployeesBeanLi) {
            Date dateOfWithDrawal;
            Date date = dateOfWithDrawal = bean.getDateOfWithDrawal() != null ? bean.getDateOfWithDrawal() : bean.getValidDate();
            if (!DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)bean.getValidDate()), (Date)dateOfWithDrawal)) continue;
            List<String> employeeList = this.mEmployeePersonnelNumberHM.get(bean.getEmployerTaxNumber());
            if (employeeList == null) {
                employeeList = new LinkedList<String>();
                employeeList.add(bean.getOidEmployee());
                this.mEmployeePersonnelNumberHM.put(bean.getEmployerTaxNumber(), employeeList);
                continue;
            }
            if (employeeList.contains(bean.getOidEmployee())) continue;
            employeeList.add(bean.getOidEmployee());
        }
    }

    public int getCountEmployeeWageTaxEFRit() {
        return this.mCountEmployeeWageTaxEFRit;
    }
}

